/***************************************************************************
 *
 * knetworkmanager.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <kdebug.h>

#include "knetworkmanager.h"
#include "knetworkmanager-encryption.h"
#include "knetworkmanager-storage.h"
#include "settings.h"
#include "klocale.h"

DeviceStore*
KNetworkManager::getDeviceStore ()
{
	return _store;
}

VPN*
KNetworkManager::getVPN ()
{
	return _vpn;
}


NetworkManagerInfo*
KNetworkManager::getNetworkManagerInfo ()
{
	return _nmi;
}

DBusConnection*
KNetworkManager::getDBus ()
{
	return _dbus;
}

Tray*
KNetworkManager::getTray ()
{
	return _tray;
}

State*
KNetworkManager::getState ()
{
	return _state;
}

KNetworkManager::KNetworkManager () : KUniqueApplication ()
{
	/* Set up D-BUS environment */
	_dbus = new DBusConnection ();
	if (_dbus->push (this) == false)
		QTimer::singleShot (3000, _dbus, SLOT (reconnect ()));

	/* Set up NetworkManagerInfo */
	_nmi = new NetworkManagerInfo ();
	_nmi->push (this);

	/* Set up backend */
	_store = new DeviceStore ( this, "devicestore" );
	_store->push (this);

	/* Set up VPN */
	_vpn = new VPN ( this, "vpnobject" );
	_vpn->push (this);

	/* Set up GUI */
	_tray = new Tray ();
	_tray->push (this);
	_tray->show ();
	setMainWidget (_tray);

	/* Set up state object representing the online/offline state of NM */
	_state = new State ();
	_state->push (this);

	/* Check and enable/disable wireless */
	_state->setWirelessState (KNetworkManagerStorage::getInstance ()->getWireless ());

	/* Check and enable/disable online mode */
	_state->setOfflineMode (KNetworkManagerStorage::getInstance ()->getOfflineMode ());

	/* 
	 * Set up signals and slots
	 *
	 */
	
	connect (_nmi, SIGNAL ( networkUpdated( Network *, bool ) ),
		 KNetworkManagerStorage::getInstance(), SLOT( updateNetwork( Network*, bool ) ) );
	
	connect (_tray, SIGNAL  (configureVPNConnections  (void)),
		 _vpn,  SLOT    (configureVPNConnections  (void)));

	connect (_tray, SIGNAL  (disconnectVPNConnection (void)),
		 _vpn,  SLOT    (disconnectVPNConnection (void)));

	connect (_tray, SIGNAL  (activateVPNConnection (VPNConnection*)),
		 _vpn,  SLOT    (activateVPNConnection (VPNConnection*)));

	connect (_tray,  SIGNAL (activateDialUp (DialUp*)),
		 _store, SLOT   (activateDialUp (DialUp*)));

	connect (_tray,  SIGNAL (deactivateDialUp (DialUp*)),
		 _store, SLOT   (deactivateDialUp (DialUp*)));

	connect (_tray,  SIGNAL (activateDevice (Device*)),
		 _store, SLOT   (activateDevice (Device*)));

	connect (_tray,  SIGNAL (activateNetwork (Network*, Device*)),
		 _store, SLOT   (activateNetwork (Network*, Device*)));

	connect (_state, SIGNAL (connectionStateChanged ()),
		 _tray,  SLOT   (slotStateChanged ()));

	connect (_store, SIGNAL (deviceStoreChanged (DeviceStore*)),
		 _tray,   SLOT  (slotStateChanged ()));

	connect( _store, SIGNAL( carrierOn( Device * ) ), _tray, SLOT( slotLinkUp( Device * ) ) );
	connect( _store, SIGNAL( carrierOff( Device * ) ), _tray, SLOT( slotLinkDown( Device * ) ) );
	connect( _store, SIGNAL( added( Device * ) ), _tray, SLOT( slotDeviceAdded( Device * ) ) );
	connect( _store, SIGNAL( removed( Device * ) ), _tray, SLOT( slotDeviceRemoved( Device * ) ) );

	connect( _state, SIGNAL( sleeping() ), _tray, SLOT( slotNMSleeping() ) );
	connect( _state, SIGNAL( connecting() ), _tray, SLOT( slotNMConnecting() ) );
	connect( _state, SIGNAL( connected() ), _tray, SLOT( slotNMConnected() ) );
	connect( _state, SIGNAL( disconnected() ), _tray, SLOT( slotNMDisconnected() ) );

	connect( _store, SIGNAL( networkFound( Network * ) ), _tray, SLOT( slotNetworkFound( Network * ) ) );
	connect( _store, SIGNAL( networkDisappeared( Network * ) ), _tray, SLOT( slotNetworkDisappeared( Network * ) ) );
	
	/* i18n dummies due to string freeze */
	/* VPN */

	i18n ("VPN Connections");
	i18n ("Configure VPN");
	i18n ("Disconnect VPN");
	i18n ("Connect to") + QString ("$CONNECTION");

	/* different NMStates */
	i18n("NetworkManager is sleeping");
	i18n("NetworkManager is connecting");
	i18n("NetworkManager is disconnecting");
	i18n("NetworkManager is now connected");
	i18n("NetworkManager is now disconnected");
	
	/* common errors */
	i18n("No network devices found");
	i18n("Could not dial in");
	i18n("No networks found");
	i18n("No active network found");
	i18n("No active network devices");
	
	/* dbus dispatcher */
	i18n("NetworkManager has started");
	i18n("NetworkManager was shut down");
	i18n("Lost connection to DBus daemon.");
	i18n("Trying to reconnect");
	i18n("New network device found");
	i18n("Link down");
	i18n("Link up");
	i18n("Network device removed");
	i18n("Network device %1 removed").arg(100);
	i18n("New wireless network found");
	i18n("New wireless network %1 found").arg(100);
	i18n("Wireless network disappeared");
	i18n("Wireless network %1 disappeared").arg(1);
	i18n("Signal strength changed");
	i18n("Signal strength of network %1 changed").arg(100);
	i18n("Signal strength changed to %1%").arg(100);
	i18n("Signal strength of network %1 changed to %2%").arg(100).arg(100);

	i18n("Successfully connected to %1").arg(100);
	i18n("Failed to join network %1").arg(100);

	/* knetworkmanager-state */
	i18n("Switched to offline mode");
	i18n("Switched to online mode");
	i18n("Wireless deactivated");
	i18n("Wireless activated");

	/* errors */
	i18n ("Network connection attempt timed out");
	i18n ("No passphrase given");
	i18n ("New passphrase required");
	i18n ("Too many incorrect passphrases");
	i18n ("Too many connection attempts");
	i18n ("Network is not connected");
	i18n ("Network connection lost");
	
	i18n( "Do you really want to remove network %1?  This will delete any stored passphrases and settings." );
	i18n( "Wired Network" );
	i18n( "Wireless Network" );
	i18n( "Dial-Up Network" );
	
	i18n( "Enter Network Name" );
	i18n( "Enter Access Point Hardware Address" );
}

KNetworkManager::~KNetworkManager()
{
	delete _nmi;
	Settings::writeConfig();
}

#include "knetworkmanager.moc"

