/*
 *   kioskConfigDialog.cpp
 *
 *   Copyright (C) 2004 Waldo Bastian <bastian@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2 as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "kioskConfigDialog.h"

#include <qcheckbox.h>
#include <qtextedit.h>

#include <kapplication.h>
#include <kconfig.h>
#include <kfiledialog.h>
#include <knuminput.h>
#include <klineedit.h>
#include <klocale.h>
#include <kurlrequester.h>

#include "kioskrun.h"

#include "kioskConfigDialog_ui.h"

KioskConfigDialog::KioskConfigDialog(QWidget *parent)
 : KDialogBase(parent, "KioskConfigDialog", true, i18n("Configure Kiosk Admin Tool"),
   KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{
  w = new KioskConfigDialogUI(this);
  w->lineProfilePrefix->setMode(KFile::Directory | KFile::LocalOnly);
  w->lineUpload->setMode(KFile::Directory);

  setMainWidget(w);
  
  init();
  connect(w->lineProfilePrefix, SIGNAL(textChanged( const QString& )), SLOT(updateExample()));
  connect(w->lineUpload, SIGNAL(textChanged( const QString& )), SLOT(updateExample()));
  connect(w->lineUploadPrefix, SIGNAL(textChanged( const QString& )), SLOT(updateExample()));
}

KioskConfigDialog::~KioskConfigDialog()
{
}

void KioskConfigDialog::init()
{
   QString prefix = KioskRun::self()->getProfilePrefix();
   
   if (prefix.isEmpty())
   {
      w->checkProfilePrefix->setChecked(false);
      w->lineProfilePrefix->setURL("/etc/kde-profile/");
   }
   else
   {
      w->checkProfilePrefix->setChecked(true);
      w->lineProfilePrefix->setURL(prefix);
   }
   
   KConfig *config = kapp->config();
   config->setGroup("General");
   
   QString uploadURL = config->readEntry("uploadURL");
   if (uploadURL.isEmpty())
   {
      w->checkUpload->setChecked(false);
      w->lineUpload->setURL("fish://root@host/");
   }
   else
   {
      w->checkUpload->setChecked(true);
      w->lineUpload->setURL(uploadURL);
   }
   w->lineUploadPrefix->setText(config->readEntry("uploadPrefix"));
   
   int minUID = config->readNumEntry("FirstUIDShown", 500);
   if (!minUID)
   {
      w->checkUID->setChecked(false);
      w->numUID->setValue(500);
   }
   else
   {
      w->checkUID->setChecked(true);
      w->numUID->setValue(minUID);
   }
   
   updateExample();   
}

void KioskConfigDialog::updateExample()
{
   QString uploadPrefix = w->lineUploadPrefix->text();
   QString file1 = w->lineProfilePrefix->url()+"default";
   QString file2 = file1;
   if (file2.startsWith(uploadPrefix))
      file2 = file2.mid(uploadPrefix.length());
   if (file2.startsWith("/"))
      file2 = file2.mid(1);
   QString url = w->lineUpload->url();
   if (!url.endsWith("/"))
      url += "/";
   url += file2;
   QString example = QString("<qt><center><b>%1</b><br>--><br><b>%2</b></center>").arg(file1, url);
   w->lblUploadExample->setText(example);
   w->lblUploadExample->setFixedSize(QSize(500,fontMetrics().lineSpacing()*3 + 6));
}

bool KioskConfigDialog::save()
{
   QString uploadURL;
   QString uploadPrefix;
   QString prefix;
   int minUID = 0;
   
   uploadPrefix = w->lineUploadPrefix->text();

   if (w->checkUpload->isChecked())
      uploadURL = w->lineUpload->url();
      
   if (w->checkProfilePrefix->isChecked())
      prefix = w->lineProfilePrefix->url();

   if (w->checkUID->isChecked())
      minUID = w->numUID->value();
   
   KConfig *config = kapp->config();
   config->setGroup("General");
   config->writeEntry("uploadURL", uploadURL);
   config->writeEntry("uploadPrefix", uploadPrefix);
   config->writeEntry("FirstUIDShown", minUID);
   config->sync();
   
   return KioskRun::self()->setProfilePrefix(prefix);
}

#include "kioskConfigDialog.moc"
