#!/bin/sh

usage()
{
	# Title
	echo "Title: MPEG-4 AVI Dual Pass (FFMPEG)"

	# Usable?
	which ffmpeg > /dev/null
	[ $? -eq 0 ] && echo Status: Active || echo Status: Inactive

	# Type
	echo Flags: double-pass file-producer

	# Profiles
	echo "Profile: High Quality (640x480, 2240 kb/s)"
	echo "Profile: Medium Quality (320x240, 1152 kb/s)"
	echo "Profile: Broadband Quality (320x240, 564 kb/s)"
	echo "Profile: Low Quality (160x120, 12fps, 128 kb/s)"
}

execute()
{
	# Arguments
	normalisation="$1"
	length="$2"
	profile="$3"
	file="$4"
	pass="$6"
	
	source "`dirname $0`/ffmpeg_utils.sh"

	# generate filename if missing
	[ "x$file" = "x" ] && file="kino_export_"`date +%Y-%m-%d_%H.%M.%S`
	
	# Determine audio codec (MP3 if avail)
	acodec="mp2"
	mp3=0
	mp3=`ffmpeg -formats 2> /dev/null | egrep "(Encoders:)|(.*E.*mp3)" | grep mp3 | wc -l`
	[ "$mp3" -gt 0 ] && acodec="mp3"

	# Set high quality on second pass
	[ $pass -eq "2" ] && ffmpeg_generate_hq

	# Run the command
	case "$profile" in 
		"0" ) 	ffmpeg -f dv -i pipe: -pass $pass -passlogfile "$file" $hq \
			-vtag DIVX $hq -s 640x480 -aspect 4:3 -b 2048 \
			-acodec "$acodec" -ab 192 -y "$file".avi ;;
		"1" ) 	ffmpeg -f dv -i pipe: -pass $pass -passlogfile "$file" $hq \
			-vtag DIVX $hq -s 320x240 -aspect 4:3 -b 1024 \
			-acodec "$acodec" -ab 128 -y "$file".avi ;;
		"2" ) 	ffmpeg -f dv -i pipe: -pass $pass -passlogfile "$file" $hq \
			-vtag DIVX $hq -s 320x240 -aspect 4:3 -b 500 \
			-acodec "$acodec" -ab 64 -y "$file".avi ;;
		"3" ) 	ffmpeg -f dv -i pipe: -pass $pass -passlogfile "$file" $hq \
			-r 12 -g 36 -vtag DIVX $hq -s 160x120 -aspect 4:3 -b 96 \
			-acodec "$acodec" -ab 32 -y "$file".avi ;;
	esac
	if [ $pass -eq "2" ]; then
		rm -f "$file-0.log"
	fi
}

[ "$1" = "--usage" ] || [ -z "$1" ] && usage "$@" || execute "$@"
