/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

//Own
#include "grubcolorpreview.h"

//Qt
#include <qpainter.h>

//KDE
#include <klocale.h>

GRUBColorPreview::GRUBColorPreview( QWidget *parent ) : QFrame( parent )
{
	clear();

	setAutoFillBackground( true );
}
GRUBColorPreview::GRUBColorPreview( const GRUB::ComplexCommand::Color color, const QVector<GRUB::ConfigFile::Entry> entries, const int highlightedEntry, QWidget *parent ) : QFrame( parent )
{
	clear();
	setColor( color );
	setEntries( entries );
	setHighlightedEntry( highlightedEntry );

	setAutoFillBackground( true );
}

void GRUBColorPreview::paintEvent( QPaintEvent * )
{
	QPainter painter( this );

	if ( !m_color.isEmpty() )
	{
		QFont font;
		font.setRawName( "Courier New" );
		painter.setFont( font );

		//normal background
		setPalette( QColor( m_color.previewOptimisedColor( m_color.normalBackground() ) ) );
		//highlighted background
		if ( m_color.highlightedIsEnabled() )
		{
			painter.setPen( QColor( m_color.previewOptimisedColor( m_color.highlightedBackground() ) ) );
			painter.setBrush( QBrush( QColor( m_color.previewOptimisedColor( m_color.highlightedBackground() ) ) ) );
			painter.drawRect( space * 1.5, ( space + ( space * ( m_highlightedEntry + 1 ) * 2 ) ), width() - ( space * 3 ), ( space * 2 ) );
		}
		else
		{
			painter.setPen( QColor( m_color.previewOptimisedColor( m_color.normalForeground() ) ) );
			painter.setBrush( QBrush( QColor( m_color.previewOptimisedColor( m_color.normalForeground() ) ) ) );
			painter.drawRect( space * 1.5, ( space + ( space * ( m_highlightedEntry + 1 ) * 2 ) ), width() - ( space * 3 ), ( space * 2 ) );
		}

		( m_color.blinkNormal() ? blinkNormal = !blinkNormal : blinkNormal = false );
		( m_color.blinkHighlighted() ? blinkHighlighted = !blinkHighlighted : blinkHighlighted = false );

		if ( blinkNormal == false )
		{
			//normal foreground
			painter.setBrush( Qt::NoBrush );
			painter.setPen( QPen( QBrush( QColor( m_color.previewOptimisedColor( m_color.normalForeground() ) ) ), 3 ) );
			painter.drawRect( space, space * 2, width() - ( space * 2 ), height() - ( space * 4 ) );

			for ( int i = 0; i < m_entries.size(); i++ )
				if ( i != m_highlightedEntry )
					painter.drawText( QPoint( space * 2, space * 2.5 + ( ( space * 2 ) * ( i + 1 ) ) ), m_entries.at( i ).title() );
		}
		if ( blinkHighlighted == false )
		{
			//highlighted foreground
			if ( m_color.highlightedIsEnabled() )
			{
				painter.setPen( QColor( m_color.previewOptimisedColor( m_color.highlightedForeground() ) ) );
				painter.drawText( QPoint( space * 2, space * 2.5 + ( space * ( m_highlightedEntry + 1 ) * 2 ) ), m_entries.at( m_highlightedEntry ).title() );
			}
			else
			{
				painter.setPen( QColor( m_color.previewOptimisedColor( m_color.normalBackground() ) ) );
				painter.drawText( QPoint( space * 2, space * 2.5 + ( space * ( m_highlightedEntry + 1 ) * 2 ) ), m_entries.at( m_highlightedEntry ).title() );
			}
		}
	}
	else
	{
		setPalette( Qt::white );
		painter.drawText( QRect( QPoint( 0, 0 ), QSize( width(), height() ) ), Qt::AlignCenter, i18n( "No preview available." ) );
	}
}

#include "grubcolorpreview.moc"
