/*
    This file is part of KBugBuster.

    Copyright (c) 2003 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/
#ifndef BUGSERVERCONFIG_H
#define BUGSERVERCONFIG_H

#include <qstring.h>
#include <qstringlist.h>

#include <kurl.h>

class KConfig;

class BugServerConfig
{
  public:
    BugServerConfig();
    BugServerConfig( const QString &name, const KURL &baseUrl );
    ~BugServerConfig();

    void setName( const QString &name );
    QString name() const;

    void setBaseUrl( const KURL &url );
    KURL baseUrl() const;

    void setUser( const QString &user );
    QString user() const;
    
    void setPassword( const QString &password );
    QString password() const;

    void readConfig( KConfig *, const QString &name );
    void writeConfig( KConfig * );

    static QStringList bugzillaVersions();

    void setBugzillaVersion( const QString & );
    QString bugzillaVersion() const;

    void setRecentPackages( const QStringList &v ) { mRecentPackages = v; }
    QStringList recentPackages() const { return mRecentPackages; }

    void setCurrentPackage( const QString &v ) { mCurrentPackage = v; }
    QString currentPackage() const { return mCurrentPackage; }

    void setCurrentComponent( const QString &v ) { mCurrentComponent = v; }
    QString currentComponent() const { return mCurrentComponent; }

    void setCurrentBug( const QString &v ) { mCurrentBug = v; }
    QString currentBug() const { return mCurrentBug; }

  private:
    QString mName;
    KURL mBaseUrl;
    QString mUser;
    QString mPassword;

    QString mBugzillaVersion;

    QStringList mRecentPackages;
    QString mCurrentPackage;
    QString mCurrentComponent;
    QString mCurrentBug;
};

#endif

/*
 * vim:sw=4:ts=4:et
 */
