/* This file is part of Rocs,
	 Copyright (C) 2008 by:
	 Tomaz Canabrava <tomaz.canabrava@gmail.com>
	 Ugo Sangiori <ugorox@gmail.com>

	 Rocs is free software; you can redistribute it and/or modify
	 it under the terms of the GNU General Public License as published by
	 the Free Software Foundation; either version 2 of the License, or
	 (at your option) any later version.

	 Rocs is distributed in the hope that it will be useful,
	 but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
	 GNU General Public License for more details.

	 You should have received a copy of the GNU General Public License
	 along with Step; if not, write to the Free Software
	 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA	02110-1301	USA
*/

#include "GraphPropertiesWidget.h"
#include "model_GraphProperties.h"
#include <KDebug>
#include <QGraphicsItem>
#include "DataType.h"
#include "graphDocument.h"
#include "Data.h"
#include "Pointer.h"
#include "MainWindow.h"
#include "NodeItem.h"
#include "OrientedEdgeItem.h"
#include "GraphScene.h"
#include <KLocale>
#include <QRadioButton>
#include <DSPluginManager.h>


GraphPropertiesWidget::GraphPropertiesWidget (DataType *g, MainWindow* parent )
        : KButtonGroup ( parent ) {
    setupUi(this);
    _mainWindow = parent;
    //! do not lock here, it will create a racing condition.

    _graph = g;
    _graphName->setText(_graph->name());
    _graphEdgeColor->setColor(_graph->pointerDefaultColor());
    _graphNodeColor->setColor(_graph->datumDefaultColor());
//     _graphAutomate->setChecked(_graph->automate());
//     _graphOriented->setChecked(_graph->directed());
    _graphVisible->setChecked( ! _graph->readOnly());
    _activateGraph->setChecked(true);
    _showEdgeNames->setChecked( _graph->pointerNameVisibility() );
    _showEdgeValues->setChecked(_graph->pointerValueVisibility());
    _showNodeNames->setChecked( _graph->datumNameVisibility() );
    _showNodeValues->setChecked(_graph->datumValueVisibility());

    _editWidget->setVisible(_activateGraph->isChecked());

    delete _extraProperties->layout();
    
    if (QLayout * lay = Rocs::DSPluginManager::instance()->dataTypeExtraProperties(g, _extraProperties)){
        _extraProperties->setLayout(lay);
    }

    DataTypeDocument *gDocument = qobject_cast<DataTypeDocument*>(g->parent());
    connect(this, SIGNAL(addGraph(QString)), gDocument, SLOT(addDataType(QString)));
    connect(this, SIGNAL(removeGraph()), g, SLOT(remove()));

    connect( _graphEdgeColor, SIGNAL(activated(QColor)), this, SLOT(setPointerDefaultColor(QColor)));
    connect( _graphNodeColor, SIGNAL(activated(QColor)), this, SLOT(setDatumDefaultColor(QColor)));

    connect( this, SIGNAL( pointerColorsChanged(QString)),      g, SLOT(setPointersColor(QString)));
    connect( this, SIGNAL( datumColorsChanged(QString)),      g, SLOT(setDatumsColor(QString)));
    connect( this, SIGNAL( pointerDefaultColorSetted(QString)), g, SLOT(setPointerDefaultColor(QString)));
    connect( this, SIGNAL( datumDefaultColorSetted(QString)), g, SLOT(setDatumDefaultColor(QString)));


    connect( _showEdgeNames,  SIGNAL(toggled(bool)), g, SLOT(setPointerNameVisibility(bool)));
    connect( _showEdgeValues, SIGNAL(toggled(bool)), g, SLOT(setPointerValueVisibility(bool)));
    connect( _showNodeNames,  SIGNAL(toggled(bool)), g, SLOT(setDatumNameVisibility(bool)  ));
    connect( _showNodeValues, SIGNAL(toggled(bool)), g, SLOT(setDatumValueVisibility(bool) ));

    connect( _graphName,      SIGNAL(textChanged(QString)), g, SLOT(setName(QString)));



}

void GraphPropertiesWidget::setPointerDefaultColor(QColor c){    emit pointerDefaultColorSetted(c.name()); }
void GraphPropertiesWidget::setDatumDefaultColor(QColor c){    emit datumDefaultColorSetted(c.name()); }
void GraphPropertiesWidget::on__graphPointerColorApplyNow_clicked() {  emit pointerColorsChanged(_graphEdgeColor->color().name()); }
void GraphPropertiesWidget::on__graphDatumColorApplyNow_clicked() {  emit datumColorsChanged(_graphNodeColor->color().name()); }

void GraphPropertiesWidget::on__graphVisible_toggled(bool b){
  _mainWindow->mutex().lock();
  _graph->setReadOnly( !b );
  _mainWindow->scene()->hideGraph( _graph, b );
  _mainWindow->mutex().unlock();
}

QRadioButton *GraphPropertiesWidget::radio()const {
    return _activateGraph;
}

void GraphPropertiesWidget::on__activateGraph_toggled(bool b) {
    _editWidget->setVisible( b );
    if (b) {
       _mainWindow->setActiveGraph(_graph);
    }
}

void GraphPropertiesWidget::on__graphDelete_clicked() {
    if (! _mainWindow->mutex().tryLock())
        return;
    bool createNewGraph = false;
    bool isActive = false;

    if (_graph == _mainWindow->graph()){
      isActive = true;
    }

    DataTypeDocument *gd = qobject_cast<DataTypeDocument*>(_graph->parent());

    if (gd->size() == 1){
	createNewGraph = true;
    }


    if (isActive) emit updateNeeded();
    radio()->group()->removeButton(radio());
    _mainWindow->mutex().unlock();

        /*! remove this graph from the document. */
    emit removeGraph();

    if (createNewGraph){
	emit addGraph(i18n("Untitled0"));
    }

    deleteLater();
}

void GraphPropertiesWidget::on__graphName_textChanged(const QString& s){
    _activateGraph->setText(s);
}

