/***************************************************************************
                          obexclient.h  -  description
                             -------------------
    begin                : Sat Feb 14 2003
    copyright            : (C) 2003 by Simone Gotti
    email                : simone.gotti@email.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OBEXCLIENT_H
#define OBEXCLIENT_H

#include <qstring.h>
#include <qstringlist.h>
#include <qcstring.h>
#include <qbuffer.h> 

#include <qobex/qobexintransport.h>
#include <qobex/qobexserialtransport.h>
#include <qobex/qobexbfbtransport.h>
#include <qobex/qobexericssontransport.h>

#include <qobex/qobexbttransport.h>


#include <qobex/qobexirdatransport.h>

#include <qobex/qobexclient.h>
#include <qobex/qobexuuid.h>

class Client
  : public QObexClient {
public:
  Client( QObexTransport*, bool);
  
  void response(const QObexObject&) ;
  bool dataReq(QByteArray&, size_t);
  bool data(const QValueList<QByteArray>&);
  void authenticationRequired(const QString&);
    
  QByteArray getData();
  void setData(QByteArray& data);
  
  QValueList<QObexHeader> getHeaders();
 
private:
  bool mVerbose;
  QByteArray mData;
  QBuffer mBuffer;
  QValueList<QObexHeader> mHeaders;
  
  bool mBodyStart;
  
};

#endif
