/***************************************************************************
                          clientmanager.h  -  description
                             -------------------
    begin                : Sat Feb 14 2003
    copyright            : (C) 2003 by Simone Gotti
	
	from the threaded konnector of Mathias Froehlich <Mathias.Froehlich@web.de>
	
    email                : simone.gotti@email.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CLIENTMANAGER_H
#define CLIENTMANAGER_H

#include <qobject.h>
#include <qapplication.h>
#include <qthread.h>
#include <qmutex.h>
#include <qwaitcondition.h>

#include <synceelist.h>

#include "device.h"

class Client;

namespace KSync
{
  class IrMCSyncThreadBase;

	enum SyncType {
	    CalendarSync,
	    AddressBookSync
	};
	/**
	   Client Thread. A QThread for the OBEX client.
	   Note that this QObject is only accessed from the main thread. It is used
	   to report events from the working thread.
	 */
	class ClientManager
				: public QObject/*, public QThread */
	{
		Q_OBJECT
	public:
		/**
		   Constructor with the usual parent handling.
		 */
		ClientManager(SyncType type, const IrMCSyncHelper::Device::Model, QObject* = 0, const char* = 0 );
		/**
		   Destructor, make sure that the thread terminated.
		 */
		~ClientManager();


		void setObexClient(Client*);

		/**
		   Returns if the worker is idel at the monment.
		   Since we have only one manager this lock free access does not introduce
		   a race condition.
		 */
		bool isIdle();

		/**
		   Starts reading the device and computing the synccees.
		   Returns if a backup could be started. If the function returns with true
		   the job is terminated by by either a @ref signalError( const KSync::Error& )
		   or a @ref signalFinished( const KSync::Progress& ).
		 */
		bool readSyncees();
		/**
		   Starts writing the syncees to the device.
		   Returns if a backup could be started. If the function returns with true
		   the job is terminated by by either a @ref signalError( const KSync::Error& )
		   or a @ref signalFinished( const KSync::Progress& ).
		 */
		bool writeSyncees();

		/**
		   Terminates ...
		   FIXME, work out if the usual terminate does a better job ...
		 */
		bool terminateThread();

		/**
		   Sets a flag in the client thread. We hope, that the worker thread
		   regularly reads that flag ...
		 */
		void cancelJob();

	signals:
		/**
		   Is emitted when the thread running has terminated.
		   Then it is save to destroy this class.
		 */
		void signalTerminated();
		
		void signalSynceeReaded( KSync::Syncee* );
		void signalSynceeWrited();

	private:
		/**
		   Worker function of QThread.
		   It runs the requests and posts events.
		 */
		void run();

		/**
		   Called by QObject to report that an event has arrived.
		 */
		void customEvent( QCustomEvent* );

		/**
		   The class where the actual work happens.
		 */
		IrMCSyncThreadBase* mWorker;
	};
}

#endif
