/*
    This file is part of kio_obex.

    Copyright (c) 2003 Mathias Froehlich <Mathias.Froehlich@web.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <qstring.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qspinbox.h>

#include <klocale.h>

#include "ipdevicewidget.h"

IpDeviceWidget::IpDeviceWidget( QWidget* parent, const char* name, WFlags fl )
  : QWidget( parent, name, fl )
{
  int margin = 11;
  int space = 6;

  mLayout = new QGridLayout( this, 2, 2, margin, space, "IpDeviceWidgetLayout"); 
  mHostnameText = new QLabel( this, "IpDeviceWidgetHostnameText" );
  mHostnameText->setText( i18n( "Hostname" ) );
  mLayout->addWidget( mHostnameText, 0, 0 );

  mHostnameInput = new QLineEdit( this, "IpDeviceWidgetHostnameInput" );
  mLayout->addWidget( mHostnameInput, 0, 1 );

  mPortNumberText = new QLabel( this, "IpDeviceWidgetPortNumberText" );
  mPortNumberText->setText( i18n( "Port" ) );
  mLayout->addWidget( mPortNumberText, 1, 0 );
  
  mPortNumberInput = new QSpinBox( this, "IpDeviceWidgetPortNumberInput" );
  mPortNumberInput->setMinValue( 1 );
  mPortNumberInput->setMaxValue( 65535 );
  mPortNumberInput->setValue( 650 );
  mLayout->addWidget( mPortNumberInput, 1, 1 );

  connect( mHostnameInput, SIGNAL(textChanged(const QString&)), SLOT(checkConfiguration()) );
}

IpDeviceWidget::~IpDeviceWidget()
{
}

QString IpDeviceWidget::peer() const
{
  return mHostnameInput->text();
}

int IpDeviceWidget::ipPort() const
{
  return mPortNumberInput->value();
}
  
void IpDeviceWidget::setPeer( const QString& p )
{
  mHostnameInput->setText( p );
}

void IpDeviceWidget::setIpPort( int v )
{
  mPortNumberInput->setValue( v );
}

void IpDeviceWidget::checkConfiguration()
{
  emit configurationReady( !peer().isEmpty() );
}

#include "ipdevicewidget.moc"
