//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "monitortab.h"
#include "kconfig.h"
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <kstandarddirs.h>
#include <kprocess.h>

MonitorTab::MonitorTab(QWidget *parent, QString name) :
    MonitorTabBase(parent, name)
{
    m_config = new KConfig("kbluetoothdrc");

    m_config->setGroup("monitor");
    bool monitorIn = m_config->readBoolEntry("monitorIncomingConnections", true);
    bool monitorOut = m_config->readBoolEntry("monitorOutgoingConnections", true);
    bool persistent = m_config->readBoolEntry("persistentMonitor", true);

    persistentMonitorCheckbox->setChecked(persistent);

    if (monitorIn) {
        if (monitorOut) {
            monitorPolicyGroup->setButton(3);
        }
        else {
            monitorPolicyGroup->setButton(2);
        }
    }
    else {
        if (monitorOut) {
            monitorPolicyGroup->setButton(1);
        }
        else {
            monitorPolicyGroup->setButton(0);
        }
    }

    connect(monitorPolicyGroup, SIGNAL(pressed(int)),
        this, SIGNAL(dirty()));
    connect(monitorPolicyGroup, SIGNAL(clicked(int)),
        this, SIGNAL(dirty()));
    connect(persistentMonitorCheckbox, SIGNAL(toggled(bool)),
        this, SIGNAL(dirty()));
}


MonitorTab::~MonitorTab()
{
    delete m_config;
}

void MonitorTab::apply()
{
    int m = monitorPolicyGroup->id(monitorPolicyGroup->selected());
    m_config->setGroup("monitor");
    m_config->writeEntry("monitorIncomingConnections", (m == 2 || m == 3));
    m_config->writeEntry("monitorOutgoingConnections", (m == 1 || m == 3));

    bool persistent = persistentMonitorCheckbox->isChecked();
    m_config->writeEntry("persistentMonitor", persistent);

    m_config->sync();
    // Execute the monitor to reparse the config
    KStandardDirs stdDirs;
    QString execPath = stdDirs.findResource(
                        "exe", "kbluetoothd_traymonitor");
    if (execPath != QString::null)
    {
        KProcess process;
        process.clearArguments();
        process << execPath;
        process.start(KProcess::DontCare);
    }
}



#include "monitortab.moc"
