/***************************************************************************
                          irmcsyncthreadbase.h  -  description
                             -------------------
    begin                : Sat Feb 14 2003
    copyright            : (C) 2003 by Simone Gotti
    email                : simone.gotti@email.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IRMCSYNCTHREADBASE_H
#define IRMCSYNCTHREADBASE_H

#include <qobject.h>
#include <qapplication.h>
#include <qthread.h>
#include <qmutex.h>
#include <qwaitcondition.h>

#include <synceelist.h>

#include "obexclient.h"
#include "clientthread.h"
#include "changelog.h"



namespace KSync
{

	/**
	   Client Thread. The Worker OBEX client thread.
	   Note that this QObject is only accessed from the client thread. It is used
	   to report events from the working thread. This QObject will be the parent of
	   all QObjects in the working thread. It is in no way connected to the QObject
	   in the main thread.
	 */
	class IrMCSyncThreadBase
				: public ClientThread
	{
		Q_OBJECT

		enum SyncAnchor {
		    ChangeCounters,
		    TimeStamps
		};

	public:

		/**
		   Constructor.
		 */
		IrMCSyncThreadBase(const QString&, const QString&, QObject*);
		/**
		   Destructor.
		 */
		~IrMCSyncThreadBase();

		void setObexClient(Client*);

		//protected:

		bool readSyncees();
		bool writeSyncees();

		QByteArray getFile(const QString&);

		void saveChangeCounter();
		void loadChangeCounter();

		void getInitialCalendarChangelog();
		bool checkAndSetDirs();
		void getCalendarChangelog();
		void getCurrentChangeCounter();
		void getRecords();

		SyncEntry* getSyncees(const QString& fileName);
		void getCalendarRecord(Changelog::record curRecord);
		bool getInfosFromFilenameWithDeviceLUID(const QString, QString&, QString&);
		bool getInfosFromFilenameWithLocalUID(QString&, const QString, QString&);

		void recreateFullSyncee(bool);

		void getChangedEvents();
		void getDeletedEvents();
		void writeAddedModifiedEntries();
		QValueList<QObexHeader> sendToDevice(const QString&, QByteArray&, bool modify = false);
		void getInfosFromReturnedHeader(QValueList<QObexHeader>, QString&, QString&, QString&);



		// You have to create this functions that depends upon the syncee type (Calendar, AddressBook, etc...)

		virtual KSync::Syncee* rawDataToSyncee(QByteArray, QStringList&) = 0;
		virtual QByteArray syncEntryToRawData(KSync::SyncEntry*, QString&) = 0;
		virtual KSync::Syncee* localGetEntry(const QString&) = 0;
		virtual void localPutEntry(KSync::SyncEntry*, const QString&) = 0;

		Client *obex;



		QString serialNumber;
		QString databaseId;
		QString databaseDir;
		QString deviceDir;
		QString fileType;
		QString extension;

		long changeCounter;

		Changelog* changelog;

		uint SyncAnchorType;		
	};
}

#endif
