/***************************************************************************
                          clientthread.cpp  -  description
                             -------------------
    begin                : Sat Feb 14 2003
    copyright            : (C) 2003 by Simone Gotti
	
	from the threaded konnector of Mathias Froehlich <Mathias.Froehlich@web.de>
	
    email                : simone.gotti@email.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qobject.h>
#include <qapplication.h>
#include <qthread.h>

#include <kdebug.h>

#include "clientthread.h"

using namespace KSync;

/**
   Constructor.
*/
ClientThread::ClientThread( QObject* reciver )
		: QObject( 0, "Threaded test konnector" )
{
	mReciver = reciver;
	mCancel = false;
}

/**
   Destructor.
*/
ClientThread::~ClientThread()
{}

/**
   Worker function of QThread.
   It runs the requests and posts events.
*/
void ClientThread::run()
{
	// Do the work here. No further communication here.
	for (;;) {
		mWait.wait( &mLock );
		mCancel = false;
		switch ( mCommand ) {
		case ReadSyncees:
			kdDebug() << "################################### ReadSyncee" << endl;
			readSyncees();
			readSynceesfinished(mSyncee);
			finished();
			break;
		case WriteSyncees:
			kdDebug() << "################################### WriteSyncee" << endl;
			writeSyncees();
			writeSynceesfinished();
			finished();
			break;
		default:
			// Signal that we are finished ...
			QApplication::postEvent( mReciver, new QCustomEvent( TerminatedEvent ) );
			return;
		}
	}
}

/**
   Call in run if you have to report an error.
*/
void ClientThread::finished()
{
	// Signal an error
	QApplication::postEvent( mReciver, new QCustomEvent( FinishedEvent ) );
}

// They were removed on 2004-10-08, let's what happens now...

// /**
//    Call in run if you have to report an error.
// */
// void ClientThread::error( const KSync::Error* e )
// {
// 	// Signal an error
// 	QCustomEvent* ce = new QCustomEvent( ErrorEvent );
// 	ce->setData( (void *)e );
// 	QApplication::postEvent( mReciver, ce );
// }

// /**const
//    Call in run if you want to report progress.
// */
// void ClientThread::progress( const KSync::Progress* p )
// {
// 	// Signal progress
// 	QCustomEvent* ce = new QCustomEvent( ProgressEvent );
// 	ce->setData( (void *)p );
// 	QApplication::postEvent( mReciver, ce );
// }

/**
   Call in run if you have to report Syncee readed.
*/
void ClientThread::readSynceesfinished(KSync::Syncee *Syncee)
{
	// Signal Syncee received
	QCustomEvent* ce = new QCustomEvent( SynceeReadedEvent );
	ce->setData( (void *)Syncee );
	QApplication::postEvent( mReciver, ce );
}

/**
   Call in run if you have to report Syncee writed.
*/
void ClientThread::writeSynceesfinished()
{
	// Signal Syncee received
	QCustomEvent* ce = new QCustomEvent( SynceeWritedEvent );
	QApplication::postEvent( mReciver, ce );
}

#include "clientthread.moc"
