/*
 *
 *  KBluetooth4 - KDE4 Bluetooth Framework
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kbluetooth4.
 *
 *  kbluetooth4 is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kbluetooth4 is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth4; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/

#ifndef WIZARDDIALOG_H
#define WIZARDDIALOG_H

#include <KConfig>
#include <KConfigGroup>
#include <KIcon>
#include <QtGui>
#include <QWizard>

#include <kjob.h>

#include <solid/control/bluetoothmanager.h>
#include <solid/control/bluetoothinterface.h>
#include <solid/control/bluetoothinputdevice.h>

#include "wizardpage.h"


class BTWizard :   public QWizard
{
Q_OBJECT

public:
	BTWizard(QObject* parent = 0);
	~BTWizard();


private:
	const Solid::Control::BluetoothManager& btmanager;
	Solid::Control::BluetoothInterface* iface;
	WizardPage* introPage;
	QLabel* introLabel;
	QVBoxLayout* introLayout;

	WizardPage* servicePage;
	QLabel* serviceLabel;
	QRadioButton* serviceRadioButton1;
	QRadioButton* serviceRadioButton2;
	QVBoxLayout* serviceLayout;

	WizardPage* devicePage;
	QLabel* deviceLabel;
	QLabel* deviceLabel1;
	QLabel* deviceLabel2;
	QLabel* deviceLabel3;
	QLabel* deviceLabel4;
	QLabel* deviceLabel5;
	QListWidget* deviceWidget;
	QPushButton* deviceButton;
	QComboBox* deviceComboBox;
	QVBoxLayout* deviceLayout;
	QHBoxLayout* deviceLayout1;
	QHBoxLayout* deviceLayout2;

	WizardPage* connPage;
	QLabel* connLabel;
	QLabel* connLabel1;
	QLabel* connLabel2;
	QLabel* connLabel3;
	QLabel* connLabel4;
	QLabel* connLabel5;
	QVBoxLayout* connLayout;
	

	

	WizardPage* createIntroPage();
	WizardPage* createSelectServicePage();
	WizardPage* createSelectDevicePage();
	WizardPage* createConnectionPage();

	Solid::Control::BluetoothRemoteDevice* dev;
	Solid::Control::BluetoothRemoteDevice* finalDev;
	Solid::Control::BluetoothInputDevice* inputDev;
	QMap<QString,Solid::Control::BluetoothRemoteDevice*> deviceMap;
	QMap<QString,QString> macMap;
	
	QListWidgetItem* item;

	QString service;

	QEventLoop m_loop;
	int m_error;
	QString m_errorString;

	void createBonding();
	void createInputDev();
	
	void filterList(Solid::Control::BluetoothRemoteDevice*, const QString&);
	void checkForHIDDevice(Solid::Control::BluetoothRemoteDevice*);

public slots:
	void slotCancel();
	void slotNext();	
	void slotSearch();
	void slotRemoteDeviceFound(QString,int, int);
	void slotDiscoveryCompleted();
	void slotServiceHandleReady(const QString&,const QList<uint>&);
	void slotDeviceCreated(const QString&);
	void slotFinish();

	void connectJob(KJob*);
	void slotPercent(KJob* , unsigned long);
	void slotInfoMessage(KJob*, const QString&);
	void slotResult(KJob*);

	void slotDeviceConnected();
	void changeFilterView(const QString&);
	void slotNewNameFound(const QString&, const QString&);
	void slotDeviceSelectionChanged();
	


};


#endif
