#!/usr/bin/env kjscmd

function BaseImage()
{
	this.a = new Image(this);
	this.b = new Image(this);
	this.c = new Image(this);
	this.d = new Image(this);
	this.e = new Image(this);
	this.f = new Image(this);
	this.g = new Image(this);
	this.h = new Image(this);
	this.i = new Image(this);
	
	this.height = function() {
		return this.a.height() + this.d.height() + this.g.height(); 
	}
	
	this.width = function() {
		return this.a.width() + this.b.width() + this.c.width(); 
	}

	this.loadImages = function() {
		return (
		this.a.load("01.png") &&
		this.b.load("02.png") &&
		this.c.load("03.png") &&
		this.d.load("04.png") &&
		this.e.load("05.png") &&
		this.f.load("06.png") &&
		this.g.load("07.png") &&
		this.h.load("08.png") &&
		this.i.load("09.png") );
	}

	this.colorize = function( color ) {
		var percent = 0.55;
		var imgfx = new ImageFX();
		
		this.a = imgfx.blendColor( color, this.a, percent);
		this.b = imgfx.blendColor( color, this.b, percent);
		this.c = imgfx.blendColor( color, this.c, percent);
		this.d = imgfx.blendColor( color, this.d, percent);
		this.e = imgfx.blendColor( color, this.e, percent);
		this.f = imgfx.blendColor( color, this.f, percent);
		this.g = imgfx.blendColor( color, this.g, percent);
		this.h = imgfx.blendColor( color, this.h, percent);
		this.i = imgfx.blendColor( color, this.i, percent);
	}

	this.resize = function( newW, newH ) {

		this.b.smoothScale( newW - ( this.a.width() + this.c.width() ), this.b.height() );
		this.h.smoothScale( newW - ( this.g.width() + this.i.width() ), this.h.height() );

		this.d.smoothScale( this.d.width(), newH - ( this.a.height() + this.g.height() ) );
		this.f.smoothScale( this.f.width(), newH - ( this.c.height() + this.i.height() ) );

		this.e.smoothScale( newW - ( this.a.width() + this.c.width() ),
			 newH - ( this.c.height() + this.i.height() ) );
	}

	this.test = function( parent ) {
		var box = new QHBox(parent);
		var vbox1 = new QVBox(box);
		var vbox2 = new QVBox(box);
		var vbox3 = new QVBox(box);
		var l1 = new QLabel(vbox1);
		l1.pixmap = this.a.pixmap();

		var l2 = new QLabel(vbox1);
		l2.pixmap = this.d.pixmap();

		var l3 = new QLabel(vbox1);
		l3.pixmap = this.g.pixmap();

		var l4 = new QLabel(vbox2);
		l4.pixmap = this.b.pixmap();

		var l5 = new QLabel(vbox2);
		l5.pixmap = this.e.pixmap();

		var l6 = new QLabel(vbox2);
		l6.pixmap = this.h.pixmap();

		var l7 = new QLabel(vbox3);
		l7.pixmap = this.c.pixmap();

		var l8 = new QLabel(vbox3);
		l8.pixmap = this.f.pixmap();

		var l9 = new QLabel(vbox3);
		l9.pixmap = this.i.pixmap();
	}

	this.pixmap = function(width, height){
		var pix = new Pixmap(this);
		pix.resize(width,height);
		pix.fill("white");
		var painter = new Painter(this);
		if( painter.begin(pix) )
		{
			this.paint(painter);
			if( painter.end() )
				return painter.pixmap();
		}
		return pix;
	}
	
	this.paint = function(painter){
		
		painter.drawRect(0,0,this.width(), this.height());
		
		painter.drawImage(0, 0, this.a, 0, 0, -1, -1, 0);
		painter.drawImage(0, this.a.height(), this.d, 0, 0, -1, -1, 0);
		painter.drawImage(0, ( this.height() - this.g.height() ) ,this.g, 0, 0, -1, -1, 0);
		
		painter.drawImage(this.a.width(), 0, this.b, 0, 0, -1, -1, 0);
		painter.drawImage(this.d.width(), this.b.height(), this.e, 0, 0, -1, -1, 0);
		painter.drawImage(this.g.width(), ( this.height() - this.h.height() ) ,this.h, 0, 0, -1, -1, 0);
		
		painter.drawImage(this.a.width() + this.b.width(), 0, this.c, 0, 0, -1, -1, 0);
		painter.drawImage(this.d.width() + this.e.width(), this.c.height(), this.f, 0, 0, -1, -1, 0);
		painter.drawImage(this.g.width() + this.h.width(), ( this.height() - this.i.height() ) ,this.i, 0, 0, -1, -1, 0);
	}
	
	this.widget = function(canvas) {
	        var painter = new Painter(this);
		if( painter.begin(canvas) )
		{
			this.paint(painter);
			if( painter.end() )
				return true;
		}
		return false;
	}
}


var base = new BaseImage();
var label = new QLabel(this);


if ( !base.loadImages() )
	alert("Error Loading Resources!");

base.colorize("blue");
var H = 128;
var W = 128;

base.resize(W,H);

var box = new QHBox(this);
var label = new QLabel(box);
label.resize(W,H);
label.paintEvent = function(ev)
{
	println("paint...");
	base.widget(label);
}

var label2 = new QLabel(box);
label2.pixmap = base.pixmap(W,H);

base.test(box);

box.show();
box.resize(W*3, H)

application.exec();

//img.load("cl.png"); img.blendColor( "blue", 0.20); img.smoothScale(16,128); lab.pixmap = img.pixmap
