//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Text;

	/// <remarks>
	///  The KConfigDialogManager class provides a means of automatically
	///  retrieving, saving and resetting basic settings.
	///  It also can emit signals when settings have been changed
	///  (settings were saved) or modified (the user changes a checkbox
	///  from on to off).
	///  The names of the widgets to be managed have to correspond to the names of the
	///  configuration entries in the KConfigSkeleton object plus an additional
	///  "kcfg_" prefix. For example a widget named "kcfg_MyOption" would be
	///  associated to the configuration entry "MyOption".
	///  New widgets can be added to the map using the static functions propertyMap() and
	///  changedMap().  Note that you can't just add any class.  The class must have a 
	///  matching Q_PROPERTY(...) macro defined, and a signal which emitted when the
	///  property changed. Note: by default, the property which defined as "USER true" 
	///  is used.
	///  For example (note that KColorButton is already added and it doesn't need to
	///  manually added):
	///  kcolorbutton.h defines the following property:
	///  <pre>
	///  Q_PROPERTY( QColor color READ color WRITE setColor USER true )
	///  </pre>
	///  and signal:
	///  <pre>
	///  void changed( QColornewColor );
	///  </pre>
	///  To add KColorButton the following code would be inserted in the main:
	///  <pre>
	///  KConfigDialogManager.ChangedMap().Insert("KColorButton", SIGNAL("changed(QColor)"));
	///  </pre>
	///  See <see cref="IKConfigDialogManagerSignals"></see> for signals emitted by KConfigDialogManager
	/// </remarks>		<author> Waldo Bastian <bastian@kde.org>
	///  </author>
	/// 		<short> Provides a means of automatically retrieving,  saving and resetting KConfigSkeleton based settings in a dialog. </short>

	[SmokeClass("KConfigDialogManager")]
	public class KConfigDialogManager : QObject, IDisposable {
 		protected KConfigDialogManager(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KConfigDialogManager), this);
		}
		private static SmokeInvocation staticInterceptor = null;
		static KConfigDialogManager() {
			staticInterceptor = new SmokeInvocation(typeof(KConfigDialogManager), null);
		}
		/// <remarks>
		///  Constructor.
		/// <param> name="parent" Dialog widget to manage
		/// </param><param> name="conf" Object that contains settings
		///    </param></remarks>		<short>    Constructor.</short>
		public KConfigDialogManager(QWidget parent, KConfigSkeleton conf) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KConfigDialogManager##", "KConfigDialogManager(QWidget*, KConfigSkeleton*)", typeof(void), typeof(QWidget), parent, typeof(KConfigSkeleton), conf);
		}
		/// <remarks>
		///  Add additional widgets to manage
		/// <param> name="widget" Additional widget to manage, inlcuding all its children
		///    </param></remarks>		<short>    Add additional widgets to manage </short>
		public void AddWidget(QWidget widget) {
			interceptor.Invoke("addWidget#", "addWidget(QWidget*)", typeof(void), typeof(QWidget), widget);
		}
		/// <remarks>
		///  Returns whether the current state of the known widgets are
		///  different from the state in the config object.
		///    </remarks>		<short>    Returns whether the current state of the known widgets are  different from the state in the config object.</short>
		public bool HasChanged() {
			return (bool) interceptor.Invoke("hasChanged", "hasChanged() const", typeof(bool));
		}
		/// <remarks>
		///  Returns whether the current state of the known widgets are
		///  the same as the default state in the config object.
		///    </remarks>		<short>    Returns whether the current state of the known widgets are  the same as the default state in the config object.</short>
		public bool IsDefault() {
			return (bool) interceptor.Invoke("isDefault", "isDefault() const", typeof(bool));
		}
		/// <remarks>
		///  Traverse the specified widgets, saving the settings of all known
		///  widgets in the settings object.
		///  Example use: User clicks Ok or Apply button in a configure dialog.
		///    </remarks>		<short>    Traverse the specified widgets, saving the settings of all known  widgets in the settings object.</short>
		[Q_SLOT("void updateSettings()")]
		public void UpdateSettings() {
			interceptor.Invoke("updateSettings", "updateSettings()", typeof(void));
		}
		/// <remarks>
		///  Traverse the specified widgets, sets the state of all known
		///  widgets according to the state in the settings object.
		///  Example use: Initialisation of dialog.
		///  Example use: User clicks Reset button in a configure dialog.
		///    </remarks>		<short>    Traverse the specified widgets, sets the state of all known  widgets according to the state in the settings object.</short>
		[Q_SLOT("void updateWidgets()")]
		public void UpdateWidgets() {
			interceptor.Invoke("updateWidgets", "updateWidgets()", typeof(void));
		}
		/// <remarks>
		///  Traverse the specified widgets, sets the state of all known
		///  widgets according to the default state in the settings object.
		///  Example use: User clicks Defaults button in a configure dialog.
		///    </remarks>		<short>    Traverse the specified widgets, sets the state of all known  widgets according to the default state in the settings object.</short>
		[Q_SLOT("void updateWidgetsDefault()")]
		public void UpdateWidgetsDefault() {
			interceptor.Invoke("updateWidgetsDefault", "updateWidgetsDefault()", typeof(void));
		}
		/// <remarks>
		/// <param> name="trackChanges" - If any changes by the widgets should be tracked
		///  set true.  This causes the emitting the modified() signal when
		///  something changes.
		///  TODO: @return bool - True if any setting was changed from the default.
		///    </param></remarks>		<short>   </short>
		protected void Init(bool trackChanges) {
			interceptor.Invoke("init$", "init(bool)", typeof(void), typeof(bool), trackChanges);
		}
		/// <remarks>
		///  Recursive function that finds all known children.
		///  Goes through the children of widget and if any are known and not being
		///  ignored, stores them in currentGroup.  Also checks if the widget
		///  should be disabled because it is set immutable.
		/// <param> name="widget" - Parent of the children to look at.
		/// </param><param> name="trackChanges" - If true then tracks any changes to the children of
		///  widget that are known.
		/// </param></remarks>		<return> bool - If a widget was set to something other then its default.
		///    </return>
		/// 		<short>    Recursive function that finds all known children.</short>
		protected bool ParseChildren(QWidget widget, bool trackChanges) {
			return (bool) interceptor.Invoke("parseChildren#$", "parseChildren(const QWidget*, bool)", typeof(bool), typeof(QWidget), widget, typeof(bool), trackChanges);
		}
		/// <remarks>
		///  Finds the USER property name using Qt's MetaProperty system, and caches
		///  it in the property map (the cache could be retrieved by propertyMap() ).
		///    </remarks>		<short>    Finds the USER property name using Qt's MetaProperty system, and caches  it in the property map (the cache could be retrieved by propertyMap() ).</short>
		protected QByteArray GetUserProperty(QWidget widget) {
			return (QByteArray) interceptor.Invoke("getUserProperty#", "getUserProperty(const QWidget*) const", typeof(QByteArray), typeof(QWidget), widget);
		}
		/// <remarks>
		///  Set a property
		///    </remarks>		<short>    Set a property    </short>
		protected void SetProperty(QWidget w, QVariant v) {
			interceptor.Invoke("setProperty##", "setProperty(QWidget*, const QVariant&)", typeof(void), typeof(QWidget), w, typeof(QVariant), v);
		}
		/// <remarks>
		///  Retrieve a property
		///    </remarks>		<short>    Retrieve a property    </short>
		protected QVariant Property(QWidget w) {
			return (QVariant) interceptor.Invoke("property#", "property(QWidget*) const", typeof(QVariant), typeof(QWidget), w);
		}
		/// <remarks>
		///  Setup secondary widget properties
		///    </remarks>		<short>    Setup secondary widget properties    </short>
		protected void SetupWidget(QWidget widget, KConfigSkeletonItem item) {
			interceptor.Invoke("setupWidget##", "setupWidget(QWidget*, KConfigSkeletonItem*)", typeof(void), typeof(QWidget), widget, typeof(KConfigSkeletonItem), item);
		}
		~KConfigDialogManager() {
			interceptor.Invoke("~KConfigDialogManager", "~KConfigDialogManager()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~KConfigDialogManager", "~KConfigDialogManager()", typeof(void));
		}
		/// <remarks>
		///  Retrieve the property map
		///    </remarks>		<short>    Retrieve the property map    </short>
		public static string PropertyMap() {
			return (string) staticInterceptor.Invoke("propertyMap", "propertyMap()", typeof(string));
		}
		/// <remarks>
		///  Retrieve the widget change map
		///    </remarks>		<short>    Retrieve the widget change map    </short>
		public static string ChangedMap() {
			return (string) staticInterceptor.Invoke("changedMap", "changedMap()", typeof(string));
		}
		/// <remarks>
		///  Initializes the property maps
		///    </remarks>		<short>    Initializes the property maps    </short>
		protected static void InitMaps() {
			staticInterceptor.Invoke("initMaps", "initMaps()", typeof(void));
		}
		protected new IKConfigDialogManagerSignals Emit {
			get { return (IKConfigDialogManagerSignals) Q_EMIT; }
		}
	}

	public interface IKConfigDialogManagerSignals : IQObjectSignals {
		/// <remarks>
		///  One or more of the settings have been saved (such as when the user
		///  clicks on the Apply button).  This is only emitted by updateSettings()
		///  whenever one or more setting were changed and consequently saved.
		///    </remarks>		<short>    One or more of the settings have been saved (such as when the user  clicks on the Apply button).</short>
		[Q_SIGNAL("void settingsChanged()")]
		void SettingsChanged();
		/// <remarks>
		///  TODO: Verify
		///  One or more of the settings have been changed.
		/// <param> name="widget" - The widget group (pass in via addWidget()) that
		///  contains the one or more modified setting.
		/// </param></remarks>		<short>    TODO: Verify  One or more of the settings have been changed.</short>
		/// 		<see> settingsChanged</see>
		[Q_SIGNAL("void settingsChanged(QWidget*)")]
		void SettingsChanged(QWidget widget);
		/// <remarks>
		///  If retrieveSettings() was told to track changes then if
		///  any known setting was changed this signal will be emitted.  Note
		///  that a settings can be modified several times and might go back to the
		///  original saved state. hasChanged() will tell you if anything has
		///  actually changed from the saved values.
		///    </remarks>		<short>    If retrieveSettings() was told to track changes then if  any known setting was changed this signal will be emitted.</short>
		[Q_SIGNAL("void widgetModified()")]
		void WidgetModified();
	}
}
