/*
 * This file has been generated by the onto2vocabularyclass tool
 * copyright (C) 2007-2008 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_NIE_H_
#define _SOPRANO_NIE_H_

#include <QtCore/QUrl>

namespace Nepomuk {
    namespace Vocabulary {
        namespace NIE {
            /**
             * http://www.semanticdesktop.org/ontologies/2007/01/19/nie#
             */
            QUrl nieNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/01/19/nie#DataObject
             *
             * A unit of data that is created, annotated and processed on the
             * user desktop. It represents a native structure the user works
             * with. The usage of the term 'native' is important. It means that
             * a DataObject can be directly mapped to a data structure maintained
             * by a native application. This may be a file, a set of files or a
             * part of a file. The granularity depends on the user. This class
             * is not intended to be instantiated by itself. Use more specific
             * subclasses.
             */
            QUrl DataObject();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/01/19/nie#InformationElement
             *
             * A unit of content the user works with. This is a superclass for
             * all interpretations of a DataObject.
             */
            QUrl InformationElement();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#url
             *
             * URL of a DataObject. It points to the location of the object.
             * A typial usage is FileDataObject. In cases where creating a
             * simple file:// or http:// URL for a file is difficult (e.g. for
             * files inside compressed archives) the applications are encouraged
             * to use conventions defined by Apache Commons VFS Project at
             * http://jakarta.apache.org/ commons/ vfs/ filesystems.html.
             */
            QUrl url();
        }
    }
}

#endif
