/*
 *  Copyright (C) 2002 - 2005 David Faure   <faure@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation;
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include "ktar.h"
#include <stdio.h>
#include <kcomponentdata.h>
#include <kdebug.h>

void recursive_print( const KArchiveDirectory * dir, const QString & path )
{
  QStringList l = dir->entries();
  l.sort();
  QStringList::ConstIterator it = l.constBegin();
  for( ; it != l.constEnd(); ++it )
  {
    const KArchiveEntry* entry = dir->entry( (*it) );
    printf("mode=%07o %s %s %s%s %lld isdir=%d\n", entry->permissions(), entry->user().toLatin1().constData(), entry->group().toLatin1().constData(), path.toLatin1().constData(), (*it).toLatin1().constData(),
            entry->isFile() ? static_cast<const KArchiveFile *>(entry)->size() : 0,
            entry->isDirectory());
    if (!entry->symLinkTarget().isEmpty()) {
        printf("  (symlink to %s)\n",qPrintable(entry->symLinkTarget()));
    }
    if (entry->isDirectory())
      recursive_print( (KArchiveDirectory *)entry, path+(*it)+'/' );
  }
}

int main( int argc, char** argv )
{
    if (argc != 2)
    {
        printf("\n"
               " Usage :\n"
               " ./ktartest /path/to/existing_file.tar.gz       tests listing an existing tar.gz\n" );
        return 1;
    }
    KComponentData componentData(QByteArray("ktartest"));
    KTar tar( argv[1] );

    if ( !tar.open( QIODevice::ReadOnly ) )
    {
      printf("Could not open %s for reading\n", argv[1] );
      return 1;
    }

    const KArchiveDirectory* dir = tar.directory();

    //printf("calling recursive_print\n");
    recursive_print( dir, "" );
    //printf("recursive_print called\n");

    tar.close();

    return 0;
}

