#ifndef METHODCALLBASE_H_
#define METHODCALLBASE_H_

#include "marshall.h"

class Smoke;

class MethodCallBase : public Marshall
{
public:
	MethodCallBase(Smoke *smoke, const Smoke::Index meth, zval** sp);
	MethodCallBase(Smoke *smoke, const Smoke::Index meth, const Smoke::Stack stack, zval** sp);
	MethodCallBase(Smoke *smoke, const Smoke::Stack stack, zval** sp);
	//	virtual ~MethodCallBase();

	Smoke *smoke();
	SmokeType type();
       	Smoke::StackItem &item();
	const Smoke::Method &method();
	virtual const int items() = 0;
	virtual void callMethod() = 0;
	void next();
	void unsupported();

protected:
	Smoke *_smoke;
	Smoke::Index _method;
	Smoke::Stack _stack;
	int _cur;
	Smoke::Index *_args;
	bool _called;
	zval **_sp;
};

#endif /*METHODCALLBASE_H_*/
