//Auto-generated by kalyptus. DO NOT EDIT.
namespace Soprano.Util {
    using Soprano;
    using System;
    using Qyoto;
    /// <remarks>
    ///  \class SignalCacheModel signalcachemodel.h Soprano/Util/SignalCacheModel
    ///  \brief Caches multiple signals into one to avoid slowdown when adding
    ///  or removing many statements.
    ///  When adding or removing many statements with separate calls to Model.AddStatement
    ///  or Model.RemoveStatement Model emits signals Model.StatementsAdded and Model.StatementsRemoved
    ///  over and over for each call. This can slow down an application that monitors
    ///  the state of the model.
    ///  The SignalCacheModel caches multiple emitted signals into one, trying to ensure
    ///  that only one signal is delivered in a certain time. The downside of this is
    ///  that signals are not delivered immiadetely but through the event loop. This,
    ///  however, should seldomly be a problem.
    ///  \author Sebastian Trueg <trueg@kde.org>
    ///  \since 2.1
    ///          </remarks>        <short>    \class SignalCacheModel signalcachemodel.</short>
    [SmokeClass("Soprano::Util::SignalCacheModel")]
    public class SignalCacheModel : Soprano.FilterModel, IDisposable {
        protected SignalCacheModel(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(SignalCacheModel), this);
        }
        /// <remarks>
        ///  Create a new SignalCacheModel.
        ///  \param parent The parent Model to forward
        ///         the actual calls to.
        ///              </remarks>        <short>    Create a new SignalCacheModel.</short>
        public SignalCacheModel(Soprano.Model parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("SignalCacheModel#", "SignalCacheModel(Soprano::Model*)", typeof(void), typeof(Soprano.Model), parent);
        }
        public SignalCacheModel() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("SignalCacheModel", "SignalCacheModel()", typeof(void));
        }
        /// <remarks>
        ///  The cache time.
        ///  \sa setCacheTime
        ///              </remarks>        <short>    The cache time.</short>
        public int CacheTime() {
            return (int) interceptor.Invoke("cacheTime", "cacheTime() const", typeof(int));
        }
        /// <remarks>
        ///  Signals are only delivered once every <pre>msec</pre> milliseconds.
        ///  Default value is 50
        ///              </remarks>        <short>    Signals are only delivered once every \p msec milliseconds.</short>
        [Q_SLOT("void setCacheTime(int)")]
        public void SetCacheTime(int msec) {
            interceptor.Invoke("setCacheTime$", "setCacheTime(int)", typeof(void), typeof(int), msec);
        }
        /// <remarks>
        ///  Reimplemented to do the actual signal caching.
        ///              </remarks>        <short>    Reimplemented to do the actual signal caching.</short>
        [SmokeMethod("parentStatementsAdded()")]
        protected override void ParentStatementsAdded() {
            interceptor.Invoke("parentStatementsAdded", "parentStatementsAdded()", typeof(void));
        }
        /// <remarks>
        ///  Reimplemented to do the actual signal caching.
        ///              </remarks>        <short>    Reimplemented to do the actual signal caching.</short>
        [SmokeMethod("parentStatementsRemoved()")]
        protected override void ParentStatementsRemoved() {
            interceptor.Invoke("parentStatementsRemoved", "parentStatementsRemoved()", typeof(void));
        }
        [SmokeMethod("timerEvent(QTimerEvent*)")]
        protected override void TimerEvent(QTimerEvent arg1) {
            interceptor.Invoke("timerEvent#", "timerEvent(QTimerEvent*)", typeof(void), typeof(QTimerEvent), arg1);
        }
        ~SignalCacheModel() {
            interceptor.Invoke("~SignalCacheModel", "~SignalCacheModel()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~SignalCacheModel", "~SignalCacheModel()", typeof(void));
        }
        protected new ISignalCacheModelSignals Emit {
            get { return (ISignalCacheModelSignals) Q_EMIT; }
        }
    }

    public interface ISignalCacheModelSignals : Soprano.IFilterModelSignals {
    }
}
