//Auto-generated by kalyptus. DO NOT EDIT.
namespace Soprano.Server {
    using Soprano;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \class ServerCore servercore.h Soprano/Server/ServerCore
    ///  \brief Central %Soprano server class.
    ///  The %ServerCore provides a %Soprano server which maintains a set
    ///  of named Model instances that can be accessed by clients over
    ///  a tcp connection through Server.BackendPlugin.
    ///  Creating a server is very simple: Either derive from ServerCore or 
    ///  create an instance and then call start() to make the server listen
    ///  for incoming connections.
    ///  <pre>
    ///  Soprano.Server.ServerCore core;
    ///  core.start();
    ///  </pre>
    ///  Optionally ServerCore can be configured using normal BackendSetting
    ///  settings through setBackendSettings().
    ///  Be aware the ServerCode supports multiple ways of communication.
    ///  start() opens a TCP socket to accept new connections, registerAsDBusObject()
    ///  registers a DBus interface on the DBus session bus. Both ways of
    ///  communication can be used simultaneously.
    ///  ServerCore is designed for single-threaded usage. Thus, model() uses
    ///  Util.AsyncModel to protect against deadlocks.
    ///  This behaviour can of course be changed by reimplementing model().
    ///  \author Sebastian Trueg <trueg@kde.org>
    ///          </remarks>        <short>    \class ServerCore servercore.</short>
    [SmokeClass("Soprano::Server::ServerCore")]
    public class ServerCore : QObject, Soprano.Error.IErrorCache, IDisposable {
        protected ServerCore(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(ServerCore), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static ServerCore() {
            staticInterceptor = new SmokeInvocation(typeof(ServerCore), null);
        }
        public static ushort DEFAULT_PORT() {
            return (ushort) staticInterceptor.Invoke("DEFAULT_PORT", "DEFAULT_PORT()", typeof(ushort));
        }
        // void setBackend(const Soprano::Backend* arg1); >>>> NOT CONVERTED
        // const Soprano::Backend* backend(); >>>> NOT CONVERTED
        // void setBackendSettings(const QList<Soprano::BackendSetting>& arg1); >>>> NOT CONVERTED
        // QList<Soprano::BackendSetting> backendSettings(); >>>> NOT CONVERTED
        // Soprano::Model* createModel(const QList<Soprano::BackendSetting>& arg1); >>>> NOT CONVERTED
        // Error lastError(); >>>> NOT CONVERTED
        // void setError(const Error& arg1); >>>> NOT CONVERTED
        public ServerCore(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ServerCore#", "ServerCore(QObject*)", typeof(void), typeof(QObject), parent);
        }
        public ServerCore() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ServerCore", "ServerCore()", typeof(void));
        }
        /// <remarks>
        ///  Set the Backend used in the Server to create Models.
        ///              </remarks>        <short>    Set the Backend used in the Server to create Models.</short>
        /// <remarks>
        ///  The Backend used by the Server to create Model instances.
        ///              </remarks>        <short>    The Backend used by the Server to create Model instances.</short>
        /// <remarks>
        ///  Set the settings that are to be used by createModel() to create new Model
        ///  instances. Be aware that Soprano.BackendOptionStorageDir will be changed
        ///  to include a subdir which is the Model's name.
        ///  \param settings The settings to use for new Models.
        ///              </remarks>        <short>    Set the settings that are to be used by createModel() to create new Model  instances.</short>
        /// <remarks>
        ///  Retrieve the backend settings configured via setBackendSettings().
        ///  \return A list of BackendSetting objects.
        ///              </remarks>        <short>    Retrieve the backend settings configured via setBackendSettings().</short>
        /// <remarks>
        ///  Get or create Model with the specific name.
        ///  The default implementation will use createModel() to create a new Model
        ///  if none with the specified name exists and protect it against deadlocks
        ///  with a Util.AsyncModel.
        ///  \param name The name of the requested Model.
        ///              </remarks>        <short>    Get or create Model with the specific name.</short>
        [SmokeMethod("model(const QString&)")]
        public virtual Soprano.Model Model(string name) {
            return (Soprano.Model) interceptor.Invoke("model$", "model(const QString&)", typeof(Soprano.Model), typeof(string), name);
        }
        /// <remarks>
        ///  Remove a model and delete all data in it.
        ///  Use with care.
        ///  Be aware that the Model instance will also be deleted.
        ///  Should be reimplemented if model() is reimplemented.
        ///  \param name The name of the requested Model.
        ///  \warning This is not the same as deleting the Model instance.
        ///  It will also delete all the data on the harddisk.
        ///              </remarks>        <short>    Remove a model and delete all data in it.</short>
        [SmokeMethod("removeModel(const QString&)")]
        public virtual void RemoveModel(string name) {
            interceptor.Invoke("removeModel$", "removeModel(const QString&)", typeof(void), typeof(string), name);
        }
        /// <remarks>
        ///  Retrieve all models that have been loaded.
        ///  \return A list of Model names.
        ///              </remarks>        <short>    Retrieve all models that have been loaded.</short>
        [SmokeMethod("allModels() const")]
        public virtual List<string> AllModels() {
            return (List<string>) interceptor.Invoke("allModels", "allModels() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Start the core on a local socket.
        ///  On Windows this is a named pipe and on Unix this this is a local domain socket.
        ///  Use Client.LocalSocketClient to connect.
        ///  \warning Via the local socket connection signals are not supported.
        ///  \return <pre>true</pre> if the local socket could be successfully
        ///  opened. <pre>false</pre> on error. See ErrorCache.LastError() for details.
        ///              </remarks>        <short>    Start the core on a local socket.</short>
        public bool Start(string socketPath) {
            return (bool) interceptor.Invoke("start$", "start(const QString&)", typeof(bool), typeof(string), socketPath);
        }
        public bool Start() {
            return (bool) interceptor.Invoke("start", "start()", typeof(bool));
        }
        /// <remarks>
        ///  Start the Server. Calling this method will make the Server
        ///  listen on the specified port for incoming client connections.
        ///  \param port The port to listen on for client connections.
        ///  Use Client.TcpClient to connect.
        ///  \warning Via the TCP connection signals are not supported. Thus, the models created
        ///  by it will not emit signals such as Model.StatementAdded. Also no permission handling or
        ///  any kind of security is implemented at the moment. Thus, if a server is running and is 
        ///  listening on a port, it is open to connections from any client on any computer in the
        ///  network.
        ///  \return <pre>true</pre> if the server was successfully started, <pre>false</pre> otherwise.
        ///              </remarks>        <short>    Start the Server.</short>
        public bool Listen(ushort port) {
            return (bool) interceptor.Invoke("listen$", "listen(unsigned short)", typeof(bool), typeof(ushort), port);
        }
        public bool Listen() {
            return (bool) interceptor.Invoke("listen", "listen()", typeof(bool));
        }
        /// <remarks>
        ///  \return The port this server is listening on or 0 if listen has not
        ///  been called successfully.
        ///  \since 2.1
        ///              </remarks>        <short>    \return The port this server is listening on or 0 if listen has not  been called successfully.</short>
        public ushort ServerPort() {
            return (ushort) interceptor.Invoke("serverPort", "serverPort() const", typeof(ushort));
        }
        /// <remarks>
        ///  Register the ServerCore as a DBus object. The process needs to be registered
        ///  as a DBus service before (QDBusConnection.RegisterService()).
        ///  \param objectPath The DBus object path to register the server as. If empty
        ///  the default path will be used (/org/soprano/Server).
        ///  Use Client.DBusClient to connect.
        ///              </remarks>        <short>    Register the ServerCore as a DBus object.</short>
        public void RegisterAsDBusObject(string objectPath) {
            interceptor.Invoke("registerAsDBusObject$", "registerAsDBusObject(const QString&)", typeof(void), typeof(string), objectPath);
        }
        public void RegisterAsDBusObject() {
            interceptor.Invoke("registerAsDBusObject", "registerAsDBusObject()", typeof(void));
        }
        /// <remarks>
        ///  Create a new Model. The default implementation uses the configured Backend
        ///  with the configured settings to create a new Model. This method can be
        ///  reimplemented to create specialized Model, for example in combination with
        ///  some FilterModel.
        ///  \param settings The settings to use (a reimplementation may choose to ignore the
        ///  settings.)
        ///  \return A newly create Model.
        ///              </remarks>        <short>    Create a new Model.</short>
        ~ServerCore() {
            interceptor.Invoke("~ServerCore", "~ServerCore()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~ServerCore", "~ServerCore()", typeof(void));
        }
        /// <remarks>
        ///  Get the last error that occured in the current thread.
        ///              </remarks>        <short>    Get the last error that occured in the current thread.</short>
        /// <remarks>
        ///  Reset the error for the current thread to no error.
        ///              </remarks>        <short>    Reset the error for the current thread to no error.</short>
        protected void ClearError() {
            interceptor.Invoke("clearError", "clearError() const", typeof(void));
        }
        /// <remarks>
        ///  Set the last occured error. This method is const to allow setting
        ///  of errors in all types of methods. The last error is as such a 
        ///  mutable property.
        ///              </remarks>        <short>    Set the last occured error.</short>
        /// <remarks>
        ///  Convenience method to set simple string error messages with a default
        ///  error code ErrorUnknown.
        ///              </remarks>        <short>    Convenience method to set simple string error messages with a default  error code ErrorUnknown.</short>
        protected void SetError(string errorMessage, int code) {
            interceptor.Invoke("setError$$", "setError(const QString&, int) const", typeof(void), typeof(string), errorMessage, typeof(int), code);
        }
        protected void SetError(string errorMessage) {
            interceptor.Invoke("setError$", "setError(const QString&) const", typeof(void), typeof(string), errorMessage);
        }
        protected new IServerCoreSignals Emit {
            get { return (IServerCoreSignals) Q_EMIT; }
        }
    }

    public interface IServerCoreSignals : IQObjectSignals {
    }
}
