//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  The Monitor emits signals if some of these objects are changed or
    ///  removed or new ones are added to the Akonadi storage.
    ///  Optionally, the changed objects can be fetched automatically from the server.
    ///  To enable this, see fetchCollection(), fetchItemMetaData(), fetchItemData().
    ///  @todo: distinguish between monitoring collection properties and collection content.
    ///  @todo: special case for collection content counts changed
    ///  See <see cref="IMonitorSignals"></see> for signals emitted by Monitor
    /// </remarks>        <author> Volker Krause <vkrause@kde.org>
    ///  </author>
    ///         <short> Monitors an item or collection for changes. </short>
    [SmokeClass("Akonadi::Monitor")]
    public class Monitor : QObject, IDisposable {
        protected Monitor(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Monitor), this);
        }
        // Akonadi::Monitor* Monitor(Akonadi::MonitorPrivate* arg1,QObject* arg2); >>>> NOT CONVERTED
        // Akonadi::Monitor* Monitor(Akonadi::MonitorPrivate* arg1); >>>> NOT CONVERTED
        /// <remarks>
        ///  Creates a new monitor.
        /// <param> name="parent" The parent object.
        ///      </param></remarks>        <short>    Creates a new monitor.</short>
        public Monitor(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Monitor#", "Monitor(QObject*)", typeof(void), typeof(QObject), parent);
        }
        public Monitor() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Monitor", "Monitor()", typeof(void));
        }
        /// <remarks>
        ///  Sets whether the specified collection shall be monitored for changes.
        /// <param> name="collection" The collection to monitor.
        ///                    If this collection is Collection.Root(), all collections
        ///                    in the Akonadi storage will be monitored.
        ///      </param></remarks>        <short>    Sets whether the specified collection shall be monitored for changes.</short>
        public void SetCollectionMonitored(Akonadi.Collection collection, bool monitored) {
            interceptor.Invoke("setCollectionMonitored#$", "setCollectionMonitored(const Akonadi::Collection&, bool)", typeof(void), typeof(Akonadi.Collection), collection, typeof(bool), monitored);
        }
        public void SetCollectionMonitored(Akonadi.Collection collection) {
            interceptor.Invoke("setCollectionMonitored#", "setCollectionMonitored(const Akonadi::Collection&)", typeof(void), typeof(Akonadi.Collection), collection);
        }
        /// <remarks>
        ///  Sets whether the specified item shall be monitored for changes.
        /// <param> name="item" The item to monitor.
        ///      </param></remarks>        <short>    Sets whether the specified item shall be monitored for changes.</short>
        public void SetItemMonitored(Akonadi.Item item, bool monitored) {
            interceptor.Invoke("setItemMonitored#$", "setItemMonitored(const Akonadi::Item&, bool)", typeof(void), typeof(Akonadi.Item), item, typeof(bool), monitored);
        }
        public void SetItemMonitored(Akonadi.Item item) {
            interceptor.Invoke("setItemMonitored#", "setItemMonitored(const Akonadi::Item&)", typeof(void), typeof(Akonadi.Item), item);
        }
        /// <remarks>
        ///  Sets whether the specified resource shall be monitored for changes.
        /// <param> name="resource" The resource identifier.
        ///      </param></remarks>        <short>    Sets whether the specified resource shall be monitored for changes.</short>
        public void SetResourceMonitored(QByteArray resource, bool monitored) {
            interceptor.Invoke("setResourceMonitored#$", "setResourceMonitored(const QByteArray&, bool)", typeof(void), typeof(QByteArray), resource, typeof(bool), monitored);
        }
        public void SetResourceMonitored(QByteArray resource) {
            interceptor.Invoke("setResourceMonitored#", "setResourceMonitored(const QByteArray&)", typeof(void), typeof(QByteArray), resource);
        }
        /// <remarks>
        ///  Sets whether objects of the specified mime type shall be monitored for changes.
        /// <param> name="mimetype" The mime type to monitor.
        ///      </param></remarks>        <short>    Sets whether objects of the specified mime type shall be monitored for changes.</short>
        public void SetMimeTypeMonitored(string mimetype, bool monitored) {
            interceptor.Invoke("setMimeTypeMonitored$$", "setMimeTypeMonitored(const QString&, bool)", typeof(void), typeof(string), mimetype, typeof(bool), monitored);
        }
        public void SetMimeTypeMonitored(string mimetype) {
            interceptor.Invoke("setMimeTypeMonitored$", "setMimeTypeMonitored(const QString&)", typeof(void), typeof(string), mimetype);
        }
        /// <remarks>
        ///  Sets whether all items shall be monitored.
        ///      </remarks>        <short>    Sets whether all items shall be monitored.</short>
        public void SetAllMonitored(bool monitored) {
            interceptor.Invoke("setAllMonitored$", "setAllMonitored(bool)", typeof(void), typeof(bool), monitored);
        }
        public void SetAllMonitored() {
            interceptor.Invoke("setAllMonitored", "setAllMonitored()", typeof(void));
        }
        /// <remarks>
        ///  Ignores all change notifications caused by the given session.
        /// <param> name="session" The session you want to ignore.
        ///      </param></remarks>        <short>    Ignores all change notifications caused by the given session.</short>
        public void IgnoreSession(Akonadi.Session session) {
            interceptor.Invoke("ignoreSession#", "ignoreSession(Akonadi::Session*)", typeof(void), typeof(Akonadi.Session), session);
        }
        /// <remarks>
        ///  Enables automatic fetching of changed collections from the Akonadi storage.
        /// <param> name="enable" <code>true</code> enables automatic fetching, <code>false</code> disables automatic fetching.
        ///      </param></remarks>        <short>    Enables automatic fetching of changed collections from the Akonadi storage.</short>
        public void FetchCollection(bool enable) {
            interceptor.Invoke("fetchCollection$", "fetchCollection(bool)", typeof(void), typeof(bool), enable);
        }
        /// <remarks>
        ///  Enables automatic fetching of changed collection statistics information from
        ///  the Akonadi storage.
        /// <param> name="enable" <code>true</code> to enables automatic fetching, <code>false</code> disables automatic fetching.
        ///      </param></remarks>        <short>    Enables automatic fetching of changed collection statistics information from  the Akonadi storage.</short>
        public void FetchCollectionStatistics(bool enable) {
            interceptor.Invoke("fetchCollectionStatistics$", "fetchCollectionStatistics(bool)", typeof(void), typeof(bool), enable);
        }
        /// <remarks>
        ///  Sets the item fetch scope.
        ///  Controls how much of an item's data is fetched from the server, e.g.
        ///  whether to fetch the full item payload or only meta data.
        /// <param> name="fetchScope" The new scope for item fetch operations.
        /// </param></remarks>        <short>    Sets the item fetch scope.</short>
        ///         <see> itemFetchScope</see>
        public void SetItemFetchScope(Akonadi.ItemFetchScope fetchScope) {
            interceptor.Invoke("setItemFetchScope#", "setItemFetchScope(const Akonadi::ItemFetchScope&)", typeof(void), typeof(Akonadi.ItemFetchScope), fetchScope);
        }
        /// <remarks>
        ///  Returns the item fetch scope.
        ///  Since this returns a reference it can be used to conveniently modify the
        ///  current scope in-place, i.e. by calling a method on the returned reference
        ///  without storing it in a local variable. See the ItemFetchScope documentation
        ///  for an example.
        /// </remarks>        <return> a reference to the current item fetch scope
        /// </return>
        ///         <short>    Returns the item fetch scope.</short>
        ///         <see> setItemFetchScope</see>
        ///         <see> for</see>
        ///         <see> replacing</see>
        ///         <see> the</see>
        ///         <see> current</see>
        ///         <see> item</see>
        ///         <see> fetch</see>
        ///         <see> scope</see>
        public Akonadi.ItemFetchScope ItemFetchScope() {
            return (Akonadi.ItemFetchScope) interceptor.Invoke("itemFetchScope", "itemFetchScope()", typeof(Akonadi.ItemFetchScope));
        }
        ~Monitor() {
            interceptor.Invoke("~Monitor", "~Monitor()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~Monitor", "~Monitor()", typeof(void));
        }
        protected new IMonitorSignals Emit {
            get { return (IMonitorSignals) Q_EMIT; }
        }
    }

    public interface IMonitorSignals : IQObjectSignals {
        // void itemChanged(const Akonadi::Item& arg1,const QSet<QByteArray>& arg2); >>>> NOT CONVERTED
        /// <remarks>
        ///  This signal is emitted if a monitored item has been moved between two collections
        /// <param> name="item" The moved item.
        /// </param><param> name="collectionSource" The collection the item has been moved from.
        /// </param><param> name="collectionDestination" The collection the item has been moved to.
        ///      </param></remarks>        <short>    This signal is emitted if a monitored item has been moved between two collections </short>
        [Q_SIGNAL("void itemMoved(Akonadi::Item, Akonadi::Collection, Akonadi::Collection)")]
        void ItemMoved(Akonadi.Item item, Akonadi.Collection collectionSource, Akonadi.Collection collectionDestination);
        /// <remarks>
        ///  This signal is emitted if an item has been added to a monitored collection in the Akonadi storage.
        /// <param> name="item" The new item.
        /// </param><param> name="collection" The collection the item has been added to.
        ///      </param></remarks>        <short>    This signal is emitted if an item has been added to a monitored collection in the Akonadi storage.</short>
        [Q_SIGNAL("void itemAdded(Akonadi::Item, Akonadi::Collection)")]
        void ItemAdded(Akonadi.Item item, Akonadi.Collection collection);
        /// <remarks>
        ///  This signal is emitted if
        ///    - a monitored item has been removed from the Akonadi storage
        ///  or
        ///    - a item has been removed from a monitored collection.
        /// <param> name="item" The removed item.
        ///      </param></remarks>        <short>    This signal is emitted if    - a monitored item has been removed from the Akonadi storage  or    - a item has been removed from a monitored collection.</short>
        [Q_SIGNAL("void itemRemoved(Akonadi::Item)")]
        void ItemRemoved(Akonadi.Item item);
        /// <remarks>
        ///  This signal is emitted if a new collection has been added to a monitored collection in the Akonadi storage.
        /// <param> name="collection" The new collection.
        /// </param><param> name="parent" The parent collection.
        ///      </param></remarks>        <short>    This signal is emitted if a new collection has been added to a monitored collection in the Akonadi storage.</short>
        [Q_SIGNAL("void collectionAdded(Akonadi::Collection, Akonadi::Collection)")]
        void CollectionAdded(Akonadi.Collection collection, Akonadi.Collection parent);
        /// <remarks>
        ///  This signal is emitted if a monitored collection has been changed (properties or content)
        ///  or has been reparented.
        /// <param> name="collection" The changed collection.
        ///      </param></remarks>        <short>    This signal is emitted if a monitored collection has been changed (properties or content)  or has been reparented.</short>
        [Q_SIGNAL("void collectionChanged(Akonadi::Collection)")]
        void CollectionChanged(Akonadi.Collection collection);
        /// <remarks>
        ///  This signal is emitted if a monitored collection has been removed from the Akonadi storage.
        /// <param> name="collection" The removed collection.
        ///      </param></remarks>        <short>    This signal is emitted if a monitored collection has been removed from the Akonadi storage.</short>
        [Q_SIGNAL("void collectionRemoved(Akonadi::Collection)")]
        void CollectionRemoved(Akonadi.Collection collection);
        /// <remarks>
        ///  This signal is emitted if the statistics information of a monitored collection
        ///  has changed.
        /// <param> name="id" The collection identifier of the changed collection.
        /// </param><param> name="statistics" The updated collection statistics, invalid if automatic
        ///                    fetching of statistics changes is disabled.
        ///      </param></remarks>        <short>    This signal is emitted if the statistics information of a monitored collection  has changed.</short>
        [Q_SIGNAL("void collectionStatisticsChanged(Akonadi::Collection::Id, Akonadi::CollectionStatistics)")]
        void CollectionStatisticsChanged(long id, Akonadi.CollectionStatistics statistics);
    }
}
