/***************************************************************************
                          cleaner.cpp  -  description
                             -------------------
    begin                : Tue Apr 5 2005
    copyright            : (C) 2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/04/27 19:38:47 $ by $Author: hftom $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <sys/time.h>
#include <sys/resource.h>

#include <qdir.h>
#include <qstringlist.h>

#include "cleaner.h"



Cleaner::Cleaner( const QString &path )
{
	livePath = path;

	connect( &timer, SIGNAL(timeout()), this, SLOT(doClean()) );
	timer.start( 60*1000 );
}



Cleaner::~Cleaner()
{
	wait();
}



void Cleaner::doClean()
{
	start();
}



void Cleaner::setPath( const QString &path )
{
	livePath = path;
}



void Cleaner::run()
{
	QStringList list;
	QDir d;

	setpriority(PRIO_PROCESS, 0, 19);

	d.setPath( livePath );
	list = d.entryList( "DVBLive-*", QDir::Files, QDir::Name );
	if ( list.count()>1 ) d.remove( list[0] );
}

#include "cleaner.moc"
