/*
 * Decompiled with CFR 0.152.
 */
package COM.sun.labs.jjtree;

import COM.sun.labs.javacc.Options;
import COM.sun.labs.jjtree.IO;
import COM.sun.labs.jjtree.JJTreeGlobals;
import COM.sun.labs.jjtree.NodeFiles;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

class JJTreeState {
    JJTreeState() {
    }

    static void generateTreeState_java() {
        String string = String.valueOf(NodeFiles.path()) + JJTreeState.nameState() + ".java";
        File file = new File(string);
        if (file.exists()) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string), 8096));
            NodeFiles.generatePrologue(printWriter, string);
            JJTreeState.insertState(printWriter);
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    static void insertParserMembers(IO iO) {
        String string = Options.B("STATIC") ? "static " : "";
        iO.println();
        iO.println("  protected " + string + JJTreeState.nameState() + " jjtree = new " + JJTreeState.nameState() + "();");
        iO.println();
    }

    private static void insertState(PrintWriter printWriter) {
        printWriter.println("class " + JJTreeState.nameState() + " {");
        printWriter.println("  private java.util.Stack nodes;");
        printWriter.println("  private java.util.Stack marks;");
        printWriter.println("");
        printWriter.println("  private int sp;\t\t// number of nodes on stack");
        printWriter.println("  private int mk;\t\t// current mark");
        printWriter.println("  private boolean node_created;");
        printWriter.println("");
        printWriter.println("  " + JJTreeState.nameState() + "() {");
        printWriter.println("    nodes = new java.util.Stack();");
        printWriter.println("    marks = new java.util.Stack();");
        printWriter.println("    sp = 0;");
        printWriter.println("    mk = 0;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  /* Determines whether the current node was actually closed and");
        printWriter.println("     pushed.  This should only be called in the final user action of a");
        printWriter.println("     node scope.  */");
        printWriter.println("  boolean nodeCreated() {");
        printWriter.println("    return node_created;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  /* Call this to reinitialize the node stack.  It is called");
        printWriter.println("     automatically by the parser's ReInit() method. */");
        printWriter.println("  void reset() {");
        printWriter.println("    nodes.removeAllElements();");
        printWriter.println("    marks.removeAllElements();");
        printWriter.println("    sp = 0;");
        printWriter.println("    mk = 0;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  /* Returns the root node of the AST.  It only makes sense to call");
        printWriter.println("     this after a successful parse. */");
        printWriter.println("  Node rootNode() {");
        printWriter.println("    return (Node)nodes.elementAt(0);");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  /* Pushes a node on to the stack. */");
        printWriter.println("  void pushNode(Node n) {");
        printWriter.println("    nodes.push(n);");
        printWriter.println("    ++sp;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  /* Returns the node on the top of the stack, and remove it from the");
        printWriter.println("     stack.  */");
        printWriter.println("  Node popNode() {");
        printWriter.println("    if (--sp < mk) {");
        printWriter.println("      mk = ((Integer)marks.pop()).intValue();");
        printWriter.println("    }");
        printWriter.println("    return (Node)nodes.pop();");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  /* Returns the node currently on the top of the stack. */");
        printWriter.println("  Node peekNode() {");
        printWriter.println("    return (Node)nodes.peek();");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  /* Returns the number of children on the stack in the current node");
        printWriter.println("     scope. */");
        printWriter.println("  int nodeArity() {");
        printWriter.println("    return sp - mk;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("");
        printWriter.println("  void clearNodeScope(Node n) {");
        printWriter.println("    while (sp > mk) {");
        printWriter.println("      popNode();");
        printWriter.println("    }");
        printWriter.println("    mk = ((Integer)marks.pop()).intValue();");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("");
        printWriter.println("  void openNodeScope(Node n) {");
        printWriter.println("    marks.push(new Integer(mk));");
        printWriter.println("    mk = sp;");
        printWriter.println("    n.jjtOpen();");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("");
        printWriter.println("  /* A definite node is constructed from a specified number of");
        printWriter.println("     children.  That number of nodes are popped from the stack and");
        printWriter.println("     made the children of the definite node.  Then the definite node");
        printWriter.println("     is pushed on to the stack. */");
        printWriter.println("  void closeNodeScope(Node n, int num) {");
        printWriter.println("    mk = ((Integer)marks.pop()).intValue();");
        printWriter.println("    while (num-- > 0) {");
        printWriter.println("      Node c = popNode();");
        printWriter.println("      c.jjtSetParent(n);");
        printWriter.println("      n.jjtAddChild(c, num);");
        printWriter.println("    }");
        printWriter.println("    n.jjtClose();");
        printWriter.println("    pushNode(n);");
        printWriter.println("    node_created = true;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("");
        printWriter.println("  /* A conditional node is constructed if its condition is true.  All");
        printWriter.println("     the nodes that have been pushed since the node was opened are");
        printWriter.println("     made children of the the conditional node, which is then pushed");
        printWriter.println("     on to the stack.  If the condition is false the node is not");
        printWriter.println("     constructed and they are left on the stack. */");
        printWriter.println("  void closeNodeScope(Node n, boolean condition) {");
        printWriter.println("    if (condition) {");
        printWriter.println("      int a = nodeArity();");
        printWriter.println("      mk = ((Integer)marks.pop()).intValue();");
        printWriter.println("      while (a-- > 0) {");
        printWriter.println("\tNode c = popNode();");
        printWriter.println("\tc.jjtSetParent(n);");
        printWriter.println("\tn.jjtAddChild(c, a);");
        printWriter.println("      }");
        printWriter.println("      n.jjtClose();");
        printWriter.println("      pushNode(n);");
        printWriter.println("      node_created = true;");
        printWriter.println("    } else {");
        printWriter.println("      mk = ((Integer)marks.pop()).intValue();");
        printWriter.println("      node_created = false;");
        printWriter.println("    }");
        printWriter.println("  }");
        printWriter.println("}");
    }

    private static String nameState() {
        return "JJT" + JJTreeGlobals.parserName + "State";
    }
}

