/*
 * Decompiled with CFR 0.152.
 */
package COM.sun.labs.jjdoc;

import COM.sun.labs.javacc.Expansion;
import COM.sun.labs.javacc.JavaCodeProduction;
import COM.sun.labs.javacc.NonTerminal;
import COM.sun.labs.javacc.NormalProduction;
import COM.sun.labs.javacc.Options;
import COM.sun.labs.javacc.RegularExpression;
import COM.sun.labs.jjdoc.Generator;
import COM.sun.labs.jjdoc.JJDocGlobals;
import java.io.PrintWriter;
import java.util.Hashtable;

public class HTMLGenerator
extends Generator {
    private Hashtable id_map = new Hashtable();
    private int id = 1;

    public HTMLGenerator(PrintWriter printWriter) {
        super(printWriter);
    }

    public void documentEnd() {
        this.println("</BODY>");
        this.println("</HTML>");
    }

    public void documentStart() {
        this.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
        this.println("<HTML>");
        this.println("<HEAD>");
        if (JJDocGlobals.input_file != null) {
            this.println("<TITLE>BNF for " + JJDocGlobals.input_file + "</TITLE>");
        } else {
            this.println("<TITLE>A BNF grammar by JJDoc</TITLE>");
        }
        this.println("</HEAD>");
        this.println("<BODY>");
        this.println("<H1 ALIGN=CENTER>BNF for " + JJDocGlobals.input_file + "</H1>");
    }

    public void expansionEnd(Expansion expansion, boolean bl) {
        this.println("</TD>");
        this.println("</TR>");
    }

    public void expansionStart(Expansion expansion, boolean bl) {
        if (!bl) {
            this.println("<TR>");
            this.println("<TD ALIGN=RIGHT VALIGN=BASELINE></TD>");
            this.println("<TD ALIGN=CENTER VALIGN=BASELINE>|</TD>");
            this.print("<TD ALIGN=LEFT VALIGN=BASELINE>");
        }
    }

    private String get_id(String string) {
        String string2 = (String)this.id_map.get(string);
        if (string2 == null) {
            string2 = "prod" + this.id++;
            this.id_map.put(string, string2);
        }
        return string2;
    }

    public void javacode(JavaCodeProduction javaCodeProduction) {
        this.productionStart(javaCodeProduction);
        this.println("<I>java code</I></TD></TR>");
        this.productionEnd(javaCodeProduction);
    }

    public void nonTerminalEnd(NonTerminal nonTerminal) {
        this.print("</A>");
    }

    public void nonTerminalStart(NonTerminal nonTerminal) {
        this.print("<A HREF=\"#" + this.get_id(nonTerminal.name) + "\">");
    }

    public void nonterminalsEnd() {
        if (Options.B("ONE_TABLE")) {
            this.println("</TABLE>");
        }
    }

    public void nonterminalsStart() {
        this.println("<H2 ALIGN=CENTER>NON-TERMINALS</H2>");
        if (Options.B("ONE_TABLE")) {
            this.println("<TABLE>");
        }
    }

    public void print(String string) {
        this.ostr.print(string);
    }

    private void println(String string) {
        this.print(String.valueOf(string) + "\n");
    }

    public void productionEnd(NormalProduction normalProduction) {
        if (!Options.B("ONE_TABLE")) {
            this.println("</TABLE>");
            this.println("<HR>");
        }
    }

    public void productionStart(NormalProduction normalProduction) {
        if (!Options.B("ONE_TABLE")) {
            this.println("");
            this.println("<TABLE ALIGN=CENTER>");
            this.println("<CAPTION><STRONG>" + normalProduction.lhs + "</STRONG></CAPTION>");
        }
        this.println("<TR>");
        this.println("<TD ALIGN=RIGHT VALIGN=BASELINE><A NAME=\"" + this.get_id(normalProduction.lhs) + "\">" + normalProduction.lhs + "</A></TD>");
        this.println("<TD ALIGN=CENTER VALIGN=BASELINE>::=</TD>");
        this.print("<TD ALIGN=LEFT VALIGN=BASELINE>");
    }

    public void reEnd(RegularExpression regularExpression) {
    }

    public void reStart(RegularExpression regularExpression) {
    }

    public void specialTokens(String string) {
        if (!Options.B("ONE_TABLE")) {
            this.println("<PRE>");
            this.print(string);
            this.println("</PRE>");
        }
    }

    public void text(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            string2 = string.charAt(n) == '<' ? String.valueOf(string2) + "&lt;" : (string.charAt(n) == '>' ? String.valueOf(string2) + "&gt;" : (string.charAt(n) == '&' ? String.valueOf(string2) + "&amp;" : String.valueOf(string2) + string.charAt(n)));
            ++n;
        }
        this.print(string2);
    }

    public void tokensEnd() {
        this.println("</TABLE>");
    }

    public void tokensStart() {
        this.println("<H2 ALIGN=CENTER>TOKENS</H2>");
        this.println("<TABLE>");
    }
}

