/*
 * Decompiled with CFR 0.152.
 */
package COM.sun.labs.javacc;

import COM.sun.labs.javacc.Expansion;
import COM.sun.labs.javacc.JavaCCErrors;
import COM.sun.labs.javacc.JavaCCGlobals;
import COM.sun.labs.javacc.JavaCCParser;
import COM.sun.labs.javacc.JavaCCParserInternals;
import COM.sun.labs.javacc.JavaFiles;
import COM.sun.labs.javacc.LexGen;
import COM.sun.labs.javacc.LookaheadWalk;
import COM.sun.labs.javacc.MatchInfo;
import COM.sun.labs.javacc.MetaParseException;
import COM.sun.labs.javacc.NfaState;
import COM.sun.labs.javacc.Options;
import COM.sun.labs.javacc.OtherFilesGen;
import COM.sun.labs.javacc.ParseEngine;
import COM.sun.labs.javacc.ParseException;
import COM.sun.labs.javacc.ParseGen;
import COM.sun.labs.javacc.RStringLiteral;
import COM.sun.labs.javacc.Semanticize;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;

public class Main {
    static void help_message() {
        System.out.println("Usage:");
        System.out.println("    javacc option-settings inputfile");
        System.out.println("");
        System.out.println("\"option-settings\" is a sequence of settings separated by spaces.");
        System.out.println("Each option setting must be of one of the following forms:");
        System.out.println("");
        System.out.println("    -optionname=value (e.g., -STATIC=false)");
        System.out.println("    -optionname:value (e.g., -STATIC:false)");
        System.out.println("    -optionname       (equivalent to -optionname=true.  e.g., -STATIC)");
        System.out.println("    -NOoptionname     (equivalent to -optionname=false. e.g., -NOSTATIC)");
        System.out.println("");
        System.out.println("Option settings are not case-sensitive, so one can say \"-nOsTaTiC\" instead");
        System.out.println("of \"-NOSTATIC\".  Option values must be appropriate for the corresponding");
        System.out.println("option, and must be either an integer, a boolean, or a string value.");
        System.out.println("");
        System.out.println("The integer valued options are:");
        System.out.println("");
        System.out.println("    LOOKAHEAD              (default 1)");
        System.out.println("    CHOICE_AMBIGUITY_CHECK (default 2)");
        System.out.println("    OTHER_AMBIGUITY_CHECK  (default 1)");
        System.out.println("");
        System.out.println("The boolean valued options are:");
        System.out.println("");
        System.out.println("    STATIC                 (default true)");
        System.out.println("    DEBUG_PARSER           (default false)");
        System.out.println("    DEBUG_LOOKAHEAD        (default false)");
        System.out.println("    DEBUG_TOKEN_MANAGER    (default false)");
        System.out.println("    OPTIMIZE_TOKEN_MANAGER (default true)");
        System.out.println("    ERROR_REPORTING        (default true)");
        System.out.println("    JAVA_UNICODE_ESCAPE    (default false)");
        System.out.println("    UNICODE_INPUT          (default false)");
        System.out.println("    IGNORE_CASE            (default false)");
        System.out.println("    COMMON_TOKEN_ACTION    (default false)");
        System.out.println("    USER_TOKEN_MANAGER     (default false)");
        System.out.println("    USER_CHAR_STREAM       (default false)");
        System.out.println("    BUILD_PARSER           (default true)");
        System.out.println("    BUILD_TOKEN_MANAGER    (default true)");
        System.out.println("    SANITY_CHECK           (default true)");
        System.out.println("    FORCE_LA_CHECK         (default false)");
        System.out.println("    CACHE_TOKENS           (default false)");
        System.out.println("    KEEP_LINE_COLUMN       (default true)");
        System.out.println("");
        System.out.println("The string valued options are:");
        System.out.println("");
        System.out.println("    OUTPUT_DIRECTORY       (default Current Directory)");
        System.out.println("");
        System.out.println("EXAMPLE:");
        System.out.println("    javacc -STATIC=false -LOOKAHEAD:2 -debug_parser mygrammar.jj");
        System.out.println("");
        System.out.println("ABOUT JavaCC:");
        System.out.println("    JavaCC is a parser generator for Java built by Sriram Sankar");
        System.out.println("    (sriram.sankar@webgain.com), Sreenivas Viswanadha (sreenivasa.viswanadha@webgain.com).");
        System.out.println("");
        System.out.println("    To learn more about JavaCC, please visit the JavaCC web site at:");
        System.out.println("                http://www.webgain.com/products/java_cc/");
        System.out.println("    If you wish to contact us, please send email to:");
        System.out.println("                javacc-support@webgain.com");
        System.out.println("    If you wish to be added to the mailing list, please send email to:");
        System.out.println("                javacc-interest-request@webgain.com");
        System.out.println("    To post to the mailing list, please send email to:");
        System.out.println("                javacc-interest@webgain.com");
        System.out.println("");
    }

    static boolean isOption(String string) {
        return string.length() > 1 && string.charAt(0) == '-';
    }

    public static void main(String[] stringArray) throws Exception {
        int n = Main.mainProgram(stringArray);
        System.exit(n);
    }

    public static int mainProgram(String[] stringArray) throws Exception {
        Main.reInitAll();
        JavaCCGlobals.bannerLine("Parser Generator", "");
        Options.JavaCCInit();
        JavaCCParser javaCCParser = null;
        if (stringArray.length == 0) {
            System.out.println("");
            Main.help_message();
            return 1;
        }
        System.out.println("(type \"javacc\" with no arguments for help)");
        if (Main.isOption(stringArray[stringArray.length - 1])) {
            System.out.println("Last argument \"" + stringArray[stringArray.length - 1] + "\" is not a filename.");
            return 1;
        }
        int n = 0;
        while (n < stringArray.length - 1) {
            if (!Main.isOption(stringArray[n])) {
                System.out.println("Argument \"" + stringArray[n] + "\" must be an option setting.");
                return 1;
            }
            Options.setCmdLineOption(stringArray[n]);
            ++n;
        }
        try {
            File file = new File(stringArray[stringArray.length - 1]);
            if (!file.exists()) {
                System.out.println("File " + stringArray[stringArray.length - 1] + " not found.");
                return 1;
            }
            if (file.isDirectory()) {
                System.out.println(String.valueOf(stringArray[stringArray.length - 1]) + " is a directory. Please use a valid file name.");
                return 1;
            }
            javaCCParser = new JavaCCParser(new FileReader(stringArray[stringArray.length - 1]));
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SecurityException securityException) {
            System.out.println("Security voilation while trying to open " + stringArray[stringArray.length - 1]);
            return 1;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File " + stringArray[stringArray.length - 1] + " not found.");
            return 1;
        }
        try {
            System.out.println("Reading from file " + stringArray[stringArray.length - 1] + " . . .");
            JavaCCGlobals.fileName = JavaCCGlobals.origFileName = stringArray[stringArray.length - 1];
            JavaCCGlobals.jjtreeGenerated = JavaCCGlobals.isGeneratedBy("JJTree", stringArray[stringArray.length - 1]);
            JavaCCGlobals.jjcovGenerated = JavaCCGlobals.isGeneratedBy("JJCov", stringArray[stringArray.length - 1]);
            JavaCCGlobals.toolNames = JavaCCGlobals.getToolNames(stringArray[stringArray.length - 1]);
            javaCCParser.javacc_input();
            JavaCCGlobals.setOutputDir();
            if (((Boolean)Options.optionValues.get("UNICODE_INPUT")).booleanValue()) {
                NfaState.unicodeWarningGiven = true;
                System.out.println("Note: UNICODE_INPUT option is specified. Please make sure you create the parser/lexer usig a Reader with the correct character encoding.");
            }
            Semanticize.start();
            ParseGen.start();
            LexGen.start();
            OtherFilesGen.start();
            if (JavaCCErrors.get_error_count() == 0 && (Options.B("BUILD_PARSER") || Options.B("BUILD_TOKEN_MANAGER"))) {
                if (JavaCCErrors.get_warning_count() == 0) {
                    System.out.println("Parser generated successfully.");
                } else {
                    System.out.println("Parser generated with 0 errors and " + JavaCCErrors.get_warning_count() + " warnings.");
                }
                return 0;
            }
            System.out.println("Detected " + JavaCCErrors.get_error_count() + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            return JavaCCErrors.get_error_count() == 0 ? 0 : 1;
        }
        catch (MetaParseException metaParseException) {
            System.out.println("Detected " + JavaCCErrors.get_error_count() + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            return 1;
        }
        catch (ParseException parseException) {
            System.out.println(parseException.toString());
            System.out.println("Detected " + (JavaCCErrors.get_error_count() + 1) + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            return 1;
        }
    }

    public static void reInitAll() {
        Expansion.reInit();
        JavaCCErrors.reInit();
        JavaCCGlobals.reInit();
        Options.reInit();
        JavaCCParserInternals.reInit();
        RStringLiteral.reInit();
        JavaFiles.reInit();
        LexGen.reInit();
        NfaState.reInit();
        MatchInfo.reInit();
        LookaheadWalk.reInit();
        Semanticize.reInit();
        ParseGen.reInit();
        OtherFilesGen.reInit();
        ParseEngine.reInit();
    }
}

