
/****************************************************************************
 *
 * Copyright (C) 2004 Ikke - http://www.eikke.com.  All rights reserved.
 *
 * This file is part of IVMan (ivm).
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Troll Tech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 * 
 * See http://www.troll.no/qpl for QPL licensing information.
 *
 * $Id: debug.c,v 1.9 2005/05/10 06:55:15 ro_han Exp $
 *****************************************************************************/

#include <stdarg.h>

#include "debug.h"
#include "log.h"


//If we arrive here DEBUG is enabled
void
debug(const char *format, const char *file, const int line,
      const char *func, ...)
{
    va_list app;

    va_start(app, func);

    if ((cfg_base == NULL)
        || ((cfg_base->debug == TRUE) && (isdaemon == FALSE)))
    {
        gchar *tmp = g_strdup_vprintf(format, app);

        g_print("%s:%d (%s) %s\n", file, line, func, tmp);
        g_free(tmp);

    } else if (cfg_base->debug == TRUE)
    {
        log_vdebug(format, app);
    }

}
