
/****************************************************************************
 *
 * Copyright (C) 2004 Ikke - http://www.eikke.com.  All rights reserved.
 *
 * This file is part of IVMan (ivm).
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Troll Tech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 * 
 * See http://www.troll.no/qpl for QPL licensing information.
 *
 * $Id: common.h,v 1.18 2005/05/12 01:42:33 ro_han Exp $
 *****************************************************************************/

#ifndef _COMMON_H
#define _COMMON_H
#ifdef HAVE_CONFIG_H
#include "../config.h"
#else
#error "No config.h!"
#endif

#ifndef __GNUC__
#define __FUNCTION__   ""
#endif

#include "debug.h"
#define DEBUG(fmt, arg...) debug(fmt, __FILE__, __LINE__, __FUNCTION__, ## arg)


#include <libhal.h>
#include "hal_compat.h"
LibHalContext *hal_ctx;

#include "dbus_interface.h"

#include "IvmConfig/IvmConfigBase.h"
IvmConfigBase * cfg_base;


#include <glib.h>
gboolean isdaemon;
gboolean usermode;
GHashTable *devices;
GHashTable *execuns;
GHashTable *pss;

#define xmlReadFailed(filename) DEBUG("Could not parse %s!\n\
    Please check this file for errors - read 'man %s' for some tips\n\
    (e.g., how to use special characters such as <,> and &).\n\
    Execution will continue, but rules in %s may not be executed.",filename,filename,filename);

#endif
