/* mpris2-controller.c generated by valac 0.16.1, the Vala compiler
 * generated from mpris2-controller.vala, do not modify */

/*
Copyright 2010 Canonical Ltd.

Authors:
    Conor Curran <conor.curran@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <common-defs.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/dbusmenu-glib.h>
#include <libdbusmenu-glib/enum-types.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <libdbusmenu-glib/types.h>
#include <gee.h>


#define TYPE_MPRIS2_CONTROLLER (mpris2_controller_get_type ())
#define MPRIS2_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS2_CONTROLLER, Mpris2Controller))
#define MPRIS2_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerClass))
#define IS_MPRIS2_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS2_CONTROLLER))
#define IS_MPRIS2_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MPRIS2_CONTROLLER))
#define MPRIS2_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerClass))

typedef struct _Mpris2Controller Mpris2Controller;
typedef struct _Mpris2ControllerClass Mpris2ControllerClass;
typedef struct _Mpris2ControllerPrivate Mpris2ControllerPrivate;

#define TYPE_MPRIS_ROOT (mpris_root_get_type ())
#define MPRIS_ROOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS_ROOT, MprisRoot))
#define IS_MPRIS_ROOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS_ROOT))
#define MPRIS_ROOT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MPRIS_ROOT, MprisRootIface))

typedef struct _MprisRoot MprisRoot;
typedef struct _MprisRootIface MprisRootIface;

#define TYPE_MPRIS_ROOT_PROXY (mpris_root_proxy_get_type ())

#define TYPE_MPRIS_PLAYER (mpris_player_get_type ())
#define MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS_PLAYER, MprisPlayer))
#define IS_MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS_PLAYER))
#define MPRIS_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MPRIS_PLAYER, MprisPlayerIface))

typedef struct _MprisPlayer MprisPlayer;
typedef struct _MprisPlayerIface MprisPlayerIface;

#define TYPE_MPRIS_PLAYER_PROXY (mpris_player_proxy_get_type ())

#define TYPE_MPRIS_PLAYLISTS (mpris_playlists_get_type ())
#define MPRIS_PLAYLISTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS_PLAYLISTS, MprisPlaylists))
#define IS_MPRIS_PLAYLISTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS_PLAYLISTS))
#define MPRIS_PLAYLISTS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MPRIS_PLAYLISTS, MprisPlaylistsIface))

typedef struct _MprisPlaylists MprisPlaylists;
typedef struct _MprisPlaylistsIface MprisPlaylistsIface;

#define TYPE_MPRIS_PLAYLISTS_PROXY (mpris_playlists_proxy_get_type ())

#define TYPE_PLAYLIST_DETAILS (playlist_details_get_type ())
typedef struct _PlaylistDetails PlaylistDetails;

#define TYPE_ACTIVE_PLAYLIST_CONTAINER (active_playlist_container_get_type ())
typedef struct _ActivePlaylistContainer ActivePlaylistContainer;

#define TYPE_FREE_DESKTOP_PROPERTIES (free_desktop_properties_get_type ())
#define FREE_DESKTOP_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FREE_DESKTOP_PROPERTIES, FreeDesktopProperties))
#define IS_FREE_DESKTOP_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FREE_DESKTOP_PROPERTIES))
#define FREE_DESKTOP_PROPERTIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FREE_DESKTOP_PROPERTIES, FreeDesktopPropertiesIface))

typedef struct _FreeDesktopProperties FreeDesktopProperties;
typedef struct _FreeDesktopPropertiesIface FreeDesktopPropertiesIface;

#define TYPE_FREE_DESKTOP_PROPERTIES_PROXY (free_desktop_properties_proxy_get_type ())

#define TYPE_PLAYER_CONTROLLER (player_controller_get_type ())
#define PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_CONTROLLER, PlayerController))
#define PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_CONTROLLER, PlayerControllerClass))
#define IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_CONTROLLER))
#define IS_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_CONTROLLER))
#define PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_CONTROLLER, PlayerControllerClass))

typedef struct _PlayerController PlayerController;
typedef struct _PlayerControllerClass PlayerControllerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _PlayerControllerPrivate PlayerControllerPrivate;

#define TYPE_PLAYER_ITEM (player_item_get_type ())
#define PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_ITEM, PlayerItem))
#define PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_ITEM, PlayerItemClass))
#define IS_PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_ITEM))
#define IS_PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_ITEM))
#define PLAYER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_ITEM, PlayerItemClass))

typedef struct _PlayerItem PlayerItem;
typedef struct _PlayerItemClass PlayerItemClass;

#define PLAYER_CONTROLLER_TYPE_WIDGET_ORDER (player_controller_widget_order_get_type ())

#define TYPE_TRANSPORT_MENUITEM (transport_menuitem_get_type ())
#define TRANSPORT_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSPORT_MENUITEM, TransportMenuitem))
#define TRANSPORT_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSPORT_MENUITEM, TransportMenuitemClass))
#define IS_TRANSPORT_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSPORT_MENUITEM))
#define IS_TRANSPORT_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSPORT_MENUITEM))
#define TRANSPORT_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSPORT_MENUITEM, TransportMenuitemClass))

typedef struct _TransportMenuitem TransportMenuitem;
typedef struct _TransportMenuitemClass TransportMenuitemClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_METADATA_MENUITEM (metadata_menuitem_get_type ())
#define METADATA_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_MENUITEM, MetadataMenuitem))
#define METADATA_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_MENUITEM, MetadataMenuitemClass))
#define IS_METADATA_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_MENUITEM))
#define IS_METADATA_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_MENUITEM))
#define METADATA_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_MENUITEM, MetadataMenuitemClass))

typedef struct _MetadataMenuitem MetadataMenuitem;
typedef struct _MetadataMenuitemClass MetadataMenuitemClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_PLAYLISTS_MENUITEM (playlists_menuitem_get_type ())
#define PLAYLISTS_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYLISTS_MENUITEM, PlaylistsMenuitem))
#define PLAYLISTS_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYLISTS_MENUITEM, PlaylistsMenuitemClass))
#define IS_PLAYLISTS_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYLISTS_MENUITEM))
#define IS_PLAYLISTS_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYLISTS_MENUITEM))
#define PLAYLISTS_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYLISTS_MENUITEM, PlaylistsMenuitemClass))

typedef struct _PlaylistsMenuitem PlaylistsMenuitem;
typedef struct _PlaylistsMenuitemClass PlaylistsMenuitemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Mpris2ControllerFetchPlaylistsData Mpris2ControllerFetchPlaylistsData;
#define _active_playlist_container_free0(var) ((var == NULL) ? NULL : (var = (active_playlist_container_free (var), NULL)))

struct _Mpris2Controller {
	GObject parent_instance;
	Mpris2ControllerPrivate * priv;
};

struct _Mpris2ControllerClass {
	GObjectClass parent_class;
};

struct _MprisRootIface {
	GTypeInterface parent_iface;
	void (*Quit) (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Quit_finish) (MprisRoot* self, GAsyncResult* _res_, GError** error);
	void (*Raise) (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Raise_finish) (MprisRoot* self, GAsyncResult* _res_, GError** error);
	gboolean (*get_HasTracklist) (MprisRoot* self);
	void (*set_HasTracklist) (MprisRoot* self, gboolean value);
	gboolean (*get_CanQuit) (MprisRoot* self);
	void (*set_CanQuit) (MprisRoot* self, gboolean value);
	gboolean (*get_CanRaise) (MprisRoot* self);
	void (*set_CanRaise) (MprisRoot* self, gboolean value);
	gchar* (*get_Identity) (MprisRoot* self);
	void (*set_Identity) (MprisRoot* self, const gchar* value);
	gchar* (*get_DesktopEntry) (MprisRoot* self);
	void (*set_DesktopEntry) (MprisRoot* self, const gchar* value);
};

struct _MprisPlayerIface {
	GTypeInterface parent_iface;
	void (*PlayPause) (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*PlayPause_finish) (MprisPlayer* self, GAsyncResult* _res_, GError** error);
	void (*Next) (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Next_finish) (MprisPlayer* self, GAsyncResult* _res_, GError** error);
	void (*Previous) (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Previous_finish) (MprisPlayer* self, GAsyncResult* _res_, GError** error);
	void (*Seek) (MprisPlayer* self, gint64 offset, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Seek_finish) (MprisPlayer* self, GAsyncResult* _res_, GError** error);
	GHashTable* (*get_Metadata) (MprisPlayer* self);
	void (*set_Metadata) (MprisPlayer* self, GHashTable* value);
	gint32 (*get_Position) (MprisPlayer* self);
	void (*set_Position) (MprisPlayer* self, gint32 value);
	gchar* (*get_PlaybackStatus) (MprisPlayer* self);
	void (*set_PlaybackStatus) (MprisPlayer* self, const gchar* value);
};

struct _PlaylistDetails {
	char* path;
	gchar* name;
	gchar* icon_path;
};

struct _ActivePlaylistContainer {
	gboolean valid;
	PlaylistDetails* details;
};

struct _MprisPlaylistsIface {
	GTypeInterface parent_iface;
	void (*ActivatePlaylist) (MprisPlaylists* self, const char* playlist_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*ActivatePlaylist_finish) (MprisPlaylists* self, GAsyncResult* _res_, GError** error);
	void (*GetPlaylists) (MprisPlaylists* self, guint32 index, guint32 max_count, const gchar* order, gboolean reverse_order, GAsyncReadyCallback _callback_, gpointer _user_data_);
	PlaylistDetails* (*GetPlaylists_finish) (MprisPlaylists* self, GAsyncResult* _res_, int* result_length1, GError** error);
	gchar** (*get_Orderings) (MprisPlaylists* self, int* result_length1);
	void (*set_Orderings) (MprisPlaylists* self, gchar** value, int value_length1);
	guint32 (*get_PlaylistCount) (MprisPlaylists* self);
	void (*set_PlaylistCount) (MprisPlaylists* self, guint32 value);
	ActivePlaylistContainer* (*get_ActivePlaylist) (MprisPlaylists* self);
	void (*set_ActivePlaylist) (MprisPlaylists* self, ActivePlaylistContainer* value);
};

struct _FreeDesktopPropertiesIface {
	GTypeInterface parent_iface;
};

struct _Mpris2ControllerPrivate {
	MprisRoot* _mpris2_root;
	MprisPlayer* _player;
	MprisPlaylists* _playlists;
	FreeDesktopProperties* _properties_interface;
	PlayerController* _owner;
};

struct _PlayerController {
	GObject parent_instance;
	PlayerControllerPrivate * priv;
	gint current_state;
	DbusmenuMenuitem* root_menu;
	GeeArrayList* custom_items;
	Mpris2Controller* mpris_bridge;
	gboolean* use_playlists;
};

struct _PlayerControllerClass {
	GObjectClass parent_class;
};

typedef enum  {
	PLAYER_CONTROLLER_WIDGET_ORDER_SEPARATOR,
	PLAYER_CONTROLLER_WIDGET_ORDER_METADATA,
	PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT,
	PLAYER_CONTROLLER_WIDGET_ORDER_PLAYLISTS
} PlayerControllerwidget_order;

struct _Mpris2ControllerFetchPlaylistsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Mpris2Controller* self;
	PlaylistDetails* current_playlists;
	gint current_playlists_length1;
	gint _current_playlists_size_;
	MprisPlaylists* _tmp0_;
	gint _tmp1_;
	PlaylistDetails* _tmp2_;
	PlaylistDetails* _tmp3_;
	gint _tmp3__length1;
	gint __tmp3__size_;
	GError* e;
	PlaylistDetails* _tmp4_;
	gint _tmp4__length1;
	PlayerController* _tmp5_;
	GeeArrayList* _tmp6_;
	gpointer _tmp7_;
	PlaylistsMenuitem* playlists_item;
	PlaylistsMenuitem* _tmp8_;
	PlaylistDetails* _tmp9_;
	gint _tmp9__length1;
	PlayerController* _tmp10_;
	GAppInfo* _tmp11_;
	GAppInfo* _tmp12_;
	const gchar* _tmp13_;
	PlayerController* _tmp14_;
	gboolean _tmp15_;
	gboolean* _tmp16_;
	GError * _inner_error_;
};


static gpointer mpris2_controller_parent_class = NULL;

GType mpris2_controller_get_type (void) G_GNUC_CONST;
GType mpris_root_proxy_get_type (void) G_GNUC_CONST;
guint mpris_root_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType mpris_root_get_type (void) G_GNUC_CONST;
GType mpris_player_proxy_get_type (void) G_GNUC_CONST;
guint mpris_player_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType mpris_player_get_type (void) G_GNUC_CONST;
GType mpris_playlists_proxy_get_type (void) G_GNUC_CONST;
guint mpris_playlists_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType playlist_details_get_type (void) G_GNUC_CONST;
PlaylistDetails* playlist_details_dup (const PlaylistDetails* self);
void playlist_details_free (PlaylistDetails* self);
void playlist_details_copy (const PlaylistDetails* self, PlaylistDetails* dest);
void playlist_details_destroy (PlaylistDetails* self);
GType active_playlist_container_get_type (void) G_GNUC_CONST;
ActivePlaylistContainer* active_playlist_container_dup (const ActivePlaylistContainer* self);
void active_playlist_container_free (ActivePlaylistContainer* self);
void active_playlist_container_copy (const ActivePlaylistContainer* self, ActivePlaylistContainer* dest);
void active_playlist_container_destroy (ActivePlaylistContainer* self);
GType mpris_playlists_get_type (void) G_GNUC_CONST;
GType free_desktop_properties_get_type (void) G_GNUC_CONST;
GType free_desktop_properties_proxy_get_type (void) G_GNUC_CONST;
guint free_desktop_properties_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType player_controller_get_type (void) G_GNUC_CONST;
#define MPRIS2_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerPrivate))
enum  {
	MPRIS2_CONTROLLER_DUMMY_PROPERTY,
	MPRIS2_CONTROLLER_MPRIS2_ROOT,
	MPRIS2_CONTROLLER_PLAYER,
	MPRIS2_CONTROLLER_PLAYLISTS,
	MPRIS2_CONTROLLER_PROPERTIES_INTERFACE,
	MPRIS2_CONTROLLER_OWNER
};
#define MPRIS2_CONTROLLER_MAX_PLAYLIST_COUNT 100
Mpris2Controller* mpris2_controller_new (PlayerController* ctrl);
Mpris2Controller* mpris2_controller_construct (GType object_type, PlayerController* ctrl);
void mpris2_controller_property_changed_cb (Mpris2Controller* self, const gchar* interface_source, GHashTable* changed_properties, gchar** invalid, int invalid_length1);
#define MPRIS_PREFIX "org.mpris.MediaPlayer2."
MprisPlayer* mpris2_controller_get_player (Mpris2Controller* self);
gchar* mpris_player_get_PlaybackStatus (MprisPlayer* self);
static gboolean mpris2_controller_ensure_correct_playback_status (Mpris2Controller* self);
static gboolean _mpris2_controller_ensure_correct_playback_status_gsource_func (gpointer self);
static TransportState mpris2_controller_determine_play_state (Mpris2Controller* self, const gchar* status);
PlayerController* mpris2_controller_get_owner (Mpris2Controller* self);
GType player_item_get_type (void) G_GNUC_CONST;
GType player_controller_widget_order_get_type (void) G_GNUC_CONST;
GType transport_menuitem_get_type (void) G_GNUC_CONST;
void transport_menuitem_change_play_state (TransportMenuitem* self, TransportState update);
static gboolean mpris2_controller_ensure_correct_metadata (Mpris2Controller* self);
static gboolean _mpris2_controller_ensure_correct_metadata_gsource_func (gpointer self);
static gboolean _bool_equal (const gboolean* s1, const gboolean* s2);
static gboolean mpris2_controller_fetch_active_playlist (Mpris2Controller* self);
static gboolean _mpris2_controller_fetch_active_playlist_gsource_func (gpointer self);
void mpris2_controller_fetch_playlists (Mpris2Controller* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris2_controller_fetch_playlists_finish (Mpris2Controller* self, GAsyncResult* _res_);
GType metadata_menuitem_get_type (void) G_GNUC_CONST;
void metadata_menuitem_alter_label (MetadataMenuitem* self, const gchar* new_title);
MprisRoot* mpris2_controller_get_mpris2_root (Mpris2Controller* self);
gchar* mpris_root_get_Identity (MprisRoot* self);
static GHashTable* mpris2_controller_clean_metadata (Mpris2Controller* self);
void player_item_reset (PlayerItem* self, GeeHashSet* attrs);
GeeHashSet* metadata_menuitem_relevant_attributes_for_ui (void);
void player_item_update (PlayerItem* self, GHashTable* data, GeeHashSet* attributes);
gboolean player_item_populated (PlayerItem* self, GeeHashSet* attrs);
void metadata_menuitem_should_collapse (MetadataMenuitem* self, gboolean collapse);
GHashTable* mpris_player_get_Metadata (MprisPlayer* self);
static GVariant* _variant_new1 (const gchar* value);
void mpris2_controller_initial_update (Mpris2Controller* self);
GeeHashSet* metadata_menuitem_attributes_format (void);
void mpris2_controller_transport_update (Mpris2Controller* self, TransportAction command);
void mpris_player_PlayPause (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_player_PlayPause_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
void mpris_player_Previous (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_player_Previous_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
void mpris_player_Next (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_player_Next_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
void mpris_player_Seek (MprisPlayer* self, gint64 offset, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_player_Seek_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
gboolean mpris2_controller_connected (Mpris2Controller* self);
void mpris2_controller_expose (Mpris2Controller* self);
void mpris_root_Raise (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_root_Raise_finish (MprisRoot* self, GAsyncResult* _res_, GError** error);
static void mpris2_controller_on_playlistdetails_changed (Mpris2Controller* self, PlaylistDetails* details);
GType playlists_menuitem_get_type (void) G_GNUC_CONST;
void playlists_menuitem_update_individual_playlist (PlaylistsMenuitem* self, PlaylistDetails* new_detail);
static void mpris2_controller_fetch_playlists_data_free (gpointer _data);
static gboolean mpris2_controller_fetch_playlists_co (Mpris2ControllerFetchPlaylistsData* _data_);
MprisPlaylists* mpris2_controller_get_playlists (Mpris2Controller* self);
void mpris_playlists_GetPlaylists (MprisPlaylists* self, guint32 index, guint32 max_count, const gchar* order, gboolean reverse_order, GAsyncReadyCallback _callback_, gpointer _user_data_);
PlaylistDetails* mpris_playlists_GetPlaylists_finish (MprisPlaylists* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void mpris2_controller_fetch_playlists_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_PlaylistDetails_array_free (PlaylistDetails* array, gint array_length);
void playlists_menuitem_update (PlaylistsMenuitem* self, PlaylistDetails* playlists, int playlists_length1);
GAppInfo* player_controller_get_app_info (PlayerController* self);
static gboolean* _bool_dup (gboolean* self);
static gboolean mpris2_controller_validate_playlists_details (Mpris2Controller* self);
ActivePlaylistContainer* mpris_playlists_get_ActivePlaylist (MprisPlaylists* self);
void playlists_menuitem_active_playlist_update (PlaylistsMenuitem* self, PlaylistDetails* detail);
void mpris2_controller_activate_playlist (Mpris2Controller* self, const char* path);
void mpris_playlists_ActivatePlaylist (MprisPlaylists* self, const char* playlist_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_playlists_ActivatePlaylist_finish (MprisPlaylists* self, GAsyncResult* _res_, GError** error);
static void mpris2_controller_set_mpris2_root (Mpris2Controller* self, MprisRoot* value);
static void mpris2_controller_set_player (Mpris2Controller* self, MprisPlayer* value);
static void mpris2_controller_set_playlists (Mpris2Controller* self, MprisPlaylists* value);
FreeDesktopProperties* mpris2_controller_get_properties_interface (Mpris2Controller* self);
static void mpris2_controller_set_properties_interface (Mpris2Controller* self, FreeDesktopProperties* value);
static void mpris2_controller_set_owner (Mpris2Controller* self, PlayerController* value);
static GObject * mpris2_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
const gchar* player_controller_get_dbus_name (PlayerController* self);
static void _mpris2_controller_property_changed_cb_free_desktop_properties_properties_changed (FreeDesktopProperties* _sender, const gchar* source, GHashTable* changed_properties, gchar** invalid, int invalid_length1, gpointer self);
static void _mpris2_controller_on_playlistdetails_changed_mpris_playlists_playlist_changed (MprisPlaylists* _sender, PlaylistDetails* details, gpointer self);
static void mpris2_controller_finalize (GObject* obj);
static void _vala_mpris2_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_mpris2_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


Mpris2Controller* mpris2_controller_construct (GType object_type, PlayerController* ctrl) {
	Mpris2Controller * self = NULL;
	PlayerController* _tmp0_;
	g_return_val_if_fail (ctrl != NULL, NULL);
	_tmp0_ = ctrl;
	self = (Mpris2Controller*) g_object_new (object_type, "owner", _tmp0_, NULL);
	return self;
}


Mpris2Controller* mpris2_controller_new (PlayerController* ctrl) {
	return mpris2_controller_construct (TYPE_MPRIS2_CONTROLLER, ctrl);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static gboolean _mpris2_controller_ensure_correct_playback_status_gsource_func (gpointer self) {
	gboolean result;
	result = mpris2_controller_ensure_correct_playback_status (self);
	return result;
}


static gboolean _mpris2_controller_ensure_correct_metadata_gsource_func (gpointer self) {
	gboolean result;
	result = mpris2_controller_ensure_correct_metadata (self);
	return result;
}


static gboolean _bool_equal (const gboolean* s1, const gboolean* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static gboolean _mpris2_controller_fetch_active_playlist_gsource_func (gpointer self) {
	gboolean result;
	result = mpris2_controller_fetch_active_playlist (self);
	return result;
}


void mpris2_controller_property_changed_cb (Mpris2Controller* self, const gchar* interface_source, GHashTable* changed_properties, gchar** invalid, int invalid_length1) {
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	gboolean _tmp4_;
	GHashTable* _tmp5_;
	gconstpointer _tmp6_ = NULL;
	GVariant* _tmp7_;
	GVariant* play_v;
	GVariant* _tmp8_;
	GHashTable* _tmp19_;
	gconstpointer _tmp20_ = NULL;
	GVariant* _tmp21_;
	GVariant* meta_v;
	GVariant* _tmp22_;
	GHashTable* _tmp23_;
	gconstpointer _tmp24_ = NULL;
	GVariant* _tmp25_;
	GVariant* playlist_v;
	gboolean _tmp26_ = FALSE;
	GVariant* _tmp27_;
	gboolean _tmp31_;
	GHashTable* _tmp32_;
	gconstpointer _tmp33_ = NULL;
	GVariant* _tmp34_;
	GVariant* playlist_count_v;
	gboolean _tmp35_ = FALSE;
	GVariant* _tmp36_;
	gboolean _tmp40_;
	GHashTable* _tmp41_;
	gconstpointer _tmp42_ = NULL;
	GVariant* _tmp43_;
	GVariant* playlist_orderings_v;
	gboolean _tmp44_ = FALSE;
	GVariant* _tmp45_;
	gboolean _tmp49_;
	GHashTable* _tmp50_;
	gconstpointer _tmp51_ = NULL;
	GVariant* _tmp52_;
	GVariant* identity_v;
	GVariant* _tmp53_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_source != NULL);
	g_return_if_fail (changed_properties != NULL);
	_tmp1_ = changed_properties;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = interface_source;
		_tmp3_ = g_str_has_prefix (_tmp2_, MPRIS_PREFIX);
		_tmp0_ = _tmp3_ == FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		g_warning ("mpris2-controller.vala:78: Property-changed hash is null or this is an" \
" interface that doesn't concern us");
		return;
	}
	_tmp5_ = changed_properties;
	_tmp6_ = g_hash_table_lookup (_tmp5_, "PlaybackStatus");
	_tmp7_ = _g_variant_ref0 ((GVariant*) _tmp6_);
	play_v = _tmp7_;
	_tmp8_ = play_v;
	if (_tmp8_ != NULL) {
		MprisPlayer* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* state;
		const gchar* _tmp12_;
		TransportState _tmp13_ = 0;
		TransportState p;
		PlayerController* _tmp14_;
		GeeArrayList* _tmp15_;
		gpointer _tmp16_ = NULL;
		TransportMenuitem* _tmp17_;
		TransportState _tmp18_;
		_tmp9_ = self->priv->_player;
		_tmp10_ = mpris_player_get_PlaybackStatus (_tmp9_);
		_tmp11_ = _tmp10_;
		state = _tmp11_;
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _mpris2_controller_ensure_correct_playback_status_gsource_func, g_object_ref (self), g_object_unref);
		_tmp12_ = state;
		_tmp13_ = mpris2_controller_determine_play_state (self, _tmp12_);
		p = (TransportState) _tmp13_;
		_tmp14_ = self->priv->_owner;
		_tmp15_ = _tmp14_->custom_items;
		_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT);
		_tmp17_ = IS_TRANSPORT_MENUITEM ((PlayerItem*) _tmp16_) ? ((TransportMenuitem*) ((PlayerItem*) _tmp16_)) : NULL;
		_tmp18_ = p;
		transport_menuitem_change_play_state (_tmp17_, _tmp18_);
		_g_object_unref0 (_tmp17_);
		_g_free0 (state);
	}
	_tmp19_ = changed_properties;
	_tmp20_ = g_hash_table_lookup (_tmp19_, "Metadata");
	_tmp21_ = _g_variant_ref0 ((GVariant*) _tmp20_);
	meta_v = _tmp21_;
	_tmp22_ = meta_v;
	if (_tmp22_ != NULL) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _mpris2_controller_ensure_correct_metadata_gsource_func, g_object_ref (self), g_object_unref);
	}
	_tmp23_ = changed_properties;
	_tmp24_ = g_hash_table_lookup (_tmp23_, "ActivePlaylist");
	_tmp25_ = _g_variant_ref0 ((GVariant*) _tmp24_);
	playlist_v = _tmp25_;
	_tmp27_ = playlist_v;
	if (_tmp27_ != NULL) {
		PlayerController* _tmp28_;
		gboolean* _tmp29_;
		gboolean _tmp30_;
		_tmp28_ = self->priv->_owner;
		_tmp29_ = _tmp28_->use_playlists;
		_tmp30_ = TRUE;
		_tmp26_ = _bool_equal (_tmp29_, &_tmp30_) == TRUE;
	} else {
		_tmp26_ = FALSE;
	}
	_tmp31_ = _tmp26_;
	if (_tmp31_) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, _mpris2_controller_fetch_active_playlist_gsource_func, g_object_ref (self), g_object_unref);
	}
	_tmp32_ = changed_properties;
	_tmp33_ = g_hash_table_lookup (_tmp32_, "PlaylistCount");
	_tmp34_ = _g_variant_ref0 ((GVariant*) _tmp33_);
	playlist_count_v = _tmp34_;
	_tmp36_ = playlist_count_v;
	if (_tmp36_ != NULL) {
		PlayerController* _tmp37_;
		gboolean* _tmp38_;
		gboolean _tmp39_;
		_tmp37_ = self->priv->_owner;
		_tmp38_ = _tmp37_->use_playlists;
		_tmp39_ = TRUE;
		_tmp35_ = _bool_equal (_tmp38_, &_tmp39_) == TRUE;
	} else {
		_tmp35_ = FALSE;
	}
	_tmp40_ = _tmp35_;
	if (_tmp40_) {
		mpris2_controller_fetch_playlists (self, NULL, NULL);
		mpris2_controller_fetch_active_playlist (self);
	}
	_tmp41_ = changed_properties;
	_tmp42_ = g_hash_table_lookup (_tmp41_, "Orderings");
	_tmp43_ = _g_variant_ref0 ((GVariant*) _tmp42_);
	playlist_orderings_v = _tmp43_;
	_tmp45_ = playlist_orderings_v;
	if (_tmp45_ != NULL) {
		PlayerController* _tmp46_;
		gboolean* _tmp47_;
		gboolean _tmp48_;
		_tmp46_ = self->priv->_owner;
		_tmp47_ = _tmp46_->use_playlists;
		_tmp48_ = TRUE;
		_tmp44_ = _bool_equal (_tmp47_, &_tmp48_) == TRUE;
	} else {
		_tmp44_ = FALSE;
	}
	_tmp49_ = _tmp44_;
	if (_tmp49_) {
		mpris2_controller_fetch_playlists (self, NULL, NULL);
		mpris2_controller_fetch_active_playlist (self);
	}
	_tmp50_ = changed_properties;
	_tmp51_ = g_hash_table_lookup (_tmp50_, "Identity");
	_tmp52_ = _g_variant_ref0 ((GVariant*) _tmp51_);
	identity_v = _tmp52_;
	_tmp53_ = identity_v;
	if (_tmp53_ != NULL) {
		PlayerController* _tmp54_;
		GeeArrayList* _tmp55_;
		gpointer _tmp56_ = NULL;
		MetadataMenuitem* md;
		MetadataMenuitem* _tmp57_;
		MprisRoot* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		_tmp54_ = self->priv->_owner;
		_tmp55_ = _tmp54_->custom_items;
		_tmp56_ = gee_abstract_list_get ((GeeAbstractList*) _tmp55_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA);
		md = IS_METADATA_MENUITEM ((PlayerItem*) _tmp56_) ? ((MetadataMenuitem*) ((PlayerItem*) _tmp56_)) : NULL;
		_tmp57_ = md;
		_tmp58_ = self->priv->_mpris2_root;
		_tmp59_ = mpris_root_get_Identity (_tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = _tmp60_;
		metadata_menuitem_alter_label (_tmp57_, _tmp61_);
		_g_free0 (_tmp61_);
		_g_object_unref0 (md);
	}
	_g_variant_unref0 (identity_v);
	_g_variant_unref0 (playlist_orderings_v);
	_g_variant_unref0 (playlist_count_v);
	_g_variant_unref0 (playlist_v);
	_g_variant_unref0 (meta_v);
	_g_variant_unref0 (play_v);
}


static gboolean mpris2_controller_ensure_correct_metadata (Mpris2Controller* self) {
	gboolean result = FALSE;
	GHashTable* _tmp0_ = NULL;
	GHashTable* changed_updates;
	PlayerController* _tmp1_;
	GeeArrayList* _tmp2_;
	gpointer _tmp3_ = NULL;
	PlayerItem* metadata;
	GeeHashSet* _tmp4_ = NULL;
	GeeHashSet* _tmp5_;
	GeeHashSet* _tmp6_ = NULL;
	GeeHashSet* _tmp7_;
	PlayerController* _tmp8_;
	GeeArrayList* _tmp9_;
	gpointer _tmp10_ = NULL;
	MetadataMenuitem* md;
	GeeHashSet* _tmp11_ = NULL;
	GeeHashSet* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	gboolean collapsing;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mpris2_controller_clean_metadata (self);
	changed_updates = _tmp0_;
	_tmp1_ = self->priv->_owner;
	_tmp2_ = _tmp1_->custom_items;
	_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tmp2_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA);
	metadata = (PlayerItem*) _tmp3_;
	_tmp4_ = metadata_menuitem_relevant_attributes_for_ui ();
	_tmp5_ = _tmp4_;
	player_item_reset (metadata, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = metadata_menuitem_relevant_attributes_for_ui ();
	_tmp7_ = _tmp6_;
	player_item_update (metadata, changed_updates, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = self->priv->_owner;
	_tmp9_ = _tmp8_->custom_items;
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA);
	md = IS_METADATA_MENUITEM ((PlayerItem*) _tmp10_) ? ((MetadataMenuitem*) ((PlayerItem*) _tmp10_)) : NULL;
	_tmp11_ = metadata_menuitem_relevant_attributes_for_ui ();
	_tmp12_ = _tmp11_;
	_tmp13_ = player_item_populated (metadata, _tmp12_);
	_tmp14_ = !_tmp13_;
	_g_object_unref0 (_tmp12_);
	collapsing = _tmp14_;
	metadata_menuitem_should_collapse (md, collapsing);
	result = FALSE;
	_g_object_unref0 (md);
	_g_object_unref0 (metadata);
	_g_hash_table_unref0 (changed_updates);
	return result;
}


static gboolean mpris2_controller_ensure_correct_playback_status (Mpris2Controller* self) {
	gboolean result = FALSE;
	MprisPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	TransportState _tmp4_ = 0;
	TransportState _tmp5_;
	TransportState p;
	PlayerController* _tmp6_;
	GeeArrayList* _tmp7_;
	gpointer _tmp8_ = NULL;
	TransportMenuitem* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_player;
	_tmp1_ = mpris_player_get_PlaybackStatus (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = mpris2_controller_determine_play_state (self, _tmp3_);
	_tmp5_ = (TransportState) _tmp4_;
	_g_free0 (_tmp3_);
	p = _tmp5_;
	_tmp6_ = self->priv->_owner;
	_tmp7_ = _tmp6_->custom_items;
	_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT);
	_tmp9_ = IS_TRANSPORT_MENUITEM ((PlayerItem*) _tmp8_) ? ((TransportMenuitem*) ((PlayerItem*) _tmp8_)) : NULL;
	transport_menuitem_change_play_state (_tmp9_, p);
	_g_object_unref0 (_tmp9_);
	result = FALSE;
	return result;
}


static GVariant* _variant_new1 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GHashTable* mpris2_controller_clean_metadata (Mpris2Controller* self) {
	GHashTable* result = NULL;
	MprisPlayer* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* changed_updates;
	MprisPlayer* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	gconstpointer _tmp7_ = NULL;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	GVariant* artist_v;
	GVariant* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_player;
	_tmp1_ = mpris_player_get_Metadata (_tmp0_);
	_tmp2_ = _tmp1_;
	changed_updates = _tmp2_;
	_tmp3_ = self->priv->_player;
	_tmp4_ = mpris_player_get_Metadata (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = g_hash_table_lookup (_tmp6_, "xesam:artist");
	_tmp8_ = _g_variant_ref0 ((GVariant*) _tmp7_);
	_tmp9_ = _tmp8_;
	_g_hash_table_unref0 (_tmp6_);
	artist_v = _tmp9_;
	_tmp10_ = artist_v;
	if (_tmp10_ != NULL) {
		gchar* display_artists = NULL;
		GVariant* _tmp11_;
		const gchar* _tmp12_ = NULL;
		GHashTable* _tmp21_;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		GVariant* _tmp24_;
		_tmp11_ = artist_v;
		_tmp12_ = g_variant_get_type_string (_tmp11_);
		if (g_strcmp0 (_tmp12_, "s") == 0) {
			GVariant* _tmp13_;
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			_tmp13_ = artist_v;
			_tmp14_ = g_variant_get_string (_tmp13_, NULL);
			_tmp15_ = g_strdup (_tmp14_);
			_g_free0 (display_artists);
			display_artists = _tmp15_;
		} else {
			GVariant* _tmp16_;
			size_t _tmp17_;
			gchar** _tmp18_ = NULL;
			gchar** artists;
			gint artists_length1;
			gint _artists_size_;
			gchar** _tmp19_;
			gint _tmp19__length1;
			gchar* _tmp20_ = NULL;
			_tmp16_ = artist_v;
			_tmp18_ = g_variant_dup_strv (_tmp16_, &_tmp17_);
			artists = _tmp18_;
			artists_length1 = _tmp17_;
			_artists_size_ = artists_length1;
			_tmp19_ = artists;
			_tmp19__length1 = artists_length1;
			_tmp20_ = g_strjoinv (", ", _tmp19_);
			_g_free0 (display_artists);
			display_artists = _tmp20_;
			artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp21_ = changed_updates;
		_tmp22_ = g_strdup ("xesam:artist");
		_tmp23_ = display_artists;
		_tmp24_ = _variant_new1 (_tmp23_);
		g_hash_table_replace (_tmp21_, _tmp22_, _tmp24_);
		_g_free0 (display_artists);
	}
	result = changed_updates;
	_g_variant_unref0 (artist_v);
	return result;
}


static TransportState mpris2_controller_determine_play_state (Mpris2Controller* self, const gchar* status) {
	TransportState result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = status;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = status;
		_tmp0_ = g_strcmp0 (_tmp2_, "Playing") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		result = TRANSPORT_STATE_PLAYING;
		return result;
	}
	result = TRANSPORT_STATE_PAUSED;
	return result;
}


void mpris2_controller_initial_update (Mpris2Controller* self) {
	TransportState update = 0;
	MprisPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	MprisRoot* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	PlayerController* _tmp23_;
	GeeArrayList* _tmp24_;
	gpointer _tmp25_ = NULL;
	TransportMenuitem* _tmp26_;
	TransportState _tmp27_;
	GHashTable* _tmp28_ = NULL;
	GHashTable* cleaned_metadata;
	PlayerController* _tmp29_;
	GeeArrayList* _tmp30_;
	gpointer _tmp31_ = NULL;
	PlayerItem* _tmp32_;
	GHashTable* _tmp33_;
	GeeHashSet* _tmp34_ = NULL;
	GeeHashSet* _tmp35_;
	PlayerController* _tmp36_;
	gboolean* _tmp37_;
	gboolean _tmp38_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_player;
	_tmp1_ = mpris_player_get_PlaybackStatus (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ == NULL;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		update = TRANSPORT_STATE_PAUSED;
	} else {
		MprisPlayer* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		TransportState _tmp9_ = 0;
		_tmp5_ = self->priv->_player;
		_tmp6_ = mpris_player_get_PlaybackStatus (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = mpris2_controller_determine_play_state (self, _tmp8_);
		update = _tmp9_;
		_g_free0 (_tmp8_);
	}
	_tmp10_ = self->priv->_mpris2_root;
	_tmp11_ = mpris_root_get_Identity (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_ != NULL;
	_g_free0 (_tmp13_);
	if (_tmp14_) {
		PlayerController* _tmp15_;
		GeeArrayList* _tmp16_;
		gpointer _tmp17_ = NULL;
		MetadataMenuitem* md;
		MetadataMenuitem* _tmp18_;
		MprisRoot* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp15_ = self->priv->_owner;
		_tmp16_ = _tmp15_->custom_items;
		_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA);
		md = IS_METADATA_MENUITEM ((PlayerItem*) _tmp17_) ? ((MetadataMenuitem*) ((PlayerItem*) _tmp17_)) : NULL;
		_tmp18_ = md;
		_tmp19_ = self->priv->_mpris2_root;
		_tmp20_ = mpris_root_get_Identity (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_;
		metadata_menuitem_alter_label (_tmp18_, _tmp22_);
		_g_free0 (_tmp22_);
		_g_object_unref0 (md);
	}
	_tmp23_ = self->priv->_owner;
	_tmp24_ = _tmp23_->custom_items;
	_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT);
	_tmp26_ = IS_TRANSPORT_MENUITEM ((PlayerItem*) _tmp25_) ? ((TransportMenuitem*) ((PlayerItem*) _tmp25_)) : NULL;
	_tmp27_ = update;
	transport_menuitem_change_play_state (_tmp26_, _tmp27_);
	_g_object_unref0 (_tmp26_);
	_tmp28_ = mpris2_controller_clean_metadata (self);
	cleaned_metadata = _tmp28_;
	_tmp29_ = self->priv->_owner;
	_tmp30_ = _tmp29_->custom_items;
	_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA);
	_tmp32_ = (PlayerItem*) _tmp31_;
	_tmp33_ = cleaned_metadata;
	_tmp34_ = metadata_menuitem_attributes_format ();
	_tmp35_ = _tmp34_;
	player_item_update (_tmp32_, _tmp33_, _tmp35_);
	_g_object_unref0 (_tmp35_);
	_g_object_unref0 (_tmp32_);
	_tmp36_ = self->priv->_owner;
	_tmp37_ = _tmp36_->use_playlists;
	_tmp38_ = TRUE;
	if (_bool_equal (_tmp37_, &_tmp38_) == TRUE) {
		mpris2_controller_fetch_playlists (self, NULL, NULL);
		mpris2_controller_fetch_active_playlist (self);
	}
	_g_hash_table_unref0 (cleaned_metadata);
}


void mpris2_controller_transport_update (Mpris2Controller* self, TransportAction command) {
	TransportAction _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = command;
	if (_tmp0_ == TRANSPORT_ACTION_PLAY_PAUSE) {
		MprisPlayer* _tmp1_;
		_tmp1_ = self->priv->_player;
		mpris_player_PlayPause (_tmp1_, NULL, NULL);
	} else {
		TransportAction _tmp2_;
		_tmp2_ = command;
		if (_tmp2_ == TRANSPORT_ACTION_PREVIOUS) {
			MprisPlayer* _tmp3_;
			_tmp3_ = self->priv->_player;
			mpris_player_Previous (_tmp3_, NULL, NULL);
		} else {
			TransportAction _tmp4_;
			_tmp4_ = command;
			if (_tmp4_ == TRANSPORT_ACTION_NEXT) {
				MprisPlayer* _tmp5_;
				_tmp5_ = self->priv->_player;
				mpris_player_Next (_tmp5_, NULL, NULL);
			} else {
				TransportAction _tmp6_;
				_tmp6_ = command;
				if (_tmp6_ == TRANSPORT_ACTION_REWIND) {
					MprisPlayer* _tmp7_;
					_tmp7_ = self->priv->_player;
					mpris_player_Seek (_tmp7_, (gint64) (-500000), NULL, NULL);
				} else {
					TransportAction _tmp8_;
					_tmp8_ = command;
					if (_tmp8_ == TRANSPORT_ACTION_FORWIND) {
						MprisPlayer* _tmp9_;
						_tmp9_ = self->priv->_player;
						mpris_player_Seek (_tmp9_, (gint64) 400000, NULL, NULL);
					}
				}
			}
		}
	}
}


gboolean mpris2_controller_connected (Mpris2Controller* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	MprisPlayer* _tmp1_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_player;
	if (_tmp1_ != NULL) {
		MprisRoot* _tmp2_;
		_tmp2_ = self->priv->_mpris2_root;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	result = _tmp3_;
	return result;
}


void mpris2_controller_expose (Mpris2Controller* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = mpris2_controller_connected (self);
	if (_tmp0_ == TRUE) {
		MprisRoot* _tmp1_;
		_tmp1_ = self->priv->_mpris2_root;
		mpris_root_Raise (_tmp1_, NULL, NULL);
	}
}


static void mpris2_controller_on_playlistdetails_changed (Mpris2Controller* self, PlaylistDetails* details) {
	PlayerController* _tmp0_;
	GeeArrayList* _tmp1_;
	gpointer _tmp2_ = NULL;
	PlaylistsMenuitem* playlists_item;
	PlaylistDetails _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = self->priv->_owner;
	_tmp1_ = _tmp0_->custom_items;
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _tmp1_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_PLAYLISTS);
	playlists_item = IS_PLAYLISTS_MENUITEM ((PlayerItem*) _tmp2_) ? ((PlaylistsMenuitem*) ((PlayerItem*) _tmp2_)) : NULL;
	_tmp3_ = *details;
	playlists_menuitem_update_individual_playlist (playlists_item, &_tmp3_);
	_g_object_unref0 (playlists_item);
}


static void mpris2_controller_fetch_playlists_data_free (gpointer _data) {
	Mpris2ControllerFetchPlaylistsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (Mpris2ControllerFetchPlaylistsData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void mpris2_controller_fetch_playlists (Mpris2Controller* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Mpris2ControllerFetchPlaylistsData* _data_;
	Mpris2Controller* _tmp0_;
	_data_ = g_slice_new0 (Mpris2ControllerFetchPlaylistsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, mpris2_controller_fetch_playlists);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, mpris2_controller_fetch_playlists_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mpris2_controller_fetch_playlists_co (_data_);
}


void mpris2_controller_fetch_playlists_finish (Mpris2Controller* self, GAsyncResult* _res_) {
	Mpris2ControllerFetchPlaylistsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void mpris2_controller_fetch_playlists_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	Mpris2ControllerFetchPlaylistsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mpris2_controller_fetch_playlists_co (_data_);
}


static void _vala_PlaylistDetails_array_free (PlaylistDetails* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			playlist_details_destroy (&array[i]);
		}
	}
	g_free (array);
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


static gboolean mpris2_controller_fetch_playlists_co (Mpris2ControllerFetchPlaylistsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->current_playlists = NULL;
	_data_->current_playlists_length1 = 0;
	_data_->_current_playlists_size_ = _data_->current_playlists_length1;
	{
		_data_->_tmp0_ = _data_->self->priv->_playlists;
		_data_->_tmp1_ = 0;
		_data_->_state_ = 1;
		mpris_playlists_GetPlaylists (_data_->_tmp0_, (guint32) 0, (guint32) MPRIS2_CONTROLLER_MAX_PLAYLIST_COUNT, "Alphabetical", FALSE, mpris2_controller_fetch_playlists_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = mpris_playlists_GetPlaylists_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp3__length1 = _data_->_tmp1_;
		_data_->__tmp3__size_ = _data_->_tmp3__length1;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch12_g_io_error;
			}
			_data_->current_playlists = (_vala_PlaylistDetails_array_free (_data_->current_playlists, _data_->current_playlists_length1), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->current_playlists = (_vala_PlaylistDetails_array_free (_data_->current_playlists, _data_->current_playlists_length1), NULL);
		_data_->current_playlists = _data_->_tmp3_;
		_data_->current_playlists_length1 = _data_->_tmp3__length1;
		_data_->_current_playlists_size_ = _data_->current_playlists_length1;
	}
	goto __finally12;
	__catch12_g_io_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->e);
		_data_->current_playlists = (_vala_PlaylistDetails_array_free (_data_->current_playlists, _data_->current_playlists_length1), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally12:
	if (_data_->_inner_error_ != NULL) {
		_data_->current_playlists = (_vala_PlaylistDetails_array_free (_data_->current_playlists, _data_->current_playlists_length1), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->current_playlists;
	_data_->_tmp4__length1 = _data_->current_playlists_length1;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->self->priv->_owner;
		_data_->_tmp6_ = _data_->_tmp5_->custom_items;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp6_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_PLAYLISTS);
		_data_->playlists_item = IS_PLAYLISTS_MENUITEM ((PlayerItem*) _data_->_tmp7_) ? ((PlaylistsMenuitem*) ((PlayerItem*) _data_->_tmp7_)) : NULL;
		_data_->_tmp8_ = _data_->playlists_item;
		_data_->_tmp9_ = _data_->current_playlists;
		_data_->_tmp9__length1 = _data_->current_playlists_length1;
		playlists_menuitem_update (_data_->_tmp8_, _data_->_tmp9_, _data_->_tmp9__length1);
		_g_object_unref0 (_data_->playlists_item);
	} else {
		_data_->_tmp10_ = _data_->self->priv->_owner;
		_data_->_tmp11_ = player_controller_get_app_info (_data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = g_app_info_get_name (_data_->_tmp12_);
		g_warning ("mpris2-controller.vala:243:  Playlists are on but %s is returning no c" \
"urrent_playlists ?", _data_->_tmp13_);
		_data_->_tmp14_ = _data_->self->priv->_owner;
		_data_->_tmp15_ = FALSE;
		_data_->_tmp16_ = __bool_dup0 (&_data_->_tmp15_);
		_g_free0 (_data_->_tmp14_->use_playlists);
		_data_->_tmp14_->use_playlists = _data_->_tmp16_;
	}
	_data_->current_playlists = (_vala_PlaylistDetails_array_free (_data_->current_playlists, _data_->current_playlists_length1), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean mpris2_controller_validate_playlists_details (Mpris2Controller* self) {
	gboolean result = FALSE;
	MprisPlaylists* _tmp0_;
	ActivePlaylistContainer* _tmp1_;
	ActivePlaylistContainer* _tmp2_;
	ActivePlaylistContainer* _tmp3_;
	gboolean _tmp4_;
	MprisPlaylists* _tmp5_;
	ActivePlaylistContainer* _tmp6_;
	ActivePlaylistContainer* _tmp7_;
	ActivePlaylistContainer* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	MprisPlaylists* _tmp11_;
	ActivePlaylistContainer* _tmp12_;
	ActivePlaylistContainer* _tmp13_;
	ActivePlaylistContainer* _tmp14_;
	PlaylistDetails* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_ = FALSE;
	MprisPlaylists* _tmp18_;
	ActivePlaylistContainer* _tmp19_;
	ActivePlaylistContainer* _tmp20_;
	ActivePlaylistContainer* _tmp21_;
	PlaylistDetails* _tmp22_;
	const char* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp31_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_playlists;
	_tmp1_ = mpris_playlists_get_ActivePlaylist (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ == NULL;
	_active_playlist_container_free0 (_tmp3_);
	if (_tmp4_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->_playlists;
	_tmp6_ = mpris_playlists_get_ActivePlaylist (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = (*_tmp8_).valid;
	_tmp10_ = _tmp9_ == FALSE;
	_active_playlist_container_free0 (_tmp8_);
	if (_tmp10_) {
		result = FALSE;
		return result;
	}
	_tmp11_ = self->priv->_playlists;
	_tmp12_ = mpris_playlists_get_ActivePlaylist (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp15_ = (*_tmp14_).details;
	_tmp16_ = _tmp15_ == NULL;
	_active_playlist_container_free0 (_tmp14_);
	if (_tmp16_) {
		result = FALSE;
		return result;
	}
	_tmp18_ = self->priv->_playlists;
	_tmp19_ = mpris_playlists_get_ActivePlaylist (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp22_ = (*_tmp21_).details;
	_tmp23_ = (*_tmp22_).path;
	_tmp24_ = _tmp23_ == NULL;
	_active_playlist_container_free0 (_tmp21_);
	if (_tmp24_) {
		_tmp17_ = TRUE;
	} else {
		MprisPlaylists* _tmp25_;
		ActivePlaylistContainer* _tmp26_;
		ActivePlaylistContainer* _tmp27_;
		ActivePlaylistContainer* _tmp28_;
		PlaylistDetails* _tmp29_;
		const gchar* _tmp30_;
		_tmp25_ = self->priv->_playlists;
		_tmp26_ = mpris_playlists_get_ActivePlaylist (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_;
		_tmp29_ = (*_tmp28_).details;
		_tmp30_ = (*_tmp29_).name;
		_tmp17_ = _tmp30_ == NULL;
		_active_playlist_container_free0 (_tmp28_);
	}
	_tmp31_ = _tmp17_;
	if (_tmp31_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean mpris2_controller_fetch_active_playlist (Mpris2Controller* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	PlayerController* _tmp1_;
	GeeArrayList* _tmp2_;
	gpointer _tmp3_ = NULL;
	PlaylistsMenuitem* playlists_item;
	PlaylistsMenuitem* _tmp4_;
	MprisPlaylists* _tmp5_;
	ActivePlaylistContainer* _tmp6_;
	ActivePlaylistContainer* _tmp7_;
	ActivePlaylistContainer* _tmp8_;
	PlaylistDetails* _tmp9_;
	PlaylistDetails _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mpris2_controller_validate_playlists_details (self);
	if (_tmp0_ == FALSE) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_owner;
	_tmp2_ = _tmp1_->custom_items;
	_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tmp2_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_PLAYLISTS);
	playlists_item = IS_PLAYLISTS_MENUITEM ((PlayerItem*) _tmp3_) ? ((PlaylistsMenuitem*) ((PlayerItem*) _tmp3_)) : NULL;
	_tmp4_ = playlists_item;
	_tmp5_ = self->priv->_playlists;
	_tmp6_ = mpris_playlists_get_ActivePlaylist (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = (*_tmp8_).details;
	_tmp10_ = *_tmp9_;
	playlists_menuitem_active_playlist_update (_tmp4_, &_tmp10_);
	_active_playlist_container_free0 (_tmp8_);
	result = FALSE;
	_g_object_unref0 (playlists_item);
	return result;
}


void mpris2_controller_activate_playlist (Mpris2Controller* self, const char* path) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	{
		MprisPlaylists* _tmp0_;
		const char* _tmp1_;
		_tmp0_ = self->priv->_playlists;
		_tmp1_ = path;
		mpris_playlists_ActivatePlaylist (_tmp0_, _tmp1_, NULL, NULL);
	}
	goto __finally13;
	__catch13_g_io_error:
	{
		GError* e = NULL;
		const char* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = path;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("mpris2-controller.vala:283: Could not activate playlist %s because %s", (const gchar*) _tmp2_, _tmp4_);
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


MprisRoot* mpris2_controller_get_mpris2_root (Mpris2Controller* self) {
	MprisRoot* result;
	MprisRoot* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mpris2_root;
	result = _tmp0_;
	return result;
}


static void mpris2_controller_set_mpris2_root (Mpris2Controller* self, MprisRoot* value) {
	MprisRoot* _tmp0_;
	MprisRoot* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_mpris2_root);
	self->priv->_mpris2_root = _tmp1_;
	g_object_notify ((GObject *) self, "mpris2-root");
}


MprisPlayer* mpris2_controller_get_player (Mpris2Controller* self) {
	MprisPlayer* result;
	MprisPlayer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_player;
	result = _tmp0_;
	return result;
}


static void mpris2_controller_set_player (Mpris2Controller* self, MprisPlayer* value) {
	MprisPlayer* _tmp0_;
	MprisPlayer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_player);
	self->priv->_player = _tmp1_;
	g_object_notify ((GObject *) self, "player");
}


MprisPlaylists* mpris2_controller_get_playlists (Mpris2Controller* self) {
	MprisPlaylists* result;
	MprisPlaylists* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_playlists;
	result = _tmp0_;
	return result;
}


static void mpris2_controller_set_playlists (Mpris2Controller* self, MprisPlaylists* value) {
	MprisPlaylists* _tmp0_;
	MprisPlaylists* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_playlists);
	self->priv->_playlists = _tmp1_;
	g_object_notify ((GObject *) self, "playlists");
}


FreeDesktopProperties* mpris2_controller_get_properties_interface (Mpris2Controller* self) {
	FreeDesktopProperties* result;
	FreeDesktopProperties* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_properties_interface;
	result = _tmp0_;
	return result;
}


static void mpris2_controller_set_properties_interface (Mpris2Controller* self, FreeDesktopProperties* value) {
	FreeDesktopProperties* _tmp0_;
	FreeDesktopProperties* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_properties_interface);
	self->priv->_properties_interface = _tmp1_;
	g_object_notify ((GObject *) self, "properties-interface");
}


PlayerController* mpris2_controller_get_owner (Mpris2Controller* self) {
	PlayerController* result;
	PlayerController* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_owner;
	result = _tmp0_;
	return result;
}


static void mpris2_controller_set_owner (Mpris2Controller* self, PlayerController* value) {
	PlayerController* _tmp0_;
	PlayerController* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_owner);
	self->priv->_owner = _tmp1_;
	g_object_notify ((GObject *) self, "owner");
}


static void _mpris2_controller_property_changed_cb_free_desktop_properties_properties_changed (FreeDesktopProperties* _sender, const gchar* source, GHashTable* changed_properties, gchar** invalid, int invalid_length1, gpointer self) {
	mpris2_controller_property_changed_cb (self, source, changed_properties, invalid, invalid_length1);
}


static void _mpris2_controller_on_playlistdetails_changed_mpris_playlists_playlist_changed (MprisPlaylists* _sender, PlaylistDetails* details, gpointer self) {
	mpris2_controller_on_playlistdetails_changed (self, details);
}


static GObject * mpris2_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Mpris2Controller * self;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (mpris2_controller_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MPRIS2_CONTROLLER (obj);
	{
		PlayerController* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		MprisRoot* _tmp3_ = NULL;
		MprisRoot* _tmp4_;
		MprisRoot* _tmp5_;
		PlayerController* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		MprisPlayer* _tmp9_ = NULL;
		MprisPlayer* _tmp10_;
		MprisPlayer* _tmp11_;
		FreeDesktopProperties* _tmp12_ = NULL;
		FreeDesktopProperties* _tmp13_;
		FreeDesktopProperties* _tmp14_;
		FreeDesktopProperties* _tmp15_;
		PlayerController* _tmp16_;
		gboolean* _tmp17_;
		gboolean _tmp18_;
		_tmp0_ = self->priv->_owner;
		_tmp1_ = player_controller_get_dbus_name (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_initable_new (TYPE_MPRIS_ROOT_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", _tmp2_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/mpris/MediaPlayer2", "g-interface-name", "org.mpris.MediaPlayer2", NULL);
		_tmp4_ = (MprisRoot*) _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch14_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp5_ = _tmp4_;
		mpris2_controller_set_mpris2_root (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
		_tmp6_ = self->priv->_owner;
		_tmp7_ = player_controller_get_dbus_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_initable_new (TYPE_MPRIS_PLAYER_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", _tmp8_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/mpris/MediaPlayer2", "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
		_tmp10_ = (MprisPlayer*) _tmp9_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch14_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp11_ = _tmp10_;
		mpris2_controller_set_player (self, _tmp11_);
		_g_object_unref0 (_tmp11_);
		_tmp12_ = g_initable_new (TYPE_FREE_DESKTOP_PROPERTIES_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.freedesktop.Properties.PropertiesChanged", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/mpris/MediaPlayer2", "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
		_tmp13_ = (FreeDesktopProperties*) _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch14_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp14_ = _tmp13_;
		mpris2_controller_set_properties_interface (self, _tmp14_);
		_g_object_unref0 (_tmp14_);
		_tmp15_ = self->priv->_properties_interface;
		g_signal_connect_object (_tmp15_, "properties-changed", (GCallback) _mpris2_controller_property_changed_cb_free_desktop_properties_properties_changed, self, 0);
		_tmp16_ = self->priv->_owner;
		_tmp17_ = _tmp16_->use_playlists;
		_tmp18_ = TRUE;
		if (_bool_equal (_tmp17_, &_tmp18_) == TRUE) {
			PlayerController* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			MprisPlaylists* _tmp22_ = NULL;
			MprisPlaylists* _tmp23_;
			MprisPlaylists* _tmp24_;
			MprisPlaylists* _tmp25_;
			_tmp19_ = self->priv->_owner;
			_tmp20_ = player_controller_get_dbus_name (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_initable_new (TYPE_MPRIS_PLAYLISTS_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", _tmp21_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/mpris/MediaPlayer2", "g-interface-name", "org.mpris.MediaPlayer2.Playlists", NULL);
			_tmp23_ = (MprisPlaylists*) _tmp22_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_IO_ERROR) {
					goto __catch14_g_io_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp24_ = _tmp23_;
			mpris2_controller_set_playlists (self, _tmp24_);
			_g_object_unref0 (_tmp24_);
			_tmp25_ = self->priv->_playlists;
			g_signal_connect_object (_tmp25_, "playlist-changed", (GCallback) _mpris2_controller_on_playlistdetails_changed_mpris_playlists_playlist_changed, self, 0);
		}
	}
	goto __finally14;
	__catch14_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		g_critical ("mpris2-controller.vala:57: Problems connecting to the session bus - %s", _tmp27_);
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void mpris2_controller_class_init (Mpris2ControllerClass * klass) {
	mpris2_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (Mpris2ControllerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_mpris2_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mpris2_controller_set_property;
	G_OBJECT_CLASS (klass)->constructor = mpris2_controller_constructor;
	G_OBJECT_CLASS (klass)->finalize = mpris2_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MPRIS2_CONTROLLER_MPRIS2_ROOT, g_param_spec_object ("mpris2-root", "mpris2-root", "mpris2-root", TYPE_MPRIS_ROOT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MPRIS2_CONTROLLER_PLAYER, g_param_spec_object ("player", "player", "player", TYPE_MPRIS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MPRIS2_CONTROLLER_PLAYLISTS, g_param_spec_object ("playlists", "playlists", "playlists", TYPE_MPRIS_PLAYLISTS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MPRIS2_CONTROLLER_PROPERTIES_INTERFACE, g_param_spec_object ("properties-interface", "properties-interface", "properties-interface", TYPE_FREE_DESKTOP_PROPERTIES, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MPRIS2_CONTROLLER_OWNER, g_param_spec_object ("owner", "owner", "owner", TYPE_PLAYER_CONTROLLER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void mpris2_controller_instance_init (Mpris2Controller * self) {
	self->priv = MPRIS2_CONTROLLER_GET_PRIVATE (self);
}


static void mpris2_controller_finalize (GObject* obj) {
	Mpris2Controller * self;
	self = MPRIS2_CONTROLLER (obj);
	_g_object_unref0 (self->priv->_mpris2_root);
	_g_object_unref0 (self->priv->_player);
	_g_object_unref0 (self->priv->_playlists);
	_g_object_unref0 (self->priv->_properties_interface);
	_g_object_unref0 (self->priv->_owner);
	G_OBJECT_CLASS (mpris2_controller_parent_class)->finalize (obj);
}


GType mpris2_controller_get_type (void) {
	static volatile gsize mpris2_controller_type_id__volatile = 0;
	if (g_once_init_enter (&mpris2_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (Mpris2ControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mpris2_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Mpris2Controller), 0, (GInstanceInitFunc) mpris2_controller_instance_init, NULL };
		GType mpris2_controller_type_id;
		mpris2_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "Mpris2Controller", &g_define_type_info, 0);
		g_once_init_leave (&mpris2_controller_type_id__volatile, mpris2_controller_type_id);
	}
	return mpris2_controller_type_id__volatile;
}


static void _vala_mpris2_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Mpris2Controller * self;
	self = MPRIS2_CONTROLLER (object);
	switch (property_id) {
		case MPRIS2_CONTROLLER_MPRIS2_ROOT:
		g_value_set_object (value, mpris2_controller_get_mpris2_root (self));
		break;
		case MPRIS2_CONTROLLER_PLAYER:
		g_value_set_object (value, mpris2_controller_get_player (self));
		break;
		case MPRIS2_CONTROLLER_PLAYLISTS:
		g_value_set_object (value, mpris2_controller_get_playlists (self));
		break;
		case MPRIS2_CONTROLLER_PROPERTIES_INTERFACE:
		g_value_set_object (value, mpris2_controller_get_properties_interface (self));
		break;
		case MPRIS2_CONTROLLER_OWNER:
		g_value_set_object (value, mpris2_controller_get_owner (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_mpris2_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Mpris2Controller * self;
	self = MPRIS2_CONTROLLER (object);
	switch (property_id) {
		case MPRIS2_CONTROLLER_MPRIS2_ROOT:
		mpris2_controller_set_mpris2_root (self, g_value_get_object (value));
		break;
		case MPRIS2_CONTROLLER_PLAYER:
		mpris2_controller_set_player (self, g_value_get_object (value));
		break;
		case MPRIS2_CONTROLLER_PLAYLISTS:
		mpris2_controller_set_playlists (self, g_value_get_object (value));
		break;
		case MPRIS2_CONTROLLER_PROPERTIES_INTERFACE:
		mpris2_controller_set_properties_interface (self, g_value_get_object (value));
		break;
		case MPRIS2_CONTROLLER_OWNER:
		mpris2_controller_set_owner (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



