/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken@vandine.org>
 */

namespace GwibberGtk
{
public class ActionBox : Gtk.Box
{
  /*
  private ActionBoxItem? _item = null;

  public ActionBoxItem item {
    get { return _item; }
    set {
      if (_item != value)
        {
          if (_item != null)
          {
            foreach (var _w in _item.get_children ())
              _item.remove (_w);
            _item.menu = null;
            _item.image = null;
          }
          _item = value;
        }
    }
  }
  */

  public ActionBox ()
  {
    Object (homogeneous:false, spacing:0);
  }

  construct
  {
    set_orientation (Gtk.Orientation.HORIZONTAL);
    var icon_theme = Gtk.IconTheme.get_default ();
    icon_theme.prepend_search_path (Config.PKGDATADIR + "/ui/icons");
    // Prepend local icon path if running from a source checkout
    var local_icon_path = GLib.Path.build_path (Path.DIR_SEPARATOR_S, Environment.get_current_dir (), "data/icons");
    if (GLib.FileUtils.test (local_icon_path, GLib.FileTest.IS_DIR))
      icon_theme.prepend_search_path (local_icon_path);
    local_icon_path = GLib.Path.build_path (Path.DIR_SEPARATOR_S, Environment.get_current_dir (), "../data/icons");
    if (GLib.FileUtils.test (local_icon_path, GLib.FileTest.IS_DIR))
      icon_theme.prepend_search_path (local_icon_path);
  }
}

public class ActionBoxItem : Gtk.EventBox
{
  public string service  { get; construct set; }
  public string stream  { get; construct set; }
  public string account { get; construct set; }
  public string mid { get; construct set; }
  public string sender { get; construct set; }
  public string action { get; construct set; }
  public bool from_me { get; construct set; }
  public bool liked { get; construct set; }
  public string tooltip { get; construct set; }

  private Gtk.Image _image;
  private Gtk.Menu? _menu;
  private Gtk.MenuItem? _amenu;

  public ActionBoxItem (string service, string stream, string account, string mid, string sender, bool from_me, bool liked, string tooltip = "")
  {
    Object (service:service, stream:stream, account:account, mid:mid, sender:sender, from_me:from_me, liked:liked, tooltip:tooltip);
  }

  ~ActionBoxItem ()
  {
    if (_image is Gtk.Widget)
      _image.destroy ();
    if (_menu is Gtk.Widget)
      _menu.destroy ();
    if (_amenu is Gtk.Widget)
      _amenu.destroy ();
  }

  construct
  {
    if (tooltip.length < 1)
      tooltip = service;

    _image = new Gtk.Image.from_icon_name(service, Gtk.IconSize.MENU);
    _image.set_no_show_all (false);
    _image.tooltip_text = tooltip;
    add (_image);
    _menu = build_menu ();
    if (get_parent() is Gtk.Widget)
      reparent (_menu);

    button_press_event.connect((event) => {
      if (_menu.get_children ().length () > 0)
        _menu.popup (null, null, null, event.button, event.time);
      return true;
    });

  }

  [Signal (action=true)]
  public virtual signal void send (string mid, string account, string sender, string action = "send")
  {
  }


  private void user_stream (string account, string sender)
  {
    var streams = new Gwibber.Streams ();
    streams.create (account, sender.replace ("@", ""), "user_messages");
  }

  public bool share (string mid, string account)
  {
    var service = new Gwibber.Service ();
    return service.retweet(mid, account);
  }

  public bool like (string mid, string account)
  {
    var service = new Gwibber.Service ();
    return service.like(mid, account);
  }

  public bool unlike (string mid, string account)
  {
    var service = new Gwibber.Service ();
    return service.unlike(mid, account);
  }

  private Gtk.Menu build_menu ()
  {
    _menu = new Gtk.Menu ();

    if ((service != "flicker" && service != "pingfm" && service != "foursquare" && service != "digg") && !from_me && stream != "private")
    {
      _amenu = new Gtk.MenuItem.with_mnemonic (_("_Reply"));
      _amenu.activate.connect(() => {
        string nick = "";
        Json.Object obj = null;
        Json.Object sender_obj = null;

        var messages = new Gwibber.Messages ();
        var msg = messages.get_message (mid);

        var parser = new Json.Parser();
        try
        {
          parser.load_from_data(msg);
        }
        catch (Error e)
        {
        }

        obj = parser.get_root().get_object();
        if (obj != null)
        {
          if (obj.has_member ("sender"))
          {
            sender_obj = obj.get_object_member ("sender");
            if (sender_obj != null)
            {
              if (sender_obj.has_member ("nick"))
                nick = sender_obj.get_string_member ("nick");
            }
          }
        }
        if (nick.length > 0)
          nick = "@" + nick;
        send (mid, account, nick);
      });
      _menu.append(_amenu);
    }

    if ((service == "twitter" || service == "identica" || service == "statusnet") && !from_me)
    {
      _amenu = new Gtk.MenuItem.with_mnemonic (_("Pri_vate Reply"));
      _amenu.activate.connect(() => {
        string nick = "";
        Json.Object obj = null;
        Json.Object sender_obj = null;

        try
        {
          var messages = new Gwibber.Messages ();
          var msg = messages.get_message (mid);

          var parser = new Json.Parser();
          try
          {
            parser.load_from_data(msg);
          }
          catch (Error e)
          {
          }

          obj = parser.get_root().get_object();
          if (obj != null)
          {
            if (obj.has_member ("sender"))
            {
              sender_obj = obj.get_object_member ("sender");
              if (sender_obj != null)
              {
                if (sender_obj.has_member ("nick"))
                  nick = sender_obj.get_string_member ("nick");
              }
            }
          }
        } catch (GLib.IOError e) {
          warning (e.message);
        }
        if (nick.length > 0)
          nick = "@" + nick;
        send (mid, account, nick, "private");
      });
      _menu.append(_amenu);
    }
    if (service != "flicker" && service != "pingfm" && service != "foursquare" && service != "digg" && service != "qaiku" && service != "buzz" && stream != "private")
    {
      string amenu_label = liked ? _("Un_like") : _("_Like");

      _amenu = new Gtk.MenuItem.with_mnemonic (amenu_label);
      _amenu.activate.connect(() => {
        var ret = liked ? unlike (mid, account) : like (mid, account);
        if (ret) {
          liked = !liked;
          _amenu.label = liked ? _("Un_like") : _("_Like");
          string name = "";
          string nick = "";
          Json.Object obj = null;
          Json.Object sender_obj = null;

          try
          {
            var messages = new Gwibber.Messages ();
            var msg = messages.get_message (mid);

            var parser = new Json.Parser();
            try
            {
              parser.load_from_data(msg);
            }
            catch (Error e)
            {
            }

            obj = parser.get_root().get_object();
            if (obj != null)
            {
              if (obj.has_member ("sender"))
              {
                sender_obj = obj.get_object_member ("sender");
                if (sender_obj != null)
                {
                  if (sender_obj.has_member ("nick"))
                    nick = sender_obj.get_string_member ("nick");
                  if (sender_obj.has_member ("name"))
                    name = sender_obj.get_string_member ("name");
                }
              }
            }
          } catch (GLib.IOError e) {
            warning (e.message);
          }
          if (name.length > 0)
            nick = name;

          var icon_theme = Gtk.IconTheme.get_default ();
          var icon_info = icon_theme.lookup_icon (service, Gtk.IconSize.DIALOG, Gtk.IconLookupFlags.FORCE_SVG);
          string liked_notify_title = liked ? _("Liked") : _("Unliked");
          string liked_notify_body = liked ? _("Liked post from %s").printf (nick) : _("Unliked post from %s").printf (nick);
          var notification = new Notify.Notification (liked_notify_title, liked_notify_body, icon_info.get_filename ());
          try
          {
            notification.show ();
          }
          catch (Error e)
          {
          }
        }
      });
      _menu.append(_amenu);
    }

    if ((service == "twitter" || service == "identica" || service == "statusnet" || service == "sina" || service == "sohu") && stream != "private")
    {
      _amenu = new Gtk.MenuItem ();
      if (service == "twitter")
      {
        _amenu = new Gtk.MenuItem.with_mnemonic (_("Re_tweet"));
      }
      if (service == "identica" || service == "statusnet")
      {
        _amenu = new Gtk.MenuItem.with_mnemonic (_("Re_peat"));
      }
      _amenu.activate.connect(() => {
        var ret = share (mid, account);
        if (ret) {
          var icon_theme = Gtk.IconTheme.get_default ();
          var icon_info = icon_theme.lookup_icon (service, Gtk.IconSize.DIALOG, Gtk.IconLookupFlags.FORCE_SVG);
          var notification = new Notify.Notification (_("Shared"), _("Shared post from %s").printf (sender), icon_info.get_filename ());
          try
          {
            notification.show ();
          }
          catch (Error e)
          {
          }
        }
      });
      _menu.append(_amenu);
    }

    if ((service == "twitter" || service == "identica" || service == "statusnet") && stream != "user")
    {
      _amenu = new Gtk.MenuItem.with_mnemonic (_("View User _Profile"));
      _amenu.activate.connect(() => {
        user_stream (account, sender);
      });
      _menu.append(_amenu);
    }

    _menu.show_all ();
    return _menu;
  }
}
}
