/* searches.c generated by valac 0.12.1, the Vala compiler
 * generated from searches.vala, do not modify */

/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "gwibber.h"
#include <gee.h>
#include <json-glib/json-glib.h>


#define TYPE_SEARCHES_INTERFACE (searches_interface_get_type ())
#define SEARCHES_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCHES_INTERFACE, SearchesInterface))
#define IS_SEARCHES_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCHES_INTERFACE))
#define SEARCHES_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SEARCHES_INTERFACE, SearchesInterfaceIface))

typedef struct _SearchesInterface SearchesInterface;
typedef struct _SearchesInterfaceIface SearchesInterfaceIface;

#define TYPE_SEARCHES_INTERFACE_PROXY (searches_interface_proxy_get_type ())
typedef GDBusProxy SearchesInterfaceProxy;
typedef GDBusProxyClass SearchesInterfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

struct _SearchesInterfaceIface {
	GTypeInterface parent_iface;
	gchar* (*Get) (SearchesInterface* self, const gchar* id, GError** error);
	gchar* (*List) (SearchesInterface* self, GError** error);
	gchar* (*Create) (SearchesInterface* self, const gchar* query, GError** error);
	void (*Delete) (SearchesInterface* self, const gchar* id, GError** error);
};

struct _GwibberSearchesPrivate {
	SearchesInterface* searches;
	GwibberUtils* utils;
};


static gpointer gwibber_searches_parent_class = NULL;

GType searches_interface_proxy_get_type (void) G_GNUC_CONST;
guint searches_interface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType searches_interface_get_type (void) G_GNUC_CONST;
gchar* searches_interface_Get (SearchesInterface* self, const gchar* id, GError** error);
gchar* searches_interface_List (SearchesInterface* self, GError** error);
gchar* searches_interface_Create (SearchesInterface* self, const gchar* query, GError** error);
void searches_interface_Delete (SearchesInterface* self, const gchar* id, GError** error);
static void searches_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_searches_interface_updated (SearchesInterface* self, GVariant* parameters);
static void _dbus_handle_searches_interface_created (SearchesInterface* self, GVariant* parameters);
static void _dbus_handle_searches_interface_deleted (SearchesInterface* self, GVariant* parameters);
static gchar* searches_interface_proxy_Get (SearchesInterface* self, const gchar* id, GError** error);
static gchar* searches_interface_proxy_List (SearchesInterface* self, GError** error);
static gchar* searches_interface_proxy_Create (SearchesInterface* self, const gchar* query, GError** error);
static void searches_interface_proxy_Delete (SearchesInterface* self, const gchar* id, GError** error);
static void searches_interface_proxy_searches_interface_interface_init (SearchesInterfaceIface* iface);
static void _dbus_searches_interface_Get (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_searches_interface_List (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_searches_interface_Create (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_searches_interface_Delete (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void searches_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* searches_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean searches_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_searches_interface_updated (GObject* _sender, const gchar* account, gpointer* _data);
static void _dbus_searches_interface_created (GObject* _sender, const gchar* account, gpointer* _data);
static void _dbus_searches_interface_deleted (GObject* _sender, const gchar* account, gpointer* _data);
static void _searches_interface_unregister_object (gpointer user_data);
#define GWIBBER_SEARCHES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_SEARCHES, GwibberSearchesPrivate))
enum  {
	GWIBBER_SEARCHES_DUMMY_PROPERTY
};
#define GWIBBER_SEARCHES_searches_name "com.Gwibber.Searches"
#define GWIBBER_SEARCHES_searches_path "/com/gwibber/Searches"
void gwibber_utils_setup (GwibberUtils* self, const gchar* name, GError** error);
static void _gwibber_searches_searches_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self);
static void _lambda5_ (const gchar* source, GwibberSearches* self);
static void __lambda5__searches_interface_updated (SearchesInterface* _sender, const gchar* account, gpointer self);
static void _lambda6_ (const gchar* source, GwibberSearches* self);
static void __lambda6__searches_interface_created (SearchesInterface* _sender, const gchar* account, gpointer self);
static void _lambda7_ (const gchar* source, GwibberSearches* self);
static void __lambda7__searches_interface_deleted (SearchesInterface* _sender, const gchar* account, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void gwibber_searches_finalize (GObject* obj);

static const GDBusArgInfo _searches_interface_dbus_arg_info_Get_id = {-1, "id", "s"};
static const GDBusArgInfo _searches_interface_dbus_arg_info_Get_result = {-1, "result", "s"};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_Get_in[] = {&_searches_interface_dbus_arg_info_Get_id, NULL};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_Get_out[] = {&_searches_interface_dbus_arg_info_Get_result, NULL};
static const GDBusMethodInfo _searches_interface_dbus_method_info_Get = {-1, "Get", (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_Get_in), (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_Get_out)};
static const GDBusArgInfo _searches_interface_dbus_arg_info_List_result = {-1, "result", "s"};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_List_in[] = {NULL};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_List_out[] = {&_searches_interface_dbus_arg_info_List_result, NULL};
static const GDBusMethodInfo _searches_interface_dbus_method_info_List = {-1, "List", (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_List_in), (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_List_out)};
static const GDBusArgInfo _searches_interface_dbus_arg_info_Create_query = {-1, "query", "s"};
static const GDBusArgInfo _searches_interface_dbus_arg_info_Create_result = {-1, "result", "s"};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_Create_in[] = {&_searches_interface_dbus_arg_info_Create_query, NULL};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_Create_out[] = {&_searches_interface_dbus_arg_info_Create_result, NULL};
static const GDBusMethodInfo _searches_interface_dbus_method_info_Create = {-1, "Create", (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_Create_in), (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_Create_out)};
static const GDBusArgInfo _searches_interface_dbus_arg_info_Delete_id = {-1, "id", "s"};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_Delete_in[] = {&_searches_interface_dbus_arg_info_Delete_id, NULL};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_Delete_out[] = {NULL};
static const GDBusMethodInfo _searches_interface_dbus_method_info_Delete = {-1, "Delete", (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_Delete_in), (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_Delete_out)};
static const GDBusMethodInfo * const _searches_interface_dbus_method_info[] = {&_searches_interface_dbus_method_info_Get, &_searches_interface_dbus_method_info_List, &_searches_interface_dbus_method_info_Create, &_searches_interface_dbus_method_info_Delete, NULL};
static const GDBusArgInfo _searches_interface_dbus_arg_info_updated_account = {-1, "account", "s"};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_updated[] = {&_searches_interface_dbus_arg_info_updated_account, NULL};
static const GDBusSignalInfo _searches_interface_dbus_signal_info_updated = {-1, "Updated", (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_updated)};
static const GDBusArgInfo _searches_interface_dbus_arg_info_created_account = {-1, "account", "s"};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_created[] = {&_searches_interface_dbus_arg_info_created_account, NULL};
static const GDBusSignalInfo _searches_interface_dbus_signal_info_created = {-1, "Created", (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_created)};
static const GDBusArgInfo _searches_interface_dbus_arg_info_deleted_account = {-1, "account", "s"};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_deleted[] = {&_searches_interface_dbus_arg_info_deleted_account, NULL};
static const GDBusSignalInfo _searches_interface_dbus_signal_info_deleted = {-1, "Deleted", (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_deleted)};
static const GDBusSignalInfo * const _searches_interface_dbus_signal_info[] = {&_searches_interface_dbus_signal_info_updated, &_searches_interface_dbus_signal_info_created, &_searches_interface_dbus_signal_info_deleted, NULL};
static const GDBusPropertyInfo * const _searches_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _searches_interface_dbus_interface_info = {-1, "com.Gwibber.Searches", (GDBusMethodInfo **) (&_searches_interface_dbus_method_info), (GDBusSignalInfo **) (&_searches_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_searches_interface_dbus_property_info)};
static const GDBusInterfaceVTable _searches_interface_dbus_interface_vtable = {searches_interface_dbus_interface_method_call, searches_interface_dbus_interface_get_property, searches_interface_dbus_interface_set_property};

gchar* searches_interface_Get (SearchesInterface* self, const gchar* id, GError** error) {
	return SEARCHES_INTERFACE_GET_INTERFACE (self)->Get (self, id, error);
}


gchar* searches_interface_List (SearchesInterface* self, GError** error) {
	return SEARCHES_INTERFACE_GET_INTERFACE (self)->List (self, error);
}


gchar* searches_interface_Create (SearchesInterface* self, const gchar* query, GError** error) {
	return SEARCHES_INTERFACE_GET_INTERFACE (self)->Create (self, query, error);
}


void searches_interface_Delete (SearchesInterface* self, const gchar* id, GError** error) {
	SEARCHES_INTERFACE_GET_INTERFACE (self)->Delete (self, id, error);
}


static void searches_interface_base_init (SearchesInterfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("updated", TYPE_SEARCHES_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
		g_signal_new ("created", TYPE_SEARCHES_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
		g_signal_new ("deleted", TYPE_SEARCHES_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	}
}


GType searches_interface_get_type (void) {
	static volatile gsize searches_interface_type_id__volatile = 0;
	if (g_once_init_enter (&searches_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchesInterfaceIface), (GBaseInitFunc) searches_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType searches_interface_type_id;
		searches_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "SearchesInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (searches_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (searches_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) searches_interface_proxy_get_type);
		g_type_set_qdata (searches_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.Gwibber.Searches");
		g_type_set_qdata (searches_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) searches_interface_register_object);
		g_once_init_leave (&searches_interface_type_id__volatile, searches_interface_type_id);
	}
	return searches_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (SearchesInterfaceProxy, searches_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_SEARCHES_INTERFACE, searches_interface_proxy_searches_interface_interface_init) )
static void searches_interface_proxy_class_init (SearchesInterfaceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = searches_interface_proxy_g_signal;
}


static void _dbus_handle_searches_interface_updated (SearchesInterface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* account = NULL;
	GVariant* _tmp22_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp22_ = g_variant_iter_next_value (&_arguments_iter);
	account = g_variant_dup_string (_tmp22_, NULL);
	g_variant_unref (_tmp22_);
	g_signal_emit_by_name (self, "updated", account);
	_g_free0 (account);
}


static void _dbus_handle_searches_interface_created (SearchesInterface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* account = NULL;
	GVariant* _tmp23_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp23_ = g_variant_iter_next_value (&_arguments_iter);
	account = g_variant_dup_string (_tmp23_, NULL);
	g_variant_unref (_tmp23_);
	g_signal_emit_by_name (self, "created", account);
	_g_free0 (account);
}


static void _dbus_handle_searches_interface_deleted (SearchesInterface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* account = NULL;
	GVariant* _tmp24_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp24_ = g_variant_iter_next_value (&_arguments_iter);
	account = g_variant_dup_string (_tmp24_, NULL);
	g_variant_unref (_tmp24_);
	g_signal_emit_by_name (self, "deleted", account);
	_g_free0 (account);
}


static void searches_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "Updated") == 0) {
		_dbus_handle_searches_interface_updated ((SearchesInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "Created") == 0) {
		_dbus_handle_searches_interface_created ((SearchesInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "Deleted") == 0) {
		_dbus_handle_searches_interface_deleted ((SearchesInterface*) proxy, parameters);
	}
}


static void searches_interface_proxy_init (SearchesInterfaceProxy* self) {
}


static gchar* searches_interface_proxy_Get (SearchesInterface* self, const gchar* id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp25_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Searches", "Get");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp25_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp25_, NULL);
	g_variant_unref (_tmp25_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* searches_interface_proxy_List (SearchesInterface* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp26_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Searches", "List");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp26_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp26_, NULL);
	g_variant_unref (_tmp26_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* searches_interface_proxy_Create (SearchesInterface* self, const gchar* query, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp27_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Searches", "Create");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp27_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp27_, NULL);
	g_variant_unref (_tmp27_);
	g_object_unref (_reply_message);
	return _result;
}


static void searches_interface_proxy_Delete (SearchesInterface* self, const gchar* id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Searches", "Delete");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void searches_interface_proxy_searches_interface_interface_init (SearchesInterfaceIface* iface) {
	iface->Get = searches_interface_proxy_Get;
	iface->List = searches_interface_proxy_List;
	iface->Create = searches_interface_proxy_Create;
	iface->Delete = searches_interface_proxy_Delete;
}


static void _dbus_searches_interface_Get (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp28_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp28_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp28_, NULL);
	g_variant_unref (_tmp28_);
	result = searches_interface_Get (self, id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 ( result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (id);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_searches_interface_List (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = searches_interface_List (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 ( result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_searches_interface_Create (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* query = NULL;
	GVariant* _tmp29_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	query = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	result = searches_interface_Create (self, query, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 ( result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (query);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_searches_interface_Delete (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp30_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp30_, NULL);
	g_variant_unref (_tmp30_);
	searches_interface_Delete (self, id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (id);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void searches_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Get") == 0) {
		_dbus_searches_interface_Get (object, parameters, invocation);
	} else if (strcmp (method_name, "List") == 0) {
		_dbus_searches_interface_List (object, parameters, invocation);
	} else if (strcmp (method_name, "Create") == 0) {
		_dbus_searches_interface_Create (object, parameters, invocation);
	} else if (strcmp (method_name, "Delete") == 0) {
		_dbus_searches_interface_Delete (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* searches_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean searches_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_searches_interface_updated (GObject* _sender, const gchar* account, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (account));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.Gwibber.Searches", "Updated", _arguments, NULL);
}


static void _dbus_searches_interface_created (GObject* _sender, const gchar* account, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (account));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.Gwibber.Searches", "Created", _arguments, NULL);
}


static void _dbus_searches_interface_deleted (GObject* _sender, const gchar* account, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (account));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.Gwibber.Searches", "Deleted", _arguments, NULL);
}


guint searches_interface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_searches_interface_dbus_interface_info), &_searches_interface_dbus_interface_vtable, data, _searches_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "updated", (GCallback) _dbus_searches_interface_updated, data);
	g_signal_connect (object, "created", (GCallback) _dbus_searches_interface_created, data);
	g_signal_connect (object, "deleted", (GCallback) _dbus_searches_interface_deleted, data);
	return result;
}


static void _searches_interface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _gwibber_searches_searches_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self) {
	gwibber_searches_searches_available (self, up);
}


static void _lambda5_ (const gchar* source, GwibberSearches* self) {
	g_return_if_fail (source != NULL);
	gwibber_searches_search_updated (self, source);
}


static void __lambda5__searches_interface_updated (SearchesInterface* _sender, const gchar* account, gpointer self) {
	_lambda5_ (account, self);
}


static void _lambda6_ (const gchar* source, GwibberSearches* self) {
	g_return_if_fail (source != NULL);
	gwibber_searches_search_created (self, source);
}


static void __lambda6__searches_interface_created (SearchesInterface* _sender, const gchar* account, gpointer self) {
	_lambda6_ (account, self);
}


static void _lambda7_ (const gchar* source, GwibberSearches* self) {
	g_return_if_fail (source != NULL);
	gwibber_searches_search_deleted (self, source);
}


static void __lambda7__searches_interface_deleted (SearchesInterface* _sender, const gchar* account, gpointer self) {
	_lambda7_ (account, self);
}


GwibberSearches* gwibber_searches_construct (GType object_type) {
	GwibberSearches * self = NULL;
	SearchesInterface* _tmp0_ = NULL;
	SearchesInterface* _tmp1_;
	GwibberUtils* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	self = (GwibberSearches*) g_object_new (object_type, NULL);
	_tmp0_ = g_initable_new (TYPE_SEARCHES_INTERFACE_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", GWIBBER_SEARCHES_searches_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", GWIBBER_SEARCHES_searches_path, "g-interface-name", "com.Gwibber.Searches", NULL);
	_tmp1_ = (SearchesInterface*) _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch31_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (self->priv->searches);
	self->priv->searches = _tmp1_;
	_tmp2_ = gwibber_utils_new ();
	_g_object_unref0 (self->priv->utils);
	self->priv->utils = _tmp2_;
	gwibber_utils_setup (self->priv->utils, GWIBBER_SEARCHES_searches_name, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch31_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	g_signal_connect_object (self->priv->utils, "available", (GCallback) _gwibber_searches_searches_available_gwibber_utils_available, self, 0);
	g_signal_connect_object (self->priv->searches, "updated", (GCallback) __lambda5__searches_interface_updated, self, 0);
	g_signal_connect_object (self->priv->searches, "created", (GCallback) __lambda6__searches_interface_created, self, 0);
	g_signal_connect_object (self->priv->searches, "deleted", (GCallback) __lambda7__searches_interface_deleted, self, 0);
	goto __finally31;
	__catch31_g_io_error:
	{
		GError * e;
		gchar* _tmp3_;
		gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = g_strconcat ("Unable to get Gwibber Searches: ", e->message, NULL);
		_tmp4_ = _tmp3_;
		g_warning ("searches.vala:77: %s", _tmp4_);
		_g_free0 (_tmp4_);
		_g_error_free0 (e);
	}
	__finally31:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


GwibberSearches* gwibber_searches_new (void) {
	return gwibber_searches_construct (GWIBBER_TYPE_SEARCHES);
}


/**
         * com.Gwibber.Searches
         **/
static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


GeeHashMap* gwibber_searches_lookup (GwibberSearches* self, const gchar* id) {
	GeeHashMap* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	JsonParser* _tmp1_ = NULL;
	JsonParser* parser;
	JsonNode* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	JsonObject* _tmp4_;
	JsonObject* obj;
	GList* _tmp5_ = NULL;
	GList* members;
	GeeHashMap* _tmp6_ = NULL;
	GeeHashMap* searches_map;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = searches_interface_Get (self->priv->searches, id, &_inner_error_);
	_result_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch32_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp1_ = json_parser_new ();
	parser = _tmp1_;
	json_parser_load_from_data (parser, _result_, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		_g_free0 (_result_);
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch32_g_io_error;
		}
		goto __finally32;
	}
	_tmp2_ = json_parser_get_root (parser);
	_tmp3_ = json_node_get_object (_tmp2_);
	_tmp4_ = _json_object_ref0 (_tmp3_);
	obj = _tmp4_;
	_tmp5_ = json_object_get_members (obj);
	members = _tmp5_;
	_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	searches_map = _tmp6_;
	{
		GList* member_collection;
		GList* member_it;
		member_collection = members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			gchar* _tmp7_;
			gchar* member;
			_tmp7_ = g_strdup ((const gchar*) member_it->data);
			member = _tmp7_;
			{
				const gchar* _tmp8_ = NULL;
				_tmp8_ = json_object_get_string_member (obj, member);
				gee_abstract_map_set ((GeeAbstractMap*) searches_map, member, _tmp8_);
				_g_free0 (member);
			}
		}
	}
	result = searches_map;
	_g_list_free0 (members);
	_json_object_unref0 (obj);
	_g_object_unref0 (parser);
	_g_free0 (_result_);
	return result;
	_g_object_unref0 (searches_map);
	_g_list_free0 (members);
	_json_object_unref0 (obj);
	_g_object_unref0 (parser);
	_g_free0 (_result_);
	goto __finally32;
	__catch32_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("searches.vala:105: %s", e->message);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally32:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


/**
         * com.Gwibber.Searches
         **/
void gwibber_searches_delete (GwibberSearches* self, const gchar* id) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	searches_interface_Delete (self->priv->searches, id, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch33_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally33;
	__catch33_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("searches.vala:122: %s", e->message);
		_g_error_free0 (e);
	}
	__finally33:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	return;
}


/**
         * com.Gwibber.Searches
         **/
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


gchar* gwibber_searches_create (GwibberSearches* self, const gchar* name, const gchar* query) {
	gchar* result = NULL;
	GList* _tmp0_ = NULL;
	GList* searches_list;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = gwibber_searches_list (self);
	searches_list = _tmp0_;
	{
		GList* s_collection;
		GList* s_it;
		s_collection = searches_list;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			GeeHashMap* _tmp1_;
			GeeHashMap* s;
			_tmp1_ = _g_object_ref0 ((GeeHashMap*) s_it->data);
			s = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				gpointer _tmp3_ = NULL;
				gchar* _tmp4_;
				gboolean _tmp5_;
				_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) s, "name");
				_tmp4_ = (gchar*) _tmp3_;
				_tmp5_ = g_strcmp0 (_tmp4_, name) == 0;
				_g_free0 (_tmp4_);
				if (_tmp5_) {
					gpointer _tmp6_ = NULL;
					gchar* _tmp7_;
					_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) s, "query");
					_tmp7_ = (gchar*) _tmp6_;
					_tmp2_ = g_strcmp0 (_tmp7_, query) == 0;
					_g_free0 (_tmp7_);
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					gpointer _tmp8_ = NULL;
					gchar* _tmp9_;
					gpointer _tmp10_ = NULL;
					g_debug ("searches.vala:138: search stream exists, updating");
					_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) s, "id");
					_tmp9_ = (gchar*) _tmp8_;
					g_signal_emit_by_name (self, "updated", _tmp9_);
					_g_free0 (_tmp9_);
					_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) s, "id");
					result = (gchar*) _tmp10_;
					_g_object_unref0 (s);
					__g_list_free__g_object_unref0_0 (searches_list);
					return result;
				}
				_g_object_unref0 (s);
			}
		}
	}
	_tmp11_ = g_strconcat ("{\"query\": \"", query, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, "\", \"name\": \"", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp14_, name, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp16_, "\"}", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = searches_interface_Create (self->priv->searches, _tmp18_, &_inner_error_);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp21_ = _tmp20_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch34_g_io_error;
		}
		__g_list_free__g_object_unref0_0 (searches_list);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp21_;
	__g_list_free__g_object_unref0_0 (searches_list);
	return result;
	goto __finally34;
	__catch34_g_io_error:
	{
		GError * e;
		gchar* _tmp22_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("searches.vala:150: %s", e->message);
		_tmp22_ = g_strdup ("");
		result = _tmp22_;
		_g_error_free0 (e);
		__g_list_free__g_object_unref0_0 (searches_list);
		return result;
	}
	__finally34:
	__g_list_free__g_object_unref0_0 (searches_list);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


/**
         * com.Gwibber.Searches
         **/
static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


GList* gwibber_searches_list (GwibberSearches* self) {
	GList* result = NULL;
	GList* searches_list;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	JsonParser* _tmp1_ = NULL;
	JsonParser* parser;
	JsonNode* _tmp2_ = NULL;
	JsonArray* _tmp3_ = NULL;
	JsonArray* _tmp4_;
	JsonArray* nodeArray;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	searches_list = NULL;
	_tmp0_ = searches_interface_List (self->priv->searches, &_inner_error_);
	_result_ = _tmp0_;
	if (_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (searches_list);
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch35_g_io_error;
		}
		__g_list_free__g_object_unref0_0 (searches_list);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp1_ = json_parser_new ();
	parser = _tmp1_;
	json_parser_load_from_data (parser, _result_, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		_g_free0 (_result_);
		__g_list_free__g_object_unref0_0 (searches_list);
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch35_g_io_error;
		}
		goto __finally35;
	}
	_tmp2_ = json_parser_get_root (parser);
	_tmp3_ = json_node_get_array (_tmp2_);
	_tmp4_ = _json_array_ref0 (_tmp3_);
	nodeArray = _tmp4_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				guint _tmp6_;
				GeeHashMap* _tmp7_ = NULL;
				GeeHashMap* searches_map;
				JsonNode* _tmp8_ = NULL;
				JsonObject* _tmp9_ = NULL;
				GList* _tmp10_ = NULL;
				GList* members;
				GeeHashMap* _tmp15_;
				if (!_tmp5_) {
					i++;
				}
				_tmp5_ = FALSE;
				_tmp6_ = json_array_get_length (nodeArray);
				if (!(i < _tmp6_)) {
					break;
				}
				_tmp7_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
				searches_map = _tmp7_;
				_tmp8_ = json_array_get_element (nodeArray, (guint) i);
				_tmp9_ = json_node_get_object (_tmp8_);
				_tmp10_ = json_object_get_members (_tmp9_);
				members = _tmp10_;
				{
					GList* member_collection;
					GList* member_it;
					member_collection = members;
					for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
						gchar* _tmp11_;
						gchar* member;
						_tmp11_ = g_strdup ((const gchar*) member_it->data);
						member = _tmp11_;
						{
							JsonNode* _tmp12_ = NULL;
							JsonObject* _tmp13_ = NULL;
							const gchar* _tmp14_ = NULL;
							_tmp12_ = json_array_get_element (nodeArray, (guint) i);
							_tmp13_ = json_node_get_object (_tmp12_);
							_tmp14_ = json_object_get_string_member (_tmp13_, member);
							gee_abstract_map_set ((GeeAbstractMap*) searches_map, member, _tmp14_);
							_g_free0 (member);
						}
					}
				}
				_tmp15_ = _g_object_ref0 (searches_map);
				searches_list = g_list_append (searches_list, _tmp15_);
				_g_list_free0 (members);
				_g_object_unref0 (searches_map);
			}
		}
	}
	result = searches_list;
	_json_array_unref0 (nodeArray);
	_g_object_unref0 (parser);
	_g_free0 (_result_);
	return result;
	_json_array_unref0 (nodeArray);
	_g_object_unref0 (parser);
	_g_free0 (_result_);
	__g_list_free__g_object_unref0_0 (searches_list);
	goto __finally35;
	__catch35_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("searches.vala:181: %s", e->message);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally35:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


void gwibber_searches_search_deleted (GwibberSearches* self, const gchar* data) {
	JsonParser* _tmp0_ = NULL;
	JsonParser* parser;
	JsonNode* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_;
	JsonObject* root_object;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* id;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	json_parser_load_from_data (parser, data, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		goto __catch36_g_error;
	}
	_tmp1_ = json_parser_get_root (parser);
	_tmp2_ = json_node_get_object (_tmp1_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	root_object = _tmp3_;
	_tmp4_ = json_object_get_string_member (root_object, "id");
	_tmp5_ = g_strdup (_tmp4_);
	id = _tmp5_;
	g_signal_emit_by_name (self, "deleted", id);
	_g_free0 (id);
	_json_object_unref0 (root_object);
	_g_object_unref0 (parser);
	goto __finally36;
	__catch36_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("searches.vala:196: %s", e->message);
		_g_error_free0 (e);
	}
	__finally36:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void gwibber_searches_search_created (GwibberSearches* self, const gchar* data) {
	JsonParser* _tmp0_ = NULL;
	JsonParser* parser;
	JsonNode* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_;
	JsonObject* root_object;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* id;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	json_parser_load_from_data (parser, data, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		goto __catch37_g_error;
	}
	_tmp1_ = json_parser_get_root (parser);
	_tmp2_ = json_node_get_object (_tmp1_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	root_object = _tmp3_;
	_tmp4_ = json_object_get_string_member (root_object, "id");
	_tmp5_ = g_strdup (_tmp4_);
	id = _tmp5_;
	g_signal_emit_by_name (self, "created", id);
	_g_free0 (id);
	_json_object_unref0 (root_object);
	_g_object_unref0 (parser);
	goto __finally37;
	__catch37_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("searches.vala:209: %s", e->message);
		_g_error_free0 (e);
	}
	__finally37:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void gwibber_searches_search_updated (GwibberSearches* self, const gchar* data) {
	JsonParser* _tmp0_ = NULL;
	JsonParser* parser;
	JsonNode* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_;
	JsonObject* root_object;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* id;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	json_parser_load_from_data (parser, data, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		goto __catch38_g_error;
	}
	_tmp1_ = json_parser_get_root (parser);
	_tmp2_ = json_node_get_object (_tmp1_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	root_object = _tmp3_;
	_tmp4_ = json_object_get_string_member (root_object, "id");
	_tmp5_ = g_strdup (_tmp4_);
	id = _tmp5_;
	g_signal_emit_by_name (self, "updated", id);
	_g_free0 (id);
	_json_object_unref0 (root_object);
	_g_object_unref0 (parser);
	goto __finally38;
	__catch38_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("searches.vala:222: %s", e->message);
		_g_error_free0 (e);
	}
	__finally38:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void gwibber_searches_searches_available (GwibberSearches* self, gboolean is_up) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "is-available", is_up);
}


static void gwibber_searches_class_init (GwibberSearchesClass * klass) {
	gwibber_searches_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberSearchesPrivate));
	G_OBJECT_CLASS (klass)->finalize = gwibber_searches_finalize;
	/** 
	            Searches::is_available:
	            @arg0: The current state
	
	            Emitted when com.Gwibber.Searches availability state changes
	*/
	g_signal_new ("is_available", GWIBBER_TYPE_SEARCHES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	g_signal_new ("updated", GWIBBER_TYPE_SEARCHES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("deleted", GWIBBER_TYPE_SEARCHES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("created", GWIBBER_TYPE_SEARCHES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void gwibber_searches_instance_init (GwibberSearches * self) {
	self->priv = GWIBBER_SEARCHES_GET_PRIVATE (self);
}


static void gwibber_searches_finalize (GObject* obj) {
	GwibberSearches * self;
	self = GWIBBER_SEARCHES (obj);
	_g_object_unref0 (self->priv->searches);
	_g_object_unref0 (self->priv->utils);
	G_OBJECT_CLASS (gwibber_searches_parent_class)->finalize (obj);
}


GType gwibber_searches_get_type (void) {
	static volatile gsize gwibber_searches_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_searches_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberSearchesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_searches_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberSearches), 0, (GInstanceInitFunc) gwibber_searches_instance_init, NULL };
		GType gwibber_searches_type_id;
		gwibber_searches_type_id = g_type_register_static (G_TYPE_OBJECT, "GwibberSearches", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_searches_type_id__volatile, gwibber_searches_type_id);
	}
	return gwibber_searches_type_id__volatile;
}



