package gls.invocation

import gls.scope.CompilableTestSupport

public class ConstructorDelegationTest extends CompilableTestSupport {

  public void testThisCallWithParameter() {
    assertScript """
       class A {
         def foo
         A(String x){foo=x}
         A(){this("bar")}
       }
       def a = new A()
       assert a.foo == "bar"
    """   
  }
  
  public void testThisCallWithoutParameter() {
    assertScript """
       class A {
         def foo
         A(String x){this(); foo=x}
         A(){foo="bar"}
       }
       def a = new A("foo")
       assert a.foo == "foo"
    """   
  }

  public void testThisConstructorCallNotOnFirstStmt() {
      def scriptStr = """
          class ThisConstructorCall {
              public ThisConstructorCall() {
                  println 'dummy first statement'
                  this(19)
              }
              public ThisConstructorCall(int b) {
                  println 'another dummy statement'
              }
          }
          1
      """
      shouldNotCompile(scriptStr)
  }

  public void testSuperConstructorCallNotOnFirstStmt() {
      def scriptStr = """
          class SuperConstructorCall {
              public SuperConstructorCall() {
                  println 'dummy first statement'
                  super()
              }
          }
          1
      """
      shouldNotCompile(scriptStr)
  }

  public void testConstructorDelegationWithThisOrSuperInArgs() {
	  def scriptStr
	  // all 4 cases below were compiling earlier but giving VerifyError at runtime
	  scriptStr = """
	  	class MyClosure3128V1 extends Closure {
		    MyClosure3128V1() {
		        super(this)
		    }
		    void run() { println 'running' }
		}
	  """
	  shouldNotCompile(scriptStr)

	  scriptStr = """
	  	class MyClosure3128V2 extends Closure {
	        MyClosure3128V2() {
	            super(super)
	        }
	        void run() { println 'running' }
	  	}
		"""
		shouldNotCompile(scriptStr)

		scriptStr = """
			class MyClosure3128V3 extends Closure {
		        MyClosure3128V3() {
		            this(this)
		        }
		        MyClosure3128V3(owner) {}
		        void run() { println 'running' }
		    }
		  """
		  shouldNotCompile(scriptStr)
		  
		  scriptStr = """
              class MyClosure3128V4 extends Closure {
                  MyClosure3128V4() {
                      this(super)
                  }
                  MyClosure3128V4(owner) {}
                  void run() { println 'running' }
              }
              """
          shouldNotCompile(scriptStr)
  }
}