.ig
groff_tmac.5

File position: <groff-source>/man/groff_tmac.man

This file is part of groff, the GNU roff type-setting system.

Copyright (C) 2000, 2001, 2002, 2003, 2004, 2006, 2007, 2008, 2009
  Free Software Foundation, Inc.
written by Bernd Warken <groff-bernd.warken-72@web.de> and
Werner Lemberg <wl@gnu.org>

Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.3 or
any later version published by the Free Software Foundation; with the
Invariant Sections being this .ig-section and AUTHOR, with no
Front-Cover Texts, and with no Back-Cover Texts.

A copy of the Free Documentation License is included as a file called
FDL in the main directory of the groff source package.
..
.ds Ellipsis \&.\|.\|.\&\"
.
.TH GROFF_TMAC @MAN5EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
groff_tmac \- macro files in the roff typesetting system
.
.
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.\" --------------------------------------------------------------------
.
The
.BR roff (@MAN7EXT@)
type-setting system provides a set of macro packages suitable for
special kinds of documents.
.
Each macro package stores its macros and definitions in a file called
the package's
.BR "tmac file" .
The name is deduced from
.RB ` T\c
.IB roff MAC\c
.IR ros '.
.
.P
The tmac files are normal roff source documents, except that they
usually contain only definitions and setup commands, but no text.
.
All tmac files are kept in a single or a small number of directories,
the
.B tmac
directories.
.
.
.\" --------------------------------------------------------------------
.SH "GROFF MACRO PACKAGES"
.\" --------------------------------------------------------------------
.
.I groff
provides all classical macro packages, some more full packages, and
some secondary packages for special purposes.
.
Note that it is not possible to use multiple primary macro packages at the
same time; saying e.g.\&
.
.IP
.EX
\fIsh#\fP groff \-m man \-m ms foo
.EE
.
.P
or
.
.IP
.EX
\fIsh#\fP groff \-m man foo \-m ms bar
.EE
.
.P
fails.
Exception to this is the use of man pages written with either the
.B mdoc
or the
.B man
macro package.
See below the description of the
.B andoc.tmac
file.
.
.
.\" --------------------------------------------------------------------
.SS "Man\~Pages"
.\" --------------------------------------------------------------------
.
.TP
.B man
This is the classical macro package for UNIX manual pages
(man\~pages); it is quite handy and easy to use; see
.BR groff_man (@MAN7EXT@).
.
.
.TP
.B doc
.TQ
.B mdoc
An alternative macro package for man\~pages mainly used in BSD
systems; it provides many new features, but it is not the standard for
man\~pages; see
.BR groff_mdoc (@MAN7EXT@).
.
.
.TP
.B andoc
.TQ
.B mandoc
Use this file in case you don't know whether the
.B man
macros or the
.B mdoc
package should be used.
Multiple man pages (in either format) can be handled.
.
.
.\" --------------------------------------------------------------------
.SS "Full Packages"
.\" --------------------------------------------------------------------
.
The packages in this section provide a complete set of macros for
writing documents of any kind, up to whole books.
.
They are similar in functionality; it is a matter of taste which one
to use.
.
.
.TP
.B me
The classical
.I me
macro package; see
.BR groff_me (@MAN7EXT@).
.
.
.TP
.B mm
The semi-classical
.I mm
macro package; see
.BR groff_mm (@MAN7EXT@).
.
.
.TP
.B mom
The new
.I mom
macro package, only available in groff.
.
As this is not based on other packages, it can be freely designed.
.
So it is expected to become quite a nice, modern macro package.
.
See
.BR groff_mom (@MAN7EXT@).
.
.
.TP
.B ms
The classical
.I ms
macro package; see
.BR groff_ms (@MAN7EXT@).
.
.
.\" --------------------------------------------------------------------
.SS "Language-specific Packages"
.\" --------------------------------------------------------------------
.
.TP
.B cs
This file adds support for Czech localization, including the main macro
packages (me, mom, mm, and ms).
.
.IP
Note that
.B cs.tmac
sets the input encoding to latin-2.
.
.
.TP
.B de
.TQ
.B den
German localization support, including the main macro packages (me, mom, mm,
and ms).
.
.IP
.B de.tmac
selects hyphenation patterns for traditional orthography, and
.B den.tmac
does the same for the new orthography (`Recht\%schreib\%reform').
.
It should be used as the last macro package on the command line.
.
.
.TP
.B fr
This file adds support for French localization, including the main macro
packages (me, mom, mm, and ms).
.
.
Example:
.RS
.IP
.EX
\fIsh#\fP groff -ms -mfr foo.ms > foo.ps
.EE
.RE
.
.IP
Note that
.B fr.tmac
sets the input encoding to latin-9 to get proper support of the `oe'
ligature.
.
.
.TP
.B sv
Swedish localization support, including the me, mom, and ms macro packages.
.
Note that Swedish for the mm macros is handled separately; see
.BR groff_mmse (@MAN7EXT@).
.
It should be used as the last macro package on the command line.
.
.
.\" --------------------------------------------------------------------
.SS "Input Encodings"
.\" --------------------------------------------------------------------
.
.
.TP
.B latin1
.TQ
.B latin2
.TQ
.B latin5
.TQ
.B latin9
Various input encodings supported directly by groff.
.
Normally, this macro is loaded at the very beginning of a document or
specified as the first macro argument on the command line.
.
.B @g@roff
loads latin1 by default at start-up.
.
Note that these macro packages don't work on EBCDIC hosts.
.
.
.TP
.B cp1047
Encoding support for EBCDIC.
.
On those platforms it is loaded automatically at start-up.
.
Due to different character ranges used in
.B @g@roff
it doesn't work on architectures which are based on ASCII.
.
.
.P
Note that it can happen that some input encoding characters are not
available for a particular output device.
.
For example, saying
.
.P
.EX
groff -Tlatin1 -mlatin9 ...
.EE
.
.P
fails if you use the Euro character in the input.
.
Usually, this limitation is present only for devices which have a
limited set of output glyphs
.RB ( \-Tascii ,
.BR \-Tlatin1 );
for other devices it is usually sufficient to install proper
fonts which contain the necessary glyphs.
.
.
.\" --------------------------------------------------------------------
.SS "Special Packages"
.\" --------------------------------------------------------------------
.
The macro packages in this section are not intended for stand-alone
usage, but can be used to add special functionality to any other
macro package or to plain groff.
.
.
.TP
.B 60bit
Provide some macros for addition, multiplication, and division of 60bit
integers (allowing safe multiplication of 30bit integers, for example).
.
.
.TP
.B ec
Switch to the EC and TC font families.
.
To be used with
.BR \%grodvi (@MAN1EXT@)
\[en] this man page also gives more details of how to use it.	
.
.
.TP
.B papersize
This macro file is already loaded at start-up by
.B @g@troff
so it isn't necessary to call it explicitly.
.
It provides an interface to set the paper size on the command line with
the option \f[B]\%\-dpaper=\f[]\f[I]size\f[].
.
Possible values for
.I size
are the same as the predefined
.B papersize
values in the DESC file (only lowercase; see
.BR groff_font (@MAN5EXT@)
for more) except
.BR a7 - d7 .
.
An appended
.B l
(ell) character denotes landscape orientation.
.
Examples:
.BR a4 ,
.BR c3l ,
.BR letterl .
.
.IP
Most output drivers need additional command line switches
.B \-p
and
.B \-l
to override the default paper length and orientation as set in the driver
specific DESC file.
.
For example, use the following for PS output on A4 paper in landscape
orientation:
.
.IP
.EX
.SM
\fIsh#\fP groff \-Tps \-dpaper=a4l \-P\-pa4 \-P\-l \-ms foo.ms > foo.ps
.EE
.
.
.TP
.B pic
This file provides proper definitions for the macros
.B PS
and
.BR PE ,
needed for the
.BR @g@pic (@MAN1EXT@)
preprocessor.
.
They center each picture.
.
Use it only if your macro package doesn't provide proper definitions
for those two macros (actually, most of them already do).
.
.
.TP
.B pspic
A single macro is provided in this file,
.BR PSPIC ,
to include a PostScript graphic in a document.
.
The following output devices support inclusion of PS images:
.BR \-Tps ,
.BR \-Tdvi ,
.BR \-Thtml ,
and
.BR \-Txhtml ;
for all other devices the image is replaced with a hollow rectangle
of the same size.
.
This macro file is already loaded at start-up by
.B @g@troff
so it isn't necessary to call it explicitly.
.
.IP
Syntax:
.RS
.IP
\&\fB.PSPIC\fP \
[\fB\-L\fP\|\
|\|\fB\-R\fP\|\
|\|\fB\-C\fP\|\
|\|\fB\-I\fP\ \fIn\fP] \
\fI\|file\fP [\fIwidth\fP [\fIheight\fP]]
.RE
.
.IP
.I file
is the name of the PostScript file;
.I width
and
.I height
give the desired width and height of the image.
.
If neither a
.I width
nor a
.I height
argument is specified, the image's natural width (as given in
the file's bounding box) or the current line length is used
as the width, whatever is smaller.
.
The
.I width
and
.I height
arguments may have scaling indicators attached;
the default scaling indicator is\~\c
.BR i .
.
This macro scales the graphic uniformly
in the x and y\~directions so that it is no more than
.I width
wide
and
.I height
high.
.
Option
.B \-C
centers the graphic horizontally, which is the default.
.
The
.B \-L
and
.B \-R
options cause the graphic to be left-aligned and right-aligned,
respectively.
.
The
.B \-I
option causes the graphic to be indented by\~\c
.I n
(default scaling indicator is\~\c
.BR m ).
.
.IP
For use of
.B .PSPIC
within a diversion it is recommended to extend it with
the following code, assuring that the diversion's width completely
covers the image's width.
.
.RS
.IP
.EX
\&.am PSPIC
\&.\ \ vpt 0
\&\[rs]h'(\[rs]\[rs]n[ps-offset]u + \[rs]\[rs]n[ps-deswid]u)'
\&.\ \ sp -1
\&.\ \ vpt 1
\&..
.EE
.RE
.
.
.TP
.B ptx
A single macro is provided in this file,
.BR xx ,
for formatting permuted index entries as produces by the GNU
.BR ptx (1)
program.
.
In case you need a different formatting, copy the macro into
your document and adapt it to your needs.
.
.
.TP
.B trace
Use this for tracing macro calls.
.
It is only useful for debugging.
.
See
.BR groff_trace (@MAN7EXT@) .
.
.
.TP
.B tty-char
Overrides the definition of standard troff characters and some groff
characters for TTY devices.
.
The optical appearance is intentionally inferior compared to that of
normal TTY formatting to allow processing with critical equipment.
.
.
.TP
.B www
Additions of elements known from the HTML format, as used in the
internet (World Wide Web) pages; this includes URL links and mail
addresses; see
.BR groff_www (@MAN7EXT@).
.
.
.\" --------------------------------------------------------------------
.SH NAMING
.\" --------------------------------------------------------------------
.
Classical roff systems were designed before the conventions of the
modern C 
.BR getopt (3)
call evolved, and used a naming scheme for macro packages that looks
odd to modern eyes. Macro packages were always included with the option
.BR \-m ;
when this option was directly followed by its argument without an
intervening space, this looked like a long option preceded by a single
minus \[em] a sensation in the computer stone age.
To make this invocation form work, classical troff
macro packages used names that started with the letter `m',
which was omitted in the naming of the macro file.
.
.
.P
For example, the macro package for the man pages was called
.IR man ,
while its macro file
.IR tmac.an .
So it could be activated by the argument
.I an
to option
.BR \-m ,
or
.BR \-man
for short.
.
.
.P
For similar reasons, macro packages that did not start with an `m'
had a leading `m'
added in the documentation and in speech; for example, the package
corresponding to
.I tmac.doc
was called
.I mdoc
in the documentation, although a more suitable name would be
.IR doc .
For, when omitting the space between the option and its argument, the
command line option for activating this package reads
.BR \-mdoc .
.
.
.P
To cope with all situations, actual versions of
.BR groff (@MAN1EXT@)
are smart about both naming schemes by providing two macro files
for the inflicted macro packages; one with a leading `m'
the other one without it.
.
So in
.IR groff ,
the
.I man
macro package may be specified as on of the following four methods:
.
.IP
.EX
\fIsh#\fP groff\ \-m\ man
\fIsh#\fP groff\ \-man
\fIsh#\fP groff\ \-mman
\fIsh#\fP groff\ \-m\ an
.EE
.
.
.P
Recent packages that do not start with `m'
do not use an additional `m'
in the documentation.
.
For example, the
.I www
macro package may be specified only as one of the two methods:
.
.IP
.EX
\fIsh#\fP groff\ \-m\ www
\fIsh#\fP groff\ \-mwww
.EE
.
.
.P
Obviously, variants like
.I \-mmwww
would not make much sense.
.
.
.P
A second strange feature of classical troff was to name macro files
in the form \f[B]tmac.\f[]\f[I]name\f[].
In modern operating systems, the type of a file is specified as a
postfix, the file name extension.
.
Again, groff copes with this situation by searching both
.IB anything .tmac
and
.BI tmac. anything
if only
.I anything
is specified.
.
.
.P
The easiest way to find out which macro packages are available on a
system is to check the man\~page
.BR groff (@MAN1EXT@),
or the contents of the
.I tmac
directories.
.
.
.P
In
.IR groff ,
most macro packages are described in\~man pages called
.BR groff_\f[I]name\f[] (@MAN7EXT@),
with a leading `m'
for the classical packages.
.
.
.\" --------------------------------------------------------------------
.SH INCLUSION
.\" --------------------------------------------------------------------
.
There are several ways to use a macro package in a document.
.
The classical way is to specify the troff/groff option
.BR \-m
.I name
at run-time; this makes the contents of the macro package
.I name
available.
.
In groff, the file
.IB name .tmac
is searched within the tmac path; if not found,
.BI tmac. name
is searched for instead.
.
.
.P
Alternatively, it is also possible to include a macro file by adding
the request
.B .so
.I filename
into the document; the argument must be the full file name of an
existing file, possibly with the directory where it is kept.
.
In groff, this was improved by the similar request
.B .mso
.IR package ,
which added searching in the tmac path, just like option
.BR \-m
does.
.
.
.P
Note that in order to resolve the
.B .so
and
.B .mso
requests, the roff preprocessor
.BR soelim (@MAN1EXT@)
must be called if the files to be included need preprocessing.
.
This can be done either directly by a pipeline on the command line or
by using the troff/groff option
.BR \-s .
.
.I man
calls soelim automatically.
.
.
.P
For example, suppose a macro file is stored as
.
.IP
.I @MACRODIR@/macros.tmac
.
.P
and is used in some document called
.IR docu.roff .
.
.
.P
At run-time, the formatter call for this is
.
.IP
.EX
\fIsh#\fP groff \-m macros docu.roff
.EE
.
.
.P
To include the macro file directly in the document either
.
.IP
.EX
\&.mso macros.tmac
.EE
.
.P
is used or
.
.IP
.EX
\&.so @MACRODIR@/macros.tmac
.EE
.
.
.P
In both cases, the formatter should be called with option
.B \-s
to invoke
.BR soelim .
.IP
.EX
\fIsh#\fP groff \-s docu.roff
.EE
.
.
.P
If you want to write your own groff macro file, call it
.IB whatever .tmac
and put it in some directory of the tmac path, see section
.BR FILES .
Then documents can include it with the
.B .mso
request or the option
.BR \-m .
.
.
.ig
.\" --------------------------------------------------------------------
.SH CONVENTION
.\" --------------------------------------------------------------------
.
.\" This section does not fit into the framework of this document.
.
There is a convention that is supported by many modern roff
type-setters and
.BR man (1)
programs, the
.I preprocessor word
described in the following.
.
.P
If the first line in a document is a comment, the first word (after the
comment characters and a blank) constitutes the
.B preprocessor
.BR word .
That means that the letters of this word are interpreted as
abbreviations for those preprocessor commands that should be run
when formatting the document.
.
Mostly, only the letters corresponding to the options for the
preprocessors are recognized, 
`e'
(for
.BR eqn ),
.\" `G',
.\" `g',
`p`
(for
.BR pic ),
`R'
(for
.BR refer ),
`s'
(for
.BR soelim ),
and
`t'
(for
.BR tbl ).
(see
.BR roff (@MAN7EXT@)).
.
.
.P
Besides being a good reminder for the user, some formatters (like the
.BR man (1)
program) are even able to automatically start the preprocessors
specified in the preprocessor word, but do not bet on this.
.
.
.P
The
.I man
program handles some preprocessors automatically, such that in
man\~pages only the following characters should be used:
`e', `p', and `t'.
.
.
..
.\" --------------------------------------------------------------------
.SH "WRITING MACROS"
.\" --------------------------------------------------------------------
.
A
.BR roff (@MAN7EXT@)
document is a text file that is enriched by predefined formatting
constructs, such as requests, escape sequences, strings, numeric
registers, and macros from a macro package.
.
These elements are described in
.BR roff (@MAN7EXT@).
.
.
.P
To give a document a personal style, it is most useful to extend the
existing elements by defining some macros for repeating tasks; the best
place for this is near the beginning of the document or in a separate
file.
.
.
.P
Macros without arguments are just like strings.
.
But the full power of macros reveals when arguments are passed with a
macro call.
.
Within the macro definition, the arguments are available as the escape
sequences
.BR \[rs]$1 ,
\*[Ellipsis],
.BR \[rs]$9 ,
.BR \[rs]$[ \*[Ellipsis] ] ,
.BR \[rs]$* ,
and
.BR \[rs]$@ ,
the name under which the macro was called is in
.BR \[rs]$0 ,
and the number of arguments is in register
.BR \[rs]n[.$] ;
see
.BR groff (@MAN7EXT@).
.
.
.\" --------------------------------------------------------------------
.SS "Copy-in Mode"
.\" --------------------------------------------------------------------
.
The phase when groff reads a macro is called
.I "copy-in mode"
or
.I "copy mode"
in roff-talk.
.
This is comparable to the C\~preprocessing phase during the development
of a program written in the C\~language.
.
.
.P
In this phase, groff interprets all backslashes; that means that all
escape sequences in the macro body are interpreted and replaced by
their value.
.
For constant expressions, this is wanted, but strings and registers
that might change between calls of the macro must be protected from
being evaluated.
.
This is most easily done by doubling the backslash that introduces the
escape sequence.
.
This doubling is most important for the positional parameters.
.
For example, to print information on the arguments that were passed to
the macro to the terminal, define a macro named `.print_args',
say.
.
.
.IP
.ds @1 \[rs]f[I]\[rs]\[rs]$0\[rs]f[]\"
.ds @2 arguments:\"
.EX
\&.ds midpart was called with
\&.de print_args
\&.\ \ tm\ \*[@1]\ \[rs]*[midpart]\ \[rs]\[rs]n[.$]\ \*[@2]
\&.\ \ tm\ \[rs]\[rs]$*
\&..
.EE
.rm @1
.rm @2
.
.
.P
When calling this macro by
.
.IP
.EX
\&.print_args arg1 arg2
.EE
.
.P
the following text is printed to the terminal:
.
.IP
.EX
\&\f[CI]print_args\f[] was called with the following 2 arguments:
arg1 arg2
.EE
.
.
.P
Let's analyze each backslash in the macro definition.
.
As the positional parameters and the number of arguments change
with each call of the macro their leading backslash must be doubled,
which results in
.I \[rs]\[rs]$*
and
.IR \[rs]\[rs][.$] .
The same applies to the macro name because it could be called with an
alias name, so
.IR \[rs]\[rs]$0 .
.
.
.P
On the other hand,
.I midpart
is a constant string, it does not change, so no doubling for
.IR \[rs]*[midpart] .
The
.I \[rs]f
escape sequences are predefined groff elements for setting the font
within the text.
.
Of course, this behavior does not change, so no doubling with
.I \[rs]f[I]
and
.IR \[rs]f[] .
.
.
.\" --------------------------------------------------------------------
.SS "Draft Mode"
.\" --------------------------------------------------------------------
.
Writing groff macros is easy when the escaping mechanism is temporarily
disabled.
.
In groff, this is done by enclosing the macro definition(s) into a
pair of
.B .eo
and
.B .ec
requests.
.
Then the body in the macro definition is just like a normal part of
the document \[em] text enhanced by calls of requests, macros,
strings, registers, etc.
.
For example, the code above can be written in a simpler way by
.
.
.IP
.ds @1 \[rs]f[I]\[rs]$0\[rs]f[]\"
.ds @2 arguments:\"
.EX
\&.eo
\&.ds midpart was called with
\&.de print_args
\&.\ \ tm\ \*[@1]\ \[rs]*[midpart]\ \[rs]n[.$]\ \*[@2]
\&.\ \ tm\ \[rs]$*
\&..
\&.ec
.EE
.rm @1
.rm @2
.
.
.P
Unfortunately, draft mode cannot be used universally.
.
Although it is good enough for defining normal macros, draft mode
fails with advanced applications, such as indirectly defined
strings, registers, etc.
.
An optimal way is to define and test all macros in draft mode and then
do the backslash doubling as a final step; do not forget to remove the
.I .eo
request.
.
.
.\" --------------------------------------------------------------------
.SS "Tips for Macro Definitions"
.\" --------------------------------------------------------------------
.
.IP \(bu
Start every line with a dot, for example, by using the groff request
.B .nop
for text lines, or write your own macro that handles also text lines
with a leading dot.
.
.RS
.IP
.EX
\&.de Text
\&.\ \ if (\[rs]\[rs]n[.$] == 0)\ \[rs]
\&.\ \ \ \ return
\&.\ \ nop\ \[rs])\[rs]\[rs]$*\[rs])
\&..
.EE
.RE
.
.IP \(bu
Write a comment macro that works both for copy-in and draft mode; for
as escaping is off in draft mode, trouble might occur when normal
comments are used.
.
For example, the following macro just ignores its arguments, so it
acts like a comment line:
.
.RS
.IP
.EX
\&.de\ c
\&..
\&.c\ This\ is\ like\ a\ comment\ line.
.EE
.RE
.
.IP \(bu
In long macro definitions, make ample use of comment lines or
almost-empty lines (this is, lines which have a leading dot
and nothing else) for a better structuring.
.
.IP \(bu
To increase readability, use groff's indentation facility for requests
and macro calls (arbitrary whitespace after the leading dot).
.
.
.\" --------------------------------------------------------------------
.SS "Diversions"
.\" --------------------------------------------------------------------
.
Diversions can be used to implement quite advanced programming
constructs.
.
They are comparable to pointers to large data structures in the
C\~programming language, but their usage is quite different.
.
.
.P
In their simplest form, diversions are multi-line strings, but
they get their power when diversions are used dynamically within macros.
.
The (formatted) information stored in a diversion can be retrieved by
calling the diversion just like a macro.
.
.
.P
Most of the problems arising with diversions can be avoided if you remain
aware of the fact that diversions always store complete lines.
.
If diversions are used when the line buffer has not been flushed,
strange results are produced; not knowing this, many people get
desperate about diversions.
.
To ensure that a diversion works, line breaks should be added at the
right places.
.
To be on the secure side, enclose everything that has to do with
diversions into a pair of line breaks; for example, by explicitly using
.B .br
requests.
.
This rule should be applied to diversion definition, both inside and
outside, and to all calls of diversions.
.
This is a bit of overkill, but it works nicely.
.
.
.P
[If you really need diversions which should ignore the current partial
line, use environments to save the current partial line and/\:or use the
.B .box
request.]
.
.
.P
The most powerful feature using diversions is to start a diversion
within a macro definition and end it within another macro.
.
Then everything between each call of this macro pair is stored within
the diversion and can be manipulated from within the macros.
.
.
.\" --------------------------------------------------------------------
.SH FILES
.\" --------------------------------------------------------------------
.
All macro names must be named
.IB name .tmac
to fully use the tmac mechanism.
.
.BI tmac. name
as with classical packages is possible as well, but deprecated.
.
.
.P
The macro files are kept in the
.IR "tmac directories" ;
a colon separated list of these constitutes the
.IR "tmac path" .
.
.
.P
The search sequence for macro files is (in that order):
.
.IP \(bu
the directories specified with troff/groff's
.B \-M
command line option
.
.IP \(bu
the directories given in the
.B $GROFF_TMAC_PATH
environment variable
.
.IP \(bu
the current directory (only if in unsafe mode, which is enabled by the
.B \-U
command line switch)
.
.IP \(bu
the home directory
.
.IP \(bu
a platform-specific directory, being
.
.RS
.IP
.B @SYSTEMMACRODIR@
.RE
.
.IP
in this installation
.
.IP \(bu
a site-specific (platform-independent) directory, being
.
.RS
.IP
.B @LOCALMACRODIR@
.RE
.
.IP
in this installation
.
.IP \(bu
the main tmac directory, being
.
.RS
.IP
.B @MACRODIR@
.RE
.
.IP
in this installation
.
.
.\" --------------------------------------------------------------------
.SH ENVIRONMENT
.\" --------------------------------------------------------------------
.
.TP
.B $GROFF_TMAC_PATH
A colon separated list of additional tmac directories in which to search
for macro files.
.
See the previous section for a detailed description.
.
.
.\" --------------------------------------------------------------------
.SH AUTHOR
.\" --------------------------------------------------------------------
.
Copyright (C) 2000, 2001, 2002, 2003, 2004, 2006, 2007, 2008, 2009
Free Software Foundation, Inc.
.
.P
This document is distributed under the terms of the FDL (GNU Free
Documentation License) version 1.3 or later.
.
You should have received a copy of the FDL on your system, it is also
available on-line at the
.UR http://\:www.gnu.org/\:copyleft/\:fdl.html
GNU copyleft site
.UE .
.
.P
This document is part of
.IR groff ,
the GNU roff distribution.
.
It was written by
.MT groff-bernd.warken-72@web.de
Bernd Warken
.ME ;
it is maintained by
.MT wl@gnu.org
Werner Lemberg 
.ME .
.
.
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
.
A complete reference for all parts of the groff system is found in the
groff
.BR info (1)
file.
.
.
.TP
.BR groff (@MAN1EXT@)
an overview of the groff system.
.
.
.TP
.BR groff_man (@MAN7EXT@),
.TQ
.BR groff_mdoc (@MAN7EXT@),
.TQ
.BR groff_me (@MAN7EXT@),
.TQ
.BR groff_mm (@MAN7EXT@),
.TQ
.BR groff_mom (@MAN7EXT@),
.TQ
.BR groff_ms (@MAN7EXT@),
.TQ
.BR groff_trace (@MAN7EXT@),
.TQ
.BR groff_www (@MAN7EXT@).
the groff tmac macro packages.
.
.
.TP
.BR groff (@MAN7EXT@)
the groff language.
.
.
.P
The Filesystem Hierarchy Standard is available at the
.UR http://\:www.pathname.com/\:fhs/
FHS web site
.UE .
.
.\" Local Variables:
.\" mode: nroff
.\" End:
