// This file was generated by go generate; DO NOT EDIT

package language

import "golang.org/x/text/internal/tag"

// Version is the version of CLDR used to generate the data in this package.
const Version = "27.0.1"

const numLanguages = 8632

const numScripts = 223

const numRegions = 354

const numCurrencies = 296

type fromTo struct {
	from uint16
	to   uint16
}

const nonCanonicalUnd = 633
const (
	_af  = 10
	_am  = 16
	_ar  = 20
	_az  = 34
	_bg  = 54
	_bn  = 72
	_ca  = 94
	_cs  = 118
	_da  = 125
	_de  = 130
	_el  = 150
	_en  = 151
	_es  = 153
	_et  = 155
	_fa  = 160
	_fi  = 164
	_fil = 165
	_fr  = 170
	_gu  = 205
	_he  = 217
	_hi  = 218
	_hr  = 230
	_hu  = 234
	_hy  = 235
	_id  = 240
	_is  = 250
	_it  = 251
	_ja  = 255
	_ka  = 264
	_kk  = 294
	_km  = 298
	_kn  = 300
	_ko  = 301
	_ky  = 324
	_lo  = 348
	_lt  = 352
	_lv  = 359
	_mk  = 387
	_ml  = 388
	_mn  = 389
	_mo  = 392
	_mr  = 396
	_ms  = 400
	_mul = 404
	_my  = 411
	_nb  = 420
	_ne  = 425
	_nl  = 434
	_no  = 438
	_pa  = 459
	_pl  = 475
	_pt  = 483
	_ro  = 503
	_ru  = 507
	_sh  = 536
	_si  = 539
	_sk  = 541
	_sl  = 543
	_sq  = 556
	_sr  = 557
	_sv  = 569
	_sw  = 570
	_ta  = 578
	_te  = 585
	_th  = 590
	_tl  = 601
	_tn  = 604
	_tr  = 608
	_uk  = 630
	_ur  = 636
	_uz  = 637
	_vi  = 642
	_zh  = 689
	_zu  = 691
	_jbo = 6818
	_ami = 1014
	_bnn = 1721
	_hak = 214
	_tlh = 13831
	_lb  = 331
	_nv  = 447
	_pwn = 11419
	_tao = 13552
	_tay = 13562
	_tsu = 14026
	_nn  = 436
	_sfb = 12993
	_vgt = 15065
	_sgg = 13024
	_cmn = 2371
	_nan = 417
	_hsn = 232
)

const langPrivateStart = 0x2cf6

const langPrivateEnd = 0x2efd

// lang holds an alphabetically sorted list of ISO-639 language identifiers.
// All entries are 4 bytes. The index of the identifier (divided by 4) is the language tag.
// For 2-byte language identifiers, the two successive bytes have the following meaning:
//     - if the first letter of the 2- and 3-letter ISO codes are the same:
//       the second and third letter of the 3-letter ISO code.
//     - otherwise: a 0 and a by 2 bits right-shifted index into altLangISO3.
// For 3-byte language identifiers the 4th byte is 0.
// Size: 2780 bytes
const lang tag.Index = "" +
	"---\x00aaarabbkabr\x00ace\x00ach\x00ada\x00ady\x00aeveaeb\x00affragq\x00" +
	"akkaakk\x00aln\x00alt\x00ammhamo\x00anrgaoz\x00arraarc\x00arn\x00aro\x00" +
	"arq\x00ary\x00arz\x00assmasa\x00ast\x00atj\x00avvaawa\x00ayymazzeazb\x00" +
	"baakbal\x00ban\x00bap\x00bar\x00bas\x00bax\x00bbc\x00bbj\x00bci\x00beelb" +
	"em\x00bew\x00bez\x00bfd\x00bfq\x00bft\x00bfy\x00bgulbgc\x00bgx\x00bhihbh" +
	"b\x00bhi\x00bhk\x00bho\x00biisbik\x00bin\x00bjj\x00bjn\x00bkm\x00bku\x00" +
	"blt\x00bmambmq\x00bnenboodbpy\x00bqi\x00bqv\x00brrebra\x00brh\x00brx\x00" +
	"bsosbsq\x00bss\x00bto\x00btv\x00bua\x00buc\x00bug\x00bum\x00bvb\x00byn" +
	"\x00byv\x00bze\x00caatcch\x00ccp\x00ceheceb\x00cgg\x00chhachk\x00chm\x00" +
	"cho\x00chp\x00chr\x00cja\x00cjm\x00ckb\x00cooscop\x00cps\x00crrecrj\x00c" +
	"rk\x00crl\x00crm\x00crs\x00csescsb\x00csw\x00ctd\x00cuhucvhvcyymdaandak" +
	"\x00dar\x00dav\x00dcc\x00deeuden\x00dgr\x00dje\x00dnj\x00doi\x00dsb\x00d" +
	"tm\x00dtp\x00dua\x00dvivdyo\x00dyu\x00dzzoebu\x00eeweefi\x00egl\x00egy" +
	"\x00eky\x00elllenngeopoes\x00\x05esu\x00etstett\x00euusewo\x00ext\x00faa" +
	"sfan\x00ffulffm\x00fiinfil\x00fit\x00fjijfoaofon\x00frrafrc\x00frp\x00fr" +
	"r\x00frs\x00fud\x00fuq\x00fur\x00fuv\x00fyrygalegaa\x00gag\x00gan\x00gay" +
	"\x00gbm\x00gbz\x00gcr\x00gdlagez\x00ggn\x00gil\x00gjk\x00gju\x00gllgglk" +
	"\x00gnrngom\x00gon\x00gor\x00gos\x00got\x00grc\x00grt\x00gsw\x00guujgub" +
	"\x00guc\x00gur\x00guz\x00gvlvgvr\x00gwi\x00haauhak\x00haw\x00haz\x00heeb" +
	"hiinhif\x00hil\x00hmd\x00hnd\x00hne\x00hnj\x00hnn\x00hno\x00homohoc\x00h" +
	"oj\x00hrrvhsb\x00hsn\x00htathuunhyyehzerianaiba\x00ibb\x00idndieleigboii" +
	"iiikpkikt\x00ilo\x00inndinh\x00iodoisslittaiukuiw\x00\x03izh\x00japnjam" +
	"\x00jgo\x00ji\x00\x06jmc\x00jml\x00jut\x00jvavjwavkaatkaa\x00kab\x00kac" +
	"\x00kaj\x00kam\x00kao\x00kbd\x00kcg\x00kck\x00kde\x00kdt\x00kea\x00ken" +
	"\x00kfo\x00kfr\x00kfy\x00kgonkge\x00kgp\x00kha\x00khb\x00khn\x00khq\x00k" +
	"ht\x00khw\x00kiikkiu\x00kjuakjg\x00kkazkkj\x00klalkln\x00kmhmkmb\x00knan" +
	"koorkoi\x00kok\x00kos\x00kpe\x00kraukrc\x00kri\x00krj\x00krl\x00kru\x00k" +
	"sasksb\x00ksf\x00ksh\x00kuurkum\x00kvomkvr\x00kvx\x00kw\x00\x01kxm\x00kx" +
	"p\x00kyirlaatlab\x00lad\x00lag\x00lah\x00laj\x00lbtzlbe\x00lbw\x00lcp" +
	"\x00lep\x00lez\x00lgugliimlif\x00lij\x00lis\x00ljp\x00lki\x00lkt\x00lmn" +
	"\x00lmo\x00lninloaolol\x00loz\x00lrc\x00ltitltg\x00luublua\x00luo\x00luy" +
	"\x00luz\x00lvavlwl\x00lzh\x00lzz\x00mad\x00maf\x00mag\x00mai\x00mak\x00m" +
	"an\x00mas\x00maz\x00mdf\x00mdh\x00mdr\x00men\x00mer\x00mfa\x00mfe\x00mgl" +
	"gmgh\x00mgo\x00mgp\x00mgy\x00mhahmirimin\x00mis\x00mkkdmlalmnonmni\x00mn" +
	"w\x00moolmoe\x00moh\x00mos\x00mrarmrd\x00mrj\x00mru\x00mssamtltmtr\x00mu" +
	"a\x00mul\x00mus\x00mvy\x00mwk\x00mwr\x00mwv\x00mxc\x00myyamyv\x00myx\x00" +
	"myz\x00mzn\x00naaunan\x00nap\x00naq\x00nbobnch\x00nddendc\x00nds\x00neep" +
	"new\x00ngdongl\x00nhe\x00nhw\x00nij\x00niu\x00njo\x00nlldnmg\x00nnnonnh" +
	"\x00noornod\x00noe\x00non\x00nqo\x00nrblnsk\x00nso\x00nus\x00nvavnxq\x00" +
	"nyyanym\x00nyn\x00nzi\x00occiojjiomrmorriosssotk\x00paanpag\x00pal\x00pa" +
	"m\x00pap\x00pau\x00pcd\x00pcm\x00pdc\x00pdt\x00peo\x00pfl\x00phn\x00pili" +
	"pka\x00pko\x00plolpms\x00pnt\x00pon\x00pra\x00prd\x00prg\x00psusptorpuu" +
	"\x00quuequc\x00qug\x00raj\x00rcf\x00rej\x00rgn\x00ria\x00rif\x00rjs\x00r" +
	"kt\x00rmohrmf\x00rmo\x00rmt\x00rmu\x00rnunrng\x00roonrob\x00rof\x00rtm" +
	"\x00ruusrue\x00rug\x00rw\x00\x04rwk\x00ryu\x00saansaf\x00sah\x00saq\x00s" +
	"as\x00sat\x00saz\x00sbp\x00scrdsck\x00scn\x00sco\x00scs\x00sdndsdc\x00se" +
	"mesef\x00seh\x00sei\x00ses\x00sgagsga\x00sgs\x00sh\x00\x02shi\x00shn\x00" +
	"siinsid\x00sklkskr\x00sllvsli\x00sly\x00smmosma\x00smj\x00smn\x00smp\x00" +
	"sms\x00snnasnk\x00soomsou\x00sqqisrrpsrb\x00srn\x00srr\x00srx\x00ssswssy" +
	"\x00stotstq\x00suunsuk\x00sus\x00svweswwaswb\x00swc\x00swv\x00sxn\x00syl" +
	"\x00syr\x00szl\x00taamtaj\x00tbw\x00tcy\x00tdd\x00tdg\x00tdh\x00teeltem" +
	"\x00teo\x00tet\x00tggkthhathl\x00thq\x00thr\x00tiirtig\x00tiv\x00tkuktkl" +
	"\x00tkr\x00tkt\x00tlgltly\x00tmh\x00tnsntoontog\x00tpi\x00trurtru\x00trv" +
	"\x00tssotsd\x00tsf\x00tsg\x00tsj\x00ttatttj\x00tts\x00ttt\x00tum\x00tvl" +
	"\x00twwitwq\x00tyahtyv\x00tzm\x00udm\x00ugiguga\x00ukkruli\x00umb\x00und" +
	"\x00unr\x00unx\x00urrduzzbvai\x00veenvec\x00vep\x00viievic\x00vls\x00vmf" +
	"\x00vmw\x00voolvot\x00vro\x00vun\x00walnwae\x00wal\x00war\x00wbp\x00wbq" +
	"\x00wbr\x00wls\x00woolwtm\x00wuu\x00xav\x00xcr\x00xhhoxlc\x00xld\x00xmf" +
	"\x00xmn\x00xmr\x00xna\x00xnr\x00xog\x00xpr\x00xsa\x00xsr\x00yao\x00yap" +
	"\x00yav\x00ybb\x00yiidyooryrl\x00yua\x00zahazbl\x00zdj\x00zea\x00zgh\x00" +
	"zhhozmi\x00zuulzxx\x00zza\x00\xff\xff\xff\xff"

const langNoIndexOffset = 694

// langNoIndex is a bit vector of all 3-letter language codes that are not used as an index
// in lookup tables. The language ids for these language codes are derived directly
// from the letters and are not consecutive.
// Size: 2197 bytes, 2197 elements
var langNoIndex = [2197]uint8{
	// Entry 0 - 3F
	0xff, 0xfd, 0xfd, 0xfe, 0xef, 0xf7, 0xbf, 0xd2,
	0xfb, 0xbf, 0xfe, 0xfa, 0xb7, 0x1d, 0x3c, 0x57,
	0x6f, 0x97, 0x73, 0xf8, 0xff, 0xef, 0xff, 0x70,
	0xbf, 0x03, 0xff, 0xff, 0xcf, 0x05, 0x85, 0x62,
	0xe9, 0xbf, 0xfd, 0xff, 0xff, 0xf7, 0xfd, 0x77,
	0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3,
	0xc9, 0xff, 0xff, 0xff, 0x4d, 0xb8, 0x0a, 0x6a,
	0x7e, 0xfa, 0xe3, 0xff, 0x7e, 0xff, 0x77, 0xff,
	// Entry 40 - 7F
	0xff, 0xff, 0xff, 0xdf, 0x2b, 0xf4, 0xf1, 0xe0,
	0x5d, 0xe7, 0x9f, 0x14, 0x07, 0x20, 0xdf, 0xed,
	0x9f, 0x37, 0xc9, 0x21, 0xf8, 0x3f, 0x94, 0xf7,
	0x7e, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff,
	0xff, 0xff, 0x7f, 0xfc, 0xdb, 0xfd, 0xbf, 0xb5,
	0x7b, 0xff, 0x7f, 0xf7, 0xeb, 0xfe, 0xff, 0xa7,
	0xbd, 0xff, 0x7f, 0xf7, 0xff, 0xef, 0xef, 0xef,
	0xff, 0xff, 0x9f, 0xff, 0xff, 0xef, 0xff, 0xdf,
	// Entry 80 - BF
	0xff, 0xff, 0xf3, 0xff, 0xfb, 0x2f, 0xff, 0xff,
	0xfb, 0xee, 0xff, 0xbd, 0xdb, 0xff, 0xdf, 0xf7,
	0xff, 0xfa, 0xfd, 0xff, 0x7e, 0xaf, 0x7b, 0xfe,
	0x7f, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xdf, 0xff,
	0xff, 0xdf, 0xfb, 0xff, 0xfd, 0xfc, 0xfb, 0xff,
	0xff, 0xff, 0xff, 0xf7, 0x7f, 0xbf, 0xfd, 0xd5,
	0xa5, 0x77, 0x40, 0xff, 0x9c, 0xc1, 0x41, 0x2c,
	0x08, 0x24, 0x41, 0x00, 0x50, 0x40, 0x00, 0x80,
	// Entry C0 - FF
	0xfb, 0x4a, 0xf2, 0x9f, 0xb4, 0x42, 0x41, 0x96,
	0x9b, 0x14, 0x88, 0xf6, 0x7b, 0xe7, 0x17, 0x56,
	0x55, 0x7d, 0x0e, 0x1c, 0x37, 0x71, 0xf3, 0xef,
	0x97, 0xff, 0x5d, 0x38, 0x64, 0x08, 0x00, 0x10,
	0xbc, 0x87, 0xaf, 0xdf, 0xff, 0xf7, 0x73, 0x35,
	0x3e, 0x87, 0xc7, 0xdf, 0xff, 0x00, 0x81, 0x00,
	0xb0, 0x05, 0x80, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x40, 0x00, 0x40, 0x92, 0x21, 0xd0, 0xbf, 0x5d,
	// Entry 100 - 13F
	0xfd, 0xde, 0xfe, 0x5e, 0x00, 0x00, 0x02, 0x64,
	0x8d, 0x19, 0xc1, 0xdf, 0x79, 0x22, 0x00, 0x00,
	0x00, 0xdf, 0x6d, 0xdc, 0x26, 0xe5, 0xd9, 0xf3,
	0xfe, 0xff, 0xfd, 0xcb, 0x9f, 0x14, 0x01, 0x0c,
	0x86, 0x00, 0xd1, 0x00, 0xf0, 0xc5, 0x67, 0x5f,
	0x56, 0x89, 0x5e, 0xb7, 0xec, 0xef, 0x03, 0x00,
	0x02, 0x00, 0x00, 0x00, 0xc0, 0x77, 0xda, 0x57,
	0x90, 0x69, 0x01, 0x2c, 0x16, 0x79, 0xe4, 0xff,
	// Entry 140 - 17F
	0xff, 0x7f, 0x00, 0x00, 0x00, 0x01, 0x08, 0x46,
	0x00, 0x00, 0x00, 0xb0, 0x14, 0x03, 0x50, 0x16,
	0x0a, 0x00, 0x01, 0x00, 0x00, 0x00, 0x11, 0x09,
	0x00, 0x00, 0x60, 0x10, 0x00, 0x00, 0x00, 0x10,
	0x00, 0x00, 0x44, 0x00, 0x00, 0x10, 0x00, 0x04,
	0x08, 0x00, 0x00, 0x04, 0x00, 0x80, 0x28, 0x04,
	0x00, 0x00, 0x50, 0xd5, 0x2d, 0x00, 0x64, 0x35,
	0x24, 0x53, 0xf5, 0xd4, 0xbd, 0xe2, 0xcd, 0x03,
	// Entry 180 - 1BF
	0x00, 0x80, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x17, 0x39, 0x01, 0xd9, 0x57, 0x98,
	0x21, 0x98, 0xa5, 0x00, 0x00, 0x01, 0x40, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x40, 0x00, 0x44, 0x00, 0x00, 0xb0, 0xfe,
	0xa9, 0x39, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
	// Entry 1C0 - 1FF
	0x10, 0x01, 0x28, 0x05, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x20, 0x04, 0xa6, 0x08, 0x04, 0x00, 0x08,
	0x01, 0x50, 0x00, 0x00, 0x08, 0x11, 0x86, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x06, 0x55,
	0x02, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x60,
	0x3b, 0x83, 0x11, 0x00, 0x80, 0x00, 0x11, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xbe, 0xdf, 0xff, 0xfe, 0xbf,
	// Entry 200 - 23F
	0xdf, 0xc7, 0x83, 0x82, 0xc0, 0xff, 0xdf, 0x27,
	0xcf, 0x5f, 0xe7, 0x01, 0x10, 0x20, 0xb2, 0xc5,
	0xa4, 0x45, 0x25, 0x9b, 0x03, 0xcf, 0xf0, 0xdf,
	0x03, 0xc4, 0x00, 0x10, 0x01, 0x0e, 0x01, 0xe3,
	0x92, 0x54, 0xdb, 0x38, 0xf1, 0x7f, 0xf7, 0x6d,
	0xf9, 0xff, 0x1c, 0x7d, 0x04, 0x08, 0x00, 0x01,
	0x21, 0x12, 0x6c, 0x5f, 0xdd, 0x0f, 0x85, 0x4f,
	0x40, 0x40, 0x00, 0x04, 0xf9, 0xfd, 0xfd, 0xd4,
	// Entry 240 - 27F
	0xe8, 0x13, 0xf4, 0x27, 0xa3, 0x0d, 0x00, 0x00,
	0x20, 0x7b, 0x39, 0x02, 0x05, 0x84, 0x00, 0xf0,
	0xbf, 0x7f, 0xda, 0x00, 0x18, 0x04, 0x81, 0x00,
	0x00, 0x00, 0x80, 0x10, 0x94, 0x1c, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x40, 0x00, 0x04,
	0x08, 0xb4, 0x7c, 0xa5, 0x0c, 0x40, 0x00, 0x00,
	0x11, 0x04, 0x04, 0x6c, 0x00, 0x60, 0x70, 0xff,
	0xfb, 0x7f, 0x60, 0x00, 0x05, 0x9b, 0xdd, 0x6e,
	// Entry 280 - 2BF
	0x03, 0x00, 0x11, 0x00, 0x00, 0x00, 0x40, 0x05,
	0xb5, 0xb6, 0x80, 0x08, 0x04, 0x00, 0x04, 0x51,
	0xe2, 0xff, 0xfd, 0x3f, 0x05, 0x09, 0x08, 0x05,
	0x40, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x02, 0x60,
	0xe5, 0x48, 0x14, 0x89, 0x20, 0xc0, 0x47, 0x80,
	0x07, 0x00, 0x00, 0x00, 0xcc, 0x50, 0x40, 0x24,
	0x85, 0x47, 0x84, 0x40, 0x20, 0x10, 0x00, 0x20,
	// Entry 2C0 - 2FF
	0x02, 0x50, 0x88, 0x11, 0x00, 0xd1, 0x6c, 0xee,
	0x50, 0x03, 0x1d, 0x11, 0x69, 0x06, 0x59, 0xe9,
	0x33, 0x08, 0x00, 0x20, 0x05, 0x40, 0x10, 0x00,
	0x00, 0x00, 0x50, 0x44, 0x96, 0x49, 0xd6, 0x5d,
	0xa7, 0x81, 0x45, 0x97, 0xfb, 0x00, 0x10, 0x00,
	0x08, 0x00, 0x80, 0x00, 0x40, 0x45, 0x00, 0x01,
	0x02, 0x00, 0x01, 0x40, 0x80, 0x00, 0x04, 0x08,
	0xf8, 0xeb, 0xf6, 0x39, 0xc4, 0x99, 0x16, 0x00,
	// Entry 300 - 33F
	0x00, 0x0c, 0x04, 0x01, 0x20, 0x20, 0xdd, 0xa2,
	0x01, 0x00, 0x00, 0x00, 0x12, 0x04, 0x00, 0x00,
	0x04, 0x10, 0xf0, 0x9d, 0x95, 0x13, 0x04, 0x80,
	0x00, 0x00, 0xd0, 0x12, 0x40, 0x00, 0x10, 0xb0,
	0x10, 0x62, 0x4c, 0xd2, 0x02, 0x01, 0x0a, 0x00,
	0x46, 0x04, 0x00, 0x08, 0x02, 0x00, 0x20, 0xc0,
	0x00, 0x80, 0x06, 0x00, 0x08, 0x00, 0x00, 0x00,
	0x00, 0xf0, 0xd8, 0x6f, 0x15, 0x02, 0x08, 0x00,
	// Entry 340 - 37F
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x10, 0x01,
	0x00, 0x10, 0x00, 0x00, 0x00, 0xf8, 0x85, 0xe3,
	0xdd, 0xff, 0xff, 0xff, 0xbb, 0xff, 0x7f, 0xfb,
	0xff, 0xfc, 0xfe, 0xdf, 0xff, 0xff, 0xff, 0xf6,
	0xfb, 0xfe, 0xf7, 0x1f, 0xff, 0xb3, 0xed, 0xff,
	0xdb, 0xed, 0xff, 0xfe, 0xff, 0xfe, 0xdf, 0xff,
	0xff, 0xff, 0xf7, 0xff, 0xfd, 0xff, 0xff, 0xff,
	0xfd, 0xff, 0xdf, 0xaf, 0x9c, 0xff, 0xfb, 0xff,
	// Entry 380 - 3BF
	0xff, 0xff, 0xff, 0xff, 0xef, 0xd2, 0xbb, 0xdf,
	0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xef,
	0xfd, 0xff, 0xff, 0xf7, 0xfd, 0xff, 0xff, 0xff,
	0xef, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x5f, 0xd3, 0x7b, 0xfd, 0xd9, 0xdf, 0xef,
	0xbc, 0x18, 0x05, 0x2c, 0xff, 0x07, 0xf0, 0xff,
	0xf7, 0x5f, 0x00, 0x08, 0x00, 0xc3, 0x3d, 0x1b,
	0x06, 0xe6, 0x72, 0xf0, 0xdd, 0x3c, 0x7f, 0x44,
	// Entry 3C0 - 3FF
	0x02, 0x30, 0x9f, 0x7a, 0x16, 0xfd, 0xff, 0x57,
	0xf2, 0xff, 0x39, 0xff, 0xf2, 0x1e, 0x95, 0xf7,
	0xf7, 0xff, 0x45, 0x80, 0x01, 0x02, 0x00, 0x00,
	0x40, 0x54, 0x9f, 0x8a, 0xd9, 0xd9, 0x0e, 0x11,
	0x84, 0x51, 0xc0, 0xf3, 0xfb, 0x47, 0x00, 0x01,
	0x05, 0xd1, 0x50, 0x58, 0x00, 0x00, 0x00, 0x10,
	0x04, 0x02, 0x00, 0x00, 0x0a, 0x00, 0x17, 0xd2,
	0xf9, 0xfd, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff,
	// Entry 400 - 43F
	0xd7, 0x6f, 0xff, 0xff, 0xdf, 0x7d, 0xbb, 0xff,
	0xff, 0xff, 0xf7, 0xf3, 0xef, 0xff, 0xff, 0xf7,
	0xff, 0xdf, 0xdb, 0x77, 0xff, 0xff, 0x7f, 0xff,
	0xff, 0xff, 0xef, 0xff, 0xbd, 0xff, 0xff, 0xfb,
	0xff, 0xfb, 0xff, 0xde, 0x76, 0xbd, 0xff, 0xf7,
	0xff, 0xff, 0xf7, 0xff, 0xff, 0xdf, 0xf3, 0xbf,
	0xef, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x7f, 0xde,
	0xf7, 0xbb, 0xef, 0xf7, 0xff, 0xfb, 0xbf, 0xdf,
	// Entry 440 - 47F
	0xfd, 0xfe, 0xff, 0xff, 0xfe, 0xff, 0x5f, 0x7d,
	0x7f, 0xff, 0xff, 0xff, 0xe5, 0xfc, 0xff, 0xfd,
	0x7f, 0x7f, 0xff, 0x9e, 0xae, 0xff, 0xee, 0xff,
	0x7f, 0xf7, 0x7b, 0x02, 0x82, 0x04, 0xff, 0xf7,
	0xff, 0xbf, 0xd7, 0xef, 0xfe, 0xdf, 0xf7, 0xfe,
	0xe2, 0x8e, 0xe7, 0xff, 0xf7, 0xff, 0x56, 0xbd,
	0xcd, 0xff, 0xfb, 0xff, 0xff, 0xdf, 0xef, 0xff,
	0xe5, 0xdf, 0x7d, 0x0f, 0xa7, 0x51, 0x04, 0x44,
	// Entry 480 - 4BF
	0x13, 0xd0, 0x5d, 0xaf, 0xa6, 0xfd, 0xb9, 0xff,
	0x43, 0x5d, 0x5b, 0xff, 0xff, 0xbf, 0x3f, 0x20,
	0x14, 0x00, 0x57, 0x51, 0x82, 0x65, 0xf5, 0x49,
	0xe2, 0xff, 0xfc, 0xdf, 0x00, 0x05, 0xc5, 0x05,
	0x00, 0x22, 0x00, 0x74, 0x69, 0x10, 0x08, 0x04,
	0x41, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x51, 0x60, 0x05, 0x04, 0x01, 0x00, 0x00,
	0x06, 0x01, 0x20, 0x00, 0x18, 0x01, 0x92, 0xb1,
	// Entry 4C0 - 4FF
	0xfd, 0x67, 0x4b, 0x06, 0x95, 0x02, 0x57, 0xed,
	0xfb, 0x4c, 0x9d, 0x7b, 0x83, 0x04, 0x62, 0x40,
	0x00, 0x15, 0x42, 0x00, 0x00, 0x00, 0x54, 0x83,
	0xf9, 0x5f, 0x10, 0x8c, 0xc9, 0x46, 0xde, 0xf7,
	0x13, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x10, 0x00,
	0x01, 0x40, 0x00, 0xf0, 0x5b, 0xf4, 0xbe, 0x7d,
	0xba, 0xcf, 0xf7, 0xaf, 0x42, 0x04, 0x84, 0x41,
	// Entry 500 - 53F
	0xb0, 0xff, 0x79, 0x7a, 0x04, 0x00, 0x00, 0x49,
	0x2d, 0x14, 0x25, 0x77, 0xed, 0xf1, 0xbf, 0xef,
	0x3f, 0x00, 0x00, 0x02, 0xc6, 0xa0, 0x1e, 0xfc,
	0xbb, 0xff, 0xfd, 0xfb, 0xb7, 0xfd, 0xf5, 0xff,
	0xfd, 0xfc, 0xd5, 0xed, 0x47, 0xf4, 0x7f, 0x10,
	0x01, 0x01, 0x84, 0x6d, 0xff, 0xf7, 0xdd, 0xf9,
	0x5f, 0x05, 0x86, 0xef, 0xf5, 0x77, 0xbd, 0x3c,
	0x00, 0x00, 0x00, 0x43, 0x71, 0x42, 0x00, 0x40,
	// Entry 540 - 57F
	0x00, 0x00, 0x01, 0x43, 0x19, 0x00, 0x08, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	// Entry 580 - 5BF
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xab, 0xbd, 0xe7, 0x57, 0xee, 0x13, 0x5d,
	0x09, 0xc1, 0x40, 0x21, 0xfa, 0x17, 0x01, 0x80,
	0x00, 0x00, 0x00, 0x00, 0xf0, 0xde, 0xff, 0xbf,
	0x00, 0x23, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
	0x00, 0x30, 0x95, 0xe3, 0x10, 0x00, 0x00, 0x00,
	0x11, 0x04, 0x16, 0x00, 0x01, 0x02, 0x00, 0x81,
	0xa3, 0x01, 0x50, 0x00, 0x00, 0x83, 0x11, 0x40,
	// Entry 5C0 - 5FF
	0x00, 0x00, 0x00, 0xf0, 0xdd, 0x7b, 0x7e, 0x02,
	0xaa, 0x10, 0x5d, 0xd8, 0x52, 0x00, 0x80, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x10, 0x02, 0x02,
	0x09, 0x00, 0x10, 0x02, 0x10, 0x61, 0x5a, 0x9d,
	0x31, 0x00, 0x00, 0x00, 0x01, 0x50, 0x02, 0x20,
	0x00, 0x00, 0x01, 0x00, 0x42, 0x00, 0x00, 0x00,
	0x00, 0x1f, 0xdf, 0xf2, 0xfd, 0xff, 0xfd, 0x3f,
	0x9f, 0x18, 0xcf, 0xbc, 0xbf, 0xaf, 0x5f, 0xfe,
	// Entry 600 - 63F
	0x7b, 0x4b, 0x40, 0x10, 0xe1, 0xfd, 0xaf, 0xfd,
	0xb7, 0xf7, 0xff, 0xf3, 0xdf, 0xff, 0x6f, 0xf1,
	0x7b, 0xf1, 0x7f, 0xdf, 0x7f, 0xbf, 0xfe, 0xb7,
	0xee, 0x1d, 0xfb, 0xdb, 0xef, 0xdf, 0xff, 0xfd,
	0x7e, 0xbe, 0x57, 0xff, 0x6f, 0x81, 0x76, 0x1f,
	0xd4, 0x77, 0xf5, 0xfd, 0xff, 0xff, 0xeb, 0xfe,
	0xbf, 0x5f, 0x57, 0x1b, 0xeb, 0x5f, 0x50, 0x18,
	0x02, 0xfe, 0xff, 0x9d, 0x15, 0x97, 0x15, 0x0f,
	// Entry 640 - 67F
	0x75, 0xc4, 0x7d, 0x81, 0x82, 0xf1, 0xd7, 0x7e,
	0xff, 0xff, 0xff, 0xef, 0xff, 0xfd, 0xdd, 0xde,
	0xbc, 0xfd, 0xf6, 0x5f, 0x7a, 0x1f, 0x40, 0x98,
	0x02, 0xff, 0xe3, 0xff, 0xf3, 0xd6, 0xf2, 0xff,
	0xfb, 0xdf, 0x7d, 0x50, 0x1e, 0x15, 0x7b, 0xb4,
	0xf5, 0xbe, 0xff, 0xff, 0xf3, 0xf7, 0xff, 0xf7,
	0x7f, 0xff, 0xff, 0xbe, 0xdb, 0xf7, 0xd7, 0xf9,
	0xef, 0x2f, 0x80, 0xbf, 0xc5, 0xff, 0xff, 0xf3,
	// Entry 680 - 6BF
	0x97, 0x9d, 0xff, 0xff, 0xf7, 0xcf, 0xfd, 0xbf,
	0xde, 0x7f, 0x06, 0x1d, 0x57, 0xff, 0xf8, 0xda,
	0x5d, 0xcf, 0x7d, 0x16, 0xb9, 0xea, 0x69, 0xa0,
	0x1a, 0x20, 0x00, 0x30, 0x02, 0x04, 0x24, 0x48,
	0x04, 0x00, 0x00, 0x40, 0xd4, 0x02, 0x04, 0x00,
	0x00, 0x04, 0x00, 0x04, 0x00, 0x20, 0x01, 0x06,
	0x50, 0x00, 0x08, 0x00, 0x00, 0x00, 0x24, 0x00,
	0x04, 0x00, 0x10, 0x8c, 0x58, 0xd5, 0x0d, 0x0f,
	// Entry 6C0 - 6FF
	0x14, 0x4d, 0xf1, 0x16, 0x44, 0xd1, 0x42, 0x08,
	0x40, 0x00, 0x00, 0x40, 0x00, 0x08, 0x00, 0x00,
	0x00, 0xdc, 0xff, 0xeb, 0x1f, 0x58, 0x08, 0x41,
	0x04, 0xa0, 0x04, 0x00, 0x30, 0x12, 0x40, 0x22,
	0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x80, 0x10, 0x10, 0xaf,
	0x6f, 0x93, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x80, 0x80, 0x25, 0x00, 0x00,
	// Entry 700 - 73F
	0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
	0x80, 0x86, 0xc2, 0x02, 0x00, 0x00, 0x00, 0x01,
	0xdf, 0x18, 0x00, 0x00, 0x02, 0xf0, 0xfd, 0x79,
	0x3b, 0x00, 0x25, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
	0x03, 0x00, 0x09, 0x20, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x81, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 740 - 77F
	0x00, 0x00, 0x00, 0xef, 0xf7, 0xfd, 0xcf, 0x7e,
	0xa0, 0x11, 0x10, 0x00, 0x00, 0x92, 0x01, 0x44,
	0xcd, 0xf9, 0x5e, 0x00, 0x01, 0x00, 0x30, 0x14,
	0x04, 0x55, 0x10, 0x01, 0x04, 0xf6, 0x3f, 0x7a,
	0x05, 0x04, 0x00, 0xb0, 0x80, 0x00, 0x55, 0x55,
	0x97, 0x7c, 0x9f, 0x71, 0xcc, 0x78, 0xd5, 0x43,
	0xf5, 0x57, 0x67, 0x14, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x2c, 0xf7, 0xdb, 0x1f, 0x50, 0x60,
	// Entry 780 - 7BF
	0x03, 0x68, 0x01, 0x10, 0x8b, 0x38, 0xaa, 0x01,
	0x00, 0x00, 0x30, 0x00, 0x24, 0x44, 0x00, 0x00,
	0x10, 0x03, 0x11, 0x02, 0x01, 0x00, 0x00, 0xf0,
	0xb5, 0xff, 0xd5, 0xd7, 0xbc, 0x70, 0xd6, 0x78,
	0x78, 0x15, 0x50, 0x00, 0xa4, 0x84, 0xe9, 0x41,
	0x00, 0x00, 0x00, 0x6b, 0x39, 0x52, 0x74, 0x00,
	0xe8, 0x30, 0x90, 0x6a, 0x92, 0x00, 0x00, 0x02,
	0xff, 0xef, 0xff, 0x4f, 0x85, 0x53, 0xf4, 0xed,
	// Entry 7C0 - 7FF
	0xdd, 0xbf, 0x72, 0x19, 0xc7, 0x0c, 0xf5, 0x42,
	0x54, 0xdd, 0x77, 0x14, 0x00, 0x80, 0xc0, 0x56,
	0xcc, 0x16, 0x9e, 0xfb, 0x35, 0x7d, 0xef, 0xff,
	0xbd, 0xa4, 0xaf, 0x01, 0x44, 0x18, 0x01, 0x5d,
	0x4e, 0x4a, 0x08, 0x50, 0x28, 0x30, 0xe0, 0x80,
	0x10, 0x20, 0x24, 0x00, 0xff, 0x3f, 0xdf, 0x67,
	0xfe, 0x01, 0x06, 0x88, 0x0a, 0x40, 0x16, 0x01,
	0x01, 0x15, 0x2b, 0x3e, 0x01, 0x00, 0x00, 0x10,
	// Entry 800 - 83F
	0x90, 0x69, 0x45, 0x02, 0x02, 0x01, 0xe1, 0xbf,
	0xbf, 0x03, 0x00, 0x00, 0x10, 0xd4, 0xa7, 0xd1,
	0x54, 0x9e, 0x44, 0xdf, 0xfd, 0x8f, 0x66, 0xb3,
	0x55, 0x20, 0xd4, 0xc3, 0xd8, 0x30, 0x3d, 0x80,
	0x00, 0x00, 0x00, 0x4c, 0xd4, 0x10, 0xc5, 0x84,
	0x6e, 0x50, 0x00, 0x22, 0x50, 0x7e, 0xbf, 0xdb,
	0x07, 0x00, 0x20, 0x10, 0x84, 0xb2, 0x45, 0x10,
	0x06, 0x44, 0x00, 0x00, 0x12, 0x02, 0x11, 0x00,
	// Entry 840 - 87F
	0xf0, 0xff, 0xfd, 0x3f, 0x05, 0x00, 0x12, 0x81,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x02, 0x28,
	0x84, 0x00, 0x33, 0xc0, 0x23, 0x24, 0x00, 0x00,
	0x00, 0xcb, 0xe4, 0x3a, 0x42, 0xc8, 0x14, 0xf1,
	0xef, 0xff, 0x7f, 0x16, 0x01, 0x01, 0x84, 0x50,
	0x07, 0xfc, 0xff, 0xff, 0x0f, 0x01, 0x00, 0x40,
	0x10, 0x38, 0x01, 0x01, 0x1c, 0x12, 0x40, 0xe1,
	// Entry 880 - 8BF
	0x76, 0x16, 0x08, 0x03, 0x10, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x24,
	0x0a, 0x00, 0x80, 0x00, 0x00,
}

// altLangISO3 holds an alphabetically sorted list of 3-letter language code alternatives
// to 2-letter language codes that cannot be derived using the method described above.
// Each 3-letter code is followed by its 1-byte langID.
// Size: 32 bytes
const altLangISO3 tag.Index = "---\x00cor\x00hbs\x01heb\x02kin\x03spa\x04yid\x05\xff\xff\xff\xff"

// altLangIndex is used to convert indexes in altLangISO3 to langIDs.
// Size: 12 bytes, 6 elements
var altLangIndex = [6]uint16{
	0x0141, 0x0218, 0x00fd, 0x01fe, 0x0099, 0x0102,
}

// langAliasMap maps langIDs to their suggested replacements.
// Size: 556 bytes, 139 elements
var langAliasMap = [139]fromTo{
	{from: 0xf7, to: 0xf0},
	{from: 0xfd, to: 0xd9},
	{from: 0x102, to: 0x2a8},
	{from: 0x107, to: 0x106},
	{from: 0x188, to: 0x1f7},
	{from: 0x1a4, to: 0x1b6},
	{from: 0x218, to: 0x22d},
	{from: 0x259, to: 0xa5},
	{from: 0x265, to: 0x243},
	{from: 0x26e, to: 0xc},
	{from: 0x2c2, to: 0x2c8},
	{from: 0x313, to: 0x8f},
	{from: 0x3b4, to: 0x1c35},
	{from: 0x3d5, to: 0x22c},
	{from: 0x3e6, to: 0x22c},
	{from: 0x471, to: 0x14},
	{from: 0x47c, to: 0xeb},
	{from: 0x4c2, to: 0x1f25},
	{from: 0x537, to: 0x21},
	{from: 0x53d, to: 0x271f},
	{from: 0x549, to: 0x22},
	{from: 0x56a, to: 0x9d},
	{from: 0x590, to: 0x25},
	{from: 0x599, to: 0x3f},
	{from: 0x647, to: 0xc67},
	{from: 0x773, to: 0x19b},
	{from: 0x7ba, to: 0x165},
	{from: 0x7c1, to: 0x56},
	{from: 0x842, to: 0x30a6},
	{from: 0x8bc, to: 0x2b1},
	{from: 0x8f9, to: 0x23de},
	{from: 0x902, to: 0x947},
	{from: 0x91f, to: 0x240},
	{from: 0x940, to: 0x3fad},
	{from: 0x943, to: 0x2b1},
	{from: 0xa3d, to: 0x70},
	{from: 0xa8c, to: 0x76},
	{from: 0xb4c, to: 0x87},
	{from: 0xb5b, to: 0x198},
	{from: 0xb7c, to: 0xb7f},
	{from: 0xb82, to: 0x2b5},
	{from: 0xc63, to: 0x1dde},
	{from: 0xc72, to: 0x2c1e},
	{from: 0xcbd, to: 0x1b2},
	{from: 0xe54, to: 0x9b},
	{from: 0xe88, to: 0x170},
	{from: 0xf24, to: 0xf4},
	{from: 0xffd, to: 0xc},
	{from: 0x11a8, to: 0xaa},
	{from: 0x11f4, to: 0xa2},
	{from: 0x12a3, to: 0xb1f},
	{from: 0x12a7, to: 0x1c7},
	{from: 0x12b6, to: 0x1449},
	{from: 0x1304, to: 0x108},
	{from: 0x1307, to: 0x82},
	{from: 0x1327, to: 0x3a33},
	{from: 0x13ee, to: 0xc6},
	{from: 0x144c, to: 0x96},
	{from: 0x1484, to: 0x277c},
	{from: 0x149c, to: 0xc4},
	{from: 0x14fe, to: 0x12a8},
	{from: 0x158d, to: 0x153a},
	{from: 0x159a, to: 0x1677},
	{from: 0x160e, to: 0x231},
	{from: 0x16fd, to: 0x1a85},
	{from: 0x17f8, to: 0x2934},
	{from: 0x180e, to: 0xfa},
	{from: 0x18de, to: 0xfc},
	{from: 0x190a, to: 0x1299},
	{from: 0x1dc1, to: 0x1e61},
	{from: 0x1dde, to: 0x185},
	{from: 0x1e67, to: 0x13c},
	{from: 0x1e72, to: 0x132},
	{from: 0x1e76, to: 0x119},
	{from: 0x1e7d, to: 0x12f},
	{from: 0x1e93, to: 0x1f6f},
	{from: 0x1eb9, to: 0x13e},
	{from: 0x1f6a, to: 0x4222},
	{from: 0x1f78, to: 0x3707},
	{from: 0x1fe6, to: 0x6ae},
	{from: 0x209a, to: 0x2faa},
	{from: 0x2106, to: 0x30e9},
	{from: 0x21f6, to: 0x167},
	{from: 0x2268, to: 0x183},
	{from: 0x2274, to: 0x180},
	{from: 0x227e, to: 0x190},
	{from: 0x22d4, to: 0x8df},
	{from: 0x232d, to: 0x66},
	{from: 0x23c2, to: 0x170},
	{from: 0x244d, to: 0x2438},
	{from: 0x247d, to: 0x1e8},
	{from: 0x24ab, to: 0x3a33},
	{from: 0x24e9, to: 0x2438},
	{from: 0x2673, to: 0x25bb},
	{from: 0x2698, to: 0x1a9},
	{from: 0x289e, to: 0x1c6},
	{from: 0x2980, to: 0x1c8},
	{from: 0x29c3, to: 0x3a33},
	{from: 0x2a80, to: 0x1e2},
	{from: 0x2a97, to: 0x31b},
	{from: 0x2acb, to: 0xa0},
	{from: 0x2acc, to: 0xa0},
	{from: 0x2b83, to: 0x17a},
	{from: 0x2b9e, to: 0x2b19},
	{from: 0x2ba5, to: 0x149},
	{from: 0x2be9, to: 0x2006},
	{from: 0x2c73, to: 0x2c5b},
	{from: 0x2f17, to: 0x1e5},
	{from: 0x30ea, to: 0x3112},
	{from: 0x31ae, to: 0x1f7},
	{from: 0x3272, to: 0x1654},
	{from: 0x336a, to: 0x21d},
	{from: 0x33dc, to: 0x129},
	{from: 0x33fa, to: 0x209},
	{from: 0x3481, to: 0x23a},
	{from: 0x35af, to: 0x2a1f},
	{from: 0x35b3, to: 0x49},
	{from: 0x35b6, to: 0x2fac},
	{from: 0x35f0, to: 0x372a},
	{from: 0x3616, to: 0x3d44},
	{from: 0x3639, to: 0x2c1e},
	{from: 0x36e0, to: 0x25b},
	{from: 0x38d2, to: 0xb15},
	{from: 0x38fc, to: 0xe7e},
	{from: 0x3a1d, to: 0x27d},
	{from: 0x3d41, to: 0x7c},
	{from: 0x4042, to: 0x2f7},
	{from: 0x40fc, to: 0x131},
	{from: 0x414f, to: 0x344f},
	{from: 0x4151, to: 0x83},
	{from: 0x4233, to: 0x30a6},
	{from: 0x4267, to: 0x2a8},
	{from: 0x434e, to: 0x218d},
	{from: 0x4361, to: 0x2460},
	{from: 0x4394, to: 0x4632},
	{from: 0x4432, to: 0x4424},
	{from: 0x44c2, to: 0x44c9},
	{from: 0x469a, to: 0x190},
	{from: 0x472b, to: 0x2ac},
}

// Size: 139 bytes, 139 elements
var langAliasTypes = [139]langAliasType{
	// Entry 0 - 3F
	0, 0, 0, 0, 0, 1, 2, 2, 0, 1, 0, 0, 1, 2, 1, 1,
	2, 0, 1, 0, 1, 2, 1, 1, 0, 2, 1, 1, 0, 2, 0, 0,
	1, 0, 1, 1, 2, 1, 1, 1, 1, 0, 0, 2, 1, 1, 1, 1,
	2, 1, 0, 1, 1, 2, 2, 0, 1, 2, 0, 1, 1, 1, 1, 1,
	// Entry 40 - 7F
	0, 0, 2, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1,
	0, 0, 1, 2, 2, 2, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1,
	1, 0, 1, 0, 2, 1, 1, 0, 1, 0, 0, 1, 1, 2, 0, 2,
	1, 1, 1, 0, 2, 0, 0, 0, 0, 1, 1, 0, 1, 2, 0, 1,
	// Entry 80 - BF
	0, 1, 0, 1, 0, 0, 0, 0, 1, 1, 1,
}

const (
	_Latn = 79
	_Hani = 48
	_Hans = 50
	_Hant = 51
	_Qaaa = 125
	_Qaai = 133
	_Qabx = 174
	_Zinh = 218
	_Zyyy = 222
	_Zzzz = 223
)

// script is an alphabetically sorted list of ISO 15924 codes. The index
// of the script in the string, divided by 4, is the internal scriptID.
// Size: 900 bytes
const script tag.Index = "" +
	"----AdlmAfakAghbAhomArabAranArmiArmnAvstBaliBamuBassBatkBengBlisBopoBrah" +
	"BraiBugiBuhdCakmCansCariChamCherCirtCoptCprtCyrlCyrsDevaDsrtDuplEgydEgyh" +
	"EgypElbaEthiGeokGeorGlagGothGranGrekGujrGuruHangHaniHanoHansHantHatrHebr" +
	"HiraHluwHmngHrktHungIndsItalJavaJpanJurcKaliKanaKharKhmrKhojKitlKitsKnda" +
	"KoreKpelKthiLanaLaooLatfLatgLatnLepcLimbLinaLinbLisuLomaLyciLydiMahjMand" +
	"ManiMarcMayaMendMercMeroMlymModiMongMoonMrooMteiMultMymrNarbNbatNkgbNkoo" +
	"NshuOgamOlckOrkhOryaOsgeOsmaPalmPaucPermPhagPhliPhlpPhlvPhnxPlrdPrtiQaaa" +
	"QaabQaacQaadQaaeQaafQaagQaahQaaiQaajQaakQaalQaamQaanQaaoQaapQaaqQaarQaas" +
	"QaatQaauQaavQaawQaaxQaayQaazQabaQabbQabcQabdQabeQabfQabgQabhQabiQabjQabk" +
	"QablQabmQabnQaboQabpQabqQabrQabsQabtQabuQabvQabwQabxRjngRoroRunrSamrSara" +
	"SarbSaurSgnwShawShrdSiddSindSinhSoraSundSyloSyrcSyreSyrjSyrnTagbTakrTale" +
	"TaluTamlTangTavtTeluTengTfngTglgThaaThaiTibtTirhUgarVaiiVispWaraWoleXpeo" +
	"XsuxYiiiZinhZmthZsymZxxxZyyyZzzz\xff\xff\xff\xff"

// suppressScript is an index from langID to the dominant script for that language,
// if it exists.  If a script is given, it should be suppressed from the language tag.
// Size: 694 bytes, 694 elements
var suppressScript = [694]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x26, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 40 - 7F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4f, 0x4f, 0x00, 0x00,
	// Entry 80 - BF
	0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x4f, 0x00, 0x00, 0x00, 0xce, 0x00, 0x00, 0xd0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x4f,
	0x4f, 0x4f, 0x00, 0x4f, 0x00, 0x4f, 0x00, 0x00,
	0x05, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x4f,
	0x4f, 0x00, 0x4f, 0x00, 0x00, 0x4f, 0x4f, 0x00,
	0x00, 0x00, 0x00, 0x4f, 0x4f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry C0 - FF
	0x00, 0x00, 0x4f, 0x00, 0x4f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4f, 0x2d, 0x00, 0x00,
	0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x35, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x4f,
	0x00, 0x4f, 0x4f, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f,
	0x00, 0x00, 0x4f, 0x4f, 0x00, 0x35, 0x00, 0x3e,
	// Entry 100 - 13F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x00,
	0x4f, 0x00, 0x43, 0x00, 0x47, 0x48, 0x00, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 140 - 17F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x4f, 0x4c, 0x00, 0x00, 0x00,
	0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00,
	0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x4f,
	// Entry 180 - 1BF
	0x00, 0x00, 0x00, 0x1d, 0x60, 0x00, 0x00, 0x00,
	0x4f, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00,
	0x4f, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x67, 0x00, 0x00, 0x00, 0x00,
	0x4f, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x4f, 0x00,
	0x4f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x4f, 0x00, 0x4f, 0x00, 0x4f, 0x00, 0x4f, 0x00,
	0x00, 0x00, 0x6b, 0x4f, 0x00, 0x4f, 0x00, 0x00,
	// Entry 1C0 - 1FF
	0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f,
	0x70, 0x00, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x05, 0x4f, 0x00, 0x4f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x4f, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x4f,
	0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x4f, 0x00,
	// Entry 200 - 23F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xbb, 0x00, 0x4f, 0x00, 0x4f,
	0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4f, 0x00, 0x4f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4f, 0x00, 0x4f, 0x00, 0x00, 0x00,
	0x00, 0x4f, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 240 - 27F
	0x00, 0x00, 0xc7, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xca, 0x4f, 0x00, 0x00, 0x00, 0xcf, 0x00,
	0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 0x4f, 0x00,
	0x00, 0x4f, 0x00, 0x4f, 0x4f, 0x4f, 0x00, 0x4f,
	0x4f, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x4f,
	// Entry 280 - 2BF
	0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x35, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x4f, 0x00, 0x00,
}

const (
	_001 = 1
	_419 = 30
	_BR  = 64
	_CA  = 72
	_ES  = 109
	_GB  = 121
	_MD  = 186
	_PT  = 236
	_UK  = 304
	_US  = 306
	_ZZ  = 354
	_XA  = 320
	_XC  = 322
	_XK  = 330
)

// isoRegionOffset needs to be added to the index of regionISO to obtain the regionID
// for 2-letter ISO codes. (The first isoRegionOffset regionIDs are reserved for
// the UN.M49 codes used for groups.)
const isoRegionOffset = 31

// regionTypes defines the status of a region for various standards.
// Size: 355 bytes, 355 elements
var regionTypes = [355]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	// Entry 40 - 7F
	0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x04, 0x00,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06,
	0x04, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x04,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x04,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	// Entry 80 - BF
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x00, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00,
	// Entry C0 - FF
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x06,
	0x06, 0x06, 0x00, 0x06, 0x04, 0x06, 0x06, 0x06,
	0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x06,
	0x00, 0x06, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	// Entry 100 - 13F
	0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x02, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06,
	// Entry 140 - 17F
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x04, 0x06, 0x06, 0x04, 0x06, 0x06,
	0x04, 0x06, 0x05,
}

// regionISO holds a list of alphabetically sorted 2-letter ISO region codes.
// Each 2-letter codes is followed by two bytes with the following meaning:
//     - [A-Z}{2}: the first letter of the 2-letter code plus these two
//                 letters form the 3-letter ISO code.
//     - 0, n:     index into altRegionISO3.
// Size: 1300 bytes
const regionISO tag.Index = "" +
	"AAAAACSCADNDAEREAFFGAGTGAIIAALLBAMRMANNTAOGOAQTAARRGASSMATUTAUUSAWBWAXLA" +
	"AZZEBAIHBBRBBDGDBEELBFFABGGRBHHRBIDIBJENBLLMBMMUBNRNBOOLBQESBRRABSHSBTTN" +
	"BUURBVVTBWWABYLRBZLZCAANCCCKCDODCFAFCGOGCHHECIIVCKOKCLHLCMMRCNHNCOOLCPPT" +
	"CRRICS\x00\x00CTTECUUBCVPVCWUWCXXRCYYPCZZEDDDRDEEUDGGADJJIDKNKDMMADOOMDY" +
	"HYDZZAEA  ECCUEESTEGGYEHSHERRIESSPETTHEU\x00\x03FIINFJJIFKLKFMSMFOROFQ" +
	"\x00\x18FRRAFXXXGAABGBBRGDRDGEEOGFUFGGGYGHHAGIIBGLRLGMMBGNINGPLPGQNQGRRC" +
	"GS\x00\x06GTTMGUUMGWNBGYUYHKKGHMMDHNNDHRRVHTTIHUUNHVVOIC  IDDNIERLILSRIM" +
	"MNINNDIOOTIQRQIRRNISSLITTAJEEYJMAMJOORJPPNJTTNKEENKGGZKHHMKIIRKM\x00\x09" +
	"KNNAKP\x00\x0cKRORKWWTKY\x00\x0fKZAZLAAOLBBNLCCALIIELKKALRBRLSSOLTTULUUX" +
	"LVVALYBYMAARMCCOMDDAMENEMFAFMGDGMHHLMIIDMKKDMLLIMMMRMNNGMOACMPNPMQTQMRRT" +
	"MSSRMTLTMUUSMVDVMWWIMXEXMYYSMZOZNAAMNCCLNEERNFFKNGGANHHBNIICNLLDNOORNPPL" +
	"NQ\x00\x1eNRRUNTTZNUIUNZZLOMMNPAANPCCIPEERPFYFPGNGPHHLPKAKPLOLPM\x00\x12" +
	"PNCNPRRIPSSEPTRTPUUSPWLWPYRYPZCZQAATQMMMQNNNQOOOQPPPQQQQQRRRQSSSQTTTQU" +
	"\x00\x03QVVVQWWWQXXXQYYYQZZZREEURHHOROOURS\x00\x15RUUSRWWASAAUSBLBSCYCSD" +
	"DNSEWESGGPSHHNSIVNSJJMSKVKSLLESMMRSNENSOOMSRURSSSDSTTPSUUNSVLVSXXMSYYRSZ" +
	"WZTAAATCCATDCDTF\x00\x18TGGOTHHATJJKTKKLTLLSTMKMTNUNTOONTPMPTRURTTTOTVUV" +
	"TWWNTZZAUAKRUGGAUK  UMMIUSSAUYRYUZZBVAATVCCTVDDRVEENVGGBVIIRVNNMVUUTWFLF" +
	"WKAKWSSMXAAAXBBBXCCCXDDDXEEEXFFFXGGGXHHHXIIIXJJJXKKKXLLLXMMMXNNNXOOOXPPP" +
	"XQQQXRRRXSSSXTTTXUUUXVVVXWWWXXXXXYYYXZZZYDMDYEEMYT\x00\x1bYUUGZAAFZMMBZR" +
	"ARZWWEZZZZ\xff\xff\xff\xff"

// altRegionISO3 holds a list of 3-letter region codes that cannot be
// mapped to 2-letter codes using the default algorithm. This is a short list.
// Size: 33 bytes
const altRegionISO3 string = "SCGQUUSGSCOMPRKCYMSPMSRBATFMYTATN"

// altRegionIDs holds a list of regionIDs the positions of which match those
// of the 3-letter ISO codes in altRegionISO3.
// Size: 22 bytes, 11 elements
var altRegionIDs = [11]uint16{
	0x0056, 0x006f, 0x0086, 0x00a6, 0x00a8, 0x00ab, 0x00e8, 0x0103,
	0x011f, 0x015c, 0x00da,
}

// Size: 80 bytes, 20 elements
var regionOldMap = [20]fromTo{
	{from: 0x43, to: 0xc2},
	{from: 0x57, to: 0xa5},
	{from: 0x5e, to: 0x5f},
	{from: 0x65, to: 0x3a},
	{from: 0x77, to: 0x76},
	{from: 0x91, to: 0x36},
	{from: 0xa1, to: 0x131},
	{from: 0xbf, to: 0x131},
	{from: 0xd5, to: 0x13c},
	{from: 0xda, to: 0x2a},
	{from: 0xed, to: 0x131},
	{from: 0xf0, to: 0xe0},
	{from: 0xfa, to: 0x6f},
	{from: 0x101, to: 0x161},
	{from: 0x128, to: 0x124},
	{from: 0x130, to: 0x79},
	{from: 0x137, to: 0x13b},
	{from: 0x13e, to: 0x131},
	{from: 0x15a, to: 0x15b},
	{from: 0x160, to: 0x4a},
}

// m49 maps regionIDs to UN.M49 codes. The first isoRegionOffset entries are
// codes indicating collections of regions.
// Size: 710 bytes, 355 elements
var m49 = [355]int16{
	// Entry 0 - 3F
	0, 1, 2, 3, 5, 9, 11, 13,
	14, 15, 17, 18, 19, 21, 29, 30,
	34, 35, 39, 53, 54, 57, 61, 142,
	143, 145, 150, 151, 154, 155, 419, 958,
	0, 20, 784, 4, 28, 660, 8, 51,
	530, 24, 10, 32, 16, 40, 36, 533,
	248, 31, 70, 52, 50, 56, 854, 100,
	48, 108, 204, 652, 60, 96, 68, 535,
	// Entry 40 - 7F
	76, 44, 64, 104, 74, 72, 112, 84,
	124, 166, 180, 140, 178, 756, 384, 184,
	152, 120, 156, 170, 0, 188, 891, 296,
	192, 132, 531, 162, 196, 203, 278, 276,
	0, 262, 208, 212, 214, 204, 12, 0,
	218, 233, 818, 732, 232, 724, 231, 967,
	246, 242, 238, 583, 234, 0, 250, 249,
	266, 826, 308, 268, 254, 831, 288, 292,
	// Entry 80 - BF
	304, 270, 324, 312, 226, 300, 239, 320,
	316, 624, 328, 344, 334, 340, 191, 332,
	348, 854, 0, 360, 372, 376, 833, 356,
	86, 368, 364, 352, 380, 832, 388, 400,
	392, 581, 404, 417, 116, 296, 174, 659,
	408, 410, 414, 136, 398, 418, 422, 662,
	438, 144, 430, 426, 440, 442, 428, 434,
	504, 492, 498, 499, 663, 450, 584, 581,
	// Entry C0 - FF
	807, 466, 104, 496, 446, 580, 474, 478,
	500, 470, 480, 462, 454, 484, 458, 508,
	516, 540, 562, 574, 566, 548, 558, 528,
	578, 524, 10, 520, 536, 570, 554, 512,
	591, 0, 604, 258, 598, 608, 586, 616,
	666, 612, 630, 275, 620, 581, 585, 600,
	591, 634, 959, 960, 961, 962, 963, 964,
	965, 966, 967, 968, 969, 970, 971, 972,
	// Entry 100 - 13F
	638, 716, 642, 688, 643, 646, 682, 90,
	690, 729, 752, 702, 654, 705, 744, 703,
	694, 674, 686, 706, 740, 728, 678, 810,
	222, 534, 760, 748, 0, 796, 148, 260,
	768, 764, 762, 772, 626, 795, 788, 776,
	626, 792, 780, 798, 158, 834, 804, 800,
	826, 581, 840, 858, 860, 336, 670, 704,
	862, 92, 850, 704, 548, 876, 581, 882,
	// Entry 140 - 17F
	973, 974, 975, 976, 977, 978, 979, 980,
	981, 982, 983, 984, 985, 986, 987, 988,
	989, 990, 991, 992, 993, 994, 995, 996,
	997, 998, 720, 887, 175, 891, 710, 894,
	180, 716, 999,
}

// m49Index gives indexes into fromM49 based on the three most significant bits
// of a 10-bit UN.M49 code. To search an UN.M49 code in fromM49, search in
//    fromM49[m49Index[msb39(code)]:m49Index[msb3(code)+1]]
// for an entry where the first 7 bits match the 7 lsb of the UN.M49 code.
// The region code is stored in the 9 lsb of the indexed value.
// Size: 18 bytes, 9 elements
var m49Index = [9]int16{
	0, 59, 107, 142, 180, 219, 258, 290,
	332,
}

// fromM49 contains entries to map UN.M49 codes to regions. See m49Index for details.
// Size: 664 bytes, 332 elements
var fromM49 = [332]uint16{
	// Entry 0 - 3F
	0x0201, 0x0402, 0x0603, 0x0823, 0x0a04, 0x1026, 0x1205, 0x142a,
	0x1606, 0x1866, 0x1a07, 0x1c08, 0x1e09, 0x202c, 0x220a, 0x240b,
	0x260c, 0x2821, 0x2a0d, 0x3029, 0x3824, 0x3a0e, 0x3c0f, 0x3e31,
	0x402b, 0x4410, 0x4611, 0x482e, 0x4e12, 0x502d, 0x5841, 0x6038,
	0x6434, 0x6627, 0x6833, 0x6a13, 0x6c14, 0x7035, 0x7215, 0x783c,
	0x7a16, 0x8042, 0x883e, 0x8c32, 0x9045, 0x9444, 0x9840, 0xa847,
	0xac98, 0xb507, 0xb939, 0xc03d, 0xc837, 0xd0c2, 0xd839, 0xe046,
	0xe8a4, 0xf051, 0xf848, 0x0859, 0x10ab, 0x184b, 0x1c17, 0x1e18,
	// Entry 40 - 7F
	0x20b1, 0x2219, 0x291e, 0x2c1a, 0x2e1b, 0x3050, 0x341c, 0x361d,
	0x3852, 0x3d2c, 0x445b, 0x4c49, 0x5453, 0x5ca6, 0x5f5c, 0x644c,
	0x684a, 0x704f, 0x7855, 0x7e8e, 0x8058, 0x885c, 0x965d, 0x983a,
	0xa062, 0xa863, 0xac64, 0xb468, 0xbd18, 0xc484, 0xcc6e, 0xce6e,
	0xd06c, 0xd269, 0xd474, 0xdc72, 0xde86, 0xe471, 0xec70, 0xf030,
	0xf277, 0xf476, 0xfc7c, 0x04e3, 0x091f, 0x0c61, 0x1478, 0x187b,
	0x1c81, 0x26eb, 0x285f, 0x2c5e, 0x305f, 0x407e, 0x487f, 0x50a5,
	0x5885, 0x6080, 0x687a, 0x7083, 0x7888, 0x8087, 0x8882, 0x908a,
	// Entry 80 - BF
	0x988f, 0x9c8c, 0xa135, 0xa88d, 0xb08b, 0xb890, 0xc09b, 0xc897,
	0xd093, 0xd89a, 0xe099, 0xe894, 0xf095, 0xf89c, 0x004e, 0x089e,
	0x10a0, 0x1cac, 0x209f, 0x28a2, 0x30a8, 0x34a9, 0x3caa, 0x42a3,
	0x44ad, 0x461e, 0x4cae, 0x54b3, 0x58b6, 0x5cb2, 0x64b7, 0x6cb0,
	0x70b4, 0x74b5, 0x7cc4, 0x84bd, 0x8ccc, 0x94ce, 0x9ccb, 0xa4c1,
	0xacc9, 0xb4c6, 0xbcc7, 0xc0ca, 0xc8cd, 0xd8b9, 0xe0c3, 0xe4ba,
	0xe6bb, 0xe8c8, 0xf0b8, 0xf8cf, 0x00df, 0x08d0, 0x10db, 0x18d9,
	0x20d7, 0x2428, 0x265a, 0x2a2f, 0x2d19, 0x2e3f, 0x30dc, 0x38d1,
	// Entry C0 - FF
	0x493c, 0x54de, 0x5cd6, 0x64d2, 0x6cd4, 0x74dd, 0x7cd3, 0x84d8,
	0x88c5, 0x8b31, 0x8e73, 0x90be, 0x92ee, 0x94e6, 0x9ee0, 0xace4,
	0xb0ef, 0xb8e2, 0xc0e5, 0xc8e9, 0xd0e7, 0xd8ec, 0xe089, 0xe524,
	0xecea, 0xf4f1, 0xfd00, 0x0502, 0x0704, 0x0d05, 0x183b, 0x1d0c,
	0x26a7, 0x2825, 0x2caf, 0x2ebc, 0x34e8, 0x3d36, 0x4511, 0x4d16,
	0x5506, 0x5d12, 0x6103, 0x6508, 0x6d10, 0x7d0b, 0x7f0f, 0x813b,
	0x830d, 0x8513, 0x8d5e, 0x9961, 0xa15a, 0xa86d, 0xb115, 0xb309,
	0xb86b, 0xc109, 0xc914, 0xd10e, 0xd91b, 0xe10a, 0xe84d, 0xf11a,
	// Entry 100 - 13F
	0xf522, 0xf921, 0x0120, 0x0923, 0x1127, 0x192a, 0x2022, 0x2926,
	0x3129, 0x3725, 0x391d, 0x3d2b, 0x412f, 0x492e, 0x4ec0, 0x5517,
	0x646a, 0x7479, 0x7e7d, 0x809d, 0x8296, 0x852d, 0x9132, 0xa53a,
	0xac36, 0xb533, 0xb934, 0xbd38, 0xd93d, 0xe53f, 0xed5b, 0xef5b,
	0xf656, 0xfd5f, 0x7c1f, 0x7ef2, 0x80f3, 0x82f4, 0x84f5, 0x86f6,
	0x88f7, 0x8af8, 0x8cf9, 0x8e6f, 0x90fb, 0x92fc, 0x94fd, 0x96fe,
	0x98ff, 0x9b40, 0x9d41, 0x9f42, 0xa143, 0xa344, 0xa545, 0xa746,
	0xa947, 0xab48, 0xad49, 0xaf4a, 0xb14b, 0xb34c, 0xb54d, 0xb74e,
	// Entry 140 - 17F
	0xb94f, 0xbb50, 0xbd51, 0xbf52, 0xc153, 0xc354, 0xc555, 0xc756,
	0xc957, 0xcb58, 0xcd59, 0xcf62,
}

// Size: 1311 bytes
var variantIndex = map[string]uint8{
	"1606nict": 0x0,
	"1694acad": 0x1,
	"1901":     0x2,
	"1959acad": 0x3,
	"1994":     0x3f,
	"1996":     0x4,
	"alalc97":  0x41,
	"aluku":    0x5,
	"arevela":  0x6,
	"arevmda":  0x7,
	"baku1926": 0x8,
	"balanka":  0x9,
	"barla":    0xa,
	"bauddha":  0xb,
	"biscayan": 0xc,
	"biske":    0x3a,
	"bohoric":  0xd,
	"boont":    0xe,
	"dajnko":   0xf,
	"ekavsk":   0x10,
	"emodeng":  0x11,
	"fonipa":   0x42,
	"fonupa":   0x43,
	"fonxsamp": 0x44,
	"hepburn":  0x12,
	"heploc":   0x40,
	"hognorsk": 0x13,
	"ijekavsk": 0x14,
	"itihasa":  0x15,
	"jauer":    0x16,
	"jyutping": 0x17,
	"kkcor":    0x18,
	"kociewie": 0x19,
	"kscor":    0x1a,
	"laukika":  0x1b,
	"lipaw":    0x3b,
	"luna1918": 0x1c,
	"metelko":  0x1d,
	"monoton":  0x1e,
	"ndyuka":   0x1f,
	"nedis":    0x20,
	"njiva":    0x3c,
	"nulik":    0x21,
	"osojs":    0x3d,
	"oxendict": 0x22,
	"pamaka":   0x23,
	"petr1708": 0x24,
	"pinyin":   0x25,
	"polyton":  0x26,
	"puter":    0x27,
	"rigik":    0x28,
	"rozaj":    0x29,
	"rumgr":    0x2a,
	"scotland": 0x2b,
	"scouse":   0x2c,
	"solba":    0x3e,
	"sotav":    0x2d,
	"surmiran": 0x2e,
	"sursilv":  0x2f,
	"sutsilv":  0x30,
	"tarask":   0x31,
	"uccor":    0x32,
	"ucrcor":   0x33,
	"ulster":   0x34,
	"unifon":   0x35,
	"vaidika":  0x36,
	"valencia": 0x37,
	"vallader": 0x38,
	"wadegile": 0x39,
}

// variantNumSpecialized is the number of specialized variants in variants.
const variantNumSpecialized = 65
const (
	_XTS = 279
	_XXX = 281
)

// currency holds an alphabetically sorted list of canonical 3-letter currency identifiers.
// Each identifier is followed by a byte of which the 6 most significant bits
// indicated the rounding and the least 2 significant bits indicate the
// number of decimal positions.
// Size: 1192 bytes
const currency tag.Index = "" +
	"---\x0aADP\x08AED\x0aAFA\x0aAFN\x08ALK\x0aALL\x08AMD\x08ANG\x0aAOA\x0aAO" +
	"K\x0aAON\x0aAOR\x0aARA\x0aARL\x0aARM\x0aARP\x0aARS\x0aATS\x0aAUD\x0aAWG" +
	"\x0aAZM\x0aAZN\x0aBAD\x0aBAM\x0aBAN\x0aBBD\x0aBDT\x0aBEC\x0aBEF\x0aBEL" +
	"\x0aBGL\x0aBGM\x0aBGN\x0aBGO\x0aBHD\x0bBIF\x08BMD\x0aBND\x0aBOB\x0aBOL" +
	"\x0aBOP\x0aBOV\x0aBRB\x0aBRC\x0aBRE\x0aBRL\x0aBRN\x0aBRR\x0aBRZ\x0aBSD" +
	"\x0aBTN\x0aBUK\x0aBWP\x0aBYB\x0aBYR\x08BZD\x0aCAD\x0aCDF\x0aCHE\x0aCHF" +
	"\x0aCHW\x0aCLE\x0aCLF\x0cCLP\x08CNX\x0aCNY\x0aCOP\x08COU\x0aCRC\x08CSD" +
	"\x0aCSK\x0aCUC\x0aCUP\x0aCVE\x0aCYP\x0aCZK\x0aDDM\x0aDEM\x0aDJF\x08DKK" +
	"\x0aDOP\x0aDZD\x0aECS\x0aECV\x0aEEK\x0aEGP\x0aERN\x0aESA\x0aESB\x0aESP" +
	"\x08ETB\x0aEUR\x0aFIM\x0aFJD\x0aFKP\x0aFRF\x0aGBP\x0aGEK\x0aGEL\x0aGHC" +
	"\x0aGHS\x0aGIP\x0aGMD\x0aGNF\x08GNS\x0aGQE\x0aGRD\x0aGTQ\x0aGWE\x0aGWP" +
	"\x0aGYD\x08HKD\x0aHNL\x0aHRD\x0aHRK\x0aHTG\x0aHUF\x0aIDR\x08IEP\x0aILP" +
	"\x0aILR\x0aILS\x0aINR\x0aIQD\x08IRR\x08ISJ\x0aISK\x08ITL\x08JMD\x0aJOD" +
	"\x0bJPY\x08KES\x0aKGS\x0aKHR\x0aKMF\x08KPW\x08KRH\x0aKRO\x0aKRW\x08KWD" +
	"\x0bKYD\x0aKZT\x0aLAK\x08LBP\x08LKR\x0aLRD\x0aLSL\x0aLTL\x0aLTT\x0aLUC" +
	"\x0aLUF\x08LUL\x0aLVL\x0aLVR\x0aLYD\x0bMAD\x0aMAF\x0aMCF\x0aMDC\x0aMDL" +
	"\x0aMGA\x08MGF\x08MKD\x0aMKN\x0aMLF\x0aMMK\x08MNT\x08MOP\x0aMRO\x08MTL" +
	"\x0aMTP\x0aMUR\x08MVR\x0aMWK\x0aMXN\x0aMXP\x0aMXV\x0aMYR\x0aMZE\x0aMZM" +
	"\x0aMZN\x0aNAD\x0aNGN\x0aNIC\x0aNIO\x0aNLG\x0aNOK\x0aNPR\x0aNZD\x0aOMR" +
	"\x0bPAB\x0aPEI\x0aPEN\x0aPES\x0aPGK\x0aPHP\x0aPKR\x08PLN\x0aPLZ\x0aPTE" +
	"\x0aPYG\x08QAR\x0aRHD\x0aROL\x0aRON\x0aRSD\x08RUB\x0aRUR\x0aRWF\x08SAR" +
	"\x0aSBD\x0aSCR\x0aSDD\x0aSDG\x0aSDP\x0aSEK\x0aSGD\x0aSHP\x0aSIT\x0aSKK" +
	"\x0aSLL\x08SOS\x08SRD\x0aSRG\x0aSSP\x0aSTD\x08SUR\x0aSVC\x0aSYP\x08SZL" +
	"\x0aTHB\x0aTJR\x0aTJS\x0aTMM\x08TMT\x0aTND\x0bTOP\x0aTPE\x0aTRL\x08TRY" +
	"\x0aTTD\x0aTWD\x0aTZS\x08UAH\x0aUAK\x0aUGS\x0aUGX\x08USD\x0aUSN\x0aUSS" +
	"\x0aUYI\x08UYP\x0aUYU\x0aUZS\x08VEB\x0aVEF\x0aVND\x08VNN\x0aVUV\x08WST" +
	"\x0aXAF\x08XAG\x0aXAU\x0aXBA\x0aXBB\x0aXBC\x0aXBD\x0aXCD\x0aXDR\x0aXEU" +
	"\x0aXFO\x0aXFU\x0aXOF\x08XPD\x0aXPF\x08XPT\x0aXRE\x0aXSU\x0aXTS\x0aXUA" +
	"\x0aXXX\x0aYDD\x0aYER\x08YUD\x0aYUM\x0aYUN\x0aYUR\x0aZAL\x0aZAR\x0aZMK" +
	"\x08ZMW\x0aZRN\x0aZRZ\x0aZWD\x08ZWL\x0aZWR\x0a\xff\xff\xff\xff"

// nRegionGroups is the number of region groups.
const nRegionGroups = 32

type likelyLangRegion struct {
	lang   uint16
	region uint16
}

// likelyScript is a lookup table, indexed by scriptID, for the most likely
// languages and regions given a script.
// Size: 900 bytes, 225 elements
var likelyScript = [225]likelyLangRegion{
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x150, region: 0x104},
	{lang: 0x0, region: 0x0},
	{lang: 0x14, region: 0x6a},
	{lang: 0x0, region: 0x0},
	{lang: 0x15, region: 0x9a},
	{lang: 0xeb, region: 0x27},
	{lang: 0x8, region: 0x9a},
	{lang: 0x26, region: 0x93},
	{lang: 0x2a, region: 0x51},
	{lang: 0x52, region: 0xb2},
	{lang: 0x2b, region: 0x93},
	{lang: 0x48, region: 0x34},
	{lang: 0x0, region: 0x0},
	{lang: 0x2b1, region: 0x12c},
	{lang: 0x1d9, region: 0x97},
	{lang: 0xaa, region: 0x76},
	{lang: 0x58, region: 0x93},
	{lang: 0x44, region: 0xe5},
	{lang: 0x60, region: 0x34},
	{lang: 0x70, region: 0x48},
	{lang: 0x297, region: 0x129},
	{lang: 0x6b, region: 0x13b},
	{lang: 0x69, region: 0x132},
	{lang: 0x0, region: 0x0},
	{lang: 0x6e, region: 0x6a},
	{lang: 0xca, region: 0x5c},
	{lang: 0x1fb, region: 0x104},
	{lang: 0x0, region: 0x0},
	{lang: 0xda, region: 0x97},
	{lang: 0x0, region: 0x0},
	{lang: 0xaa, region: 0x76},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x94, region: 0x6a},
	{lang: 0x22c, region: 0x26},
	{lang: 0x10, region: 0x6e},
	{lang: 0x0, region: 0x0},
	{lang: 0x108, region: 0x7b},
	{lang: 0x7a, region: 0x37},
	{lang: 0xc9, region: 0x12e},
	{lang: 0x201, region: 0x97},
	{lang: 0x96, region: 0x85},
	{lang: 0xcd, region: 0x97},
	{lang: 0x1cb, region: 0x97},
	{lang: 0x12d, region: 0xa9},
	{lang: 0x2b1, region: 0x52},
	{lang: 0xe1, region: 0xe5},
	{lang: 0x2b1, region: 0x52},
	{lang: 0x2b1, region: 0x12c},
	{lang: 0x0, region: 0x0},
	{lang: 0xd9, region: 0x95},
	{lang: 0xff, region: 0xa0},
	{lang: 0x0, region: 0x0},
	{lang: 0xe0, region: 0xad},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x9c, region: 0x9c},
	{lang: 0x106, region: 0x93},
	{lang: 0xff, region: 0xa0},
	{lang: 0x0, region: 0x0},
	{lang: 0x95, region: 0xc2},
	{lang: 0xff, region: 0xa0},
	{lang: 0x1df, region: 0xe6},
	{lang: 0x12a, region: 0xa4},
	{lang: 0x20e, region: 0x97},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x12c, region: 0x97},
	{lang: 0x12d, region: 0xa9},
	{lang: 0x0, region: 0x0},
	{lang: 0x39, region: 0x97},
	{lang: 0x1b7, region: 0x121},
	{lang: 0x15c, region: 0xad},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x14f, region: 0x97},
	{lang: 0x153, region: 0x97},
	{lang: 0x146, region: 0x85},
	{lang: 0xca, region: 0x85},
	{lang: 0x155, region: 0x52},
	{lang: 0x0, region: 0x0},
	{lang: 0x299, region: 0x129},
	{lang: 0x29a, region: 0x129},
	{lang: 0xda, region: 0x97},
	{lang: 0x19e, region: 0x9a},
	{lang: 0x29c, region: 0x52},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x176, region: 0x110},
	{lang: 0x29d, region: 0x109},
	{lang: 0x29d, region: 0x109},
	{lang: 0x184, region: 0x97},
	{lang: 0x18c, region: 0x97},
	{lang: 0x185, region: 0x52},
	{lang: 0x0, region: 0x0},
	{lang: 0x18f, region: 0x34},
	{lang: 0x186, region: 0x97},
	{lang: 0x0, region: 0x0},
	{lang: 0x19b, region: 0xc2},
	{lang: 0x29e, region: 0x106},
	{lang: 0x15, region: 0x9f},
	{lang: 0x0, region: 0x0},
	{lang: 0x170, region: 0x82},
	{lang: 0x0, region: 0x0},
	{lang: 0x216, region: 0x94},
	{lang: 0x206, region: 0x97},
	{lang: 0x1ca, region: 0xc3},
	{lang: 0x1c8, region: 0x97},
	{lang: 0x0, region: 0x0},
	{lang: 0x22a, region: 0x113},
	{lang: 0x15, region: 0x11a},
	{lang: 0x79, region: 0xc2},
	{lang: 0x13e, region: 0x104},
	{lang: 0x169, region: 0x52},
	{lang: 0x1cd, region: 0x9a},
	{lang: 0x1cd, region: 0x52},
	{lang: 0x0, region: 0x0},
	{lang: 0x1d7, region: 0xae},
	{lang: 0xdd, region: 0x52},
	{lang: 0x2a1, region: 0x9a},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x1ea, region: 0x93},
	{lang: 0x0, region: 0x0},
	{lang: 0x1b9, region: 0x10a},
	{lang: 0x226, region: 0x95},
	{lang: 0x0, region: 0x0},
	{lang: 0x2a2, region: 0x15b},
	{lang: 0x207, region: 0x97},
	{lang: 0x0, region: 0x0},
	{lang: 0x97, region: 0x79},
	{lang: 0x201, region: 0x97},
	{lang: 0x201, region: 0x97},
	{lang: 0x20e, region: 0x97},
	{lang: 0x21b, region: 0xb1},
	{lang: 0x22e, region: 0x97},
	{lang: 0x236, region: 0x93},
	{lang: 0x23f, region: 0x34},
	{lang: 0x240, region: 0x99},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x244, region: 0xe5},
	{lang: 0x87, region: 0x97},
	{lang: 0x246, region: 0x52},
	{lang: 0x11d, region: 0x52},
	{lang: 0x242, region: 0x97},
	{lang: 0x0, region: 0x0},
	{lang: 0x45, region: 0x13b},
	{lang: 0x249, region: 0x97},
	{lang: 0x0, region: 0x0},
	{lang: 0x2b0, region: 0xb8},
	{lang: 0xa5, region: 0xe5},
	{lang: 0x8c, region: 0xcb},
	{lang: 0x24e, region: 0x121},
	{lang: 0x49, region: 0x52},
	{lang: 0x16e, region: 0x97},
	{lang: 0x275, region: 0x11a},
	{lang: 0x27e, region: 0xb2},
	{lang: 0x0, region: 0x0},
	{lang: 0xe4, region: 0x97},
	{lang: 0x0, region: 0x0},
	{lang: 0x1d5, region: 0x9a},
	{lang: 0xd, region: 0x99},
	{lang: 0xf3, region: 0x52},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
}

type likelyScriptRegion struct {
	region uint16
	script uint8
	flags  uint8
}

// likelyLang is a lookup table, indexed by langID, for the most likely
// scripts and regions given incomplete information. If more entries exist for a
// given language, region and script are the index and size respectively
// of the list in likelyLangList.
// Size: 2776 bytes, 694 elements
var likelyLang = [694]likelyScriptRegion{
	{region: 0x132, script: 0x4f, flags: 0x0},
	{region: 0x6e, script: 0x4f, flags: 0x0},
	{region: 0x7b, script: 0x1d, flags: 0x0},
	{region: 0x7e, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x12f, script: 0x4f, flags: 0x0},
	{region: 0x7e, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x9a, script: 0x9, flags: 0x0},
	{region: 0x126, script: 0x5, flags: 0x0},
	{region: 0x15e, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0x7e, script: 0x4f, flags: 0x0},
	{region: 0x99, script: 0xd8, flags: 0x0},
	{region: 0x14a, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x6e, script: 0x26, flags: 0x0},
	{region: 0xd4, script: 0x4f, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x6a, script: 0x5, flags: 0x0},
	{region: 0x0, script: 0x3, flags: 0x1},
	{region: 0x50, script: 0x4f, flags: 0x0},
	{region: 0x3e, script: 0x4f, flags: 0x0},
	{region: 0x66, script: 0x5, flags: 0x0},
	{region: 0xb8, script: 0x5, flags: 0x0},
	{region: 0x6a, script: 0x5, flags: 0x0},
	{region: 0x97, script: 0xe, flags: 0x0},
	{region: 0x12d, script: 0x4f, flags: 0x0},
	{region: 0x6d, script: 0x4f, flags: 0x0},
	{region: 0x48, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x3e, script: 0x4f, flags: 0x0},
	{region: 0x3, script: 0x4, flags: 0x1},
	{region: 0x9a, script: 0x5, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0x2d, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0xb, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0x4e, script: 0x4f, flags: 0x0},
	{region: 0x46, script: 0x1d, flags: 0x0},
	{region: 0x15f, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x12d, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0xc7, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x37, script: 0x1d, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x129, script: 0x2c, flags: 0x0},
	{region: 0x97, script: 0x4a, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x13c, script: 0x4f, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0xd4, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0x13b, script: 0xc9, flags: 0x0},
	{region: 0xc1, script: 0x4f, flags: 0x0},
	{region: 0xc1, script: 0x4f, flags: 0x0},
	{region: 0x34, script: 0xe, flags: 0x0},
	{region: 0x52, script: 0xd0, flags: 0x0},
	{region: 0x97, script: 0xe, flags: 0x0},
	{region: 0x9a, script: 0x5, flags: 0x0},
	{region: 0x4e, script: 0x4f, flags: 0x0},
	{region: 0x76, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x32, script: 0x4f, flags: 0x0},
	{region: 0xb2, script: 0xc, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0xe6, script: 0x1f, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x15c, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0x84, script: 0x4f, flags: 0x0},
	{region: 0x6c, script: 0x26, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0xc1, script: 0x4f, flags: 0x0},
	{region: 0x6d, script: 0x4f, flags: 0x0},
	{region: 0xd4, script: 0x4f, flags: 0x0},
	{region: 0x7, script: 0x2, flags: 0x1},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0x12f, script: 0x4f, flags: 0x0},
	{region: 0x88, script: 0x4f, flags: 0x0},
	{region: 0x73, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x132, script: 0x4f, flags: 0x0},
	{region: 0x48, script: 0x4f, flags: 0x0},
	{region: 0x132, script: 0x19, flags: 0x0},
	{region: 0xa4, script: 0x5, flags: 0x0},
	{region: 0x13b, script: 0x18, flags: 0x0},
	{region: 0x99, script: 0x5, flags: 0x0},
	{region: 0x76, script: 0x4f, flags: 0x0},
	{region: 0x6a, script: 0x1b, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0x48, script: 0x16, flags: 0x0},
	{region: 0x48, script: 0x16, flags: 0x0},
	{region: 0x48, script: 0x16, flags: 0x0},
	{region: 0x48, script: 0x16, flags: 0x0},
	{region: 0x48, script: 0x16, flags: 0x0},
	{region: 0x108, script: 0x4f, flags: 0x0},
	{region: 0x5d, script: 0x4f, flags: 0x0},
	{region: 0xe7, script: 0x4f, flags: 0x0},
	{region: 0x48, script: 0x16, flags: 0x0},
	{region: 0xc2, script: 0x74, flags: 0x0},
	{region: 0x9, script: 0x2, flags: 0x1},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x79, script: 0x4f, flags: 0x0},
	{region: 0x62, script: 0x4f, flags: 0x0},
	{region: 0x132, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0xa2, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x5, flags: 0x0},
	{region: 0x5f, script: 0x4f, flags: 0x0},
	{region: 0x48, script: 0x4f, flags: 0x0},
	{region: 0x48, script: 0x4f, flags: 0x0},
	{region: 0xd2, script: 0x4f, flags: 0x0},
	{region: 0x4e, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x5, flags: 0x0},
	{region: 0x5f, script: 0x4f, flags: 0x0},
	{region: 0xc1, script: 0x4f, flags: 0x0},
	{region: 0xce, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0xcb, script: 0xce, flags: 0x0},
	{region: 0x112, script: 0x4f, flags: 0x0},
	{region: 0x36, script: 0x4f, flags: 0x0},
	{region: 0x42, script: 0xd0, flags: 0x0},
	{region: 0xa2, script: 0x4f, flags: 0x0},
	{region: 0x7e, script: 0x4f, flags: 0x0},
	{region: 0xd4, script: 0x4f, flags: 0x0},
	{region: 0x9c, script: 0x4f, flags: 0x0},
	{region: 0x6a, script: 0x24, flags: 0x0},
	{region: 0xc2, script: 0x40, flags: 0x0},
	{region: 0x85, script: 0x2c, flags: 0x0},
	{region: 0xb, script: 0x2, flags: 0x1},
	{region: 0x1, script: 0x4f, flags: 0x0},
	{region: 0x6d, script: 0x4f, flags: 0x0},
	{region: 0x132, script: 0x4f, flags: 0x0},
	{region: 0x69, script: 0x4f, flags: 0x0},
	{region: 0x9c, script: 0x3c, flags: 0x0},
	{region: 0x6d, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0x6d, script: 0x4f, flags: 0x0},
	{region: 0x9a, script: 0x5, flags: 0x0},
	{region: 0x84, script: 0x4f, flags: 0x0},
	{region: 0x112, script: 0x4f, flags: 0x0},
	{region: 0xc1, script: 0x4f, flags: 0x0},
	{region: 0x70, script: 0x4f, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0x10a, script: 0x4f, flags: 0x0},
	{region: 0x71, script: 0x4f, flags: 0x0},
	{region: 0x74, script: 0x4f, flags: 0x0},
	{region: 0x3a, script: 0x4f, flags: 0x0},
	{region: 0x76, script: 0x4f, flags: 0x0},
	{region: 0x132, script: 0x4f, flags: 0x0},
	{region: 0x76, script: 0x4f, flags: 0x0},
	{region: 0x5f, script: 0x4f, flags: 0x0},
	{region: 0x5f, script: 0x4f, flags: 0x0},
	{region: 0x13d, script: 0x4f, flags: 0x0},
	{region: 0xd2, script: 0x4f, flags: 0x0},
	{region: 0x9c, script: 0x4f, flags: 0x0},
	{region: 0xd4, script: 0x4f, flags: 0x0},
	{region: 0xd7, script: 0x4f, flags: 0x0},
	{region: 0x94, script: 0x4f, flags: 0x0},
	{region: 0x7e, script: 0x4f, flags: 0x0},
	{region: 0xba, script: 0x4f, flags: 0x0},
	{region: 0x52, script: 0x32, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x9a, script: 0x5, flags: 0x0},
	{region: 0x7c, script: 0x4f, flags: 0x0},
	{region: 0x79, script: 0x4f, flags: 0x0},
	{region: 0x6e, script: 0x26, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0xa5, script: 0x4f, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x0},
	{region: 0x6d, script: 0x4f, flags: 0x0},
	{region: 0x9a, script: 0x5, flags: 0x0},
	{region: 0xef, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x97, script: 0xca, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0xd7, script: 0x4f, flags: 0x0},
	{region: 0x12e, script: 0x2a, flags: 0x0},
	{region: 0xd, script: 0x2, flags: 0x1},
	{region: 0x97, script: 0xe, flags: 0x0},
	{region: 0x4d, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x2d, flags: 0x0},
	{region: 0x40, script: 0x4f, flags: 0x0},
	{region: 0x53, script: 0x4f, flags: 0x0},
	{region: 0x7e, script: 0x4f, flags: 0x0},
	{region: 0xa2, script: 0x4f, flags: 0x0},
	{region: 0x96, script: 0x4f, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0x48, script: 0x4f, flags: 0x0},
	{region: 0xf, script: 0x3, flags: 0x1},
	{region: 0x52, script: 0x32, flags: 0x0},
	{region: 0x132, script: 0x4f, flags: 0x0},
	{region: 0x23, script: 0x5, flags: 0x0},
	{region: 0x95, script: 0x35, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x71, script: 0x1f, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0x52, script: 0x7b, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0xad, script: 0x38, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x0},
	{region: 0xe4, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x8e, script: 0x4f, flags: 0x0},
	{region: 0x5f, script: 0x4f, flags: 0x0},
	{region: 0x52, script: 0x32, flags: 0x0},
	{region: 0x8f, script: 0x4f, flags: 0x0},
	{region: 0x90, script: 0x4f, flags: 0x0},
	{region: 0x27, script: 0x8, flags: 0x0},
	{region: 0xd0, script: 0x4f, flags: 0x0},
	{region: 0x76, script: 0x4f, flags: 0x0},
	{region: 0xce, script: 0x4f, flags: 0x0},
	{region: 0xd4, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0xd4, script: 0x4f, flags: 0x0},
	{region: 0x52, script: 0xd9, flags: 0x0},
	{region: 0x132, script: 0x4f, flags: 0x0},
	{region: 0x48, script: 0x4f, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x9b, script: 0x4f, flags: 0x0},
	{region: 0x9c, script: 0x4f, flags: 0x0},
	{region: 0x48, script: 0x16, flags: 0x0},
	{region: 0x95, script: 0x35, flags: 0x0},
	{region: 0x104, script: 0x4f, flags: 0x0},
	{region: 0xa0, script: 0x3e, flags: 0x0},
	{region: 0x9e, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0x12e, script: 0x35, flags: 0x0},
	{region: 0x12d, script: 0x4f, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0x62, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x7b, script: 0x28, flags: 0x0},
	{region: 0x134, script: 0x1d, flags: 0x0},
	{region: 0x66, script: 0x4f, flags: 0x0},
	{region: 0xc2, script: 0x4f, flags: 0x0},
	{region: 0xd4, script: 0x4f, flags: 0x0},
	{region: 0xa2, script: 0x4f, flags: 0x0},
	{region: 0xc1, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0xd4, script: 0x4f, flags: 0x0},
	{region: 0x161, script: 0x4f, flags: 0x0},
	{region: 0x12d, script: 0x4f, flags: 0x0},
	{region: 0x121, script: 0xcf, flags: 0x0},
	{region: 0x59, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0x4e, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x4a, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x40, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x4f, flags: 0x0},
	{region: 0x52, script: 0xc6, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0xc1, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x67, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x0},
	{region: 0xa2, script: 0x4f, flags: 0x0},
	{region: 0x129, script: 0x4f, flags: 0x0},
	{region: 0xd0, script: 0x4f, flags: 0x0},
	{region: 0xad, script: 0x4c, flags: 0x0},
	{region: 0x12, script: 0x6, flags: 0x1},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0x80, script: 0x4f, flags: 0x0},
	{region: 0xa2, script: 0x4f, flags: 0x0},
	{region: 0xa4, script: 0x43, flags: 0x0},
	{region: 0x29, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x47, flags: 0x0},
	{region: 0xa9, script: 0x48, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x73, script: 0x4f, flags: 0x0},
	{region: 0xb2, script: 0x4f, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x110, script: 0x4f, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x97, script: 0x5, flags: 0x0},
	{region: 0x12d, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0x5f, script: 0x4f, flags: 0x0},
	{region: 0x18, script: 0x3, flags: 0x1},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x0},
	{region: 0x79, script: 0x4f, flags: 0x0},
	{region: 0x121, script: 0xcf, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x0},
	{region: 0x1b, script: 0x5, flags: 0x1},
	{region: 0x135, script: 0x4f, flags: 0x0},
	{region: 0x85, script: 0x52, flags: 0x0},
	{region: 0x95, script: 0x35, flags: 0x0},
	{region: 0x12d, script: 0x4f, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x0},
	{region: 0x12f, script: 0x4f, flags: 0x0},
	{region: 0xb5, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x52, script: 0xcf, flags: 0x0},
	{region: 0x97, script: 0x50, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x12f, script: 0x4f, flags: 0x0},
	{region: 0xd7, script: 0x4f, flags: 0x0},
	{region: 0x20, script: 0x2, flags: 0x1},
	{region: 0x9c, script: 0x4f, flags: 0x0},
	{region: 0x52, script: 0x54, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x9a, script: 0x5, flags: 0x0},
	{region: 0x132, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0xca, flags: 0x0},
	{region: 0x9c, script: 0x4f, flags: 0x0},
	{region: 0x4a, script: 0x4f, flags: 0x0},
	{region: 0xad, script: 0x4c, flags: 0x0},
	{region: 0x4a, script: 0x4f, flags: 0x0},
	{region: 0x15f, script: 0x4f, flags: 0x0},
	{region: 0x9a, script: 0x5, flags: 0x0},
	{region: 0xb4, script: 0x4f, flags: 0x0},
	{region: 0xb6, script: 0x4f, flags: 0x0},
	{region: 0x4a, script: 0x4f, flags: 0x0},
	{region: 0x4a, script: 0x4f, flags: 0x0},
	{region: 0xa2, script: 0x4f, flags: 0x0},
	{region: 0xa2, script: 0x4f, flags: 0x0},
	{region: 0x9a, script: 0x5, flags: 0x0},
	{region: 0xb6, script: 0x4f, flags: 0x0},
	{region: 0x121, script: 0xcf, flags: 0x0},
	{region: 0x52, script: 0x32, flags: 0x0},
	{region: 0x129, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x22, script: 0x3, flags: 0x1},
	{region: 0xa2, script: 0x4f, flags: 0x0},
	{region: 0xcd, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x110, script: 0x4f, flags: 0x0},
	{region: 0xa2, script: 0x4f, flags: 0x0},
	{region: 0x121, script: 0x5, flags: 0x0},
	{region: 0xca, script: 0x4f, flags: 0x0},
	{region: 0xbd, script: 0x4f, flags: 0x0},
	{region: 0xcf, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0x12d, script: 0x4f, flags: 0x0},
	{region: 0xbe, script: 0x4f, flags: 0x0},
	{region: 0xde, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0xc0, script: 0x1d, flags: 0x0},
	{region: 0x97, script: 0x60, flags: 0x0},
	{region: 0x25, script: 0x3, flags: 0x1},
	{region: 0x97, script: 0xe, flags: 0x0},
	{region: 0xc2, script: 0x67, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x48, script: 0x4f, flags: 0x0},
	{region: 0x48, script: 0x4f, flags: 0x0},
	{region: 0x36, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x34, script: 0x64, flags: 0x0},
	{region: 0x28, script: 0x3, flags: 0x1},
	{region: 0xc9, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x132, script: 0x4f, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x0},
	{region: 0xc1, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x161, script: 0x4f, flags: 0x0},
	{region: 0xc2, script: 0x67, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x12f, script: 0x4f, flags: 0x0},
	{region: 0x9a, script: 0x59, flags: 0x0},
	{region: 0x9a, script: 0x5, flags: 0x0},
	{region: 0xdb, script: 0x4f, flags: 0x0},
	{region: 0x52, script: 0x32, flags: 0x0},
	{region: 0x9c, script: 0x4f, flags: 0x0},
	{region: 0xd0, script: 0x4f, flags: 0x0},
	{region: 0xd8, script: 0x4f, flags: 0x0},
	{region: 0xcd, script: 0x4f, flags: 0x0},
	{region: 0x161, script: 0x4f, flags: 0x0},
	{region: 0xcf, script: 0x4f, flags: 0x0},
	{region: 0x5f, script: 0x4f, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0xd0, script: 0x4f, flags: 0x0},
	{region: 0xcf, script: 0x4f, flags: 0x0},
	{region: 0xcd, script: 0x4f, flags: 0x0},
	{region: 0xcd, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0xdd, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x4f, flags: 0x0},
	{region: 0xd7, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0xd8, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0xd8, script: 0x4f, flags: 0x0},
	{region: 0x121, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x10a, script: 0xb1, flags: 0x0},
	{region: 0x82, script: 0x6b, flags: 0x0},
	{region: 0x15e, script: 0x4f, flags: 0x0},
	{region: 0x48, script: 0x16, flags: 0x0},
	{region: 0x15e, script: 0x4f, flags: 0x0},
	{region: 0x109, script: 0x4f, flags: 0x0},
	{region: 0x132, script: 0x4f, flags: 0x0},
	{region: 0x52, script: 0x4f, flags: 0x0},
	{region: 0xcc, script: 0x4f, flags: 0x0},
	{region: 0x12d, script: 0x4f, flags: 0x0},
	{region: 0x12f, script: 0x4f, flags: 0x0},
	{region: 0x7e, script: 0x4f, flags: 0x0},
	{region: 0x76, script: 0x4f, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x6e, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x70, flags: 0x0},
	{region: 0x7b, script: 0x1d, flags: 0x0},
	{region: 0xc3, script: 0x6f, flags: 0x0},
	{region: 0x2b, script: 0x3, flags: 0x1},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0x2e, script: 0x2, flags: 0x1},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0x2f, script: 0x4f, flags: 0x0},
	{region: 0xee, script: 0x4f, flags: 0x0},
	{region: 0x76, script: 0x4f, flags: 0x0},
	{region: 0xd4, script: 0x4f, flags: 0x0},
	{region: 0x132, script: 0x4f, flags: 0x0},
	{region: 0x48, script: 0x4f, flags: 0x0},
	{region: 0x9a, script: 0xd7, flags: 0x0},
	{region: 0x5f, script: 0x4f, flags: 0x0},
	{region: 0xae, script: 0x7a, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x97, script: 0x11, flags: 0x0},
	{region: 0xa2, script: 0x4f, flags: 0x0},
	{region: 0xe7, script: 0x4f, flags: 0x0},
	{region: 0x9c, script: 0x4f, flags: 0x0},
	{region: 0x85, script: 0x2c, flags: 0x0},
	{region: 0x73, script: 0x4f, flags: 0x0},
	{region: 0xe6, script: 0x42, flags: 0x0},
	{region: 0x9a, script: 0x5, flags: 0x0},
	{region: 0x1, script: 0x4f, flags: 0x0},
	{region: 0x23, script: 0x5, flags: 0x0},
	{region: 0x40, script: 0x4f, flags: 0x0},
	{region: 0x78, script: 0x4f, flags: 0x0},
	{region: 0xe2, script: 0x4f, flags: 0x0},
	{region: 0x87, script: 0x4f, flags: 0x0},
	{region: 0x68, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x4f, flags: 0x0},
	{region: 0x100, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x9c, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x4f, flags: 0x0},
	{region: 0x30, script: 0x2, flags: 0x1},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0x34, script: 0xe, flags: 0x0},
	{region: 0x4d, script: 0x4f, flags: 0x0},
	{region: 0x70, script: 0x4f, flags: 0x0},
	{region: 0x4d, script: 0x4f, flags: 0x0},
	{region: 0x9a, script: 0x5, flags: 0x0},
	{region: 0x10a, script: 0x4f, flags: 0x0},
	{region: 0x39, script: 0x4f, flags: 0x0},
	{region: 0xcf, script: 0x4f, flags: 0x0},
	{region: 0x102, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x12d, script: 0x4f, flags: 0x0},
	{region: 0x71, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x12e, script: 0x1d, flags: 0x0},
	{region: 0x107, script: 0x4f, flags: 0x0},
	{region: 0x105, script: 0x4f, flags: 0x0},
	{region: 0x12d, script: 0x4f, flags: 0x0},
	{region: 0xa0, script: 0x41, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x7e, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0xa2, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0xb5, flags: 0x0},
	{region: 0x12d, script: 0x4f, flags: 0x0},
	{region: 0x9c, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x9c, script: 0x4f, flags: 0x0},
	{region: 0x79, script: 0x4f, flags: 0x0},
	{region: 0x48, script: 0x4f, flags: 0x0},
	{region: 0x32, script: 0x4, flags: 0x1},
	{region: 0x9c, script: 0x4f, flags: 0x0},
	{region: 0xd8, script: 0x4f, flags: 0x0},
	{region: 0x4e, script: 0x4f, flags: 0x0},
	{region: 0xcf, script: 0x4f, flags: 0x0},
	{region: 0xcd, script: 0x4f, flags: 0x0},
	{region: 0xc1, script: 0x4f, flags: 0x0},
	{region: 0x4b, script: 0x4f, flags: 0x0},
	{region: 0x94, script: 0x6d, flags: 0x0},
	{region: 0xb4, script: 0x4f, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0xb8, script: 0xcc, flags: 0x0},
	{region: 0xc2, script: 0x67, flags: 0x0},
	{region: 0xb1, script: 0xbb, flags: 0x0},
	{region: 0x6e, script: 0x4f, flags: 0x0},
	{region: 0x10f, script: 0x4f, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x0},
	{region: 0x10d, script: 0x4f, flags: 0x0},
	{region: 0xe7, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x13f, script: 0x4f, flags: 0x0},
	{region: 0x10a, script: 0x4f, flags: 0x0},
	{region: 0x10a, script: 0x4f, flags: 0x0},
	{region: 0x70, script: 0x4f, flags: 0x0},
	{region: 0x95, script: 0xb2, flags: 0x0},
	{region: 0x70, script: 0x4f, flags: 0x0},
	{region: 0x161, script: 0x4f, flags: 0x0},
	{region: 0xc1, script: 0x4f, flags: 0x0},
	{region: 0x113, script: 0x4f, flags: 0x0},
	{region: 0x121, script: 0xcf, flags: 0x0},
	{region: 0x26, script: 0x4f, flags: 0x0},
	{region: 0x36, script: 0x5, flags: 0x1},
	{region: 0x97, script: 0xbc, flags: 0x0},
	{region: 0x114, script: 0x4f, flags: 0x0},
	{region: 0x112, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x15e, script: 0x4f, flags: 0x0},
	{region: 0x6c, script: 0x4f, flags: 0x0},
	{region: 0x15e, script: 0x4f, flags: 0x0},
	{region: 0x5f, script: 0x4f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x12d, script: 0x4f, flags: 0x0},
	{region: 0x82, script: 0x4f, flags: 0x0},
	{region: 0x10a, script: 0x4f, flags: 0x0},
	{region: 0x12d, script: 0x4f, flags: 0x0},
	{region: 0x15c, script: 0x5, flags: 0x0},
	{region: 0x4a, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x93, script: 0x4f, flags: 0x0},
	{region: 0x34, script: 0xe, flags: 0x0},
	{region: 0x99, script: 0xbf, flags: 0x0},
	{region: 0xe7, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0xc7, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x47, flags: 0x0},
	{region: 0x52, script: 0xc5, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0x97, script: 0xca, flags: 0x0},
	{region: 0x110, script: 0x4f, flags: 0x0},
	{region: 0x12f, script: 0x4f, flags: 0x0},
	{region: 0x124, script: 0x4f, flags: 0x0},
	{region: 0x3b, script: 0x3, flags: 0x1},
	{region: 0x121, script: 0xcf, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0x6e, script: 0x26, flags: 0x0},
	{region: 0x6c, script: 0x26, flags: 0x0},
	{region: 0xd4, script: 0x4f, flags: 0x0},
	{region: 0x125, script: 0x4f, flags: 0x0},
	{region: 0x123, script: 0x4f, flags: 0x0},
	{region: 0x31, script: 0x4f, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0x31, script: 0x4f, flags: 0x0},
	{region: 0xd2, script: 0x4f, flags: 0x0},
	{region: 0x15e, script: 0x4f, flags: 0x0},
	{region: 0x127, script: 0x4f, flags: 0x0},
	{region: 0xcc, script: 0x4f, flags: 0x0},
	{region: 0xe4, script: 0x4f, flags: 0x0},
	{region: 0x129, script: 0x4f, flags: 0x0},
	{region: 0x129, script: 0x4f, flags: 0x0},
	{region: 0x12c, script: 0x4f, flags: 0x0},
	{region: 0x15e, script: 0x4f, flags: 0x0},
	{region: 0x85, script: 0x2c, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0x42, script: 0xd0, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x12f, script: 0x4f, flags: 0x0},
	{region: 0x121, script: 0xcf, flags: 0x0},
	{region: 0x31, script: 0x4f, flags: 0x0},
	{region: 0xcc, script: 0x4f, flags: 0x0},
	{region: 0x12b, script: 0x4f, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0xd2, script: 0x4f, flags: 0x0},
	{region: 0xe3, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0xb8, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x3e, script: 0x4, flags: 0x1},
	{region: 0x11a, script: 0xd2, flags: 0x0},
	{region: 0x12e, script: 0x1d, flags: 0x0},
	{region: 0x73, script: 0x4f, flags: 0x0},
	{region: 0x29, script: 0x4f, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x42, script: 0x3, flags: 0x1},
	{region: 0x97, script: 0xe, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x0},
	{region: 0x45, script: 0x4, flags: 0x1},
	{region: 0xb2, script: 0xd3, flags: 0x0},
	{region: 0x15e, script: 0x4f, flags: 0x0},
	{region: 0x9c, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x4f, flags: 0x0},
	{region: 0x13b, script: 0x4f, flags: 0x0},
	{region: 0x119, script: 0x4f, flags: 0x0},
	{region: 0x35, script: 0x4f, flags: 0x0},
	{region: 0x5f, script: 0x4f, flags: 0x0},
	{region: 0xcf, script: 0x4f, flags: 0x0},
	{region: 0x1, script: 0x4f, flags: 0x0},
	{region: 0x104, script: 0x4f, flags: 0x0},
	{region: 0x69, script: 0x4f, flags: 0x0},
	{region: 0x12d, script: 0x4f, flags: 0x0},
	{region: 0x35, script: 0x4f, flags: 0x0},
	{region: 0x4d, script: 0x4f, flags: 0x0},
	{region: 0x6e, script: 0x26, flags: 0x0},
	{region: 0xe5, script: 0x4f, flags: 0x0},
	{region: 0x2e, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0xca, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x13d, script: 0x4f, flags: 0x0},
	{region: 0x112, script: 0x4f, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x52, script: 0x32, flags: 0x0},
	{region: 0x40, script: 0x4f, flags: 0x0},
	{region: 0x129, script: 0x17, flags: 0x0},
	{region: 0x15e, script: 0x4f, flags: 0x0},
	{region: 0x129, script: 0x56, flags: 0x0},
	{region: 0x129, script: 0x57, flags: 0x0},
	{region: 0x7b, script: 0x28, flags: 0x0},
	{region: 0x52, script: 0x5a, flags: 0x0},
	{region: 0x109, script: 0x5e, flags: 0x0},
	{region: 0x106, script: 0x68, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x0},
	{region: 0x12f, script: 0x4f, flags: 0x0},
	{region: 0x9a, script: 0x7c, flags: 0x0},
	{region: 0x15b, script: 0xb4, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0xcf, script: 0x4f, flags: 0x0},
	{region: 0x73, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x4f, flags: 0x0},
	{region: 0x1, script: 0x35, flags: 0x0},
	{region: 0xd4, script: 0x4f, flags: 0x0},
	{region: 0x40, script: 0x4f, flags: 0x0},
	{region: 0xcd, script: 0x4f, flags: 0x0},
	{region: 0x52, script: 0x4f, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0xa6, script: 0x5, flags: 0x0},
	{region: 0xd7, script: 0x4f, flags: 0x0},
	{region: 0xb8, script: 0xcc, flags: 0x0},
	{region: 0x49, script: 0x13, flags: 0x1},
	{region: 0xce, script: 0x4f, flags: 0x0},
	{region: 0x15e, script: 0x4f, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x129, script: 0x4f, flags: 0x0},
}

// likelyLangList holds lists info associated with likelyLang.
// Size: 368 bytes, 92 elements
var likelyLangList = [92]likelyScriptRegion{
	{region: 0x9a, script: 0x7, flags: 0x0},
	{region: 0x9f, script: 0x69, flags: 0x2},
	{region: 0x11a, script: 0x73, flags: 0x2},
	{region: 0x31, script: 0x4f, flags: 0x0},
	{region: 0x9a, script: 0x5, flags: 0x4},
	{region: 0x104, script: 0x1d, flags: 0x4},
	{region: 0x9a, script: 0x5, flags: 0x2},
	{region: 0x97, script: 0xe, flags: 0x0},
	{region: 0x34, script: 0x15, flags: 0x2},
	{region: 0x104, script: 0x1d, flags: 0x0},
	{region: 0x37, script: 0x29, flags: 0x2},
	{region: 0x132, script: 0x4f, flags: 0x0},
	{region: 0x79, script: 0xb7, flags: 0x2},
	{region: 0x5c, script: 0x1c, flags: 0x0},
	{region: 0x85, script: 0x53, flags: 0x2},
	{region: 0xd4, script: 0x4f, flags: 0x0},
	{region: 0x51, script: 0x5, flags: 0x4},
	{region: 0x109, script: 0x5, flags: 0x4},
	{region: 0xac, script: 0x1d, flags: 0x0},
	{region: 0x23, script: 0x5, flags: 0x4},
	{region: 0x52, script: 0x5, flags: 0x4},
	{region: 0x9a, script: 0x5, flags: 0x4},
	{region: 0xc3, script: 0x5, flags: 0x4},
	{region: 0x52, script: 0x5, flags: 0x2},
	{region: 0x129, script: 0x4f, flags: 0x0},
	{region: 0xae, script: 0x5, flags: 0x4},
	{region: 0x99, script: 0x5, flags: 0x2},
	{region: 0xa3, script: 0x1d, flags: 0x0},
	{region: 0x52, script: 0x5, flags: 0x4},
	{region: 0x129, script: 0x4f, flags: 0x4},
	{region: 0x52, script: 0x5, flags: 0x2},
	{region: 0x129, script: 0x4f, flags: 0x2},
	{region: 0xd9, script: 0x1f, flags: 0x0},
	{region: 0x97, script: 0x51, flags: 0x2},
	{region: 0x81, script: 0x4f, flags: 0x0},
	{region: 0x82, script: 0x6b, flags: 0x4},
	{region: 0x82, script: 0x6b, flags: 0x2},
	{region: 0xc3, script: 0x1d, flags: 0x0},
	{region: 0x52, script: 0x62, flags: 0x4},
	{region: 0x52, script: 0x62, flags: 0x2},
	{region: 0xce, script: 0x4f, flags: 0x0},
	{region: 0x49, script: 0x5, flags: 0x4},
	{region: 0x93, script: 0x5, flags: 0x4},
	{region: 0x97, script: 0x2e, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x4},
	{region: 0xe6, script: 0x5, flags: 0x2},
	{region: 0x9a, script: 0x77, flags: 0x0},
	{region: 0x52, script: 0x78, flags: 0x2},
	{region: 0xb8, script: 0xcc, flags: 0x0},
	{region: 0xd7, script: 0x4f, flags: 0x4},
	{region: 0xe6, script: 0x5, flags: 0x0},
	{region: 0x97, script: 0x1f, flags: 0x2},
	{region: 0x97, script: 0x44, flags: 0x2},
	{region: 0x97, script: 0xba, flags: 0x2},
	{region: 0x103, script: 0x1d, flags: 0x0},
	{region: 0xbb, script: 0x4f, flags: 0x4},
	{region: 0x102, script: 0x4f, flags: 0x4},
	{region: 0x104, script: 0x4f, flags: 0x4},
	{region: 0x129, script: 0x4f, flags: 0x4},
	{region: 0x122, script: 0x1d, flags: 0x0},
	{region: 0xe6, script: 0x5, flags: 0x4},
	{region: 0xe6, script: 0x5, flags: 0x2},
	{region: 0x52, script: 0x5, flags: 0x0},
	{region: 0xac, script: 0x1d, flags: 0x4},
	{region: 0xc3, script: 0x1d, flags: 0x4},
	{region: 0xac, script: 0x1d, flags: 0x2},
	{region: 0x97, script: 0xe, flags: 0x0},
	{region: 0xd9, script: 0x1f, flags: 0x4},
	{region: 0xd9, script: 0x1f, flags: 0x2},
	{region: 0x134, script: 0x4f, flags: 0x0},
	{region: 0x23, script: 0x5, flags: 0x4},
	{region: 0x52, script: 0x1d, flags: 0x4},
	{region: 0x23, script: 0x5, flags: 0x2},
	{region: 0x52, script: 0x32, flags: 0x0},
	{region: 0x2e, script: 0x33, flags: 0x4},
	{region: 0x3d, script: 0x33, flags: 0x4},
	{region: 0x79, script: 0x33, flags: 0x4},
	{region: 0x7c, script: 0x33, flags: 0x4},
	{region: 0x8b, script: 0x33, flags: 0x4},
	{region: 0x93, script: 0x33, flags: 0x4},
	{region: 0xc4, script: 0x33, flags: 0x4},
	{region: 0xce, script: 0x33, flags: 0x4},
	{region: 0xe0, script: 0x33, flags: 0x4},
	{region: 0xe3, script: 0x33, flags: 0x4},
	{region: 0xe5, script: 0x33, flags: 0x4},
	{region: 0x114, script: 0x33, flags: 0x4},
	{region: 0x121, script: 0x33, flags: 0x4},
	{region: 0x12c, script: 0x33, flags: 0x4},
	{region: 0x132, script: 0x33, flags: 0x4},
	{region: 0x13b, script: 0x33, flags: 0x4},
	{region: 0x12c, script: 0x10, flags: 0x2},
	{region: 0x12c, script: 0x33, flags: 0x2},
}

type likelyLangScript struct {
	lang   uint16
	script uint8
	flags  uint8
}

// likelyRegion is a lookup table, indexed by regionID, for the most likely
// languages and scripts given incomplete information. If more entries exist
// for a given regionID, lang and script are the index and size respectively
// of the list in likelyRegionList.
// TODO: exclude containers and user-definable regions from the list.
// Size: 1420 bytes, 355 elements
var likelyRegion = [355]likelyLangScript{
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x5e, script: 0x4f, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0x0, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x2, script: 0x2, flags: 0x1},
	{lang: 0x4, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x1e3, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x4f, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x222, script: 0x4f, flags: 0x0},
	{lang: 0x82, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x1b2, script: 0x4f, flags: 0x0},
	{lang: 0x239, script: 0x4f, flags: 0x0},
	{lang: 0x22, script: 0x4f, flags: 0x0},
	{lang: 0x6, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x48, script: 0xe, flags: 0x0},
	{lang: 0x1b2, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x36, script: 0x1d, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0x1f5, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x190, script: 0x4f, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x1cf, script: 0x4f, flags: 0x0},
	{lang: 0x1e3, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x8, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x2e, script: 0x1d, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x2a8, script: 0x35, flags: 0x2},
	{lang: 0x190, script: 0x5, flags: 0x2},
	{lang: 0x23a, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x82, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0xa, script: 0x4, flags: 0x1},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x4f, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x1e3, script: 0x4f, flags: 0x0},
	{lang: 0x1cf, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xe, script: 0x2, flags: 0x1},
	{lang: 0x76, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x82, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x1, script: 0x4f, flags: 0x0},
	{lang: 0x7d, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x10, script: 0x2, flags: 0x1},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x9b, script: 0x4f, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0x252, script: 0x26, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x12, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xa4, script: 0x4f, flags: 0x0},
	{lang: 0xdb, script: 0x1f, flags: 0x2},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xa8, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x14, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x16, script: 0x3, flags: 0x1},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xc, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x128, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x19, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x4f, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x1e3, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x2b1, script: 0x33, flags: 0x0},
	{lang: 0x0, script: 0x4f, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0xe6, script: 0x4f, flags: 0x0},
	{lang: 0xe9, script: 0x4f, flags: 0x0},
	{lang: 0xea, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x1b, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xd9, script: 0x35, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x1d, script: 0x3, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0x20, script: 0x2, flags: 0x1},
	{lang: 0xfa, script: 0x4f, flags: 0x0},
	{lang: 0xfb, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0xff, script: 0x3e, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x23a, script: 0x4f, flags: 0x0},
	{lang: 0x144, script: 0x1d, flags: 0x0},
	{lang: 0x22, script: 0x3, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x25, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x12d, script: 0x48, flags: 0x0},
	{lang: 0x12d, script: 0x48, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x1fb, script: 0x1d, flags: 0x0},
	{lang: 0x27, script: 0x2, flags: 0x1},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x82, script: 0x4f, flags: 0x0},
	{lang: 0x21b, script: 0xbb, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x234, script: 0x4f, flags: 0x0},
	{lang: 0x160, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x167, script: 0x4f, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0x29, script: 0x2, flags: 0x1},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x2b, script: 0x2, flags: 0x1},
	{lang: 0x22d, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x17a, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x2d, script: 0x2, flags: 0x1},
	{lang: 0x46, script: 0x4f, flags: 0x0},
	{lang: 0x2f, script: 0x2, flags: 0x1},
	{lang: 0x31, script: 0x2, flags: 0x1},
	{lang: 0x33, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x35, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x191, script: 0x4f, flags: 0x0},
	{lang: 0x37, script: 0x3, flags: 0x1},
	{lang: 0x8c, script: 0xce, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x190, script: 0x4f, flags: 0x0},
	{lang: 0x1e3, script: 0x4f, flags: 0x0},
	{lang: 0xa, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0xd5, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xd5, script: 0x5, flags: 0x2},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x1b2, script: 0x4f, flags: 0x0},
	{lang: 0x1a4, script: 0x4f, flags: 0x0},
	{lang: 0x1a9, script: 0x1f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x25f, script: 0x4f, flags: 0x0},
	{lang: 0xa5, script: 0x4f, flags: 0x0},
	{lang: 0x3a, script: 0x3, flags: 0x1},
	{lang: 0x3d, script: 0x2, flags: 0x1},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0x1e3, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x1d0, script: 0x4f, flags: 0x0},
	{lang: 0xc4, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x3f, script: 0x2, flags: 0x1},
	{lang: 0x22d, script: 0x1d, flags: 0x0},
	{lang: 0x41, script: 0x2, flags: 0x1},
	{lang: 0x1fe, script: 0x4f, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0x43, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x21f, script: 0x4f, flags: 0x0},
	{lang: 0x1a4, script: 0x4f, flags: 0x0},
	{lang: 0x45, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xfb, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x22a, script: 0x4f, flags: 0x0},
	{lang: 0x1b2, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x1e3, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x47, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x49, script: 0x3, flags: 0x1},
	{lang: 0x4c, script: 0x2, flags: 0x1},
	{lang: 0x256, script: 0x4f, flags: 0x0},
	{lang: 0x1e3, script: 0x4f, flags: 0x0},
	{lang: 0x255, script: 0x4f, flags: 0x0},
	{lang: 0x4e, script: 0x2, flags: 0x1},
	{lang: 0x25d, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x50, script: 0x3, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x26d, script: 0x4f, flags: 0x0},
	{lang: 0x53, script: 0x2, flags: 0x1},
	{lang: 0x23a, script: 0x4f, flags: 0x0},
	{lang: 0x55, script: 0x3, flags: 0x1},
	{lang: 0x23a, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x2a8, script: 0x35, flags: 0x2},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x27d, script: 0x4f, flags: 0x0},
	{lang: 0xfb, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x99, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x282, script: 0x4f, flags: 0x0},
	{lang: 0x3e, script: 0x4f, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x222, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x58, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0x5a, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x228, script: 0x4f, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
}

// likelyRegionList holds lists info associated with likelyRegion.
// Size: 368 bytes, 92 elements
var likelyRegionList = [92]likelyLangScript{
	{lang: 0xa0, script: 0x5, flags: 0x0},
	{lang: 0x255, script: 0x4f, flags: 0x0},
	{lang: 0x22c, script: 0x4f, flags: 0x0},
	{lang: 0x183, script: 0x1d, flags: 0x0},
	{lang: 0xeb, script: 0x8, flags: 0x0},
	{lang: 0x13c, script: 0x4f, flags: 0x0},
	{lang: 0x51, script: 0x4f, flags: 0x0},
	{lang: 0x22d, script: 0x1d, flags: 0x0},
	{lang: 0x8f, script: 0xd0, flags: 0x0},
	{lang: 0x1a9, script: 0x1f, flags: 0x0},
	{lang: 0x2b1, script: 0x32, flags: 0x0},
	{lang: 0x274, script: 0x5, flags: 0x0},
	{lang: 0x2ac, script: 0x4f, flags: 0x0},
	{lang: 0x14e, script: 0xcf, flags: 0x0},
	{lang: 0x96, script: 0x2c, flags: 0x0},
	{lang: 0x260, script: 0x4f, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x10, script: 0x26, flags: 0x0},
	{lang: 0x97, script: 0x4f, flags: 0x0},
	{lang: 0x138, script: 0x5, flags: 0x2},
	{lang: 0x2a8, script: 0x35, flags: 0x2},
	{lang: 0x108, script: 0x28, flags: 0x0},
	{lang: 0x2, script: 0x1d, flags: 0x0},
	{lang: 0x13c, script: 0x4f, flags: 0x0},
	{lang: 0x96, script: 0x2c, flags: 0x0},
	{lang: 0x183, script: 0x1d, flags: 0x0},
	{lang: 0xf0, script: 0x4f, flags: 0x0},
	{lang: 0x190, script: 0x5, flags: 0x0},
	{lang: 0xda, script: 0x1f, flags: 0x0},
	{lang: 0x27c, script: 0x5, flags: 0x0},
	{lang: 0x120, script: 0x67, flags: 0x0},
	{lang: 0xa0, script: 0x5, flags: 0x0},
	{lang: 0x255, script: 0x4f, flags: 0x0},
	{lang: 0x12a, script: 0x43, flags: 0x0},
	{lang: 0x6a, script: 0x5, flags: 0x0},
	{lang: 0x113, script: 0xcf, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x15c, script: 0x4c, flags: 0x0},
	{lang: 0x113, script: 0xcf, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x1f7, script: 0x4f, flags: 0x0},
	{lang: 0x276, script: 0x1d, flags: 0x0},
	{lang: 0x183, script: 0x1d, flags: 0x0},
	{lang: 0x22c, script: 0x4f, flags: 0x0},
	{lang: 0x19b, script: 0x67, flags: 0x0},
	{lang: 0x10b, script: 0x4f, flags: 0x0},
	{lang: 0x185, script: 0x1d, flags: 0x0},
	{lang: 0x126, script: 0x5, flags: 0x0},
	{lang: 0x2b1, script: 0x33, flags: 0x0},
	{lang: 0x1e3, script: 0x4f, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x179, script: 0x4f, flags: 0x0},
	{lang: 0x27c, script: 0x5, flags: 0x0},
	{lang: 0x3d, script: 0x1f, flags: 0x0},
	{lang: 0x27c, script: 0x5, flags: 0x0},
	{lang: 0x27c, script: 0x5, flags: 0x0},
	{lang: 0x55, script: 0x1f, flags: 0x0},
	{lang: 0x1db, script: 0x4f, flags: 0x0},
	{lang: 0x2e, script: 0x1d, flags: 0x0},
	{lang: 0x1f7, script: 0x4f, flags: 0x0},
	{lang: 0x36, script: 0x1d, flags: 0x0},
	{lang: 0x1fb, script: 0x1d, flags: 0x0},
	{lang: 0x136, script: 0x4f, flags: 0x0},
	{lang: 0x239, script: 0x4f, flags: 0x0},
	{lang: 0x2a8, script: 0x35, flags: 0x0},
	{lang: 0x21d, script: 0x4f, flags: 0x0},
	{lang: 0x276, script: 0x1d, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x24e, script: 0xcf, flags: 0x0},
	{lang: 0x178, script: 0x5, flags: 0x0},
	{lang: 0x187, script: 0x67, flags: 0x0},
	{lang: 0x24d, script: 0x1d, flags: 0x0},
	{lang: 0xa0, script: 0x5, flags: 0x0},
	{lang: 0x14, script: 0x5, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x260, script: 0x4f, flags: 0x0},
	{lang: 0x10f, script: 0x1d, flags: 0x0},
	{lang: 0x38, script: 0x2c, flags: 0x0},
	{lang: 0x2b1, script: 0x33, flags: 0x0},
	{lang: 0x262, script: 0x4f, flags: 0x0},
	{lang: 0x276, script: 0x1d, flags: 0x0},
	{lang: 0x2a8, script: 0x35, flags: 0x0},
	{lang: 0x1db, script: 0x4f, flags: 0x0},
	{lang: 0x22c, script: 0x4f, flags: 0x0},
	{lang: 0x22d, script: 0x1d, flags: 0x0},
	{lang: 0xaa, script: 0x4f, flags: 0x0},
	{lang: 0x23b, script: 0x5, flags: 0x0},
}

type likelyTag struct {
	lang   uint16
	region uint16
	script uint8
}

// Size: 192 bytes, 32 elements
var likelyRegionGroup = [32]likelyTag{
	{lang: 0x0, region: 0x0, script: 0x0},
	{lang: 0x97, region: 0xd4, script: 0x4f},
	{lang: 0x97, region: 0x132, script: 0x4f},
	{lang: 0x1e3, region: 0x40, script: 0x4f},
	{lang: 0x97, region: 0x2e, script: 0x4f},
	{lang: 0x97, region: 0xd4, script: 0x4f},
	{lang: 0x99, region: 0xcd, script: 0x4f},
	{lang: 0x23a, region: 0x12d, script: 0x4f},
	{lang: 0x14, region: 0x6a, script: 0x5},
	{lang: 0x23a, region: 0x4a, script: 0x4f},
	{lang: 0x97, region: 0x15e, script: 0x4f},
	{lang: 0x97, region: 0x132, script: 0x4f},
	{lang: 0x97, region: 0x132, script: 0x4f},
	{lang: 0x99, region: 0x58, script: 0x4f},
	{lang: 0x2b1, region: 0x52, script: 0x32},
	{lang: 0xda, region: 0x97, script: 0x1f},
	{lang: 0xf0, region: 0x93, script: 0x4f},
	{lang: 0xfb, region: 0x9c, script: 0x4f},
	{lang: 0x97, region: 0x2e, script: 0x4f},
	{lang: 0x97, region: 0xe4, script: 0x4f},
	{lang: 0x97, region: 0x88, script: 0x4f},
	{lang: 0x222, region: 0x13f, script: 0x4f},
	{lang: 0x2b1, region: 0x52, script: 0x32},
	{lang: 0x27d, region: 0x134, script: 0x4f},
	{lang: 0x14, region: 0x106, script: 0x5},
	{lang: 0x1fb, region: 0x104, script: 0x1d},
	{lang: 0x1fb, region: 0x104, script: 0x1d},
	{lang: 0x97, region: 0x79, script: 0x4f},
	{lang: 0x82, region: 0x5f, script: 0x4f},
	{lang: 0x99, region: 0x1e, script: 0x4f},
	{lang: 0x97, region: 0x98, script: 0x4f},
	{lang: 0x97, region: 0x79, script: 0x4f},
}

type mutualIntelligibility struct {
	want   uint16
	have   uint16
	conf   uint8
	oneway bool
}

type scriptIntelligibility struct {
	lang uint16
	want uint8
	have uint8
	conf uint8
}

// matchLang holds pairs of langIDs of base languages that are typically
// mutually intelligible. Each pair is associated with a confidence and
// whether the intelligibility goes one or both ways.
// Size: 702 bytes, 117 elements
var matchLang = [117]mutualIntelligibility{
	{want: 0x1b6, have: 0x1a4, conf: 0x2, oneway: false},
	{want: 0xe6, have: 0x51, conf: 0x2, oneway: false},
	{want: 0x218, have: 0x51, conf: 0x2, oneway: false},
	{want: 0x22d, have: 0x51, conf: 0x2, oneway: false},
	{want: 0x218, have: 0xe6, conf: 0x2, oneway: false},
	{want: 0x22d, have: 0xe6, conf: 0x2, oneway: false},
	{want: 0x218, have: 0x22d, conf: 0x2, oneway: false},
	{want: 0x233, have: 0x1, conf: 0x2, oneway: false},
	{want: 0xcc, have: 0x82, conf: 0x2, oneway: true},
	{want: 0x14b, have: 0x82, conf: 0x2, oneway: true},
	{want: 0x13c, have: 0x6c, conf: 0x2, oneway: false},
	{want: 0x7d, have: 0x1b6, conf: 0x2, oneway: false},
	{want: 0x7d, have: 0x1a4, conf: 0x2, oneway: false},
	{want: 0x6c, have: 0x14, conf: 0x2, oneway: true},
	{want: 0x6d, have: 0xaa, conf: 0x2, oneway: true},
	{want: 0x75, have: 0xaa, conf: 0x2, oneway: true},
	{want: 0x7c, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x91, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x98, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x9b, have: 0xa4, conf: 0x2, oneway: true},
	{want: 0x9d, have: 0x99, conf: 0x2, oneway: true},
	{want: 0xa8, have: 0x7d, conf: 0x2, oneway: true},
	{want: 0xb3, have: 0x1b2, conf: 0x2, oneway: true},
	{want: 0xb4, have: 0x97, conf: 0x2, oneway: true},
	{want: 0xb5, have: 0x97, conf: 0x2, oneway: true},
	{want: 0xbc, have: 0x97, conf: 0x2, oneway: true},
	{want: 0xc2, have: 0x99, conf: 0x2, oneway: true},
	{want: 0xc4, have: 0x99, conf: 0x2, oneway: true},
	{want: 0xcd, have: 0xda, conf: 0x2, oneway: true},
	{want: 0xd5, have: 0x97, conf: 0x2, oneway: true},
	{want: 0xd7, have: 0x97, conf: 0x2, oneway: true},
	{want: 0xe9, have: 0xaa, conf: 0x2, oneway: true},
	{want: 0xeb, have: 0x1fb, conf: 0x2, oneway: true},
	{want: 0xed, have: 0x97, conf: 0x2, oneway: true},
	{want: 0xf2, have: 0x97, conf: 0x2, oneway: true},
	{want: 0xfa, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x106, have: 0xf0, conf: 0x2, oneway: true},
	{want: 0x108, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x119, have: 0xaa, conf: 0x2, oneway: true},
	{want: 0x126, have: 0x1fb, conf: 0x2, oneway: true},
	{want: 0x12a, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x12c, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x134, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x13c, have: 0x260, conf: 0x2, oneway: true},
	{want: 0x144, have: 0x1fb, conf: 0x2, oneway: true},
	{want: 0x145, have: 0xfb, conf: 0x2, oneway: true},
	{want: 0x151, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x15b, have: 0xaa, conf: 0x2, oneway: true},
	{want: 0x15c, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x15e, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x163, have: 0xaa, conf: 0x2, oneway: true},
	{want: 0x179, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x17a, have: 0xaa, conf: 0x2, oneway: true},
	{want: 0x180, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x183, have: 0x36, conf: 0x2, oneway: true},
	{want: 0x184, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x185, have: 0x1fb, conf: 0x2, oneway: true},
	{want: 0x18c, have: 0xda, conf: 0x2, oneway: true},
	{want: 0x190, have: 0xf0, conf: 0x2, oneway: true},
	{want: 0x191, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x19b, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x1a9, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x1b4, have: 0x1a4, conf: 0x2, oneway: false},
	{want: 0x1b4, have: 0x1b6, conf: 0x2, oneway: true},
	{want: 0x1bd, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x1c1, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x1c3, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x1c5, have: 0xaa, conf: 0x2, oneway: true},
	{want: 0x1c7, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x1c8, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x1cb, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x1d2, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x1e2, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x1e5, have: 0x99, conf: 0x2, oneway: true},
	{want: 0x1f0, have: 0x82, conf: 0x2, oneway: true},
	{want: 0x1f5, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x1fe, have: 0xaa, conf: 0x2, oneway: true},
	{want: 0x201, have: 0xda, conf: 0x2, oneway: true},
	{want: 0x20e, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x21b, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x228, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x22a, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x22c, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x234, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x236, have: 0xf0, conf: 0x2, oneway: true},
	{want: 0x23a, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x242, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x249, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x24d, have: 0x1fb, conf: 0x2, oneway: true},
	{want: 0x252, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x255, have: 0x1fb, conf: 0x2, oneway: true},
	{want: 0x3607, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x25c, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x25d, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x268, have: 0x1fb, conf: 0x2, oneway: true},
	{want: 0x26c, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x274, have: 0x2b1, conf: 0x2, oneway: true},
	{want: 0x27c, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x27d, have: 0x1fb, conf: 0x2, oneway: true},
	{want: 0x293, have: 0xaa, conf: 0x2, oneway: true},
	{want: 0x298, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x2a8, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x2a9, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x2b3, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x5, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x2, have: 0x1fb, conf: 0x2, oneway: true},
	{want: 0xa, have: 0x1b2, conf: 0x2, oneway: true},
	{want: 0xc, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x21, have: 0x99, conf: 0x2, oneway: true},
	{want: 0x22, have: 0x1fb, conf: 0x2, oneway: true},
	{want: 0x2e, have: 0x1fb, conf: 0x2, oneway: true},
	{want: 0x2f, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x39, have: 0xda, conf: 0x2, oneway: true},
	{want: 0x48, have: 0x97, conf: 0x2, oneway: true},
	{want: 0x4d, have: 0xaa, conf: 0x2, oneway: true},
	{want: 0x62, have: 0xa5, conf: 0x2, oneway: true},
	{want: 0x69, have: 0x97, conf: 0x2, oneway: true},
}

// matchScript holds pairs of scriptIDs where readers of one script
// can typically also read the other. Each is associated with a confidence.
// Size: 24 bytes, 4 elements
var matchScript = [4]scriptIntelligibility{
	{lang: 0x22d, want: 0x4f, have: 0x1d, conf: 0x2},
	{lang: 0x22d, want: 0x1d, have: 0x4f, conf: 0x2},
	{lang: 0x0, want: 0x32, have: 0x33, conf: 0x1},
	{lang: 0x0, want: 0x33, have: 0x32, conf: 0x1},
}

// Size: 128 bytes, 32 elements
var regionContainment = [32]uint32{
	0xffffffff, 0x000007a2, 0x00003044, 0x00000008,
	0x403c0010, 0x00000020, 0x00000040, 0x00000080,
	0x00000100, 0x00000200, 0x00000400, 0x2000384c,
	0x00001000, 0x00002000, 0x00004000, 0x00008000,
	0x00010000, 0x00020000, 0x00040000, 0x00080000,
	0x00100000, 0x00200000, 0x01c1c000, 0x00800000,
	0x01000000, 0x9e020000, 0x04000000, 0x08000000,
	0x10000000, 0x20002048, 0x40000000, 0x80000000,
}

// regionInclusion maps region identifiers to sets of regions in regionInclusionBits,
// where each set holds all groupings that are directly connected in a region
// containment graph.
// Size: 355 bytes, 355 elements
var regionInclusion = [355]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06,
	0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e,
	0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
	0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x20,
	0x21, 0x22, 0x23, 0x24, 0x25, 0x25, 0x22, 0x23,
	0x25, 0x26, 0x21, 0x27, 0x28, 0x29, 0x2a, 0x25,
	0x2b, 0x23, 0x22, 0x25, 0x24, 0x29, 0x2c, 0x2d,
	0x23, 0x2e, 0x2c, 0x25, 0x2f, 0x30, 0x27, 0x25,
	// Entry 40 - 7F
	0x27, 0x25, 0x24, 0x30, 0x21, 0x31, 0x32, 0x33,
	0x2f, 0x21, 0x26, 0x26, 0x26, 0x34, 0x2c, 0x28,
	0x27, 0x26, 0x35, 0x27, 0x21, 0x33, 0x22, 0x20,
	0x25, 0x2c, 0x25, 0x21, 0x36, 0x2d, 0x34, 0x29,
	0x21, 0x2e, 0x37, 0x25, 0x25, 0x20, 0x38, 0x38,
	0x27, 0x37, 0x38, 0x38, 0x2e, 0x39, 0x2e, 0x1f,
	0x37, 0x3a, 0x27, 0x3b, 0x2b, 0x20, 0x29, 0x34,
	0x26, 0x37, 0x25, 0x23, 0x27, 0x2b, 0x2c, 0x22,
	// Entry 80 - BF
	0x2f, 0x2c, 0x2c, 0x25, 0x26, 0x39, 0x21, 0x33,
	0x3b, 0x2c, 0x27, 0x35, 0x21, 0x33, 0x39, 0x25,
	0x2d, 0x20, 0x38, 0x30, 0x37, 0x23, 0x2b, 0x24,
	0x21, 0x23, 0x24, 0x2b, 0x39, 0x2b, 0x25, 0x23,
	0x35, 0x20, 0x2e, 0x3c, 0x30, 0x3b, 0x2e, 0x25,
	0x35, 0x35, 0x23, 0x25, 0x3c, 0x30, 0x23, 0x25,
	0x34, 0x24, 0x2c, 0x31, 0x37, 0x29, 0x37, 0x38,
	0x38, 0x34, 0x32, 0x22, 0x25, 0x2e, 0x3b, 0x20,
	// Entry C0 - FF
	0x22, 0x2c, 0x30, 0x35, 0x35, 0x3b, 0x25, 0x2c,
	0x25, 0x39, 0x2e, 0x24, 0x2e, 0x33, 0x30, 0x2e,
	0x31, 0x3a, 0x2c, 0x2a, 0x2c, 0x20, 0x33, 0x29,
	0x2b, 0x24, 0x20, 0x3b, 0x23, 0x28, 0x2a, 0x23,
	0x33, 0x20, 0x27, 0x28, 0x3a, 0x30, 0x24, 0x2d,
	0x2f, 0x28, 0x25, 0x23, 0x39, 0x20, 0x3b, 0x27,
	0x20, 0x23, 0x20, 0x20, 0x1e, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x3d, 0x20, 0x20, 0x20, 0x20, 0x20,
	// Entry 100 - 13F
	0x2e, 0x20, 0x2d, 0x22, 0x32, 0x2e, 0x23, 0x3a,
	0x2e, 0x38, 0x37, 0x30, 0x2c, 0x39, 0x2b, 0x2d,
	0x2c, 0x22, 0x2c, 0x2e, 0x27, 0x38, 0x26, 0x32,
	0x33, 0x25, 0x23, 0x31, 0x21, 0x25, 0x26, 0x21,
	0x2c, 0x30, 0x3c, 0x28, 0x30, 0x3c, 0x38, 0x28,
	0x30, 0x23, 0x25, 0x28, 0x35, 0x2e, 0x32, 0x2e,
	0x20, 0x21, 0x2f, 0x27, 0x3c, 0x22, 0x25, 0x20,
	0x27, 0x25, 0x25, 0x30, 0x3a, 0x28, 0x20, 0x28,
	// Entry 140 - 17F
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x23, 0x23, 0x2e, 0x22, 0x31, 0x2e,
	0x26, 0x2e, 0x20,
}

// regionInclusionBits is an array of bit vectors where every vector represents
// a set of region groupings.  These sets are used to compute the distance
// between two regions for the purpose of language matching.
// Size: 300 bytes, 75 elements
var regionInclusionBits = [75]uint32{
	// Entry 0 - 1F
	0x02400813, 0x000007a3, 0x00003844, 0x20000808,
	0x403c0011, 0x00000022, 0x20000844, 0x00000082,
	0x00000102, 0x00000202, 0x00000402, 0x2000384d,
	0x00001804, 0x20002804, 0x00404000, 0x00408000,
	0x00410000, 0x02020000, 0x00040010, 0x00080010,
	0x00100010, 0x00200010, 0x01c1c001, 0x00c00000,
	0x01400000, 0x9e020001, 0x06000000, 0x0a000000,
	0x12000000, 0x20002848, 0x40000010, 0x82000000,
	// Entry 20 - 3F
	0x00000001, 0x40000000, 0x00020000, 0x01000000,
	0x00008000, 0x00002000, 0x00000200, 0x00000008,
	0x00200000, 0x90000000, 0x00040000, 0x08000000,
	0x00000020, 0x84000000, 0x00000080, 0x00001000,
	0x00010000, 0x00000400, 0x04000000, 0x00000040,
	0x10000000, 0x00004000, 0x81000000, 0x88000000,
	0x00000100, 0x80020000, 0x00080000, 0x00100000,
	0x00800000, 0x02000000, 0xffffffff, 0x02400fb3,
	// Entry 40 - 5F
	0x427c0813, 0x2240385f, 0x03c1c813, 0x9e420813,
	0x92000000, 0x86000000, 0x83400000, 0x8a000000,
	0x82020000, 0x9fc3c001, 0x9fc3c813,
}

// regionInclusionNext marks, for each entry in regionInclusionBits, the set of
// all groups that are reachable from the groups set in the respective entry.
// Size: 75 bytes, 75 elements
var regionInclusionNext = [75]uint8{
	// Entry 0 - 3F
	0x3e, 0x3f, 0x0b, 0x0b, 0x40, 0x01, 0x0b, 0x01,
	0x01, 0x01, 0x01, 0x41, 0x0b, 0x0b, 0x16, 0x16,
	0x16, 0x19, 0x04, 0x04, 0x04, 0x04, 0x42, 0x16,
	0x16, 0x43, 0x19, 0x19, 0x19, 0x0b, 0x04, 0x19,
	0x00, 0x1e, 0x11, 0x18, 0x0f, 0x0d, 0x09, 0x03,
	0x15, 0x44, 0x12, 0x1b, 0x05, 0x45, 0x07, 0x0c,
	0x10, 0x0a, 0x1a, 0x06, 0x1c, 0x0e, 0x46, 0x47,
	0x08, 0x48, 0x13, 0x14, 0x17, 0x19, 0x3e, 0x3e,
	// Entry 40 - 7F
	0x3e, 0x3e, 0x3e, 0x3e, 0x19, 0x19, 0x49, 0x19,
	0x19, 0x4a, 0x3e,
}

type parentRel struct {
	lang       uint16
	script     uint8
	maxScript  uint8
	toRegion   uint16
	fromRegion []uint16
}

// Size: 352 bytes, 4 elements
var parents = [4]parentRel{
	{lang: 0x97, script: 0x0, maxScript: 0x4f, toRegion: 0x1, fromRegion: []uint16{0x1a, 0x24, 0x25, 0x2e, 0x33, 0x35, 0x3c, 0x41, 0x45, 0x47, 0x48, 0x49, 0x4f, 0x51, 0x5b, 0x60, 0x63, 0x6c, 0x71, 0x72, 0x73, 0x79, 0x7a, 0x7d, 0x7e, 0x7f, 0x81, 0x8a, 0x8b, 0x94, 0x96, 0x97, 0x98, 0x9d, 0x9e, 0xa2, 0xa5, 0xa7, 0xab, 0xaf, 0xb2, 0xb3, 0xbd, 0xc4, 0xc8, 0xc9, 0xca, 0xcc, 0xce, 0xd0, 0xd3, 0xd4, 0xdb, 0xdd, 0xde, 0xe4, 0xe5, 0xe6, 0xe9, 0xee, 0x105, 0x107, 0x108, 0x109, 0x10b, 0x10c, 0x110, 0x115, 0x119, 0x11b, 0x11d, 0x123, 0x127, 0x12a, 0x12b, 0x12d, 0x12f, 0x136, 0x139, 0x13c, 0x13f, 0x15e, 0x15f, 0x161}},
	{lang: 0x99, script: 0x0, maxScript: 0x4f, toRegion: 0x1e, fromRegion: []uint16{0x2b, 0x3e, 0x50, 0x53, 0x55, 0x58, 0x64, 0x68, 0x87, 0x8d, 0xcd, 0xd6, 0xe0, 0xe2, 0xea, 0xef, 0x118, 0x132, 0x133, 0x138}},
	{lang: 0x1e3, script: 0x0, maxScript: 0x4f, toRegion: 0xec, fromRegion: []uint16{0x29, 0x59, 0x89, 0xc4, 0xcf, 0x116, 0x124}},
	{lang: 0x2b1, script: 0x33, maxScript: 0x33, toRegion: 0x8b, fromRegion: []uint16{0xc4}},
}

// Total table size 20955 bytes (20KiB); checksum: 68810BB6
