#ifndef GNM_CONF_PRIV_H
#define GNM_CONF_PRIV_H

/*
 *  Note: This file must stay synchronized with the corresponding schema file!
 *
 *        This file should only be included into gnumeric-gconf.c  and
 *        dialogs/dialog-preferences.c
 */


/*
 *  schemas/gnumeric-dialogs.schemas
 */
#define FUNCTION_SELECT_GCONF_RECENT "/apps/gnumeric/functionselector/recentfunctions"
#define FUNCTION_SELECT_GCONF_NUM_OF_RECENT "/apps/gnumeric/functionselector/num-of-recent"

#define CONF_DEFAULT_FONT_DIR	"/apps/gnumeric/core/defaultfont/"
#define CONF_DEFAULT_FONT_NAME	  CONF_DEFAULT_FONT_DIR "name"
#define CONF_DEFAULT_FONT_SIZE	  CONF_DEFAULT_FONT_DIR "size"
#define CONF_DEFAULT_FONT_BOLD	  CONF_DEFAULT_FONT_DIR "bold"
#define CONF_DEFAULT_FONT_ITALIC  CONF_DEFAULT_FONT_DIR "italic"

#define PLUGIN_GCONF_DIRECTORY "/apps/gnumeric/plugins"
#define PLUGIN_GCONF_ACTIVATE_NEW PLUGIN_GCONF_DIRECTORY "/activate-new"
#define PLUGIN_GCONF_ACTIVE PLUGIN_GCONF_DIRECTORY "/active"
#define PLUGIN_GCONF_FILE_STATES PLUGIN_GCONF_DIRECTORY "/file-states"
#define PLUGIN_GCONF_EXTRA_DIRS PLUGIN_GCONF_DIRECTORY "/extra-dirs"

#define AUTOFORMAT_GCONF_DIRECTORY "/apps/gnumeric/autoformat"
#define AUTOFORMAT_GCONF_EXTRA_DIRS AUTOFORMAT_GCONF_DIRECTORY "/extra-dirs"
#define AUTOFORMAT_GCONF_SYS_DIR AUTOFORMAT_GCONF_DIRECTORY "/sys-dir"
#define AUTOFORMAT_GCONF_USR_DIR AUTOFORMAT_GCONF_DIRECTORY "/usr-dir"

#define PRINTSETUP_GCONF_DIRECTORY "/apps/gnumeric/printsetup"
#define PRINTSETUP_GCONF_ALL_SHEETS PRINTSETUP_GCONF_DIRECTORY "/all-sheets"
#define PRINTSETUP_GCONF_PRINTER_CONFIG PRINTSETUP_GCONF_DIRECTORY "/printer-config"
#define PRINTSETUP_GCONF_HEADER PRINTSETUP_GCONF_DIRECTORY "/header"
#define PRINTSETUP_GCONF_FOOTER PRINTSETUP_GCONF_DIRECTORY "/footer"
#define PRINTSETUP_GCONF_HF_FONT_NAME PRINTSETUP_GCONF_DIRECTORY "/hf-font-name"
#define PRINTSETUP_GCONF_HF_FONT_SIZE PRINTSETUP_GCONF_DIRECTORY "/hf-font-size"
#define PRINTSETUP_GCONF_HF_FONT_BOLD PRINTSETUP_GCONF_DIRECTORY "/hf-font-bold"
#define PRINTSETUP_GCONF_HF_FONT_ITALIC PRINTSETUP_GCONF_DIRECTORY "/hf-font-italic"
#define PRINTSETUP_GCONF_CENTER_HORIZONTALLY PRINTSETUP_GCONF_DIRECTORY "/center-horizontally"
#define PRINTSETUP_GCONF_CENTER_VERTICALLY PRINTSETUP_GCONF_DIRECTORY "/center-vertically"
#define PRINTSETUP_GCONF_PRINT_GRID_LINES PRINTSETUP_GCONF_DIRECTORY "/print-grid-lines"
#define PRINTSETUP_GCONF_EVEN_IF_ONLY_STYLES PRINTSETUP_GCONF_DIRECTORY "/print-even-if-only-styles"
#define PRINTSETUP_GCONF_PRINT_BLACK_AND_WHITE PRINTSETUP_GCONF_DIRECTORY "/print-black-n-white"
#define PRINTSETUP_GCONF_PRINT_TITLES PRINTSETUP_GCONF_DIRECTORY "/print-titles"
#define PRINTSETUP_GCONF_RIGHT_THEN_DOWN PRINTSETUP_GCONF_DIRECTORY "/right-then-down"
#define PRINTSETUP_GCONF_SCALE_PERCENTAGE PRINTSETUP_GCONF_DIRECTORY "/scale-percentage"
#define PRINTSETUP_GCONF_SCALE_PERCENTAGE_VALUE PRINTSETUP_GCONF_DIRECTORY "/scale-percentage-value"
#define PRINTSETUP_GCONF_SCALE_WIDTH PRINTSETUP_GCONF_DIRECTORY "/scale-width"
#define PRINTSETUP_GCONF_SCALE_HEIGHT PRINTSETUP_GCONF_DIRECTORY "/scale-height"
#define PRINTSETUP_GCONF_REPEAT_TOP PRINTSETUP_GCONF_DIRECTORY "/repeat-top"
#define PRINTSETUP_GCONF_REPEAT_LEFT PRINTSETUP_GCONF_DIRECTORY "/repeat-left"
#define PRINTSETUP_GCONF_MARGIN_TOP PRINTSETUP_GCONF_DIRECTORY "/margin-top"
#define PRINTSETUP_GCONF_MARGIN_BOTTOM PRINTSETUP_GCONF_DIRECTORY "/margin-bottom"
#define PRINTSETUP_GCONF_HEADER_FORMAT_LEFT PRINTSETUP_GCONF_DIRECTORY "/hf-left"
#define PRINTSETUP_GCONF_HEADER_FORMAT_MIDDLE PRINTSETUP_GCONF_DIRECTORY "/hf-middle"
#define PRINTSETUP_GCONF_HEADER_FORMAT_RIGHT PRINTSETUP_GCONF_DIRECTORY "/hf-right"

#define DIALOGS_GCONF_DIRECTORY "/apps/gnumeric/dialogs"
#define DIALOGS_GCONF_UNFOCUSED_RS DIALOGS_GCONF_DIRECTORY "/rs/unfocused"

/*
 *  schemas/gnumeric-general.schemas
 */

#define GNM_CONF_UNDO_DIRECTORY "/apps/gnumeric/undo"
#define GNM_CONF_UNDO_SIZE GNM_CONF_UNDO_DIRECTORY "/size"
#define GNM_CONF_UNDO_MAXNUM GNM_CONF_UNDO_DIRECTORY "/maxnum"
#define GNM_CONF_UNDO_SHOW_SHEET_NAME GNM_CONF_UNDO_DIRECTORY "/show_sheet_name"
#define GNM_CONF_UNDO_MAX_DESCRIPTOR_WIDTH GNM_CONF_UNDO_DIRECTORY "/max_descriptor_width"

#define GNM_CONF_FONT_DIRECTORY "/apps/gnumeric/core/defaultfont"
#define GNM_CONF_FONT_NAME GNM_CONF_FONT_DIRECTORY "/name"
#define GNM_CONF_FONT_SIZE GNM_CONF_FONT_DIRECTORY "/size"
#define GNM_CONF_FONT_BOLD GNM_CONF_FONT_DIRECTORY "/bold"
#define GNM_CONF_FONT_ITALIC GNM_CONF_FONT_DIRECTORY "/italic"

#define GNM_CONF_FILE_DIRECTORY "/apps/gnumeric/core/file"
#define GNM_CONF_FILE_HISTORY_N GNM_CONF_FILE_DIRECTORY "/history/n"
#define GNM_CONF_FILE_HISTORY_FILES GNM_CONF_FILE_DIRECTORY "/history/files"
#define GNM_CONF_FILE_OVERWRITE_DEFAULT GNM_CONF_FILE_DIRECTORY "/save/def-overwrite"
#define GNM_CONF_FILE_SINGLE_SHEET_SAVE GNM_CONF_FILE_DIRECTORY "/save/single_sheet"

#define GNM_CONF_WORKBOOK_NSHEETS "/apps/gnumeric/core/workbook/n-sheet"

#define GNM_CONF_GUI_DIRECTORY "/apps/gnumeric/core/gui"
#define GNM_CONF_GUI_RES_H GNM_CONF_GUI_DIRECTORY "/screen/horizontaldpi"
#define GNM_CONF_GUI_RES_V GNM_CONF_GUI_DIRECTORY "/screen/verticaldpi"
#define GNM_CONF_GUI_ED_AUTOCOMPLETE GNM_CONF_GUI_DIRECTORY "/editing/autocomplete"
#define GNM_CONF_GUI_ED_TRANSITION_KEYS GNM_CONF_GUI_DIRECTORY "/editing/transitionkeys"
#define GNM_CONF_GUI_ED_LIVESCROLLING GNM_CONF_GUI_DIRECTORY "/editing/livescrolling"
#define GNM_CONF_GUI_ED_RECALC_LAG GNM_CONF_GUI_DIRECTORY "/editing/recalclag"
#define GNM_CONF_GUI_WINDOW_X GNM_CONF_GUI_DIRECTORY "/window/x"
#define GNM_CONF_GUI_WINDOW_Y GNM_CONF_GUI_DIRECTORY "/window/y"
#define GNM_CONF_GUI_ZOOM GNM_CONF_GUI_DIRECTORY "/window/zoom"

#define GNM_CONF_XML_COMPRESSION "/apps/gnumeric/core/xml/compression-level"

#define GNM_CONF_SORT_DIRECTORY "/apps/gnumeric/core/sort"
#define GNM_CONF_SORT_DEFAULT_BY_CASE GNM_CONF_SORT_DIRECTORY "/default/by-case"
#define GNM_CONF_SORT_DEFAULT_RETAIN_FORM GNM_CONF_SORT_DIRECTORY "/default/retain-formats"
#define GNM_CONF_SORT_DEFAULT_ASCENDING GNM_CONF_SORT_DIRECTORY "/default/ascending"
#define GNM_CONF_SORT_DIALOG_MAX_INITIAL GNM_CONF_SORT_DIRECTORY "/dialog/max-initial-clauses"

#define GNM_CONF_CUTANDPASTE_DIRECTORY "/apps/gnumeric/cut-and-paste"
#define GNM_CONF_CUTANDPASTE_PREFER_CLIPBOARD GNM_CONF_CUTANDPASTE_DIRECTORY "/prefer-clipboard"

/*
 *  schemas/gnumeric-plugins.schemas
 */

#define PLUGIN_GCONF_LATEX "/apps/gnumeric/plugin/latex"
#define PLUGIN_GCONF_LATEX_USE_UTF8 PLUGIN_GCONF_LATEX "/use-utf8"

#endif /* GNM_CONF_PRIV_H */
