/* contacts-store.c generated by valac 0.28.0, the Vala compiler
 * generated from contacts-store.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <telepathy-glib/telepathy-glib.h>
#include <folks/folks.h>
#include <glib/gstdio.h>
#include <gio/gio.h>


#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
typedef struct _ContactsStorePrivate ContactsStorePrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ContactsContactPrivate ContactsContactPrivate;
typedef struct _Block35Data Block35Data;
typedef struct _ContactsStoreFindContactData ContactsStoreFindContactData;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _ContactsStoreCheckCallCapabilitiesData ContactsStoreCheckCallCapabilitiesData;
typedef struct _ContactsStoreCheckAccountCapsData ContactsStoreCheckAccountCapsData;

struct _ContactsStore {
	GObject parent_instance;
	ContactsStorePrivate * priv;
	GeeHashMap* calling_accounts;
	GeeHashMultiMap* dont_suggest_link;
};

struct _ContactsStoreClass {
	GObjectClass parent_class;
};

struct _ContactsStorePrivate {
	FolksIndividualAggregator* _aggregator;
	FolksBackendStore* _backend_store;
	GeeArrayList* contacts;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_main;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
	FolksPersona* fake_persona;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

typedef gboolean (*ContactsStoreContactMatcher) (ContactsContact* c, void* user_data);
struct _Block35Data {
	int _ref_count_;
	ContactsStore* self;
	ContactsContact* matched;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	ContactsStoreContactMatcher matcher;
	gpointer matcher_target;
	gpointer _async_data_;
};

struct _ContactsStoreFindContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ContactsStore* self;
	ContactsStoreContactMatcher matcher;
	gpointer matcher_target;
	ContactsContact* result;
	Block35Data* _data35_;
	ContactsStoreContactMatcher _tmp0_;
	void* _tmp0__target;
	GeeArrayList* _c_list;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _c_size;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _c_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	ContactsContact* c;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	ContactsStoreContactMatcher _tmp12_;
	void* _tmp12__target;
	ContactsContact* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gulong id1;
	gulong id2;
	gulong id3;
	gulong _tmp17_;
	gulong _tmp18_;
	gulong _tmp19_;
	gulong _tmp20_;
	gulong _tmp21_;
	gulong _tmp22_;
	ContactsContact* _tmp23_;
	ContactsContact* _tmp24_;
};

struct _ContactsStoreCheckCallCapabilitiesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ContactsStore* self;
	GeeHashMap* _tmp0_;
	TpAccountManager* account_manager;
	TpAccountManager* _tmp1_;
	GList* _tmp2_;
	GList* account_collection;
	GList* account_it;
	TpAccount* account;
	TpAccount* _tmp3_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError * _inner_error_;
};

struct _ContactsStoreCheckAccountCapsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ContactsStore* self;
	TpAccount* account;
	GQuark addressing;
	GQuark _tmp0_;
	TpAccount* _tmp1_;
	GQuark _tmp2_;
	gboolean _tmp3_;
	GQuark* features;
	GQuark _tmp4_;
	GQuark* _tmp5_;
	gint features_length1;
	gint _features_size_;
	TpAccount* _tmp6_;
	GQuark* _tmp7_;
	gint _tmp7__length1;
	GError* e;
	GError* _tmp8_;
	const gchar* _tmp9_;
	TpAccount* _tmp10_;
	GQuark _tmp11_;
	gboolean _tmp12_;
	gchar* k;
	TpAccount* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	TpAccount* _tmp17_;
	gboolean _tmp18_;
	TpAccount* _tmp19_;
	gboolean _tmp20_;
	GeeHashMap* _tmp21_;
	const gchar* _tmp22_;
	TpAccount* _tmp23_;
	GeeHashMap* _tmp24_;
	const gchar* _tmp25_;
	GError * _inner_error_;
};


static gpointer contacts_store_parent_class = NULL;

GType contacts_store_get_type (void) G_GNUC_CONST;
GType contacts_contact_get_type (void) G_GNUC_CONST;
#define CONTACTS_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_STORE, ContactsStorePrivate))
enum  {
	CONTACTS_STORE_DUMMY_PROPERTY,
	CONTACTS_STORE_AGGREGATOR,
	CONTACTS_STORE_BACKEND_STORE,
	CONTACTS_STORE_CAN_CALL,
	CONTACTS_STORE_IS_QUIESCENT,
	CONTACTS_STORE_IS_PREPARED
};
void contacts_store_refresh (ContactsStore* self);
void contacts_contact_queue_changed (ContactsContact* self, gboolean is_persona_change);
static gboolean contacts_store_individual_can_replace_at_split (ContactsStore* self, FolksIndividual* new_individual);
static gboolean contacts_store_individual_should_replace_at_join (ContactsStore* self, FolksIndividual* old_individual);
ContactsContact* contacts_contact_from_individual (FolksIndividual* i);
static void contacts_store_read_dont_suggest_db (ContactsStore* self);
static void contacts_store_write_dont_suggest_db (ContactsStore* self);
gboolean contacts_store_may_suggest_link (ContactsStore* self, ContactsContact* a, ContactsContact* b);
void contacts_store_add_no_suggest_link (ContactsStore* self, ContactsContact* a, ContactsContact* b);
GeeList* contacts_contact_get_personas_for_display (ContactsContact* self);
static void contacts_store_contact_changed_cb (ContactsStore* self, ContactsContact* c);
static void contacts_store_find_contact_data_free (gpointer _data);
void contacts_store_find_contact (ContactsStore* self, ContactsStoreContactMatcher matcher, void* matcher_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
ContactsContact* contacts_store_find_contact_finish (ContactsStore* self, GAsyncResult* _res_);
static gboolean contacts_store_find_contact_co (ContactsStoreFindContactData* _data_);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
gboolean contacts_store_get_is_quiescent (ContactsStore* self);
static gboolean _contacts_store_find_contact_co_gsource_func (gpointer self);
static void __lambda17_ (Block35Data* _data35_, ContactsContact* c);
static void ___lambda17__contacts_store_changed (ContactsStore* _sender, ContactsContact* c, gpointer self);
static void __lambda18_ (Block35Data* _data35_, ContactsContact* c);
static void ___lambda18__contacts_store_added (ContactsStore* _sender, ContactsContact* c, gpointer self);
static void __lambda19_ (Block35Data* _data35_);
static void ___lambda19__contacts_store_quiescent (ContactsStore* _sender, gpointer self);
ContactsContact* contacts_store_find_contact_with_persona (ContactsStore* self, FolksPersona* persona);
GeeCollection* contacts_store_get_contacts (ContactsStore* self);
gboolean contacts_store_is_empty (ContactsStore* self);
gboolean contacts_contact_get_is_hidden (ContactsContact* self);
static void contacts_store_add (ContactsStore* self, ContactsContact* c);
static void _contacts_store_contact_changed_cb_contacts_contact_changed (ContactsContact* _sender, gpointer self);
static void contacts_store_remove (ContactsStore* self, ContactsContact* c);
static void contacts_store_check_call_capabilities_data_free (gpointer _data);
static void contacts_store_check_call_capabilities (ContactsStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void contacts_store_check_call_capabilities_finish (ContactsStore* self, GAsyncResult* _res_);
static gboolean contacts_store_check_call_capabilities_co (ContactsStoreCheckCallCapabilitiesData* _data_);
static void contacts_store_check_call_capabilities_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void contacts_store_check_account_caps (ContactsStore* self, TpAccount* account, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void contacts_store_check_account_caps_finish (ContactsStore* self, GAsyncResult* _res_);
static void _contacts_store_check_account_caps_tp_account_manager_account_enabled (TpAccountManager* _sender, TpAccount* account, gpointer self);
static void _contacts_store_check_account_caps_tp_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self);
static void contacts_store_check_account_caps_data_free (gpointer _data);
static gboolean contacts_store_check_account_caps_co (ContactsStoreCheckAccountCapsData* _data_);
static void contacts_store_check_account_caps_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
ContactsStore* contacts_store_new (void);
ContactsStore* contacts_store_construct (GType object_type);
FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self);
static void contacts_store_set_aggregator (ContactsStore* self, FolksIndividualAggregator* value);
FolksBackendStore* contacts_store_get_backend_store (ContactsStore* self);
static void contacts_store_set_backend_store (ContactsStore* self, FolksBackendStore* value);
gboolean contacts_store_get_can_call (ContactsStore* self);
gboolean contacts_store_get_is_prepared (ContactsStore* self);
static GObject * contacts_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _contacts_store___lambda20_ (ContactsStore* self, FolksBackend* backend);
static void ___lambda21_ (ContactsStore* self);
static void ____lambda21__folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
static void ___lambda22_ (ContactsStore* self);
static void ____lambda22__folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
static void __contacts_store___lambda20__folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self);
static void _contacts_store___lambda23_ (ContactsStore* self, GObject* obj, GParamSpec* pspec);
static gboolean __lambda24_ (ContactsStore* self);
static gboolean ___lambda24__gsource_func (gpointer self);
static void __contacts_store___lambda23__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _contacts_store___lambda25_ (ContactsStore* self, GObject* obj, GParamSpec* pspec);
static gboolean __lambda26_ (ContactsStore* self);
static gboolean ___lambda26__gsource_func (gpointer self);
static void __contacts_store___lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _contacts_store___lambda27_ (ContactsStore* self, GeeMultiMap* changes);
ContactsContact* contacts_contact_new (ContactsStore* store, FolksIndividual* i);
ContactsContact* contacts_contact_construct (GType object_type, ContactsStore* store, FolksIndividual* i);
void contacts_contact_replace_individual (ContactsContact* self, FolksIndividual* new_individual);
static void __contacts_store___lambda27__folks_individual_aggregator_individuals_changed_detailed (FolksIndividualAggregator* _sender, GeeMultiMap* changes, gpointer self);
static void contacts_store_finalize (GObject* obj);
static void _vala_contacts_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_contacts_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void contacts_store_refresh (ContactsStore* self) {
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _c_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _c_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _c_index = 0;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_c_list = _tmp1_;
		_tmp2_ = _c_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_c_size = _tmp4_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			ContactsContact* c = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			ContactsContact* _tmp11_ = NULL;
			_tmp5_ = _c_index;
			_c_index = _tmp5_ + 1;
			_tmp6_ = _c_index;
			_tmp7_ = _c_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _c_list;
			_tmp9_ = _c_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			c = (ContactsContact*) _tmp10_;
			_tmp11_ = c;
			contacts_contact_queue_changed (_tmp11_, TRUE);
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_list);
	}
}


static gboolean contacts_store_individual_can_replace_at_split (ContactsStore* self, FolksIndividual* new_individual) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_individual != NULL, FALSE);
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
		_tmp0_ = new_individual;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			FolksPersona* p = NULL;
			GeeIterator* _tmp6_ = NULL;
			gpointer _tmp7_ = NULL;
			FolksPersona* _tmp8_ = NULL;
			gconstpointer _tmp9_ = NULL;
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _p_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			p = (FolksPersona*) _tmp7_;
			_tmp8_ = p;
			_tmp9_ = g_object_get_data ((GObject*) _tmp8_, "contacts-new-contact");
			if ((gboolean) ((gintptr) _tmp9_)) {
				result = FALSE;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = TRUE;
	return result;
}


static gboolean contacts_store_individual_should_replace_at_join (ContactsStore* self, FolksIndividual* old_individual) {
	gboolean result = FALSE;
	ContactsContact* c = NULL;
	FolksIndividual* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (old_individual != NULL, FALSE);
	_tmp0_ = old_individual;
	_tmp1_ = contacts_contact_from_individual (_tmp0_);
	c = _tmp1_;
	_tmp2_ = g_object_get_data ((GObject*) c, "contacts-master-at-join");
	result = (gboolean) ((gintptr) _tmp2_);
	_g_object_unref0 (c);
	return result;
}


static void contacts_store_read_dont_suggest_db (ContactsStore* self) {
	GeeHashMultiMap* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->dont_suggest_link;
	gee_multi_map_clear ((GeeMultiMap*) _tmp0_);
	{
		gchar* path = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* contents = NULL;
		gboolean _tmp3_ = FALSE;
		gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp1_ = g_get_user_config_dir ();
		_tmp2_ = g_build_filename (_tmp1_, "gnome-contacts", "dont_suggest.db", NULL);
		path = _tmp2_;
		_tmp5_ = g_file_get_contents (path, &_tmp4_, NULL, &_inner_error_);
		_g_free0 (contents);
		contents = _tmp4_;
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (contents);
			_g_free0 (path);
			goto __catch24_g_error;
		}
		if (_tmp3_) {
			gchar** rows = NULL;
			gchar** _tmp6_ = NULL;
			gchar** _tmp7_ = NULL;
			gint rows_length1 = 0;
			gint _rows_size_ = 0;
			gchar** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			_tmp7_ = _tmp6_ = g_strsplit (contents, "\n", 0);
			rows = _tmp7_;
			rows_length1 = _vala_array_length (_tmp6_);
			_rows_size_ = rows_length1;
			_tmp8_ = rows;
			_tmp8__length1 = rows_length1;
			{
				gchar** r_collection = NULL;
				gint r_collection_length1 = 0;
				gint _r_collection_size_ = 0;
				gint r_it = 0;
				r_collection = _tmp8_;
				r_collection_length1 = _tmp8__length1;
				for (r_it = 0; r_it < _tmp8__length1; r_it = r_it + 1) {
					gchar* _tmp9_ = NULL;
					gchar* r = NULL;
					_tmp9_ = g_strdup (r_collection[r_it]);
					r = _tmp9_;
					{
						gchar** ids = NULL;
						const gchar* _tmp10_ = NULL;
						gchar** _tmp11_ = NULL;
						gchar** _tmp12_ = NULL;
						gint ids_length1 = 0;
						gint _ids_size_ = 0;
						gchar** _tmp13_ = NULL;
						gint _tmp13__length1 = 0;
						_tmp10_ = r;
						_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, " ", 0);
						ids = _tmp12_;
						ids_length1 = _vala_array_length (_tmp11_);
						_ids_size_ = ids_length1;
						_tmp13_ = ids;
						_tmp13__length1 = ids_length1;
						if (_tmp13__length1 == 2) {
							GeeHashMultiMap* _tmp14_ = NULL;
							gchar** _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							const gchar* _tmp16_ = NULL;
							gchar** _tmp17_ = NULL;
							gint _tmp17__length1 = 0;
							const gchar* _tmp18_ = NULL;
							_tmp14_ = self->dont_suggest_link;
							_tmp15_ = ids;
							_tmp15__length1 = ids_length1;
							_tmp16_ = _tmp15_[0];
							_tmp17_ = ids;
							_tmp17__length1 = ids_length1;
							_tmp18_ = _tmp17_[1];
							gee_multi_map_set ((GeeMultiMap*) _tmp14_, _tmp16_, _tmp18_);
						}
						ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (r);
					}
				}
			}
			rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (contents);
		_g_free0 (path);
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		if (!g_error_matches (_tmp19_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			GError* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			_tmp20_ = e;
			_tmp21_ = _tmp20_->message;
			g_warning ("contacts-store.vala:90: error loading no suggestion db: %s\n", _tmp21_);
		}
		_g_error_free0 (e);
	}
	__finally24:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void contacts_store_write_dont_suggest_db (ContactsStore* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* dir = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* path = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GString* s = NULL;
		GString* _tmp5_ = NULL;
		const gchar* _tmp28_ = NULL;
		GString* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		GString* _tmp31_ = NULL;
		gssize _tmp32_ = 0L;
		_tmp0_ = g_get_user_config_dir ();
		_tmp1_ = g_build_filename (_tmp0_, "gnome-contacts", NULL);
		dir = _tmp1_;
		_tmp2_ = dir;
		g_mkdir_with_parents (_tmp2_, 0700);
		_tmp3_ = dir;
		_tmp4_ = g_build_filename (_tmp3_, "dont_suggest.db", NULL);
		path = _tmp4_;
		_tmp5_ = g_string_new ("");
		s = _tmp5_;
		{
			GeeIterator* _key_it = NULL;
			GeeHashMultiMap* _tmp6_ = NULL;
			GeeSet* _tmp7_ = NULL;
			GeeSet* _tmp8_ = NULL;
			GeeIterator* _tmp9_ = NULL;
			GeeIterator* _tmp10_ = NULL;
			_tmp6_ = self->dont_suggest_link;
			_tmp7_ = gee_multi_map_get_keys ((GeeMultiMap*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
			_tmp10_ = _tmp9_;
			_g_object_unref0 (_tmp8_);
			_key_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				gchar* key = NULL;
				GeeIterator* _tmp13_ = NULL;
				gpointer _tmp14_ = NULL;
				_tmp11_ = _key_it;
				_tmp12_ = gee_iterator_next (_tmp11_);
				if (!_tmp12_) {
					break;
				}
				_tmp13_ = _key_it;
				_tmp14_ = gee_iterator_get (_tmp13_);
				key = (gchar*) _tmp14_;
				{
					GeeIterator* _value_it = NULL;
					GeeHashMultiMap* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					GeeCollection* _tmp17_ = NULL;
					GeeCollection* _tmp18_ = NULL;
					GeeIterator* _tmp19_ = NULL;
					GeeIterator* _tmp20_ = NULL;
					_tmp15_ = self->dont_suggest_link;
					_tmp16_ = key;
					_tmp17_ = gee_multi_map_get ((GeeMultiMap*) _tmp15_, _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
					_tmp20_ = _tmp19_;
					_g_object_unref0 (_tmp18_);
					_value_it = _tmp20_;
					while (TRUE) {
						GeeIterator* _tmp21_ = NULL;
						gboolean _tmp22_ = FALSE;
						gchar* value = NULL;
						GeeIterator* _tmp23_ = NULL;
						gpointer _tmp24_ = NULL;
						GString* _tmp25_ = NULL;
						const gchar* _tmp26_ = NULL;
						const gchar* _tmp27_ = NULL;
						_tmp21_ = _value_it;
						_tmp22_ = gee_iterator_next (_tmp21_);
						if (!_tmp22_) {
							break;
						}
						_tmp23_ = _value_it;
						_tmp24_ = gee_iterator_get (_tmp23_);
						value = (gchar*) _tmp24_;
						_tmp25_ = s;
						_tmp26_ = key;
						_tmp27_ = value;
						g_string_append_printf (_tmp25_, "%s %s\n", _tmp26_, _tmp27_);
						_g_free0 (value);
					}
					_g_object_unref0 (_value_it);
				}
				_g_free0 (key);
			}
			_g_object_unref0 (_key_it);
		}
		_tmp28_ = path;
		_tmp29_ = s;
		_tmp30_ = _tmp29_->str;
		_tmp31_ = s;
		_tmp32_ = _tmp31_->len;
		g_file_set_contents (_tmp28_, _tmp30_, _tmp32_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_string_free0 (s);
			_g_free0 (path);
			_g_free0 (dir);
			goto __catch25_g_error;
		}
		_g_string_free0 (s);
		_g_free0 (path);
		_g_free0 (dir);
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		g_warning ("contacts-store.vala:108: error writing no suggestion db: %s\n", _tmp34_);
		_g_error_free0 (e);
	}
	__finally25:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gboolean contacts_store_may_suggest_link (ContactsStore* self, ContactsContact* a, ContactsContact* b) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	{
		GeeIterator* _a_persona_it = NULL;
		ContactsContact* _tmp0_ = NULL;
		FolksIndividual* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		_tmp0_ = a;
		_tmp1_ = _tmp0_->individual;
		_tmp2_ = folks_individual_get_personas (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_a_persona_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			FolksPersona* a_persona = NULL;
			GeeIterator* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			_tmp5_ = _a_persona_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _a_persona_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			a_persona = (FolksPersona*) _tmp8_;
			{
				GeeIterator* _no_link_uid_it = NULL;
				GeeHashMultiMap* _tmp9_ = NULL;
				FolksPersona* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				GeeCollection* _tmp13_ = NULL;
				GeeCollection* _tmp14_ = NULL;
				GeeIterator* _tmp15_ = NULL;
				GeeIterator* _tmp16_ = NULL;
				_tmp9_ = self->dont_suggest_link;
				_tmp10_ = a_persona;
				_tmp11_ = folks_persona_get_uid (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = gee_multi_map_get ((GeeMultiMap*) _tmp9_, _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
				_tmp16_ = _tmp15_;
				_g_object_unref0 (_tmp14_);
				_no_link_uid_it = _tmp16_;
				while (TRUE) {
					GeeIterator* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					gchar* no_link_uid = NULL;
					GeeIterator* _tmp19_ = NULL;
					gpointer _tmp20_ = NULL;
					_tmp17_ = _no_link_uid_it;
					_tmp18_ = gee_iterator_next (_tmp17_);
					if (!_tmp18_) {
						break;
					}
					_tmp19_ = _no_link_uid_it;
					_tmp20_ = gee_iterator_get (_tmp19_);
					no_link_uid = (gchar*) _tmp20_;
					{
						GeeIterator* _b_persona_it = NULL;
						ContactsContact* _tmp21_ = NULL;
						FolksIndividual* _tmp22_ = NULL;
						GeeSet* _tmp23_ = NULL;
						GeeSet* _tmp24_ = NULL;
						GeeIterator* _tmp25_ = NULL;
						_tmp21_ = b;
						_tmp22_ = _tmp21_->individual;
						_tmp23_ = folks_individual_get_personas (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = gee_iterable_iterator ((GeeIterable*) _tmp24_);
						_b_persona_it = _tmp25_;
						while (TRUE) {
							GeeIterator* _tmp26_ = NULL;
							gboolean _tmp27_ = FALSE;
							FolksPersona* b_persona = NULL;
							GeeIterator* _tmp28_ = NULL;
							gpointer _tmp29_ = NULL;
							FolksPersona* _tmp30_ = NULL;
							const gchar* _tmp31_ = NULL;
							const gchar* _tmp32_ = NULL;
							const gchar* _tmp33_ = NULL;
							_tmp26_ = _b_persona_it;
							_tmp27_ = gee_iterator_next (_tmp26_);
							if (!_tmp27_) {
								break;
							}
							_tmp28_ = _b_persona_it;
							_tmp29_ = gee_iterator_get (_tmp28_);
							b_persona = (FolksPersona*) _tmp29_;
							_tmp30_ = b_persona;
							_tmp31_ = folks_persona_get_uid (_tmp30_);
							_tmp32_ = _tmp31_;
							_tmp33_ = no_link_uid;
							if (g_strcmp0 (_tmp32_, _tmp33_) == 0) {
								result = FALSE;
								_g_object_unref0 (b_persona);
								_g_object_unref0 (_b_persona_it);
								_g_free0 (no_link_uid);
								_g_object_unref0 (_no_link_uid_it);
								_g_object_unref0 (a_persona);
								_g_object_unref0 (_a_persona_it);
								return result;
							}
							_g_object_unref0 (b_persona);
						}
						_g_object_unref0 (_b_persona_it);
					}
					_g_free0 (no_link_uid);
				}
				_g_object_unref0 (_no_link_uid_it);
			}
			_g_object_unref0 (a_persona);
		}
		_g_object_unref0 (_a_persona_it);
	}
	{
		GeeIterator* _b_persona_it = NULL;
		ContactsContact* _tmp34_ = NULL;
		FolksIndividual* _tmp35_ = NULL;
		GeeSet* _tmp36_ = NULL;
		GeeSet* _tmp37_ = NULL;
		GeeIterator* _tmp38_ = NULL;
		_tmp34_ = b;
		_tmp35_ = _tmp34_->individual;
		_tmp36_ = folks_individual_get_personas (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = gee_iterable_iterator ((GeeIterable*) _tmp37_);
		_b_persona_it = _tmp38_;
		while (TRUE) {
			GeeIterator* _tmp39_ = NULL;
			gboolean _tmp40_ = FALSE;
			FolksPersona* b_persona = NULL;
			GeeIterator* _tmp41_ = NULL;
			gpointer _tmp42_ = NULL;
			_tmp39_ = _b_persona_it;
			_tmp40_ = gee_iterator_next (_tmp39_);
			if (!_tmp40_) {
				break;
			}
			_tmp41_ = _b_persona_it;
			_tmp42_ = gee_iterator_get (_tmp41_);
			b_persona = (FolksPersona*) _tmp42_;
			{
				GeeIterator* _no_link_uid_it = NULL;
				GeeHashMultiMap* _tmp43_ = NULL;
				FolksPersona* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				GeeCollection* _tmp47_ = NULL;
				GeeCollection* _tmp48_ = NULL;
				GeeIterator* _tmp49_ = NULL;
				GeeIterator* _tmp50_ = NULL;
				_tmp43_ = self->dont_suggest_link;
				_tmp44_ = b_persona;
				_tmp45_ = folks_persona_get_uid (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = gee_multi_map_get ((GeeMultiMap*) _tmp43_, _tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = gee_iterable_iterator ((GeeIterable*) _tmp48_);
				_tmp50_ = _tmp49_;
				_g_object_unref0 (_tmp48_);
				_no_link_uid_it = _tmp50_;
				while (TRUE) {
					GeeIterator* _tmp51_ = NULL;
					gboolean _tmp52_ = FALSE;
					gchar* no_link_uid = NULL;
					GeeIterator* _tmp53_ = NULL;
					gpointer _tmp54_ = NULL;
					_tmp51_ = _no_link_uid_it;
					_tmp52_ = gee_iterator_next (_tmp51_);
					if (!_tmp52_) {
						break;
					}
					_tmp53_ = _no_link_uid_it;
					_tmp54_ = gee_iterator_get (_tmp53_);
					no_link_uid = (gchar*) _tmp54_;
					{
						GeeIterator* _a_persona_it = NULL;
						ContactsContact* _tmp55_ = NULL;
						FolksIndividual* _tmp56_ = NULL;
						GeeSet* _tmp57_ = NULL;
						GeeSet* _tmp58_ = NULL;
						GeeIterator* _tmp59_ = NULL;
						_tmp55_ = a;
						_tmp56_ = _tmp55_->individual;
						_tmp57_ = folks_individual_get_personas (_tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = gee_iterable_iterator ((GeeIterable*) _tmp58_);
						_a_persona_it = _tmp59_;
						while (TRUE) {
							GeeIterator* _tmp60_ = NULL;
							gboolean _tmp61_ = FALSE;
							FolksPersona* a_persona = NULL;
							GeeIterator* _tmp62_ = NULL;
							gpointer _tmp63_ = NULL;
							FolksPersona* _tmp64_ = NULL;
							const gchar* _tmp65_ = NULL;
							const gchar* _tmp66_ = NULL;
							const gchar* _tmp67_ = NULL;
							_tmp60_ = _a_persona_it;
							_tmp61_ = gee_iterator_next (_tmp60_);
							if (!_tmp61_) {
								break;
							}
							_tmp62_ = _a_persona_it;
							_tmp63_ = gee_iterator_get (_tmp62_);
							a_persona = (FolksPersona*) _tmp63_;
							_tmp64_ = a_persona;
							_tmp65_ = folks_persona_get_uid (_tmp64_);
							_tmp66_ = _tmp65_;
							_tmp67_ = no_link_uid;
							if (g_strcmp0 (_tmp66_, _tmp67_) == 0) {
								result = FALSE;
								_g_object_unref0 (a_persona);
								_g_object_unref0 (_a_persona_it);
								_g_free0 (no_link_uid);
								_g_object_unref0 (_no_link_uid_it);
								_g_object_unref0 (b_persona);
								_g_object_unref0 (_b_persona_it);
								return result;
							}
							_g_object_unref0 (a_persona);
						}
						_g_object_unref0 (_a_persona_it);
					}
					_g_free0 (no_link_uid);
				}
				_g_object_unref0 (_no_link_uid_it);
			}
			_g_object_unref0 (b_persona);
		}
		_g_object_unref0 (_b_persona_it);
	}
	result = TRUE;
	return result;
}


void contacts_store_add_no_suggest_link (ContactsStore* self, ContactsContact* a, ContactsContact* b) {
	FolksPersona* persona1 = NULL;
	ContactsContact* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gpointer* _tmp4_ = NULL;
	FolksPersona** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	FolksPersona* _tmp6_ = NULL;
	FolksPersona* _tmp7_ = NULL;
	FolksPersona* _tmp8_ = NULL;
	FolksPersona* persona2 = NULL;
	ContactsContact* _tmp9_ = NULL;
	GeeList* _tmp10_ = NULL;
	GeeList* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gpointer* _tmp13_ = NULL;
	FolksPersona** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	FolksPersona* _tmp15_ = NULL;
	FolksPersona* _tmp16_ = NULL;
	FolksPersona* _tmp17_ = NULL;
	GeeHashMultiMap* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = a;
	_tmp1_ = contacts_contact_get_personas_for_display (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = gee_collection_to_array ((GeeCollection*) _tmp2_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp6_ = _tmp5_[0];
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp2_);
	persona1 = _tmp8_;
	_tmp9_ = b;
	_tmp10_ = contacts_contact_get_personas_for_display (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp13_ = gee_collection_to_array ((GeeCollection*) _tmp11_, &_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp14__length1 = _tmp12_;
	_tmp15_ = _tmp14_[0];
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp11_);
	persona2 = _tmp17_;
	_tmp18_ = self->dont_suggest_link;
	_tmp19_ = folks_persona_get_uid (persona1);
	_tmp20_ = _tmp19_;
	_tmp21_ = folks_persona_get_uid (persona2);
	_tmp22_ = _tmp21_;
	gee_multi_map_set ((GeeMultiMap*) _tmp18_, _tmp20_, _tmp22_);
	contacts_store_write_dont_suggest_db (self);
	_g_object_unref0 (persona2);
	_g_object_unref0 (persona1);
}


static void contacts_store_contact_changed_cb (ContactsStore* self, ContactsContact* c) {
	ContactsContact* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	g_signal_emit_by_name (self, "changed", _tmp0_);
}


static void contacts_store_find_contact_data_free (gpointer _data) {
	ContactsStoreFindContactData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsStoreFindContactData, _data_);
}


void contacts_store_find_contact (ContactsStore* self, ContactsStoreContactMatcher matcher, void* matcher_target, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsStoreFindContactData* _data_;
	ContactsStore* _tmp0_ = NULL;
	ContactsStoreContactMatcher _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	_data_ = g_slice_new0 (ContactsStoreFindContactData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, contacts_store_find_contact);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, contacts_store_find_contact_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = matcher;
	_tmp1__target = matcher_target;
	_data_->matcher = _tmp1_;
	_data_->matcher_target = _tmp1__target;
	contacts_store_find_contact_co (_data_);
}


ContactsContact* contacts_store_find_contact_finish (ContactsStore* self, GAsyncResult* _res_) {
	ContactsContact* result;
	ContactsStoreFindContactData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block35Data* block35_data_ref (Block35Data* _data35_) {
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}


static void block35_data_unref (void * _userdata_) {
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		ContactsStore* self;
		self = _data35_->self;
		(_data35_->callback_target_destroy_notify == NULL) ? NULL : (_data35_->callback_target_destroy_notify (_data35_->callback_target), NULL);
		_data35_->callback = NULL;
		_data35_->callback_target = NULL;
		_data35_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (_data35_->matched);
		_g_object_unref0 (self);
		g_slice_free (Block35Data, _data35_);
	}
}


static gboolean _contacts_store_find_contact_co_gsource_func (gpointer self) {
	gboolean result;
	result = contacts_store_find_contact_co (self);
	return result;
}


static void __lambda17_ (Block35Data* _data35_, ContactsContact* c) {
	ContactsStore* self;
	ContactsStoreContactMatcher _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	ContactsContact* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	self = _data35_->self;
	g_return_if_fail (c != NULL);
	_tmp0_ = _data35_->matcher;
	_tmp0__target = _data35_->matcher_target;
	_tmp1_ = c;
	_tmp2_ = _tmp0_ (_tmp1_, _tmp0__target);
	if (_tmp2_) {
		ContactsContact* _tmp3_ = NULL;
		ContactsContact* _tmp4_ = NULL;
		GSourceFunc _tmp5_ = NULL;
		void* _tmp5__target = NULL;
		_tmp3_ = c;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (_data35_->matched);
		_data35_->matched = _tmp4_;
		_tmp5_ = _data35_->callback;
		_tmp5__target = _data35_->callback_target;
		_tmp5_ (_tmp5__target);
	}
}


static void ___lambda17__contacts_store_changed (ContactsStore* _sender, ContactsContact* c, gpointer self) {
	__lambda17_ (self, c);
}


static void __lambda18_ (Block35Data* _data35_, ContactsContact* c) {
	ContactsStore* self;
	ContactsStoreContactMatcher _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	ContactsContact* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	self = _data35_->self;
	g_return_if_fail (c != NULL);
	_tmp0_ = _data35_->matcher;
	_tmp0__target = _data35_->matcher_target;
	_tmp1_ = c;
	_tmp2_ = _tmp0_ (_tmp1_, _tmp0__target);
	if (_tmp2_) {
		ContactsContact* _tmp3_ = NULL;
		ContactsContact* _tmp4_ = NULL;
		GSourceFunc _tmp5_ = NULL;
		void* _tmp5__target = NULL;
		_tmp3_ = c;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (_data35_->matched);
		_data35_->matched = _tmp4_;
		_tmp5_ = _data35_->callback;
		_tmp5__target = _data35_->callback_target;
		_tmp5_ (_tmp5__target);
	}
}


static void ___lambda18__contacts_store_added (ContactsStore* _sender, ContactsContact* c, gpointer self) {
	__lambda18_ (self, c);
}


static void __lambda19_ (Block35Data* _data35_) {
	ContactsStore* self;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	self = _data35_->self;
	_tmp0_ = _data35_->callback;
	_tmp0__target = _data35_->callback_target;
	_tmp0_ (_tmp0__target);
}


static void ___lambda19__contacts_store_quiescent (ContactsStore* _sender, gpointer self) {
	__lambda19_ (self);
}


static gboolean contacts_store_find_contact_co (ContactsStoreFindContactData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data35_ = g_slice_new0 (Block35Data);
	_data_->_data35_->_ref_count_ = 1;
	_data_->_data35_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0__target = NULL;
	_data_->_tmp0_ = _data_->matcher;
	_data_->_tmp0__target = _data_->matcher_target;
	_data_->_data35_->matcher = _data_->_tmp0_;
	_data_->_data35_->matcher_target = _data_->_tmp0__target;
	_data_->_data35_->_async_data_ = _data_;
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->self->priv->contacts;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
		_data_->_c_list = _data_->_tmp2_;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_c_list;
		_data_->_tmp4_ = 0;
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
		_data_->_tmp5_ = 0;
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_c_size = _data_->_tmp5_;
		_data_->_c_index = -1;
		while (TRUE) {
			_data_->_tmp6_ = 0;
			_data_->_tmp6_ = _data_->_c_index;
			_data_->_c_index = _data_->_tmp6_ + 1;
			_data_->_tmp7_ = 0;
			_data_->_tmp7_ = _data_->_c_index;
			_data_->_tmp8_ = 0;
			_data_->_tmp8_ = _data_->_c_size;
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
				break;
			}
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->_c_list;
			_data_->_tmp10_ = 0;
			_data_->_tmp10_ = _data_->_c_index;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
			_data_->c = (ContactsContact*) _data_->_tmp11_;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12__target = NULL;
			_data_->_tmp12_ = _data_->_data35_->matcher;
			_data_->_tmp12__target = _data_->_data35_->matcher_target;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->c;
			_data_->_tmp14_ = FALSE;
			_data_->_tmp14_ = _data_->_tmp12_ (_data_->_tmp13_, _data_->_tmp12__target);
			if (_data_->_tmp14_) {
				_data_->result = _data_->c;
				_g_object_unref0 (_data_->_c_list);
				block35_data_unref (_data_->_data35_);
				_data_->_data35_ = NULL;
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->c);
		}
		_g_object_unref0 (_data_->_c_list);
	}
	_data_->_tmp15_ = FALSE;
	_data_->_tmp15_ = contacts_store_get_is_quiescent (_data_->self);
	_data_->_tmp16_ = FALSE;
	_data_->_tmp16_ = _data_->_tmp15_;
	if (_data_->_tmp16_) {
		_data_->result = NULL;
		block35_data_unref (_data_->_data35_);
		_data_->_data35_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_data35_->matched = NULL;
	_data_->_data35_->callback = _contacts_store_find_contact_co_gsource_func;
	_data_->_data35_->callback_target = _data_;
	_data_->_data35_->callback_target_destroy_notify = NULL;
	_data_->_tmp17_ = 0UL;
	_data_->_tmp17_ = g_signal_connect_data (_data_->self, "changed", (GCallback) ___lambda17__contacts_store_changed, block35_data_ref (_data_->_data35_), (GClosureNotify) block35_data_unref, 0);
	_data_->id1 = _data_->_tmp17_;
	_data_->_tmp18_ = 0UL;
	_data_->_tmp18_ = g_signal_connect_data (_data_->self, "added", (GCallback) ___lambda18__contacts_store_added, block35_data_ref (_data_->_data35_), (GClosureNotify) block35_data_unref, 0);
	_data_->id2 = _data_->_tmp18_;
	_data_->_tmp19_ = 0UL;
	_data_->_tmp19_ = g_signal_connect_data (_data_->self, "quiescent", (GCallback) ___lambda19__contacts_store_quiescent, block35_data_ref (_data_->_data35_), (GClosureNotify) block35_data_unref, 0);
	_data_->id3 = _data_->_tmp19_;
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp20_ = 0UL;
	_data_->_tmp20_ = _data_->id1;
	g_signal_handler_disconnect ((GObject*) _data_->self, _data_->_tmp20_);
	_data_->_tmp21_ = 0UL;
	_data_->_tmp21_ = _data_->id2;
	g_signal_handler_disconnect ((GObject*) _data_->self, _data_->_tmp21_);
	_data_->_tmp22_ = 0UL;
	_data_->_tmp22_ = _data_->id3;
	g_signal_handler_disconnect ((GObject*) _data_->self, _data_->_tmp22_);
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->_data35_->matched;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _g_object_ref0 (_data_->_tmp23_);
	_data_->result = _data_->_tmp24_;
	block35_data_unref (_data_->_data35_);
	_data_->_data35_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block35_data_unref (_data_->_data35_);
	_data_->_data35_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


ContactsContact* contacts_store_find_contact_with_persona (ContactsStore* self, FolksPersona* persona) {
	ContactsContact* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (persona != NULL, NULL);
	{
		GeeArrayList* _contact_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _contact_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _contact_index = 0;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_contact_list = _tmp1_;
		_tmp2_ = _contact_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_contact_size = _tmp4_;
		_contact_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			ContactsContact* contact = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			ContactsContact* _tmp11_ = NULL;
			FolksIndividual* _tmp12_ = NULL;
			GeeSet* _tmp13_ = NULL;
			GeeSet* _tmp14_ = NULL;
			FolksPersona* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			_tmp5_ = _contact_index;
			_contact_index = _tmp5_ + 1;
			_tmp6_ = _contact_index;
			_tmp7_ = _contact_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _contact_list;
			_tmp9_ = _contact_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			contact = (ContactsContact*) _tmp10_;
			_tmp11_ = contact;
			_tmp12_ = _tmp11_->individual;
			_tmp13_ = folks_individual_get_personas (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = persona;
			_tmp16_ = gee_collection_contains ((GeeCollection*) _tmp14_, _tmp15_);
			if (_tmp16_) {
				result = contact;
				_g_object_unref0 (_contact_list);
				return result;
			}
			_g_object_unref0 (contact);
		}
		_g_object_unref0 (_contact_list);
	}
	result = NULL;
	return result;
}


GeeCollection* contacts_store_get_contacts (ContactsStore* self) {
	GeeCollection* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeBidirList* _tmp1_ = NULL;
	GeeBidirList* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->contacts;
	_tmp1_ = gee_abstract_bidir_list_get_read_only_view ((GeeAbstractBidirList*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (GeeCollection*) _tmp2_;
	return result;
}


gboolean contacts_store_is_empty (ContactsStore* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _contact_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _contact_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _contact_index = 0;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_contact_list = _tmp1_;
		_tmp2_ = _contact_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_contact_size = _tmp4_;
		_contact_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			ContactsContact* contact = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			ContactsContact* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			_tmp5_ = _contact_index;
			_contact_index = _tmp5_ + 1;
			_tmp6_ = _contact_index;
			_tmp7_ = _contact_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _contact_list;
			_tmp9_ = _contact_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			contact = (ContactsContact*) _tmp10_;
			_tmp11_ = contact;
			_tmp12_ = contacts_contact_get_is_hidden (_tmp11_);
			_tmp13_ = _tmp12_;
			if (!_tmp13_) {
				result = FALSE;
				_g_object_unref0 (contact);
				_g_object_unref0 (_contact_list);
				return result;
			}
			_g_object_unref0 (contact);
		}
		_g_object_unref0 (_contact_list);
	}
	result = TRUE;
	return result;
}


static void _contacts_store_contact_changed_cb_contacts_contact_changed (ContactsContact* _sender, gpointer self) {
	contacts_store_contact_changed_cb ((ContactsStore*) self, _sender);
}


static void contacts_store_add (ContactsStore* self, ContactsContact* c) {
	GeeArrayList* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	ContactsContact* _tmp2_ = NULL;
	ContactsContact* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->contacts;
	_tmp1_ = c;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	_tmp2_ = c;
	g_signal_connect_object (_tmp2_, "changed", (GCallback) _contacts_store_contact_changed_cb_contacts_contact_changed, self, 0);
	_tmp3_ = c;
	g_signal_emit_by_name (self, "added", _tmp3_);
}


static void contacts_store_remove (ContactsStore* self, ContactsContact* c) {
	ContactsContact* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gint i = 0;
	GeeArrayList* _tmp2_ = NULL;
	ContactsContact* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GeeArrayList* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GeeArrayList* _tmp17_ = NULL;
	GeeArrayList* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gpointer _tmp21_ = NULL;
	ContactsContact* _tmp22_ = NULL;
	ContactsContact* _tmp23_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	g_signal_parse_name ("changed", CONTACTS_TYPE_CONTACT, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _contacts_store_contact_changed_cb_contacts_contact_changed, self);
	_tmp2_ = self->priv->contacts;
	_tmp3_ = c;
	_tmp4_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp2_, _tmp3_);
	i = _tmp4_;
	_tmp5_ = i;
	_tmp6_ = self->priv->contacts;
	_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp5_ != (_tmp8_ - 1)) {
		GeeArrayList* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		GeeArrayList* _tmp11_ = NULL;
		GeeArrayList* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gpointer _tmp15_ = NULL;
		ContactsContact* _tmp16_ = NULL;
		_tmp9_ = self->priv->contacts;
		_tmp10_ = i;
		_tmp11_ = self->priv->contacts;
		_tmp12_ = self->priv->contacts;
		_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp14_ - 1);
		_tmp16_ = (ContactsContact*) _tmp15_;
		gee_abstract_list_set ((GeeAbstractList*) _tmp9_, _tmp10_, _tmp16_);
		_g_object_unref0 (_tmp16_);
	}
	_tmp17_ = self->priv->contacts;
	_tmp18_ = self->priv->contacts;
	_tmp19_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp17_, _tmp20_ - 1);
	_tmp22_ = (ContactsContact*) _tmp21_;
	_g_object_unref0 (_tmp22_);
	_tmp23_ = c;
	g_signal_emit_by_name (self, "removed", _tmp23_);
}


static void contacts_store_check_call_capabilities_data_free (gpointer _data) {
	ContactsStoreCheckCallCapabilitiesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsStoreCheckCallCapabilitiesData, _data_);
}


static void contacts_store_check_call_capabilities (ContactsStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsStoreCheckCallCapabilitiesData* _data_;
	ContactsStore* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ContactsStoreCheckCallCapabilitiesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, contacts_store_check_call_capabilities);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, contacts_store_check_call_capabilities_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_store_check_call_capabilities_co (_data_);
}


static void contacts_store_check_call_capabilities_finish (ContactsStore* self, GAsyncResult* _res_) {
	ContactsStoreCheckCallCapabilitiesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void contacts_store_check_call_capabilities_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsStoreCheckCallCapabilitiesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_store_check_call_capabilities_co (_data_);
}


static void _contacts_store_check_account_caps_tp_account_manager_account_enabled (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	contacts_store_check_account_caps ((ContactsStore*) self, account, NULL, NULL);
}


static void _contacts_store_check_account_caps_tp_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	contacts_store_check_account_caps ((ContactsStore*) self, account, NULL, NULL);
}


static gboolean contacts_store_check_call_capabilities_co (ContactsStoreCheckCallCapabilitiesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, tp_account_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (_data_->self->calling_accounts);
	_data_->self->calling_accounts = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = tp_account_manager_dup ();
	_data_->account_manager = _data_->_tmp1_;
	{
		_data_->_state_ = 1;
		tp_proxy_prepare_async ((TpProxy*) _data_->account_manager, NULL, contacts_store_check_call_capabilities_ready, _data_);
		return FALSE;
		_state_1:
		tp_proxy_prepare_finish ((TpProxy*) _data_->account_manager, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch26_g_error;
		}
		g_signal_connect_object (_data_->account_manager, "account-enabled", (GCallback) _contacts_store_check_account_caps_tp_account_manager_account_enabled, _data_->self, 0);
		g_signal_connect_object (_data_->account_manager, "account-disabled", (GCallback) _contacts_store_check_account_caps_tp_account_manager_account_disabled, _data_->self, 0);
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = tp_account_manager_get_valid_accounts (_data_->account_manager);
		{
			_data_->account_collection = _data_->_tmp2_;
			for (_data_->account_it = _data_->account_collection; _data_->account_it != NULL; _data_->account_it = _data_->account_it->next) {
				_data_->account = (TpAccount*) _data_->account_it->data;
				{
					_data_->_tmp3_ = NULL;
					_data_->_tmp3_ = _data_->account;
					_data_->_state_ = 2;
					contacts_store_check_account_caps (_data_->self, _data_->_tmp3_, contacts_store_check_call_capabilities_ready, _data_);
					return FALSE;
					_state_2:
					contacts_store_check_account_caps_finish (_data_->self, _data_->_res_);
				}
			}
			_g_list_free0 (_data_->account_collection);
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_warning ("contacts-store.vala:335: Unable to check accounts caps %s", _data_->_tmp5_);
		_g_error_free0 (_data_->e);
	}
	__finally26:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->account_manager);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->account_manager);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void contacts_store_check_account_caps_data_free (gpointer _data) {
	ContactsStoreCheckAccountCapsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsStoreCheckAccountCapsData, _data_);
}


static void contacts_store_check_account_caps (ContactsStore* self, TpAccount* account, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsStoreCheckAccountCapsData* _data_;
	ContactsStore* _tmp0_ = NULL;
	TpAccount* _tmp1_ = NULL;
	TpAccount* _tmp2_ = NULL;
	_data_ = g_slice_new0 (ContactsStoreCheckAccountCapsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, contacts_store_check_account_caps);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, contacts_store_check_account_caps_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = account;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp2_;
	contacts_store_check_account_caps_co (_data_);
}


static void contacts_store_check_account_caps_finish (ContactsStore* self, GAsyncResult* _res_) {
	ContactsStoreCheckAccountCapsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void contacts_store_check_account_caps_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsStoreCheckAccountCapsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_store_check_account_caps_co (_data_);
}


static gboolean contacts_store_check_account_caps_co (ContactsStoreCheckAccountCapsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0U;
	_data_->_tmp0_ = tp_account_get_feature_quark_addressing ();
	_data_->addressing = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->account;
	_data_->_tmp2_ = 0U;
	_data_->_tmp2_ = _data_->addressing;
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = tp_proxy_is_prepared ((TpProxy*) _data_->_tmp1_, _data_->_tmp2_);
	if (!_data_->_tmp3_) {
		_data_->_tmp4_ = 0U;
		_data_->_tmp4_ = _data_->addressing;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_new0 (GQuark, 1);
		_data_->_tmp5_[0] = _data_->_tmp4_;
		_data_->features_length1 = 0;
		_data_->_features_size_ = 0;
		_data_->features = _data_->_tmp5_;
		_data_->features_length1 = 1;
		_data_->_features_size_ = _data_->features_length1;
		{
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = _data_->account;
			_data_->_tmp7_ = NULL;
			_data_->_tmp7__length1 = 0;
			_data_->_tmp7_ = _data_->features;
			_data_->_tmp7__length1 = _data_->features_length1;
			_data_->_state_ = 1;
			tp_proxy_prepare_async ((TpProxy*) _data_->_tmp6_, _data_->_tmp7_, contacts_store_check_account_caps_ready, _data_);
			return FALSE;
			_state_1:
			tp_proxy_prepare_finish ((TpProxy*) _data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch27_g_error;
			}
		}
		goto __finally27;
		__catch27_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->e;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->_tmp8_->message;
			g_warning ("contacts-store.vala:346: Unable to prepare account %s", _data_->_tmp9_);
			_g_error_free0 (_data_->e);
		}
		__finally27:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_data_->features = (g_free (_data_->features), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->features = (g_free (_data_->features), NULL);
	}
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->account;
	_data_->_tmp11_ = 0U;
	_data_->_tmp11_ = _data_->addressing;
	_data_->_tmp12_ = FALSE;
	_data_->_tmp12_ = tp_proxy_is_prepared ((TpProxy*) _data_->_tmp10_, _data_->_tmp11_);
	if (_data_->_tmp12_) {
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->account;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = tp_proxy_get_object_path ((TpProxy*) _data_->_tmp13_);
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
		_data_->k = _data_->_tmp15_;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->account;
		_data_->_tmp18_ = FALSE;
		_data_->_tmp18_ = tp_account_is_enabled (_data_->_tmp17_);
		if (_data_->_tmp18_) {
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->account;
			_data_->_tmp20_ = FALSE;
			_data_->_tmp20_ = tp_account_associated_with_uri_scheme (_data_->_tmp19_, "tel");
			_data_->_tmp16_ = _data_->_tmp20_;
		} else {
			_data_->_tmp16_ = FALSE;
		}
		if (_data_->_tmp16_) {
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->self->calling_accounts;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _data_->k;
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->account;
			gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp21_, _data_->_tmp22_, _data_->_tmp23_);
		} else {
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = _data_->self->calling_accounts;
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->k;
			gee_abstract_map_unset ((GeeAbstractMap*) _data_->_tmp24_, _data_->_tmp25_, NULL);
		}
		_g_free0 (_data_->k);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


ContactsStore* contacts_store_construct (GType object_type) {
	ContactsStore * self = NULL;
	self = (ContactsStore*) g_object_new (object_type, NULL);
	return self;
}


ContactsStore* contacts_store_new (void) {
	return contacts_store_construct (CONTACTS_TYPE_STORE);
}


FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self) {
	FolksIndividualAggregator* result;
	FolksIndividualAggregator* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aggregator;
	result = _tmp0_;
	return result;
}


static void contacts_store_set_aggregator (ContactsStore* self, FolksIndividualAggregator* value) {
	FolksIndividualAggregator* _tmp0_ = NULL;
	FolksIndividualAggregator* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_aggregator);
	self->priv->_aggregator = _tmp1_;
	g_object_notify ((GObject *) self, "aggregator");
}


FolksBackendStore* contacts_store_get_backend_store (ContactsStore* self) {
	FolksBackendStore* result;
	FolksBackendStore* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backend_store;
	result = _tmp0_;
	return result;
}


static void contacts_store_set_backend_store (ContactsStore* self, FolksBackendStore* value) {
	FolksBackendStore* _tmp0_ = NULL;
	FolksBackendStore* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_backend_store);
	self->priv->_backend_store = _tmp1_;
	g_object_notify ((GObject *) self, "backend-store");
}


gboolean contacts_store_get_can_call (ContactsStore* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->calling_accounts;
	_tmp2_ = gee_abstract_map_get_size ((GeeMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean contacts_store_get_is_quiescent (ContactsStore* self) {
	gboolean result;
	FolksIndividualAggregator* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_aggregator;
	_tmp1_ = folks_individual_aggregator_get_is_quiescent (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


gboolean contacts_store_get_is_prepared (ContactsStore* self) {
	gboolean result;
	FolksIndividualAggregator* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_aggregator;
	_tmp1_ = folks_individual_aggregator_get_is_prepared (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void ___lambda21_ (ContactsStore* self) {
	g_signal_emit_by_name (self, "eds-persona-store-changed");
}


static void ____lambda21__folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	___lambda21_ ((ContactsStore*) self);
}


static void ___lambda22_ (ContactsStore* self) {
	g_signal_emit_by_name (self, "eds-persona-store-changed");
}


static void ____lambda22__folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	___lambda22_ ((ContactsStore*) self);
}


static void _contacts_store___lambda20_ (ContactsStore* self, FolksBackend* backend) {
	FolksBackend* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (backend != NULL);
	_tmp0_ = backend;
	_tmp1_ = folks_backend_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "eds") == 0) {
		FolksBackend* _tmp3_ = NULL;
		FolksBackend* _tmp4_ = NULL;
		_tmp3_ = backend;
		g_signal_connect_object (_tmp3_, "persona-store-added", (GCallback) ____lambda21__folks_backend_persona_store_added, self, 0);
		_tmp4_ = backend;
		g_signal_connect_object (_tmp4_, "persona-store-removed", (GCallback) ____lambda22__folks_backend_persona_store_removed, self, 0);
	}
}


static void __contacts_store___lambda20__folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self) {
	_contacts_store___lambda20_ ((ContactsStore*) self, backend);
}


static gboolean __lambda24_ (ContactsStore* self) {
	gboolean result = FALSE;
	g_signal_emit_by_name (self, "quiescent");
	result = FALSE;
	return result;
}


static gboolean ___lambda24__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda24_ ((ContactsStore*) self);
	return result;
}


static void _contacts_store___lambda23_ (ContactsStore* self, GObject* obj, GParamSpec* pspec) {
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda24__gsource_func, g_object_ref (self), g_object_unref);
}


static void __contacts_store___lambda23__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_contacts_store___lambda23_ ((ContactsStore*) self, _sender, pspec);
}


static gboolean __lambda26_ (ContactsStore* self) {
	gboolean result = FALSE;
	g_signal_emit_by_name (self, "prepared");
	result = FALSE;
	return result;
}


static gboolean ___lambda26__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda26_ ((ContactsStore*) self);
	return result;
}


static void _contacts_store___lambda25_ (ContactsStore* self, GObject* obj, GParamSpec* pspec) {
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda26__gsource_func, g_object_ref (self), g_object_unref);
}


static void __contacts_store___lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_contacts_store___lambda25_ ((ContactsStore*) self, _sender, pspec);
}


static void _contacts_store___lambda27_ (ContactsStore* self, GeeMultiMap* changes) {
	GeeHashMap* replaced_individuals = NULL;
	GeeHashMap* _tmp0_ = NULL;
	g_return_if_fail (changes != NULL);
	_tmp0_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	replaced_individuals = _tmp0_;
	{
		GeeIterator* _old_individual_it = NULL;
		GeeMultiMap* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		_tmp1_ = changes;
		_tmp2_ = gee_multi_map_get_keys (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_old_individual_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			FolksIndividual* old_individual = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			FolksIndividual* _tmp10_ = NULL;
			_tmp6_ = _old_individual_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _old_individual_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			old_individual = (FolksIndividual*) _tmp9_;
			_tmp10_ = old_individual;
			if (_tmp10_ == NULL) {
				_g_object_unref0 (old_individual);
				continue;
			}
			{
				GeeIterator* _new_individual_it = NULL;
				GeeMultiMap* _tmp11_ = NULL;
				FolksIndividual* _tmp12_ = NULL;
				GeeCollection* _tmp13_ = NULL;
				GeeCollection* _tmp14_ = NULL;
				GeeIterator* _tmp15_ = NULL;
				GeeIterator* _tmp16_ = NULL;
				_tmp11_ = changes;
				_tmp12_ = old_individual;
				_tmp13_ = gee_multi_map_get (_tmp11_, _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
				_tmp16_ = _tmp15_;
				_g_object_unref0 (_tmp14_);
				_new_individual_it = _tmp16_;
				while (TRUE) {
					GeeIterator* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					FolksIndividual* new_individual = NULL;
					GeeIterator* _tmp19_ = NULL;
					gpointer _tmp20_ = NULL;
					FolksIndividual* _tmp21_ = NULL;
					gboolean _tmp22_ = FALSE;
					GeeHashMap* _tmp23_ = NULL;
					FolksIndividual* _tmp24_ = NULL;
					gboolean _tmp25_ = FALSE;
					_tmp17_ = _new_individual_it;
					_tmp18_ = gee_iterator_next (_tmp17_);
					if (!_tmp18_) {
						break;
					}
					_tmp19_ = _new_individual_it;
					_tmp20_ = gee_iterator_get (_tmp19_);
					new_individual = (FolksIndividual*) _tmp20_;
					_tmp21_ = new_individual;
					if (_tmp21_ == NULL) {
						_g_object_unref0 (new_individual);
						continue;
					}
					_tmp23_ = replaced_individuals;
					_tmp24_ = new_individual;
					_tmp25_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp23_, _tmp24_);
					if (!_tmp25_) {
						_tmp22_ = TRUE;
					} else {
						FolksIndividual* _tmp26_ = NULL;
						gboolean _tmp27_ = FALSE;
						_tmp26_ = old_individual;
						_tmp27_ = contacts_store_individual_should_replace_at_join (self, _tmp26_);
						_tmp22_ = _tmp27_;
					}
					if (_tmp22_) {
						GeeHashMap* _tmp28_ = NULL;
						FolksIndividual* _tmp29_ = NULL;
						FolksIndividual* _tmp30_ = NULL;
						_tmp28_ = replaced_individuals;
						_tmp29_ = new_individual;
						_tmp30_ = old_individual;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, _tmp29_, _tmp30_);
					}
					_g_object_unref0 (new_individual);
				}
				_g_object_unref0 (_new_individual_it);
			}
			_g_object_unref0 (old_individual);
		}
		_g_object_unref0 (_old_individual_it);
	}
	{
		GeeIterator* _old_individual_it = NULL;
		GeeMultiMap* _tmp31_ = NULL;
		GeeSet* _tmp32_ = NULL;
		GeeSet* _tmp33_ = NULL;
		GeeIterator* _tmp34_ = NULL;
		GeeIterator* _tmp35_ = NULL;
		_tmp31_ = changes;
		_tmp32_ = gee_multi_map_get_keys (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = gee_iterable_iterator ((GeeIterable*) _tmp33_);
		_tmp35_ = _tmp34_;
		_g_object_unref0 (_tmp33_);
		_old_individual_it = _tmp35_;
		while (TRUE) {
			GeeIterator* _tmp36_ = NULL;
			gboolean _tmp37_ = FALSE;
			FolksIndividual* old_individual = NULL;
			GeeIterator* _tmp38_ = NULL;
			gpointer _tmp39_ = NULL;
			GeeHashSet* replacements = NULL;
			GeeHashSet* _tmp71_ = NULL;
			_tmp36_ = _old_individual_it;
			_tmp37_ = gee_iterator_next (_tmp36_);
			if (!_tmp37_) {
				break;
			}
			_tmp38_ = _old_individual_it;
			_tmp39_ = gee_iterator_get (_tmp38_);
			old_individual = (FolksIndividual*) _tmp39_;
			replacements = NULL;
			{
				GeeIterator* _new_individual_it = NULL;
				GeeMultiMap* _tmp40_ = NULL;
				FolksIndividual* _tmp41_ = NULL;
				GeeCollection* _tmp42_ = NULL;
				GeeCollection* _tmp43_ = NULL;
				GeeIterator* _tmp44_ = NULL;
				GeeIterator* _tmp45_ = NULL;
				_tmp40_ = changes;
				_tmp41_ = old_individual;
				_tmp42_ = gee_multi_map_get (_tmp40_, _tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = gee_iterable_iterator ((GeeIterable*) _tmp43_);
				_tmp45_ = _tmp44_;
				_g_object_unref0 (_tmp43_);
				_new_individual_it = _tmp45_;
				while (TRUE) {
					GeeIterator* _tmp46_ = NULL;
					gboolean _tmp47_ = FALSE;
					FolksIndividual* new_individual = NULL;
					GeeIterator* _tmp48_ = NULL;
					gpointer _tmp49_ = NULL;
					gboolean _tmp50_ = FALSE;
					gboolean _tmp51_ = FALSE;
					FolksIndividual* _tmp52_ = NULL;
					_tmp46_ = _new_individual_it;
					_tmp47_ = gee_iterator_next (_tmp46_);
					if (!_tmp47_) {
						break;
					}
					_tmp48_ = _new_individual_it;
					_tmp49_ = gee_iterator_get (_tmp48_);
					new_individual = (FolksIndividual*) _tmp49_;
					_tmp52_ = old_individual;
					if (_tmp52_ != NULL) {
						FolksIndividual* _tmp53_ = NULL;
						_tmp53_ = new_individual;
						_tmp51_ = _tmp53_ != NULL;
					} else {
						_tmp51_ = FALSE;
					}
					if (_tmp51_) {
						GeeHashMap* _tmp54_ = NULL;
						FolksIndividual* _tmp55_ = NULL;
						gpointer _tmp56_ = NULL;
						FolksIndividual* _tmp57_ = NULL;
						FolksIndividual* _tmp58_ = NULL;
						_tmp54_ = replaced_individuals;
						_tmp55_ = new_individual;
						_tmp56_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp54_, _tmp55_);
						_tmp57_ = (FolksIndividual*) _tmp56_;
						_tmp58_ = old_individual;
						_tmp50_ = _tmp57_ == _tmp58_;
						_g_object_unref0 (_tmp57_);
					} else {
						_tmp50_ = FALSE;
					}
					if (_tmp50_) {
						GeeHashSet* _tmp59_ = NULL;
						GeeHashSet* _tmp61_ = NULL;
						FolksIndividual* _tmp62_ = NULL;
						_tmp59_ = replacements;
						if (_tmp59_ == NULL) {
							GeeHashSet* _tmp60_ = NULL;
							_tmp60_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
							_g_object_unref0 (replacements);
							replacements = _tmp60_;
						}
						_tmp61_ = replacements;
						_tmp62_ = new_individual;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, _tmp62_);
					} else {
						FolksIndividual* _tmp63_ = NULL;
						_tmp63_ = old_individual;
						if (_tmp63_ != NULL) {
							ContactsContact* c = NULL;
							FolksIndividual* _tmp64_ = NULL;
							ContactsContact* _tmp65_ = NULL;
							ContactsContact* _tmp66_ = NULL;
							_tmp64_ = old_individual;
							_tmp65_ = contacts_contact_from_individual (_tmp64_);
							c = _tmp65_;
							_tmp66_ = c;
							contacts_store_remove (self, _tmp66_);
							_g_object_unref0 (c);
						} else {
							FolksIndividual* _tmp67_ = NULL;
							_tmp67_ = new_individual;
							if (_tmp67_ != NULL) {
								FolksIndividual* _tmp68_ = NULL;
								ContactsContact* _tmp69_ = NULL;
								ContactsContact* _tmp70_ = NULL;
								_tmp68_ = new_individual;
								_tmp69_ = contacts_contact_new (self, _tmp68_);
								_tmp70_ = _tmp69_;
								contacts_store_add (self, _tmp70_);
								_g_object_unref0 (_tmp70_);
							}
						}
					}
					_g_object_unref0 (new_individual);
				}
				_g_object_unref0 (_new_individual_it);
			}
			_tmp71_ = replacements;
			if (_tmp71_ != NULL) {
				FolksIndividual* main_individual = NULL;
				ContactsContact* c = NULL;
				FolksIndividual* _tmp82_ = NULL;
				ContactsContact* _tmp83_ = NULL;
				ContactsContact* _tmp84_ = NULL;
				FolksIndividual* _tmp85_ = NULL;
				main_individual = NULL;
				{
					GeeIterator* _i_it = NULL;
					GeeHashSet* _tmp72_ = NULL;
					GeeIterator* _tmp73_ = NULL;
					_tmp72_ = replacements;
					_tmp73_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp72_);
					_i_it = _tmp73_;
					while (TRUE) {
						GeeIterator* _tmp74_ = NULL;
						gboolean _tmp75_ = FALSE;
						FolksIndividual* i = NULL;
						GeeIterator* _tmp76_ = NULL;
						gpointer _tmp77_ = NULL;
						FolksIndividual* _tmp78_ = NULL;
						FolksIndividual* _tmp79_ = NULL;
						FolksIndividual* _tmp80_ = NULL;
						gboolean _tmp81_ = FALSE;
						_tmp74_ = _i_it;
						_tmp75_ = gee_iterator_next (_tmp74_);
						if (!_tmp75_) {
							break;
						}
						_tmp76_ = _i_it;
						_tmp77_ = gee_iterator_get (_tmp76_);
						i = (FolksIndividual*) _tmp77_;
						_tmp78_ = i;
						_tmp79_ = _g_object_ref0 (_tmp78_);
						_g_object_unref0 (main_individual);
						main_individual = _tmp79_;
						_tmp80_ = i;
						_tmp81_ = contacts_store_individual_can_replace_at_split (self, _tmp80_);
						if (_tmp81_) {
							_g_object_unref0 (i);
							break;
						}
						_g_object_unref0 (i);
					}
					_g_object_unref0 (_i_it);
				}
				_tmp82_ = old_individual;
				_tmp83_ = contacts_contact_from_individual (_tmp82_);
				c = _tmp83_;
				_tmp84_ = c;
				_tmp85_ = main_individual;
				contacts_contact_replace_individual (_tmp84_, _tmp85_);
				{
					GeeIterator* _i_it = NULL;
					GeeHashSet* _tmp86_ = NULL;
					GeeIterator* _tmp87_ = NULL;
					_tmp86_ = replacements;
					_tmp87_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp86_);
					_i_it = _tmp87_;
					while (TRUE) {
						GeeIterator* _tmp88_ = NULL;
						gboolean _tmp89_ = FALSE;
						FolksIndividual* i = NULL;
						GeeIterator* _tmp90_ = NULL;
						gpointer _tmp91_ = NULL;
						FolksIndividual* _tmp92_ = NULL;
						FolksIndividual* _tmp93_ = NULL;
						_tmp88_ = _i_it;
						_tmp89_ = gee_iterator_next (_tmp88_);
						if (!_tmp89_) {
							break;
						}
						_tmp90_ = _i_it;
						_tmp91_ = gee_iterator_get (_tmp90_);
						i = (FolksIndividual*) _tmp91_;
						_tmp92_ = i;
						_tmp93_ = main_individual;
						if (_tmp92_ != _tmp93_) {
							FolksIndividual* _tmp94_ = NULL;
							ContactsContact* _tmp95_ = NULL;
							ContactsContact* _tmp96_ = NULL;
							_tmp94_ = i;
							_tmp95_ = contacts_contact_new (self, _tmp94_);
							_tmp96_ = _tmp95_;
							contacts_store_add (self, _tmp96_);
							_g_object_unref0 (_tmp96_);
						}
						_g_object_unref0 (i);
					}
					_g_object_unref0 (_i_it);
				}
				_g_object_unref0 (c);
				_g_object_unref0 (main_individual);
			}
			_g_object_unref0 (replacements);
			_g_object_unref0 (old_individual);
		}
		_g_object_unref0 (_old_individual_it);
	}
	_g_object_unref0 (replaced_individuals);
}


static void __contacts_store___lambda27__folks_individual_aggregator_individuals_changed_detailed (FolksIndividualAggregator* _sender, GeeMultiMap* changes, gpointer self) {
	_contacts_store___lambda27_ ((ContactsStore*) self, changes);
}


static GObject * contacts_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ContactsStore * self;
	GeeArrayList* _tmp0_ = NULL;
	GeeHashMultiMap* _tmp1_ = NULL;
	FolksBackendStore* _tmp2_ = NULL;
	FolksBackendStore* _tmp3_ = NULL;
	FolksBackendStore* _tmp4_ = NULL;
	FolksIndividualAggregator* _tmp5_ = NULL;
	FolksIndividualAggregator* _tmp6_ = NULL;
	FolksIndividualAggregator* _tmp7_ = NULL;
	FolksIndividualAggregator* _tmp8_ = NULL;
	FolksIndividualAggregator* _tmp9_ = NULL;
	FolksIndividualAggregator* _tmp10_ = NULL;
	parent_class = G_OBJECT_CLASS (contacts_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_STORE, ContactsStore);
	_tmp0_ = gee_array_list_new (CONTACTS_TYPE_CONTACT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->contacts);
	self->priv->contacts = _tmp0_;
	_tmp1_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->dont_suggest_link);
	self->dont_suggest_link = _tmp1_;
	contacts_store_read_dont_suggest_db (self);
	_tmp2_ = folks_backend_store_dup ();
	_tmp3_ = _tmp2_;
	contacts_store_set_backend_store (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_backend_store;
	g_signal_connect_object (_tmp4_, "backend-available", (GCallback) __contacts_store___lambda20__folks_backend_store_backend_available, self, 0);
	_tmp5_ = folks_individual_aggregator_dup ();
	_tmp6_ = _tmp5_;
	contacts_store_set_aggregator (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->_aggregator;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::is-quiescent", (GCallback) __contacts_store___lambda23__g_object_notify, self, 0);
	_tmp8_ = self->priv->_aggregator;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::is-prepared", (GCallback) __contacts_store___lambda25__g_object_notify, self, 0);
	_tmp9_ = self->priv->_aggregator;
	g_signal_connect_object (_tmp9_, "individuals-changed-detailed", (GCallback) __contacts_store___lambda27__folks_individual_aggregator_individuals_changed_detailed, self, 0);
	_tmp10_ = self->priv->_aggregator;
	folks_individual_aggregator_prepare (_tmp10_, NULL, NULL);
	contacts_store_check_call_capabilities (self, NULL, NULL);
	return obj;
}


static void contacts_store_class_init (ContactsStoreClass * klass) {
	contacts_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsStorePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_AGGREGATOR, g_param_spec_object ("aggregator", "aggregator", "aggregator", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_BACKEND_STORE, g_param_spec_object ("backend-store", "backend-store", "backend-store", FOLKS_TYPE_BACKEND_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_CAN_CALL, g_param_spec_boolean ("can-call", "can-call", "can-call", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("changed", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_CONTACT);
	g_signal_new ("added", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_CONTACT);
	g_signal_new ("removed", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_CONTACT);
	g_signal_new ("quiescent", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("prepared", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("eds_persona_store_changed", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void contacts_store_instance_init (ContactsStore * self) {
	self->priv = CONTACTS_STORE_GET_PRIVATE (self);
}


static void contacts_store_finalize (GObject* obj) {
	ContactsStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_STORE, ContactsStore);
	_g_object_unref0 (self->priv->_aggregator);
	_g_object_unref0 (self->priv->_backend_store);
	_g_object_unref0 (self->priv->contacts);
	_g_object_unref0 (self->calling_accounts);
	_g_object_unref0 (self->dont_suggest_link);
	G_OBJECT_CLASS (contacts_store_parent_class)->finalize (obj);
}


GType contacts_store_get_type (void) {
	static volatile gsize contacts_store_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsStore), 0, (GInstanceInitFunc) contacts_store_instance_init, NULL };
		GType contacts_store_type_id;
		contacts_store_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsStore", &g_define_type_info, 0);
		g_once_init_leave (&contacts_store_type_id__volatile, contacts_store_type_id);
	}
	return contacts_store_type_id__volatile;
}


static void _vala_contacts_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ContactsStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_STORE, ContactsStore);
	switch (property_id) {
		case CONTACTS_STORE_AGGREGATOR:
		g_value_set_object (value, contacts_store_get_aggregator (self));
		break;
		case CONTACTS_STORE_BACKEND_STORE:
		g_value_set_object (value, contacts_store_get_backend_store (self));
		break;
		case CONTACTS_STORE_CAN_CALL:
		g_value_set_boolean (value, contacts_store_get_can_call (self));
		break;
		case CONTACTS_STORE_IS_QUIESCENT:
		g_value_set_boolean (value, contacts_store_get_is_quiescent (self));
		break;
		case CONTACTS_STORE_IS_PREPARED:
		g_value_set_boolean (value, contacts_store_get_is_prepared (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_contacts_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ContactsStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_STORE, ContactsStore);
	switch (property_id) {
		case CONTACTS_STORE_AGGREGATOR:
		contacts_store_set_aggregator (self, g_value_get_object (value));
		break;
		case CONTACTS_STORE_BACKEND_STORE:
		contacts_store_set_backend_store (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



