/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GSWITCHIT_CONFIG_PRIVATE_H__
#define __GSWITCHIT_CONFIG_PRIVATE_H__

#include "libgswitchit/gswitchit_config.h"

/**
 * General config functions (private)
 */
extern void GSwitchItKbdConfigModelSet (GSwitchItKbdConfig * kbdConfig,
					const gchar * modelName);

extern void GSwitchItKbdConfigLayoutsReset (GSwitchItKbdConfig * kbdConfig);
extern void GSwitchItKbdConfigLayoutsAdd (GSwitchItKbdConfig * kbdConfig,
					  const gchar * layoutName,
					  const gchar * variantName);

extern void GSwitchItKbdConfigLayoutsReset (GSwitchItKbdConfig * kbdConfig);
extern void GSwitchItKbdConfigOptionsReset (GSwitchItKbdConfig * kbdConfig);

extern void GSwitchItKbdConfigOptionsAdd (GSwitchItKbdConfig * kbdConfig,
					  const gchar * groupName,
					  const gchar * optionName);
extern gboolean GSwitchItKbdConfigOptionsIsSet (GSwitchItKbdConfig * kbdConfig,
						const gchar * groupName,
						const gchar * optionName);

extern gboolean GSwitchItKbdConfigDumpSettings (GSwitchItKbdConfig * kbdConfig,
					     const char *fileName);

extern void GSwitchItKbdConfigStartListen (GSwitchItKbdConfig * kbdConfig,
					   GConfClientNotifyFunc func, 
					   gpointer user_data);

extern void GSwitchItKbdConfigStopListen (GSwitchItKbdConfig * kbdConfig);

#endif
