#!/usr/bin/env python

from distutils.core import setup
from distutils.command.build import build
import glob
import os
import os.path
import re
import sys

class build_gai(build):
    def run(self):
        data_files = self.distribution.data_files
        print "Setting up help files..."
        for filepath in glob.glob("help/*"):
            lang = filepath[len("help/"):]
            print " Language: %s" % lang
            path_xml = os.path.join("share/gnome/help/gnome-app-install/",
                                    lang)
            path_figures = os.path.join("share/gnome/help/gnome-app-install/",
                                        lang, "figures")
            data_files.append((path_xml, (glob.glob("%s/*.xml" % filepath))))
            data_files.append((path_figures,
                               (glob.glob("%s/figures/*.png" % filepath))))
        data_files.append(('share/omf/gnome-app-install',
                           glob.glob("help/*/*.omf")))

        for size in glob.glob("data/icons/*"):
            for category in glob.glob("%s/*" % size):
                icons = []
                for icon in glob.glob("%s/*" % category):
                    icons.append(icon)
                    data_files.append(("share/icons/hicolor/%s/%s" % \
                                       (os.path.basename(size), \
                                        os.path.basename(category)), \
                                        icons))
        # generate the i18n files
        for filepath in glob.glob("po/mo/*/LC_MESSAGES/*.mo"):
            lang = filepath[len("po/mo/"):]
            targetpath = os.path.dirname(os.path.join("share/locale",lang))
            data_files.append((targetpath, [filepath]))

        # HACK: make sure that the mo files are generated and up-to-date
        os.system("intltool-merge -d po data/gnome-app-install.schemas.in "\
                  "data/gnome-app-install.schemas")
        os.system("cd po; make update-po")
        os.system("cd data; make")

        build.run(self)

if __name__ == "__main__":

    # look/set what version we have
    changelog = "debian/changelog"
    if os.path.exists(changelog):
        head=open(changelog).readline()
        match = re.compile(".*\((.*)\).*").match(head)
        if match:
            version = match.group(1)
            f=open("AppInstall/Version.py","w")
            f.write("VERSION=\"%s\"\n" % version)
            f.close()

    GETTEXT_NAME="gnome-app-install"

    setup(name='gnome-app-install',
          version=version,
          cmdclass={"build":build_gai},
          packages=['AppInstall'],
          scripts=['gnome-app-install'],
          data_files=[('share/gnome-app-install/',
                       ["data/gnome-app-install.glade",
                       ]
                      ),
                      ('share/gconf/schemas',
                       glob.glob("data/*.schemas")
                      ),
                      ('share/app-install/channels',
                       glob.glob("channels/*.list")
                      ),
                      ('share/applications',
                       ["data/gnome-app-install.desktop"]
                      ),
                      ('share/app-install/desktop',
                       glob.glob("menu-data/*.desktop")+
                       glob.glob("menu-data-additional/*.desktop")+
                       glob.glob("menu-data/*.menu")+
                       # FIXME: maybe move this into the channels dir?
                       glob.glob("channels/*.desktop")
                      ),
                      ('sbin',
                       ["update-app-install"]),
                      ('share/app-install/icons',
                       glob.glob("menu-data/icons/*")+
                       glob.glob("menu-data-additional/icons/*")
                      )
                     ]
          )


