// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_TLSFILEDATABASE_H
#define _GIOMM_TLSFILEDATABASE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2013 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/interface.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GTlsFileDatabaseInterface GTlsFileDatabaseInterface;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GTlsFileDatabase GTlsFileDatabase;
typedef struct _GTlsFileDatabaseClass GTlsFileDatabaseClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class TlsFileDatabase_Class; } // namespace Gio
namespace Gio
{

/** TlsFileDatabase - TLS file based database type.
 * TlsFileDatabase is implemented by TlsDatabase objects which load their
 * certificate information from a file. It is in interface which TLS library
 * specific subtypes implement.
 * @newin{2,36}
 */

class TlsFileDatabase : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef TlsFileDatabase CppObjectType;
  typedef TlsFileDatabase_Class CppClassType;
  typedef GTlsFileDatabase BaseObjectType;
  typedef GTlsFileDatabaseInterface BaseClassType;

private:
  friend class TlsFileDatabase_Class;
  static CppClassType tlsfiledatabase_class_;

  // noncopyable
  TlsFileDatabase(const TlsFileDatabase&);
  TlsFileDatabase& operator=(const TlsFileDatabase&);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  TlsFileDatabase();
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit TlsFileDatabase(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit TlsFileDatabase(GTlsFileDatabase* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~TlsFileDatabase();

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GTlsFileDatabase*       gobj()       { return reinterpret_cast<GTlsFileDatabase*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GTlsFileDatabase* gobj() const { return reinterpret_cast<GTlsFileDatabase*>(gobject_); }

private:


public:
  //TODO: Should this create() method be in TlsDatabase since the _new()
  //function returns a GTlsDatabase?
  //TODO: Wrap this using _WRAP_CTR()/WRAP_CREATE() when the
  //g_tls_file_database_new() function does not do more than calling
  //g_initable_new().
 

  /** Creates a new TlsFileDatabase which uses anchor certificate authorities
   * in @a anchors to verify certificate chains.
   * 
   * The certificates in @a anchors must be PEM encoded.
   * 
   * @newin{2,30}
   * @param anchors Filename of anchor certificate authorities.
   * @return The new
   * TlsFileDatabase, or <tt>0</tt> on error.
   */
  static Glib::RefPtr<TlsFileDatabase> create(const Glib::ustring& anchors);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The certificate authority anchor file.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_anchors() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The certificate authority anchor file.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_anchors() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::TlsFileDatabase
   */
  Glib::RefPtr<Gio::TlsFileDatabase> wrap(GTlsFileDatabase* object, bool take_copy = false);

} // namespace Glib


#endif /* _GIOMM_TLSFILEDATABASE_H */

