%define name		gcompris
%define version      	8.2.2
%define RELEASE 	1
%define rel     	%{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define prefix		/usr
%define canvaspackage	%(if rpm -q redhat-release &> /dev/null; then echo gdk-pixbuf-gnome; elif rpm -q mandrake-release &> /dev/null; then echo gdk-pixbuf-gnomecanvas; else echo; fi)
%define canvaslib	%(if rpm -q mandriva-release &> /dev/null; then echo libgnomecanvas2; else echo libgnomecanvas; fi)

Summary: Educational suite for kids 2-10 years old
Name: 		%name
Version: 	%version
Release: 	%rel
License: 	GPL
Group: 		Games/Other
Source:		ftp://gcompris.sourceforge.net/gcompris-%{PACKAGE_VERSION}.tar.gz
BuildRoot: 	%_tmppath/%name-%version-buildroot
Buildrequires: gnuchess gnucap
Buildrequires: libxml2-devel libgnomeui2-devel libsqlite3_0-devel
Buildrequires: texinfo
# (misc) needed for python support
Buildrequires:  python-devel pygtk2.0-devel
Requires:	gnome-libs libxml2 gdk-pixbuf %canvaspackage %canvaslib
Requires:       gnuchess >= 5.02
Requires:       python pygtk2.0 python-sqlite2
Requires:	libSDL_mixer1.2
Requires:	libsqlite3_0
Packager:       Bruno Coudoin <bcoudoin.coudoin@free.fr>
URL: 		http://gcompris.net

%description
GCompris / I Got IT is an educationnal game for children starting at 2.
More than 100 different activities are proposed:
* Click on the animals => learn the mouse/click usage
* Type the falling letters => learn the keyboard usage
* Falling Dices
* Falling words
* Basic algebra
* Time learning with an analog clock
* Puzzle game with famous paintings
* Drive Plane to catch clouds in increasing number
* Balance the scales
* And much more ...

The Game is included in the Main desktop menu in 'Games'.

You should install it only if you have children using this computer.

%description -l fr
GCompris / J'ai Compris est un logiciel ducatif pour les enfants
 partir de 2 ans.

Plus de 100 activits sont proposes :
* Cliquer sur les animaux => apprentissage du click et de la souris
* Entrer les lettres qui tombent => Apprentissage du clavier
* Les ds qui tombent
* Les mots qui tombent
* Algbre simple
* Apprentissage de la lecture de l'heure sur une horloge analogique
* Puzzle avec des tableaux clbres
* Pilote un avion pour attraper les nuages dans l'ordre
* Equilibre la balance
* ...

Le jeu est inclus dans les icones sous le menu Jeux.

A installer si vous avez des enfants utilisant cet ordinateur.

%package devel
Summary:        Development package for gcompris
Group: 		Amusements/Games
Version: %version

%description devel
Development package for gcompris

%package -n gcompris-voices-cs
Summary:        GCompris Czech voices
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-cs
Czech voices for the GCompris game


%package -n gcompris-voices-da
Summary:        GCompris Danish voices
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-da
Danish voices for the GCompris game


%package -n gcompris-voices-de
Summary:        GCompris voices in German
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-de
Alphabet voices in German


%package -n gcompris-voices-en
Summary:        GCompris voices in English
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-en
English voices for the GCompris game


%package -n gcompris-voices-es
Summary:        GCompris voices in Spanish
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-es
Spanish voices for the GCompris game


%package -n gcompris-voices-eu
Summary:        GCompris voices in Basque
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-eu
Basque voices for the GCompris game


%package -n gcompris-voices-fi
Summary:        GCompris voices in Finish
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-fi
Finish voices for the GCompris game


%package -n gcompris-voices-fr
Summary:        GCompris voices in French
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-fr
French voices for the GCompris game


%package -n gcompris-voices-hu
Summary:        GCompris voices in Hungarian
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-hu
Hungarian voices for the GCompris game


%package -n gcompris-voices-it
Summary:        GCompris voices in Italian
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-it
Italian voices for the GCompris game


%package -n gcompris-voices-nl
Summary:        GCompris voices in Dutch
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-nl
Dutch voices for the GCompris game


%package -n gcompris-voices-mr
Summary:        GCompris voices in Marathi
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-mr
Marathi voices for the GCompris game


%package -n gcompris-voices-pt
Summary:        GCompris voices in Portuguese
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-pt
Portuguese voices for the GCompris game


%package -n gcompris-voices-pt-br
Summary:        GCompris voices in Brasilian
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-pt-br
Brasilian voices for the GCompris game


%package -n gcompris-voices-ru
Summary:        GCompris voices in Russian
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-ru
Russian voices for the GCompris game


%package -n gcompris-voices-sv
Summary:        Alphabet voices in Swedish
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-sv
Alphabet voices in Swedish


%package -n gcompris-voices-tr
Summary:        Alphabet voices in Turkish
Group: 		Amusements/Games
Version: 1.0

%description -n gcompris-voices-tr
Alphabet voices in Turkish

%prep
%setup -q

%build
%ifarch alpha
  MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif
%configure

%make


%install
rm -rf $RPM_BUILD_ROOT
%makeinstall_std


%clean
rm -rf $RPM_BUILD_ROOT

%post

%update_menus

%_install_info %{name}.info

%postun

%clean_menus

%preun

%_remove_install_info %{name}.info

%files
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog NEWS README
%_bindir/*

%dir %_libdir/%{name}/
%_libdir/%{name}/*
%_libdir/libgcompris-1.so.0.0.0
%_libdir/libgcompris-1.so.0

%_menudir/*
%dir %{prefix}/share/gcompris
%dir %{prefix}/share/gcompris/boards
%dir %{prefix}/share/gcompris/boards/skins
%{prefix}/share/gcompris/boards/skins/*
%{prefix}/share/gcompris/boards/[^s]*
%{prefix}/share/gcompris/boards/s[tcemu]*
%{prefix}/share/gcompris/boards/sound_group*
%dir %{prefix}/share/gcompris/boards/sounds
%{prefix}/share/gcompris/boards/sounds/*.ogg
%{prefix}/share/gcompris/boards/sounds/melody/*/*.ogg
%{prefix}/share/gcompris/boards/sounds/memory/*.ogg
%{prefix}/share/gcompris/boards/sounds/chronos/space/*.ogg
%{prefix}/share/gcompris/boards/sounds/LuneRouge/*
%{prefix}/share/gcompris/boards/sounds/HOWTO_ENCODE
%dir %{prefix}/share/gcompris/python
%{prefix}/share/gcompris/python/*
%{prefix}/share/applications/*
%{prefix}/share/locale/*/*/*
%{prefix}/share/pixmaps/*.png
%_infodir/*
%_mandir/*

%files devel
%dir %_includedir/libgcompris-1.0/libgcompris
%_includedir/libgcompris-1.0/libgcompris/*
%dir %_libdir
%_libdir/libgcompris-1.la
%_libdir/libgcompris-1.so
%_libdir/pkgconfig/libgcompris-1.0.pc

%files -n gcompris-voices-cs
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/cs

%files -n gcompris-voices-da
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/da

%files -n gcompris-voices-de
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/de

%files -n gcompris-voices-en
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/en

%files -n gcompris-voices-es
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/es

%files -n gcompris-voices-eu
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/eu

%files -n gcompris-voices-fi
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/fi

%files -n gcompris-voices-fr
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/fr

%files -n gcompris-voices-hu
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/hu

%files -n gcompris-voices-it
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/it

%files -n gcompris-voices-mr
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/mr

%files -n gcompris-voices-nl
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/nl

%files -n gcompris-voices-pt
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/pt

%files -n gcompris-voices-pt-br
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/pt_BR

%files -n gcompris-voices-ru
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/ru

%files -n gcompris-voices-sv
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/sv

%files -n gcompris-voices-tr
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/tr
