/* GTK uses utf8 rather than ucs2 for its strings. So all my unichar_t */
/*  functions are just char functions now */


#ifndef _GTKUSTR_H
# define _GTKUSTR_H

#ifdef VMS		/* these three lines from Jacob Jansen, Open VMS port */
# include <vms_jackets.h>
#endif

#include <stdio.h>		/* for NULL */
#include <stdlib.h>		/* for free */
#include <limits.h>
#include <stdarg.h>
#include <string.h>
#include <memory.h>
#include <glib.h>

#define true 1
#define false 0

#define forever for (;;)

typedef char unichar_t;

typedef gint8	int8;
typedef guint8	uint8;
typedef gint16	int16;
typedef guint16	uint16;
typedef gint32	int32;
typedef guint32	uint32;

	/* An integral type which can hold a pointer */
#if defined(__WORDSIZE) && __WORDSIZE==64
typedef long		intpt;
#else
typedef int		intpt;
#endif

extern void *galloc(long size);
extern void *gcalloc(int cnt, long size);
extern void *grealloc(void *,long size);
extern void gfree(void *);
extern void galloc_set_trap(void (*)(void));

#define copy(str)			strdup(str)
/*extern char *copyn(const char *,long);*/
#define u_copy(str)			strdup(str)
#define uc_copy(str)			strdup(str)
#define cu_copy(str)			strdup(str)
/*extern unichar_t *u_copyn(const unichar_t*, long);*/

#define uc_strcmp(str1,str2)		strcmp(str1,str2)
#define u_strcmp(str1,str2)		strcmp(str1,str2)
#define uc_strncmp(str1,str2,n)		strcmp(str1,str2,n)
#define u_strncmp(str1,str2,n)		strcmp(str1,str2,n)
#define uc_strmatch(str1,str2)		strcasecmp(str1,str2)
#define uc_strnmatch(str1,str2,n)	strncasecmp(str1,str2,n)
#define u_strmatch(str1,str2)		strcasecmp(str1,str2)
#define u_strnmatch(str1,str2,n)	strncasecmp(str1,str2,n)
#define strmatch(str1,str2)		strcasecmp(str1,str2)
#define strnmatch(str1,str2,n)		strncasecmp(str1,str2,n)

#define uc_strcpy(str1,str2)		strcpy(str1,str2)
#define cu_strcpy(str1,str2)		strcpy(str1,str2)
#define u_strcpy(str1,str2)		strcpy(str1,str2)
#define uc_strncpy(str1,str2,n)		strncpy(str1,str2,n)
#define cu_strncpy(str1,str2,n)		strncpy(str1,str2,n)
#define u_strncpy(str1,str2,n)		strncpy(str1,str2,n)

#define uc_strcat(str1,str2)		strcat(str1,str2)
#define cu_strcat(str1,str2)		strcat(str1,str2)
#define u_strcat(str1,str2)		strcat(str1,str2)
#define uc_strncat(str1,str2,n)		strncat(str1,str2,n)
#define cu_strncat(str1,str2,n)		strncat(str1,str2,n)
#define u_strncat(str1,str2,n)		strncat(str1,str2,n)

#define u_strlen(str)			strlen(str)

#define u_strchr(str,ch)		g_utf8_strchr(str,-1,ch)
#define u_strrchr(str,ch)		g_utf8_strrchr(str,-1,ch)

#define uc_strstr(str1,str2)		strstr(str1,str2)
#define u_strstr(str1,str2)		strstr(str1,str2)

#if 0
extern unichar_t *uc_strstrmatch(const unichar_t *,const char *);
extern unichar_t *u_strstrmatch(const unichar_t *,const unichar_t *);
extern char      *  strstrmatch(const char *,const char *);
#endif

#define u_strtoul(str1,end,base)	strtoul(str1,end,base)
#define u_strtol(str1,end,base)		strtol(str1,end,base)
#define u_strtod(str1,end)		strtod(str1,end)

#if 0
extern char *strstart(const char *initial,const char *full);
extern char *strstartmatch(const char *initial,const char *full);
extern unichar_t *u_strstartmatch(const unichar_t *initial, const unichar_t *full);
extern unichar_t *cu_strstartmatch(const char *initial, const unichar_t *full);

extern int32 *utf82u32_strncpy(int32 *ubuf,const char *utf8buf,int len);
extern int32 *utf82u32_copy(const char *utf8buf);
extern char *u322utf8_copy(const int32 *ubuf);
extern char *u322utf8_strncpy(char *utf8buf, const int32 *ubuf,int len);

extern unichar_t *utf82u_strncpy(unichar_t *ubuf,const char *utf8buf,int len);
extern unichar_t *utf82u_copyn(const char *utf8buf,int len);
extern unichar_t *utf82u_copy(const char *utf8buf);
extern char *utf82u_strcpy(char *utf8buf,const unichar_t *ubuf);
extern char *u2utf8_copy(const unichar_t *ubuf);
extern unichar_t *encoding2u_strncpy(unichar_t *uto, const char *from, int n, enum encoding cs);
extern char *u2encoding_strncpy(char *to, const unichar_t *ufrom, int n, enum encoding cs);
extern unichar_t *def2u_strncpy(unichar_t *uto, const char *from, int n);
extern char *u2def_strncpy(char *to, const unichar_t *ufrom, int n);
extern unichar_t *def2u_copy(const char *from);
extern char *u2def_copy(const unichar_t *ufrom);

extern int u_sprintf(unichar_t *str, const unichar_t *format, ... );
extern int u_snprintf(unichar_t *str, int len, const unichar_t *format, ... );
extern int u_vsnprintf(unichar_t *str, int len, const unichar_t *format, va_list ap );
#endif
#endif
