/* backend.c generated by valac 0.20.1.30-1b1d, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libedataserver/libedataserver.h>
#include <stdlib.h>
#include <string.h>
#include <libebook/libebook.h>
#include <gee.h>
#include <libebook-contacts/libebook-contacts.h>
#include <folks/folks-eds.h>
#include <folks/folks.h>
#include <gobject/gvaluecollector.h>


#define EDS_TEST_TYPE_BACKEND (eds_test_backend_get_type ())
#define EDS_TEST_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackend))
#define EDS_TEST_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))
#define EDS_TEST_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))

typedef struct _EdsTestBackend EdsTestBackend;
typedef struct _EdsTestBackendClass EdsTestBackendClass;
typedef struct _EdsTestBackendPrivate EdsTestBackendPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _eds_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (eds_test_backend_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _EdsTestBackendUpdateContactData EdsTestBackendUpdateContactData;
typedef struct _EdsTestBackendRemoveContactData EdsTestBackendRemoveContactData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _EdsTestBackendPrepareSourceAsyncData EdsTestBackendPrepareSourceAsyncData;
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
typedef struct _EdsTestBackendCommitContactsToAddressbookData EdsTestBackendCommitContactsToAddressbookData;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define __vala_EContactPhoto_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactPhoto_free (var), NULL)))
#define __vala_EContactName_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactName_free (var), NULL)))
#define __vala_EContactAddress_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactAddress_free (var), NULL)))
typedef struct _EdsTestParamSpecBackend EdsTestParamSpecBackend;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	EDS_TEST_BACKEND_SETUP_ERROR_FETCH_SOURCE_GROUP_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_OPENING_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_ADD_TO_SOURCE_GROUP_FAILED
} EdsTestBackendSetupError;
#define EDS_TEST_BACKEND_SETUP_ERROR eds_test_backend_setup_error_quark ()
struct _EdsTestBackend {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EdsTestBackendPrivate * priv;
};

struct _EdsTestBackendClass {
	GTypeClass parent_class;
	void (*finalize) (EdsTestBackend *self);
};

struct _EdsTestBackendPrivate {
	gchar* _addressbook_name;
	EBookClient* _addressbook;
	gchar** _e_contacts;
	gint _e_contacts_length1;
	gint __e_contacts_size_;
	GList* _contacts;
	ESourceRegistry* _source_registry;
	ESource* _source;
	GFile* _source_file;
};

struct _EdsTestBackendUpdateContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gint contact_pos;
	GeeHashMap* updated_data;
	gchar* uid;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	EContact* contact;
	EBookClient* _tmp4_;
	const gchar* _tmp5_;
	EContact* _tmp6_;
	EContact* _tmp7_;
	GeeHashMap* _tmp8_;
	EBookClient* _tmp9_;
	EContact* _tmp10_;
	GError* e;
	GError * _inner_error_;
};

struct _EdsTestBackendRemoveContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gint contact_pos;
	gchar* uid;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	EContact* contact;
	EBookClient* _tmp4_;
	const gchar* _tmp5_;
	EContact* _tmp6_;
	EBookClient* _tmp7_;
	EContact* _tmp8_;
	GError* e;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	EdsTestBackend * self;
	GMainLoop* mainloop;
};

struct _Block2Data {
	int _ref_count_;
	EdsTestBackend * self;
	gpointer _async_data_;
};

struct _EdsTestBackendPrepareSourceAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gboolean is_default;
	Block2Data* _data2_;
	gchar* source_file_name;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* config_dir;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* source_file;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gchar* source_file_content;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	ESourceRegistry* source_registry;
	ESourceRegistry* _tmp14_;
	ESourceRegistry* _tmp15_;
	ESourceRegistry* _tmp16_;
	gulong signal_id;
	ESourceRegistry* _tmp17_;
	gulong _tmp18_;
	GFile* _tmp19_;
	const gchar* _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	guint8* _tmp22_;
	gint _tmp22__length1;
	ESourceRegistry* _tmp23_;
	const gchar* _tmp24_;
	ESource* _tmp25_;
	ESource* _tmp26_;
	ESource* _tmp27_;
	ESourceRegistry* _tmp28_;
	gulong _tmp29_;
	GFile* _tmp30_;
	GFile* _tmp31_;
	gboolean _tmp32_;
	GError * _inner_error_;
};

struct _EdsTestBackendCommitContactsToAddressbookData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	GSList* contacts;
	GList* _tmp0_;
	GList* c_collection;
	GList* c_it;
	GeeHashMap* _tmp1_;
	GeeHashMap* c;
	EContact* contact;
	EContact* _tmp2_;
	EContact* _tmp3_;
	GeeHashMap* _tmp4_;
	EContact* _tmp5_;
	EContact* _tmp6_;
	GSList* uids;
	EBookClient* _tmp7_;
	GSList* _tmp8_;
	GSList* _tmp9_;
	GSList* uid_collection;
	GSList* uid_it;
	const gchar* uid;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError* e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError * _inner_error_;
};

struct _EdsTestParamSpecBackend {
	GParamSpec parent_instance;
};


static gpointer eds_test_backend_parent_class = NULL;

void e_source_registry_new (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
ESourceRegistry* e_source_registry_new_finish (GAsyncResult* _res_, GError** error);
GQuark eds_test_backend_setup_error_quark (void);
gpointer eds_test_backend_ref (gpointer instance);
void eds_test_backend_unref (gpointer instance);
GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void eds_test_value_set_backend (GValue* value, gpointer v_object);
void eds_test_value_take_backend (GValue* value, gpointer v_object);
gpointer eds_test_value_get_backend (const GValue* value);
GType eds_test_backend_get_type (void) G_GNUC_CONST;
#define EDS_TEST_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EDS_TEST_TYPE_BACKEND, EdsTestBackendPrivate))
enum  {
	EDS_TEST_BACKEND_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
EdsTestBackend* eds_test_backend_new (void);
EdsTestBackend* eds_test_backend_construct (GType object_type);
void eds_test_backend_add_contact (EdsTestBackend* self, GeeHashMap* c);
static void eds_test_backend_update_contact_data_free (gpointer _data);
void eds_test_backend_update_contact (EdsTestBackend* self, gint contact_pos, GeeHashMap* updated_data, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_update_contact_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_update_contact_co (EdsTestBackendUpdateContactData* _data_);
static void eds_test_backend_update_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _eds_test_backend_set_contact_fields (EdsTestBackend* self, EContact* contact, GeeHashMap* c);
static void eds_test_backend_remove_contact_data_free (gpointer _data);
void eds_test_backend_remove_contact (EdsTestBackend* self, gint contact_pos, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_remove_contact_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_remove_contact_co (EdsTestBackendRemoveContactData* _data_);
static void eds_test_backend_remove_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void eds_test_backend_reset (EdsTestBackend* self);
void eds_test_backend_set_up (EdsTestBackend* self, gboolean source_is_default, const gchar* name);
static void _eds_test_backend_prepare_source (EdsTestBackend* self, gboolean is_default);
void eds_test_backend_set_as_default (EdsTestBackend* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _eds_test_backend_prepare_source_async (EdsTestBackend* self, gboolean is_default, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _eds_test_backend_prepare_source_finish (EdsTestBackend* self, GAsyncResult* _res_, GError** error);
static void __lambda3_ (Block1Data* _data1_, GObject* obj, GAsyncResult* async_res);
static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _eds_test_backend_prepare_source_async_data_free (gpointer _data);
static gboolean _eds_test_backend_prepare_source_async_co (EdsTestBackendPrepareSourceAsyncData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _eds_test_backend_prepare_source_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda2_ (Block2Data* _data2_, ESourceRegistry* r, ESource* s);
static void ___lambda2__e_source_registry_source_added (ESourceRegistry* _sender, ESource* source, gpointer self);
static void eds_test_backend_commit_contacts_to_addressbook_data_free (gpointer _data);
void eds_test_backend_commit_contacts_to_addressbook (EdsTestBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_commit_contacts_to_addressbook_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_commit_contacts_to_addressbook_co (EdsTestBackendCommitContactsToAddressbookData* _data_);
static void eds_test_backend_commit_contacts_to_addressbook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _g_slist_free__g_object_unref0_ (GSList* self);
static void _vala_GValue_free (GValue* self);
static void _vala_EContactPhoto_free (EContactPhoto* self);
static void _vala_EContactName_free (EContactName* self);
static GeeHashMap* _eds_test_backend_parse_im_addrs (EdsTestBackend* self, const gchar* addr_str);
static void _vala_EContactAddress_free (EContactAddress* self);
void eds_test_backend_tear_down (EdsTestBackend* self);
const gchar* eds_test_backend_get_address_book_uid (EdsTestBackend* self);
static void eds_test_backend_finalize (EdsTestBackend* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark eds_test_backend_setup_error_quark (void) {
	return g_quark_from_static_string ("eds_test_backend_setup_error-quark");
}


static void _g_object_unref0_ (gpointer var) {
#line 43 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 332 "backend.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 43 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 43 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_list_free (self);
#line 341 "backend.c"
}


EdsTestBackend* eds_test_backend_construct (GType object_type) {
	EdsTestBackend* self = NULL;
	gchar** _tmp0_ = NULL;
#line 53 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self = (EdsTestBackend*) g_type_create_instance (object_type);
#line 55 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 55 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = NULL;
#line 56 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 56 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = (_vala_array_free (self->priv->_e_contacts, self->priv->_e_contacts_length1, (GDestroyNotify) g_free), NULL);
#line 56 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = _tmp0_;
#line 56 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts_length1 = 0;
#line 56 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->__e_contacts_size_ = self->priv->_e_contacts_length1;
#line 53 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return self;
#line 366 "backend.c"
}


EdsTestBackend* eds_test_backend_new (void) {
#line 53 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return eds_test_backend_construct (EDS_TEST_TYPE_BACKEND);
#line 373 "backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 61 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 380 "backend.c"
}


void eds_test_backend_add_contact (EdsTestBackend* self, GeeHashMap* c) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
#line 59 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 59 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (c != NULL);
#line 61 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = c;
#line 61 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 61 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = g_list_prepend (self->priv->_contacts, _tmp1_);
#line 59 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (c);
#line 399 "backend.c"
}


static void eds_test_backend_update_contact_data_free (gpointer _data) {
	EdsTestBackendUpdateContactData* _data_;
	_data_ = _data;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendUpdateContactData, _data_);
#line 412 "backend.c"
}


static gpointer _eds_test_backend_ref0 (gpointer self) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return self ? eds_test_backend_ref (self) : NULL;
#line 419 "backend.c"
}


void eds_test_backend_update_contact (EdsTestBackend* self, gint contact_pos, GeeHashMap* updated_data, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendUpdateContactData* _data_;
	EdsTestBackend* _tmp0_;
	gint _tmp1_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendUpdateContactData);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_update_contact);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_update_contact_data_free);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = contact_pos;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->contact_pos = _tmp1_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->updated_data = updated_data;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	eds_test_backend_update_contact_co (_data_);
#line 447 "backend.c"
}


void eds_test_backend_update_contact_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendUpdateContactData* _data_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 455 "backend.c"
}


static void eds_test_backend_update_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendUpdateContactData* _data_;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	eds_test_backend_update_contact_co (_data_);
#line 469 "backend.c"
}


static gboolean eds_test_backend_update_contact_co (EdsTestBackendUpdateContactData* _data_) {
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 0:
#line 478 "backend.c"
		goto _state_0;
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 1:
#line 482 "backend.c"
		goto _state_1;
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 2:
#line 486 "backend.c"
		goto _state_2;
		default:
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 491 "backend.c"
	}
	_state_0:
#line 67 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_e_contacts;
#line 67 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0__length1 = _data_->self->priv->_e_contacts_length1;
#line 67 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = _data_->contact_pos;
#line 67 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = _data_->_tmp0_[_data_->_tmp1_];
#line 67 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 67 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->uid = _data_->_tmp3_;
#line 506 "backend.c"
	{
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp4_ = _data_->self->priv->_addressbook;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp5_ = _data_->uid;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp6_ = NULL;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 1;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact (_data_->_tmp4_, _data_->_tmp5_, NULL, eds_test_backend_update_contact_ready, _data_);
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 520 "backend.c"
		_state_1:
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->contact = _data_->_tmp6_;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 530 "backend.c"
			goto __catch0_g_error;
		}
#line 72 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = _data_->contact;
#line 72 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = _data_->updated_data;
#line 72 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_set_contact_fields (_data_->self, _data_->_tmp7_, _data_->_tmp8_);
#line 73 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp9_ = _data_->self->priv->_addressbook;
#line 73 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp10_ = _data_->contact;
#line 73 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 2;
#line 73 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_modify_contact (_data_->_tmp9_, _data_->_tmp10_, NULL, eds_test_backend_update_contact_ready, _data_);
#line 73 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 549 "backend.c"
		_state_2:
#line 73 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_modify_contact_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
#line 73 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 555 "backend.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->e = _data_->_inner_error_;
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_inner_error_ = NULL;
#line 77 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:77: Couldn't update contact\n");
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (_data_->e);
#line 570 "backend.c"
	}
	__finally0:
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->uid);
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->updated_data);
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_data_->_inner_error_);
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 587 "backend.c"
	}
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->contact);
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->uid);
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 599 "backend.c"
	} else {
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 603 "backend.c"
	}
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 609 "backend.c"
}


static void eds_test_backend_remove_contact_data_free (gpointer _data) {
	EdsTestBackendRemoveContactData* _data_;
	_data_ = _data;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendRemoveContactData, _data_);
#line 620 "backend.c"
}


void eds_test_backend_remove_contact (EdsTestBackend* self, gint contact_pos, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendRemoveContactData* _data_;
	EdsTestBackend* _tmp0_;
	gint _tmp1_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendRemoveContactData);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_remove_contact);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_remove_contact_data_free);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = contact_pos;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->contact_pos = _tmp1_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	eds_test_backend_remove_contact_co (_data_);
#line 644 "backend.c"
}


void eds_test_backend_remove_contact_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendRemoveContactData* _data_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 652 "backend.c"
}


static void eds_test_backend_remove_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendRemoveContactData* _data_;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	eds_test_backend_remove_contact_co (_data_);
#line 666 "backend.c"
}


static gboolean eds_test_backend_remove_contact_co (EdsTestBackendRemoveContactData* _data_) {
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 0:
#line 675 "backend.c"
		goto _state_0;
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 1:
#line 679 "backend.c"
		goto _state_1;
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 2:
#line 683 "backend.c"
		goto _state_2;
		default:
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 688 "backend.c"
	}
	_state_0:
#line 83 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_e_contacts;
#line 83 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0__length1 = _data_->self->priv->_e_contacts_length1;
#line 83 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = _data_->contact_pos;
#line 83 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = _data_->_tmp0_[_data_->_tmp1_];
#line 83 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 83 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->uid = _data_->_tmp3_;
#line 703 "backend.c"
	{
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp4_ = _data_->self->priv->_addressbook;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp5_ = _data_->uid;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp6_ = NULL;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 1;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact (_data_->_tmp4_, _data_->_tmp5_, NULL, eds_test_backend_remove_contact_ready, _data_);
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 717 "backend.c"
		_state_1:
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->contact = _data_->_tmp6_;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 727 "backend.c"
			goto __catch1_g_error;
		}
#line 88 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = _data_->self->priv->_addressbook;
#line 88 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = _data_->contact;
#line 88 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 2;
#line 88 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_remove_contact (_data_->_tmp7_, _data_->_tmp8_, NULL, eds_test_backend_remove_contact_ready, _data_);
#line 88 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 740 "backend.c"
		_state_2:
#line 88 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_remove_contact_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 88 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 746 "backend.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->e = _data_->_inner_error_;
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_inner_error_ = NULL;
#line 92 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:92: Couldn't remove contact\n");
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (_data_->e);
#line 761 "backend.c"
	}
	__finally1:
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->uid);
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_data_->_inner_error_);
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 776 "backend.c"
	}
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->contact);
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->uid);
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 786 "backend.c"
	} else {
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 790 "backend.c"
	}
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 796 "backend.c"
}


void eds_test_backend_reset (EdsTestBackend* self) {
	gchar** _tmp0_ = NULL;
#line 96 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 98 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 98 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = NULL;
#line 99 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 99 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = (_vala_array_free (self->priv->_e_contacts, self->priv->_e_contacts_length1, (GDestroyNotify) g_free), NULL);
#line 99 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = _tmp0_;
#line 99 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts_length1 = 0;
#line 99 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->__e_contacts_size_ = self->priv->_e_contacts_length1;
#line 818 "backend.c"
}


void eds_test_backend_set_up (EdsTestBackend* self, gboolean source_is_default, const gchar* name) {
	GError * _inner_error_ = NULL;
#line 103 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 103 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (name != NULL);
#line 828 "backend.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gboolean _tmp2_;
		EBookClient* _tmp3_ = NULL;
		ESource* _tmp4_;
		EBookClient* _tmp5_;
		EBookClient* _tmp6_;
		const gchar* _tmp7_;
#line 108 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp0_ = name;
#line 108 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 108 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_free0 (self->priv->_addressbook_name);
#line 108 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook_name = _tmp1_;
#line 110 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp2_ = source_is_default;
#line 110 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_prepare_source (self, _tmp2_);
#line 111 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp4_ = self->priv->_source;
#line 111 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp5_ = e_book_client_new (_tmp4_, &_inner_error_);
#line 111 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp3_ = _tmp5_;
#line 111 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_inner_error_ != NULL) {
#line 858 "backend.c"
			goto __catch2_g_error;
		}
#line 111 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_addressbook);
#line 111 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook = _tmp3_;
#line 112 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp6_ = self->priv->_addressbook;
#line 112 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_client_open_sync ((EClient*) _tmp6_, FALSE, NULL, &_inner_error_);
#line 112 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_inner_error_ != NULL) {
#line 871 "backend.c"
			goto __catch2_g_error;
		}
#line 113 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp7_ = self->priv->_addressbook_name;
#line 113 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_setenv ("FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS", _tmp7_, TRUE);
#line 878 "backend.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 105 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 105 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 118 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp8_ = e;
#line 118 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp9_ = _tmp8_->message;
#line 118 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:118: Unable to create test data: %s\n", _tmp9_);
#line 105 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 898 "backend.c"
	}
	__finally2:
#line 105 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_inner_error_ != NULL) {
#line 105 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 105 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 105 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return;
#line 909 "backend.c"
	}
}


void eds_test_backend_set_as_default (EdsTestBackend* self) {
	ESourceRegistry* _tmp0_;
	ESource* _tmp1_;
#line 122 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 124 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = self->priv->_source_registry;
#line 124 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = self->priv->_source;
#line 124 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	e_source_registry_set_default_address_book (_tmp0_, _tmp1_);
#line 925 "backend.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return _data1_;
#line 934 "backend.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 943 "backend.c"
		EdsTestBackend * self;
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		self = _data1_->self;
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_main_loop_unref0 (_data1_->mainloop);
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_unref0 (self);
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_slice_free (Block1Data, _data1_);
#line 953 "backend.c"
	}
}


static void __lambda3_ (Block1Data* _data1_, GObject* obj, GAsyncResult* async_res) {
	EdsTestBackend * self;
	GError * _inner_error_ = NULL;
#line 131 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self = _data1_->self;
#line 131 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (async_res != NULL);
#line 965 "backend.c"
	{
		GAsyncResult* _tmp0_;
#line 135 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp0_ = async_res;
#line 135 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_prepare_source_finish (self, _tmp0_, &_inner_error_);
#line 135 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_inner_error_ != NULL) {
#line 974 "backend.c"
			goto __catch3_g_error;
		}
#line 136 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_main_loop_quit (_data1_->mainloop);
#line 979 "backend.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 133 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 133 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 140 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp1_ = e;
#line 140 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp2_ = _tmp1_->message;
#line 140 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_critical ("backend.vala:140: %s", _tmp2_);
#line 133 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 999 "backend.c"
	}
	__finally3:
#line 133 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_inner_error_ != NULL) {
#line 133 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 133 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 133 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return;
#line 1010 "backend.c"
	}
}


static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 131 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__lambda3_ (self, source_object, res);
#line 131 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	block1_data_unref (self);
#line 1020 "backend.c"
}


static void _eds_test_backend_prepare_source (EdsTestBackend* self, gboolean is_default) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
	gboolean _tmp1_;
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data1_->_ref_count_ = 1;
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data1_->self = eds_test_backend_ref (self);
#line 129 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 129 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data1_->mainloop = _tmp0_;
#line 131 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = is_default;
#line 131 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async (self, _tmp1_, ___lambda3__gasync_ready_callback, block1_data_ref (_data1_));
#line 144 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_main_loop_run (_data1_->mainloop);
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	block1_data_unref (_data1_);
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data1_ = NULL;
#line 1050 "backend.c"
}


static void _eds_test_backend_prepare_source_async_data_free (gpointer _data) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
	_data_ = _data;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendPrepareSourceAsyncData, _data_);
#line 1061 "backend.c"
}


static void _eds_test_backend_prepare_source_async (EdsTestBackend* self, gboolean is_default, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
	EdsTestBackend* _tmp0_;
	gboolean _tmp1_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendPrepareSourceAsyncData);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, _eds_test_backend_prepare_source_async);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _eds_test_backend_prepare_source_async_data_free);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = is_default;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->is_default = _tmp1_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async_co (_data_);
#line 1085 "backend.c"
}


static void _eds_test_backend_prepare_source_finish (EdsTestBackend* self, GAsyncResult* _res_, GError** error) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return;
#line 1095 "backend.c"
	}
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1099 "backend.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return _data2_;
#line 1108 "backend.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1117 "backend.c"
		EdsTestBackend * self;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		self = _data2_->self;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_unref0 (self);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_slice_free (Block2Data, _data2_);
#line 1125 "backend.c"
	}
}


static void _eds_test_backend_prepare_source_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async_co (_data_);
#line 1140 "backend.c"
}


static void __lambda2_ (Block2Data* _data2_, ESourceRegistry* r, ESource* s) {
	EdsTestBackend * self;
	ESource* _tmp0_;
	ESource* _tmp1_;
#line 167 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self = _data2_->self;
#line 167 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (r != NULL);
#line 167 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (s != NULL);
#line 169 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = s;
#line 169 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 169 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source);
#line 169 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_source = _tmp1_;
#line 170 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async_co (_data2_->_async_data_);
#line 1164 "backend.c"
}


static void ___lambda2__e_source_registry_source_added (ESourceRegistry* _sender, ESource* source, gpointer self) {
#line 167 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__lambda2_ (self, _sender, source);
#line 1171 "backend.c"
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
#line 1260 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1261 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1261 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1261 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1262 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1262 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1262 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1262 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1263 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1263 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1263 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1263 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1263 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1263 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 1215 "backend.c"
	}
#line 1263 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1263 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 1221 "backend.c"
}


static gboolean _eds_test_backend_prepare_source_async_co (EdsTestBackendPrepareSourceAsyncData* _data_) {
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 0:
#line 1230 "backend.c"
		goto _state_0;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 1:
#line 1234 "backend.c"
		goto _state_1;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 2:
#line 1238 "backend.c"
		goto _state_2;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 3:
#line 1242 "backend.c"
		goto _state_3;
		default:
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 1247 "backend.c"
	}
	_state_0:
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_data2_->self = eds_test_backend_ref (_data_->self);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 150 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_addressbook_name;
#line 150 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = g_strconcat (_data_->_tmp0_, ".source", NULL);
#line 150 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->source_file_name = _data_->_tmp1_;
#line 152 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = NULL;
#line 152 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = g_get_user_config_dir ();
#line 152 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = NULL;
#line 152 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_file_new_for_path (_data_->_tmp2_);
#line 152 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->config_dir = _data_->_tmp3_;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp4_ = _data_->config_dir;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp5_ = NULL;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp5_ = g_file_get_child (_data_->_tmp4_, "evolution");
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp7_ = NULL;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp7_ = g_file_get_child (_data_->_tmp6_, "sources");
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp9_ = _data_->source_file_name;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp10_ = NULL;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp10_ = g_file_get_child (_data_->_tmp8_, _data_->_tmp9_);
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->_tmp8_);
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->_tmp6_);
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->source_file = _data_->_tmp11_;
#line 156 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp12_ = _data_->self->priv->_addressbook_name;
#line 156 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp13_ = NULL;
#line 156 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp13_ = g_strdup_printf ("[Data Source]\n" "DisplayName=%s\n" "Enabled=true\n" "Parent=local-stub\n" "\n" "[Address Book]\n" "BackendName=local\n", _data_->_tmp12_);
#line 156 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->source_file_content = _data_->_tmp13_;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_state_ = 1;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	e_source_registry_new (NULL, _eds_test_backend_prepare_source_async_ready, _data_);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1316 "backend.c"
	_state_1:
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp14_ = NULL;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp14_ = e_source_registry_new_finish (_data_->_res_, &_data_->_inner_error_);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->source_registry = _data_->_tmp14_;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_error_free (_data_->_inner_error_);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_content);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->source_file);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->config_dir);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_name);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		block2_data_unref (_data_->_data2_);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_data2_ = NULL;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_data_->_state_ == 0) {
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1346 "backend.c"
		} else {
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1350 "backend.c"
		}
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_object_unref (_data_->_async_result);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1356 "backend.c"
	}
#line 166 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp15_ = _data_->source_registry;
#line 166 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp16_ = _g_object_ref0 (_data_->_tmp15_);
#line 166 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->self->priv->_source_registry);
#line 166 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_source_registry = _data_->_tmp16_;
#line 167 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp17_ = _data_->source_registry;
#line 167 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp18_ = 0UL;
#line 167 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp18_ = g_signal_connect_data (_data_->_tmp17_, "source-added", (GCallback) ___lambda2__e_source_registry_source_added, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
#line 167 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->signal_id = _data_->_tmp18_;
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp19_ = _data_->source_file;
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp20_ = _data_->source_file_content;
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp21_ = string_get_data (_data_->_tmp20_, &_data_->_tmp21__length1);
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp22_ = _data_->_tmp21_;
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp22__length1 = _data_->_tmp21__length1;
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_state_ = 2;
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_file_replace_contents_async (_data_->_tmp19_, _data_->_tmp22_, (gsize) _data_->_tmp22__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, _eds_test_backend_prepare_source_async_ready, _data_);
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1390 "backend.c"
	_state_2:
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_file_replace_contents_finish (_data_->_tmp19_, _data_->_res_, NULL, &_data_->_inner_error_);
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_error_free (_data_->_inner_error_);
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->source_registry);
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_content);
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->source_file);
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->config_dir);
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_name);
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		block2_data_unref (_data_->_data2_);
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_data2_ = NULL;
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_data_->_state_ == 0) {
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1418 "backend.c"
		} else {
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1422 "backend.c"
		}
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_object_unref (_data_->_async_result);
#line 174 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1428 "backend.c"
	}
#line 176 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp23_ = _data_->source_registry;
#line 176 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp24_ = _data_->self->priv->_addressbook_name;
#line 176 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp25_ = NULL;
#line 176 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp25_ = e_source_registry_ref_source (_data_->_tmp23_, _data_->_tmp24_);
#line 176 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->self->priv->_source);
#line 176 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_source = _data_->_tmp25_;
#line 177 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp26_ = _data_->self->priv->_source;
#line 177 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_tmp26_ == NULL) {
#line 179 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 3;
#line 179 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1450 "backend.c"
		_state_3:
		;
	}
#line 183 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp27_ = _data_->self->priv->_source;
#line 183 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_vala_assert (_data_->_tmp27_ != NULL, "this._source != null");
#line 184 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp28_ = _data_->source_registry;
#line 184 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp29_ = _data_->signal_id;
#line 184 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_signal_handler_disconnect ((GObject*) _data_->_tmp28_, _data_->_tmp29_);
#line 186 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp30_ = _data_->source_file;
#line 186 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp31_ = _g_object_ref0 (_data_->_tmp30_);
#line 186 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->self->priv->_source_file);
#line 186 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_source_file = _data_->_tmp31_;
#line 188 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp32_ = _data_->is_default;
#line 188 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_tmp32_) {
#line 190 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		eds_test_backend_set_as_default (_data_->self);
#line 1478 "backend.c"
	}
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->source_registry);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->source_file_content);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->source_file);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->config_dir);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->source_file_name);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	block2_data_unref (_data_->_data2_);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_data2_ = NULL;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1498 "backend.c"
	} else {
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1502 "backend.c"
	}
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1508 "backend.c"
}


static void eds_test_backend_commit_contacts_to_addressbook_data_free (gpointer _data) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	_data_ = _data;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendCommitContactsToAddressbookData, _data_);
#line 1519 "backend.c"
}


void eds_test_backend_commit_contacts_to_addressbook (EdsTestBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	EdsTestBackend* _tmp0_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendCommitContactsToAddressbookData);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_commit_contacts_to_addressbook);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_commit_contacts_to_addressbook_data_free);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook_co (_data_);
#line 1538 "backend.c"
}


void eds_test_backend_commit_contacts_to_addressbook_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1546 "backend.c"
}


static void eds_test_backend_commit_contacts_to_addressbook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook_co (_data_);
#line 1560 "backend.c"
}


static void _g_free0_ (gpointer var) {
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	var = (g_free (var), NULL);
#line 1567 "backend.c"
}


static void _g_slist_free__g_free0_ (GSList* self) {
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_slist_free (self);
#line 1576 "backend.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 216 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if ((*length) == (*size)) {
#line 216 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 216 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1587 "backend.c"
	}
#line 216 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	(*array)[(*length)++] = value;
#line 216 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	(*array)[*length] = NULL;
#line 1593 "backend.c"
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
#line 209 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 209 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_slist_free (self);
#line 1602 "backend.c"
}


static gboolean eds_test_backend_commit_contacts_to_addressbook_co (EdsTestBackendCommitContactsToAddressbookData* _data_) {
#line 194 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 194 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 0:
#line 1611 "backend.c"
		goto _state_0;
#line 194 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 1:
#line 1615 "backend.c"
		goto _state_1;
		default:
#line 194 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 1620 "backend.c"
	}
	_state_0:
#line 196 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->contacts = NULL;
#line 198 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_contacts = g_list_reverse (_data_->self->priv->_contacts);
#line 200 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_contacts;
#line 1629 "backend.c"
	{
#line 200 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->c_collection = _data_->_tmp0_;
#line 200 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		for (_data_->c_it = _data_->c_collection; _data_->c_it != NULL; _data_->c_it = _data_->c_it->next) {
#line 200 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_data_->_tmp1_ = _g_object_ref0 ((GeeHashMap*) _data_->c_it->data);
#line 200 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_data_->c = _data_->_tmp1_;
#line 1639 "backend.c"
			{
#line 202 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_data_->_tmp2_ = e_contact_new ();
#line 202 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_data_->contact = _data_->_tmp2_;
#line 204 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_data_->_tmp3_ = _data_->contact;
#line 204 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_data_->_tmp4_ = _data_->c;
#line 204 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_eds_test_backend_set_contact_fields (_data_->self, _data_->_tmp3_, _data_->_tmp4_);
#line 206 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_data_->_tmp5_ = _data_->contact;
#line 206 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
#line 206 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_data_->contacts = g_slist_prepend (_data_->contacts, _data_->_tmp6_);
#line 200 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_object_unref0 (_data_->contact);
#line 200 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_object_unref0 (_data_->c);
#line 1661 "backend.c"
			}
		}
	}
	{
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = _data_->self->priv->_addressbook;
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = _data_->contacts;
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp9_ = NULL;
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 1;
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_add_contacts (_data_->_tmp7_, _data_->_tmp8_, NULL, eds_test_backend_commit_contacts_to_addressbook_ready, _data_);
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1678 "backend.c"
		_state_1:
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_add_contacts_finish (_data_->_tmp7_, _data_->_res_, &_data_->_tmp9_, &_data_->_inner_error_);
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		__g_slist_free__g_free0_0 (_data_->uids);
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->uids = _data_->_tmp9_;
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 213 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			__g_slist_free__g_free0_0 (_data_->uids);
#line 1690 "backend.c"
			goto __catch4_g_error;
		}
		{
#line 215 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_data_->uid_collection = _data_->uids;
#line 215 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			for (_data_->uid_it = _data_->uid_collection; _data_->uid_it != NULL; _data_->uid_it = _data_->uid_it->next) {
#line 215 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_data_->uid = (const gchar*) _data_->uid_it->data;
#line 1700 "backend.c"
				{
#line 216 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->_tmp10_ = _data_->self->priv->_e_contacts;
#line 216 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->_tmp10__length1 = _data_->self->priv->_e_contacts_length1;
#line 216 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->_tmp11_ = _data_->uid;
#line 216 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
#line 216 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_vala_array_add1 (&_data_->self->priv->_e_contacts, &_data_->self->priv->_e_contacts_length1, &_data_->self->priv->__e_contacts_size_, _data_->_tmp12_);
#line 1712 "backend.c"
				}
			}
		}
#line 209 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		__g_slist_free__g_free0_0 (_data_->uids);
#line 1718 "backend.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
#line 209 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->e = _data_->_inner_error_;
#line 209 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_inner_error_ = NULL;
#line 220 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp13_ = _data_->e;
#line 220 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp14_ = _data_->_tmp13_->message;
#line 220 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:220: Couldn't add contacts: %s\n", _data_->_tmp14_);
#line 209 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (_data_->e);
#line 1735 "backend.c"
	}
	__finally4:
#line 209 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 209 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		__g_slist_free__g_object_unref0_0 (_data_->contacts);
#line 209 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 209 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_data_->_inner_error_);
#line 209 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1748 "backend.c"
	}
#line 194 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__g_slist_free__g_object_unref0_0 (_data_->contacts);
#line 194 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 194 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1756 "backend.c"
	} else {
#line 194 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1760 "backend.c"
	}
#line 194 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 194 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1766 "backend.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1190 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1191 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1191 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1191 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1192 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1192 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1801 "backend.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1193 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1193 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1193 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1810 "backend.c"
	}
#line 1195 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1195 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1816 "backend.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1196 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1196 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1196 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1825 "backend.c"
	}
#line 1198 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1198 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1831 "backend.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1198 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1198 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1198 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1840 "backend.c"
	} else {
#line 1198 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1844 "backend.c"
	}
#line 1198 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1198 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1199 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1199 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 1854 "backend.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1199 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1199 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1199 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 1863 "backend.c"
	} else {
#line 1199 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 1867 "backend.c"
	}
#line 1199 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1199 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1200 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1200 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1200 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1201 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1201 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1201 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1201 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1201 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1201 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 1891 "backend.c"
}


static void _vala_GValue_free (GValue* self) {
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_value_unset (self);
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_free (self);
#line 1900 "backend.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
#line 898 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 898 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 899 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 899 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 899 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 899 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 901 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 901 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1927 "backend.c"
		gchar* _tmp4_;
#line 902 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 902 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 902 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1935 "backend.c"
	} else {
#line 904 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		result = -1;
#line 904 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1941 "backend.c"
	}
}


static void _vala_EContactPhoto_free (EContactPhoto* self) {
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_photo_get_type (), self);
#line 1949 "backend.c"
}


static void _vala_EContactName_free (EContactName* self) {
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_name_get_type (), self);
#line 1956 "backend.c"
}


static void _vala_EContactAddress_free (EContactAddress* self) {
#line 303 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_address_get_type (), self);
#line 1963 "backend.c"
}


static void _eds_test_backend_set_contact_fields (EdsTestBackend* self, EContact* contact, GeeHashMap* c) {
	gboolean added_contact_name = FALSE;
	EContactName* contact_name = NULL;
	EContactName* _tmp0_;
	gchar* contact_field_name = NULL;
	gchar* _tmp1_;
	gint min_len = 0;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp199_;
	GError * _inner_error_ = NULL;
#line 225 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 225 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (contact != NULL);
#line 225 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (c != NULL);
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	added_contact_name = FALSE;
#line 229 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = e_contact_name_new ();
#line 229 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	contact_name = _tmp0_;
#line 230 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = g_strdup ("contact_name");
#line 230 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	contact_field_name = _tmp1_;
#line 231 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp2_ = contact_field_name;
#line 231 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp3_ = strlen (_tmp2_);
#line 231 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp4_ = _tmp3_;
#line 231 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	min_len = _tmp4_;
#line 2003 "backend.c"
	{
		GeeIterator* _k_it = NULL;
		GeeHashMap* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _tmp10_;
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp5_ = c;
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp7_ = _tmp6_;
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp8_ = _tmp7_;
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp10_ = _tmp9_;
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_tmp8_);
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_k_it = _tmp10_;
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		while (TRUE) {
#line 2030 "backend.c"
			GeeIterator* _tmp11_;
			gboolean _tmp12_ = FALSE;
			gchar* k = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
			const gchar* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gboolean _tmp25_;
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp11_ = _k_it;
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp12_ = gee_iterator_next (_tmp11_);
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			if (!_tmp12_) {
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				break;
#line 2050 "backend.c"
			}
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp13_ = _k_it;
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp14_ = gee_iterator_get (_tmp13_);
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			k = (gchar*) _tmp14_;
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp16_ = k;
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp17_ = strlen (_tmp16_);
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp18_ = _tmp17_;
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp19_ = min_len;
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			if (_tmp18_ > _tmp19_) {
#line 2068 "backend.c"
				const gchar* _tmp20_;
				gint _tmp21_;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				const gchar* _tmp24_;
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp20_ = k;
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp21_ = min_len;
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp22_ = string_slice (_tmp20_, (glong) 0, (glong) _tmp21_);
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp23_ = _tmp22_;
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp24_ = contact_field_name;
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp15_ = g_strcmp0 (_tmp23_, _tmp24_) == 0;
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp23_);
#line 2088 "backend.c"
			} else {
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp15_ = FALSE;
#line 2092 "backend.c"
			}
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp25_ = _tmp15_;
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			if (_tmp25_) {
#line 2098 "backend.c"
				gchar* v = NULL;
				GeeHashMap* _tmp26_;
				const gchar* _tmp27_;
				gpointer _tmp28_ = NULL;
				GValue* _tmp29_;
				GValue _tmp30_;
				const gchar* _tmp31_ = NULL;
				gchar* _tmp32_;
				gchar* _tmp33_;
				const gchar* _tmp34_;
				gint _tmp35_ = 0;
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp26_ = c;
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp27_ = k;
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp28_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp26_, _tmp27_);
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp29_ = (GValue*) _tmp28_;
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp30_ = *_tmp29_;
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp31_ = g_value_get_string (&_tmp30_);
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp32_ = g_strdup (_tmp31_);
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp33_ = _tmp32_;
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				__vala_GValue_free0 (_tmp29_);
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				v = _tmp33_;
#line 238 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp34_ = k;
#line 238 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp35_ = string_index_of (_tmp34_, "family", 0);
#line 238 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				if (_tmp35_ >= 0) {
#line 2136 "backend.c"
					EContactName* _tmp36_;
					const gchar* _tmp37_;
					gchar* _tmp38_;
#line 240 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp36_ = contact_name;
#line 240 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp37_ = v;
#line 240 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp38_ = g_strdup (_tmp37_);
#line 240 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_g_free0 (_tmp36_->family);
#line 240 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp36_->family = _tmp38_;
#line 2150 "backend.c"
				} else {
					const gchar* _tmp39_;
					gint _tmp40_ = 0;
#line 242 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp39_ = k;
#line 242 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp40_ = string_index_of (_tmp39_, "given", 0);
#line 242 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					if (_tmp40_ >= 0) {
#line 2160 "backend.c"
						EContactName* _tmp41_;
						const gchar* _tmp42_;
						gchar* _tmp43_;
#line 244 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp41_ = contact_name;
#line 244 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp42_ = v;
#line 244 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp43_ = g_strdup (_tmp42_);
#line 244 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_free0 (_tmp41_->given);
#line 244 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp41_->given = _tmp43_;
#line 2174 "backend.c"
					} else {
						const gchar* _tmp44_;
						gint _tmp45_ = 0;
#line 246 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp44_ = k;
#line 246 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp45_ = string_index_of (_tmp44_, "additional", 0);
#line 246 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						if (_tmp45_ >= 0) {
#line 2184 "backend.c"
							EContactName* _tmp46_;
							const gchar* _tmp47_;
							gchar* _tmp48_;
#line 248 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp46_ = contact_name;
#line 248 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp47_ = v;
#line 248 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp48_ = g_strdup (_tmp47_);
#line 248 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp46_->additional);
#line 248 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp46_->additional = _tmp48_;
#line 2198 "backend.c"
						} else {
							const gchar* _tmp49_;
							gint _tmp50_ = 0;
#line 250 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp49_ = k;
#line 250 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp50_ = string_index_of (_tmp49_, "prefixes", 0);
#line 250 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							if (_tmp50_ >= 0) {
#line 2208 "backend.c"
								EContactName* _tmp51_;
								const gchar* _tmp52_;
								gchar* _tmp53_;
#line 252 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp51_ = contact_name;
#line 252 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp52_ = v;
#line 252 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp53_ = g_strdup (_tmp52_);
#line 252 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp51_->prefixes);
#line 252 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp51_->prefixes = _tmp53_;
#line 2222 "backend.c"
							} else {
								const gchar* _tmp54_;
								gint _tmp55_ = 0;
#line 254 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp54_ = k;
#line 254 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp55_ = string_index_of (_tmp54_, "suffixes", 0);
#line 254 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								if (_tmp55_ >= 0) {
#line 2232 "backend.c"
									EContactName* _tmp56_;
									const gchar* _tmp57_;
									gchar* _tmp58_;
#line 256 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp56_ = contact_name;
#line 256 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp57_ = v;
#line 256 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp58_ = g_strdup (_tmp57_);
#line 256 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_g_free0 (_tmp56_->suffixes);
#line 256 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp56_->suffixes = _tmp58_;
#line 2246 "backend.c"
								}
							}
						}
					}
				}
#line 259 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				added_contact_name = TRUE;
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_free0 (v);
#line 2256 "backend.c"
			} else {
				const gchar* _tmp59_;
#line 261 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp59_ = k;
#line 261 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				if (g_strcmp0 (_tmp59_, "avatar") == 0) {
#line 2263 "backend.c"
					gchar* v = NULL;
					GeeHashMap* _tmp60_;
					const gchar* _tmp61_;
					gpointer _tmp62_ = NULL;
					GValue* _tmp63_;
					GValue _tmp64_;
					const gchar* _tmp65_ = NULL;
					gchar* _tmp66_;
					gchar* _tmp67_;
					guint8* photo_content = NULL;
					gint photo_content_length1 = 0;
					gint _photo_content_size_ = 0;
					GFile* file = NULL;
					const gchar* _tmp68_;
					GFile* _tmp69_ = NULL;
#line 263 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp60_ = c;
#line 263 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp61_ = k;
#line 263 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp62_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp60_, _tmp61_);
#line 263 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp63_ = (GValue*) _tmp62_;
#line 263 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp64_ = *_tmp63_;
#line 263 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp65_ = g_value_get_string (&_tmp64_);
#line 263 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp66_ = g_strdup (_tmp65_);
#line 263 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp67_ = _tmp66_;
#line 263 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					__vala_GValue_free0 (_tmp63_);
#line 263 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					v = _tmp67_;
#line 265 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp68_ = v;
#line 265 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp69_ = g_file_new_for_path (_tmp68_);
#line 265 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					file = _tmp69_;
#line 2305 "backend.c"
					{
						GFile* _tmp70_;
						guint8* _tmp71_ = NULL;
						gsize _tmp72_;
						EContactPhoto* cp = NULL;
						EContactPhoto* _tmp73_;
						EContactPhoto* _tmp74_;
						EContactPhoto* _tmp75_;
						guint8* _tmp76_;
						gint _tmp76__length1;
						EContact* _tmp77_;
						EContactField _tmp78_ = 0;
						EContactPhoto* _tmp79_;
#line 269 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp70_ = file;
#line 269 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						g_file_load_contents (_tmp70_, NULL, &_tmp71_, &_tmp72_, NULL, &_inner_error_);
#line 269 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						photo_content = (g_free (photo_content), NULL);
#line 269 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						photo_content = _tmp71_;
#line 269 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						photo_content_length1 = _tmp72_;
#line 269 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_photo_content_size_ = photo_content_length1;
#line 269 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						if (_inner_error_ != NULL) {
#line 2333 "backend.c"
							goto __catch5_g_error;
						}
#line 271 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp73_ = e_contact_photo_new ();
#line 271 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						cp = _tmp73_;
#line 272 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp74_ = cp;
#line 272 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp74_->type = E_CONTACT_PHOTO_TYPE_INLINED;
#line 273 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp75_ = cp;
#line 273 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp76_ = photo_content;
#line 273 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp76__length1 = photo_content_length1;
#line 273 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						e_contact_photo_set_inlined (_tmp75_, _tmp76_, (gsize) _tmp76__length1);
#line 275 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp77_ = contact;
#line 275 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp78_ = e_contact_field_id ("photo");
#line 275 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp79_ = cp;
#line 275 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						e_contact_set (_tmp77_, _tmp78_, _tmp79_);
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						__vala_EContactPhoto_free0 (cp);
#line 2362 "backend.c"
					}
					goto __finally5;
					__catch5_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp80_;
						GError* _tmp81_;
						const gchar* _tmp82_;
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						e = _inner_error_;
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_inner_error_ = NULL;
#line 279 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp80_ = v;
#line 279 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp81_ = e;
#line 279 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp82_ = _tmp81_->message;
#line 279 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						g_warning ("backend.vala:279: \n\nCan't load avatar %s: %s\n\n", _tmp80_, _tmp82_);
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_error_free0 (e);
#line 2385 "backend.c"
					}
					__finally5:
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					if (_inner_error_ != NULL) {
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_object_unref0 (file);
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						photo_content = (g_free (photo_content), NULL);
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_free0 (v);
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_free0 (k);
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_object_unref0 (_k_it);
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_free0 (contact_field_name);
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						__vala_EContactName_free0 (contact_name);
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						g_clear_error (&_inner_error_);
#line 267 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						return;
#line 2410 "backend.c"
					}
#line 261 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_g_object_unref0 (file);
#line 261 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					photo_content = (g_free (photo_content), NULL);
#line 261 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_g_free0 (v);
#line 2418 "backend.c"
				} else {
					const gchar* _tmp83_;
#line 283 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp83_ = k;
#line 283 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					if (g_strcmp0 (_tmp83_, "email_addresses") == 0) {
#line 2425 "backend.c"
						gchar* v = NULL;
						GeeHashMap* _tmp84_;
						const gchar* _tmp85_;
						gpointer _tmp86_ = NULL;
						GValue* _tmp87_;
						GValue _tmp88_;
						const gchar* _tmp89_ = NULL;
						gchar* _tmp90_;
						gchar* _tmp91_;
						gchar** addresses = NULL;
						const gchar* _tmp92_;
						gchar** _tmp93_;
						gchar** _tmp94_ = NULL;
						gint addresses_length1;
						gint _addresses_size_;
						gchar** _tmp95_;
						gint _tmp95__length1;
#line 285 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp84_ = c;
#line 285 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp85_ = k;
#line 285 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp86_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp84_, _tmp85_);
#line 285 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp87_ = (GValue*) _tmp86_;
#line 285 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp88_ = *_tmp87_;
#line 285 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp89_ = g_value_get_string (&_tmp88_);
#line 285 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp90_ = g_strdup (_tmp89_);
#line 285 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp91_ = _tmp90_;
#line 285 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						__vala_GValue_free0 (_tmp87_);
#line 285 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						v = _tmp91_;
#line 286 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp92_ = v;
#line 286 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp94_ = _tmp93_ = g_strsplit (_tmp92_, ",", 0);
#line 286 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						addresses = _tmp94_;
#line 286 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						addresses_length1 = _vala_array_length (_tmp93_);
#line 286 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_addresses_size_ = addresses_length1;
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp95_ = addresses;
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp95__length1 = addresses_length1;
#line 2477 "backend.c"
						{
							gchar** addr_collection = NULL;
							gint addr_collection_length1 = 0;
							gint _addr_collection_size_ = 0;
							gint addr_it = 0;
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							addr_collection = _tmp95_;
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							addr_collection_length1 = _tmp95__length1;
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							for (addr_it = 0; addr_it < _tmp95__length1; addr_it = addr_it + 1) {
#line 2489 "backend.c"
								gchar* _tmp96_;
								gchar* addr = NULL;
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp96_ = g_strdup (addr_collection[addr_it]);
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								addr = _tmp96_;
#line 2496 "backend.c"
								{
									EContact* _tmp97_;
									EContactField _tmp98_ = 0;
									const gchar* _tmp99_;
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp97_ = contact;
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp98_ = e_contact_field_id ("email");
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp99_ = addr;
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									e_contact_set (_tmp97_, _tmp98_, _tmp99_);
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_g_free0 (addr);
#line 2511 "backend.c"
								}
							}
						}
#line 283 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						addresses = (_vala_array_free (addresses, addresses_length1, (GDestroyNotify) g_free), NULL);
#line 283 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_free0 (v);
#line 2519 "backend.c"
					} else {
						const gchar* _tmp100_;
#line 293 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp100_ = k;
#line 293 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						if (g_strcmp0 (_tmp100_, "im_addresses") == 0) {
#line 2526 "backend.c"
							gchar* v = NULL;
							GeeHashMap* _tmp101_;
							const gchar* _tmp102_;
							gpointer _tmp103_ = NULL;
							GValue* _tmp104_;
							GValue _tmp105_;
							const gchar* _tmp106_ = NULL;
							gchar* _tmp107_;
							gchar* _tmp108_;
							GeeHashMap* addresses = NULL;
							const gchar* _tmp109_;
							GeeHashMap* _tmp110_ = NULL;
#line 295 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp101_ = c;
#line 295 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp102_ = k;
#line 295 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp103_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp101_, _tmp102_);
#line 295 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp104_ = (GValue*) _tmp103_;
#line 295 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp105_ = *_tmp104_;
#line 295 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp106_ = g_value_get_string (&_tmp105_);
#line 295 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp107_ = g_strdup (_tmp106_);
#line 295 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp108_ = _tmp107_;
#line 295 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							__vala_GValue_free0 (_tmp104_);
#line 295 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							v = _tmp108_;
#line 296 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp109_ = v;
#line 296 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp110_ = _eds_test_backend_parse_im_addrs (self, _tmp109_);
#line 296 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							addresses = _tmp110_;
#line 2565 "backend.c"
							{
								GeeIterator* _addr_it = NULL;
								GeeHashMap* _tmp111_;
								GeeSet* _tmp112_;
								GeeSet* _tmp113_;
								GeeSet* _tmp114_;
								GeeIterator* _tmp115_ = NULL;
								GeeIterator* _tmp116_;
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp111_ = addresses;
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp112_ = gee_abstract_map_get_keys ((GeeMap*) _tmp111_);
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp113_ = _tmp112_;
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp114_ = _tmp113_;
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp115_ = gee_iterable_iterator ((GeeIterable*) _tmp114_);
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp116_ = _tmp115_;
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (_tmp114_);
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_addr_it = _tmp116_;
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								while (TRUE) {
#line 2592 "backend.c"
									GeeIterator* _tmp117_;
									gboolean _tmp118_ = FALSE;
									gchar* addr = NULL;
									GeeIterator* _tmp119_;
									gpointer _tmp120_ = NULL;
									gchar* proto = NULL;
									GeeHashMap* _tmp121_;
									const gchar* _tmp122_;
									gpointer _tmp123_ = NULL;
									EContact* _tmp124_;
									const gchar* _tmp125_;
									EContactField _tmp126_ = 0;
									const gchar* _tmp127_;
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp117_ = _addr_it;
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp118_ = gee_iterator_next (_tmp117_);
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									if (!_tmp118_) {
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
										break;
#line 2614 "backend.c"
									}
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp119_ = _addr_it;
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp120_ = gee_iterator_get (_tmp119_);
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									addr = (gchar*) _tmp120_;
#line 299 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp121_ = addresses;
#line 299 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp122_ = addr;
#line 299 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp123_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp121_, _tmp122_);
#line 299 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									proto = (gchar*) _tmp123_;
#line 300 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp124_ = contact;
#line 300 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp125_ = proto;
#line 300 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp126_ = e_contact_field_id (_tmp125_);
#line 300 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp127_ = addr;
#line 300 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									e_contact_set (_tmp124_, _tmp126_, _tmp127_);
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_g_free0 (proto);
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_g_free0 (addr);
#line 2644 "backend.c"
								}
#line 297 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (_addr_it);
#line 2648 "backend.c"
							}
#line 293 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_g_object_unref0 (addresses);
#line 293 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_g_free0 (v);
#line 2654 "backend.c"
						} else {
							const gchar* _tmp128_;
							const gchar* _tmp129_;
#line 303 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp128_ = k;
#line 303 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp129_ = EDSF_PERSONA_address_fields[0];
#line 303 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							if (g_strcmp0 (_tmp128_, _tmp129_) == 0) {
#line 2664 "backend.c"
								FolksPostalAddressFieldDetails* pa_fd = NULL;
								GeeHashMap* _tmp130_;
								const gchar* _tmp131_;
								gpointer _tmp132_ = NULL;
								GValue* _tmp133_;
								GValue _tmp134_;
								GObject* _tmp135_ = NULL;
								FolksPostalAddressFieldDetails* _tmp136_;
								FolksPostalAddressFieldDetails* _tmp137_;
								FolksPostalAddress* pa = NULL;
								FolksPostalAddressFieldDetails* _tmp138_;
								gconstpointer _tmp139_;
								FolksPostalAddress* _tmp140_;
								FolksPostalAddress* _tmp141_;
								EContactAddress* address = NULL;
								EContactAddress* _tmp142_;
								EContactAddress* _tmp143_;
								FolksPostalAddress* _tmp144_;
								const gchar* _tmp145_;
								const gchar* _tmp146_;
								gchar* _tmp147_;
								EContactAddress* _tmp148_;
								FolksPostalAddress* _tmp149_;
								const gchar* _tmp150_;
								const gchar* _tmp151_;
								gchar* _tmp152_;
								EContactAddress* _tmp153_;
								FolksPostalAddress* _tmp154_;
								const gchar* _tmp155_;
								const gchar* _tmp156_;
								gchar* _tmp157_;
								EContactAddress* _tmp158_;
								FolksPostalAddress* _tmp159_;
								const gchar* _tmp160_;
								const gchar* _tmp161_;
								gchar* _tmp162_;
								EContactAddress* _tmp163_;
								FolksPostalAddress* _tmp164_;
								const gchar* _tmp165_;
								const gchar* _tmp166_;
								gchar* _tmp167_;
								EContactAddress* _tmp168_;
								FolksPostalAddress* _tmp169_;
								const gchar* _tmp170_;
								const gchar* _tmp171_;
								gchar* _tmp172_;
								EContactAddress* _tmp173_;
								FolksPostalAddress* _tmp174_;
								const gchar* _tmp175_;
								const gchar* _tmp176_;
								gchar* _tmp177_;
								EContactAddress* _tmp178_;
								FolksPostalAddress* _tmp179_;
								const gchar* _tmp180_;
								const gchar* _tmp181_;
								gchar* _tmp182_;
								EContact* _tmp183_;
								const gchar* _tmp184_;
								EContactField _tmp185_ = 0;
								EContactAddress* _tmp186_;
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp130_ = c;
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp131_ = k;
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp132_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp130_, _tmp131_);
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp133_ = (GValue*) _tmp132_;
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp134_ = *_tmp133_;
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp135_ = g_value_get_object (&_tmp134_);
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp136_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp135_, FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetails));
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp137_ = _tmp136_;
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								__vala_GValue_free0 (_tmp133_);
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								pa_fd = _tmp137_;
#line 306 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp138_ = pa_fd;
#line 306 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp139_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp138_);
#line 306 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp140_ = _tmp139_;
#line 306 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp141_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((FolksPostalAddress*) _tmp140_, FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddress));
#line 306 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								pa = _tmp141_;
#line 307 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp142_ = e_contact_address_new ();
#line 307 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								address = _tmp142_;
#line 308 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp143_ = address;
#line 308 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp144_ = pa;
#line 308 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp145_ = folks_postal_address_get_po_box (_tmp144_);
#line 308 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp146_ = _tmp145_;
#line 308 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp147_ = g_strdup (_tmp146_);
#line 308 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp143_->po);
#line 308 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp143_->po = _tmp147_;
#line 309 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp148_ = address;
#line 309 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp149_ = pa;
#line 309 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp150_ = folks_postal_address_get_extension (_tmp149_);
#line 309 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp151_ = _tmp150_;
#line 309 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp152_ = g_strdup (_tmp151_);
#line 309 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp148_->ext);
#line 309 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp148_->ext = _tmp152_;
#line 310 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp153_ = address;
#line 310 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp154_ = pa;
#line 310 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp155_ = folks_postal_address_get_street (_tmp154_);
#line 310 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp156_ = _tmp155_;
#line 310 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp157_ = g_strdup (_tmp156_);
#line 310 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp153_->street);
#line 310 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp153_->street = _tmp157_;
#line 311 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp158_ = address;
#line 311 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp159_ = pa;
#line 311 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp160_ = folks_postal_address_get_locality (_tmp159_);
#line 311 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp161_ = _tmp160_;
#line 311 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp162_ = g_strdup (_tmp161_);
#line 311 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp158_->locality);
#line 311 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp158_->locality = _tmp162_;
#line 312 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp163_ = address;
#line 312 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp164_ = pa;
#line 312 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp165_ = folks_postal_address_get_region (_tmp164_);
#line 312 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp166_ = _tmp165_;
#line 312 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp167_ = g_strdup (_tmp166_);
#line 312 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp163_->region);
#line 312 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp163_->region = _tmp167_;
#line 313 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp168_ = address;
#line 313 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp169_ = pa;
#line 313 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp170_ = folks_postal_address_get_postal_code (_tmp169_);
#line 313 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp171_ = _tmp170_;
#line 313 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp172_ = g_strdup (_tmp171_);
#line 313 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp168_->code);
#line 313 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp168_->code = _tmp172_;
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp173_ = address;
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp174_ = pa;
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp175_ = folks_postal_address_get_country (_tmp174_);
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp176_ = _tmp175_;
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp177_ = g_strdup (_tmp176_);
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp173_->country);
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp173_->country = _tmp177_;
#line 315 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp178_ = address;
#line 315 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp179_ = pa;
#line 315 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp180_ = folks_postal_address_get_address_format (_tmp179_);
#line 315 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp181_ = _tmp180_;
#line 315 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp182_ = g_strdup (_tmp181_);
#line 315 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp178_->address_format);
#line 315 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp178_->address_format = _tmp182_;
#line 317 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp183_ = contact;
#line 317 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp184_ = k;
#line 317 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp185_ = e_contact_field_id (_tmp184_);
#line 317 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp186_ = address;
#line 317 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								e_contact_set (_tmp183_, _tmp185_, _tmp186_);
#line 303 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								__vala_EContactAddress_free0 (address);
#line 303 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (pa);
#line 303 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (pa_fd);
#line 2887 "backend.c"
							} else {
								gchar* v = NULL;
								GeeHashMap* _tmp187_;
								const gchar* _tmp188_;
								gpointer _tmp189_ = NULL;
								GValue* _tmp190_;
								GValue _tmp191_;
								const gchar* _tmp192_ = NULL;
								gchar* _tmp193_;
								gchar* _tmp194_;
								EContact* _tmp195_;
								const gchar* _tmp196_;
								EContactField _tmp197_ = 0;
								const gchar* _tmp198_;
#line 321 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp187_ = c;
#line 321 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp188_ = k;
#line 321 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp189_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp187_, _tmp188_);
#line 321 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp190_ = (GValue*) _tmp189_;
#line 321 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp191_ = *_tmp190_;
#line 321 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp192_ = g_value_get_string (&_tmp191_);
#line 321 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp193_ = g_strdup (_tmp192_);
#line 321 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp194_ = _tmp193_;
#line 321 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								__vala_GValue_free0 (_tmp190_);
#line 321 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								v = _tmp194_;
#line 322 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp195_ = contact;
#line 322 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp196_ = k;
#line 322 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp197_ = e_contact_field_id (_tmp196_);
#line 322 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp198_ = v;
#line 322 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								e_contact_set (_tmp195_, _tmp197_, _tmp198_);
#line 303 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (v);
#line 2934 "backend.c"
							}
						}
					}
				}
			}
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_g_free0 (k);
#line 2942 "backend.c"
		}
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_k_it);
#line 2946 "backend.c"
	}
#line 325 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp199_ = added_contact_name;
#line 325 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_tmp199_) {
#line 2952 "backend.c"
		EContact* _tmp200_;
		EContactField _tmp201_ = 0;
		EContactName* _tmp202_;
#line 327 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp200_ = contact;
#line 327 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp201_ = e_contact_field_id ("name");
#line 327 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp202_ = contact_name;
#line 327 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_contact_set (_tmp200_, _tmp201_, _tmp202_);
#line 2964 "backend.c"
	}
#line 225 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_free0 (contact_field_name);
#line 225 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__vala_EContactName_free0 (contact_name);
#line 2970 "backend.c"
}


void eds_test_backend_tear_down (EdsTestBackend* self) {
	GError * _inner_error_ = NULL;
#line 331 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 333 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_setenv ("FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS", "", TRUE);
#line 2980 "backend.c"
	{
		GFile* _tmp0_;
#line 338 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp0_ = self->priv->_source_file;
#line 338 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_tmp0_ != NULL) {
#line 2987 "backend.c"
			GFile* _tmp1_;
#line 340 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp1_ = self->priv->_source_file;
#line 340 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			g_file_delete (_tmp1_, NULL, &_inner_error_);
#line 340 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			if (_inner_error_ != NULL) {
#line 2995 "backend.c"
				goto __catch6_g_error;
			}
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 336 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 336 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 345 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp2_ = self->priv->_addressbook_name;
#line 345 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp3_ = e;
#line 345 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp4_ = _tmp3_->message;
#line 345 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:345: Unable to remove addressbook ‘%s’: %s", _tmp2_, _tmp4_);
#line 336 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 3021 "backend.c"
	}
	__finally6:
	{
#line 350 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_source_file);
#line 350 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		self->priv->_source_file = NULL;
#line 351 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_source);
#line 351 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		self->priv->_source = NULL;
#line 352 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_addressbook);
#line 352 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook = NULL;
#line 353 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_source_registry);
#line 353 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		self->priv->_source_registry = NULL;
#line 3041 "backend.c"
	}
#line 336 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_inner_error_ != NULL) {
#line 336 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 336 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 336 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return;
#line 3051 "backend.c"
	}
}


static GeeHashMap* _eds_test_backend_parse_im_addrs (EdsTestBackend* self, const gchar* addr_str) {
	GeeHashMap* result = NULL;
	GeeHashMap* ret = NULL;
	GeeHashMap* _tmp0_;
	gchar** im_addrs = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gint im_addrs_length1;
	gint _im_addrs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
#line 357 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 357 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (addr_str != NULL, NULL);
#line 359 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 359 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	ret = _tmp0_;
#line 360 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = addr_str;
#line 360 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
#line 360 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	im_addrs = _tmp3_;
#line 360 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	im_addrs_length1 = _vala_array_length (_tmp2_);
#line 360 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_im_addrs_size_ = im_addrs_length1;
#line 362 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp4_ = im_addrs;
#line 362 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp4__length1 = im_addrs_length1;
#line 3090 "backend.c"
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
#line 362 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		a_collection = _tmp4_;
#line 362 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		a_collection_length1 = _tmp4__length1;
#line 362 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		for (a_it = 0; a_it < _tmp4__length1; a_it = a_it + 1) {
#line 3102 "backend.c"
			gchar* _tmp5_;
			gchar* a = NULL;
#line 362 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp5_ = g_strdup (a_collection[a_it]);
#line 362 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			a = _tmp5_;
#line 3109 "backend.c"
			{
				gchar** info = NULL;
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_ = NULL;
				gint info_length1;
				gint _info_size_;
				gchar* proto = NULL;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* addr = NULL;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				GeeHashMap* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
#line 364 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp6_ = a;
#line 364 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "#", 0);
#line 364 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				info = _tmp8_;
#line 364 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				info_length1 = _vala_array_length (_tmp7_);
#line 364 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_info_size_ = info_length1;
#line 365 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp9_ = info;
#line 365 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp9__length1 = info_length1;
#line 365 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp10_ = _tmp9_[0];
#line 365 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp11_ = g_strdup (_tmp10_);
#line 365 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				proto = _tmp11_;
#line 366 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp12_ = info;
#line 366 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp12__length1 = info_length1;
#line 366 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp13_ = _tmp12_[1];
#line 366 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp14_ = g_strdup (_tmp13_);
#line 366 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				addr = _tmp14_;
#line 368 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp15_ = ret;
#line 368 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp16_ = addr;
#line 368 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				addr = NULL;
#line 368 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp17_ = _tmp16_;
#line 368 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp18_ = proto;
#line 368 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				proto = NULL;
#line 368 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp19_ = _tmp18_;
#line 368 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp17_, _tmp19_);
#line 368 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp19_);
#line 368 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp17_);
#line 362 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_free0 (addr);
#line 362 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_free0 (proto);
#line 362 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 362 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_free0 (a);
#line 3190 "backend.c"
			}
		}
	}
#line 371 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	result = ret;
#line 371 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	im_addrs = (_vala_array_free (im_addrs, im_addrs_length1, (GDestroyNotify) g_free), NULL);
#line 371 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return result;
#line 3200 "backend.c"
}


const gchar* eds_test_backend_get_address_book_uid (EdsTestBackend* self) {
	const gchar* result;
	EBookClient* _tmp0_;
	ESource* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 50 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = self->priv->_addressbook;
#line 50 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = e_client_get_source ((EClient*) _tmp0_);
#line 50 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp2_ = e_source_get_uid (_tmp1_);
#line 50 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	result = _tmp2_;
#line 50 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return result;
#line 3221 "backend.c"
}


static void eds_test_value_backend_init (GValue* value) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	value->data[0].v_pointer = NULL;
#line 3228 "backend.c"
}


static void eds_test_value_backend_free_value (GValue* value) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (value->data[0].v_pointer) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (value->data[0].v_pointer);
#line 3237 "backend.c"
	}
}


static void eds_test_value_backend_copy_value (const GValue* src_value, GValue* dest_value) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (src_value->data[0].v_pointer) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		dest_value->data[0].v_pointer = eds_test_backend_ref (src_value->data[0].v_pointer);
#line 3247 "backend.c"
	} else {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3251 "backend.c"
	}
}


static gpointer eds_test_value_backend_peek_pointer (const GValue* value) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return value->data[0].v_pointer;
#line 3259 "backend.c"
}


static gchar* eds_test_value_backend_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (collect_values[0].v_pointer) {
#line 3266 "backend.c"
		EdsTestBackend* object;
		object = collect_values[0].v_pointer;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (object->parent_instance.g_class == NULL) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3273 "backend.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3277 "backend.c"
		}
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = eds_test_backend_ref (object);
#line 3281 "backend.c"
	} else {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3285 "backend.c"
	}
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return NULL;
#line 3289 "backend.c"
}


static gchar* eds_test_value_backend_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	EdsTestBackend** object_p;
	object_p = collect_values[0].v_pointer;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (!object_p) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3300 "backend.c"
	}
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (!value->data[0].v_pointer) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		*object_p = NULL;
#line 3306 "backend.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		*object_p = value->data[0].v_pointer;
#line 3310 "backend.c"
	} else {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		*object_p = eds_test_backend_ref (value->data[0].v_pointer);
#line 3314 "backend.c"
	}
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return NULL;
#line 3318 "backend.c"
}


GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	EdsTestParamSpecBackend* spec;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (g_type_is_a (object_type, EDS_TEST_TYPE_BACKEND), NULL);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return G_PARAM_SPEC (spec);
#line 3332 "backend.c"
}


gpointer eds_test_value_get_backend (const GValue* value) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND), NULL);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return value->data[0].v_pointer;
#line 3341 "backend.c"
}


void eds_test_value_set_backend (GValue* value, gpointer v_object) {
	EdsTestBackend* old;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND));
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (v_object) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDS_TEST_TYPE_BACKEND));
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = v_object;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		eds_test_backend_ref (value->data[0].v_pointer);
#line 3361 "backend.c"
	} else {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3365 "backend.c"
	}
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (old) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (old);
#line 3371 "backend.c"
	}
}


void eds_test_value_take_backend (GValue* value, gpointer v_object) {
	EdsTestBackend* old;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND));
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (v_object) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDS_TEST_TYPE_BACKEND));
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = v_object;
#line 3390 "backend.c"
	} else {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3394 "backend.c"
	}
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (old) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (old);
#line 3400 "backend.c"
	}
}


static void eds_test_backend_class_init (EdsTestBackendClass * klass) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	eds_test_backend_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	EDS_TEST_BACKEND_CLASS (klass)->finalize = eds_test_backend_finalize;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_type_class_add_private (klass, sizeof (EdsTestBackendPrivate));
#line 3412 "backend.c"
}


static void eds_test_backend_instance_init (EdsTestBackend * self) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv = EDS_TEST_BACKEND_GET_PRIVATE (self);
#line 41 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_addressbook = NULL;
#line 44 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_source_registry = NULL;
#line 45 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_source = NULL;
#line 46 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_source_file = NULL;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->ref_count = 1;
#line 3429 "backend.c"
}


static void eds_test_backend_finalize (EdsTestBackend* obj) {
	EdsTestBackend * self;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDS_TEST_TYPE_BACKEND, EdsTestBackend);
#line 40 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_free0 (self->priv->_addressbook_name);
#line 41 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_addressbook);
#line 42 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = (_vala_array_free (self->priv->_e_contacts, self->priv->_e_contacts_length1, (GDestroyNotify) g_free), NULL);
#line 43 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 44 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source_registry);
#line 45 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source);
#line 46 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source_file);
#line 3451 "backend.c"
}


GType eds_test_backend_get_type (void) {
	static volatile gsize eds_test_backend_type_id__volatile = 0;
	if (g_once_init_enter (&eds_test_backend_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { eds_test_value_backend_init, eds_test_value_backend_free_value, eds_test_value_backend_copy_value, eds_test_value_backend_peek_pointer, "p", eds_test_value_backend_collect_value, "p", eds_test_value_backend_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EdsTestBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) eds_test_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EdsTestBackend), 0, (GInstanceInitFunc) eds_test_backend_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType eds_test_backend_type_id;
		eds_test_backend_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EdsTestBackend", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&eds_test_backend_type_id__volatile, eds_test_backend_type_id);
	}
	return eds_test_backend_type_id__volatile;
}


gpointer eds_test_backend_ref (gpointer instance) {
	EdsTestBackend* self;
	self = instance;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&self->ref_count);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return instance;
#line 3476 "backend.c"
}


void eds_test_backend_unref (gpointer instance) {
	EdsTestBackend* self;
	self = instance;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		EDS_TEST_BACKEND_GET_CLASS (self)->finalize (self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3489 "backend.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



