#if 0
//
// FX Version: fx_4_0
// Child effect (requires effect pool): false
//
// 3 local buffer(s)
//
cbuffer cb0
{
    float4  QuadDesc;                   // Offset:    0, size:   16
    float4  TexCoords;                  // Offset:   16, size:   16
    float4  MaskTexCoords;              // Offset:   32, size:   16
    float4  TextColor;                  // Offset:   48, size:   16
}

cbuffer cb1
{
    float4  BlurOffsetsH[3];            // Offset:    0, size:   48
    float4  BlurOffsetsV[3];            // Offset:   48, size:   48
    float4  BlurWeights[3];             // Offset:   96, size:   48
    float4  ShadowColor;                // Offset:  144, size:   16
}

cbuffer cb2
{
    float3x3 DeviceSpaceToUserSpace;    // Offset:    0, size:   44
    float2  dimensions;                 // Offset:   48, size:    8
    float3  diff;                       // Offset:   64, size:   12
    float2  center1;                    // Offset:   80, size:    8
    float   A;                          // Offset:   88, size:    4
    float   radius1;                    // Offset:   92, size:    4
    float   sq_radius1;                 // Offset:   96, size:    4
}

//
// 11 local object(s)
//
Texture2D tex;
Texture2D mask;
SamplerState sSampler
{
    Filter   = uint(MIN_MAG_MIP_LINEAR /* 21 */);
    Texture  = tex;
    AddressU = uint(CLAMP /* 3 */);
    AddressV = uint(CLAMP /* 3 */);
};
SamplerState sWrapSampler
{
    Filter   = uint(MIN_MAG_MIP_LINEAR /* 21 */);
    Texture  = tex;
    AddressU = uint(WRAP /* 1 */);
    AddressV = uint(WRAP /* 1 */);
};
SamplerState sMirrorSampler
{
    Filter   = uint(MIN_MAG_MIP_LINEAR /* 21 */);
    Texture  = tex;
    AddressU = uint(MIRROR /* 2 */);
    AddressV = uint(MIRROR /* 2 */);
};
SamplerState sMaskSampler
{
    Filter   = uint(MIN_MAG_MIP_LINEAR /* 21 */);
    Texture  = mask;
    AddressU = uint(CLAMP /* 3 */);
    AddressV = uint(CLAMP /* 3 */);
};
SamplerState sShadowSampler
{
    Filter   = uint(MIN_MAG_MIP_LINEAR /* 21 */);
    Texture  = tex;
    AddressU = uint(BORDER /* 4 */);
    AddressV = uint(BORDER /* 4 */);
    BorderColor = float4(0, 0, 0, 0);
};
RasterizerState TextureRast
{
    ScissorEnable = bool(FALSE /* 0 */);
    CullMode = uint(NONE /* 1 */);
};
BlendState ShadowBlendH
{
    BlendEnable[0] = bool(FALSE /* 0 */);
    RenderTargetWriteMask[0] = byte(0x0f);
};
BlendState ShadowBlendV
{
    BlendEnable[0] = bool(TRUE /* 1 */);
    SrcBlend[0] = uint(ONE /* 2 */);
    DestBlend[0] = uint(INV_SRC_ALPHA /* 6 */);
    BlendOp[0] = uint(ADD /* 1 */);
    SrcBlendAlpha[0] = uint(ONE /* 2 */);
    DestBlendAlpha[0] = uint(INV_SRC_ALPHA /* 6 */);
    BlendOpAlpha[0] = uint(ADD /* 1 */);
    RenderTargetWriteMask[0] = byte(0x0f);
};
BlendState bTextBlend
{
    AlphaToCoverageEnable = bool(FALSE /* 0 */);
    BlendEnable[0] = bool(TRUE /* 1 */);
    SrcBlend[0] = uint(SRC1_COLOR /* 16 */);
    DestBlend[0] = uint(INV_SRC1_COLOR /* 17 */);
    BlendOp[0] = uint(ADD /* 1 */);
    SrcBlendAlpha[0] = uint(SRC1_ALPHA /* 18 */);
    DestBlendAlpha[0] = uint(INV_SRC1_ALPHA /* 19 */);
    BlendOpAlpha[0] = uint(ADD /* 1 */);
    RenderTargetWriteMask[0] = byte(0x0f);
};

//
// 5 technique(s)
//
technique10 SampleTexture
{
    pass P0
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // POSITION                 0   xyz         0     NONE  float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float   xyzw
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sSampler                          sampler      NA          NA    0        1
            // tex                               texture  float4          2d    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float       
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float       
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Target                0   xyzw        0   TARGET  float   xyzw
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                dcl t0
                dcl_2d s0
                texld r0, t0, s0
                mov oC0, r0
            
            // approximately 2 instruction slots used (1 texture, 1 arithmetic)
            ps_4_0
            dcl_sampler s0, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_input_ps linear v1.xy
            dcl_output o0.xyzw
            sample o0.xyzw, v1.xyxx, t0.xyzw, s0
            ret 
            // Approximately 2 instruction slots used
                    
        };
    }

}

technique10 SampleRadialGradient
{
    pass APos
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44
            //   float2 dimensions;                 // Offset:   48 Size:     8
            //   float3 diff;                       // Offset:   64 Size:    12 [unused]
            //   float2 center1;                    // Offset:   80 Size:     8 [unused]
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4 [unused]
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            // cb2                               cbuffer      NA          NA    1        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // POSITION                 0   xyz         0     NONE  float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float   xyzw
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         1  ( FLT, FLT, FLT, FLT)
            // c2         cb0             2         1  ( FLT, FLT, FLT, FLT)
            // c3         cb1             0         2  ( FLT, FLT, FLT, FLT)
            // c5         cb1             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c6, 1, 0.5, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad r0.xy, v0, c1.zwzw, c1
                add r0.z, r0.x, c6.x
                mul r0.z, r0.z, c5.x
                mul r1.x, r0.z, c6.y
                add r0.z, -r0.y, c6.x
                add oPos.xy, r0, c0
                mul r0.x, r0.z, c5.y
                mul r1.y, r0.x, c6.y
                mov r1.z, c6.x
                dp3 oT0.w, r1, c3
                dp3 oT0.z, r1, c4
                mov oPos.zw, c6.xyzx
            
            // approximately 13 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_constantbuffer cb1[4], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            dcl_temps 2
            mov o0.zw, l(0,0,0,1.000000)
            mad r0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.xy, r0.xyxx
            add r0.x, r0.x, l(1.000000)
            add r0.y, -r0.y, l(1.000000)
            mul r0.xy, r0.xyxx, cb1[3].xyxx
            mul r1.xy, r0.xyxx, l(0.500000, 0.500000, 0.000000, 0.000000)
            mov r1.z, l(1.000000)
            dp3 o1.z, r1.xyzx, cb1[0].xyzx
            dp3 o1.w, r1.xyzx, cb1[1].xyzx
            mad o1.xy, v0.xyxx, cb0[2].zwzz, cb0[2].xyxx
            ret 
            // Approximately 12 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44 [unused]
            //   float2 dimensions;                 // Offset:   48 Size:     8 [unused]
            //   float3 diff;                       // Offset:   64 Size:    12
            //   float2 center1;                    // Offset:   80 Size:     8
            //   float A;                           // Offset:   88 Size:     4
            //   float radius1;                     // Offset:   92 Size:     4
            //   float sq_radius1;                  // Offset:   96 Size:     4
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sSampler                          sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb2                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float       
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Target                0   xyzw        0   TARGET  float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             4         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c3, 0.5, 0, 0, 0
                def c4, 1, -1, 0, -0
                dcl t0
                dcl_2d s0
                dcl_2d s1
                add r0.xy, t0.wzzw, -c1
                dp2add r0.w, r0, r0, -c2.x
                mul r0.w, r0.w, c1.z
                mov r0.z, c1.w
                dp3 r0.x, r0, c0
                mad r0.y, r0.x, r0.x, -r0.w
                abs r0.z, r0.y
                rsq r0.z, r0.z
                rcp r1.x, r0.z
                mov r1.yz, -r1.x
                add r0.xzw, r0.x, r1.xyyz
                rcp r1.x, c1.z
                mul r0.xzw, r0, r1.x
                mov r1.w, c1.w
                mad r1.xyz, r0.xzww, c0.z, r1.w
                cmp r2.x, r1.x, r0.x, r0.w
                cmp r0.xzw, r1.xyyz, c4.xyxy, c4.zyzw
                mov r2.y, c3.x
                texld r1, t0, s1
                texld r2, r2, s0
                mul r2.xyz, r2.w, r2
                mul r1, r1.w, r2
                add r0.w, r0.w, r0.x
                cmp r0.x, r0.w, r0.x, r0.z
                cmp r1, -r0.x, c4.z, r1
                cmp r0, r0.y, r1, c4.z
                mov oC0, r0
            
            // approximately 28 instruction slots used (2 texture, 26 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[7], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 3
            add r0.xy, v1.zwzz, -cb0[5].xyxx
            mov r0.z, cb0[5].w
            dp3 r0.z, r0.xyzx, cb0[4].xyzx
            dp2 r0.x, r0.xyxx, r0.xyxx
            add r0.x, r0.x, -cb0[6].x
            mul r0.x, r0.x, cb0[5].z
            mad r0.x, r0.z, r0.z, -r0.x
            lt r0.y, r0.x, l(0.000000)
            sqrt r1.x, |r0.x|
            mov r1.y, -r1.x
            add r0.xz, r0.zzzz, r1.xxyx
            div r0.xz, r0.xxzx, cb0[5].zzzz
            mul r1.xy, r0.xzxx, cb0[4].zzzz
            ge r1.xy, r1.xyxx, -cb0[5].wwww
            and r1.xy, r1.xyxx, l(0x3f800000, 0x3f800000, 0, 0)
            add r0.x, -r0.z, r0.x
            mad r2.x, r1.x, r0.x, r0.z
            mov r2.y, l(0.500000)
            sample r2.xyzw, r2.xyxx, t0.xyzw, s0
            if_nz r0.y
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            max r0.x, r1.y, r1.x
            ge r0.x, l(0.000000), r0.x
            if_nz r0.x
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            mul r2.xyz, r2.wwww, r2.xyzx
            sample r0.xyzw, v1.xyxx, t1.xyzw, s1
            mul o0.xyzw, r0.wwww, r2.xyzw
            ret 
            // Approximately 33 instruction slots used
                    
        };
    }

    pass A0
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44
            //   float2 dimensions;                 // Offset:   48 Size:     8
            //   float3 diff;                       // Offset:   64 Size:    12 [unused]
            //   float2 center1;                    // Offset:   80 Size:     8 [unused]
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4 [unused]
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            // cb2                               cbuffer      NA          NA    1        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // POSITION                 0   xyz         0     NONE  float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float   xyzw
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         1  ( FLT, FLT, FLT, FLT)
            // c2         cb0             2         1  ( FLT, FLT, FLT, FLT)
            // c3         cb1             0         2  ( FLT, FLT, FLT, FLT)
            // c5         cb1             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c6, 1, 0.5, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad r0.xy, v0, c1.zwzw, c1
                add r0.z, r0.x, c6.x
                mul r0.z, r0.z, c5.x
                mul r1.x, r0.z, c6.y
                add r0.z, -r0.y, c6.x
                add oPos.xy, r0, c0
                mul r0.x, r0.z, c5.y
                mul r1.y, r0.x, c6.y
                mov r1.z, c6.x
                dp3 oT0.w, r1, c3
                dp3 oT0.z, r1, c4
                mov oPos.zw, c6.xyzx
            
            // approximately 13 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_constantbuffer cb1[4], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            dcl_temps 2
            mov o0.zw, l(0,0,0,1.000000)
            mad r0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.xy, r0.xyxx
            add r0.x, r0.x, l(1.000000)
            add r0.y, -r0.y, l(1.000000)
            mul r0.xy, r0.xyxx, cb1[3].xyxx
            mul r1.xy, r0.xyxx, l(0.500000, 0.500000, 0.000000, 0.000000)
            mov r1.z, l(1.000000)
            dp3 o1.z, r1.xyzx, cb1[0].xyzx
            dp3 o1.w, r1.xyzx, cb1[1].xyzx
            mad o1.xy, v0.xyxx, cb0[2].zwzz, cb0[2].xyxx
            ret 
            // Approximately 12 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44 [unused]
            //   float2 dimensions;                 // Offset:   48 Size:     8 [unused]
            //   float3 diff;                       // Offset:   64 Size:    12
            //   float2 center1;                    // Offset:   80 Size:     8
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sSampler                          sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb2                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float       
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Target                0   xyzw        0   TARGET  float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             4         2  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c2, 0.5, 0, 0, 0
                dcl t0
                dcl_2d s0
                dcl_2d s1
                mul r0.w, c1.w, c1.w
                add r0.xy, t0.wzzw, -c1
                dp2add r0.w, r0, r0, -r0.w
                mul r0.w, r0.w, c2.x
                mov r0.z, c1.w
                dp3 r0.x, r0, c0
                rcp r0.x, r0.x
                mul r0.x, r0.x, r0.w
                mov r0.y, c2.x
                texld r1, t0, s1
                texld r2, r0, s0
                mov r0.w, c1.w
                mad r0.x, r0.x, -c0.z, -r0.w
                mul r2.xyz, r2.w, r2
                mul r1, r1.w, r2
                cmp r0, r0.x, c2.y, r1
                mov oC0, r0
            
            // approximately 18 instruction slots used (2 texture, 16 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[6], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 2
            add r0.xy, v1.zwzz, -cb0[5].xyxx
            mov r0.z, cb0[5].w
            dp3 r0.z, r0.xyzx, cb0[4].xyzx
            dp2 r0.x, r0.xyxx, r0.xyxx
            mad r0.x, -cb0[5].w, cb0[5].w, r0.x
            mul r0.x, r0.x, l(0.500000)
            div r0.x, r0.x, r0.z
            mul r0.z, r0.x, cb0[4].z
            ge r0.z, -cb0[5].w, r0.z
            mov r0.y, l(0.500000)
            sample r1.xyzw, r0.xyxx, t0.xyzw, s0
            if_nz r0.z
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            mul r1.xyz, r1.wwww, r1.xyzx
            sample r0.xyzw, v1.xyxx, t1.xyzw, s1
            mul o0.xyzw, r0.wwww, r1.xyzw
            ret 
            // Approximately 19 instruction slots used
                    
        };
    }

    pass APosWrap
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44
            //   float2 dimensions;                 // Offset:   48 Size:     8
            //   float3 diff;                       // Offset:   64 Size:    12 [unused]
            //   float2 center1;                    // Offset:   80 Size:     8 [unused]
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4 [unused]
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            // cb2                               cbuffer      NA          NA    1        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // POSITION                 0   xyz         0     NONE  float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float   xyzw
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         1  ( FLT, FLT, FLT, FLT)
            // c2         cb0             2         1  ( FLT, FLT, FLT, FLT)
            // c3         cb1             0         2  ( FLT, FLT, FLT, FLT)
            // c5         cb1             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c6, 1, 0.5, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad r0.xy, v0, c1.zwzw, c1
                add r0.z, r0.x, c6.x
                mul r0.z, r0.z, c5.x
                mul r1.x, r0.z, c6.y
                add r0.z, -r0.y, c6.x
                add oPos.xy, r0, c0
                mul r0.x, r0.z, c5.y
                mul r1.y, r0.x, c6.y
                mov r1.z, c6.x
                dp3 oT0.w, r1, c3
                dp3 oT0.z, r1, c4
                mov oPos.zw, c6.xyzx
            
            // approximately 13 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_constantbuffer cb1[4], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            dcl_temps 2
            mov o0.zw, l(0,0,0,1.000000)
            mad r0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.xy, r0.xyxx
            add r0.x, r0.x, l(1.000000)
            add r0.y, -r0.y, l(1.000000)
            mul r0.xy, r0.xyxx, cb1[3].xyxx
            mul r1.xy, r0.xyxx, l(0.500000, 0.500000, 0.000000, 0.000000)
            mov r1.z, l(1.000000)
            dp3 o1.z, r1.xyzx, cb1[0].xyzx
            dp3 o1.w, r1.xyzx, cb1[1].xyzx
            mad o1.xy, v0.xyxx, cb0[2].zwzz, cb0[2].xyxx
            ret 
            // Approximately 12 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44 [unused]
            //   float2 dimensions;                 // Offset:   48 Size:     8 [unused]
            //   float3 diff;                       // Offset:   64 Size:    12
            //   float2 center1;                    // Offset:   80 Size:     8
            //   float A;                           // Offset:   88 Size:     4
            //   float radius1;                     // Offset:   92 Size:     4
            //   float sq_radius1;                  // Offset:   96 Size:     4
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sWrapSampler                      sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb2                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float       
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Target                0   xyzw        0   TARGET  float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             4         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c3, 0.5, 0, 0, 0
                def c4, 1, -1, 0, -0
                dcl t0
                dcl_2d s0
                dcl_2d s1
                add r0.xy, t0.wzzw, -c1
                dp2add r0.w, r0, r0, -c2.x
                mul r0.w, r0.w, c1.z
                mov r0.z, c1.w
                dp3 r0.x, r0, c0
                mad r0.y, r0.x, r0.x, -r0.w
                abs r0.z, r0.y
                rsq r0.z, r0.z
                rcp r1.x, r0.z
                mov r1.yz, -r1.x
                add r0.xzw, r0.x, r1.xyyz
                rcp r1.x, c1.z
                mul r0.xzw, r0, r1.x
                mov r1.w, c1.w
                mad r1.xyz, r0.xzww, c0.z, r1.w
                cmp r2.x, r1.x, r0.x, r0.w
                cmp r0.xzw, r1.xyyz, c4.xyxy, c4.zyzw
                mov r2.y, c3.x
                texld r1, t0, s1
                texld r2, r2, s0
                mul r2.xyz, r2.w, r2
                mul r1, r1.w, r2
                add r0.w, r0.w, r0.x
                cmp r0.x, r0.w, r0.x, r0.z
                cmp r1, -r0.x, c4.z, r1
                cmp r0, r0.y, r1, c4.z
                mov oC0, r0
            
            // approximately 28 instruction slots used (2 texture, 26 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[7], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 3
            add r0.xy, v1.zwzz, -cb0[5].xyxx
            mov r0.z, cb0[5].w
            dp3 r0.z, r0.xyzx, cb0[4].xyzx
            dp2 r0.x, r0.xyxx, r0.xyxx
            add r0.x, r0.x, -cb0[6].x
            mul r0.x, r0.x, cb0[5].z
            mad r0.x, r0.z, r0.z, -r0.x
            lt r0.y, r0.x, l(0.000000)
            sqrt r1.x, |r0.x|
            mov r1.y, -r1.x
            add r0.xz, r0.zzzz, r1.xxyx
            div r0.xz, r0.xxzx, cb0[5].zzzz
            mul r1.xy, r0.xzxx, cb0[4].zzzz
            ge r1.xy, r1.xyxx, -cb0[5].wwww
            and r1.xy, r1.xyxx, l(0x3f800000, 0x3f800000, 0, 0)
            add r0.x, -r0.z, r0.x
            mad r2.x, r1.x, r0.x, r0.z
            mov r2.y, l(0.500000)
            sample r2.xyzw, r2.xyxx, t0.xyzw, s0
            if_nz r0.y
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            max r0.x, r1.y, r1.x
            ge r0.x, l(0.000000), r0.x
            if_nz r0.x
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            mul r2.xyz, r2.wwww, r2.xyzx
            sample r0.xyzw, v1.xyxx, t1.xyzw, s1
            mul o0.xyzw, r0.wwww, r2.xyzw
            ret 
            // Approximately 33 instruction slots used
                    
        };
    }

    pass A0Wrap
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44
            //   float2 dimensions;                 // Offset:   48 Size:     8
            //   float3 diff;                       // Offset:   64 Size:    12 [unused]
            //   float2 center1;                    // Offset:   80 Size:     8 [unused]
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4 [unused]
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            // cb2                               cbuffer      NA          NA    1        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // POSITION                 0   xyz         0     NONE  float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float   xyzw
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         1  ( FLT, FLT, FLT, FLT)
            // c2         cb0             2         1  ( FLT, FLT, FLT, FLT)
            // c3         cb1             0         2  ( FLT, FLT, FLT, FLT)
            // c5         cb1             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c6, 1, 0.5, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad r0.xy, v0, c1.zwzw, c1
                add r0.z, r0.x, c6.x
                mul r0.z, r0.z, c5.x
                mul r1.x, r0.z, c6.y
                add r0.z, -r0.y, c6.x
                add oPos.xy, r0, c0
                mul r0.x, r0.z, c5.y
                mul r1.y, r0.x, c6.y
                mov r1.z, c6.x
                dp3 oT0.w, r1, c3
                dp3 oT0.z, r1, c4
                mov oPos.zw, c6.xyzx
            
            // approximately 13 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_constantbuffer cb1[4], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            dcl_temps 2
            mov o0.zw, l(0,0,0,1.000000)
            mad r0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.xy, r0.xyxx
            add r0.x, r0.x, l(1.000000)
            add r0.y, -r0.y, l(1.000000)
            mul r0.xy, r0.xyxx, cb1[3].xyxx
            mul r1.xy, r0.xyxx, l(0.500000, 0.500000, 0.000000, 0.000000)
            mov r1.z, l(1.000000)
            dp3 o1.z, r1.xyzx, cb1[0].xyzx
            dp3 o1.w, r1.xyzx, cb1[1].xyzx
            mad o1.xy, v0.xyxx, cb0[2].zwzz, cb0[2].xyxx
            ret 
            // Approximately 12 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44 [unused]
            //   float2 dimensions;                 // Offset:   48 Size:     8 [unused]
            //   float3 diff;                       // Offset:   64 Size:    12
            //   float2 center1;                    // Offset:   80 Size:     8
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sWrapSampler                      sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb2                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float       
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Target                0   xyzw        0   TARGET  float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             4         2  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c2, 0.5, 0, 0, 0
                dcl t0
                dcl_2d s0
                dcl_2d s1
                mul r0.w, c1.w, c1.w
                add r0.xy, t0.wzzw, -c1
                dp2add r0.w, r0, r0, -r0.w
                mul r0.w, r0.w, c2.x
                mov r0.z, c1.w
                dp3 r0.x, r0, c0
                rcp r0.x, r0.x
                mul r0.x, r0.x, r0.w
                mov r0.y, c2.x
                texld r1, t0, s1
                texld r2, r0, s0
                mov r0.w, c1.w
                mad r0.x, r0.x, -c0.z, -r0.w
                mul r2.xyz, r2.w, r2
                mul r1, r1.w, r2
                cmp r0, r0.x, c2.y, r1
                mov oC0, r0
            
            // approximately 18 instruction slots used (2 texture, 16 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[6], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 2
            add r0.xy, v1.zwzz, -cb0[5].xyxx
            mov r0.z, cb0[5].w
            dp3 r0.z, r0.xyzx, cb0[4].xyzx
            dp2 r0.x, r0.xyxx, r0.xyxx
            mad r0.x, -cb0[5].w, cb0[5].w, r0.x
            mul r0.x, r0.x, l(0.500000)
            div r0.x, r0.x, r0.z
            mul r0.z, r0.x, cb0[4].z
            ge r0.z, -cb0[5].w, r0.z
            mov r0.y, l(0.500000)
            sample r1.xyzw, r0.xyxx, t0.xyzw, s0
            if_nz r0.z
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            mul r1.xyz, r1.wwww, r1.xyzx
            sample r0.xyzw, v1.xyxx, t1.xyzw, s1
            mul o0.xyzw, r0.wwww, r1.xyzw
            ret 
            // Approximately 19 instruction slots used
                    
        };
    }

    pass APosMirror
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44
            //   float2 dimensions;                 // Offset:   48 Size:     8
            //   float3 diff;                       // Offset:   64 Size:    12 [unused]
            //   float2 center1;                    // Offset:   80 Size:     8 [unused]
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4 [unused]
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            // cb2                               cbuffer      NA          NA    1        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // POSITION                 0   xyz         0     NONE  float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float   xyzw
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         1  ( FLT, FLT, FLT, FLT)
            // c2         cb0             2         1  ( FLT, FLT, FLT, FLT)
            // c3         cb1             0         2  ( FLT, FLT, FLT, FLT)
            // c5         cb1             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c6, 1, 0.5, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad r0.xy, v0, c1.zwzw, c1
                add r0.z, r0.x, c6.x
                mul r0.z, r0.z, c5.x
                mul r1.x, r0.z, c6.y
                add r0.z, -r0.y, c6.x
                add oPos.xy, r0, c0
                mul r0.x, r0.z, c5.y
                mul r1.y, r0.x, c6.y
                mov r1.z, c6.x
                dp3 oT0.w, r1, c3
                dp3 oT0.z, r1, c4
                mov oPos.zw, c6.xyzx
            
            // approximately 13 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_constantbuffer cb1[4], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            dcl_temps 2
            mov o0.zw, l(0,0,0,1.000000)
            mad r0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.xy, r0.xyxx
            add r0.x, r0.x, l(1.000000)
            add r0.y, -r0.y, l(1.000000)
            mul r0.xy, r0.xyxx, cb1[3].xyxx
            mul r1.xy, r0.xyxx, l(0.500000, 0.500000, 0.000000, 0.000000)
            mov r1.z, l(1.000000)
            dp3 o1.z, r1.xyzx, cb1[0].xyzx
            dp3 o1.w, r1.xyzx, cb1[1].xyzx
            mad o1.xy, v0.xyxx, cb0[2].zwzz, cb0[2].xyxx
            ret 
            // Approximately 12 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44 [unused]
            //   float2 dimensions;                 // Offset:   48 Size:     8 [unused]
            //   float3 diff;                       // Offset:   64 Size:    12
            //   float2 center1;                    // Offset:   80 Size:     8
            //   float A;                           // Offset:   88 Size:     4
            //   float radius1;                     // Offset:   92 Size:     4
            //   float sq_radius1;                  // Offset:   96 Size:     4
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sMirrorSampler                    sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb2                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float       
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Target                0   xyzw        0   TARGET  float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             4         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c3, 0.5, 0, 0, 0
                def c4, 1, -1, 0, -0
                dcl t0
                dcl_2d s0
                dcl_2d s1
                add r0.xy, t0.wzzw, -c1
                dp2add r0.w, r0, r0, -c2.x
                mul r0.w, r0.w, c1.z
                mov r0.z, c1.w
                dp3 r0.x, r0, c0
                mad r0.y, r0.x, r0.x, -r0.w
                abs r0.z, r0.y
                rsq r0.z, r0.z
                rcp r1.x, r0.z
                mov r1.yz, -r1.x
                add r0.xzw, r0.x, r1.xyyz
                rcp r1.x, c1.z
                mul r0.xzw, r0, r1.x
                mov r1.w, c1.w
                mad r1.xyz, r0.xzww, c0.z, r1.w
                cmp r2.x, r1.x, r0.x, r0.w
                cmp r0.xzw, r1.xyyz, c4.xyxy, c4.zyzw
                mov r2.y, c3.x
                texld r1, t0, s1
                texld r2, r2, s0
                mul r2.xyz, r2.w, r2
                mul r1, r1.w, r2
                add r0.w, r0.w, r0.x
                cmp r0.x, r0.w, r0.x, r0.z
                cmp r1, -r0.x, c4.z, r1
                cmp r0, r0.y, r1, c4.z
                mov oC0, r0
            
            // approximately 28 instruction slots used (2 texture, 26 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[7], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 3
            add r0.xy, v1.zwzz, -cb0[5].xyxx
            mov r0.z, cb0[5].w
            dp3 r0.z, r0.xyzx, cb0[4].xyzx
            dp2 r0.x, r0.xyxx, r0.xyxx
            add r0.x, r0.x, -cb0[6].x
            mul r0.x, r0.x, cb0[5].z
            mad r0.x, r0.z, r0.z, -r0.x
            lt r0.y, r0.x, l(0.000000)
            sqrt r1.x, |r0.x|
            mov r1.y, -r1.x
            add r0.xz, r0.zzzz, r1.xxyx
            div r0.xz, r0.xxzx, cb0[5].zzzz
            mul r1.xy, r0.xzxx, cb0[4].zzzz
            ge r1.xy, r1.xyxx, -cb0[5].wwww
            and r1.xy, r1.xyxx, l(0x3f800000, 0x3f800000, 0, 0)
            add r0.x, -r0.z, r0.x
            mad r2.x, r1.x, r0.x, r0.z
            mov r2.y, l(0.500000)
            sample r2.xyzw, r2.xyxx, t0.xyzw, s0
            if_nz r0.y
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            max r0.x, r1.y, r1.x
            ge r0.x, l(0.000000), r0.x
            if_nz r0.x
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            mul r2.xyz, r2.wwww, r2.xyzx
            sample r0.xyzw, v1.xyxx, t1.xyzw, s1
            mul o0.xyzw, r0.wwww, r2.xyzw
            ret 
            // Approximately 33 instruction slots used
                    
        };
    }

    pass A0Mirror
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44
            //   float2 dimensions;                 // Offset:   48 Size:     8
            //   float3 diff;                       // Offset:   64 Size:    12 [unused]
            //   float2 center1;                    // Offset:   80 Size:     8 [unused]
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4 [unused]
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            // cb2                               cbuffer      NA          NA    1        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // POSITION                 0   xyz         0     NONE  float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float   xyzw
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         1  ( FLT, FLT, FLT, FLT)
            // c2         cb0             2         1  ( FLT, FLT, FLT, FLT)
            // c3         cb1             0         2  ( FLT, FLT, FLT, FLT)
            // c5         cb1             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c6, 1, 0.5, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad r0.xy, v0, c1.zwzw, c1
                add r0.z, r0.x, c6.x
                mul r0.z, r0.z, c5.x
                mul r1.x, r0.z, c6.y
                add r0.z, -r0.y, c6.x
                add oPos.xy, r0, c0
                mul r0.x, r0.z, c5.y
                mul r1.y, r0.x, c6.y
                mov r1.z, c6.x
                dp3 oT0.w, r1, c3
                dp3 oT0.z, r1, c4
                mov oPos.zw, c6.xyzx
            
            // approximately 13 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_constantbuffer cb1[4], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            dcl_temps 2
            mov o0.zw, l(0,0,0,1.000000)
            mad r0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.xy, r0.xyxx
            add r0.x, r0.x, l(1.000000)
            add r0.y, -r0.y, l(1.000000)
            mul r0.xy, r0.xyxx, cb1[3].xyxx
            mul r1.xy, r0.xyxx, l(0.500000, 0.500000, 0.000000, 0.000000)
            mov r1.z, l(1.000000)
            dp3 o1.z, r1.xyzx, cb1[0].xyzx
            dp3 o1.w, r1.xyzx, cb1[1].xyzx
            mad o1.xy, v0.xyxx, cb0[2].zwzz, cb0[2].xyxx
            ret 
            // Approximately 12 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44 [unused]
            //   float2 dimensions;                 // Offset:   48 Size:     8 [unused]
            //   float3 diff;                       // Offset:   64 Size:    12
            //   float2 center1;                    // Offset:   80 Size:     8
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sMirrorSampler                    sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb2                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float       
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Target                0   xyzw        0   TARGET  float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             4         2  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c2, 0.5, 0, 0, 0
                dcl t0
                dcl_2d s0
                dcl_2d s1
                mul r0.w, c1.w, c1.w
                add r0.xy, t0.wzzw, -c1
                dp2add r0.w, r0, r0, -r0.w
                mul r0.w, r0.w, c2.x
                mov r0.z, c1.w
                dp3 r0.x, r0, c0
                rcp r0.x, r0.x
                mul r0.x, r0.x, r0.w
                mov r0.y, c2.x
                texld r1, t0, s1
                texld r2, r0, s0
                mov r0.w, c1.w
                mad r0.x, r0.x, -c0.z, -r0.w
                mul r2.xyz, r2.w, r2
                mul r1, r1.w, r2
                cmp r0, r0.x, c2.y, r1
                mov oC0, r0
            
            // approximately 18 instruction slots used (2 texture, 16 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[6], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 2
            add r0.xy, v1.zwzz, -cb0[5].xyxx
            mov r0.z, cb0[5].w
            dp3 r0.z, r0.xyzx, cb0[4].xyzx
            dp2 r0.x, r0.xyxx, r0.xyxx
            mad r0.x, -cb0[5].w, cb0[5].w, r0.x
            mul r0.x, r0.x, l(0.500000)
            div r0.x, r0.x, r0.z
            mul r0.z, r0.x, cb0[4].z
            ge r0.z, -cb0[5].w, r0.z
            mov r0.y, l(0.500000)
            sample r1.xyzw, r0.xyxx, t0.xyzw, s0
            if_nz r0.z
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            mul r1.xyz, r1.wwww, r1.xyzx
            sample r0.xyzw, v1.xyxx, t1.xyzw, s1
            mul o0.xyzw, r0.wwww, r1.xyzw
            ret 
            // Approximately 19 instruction slots used
                    
        };
    }

}

technique10 SampleMaskedTexture
{
    pass P0
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // POSITION                 0   xyz         0     NONE  float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float   xyzw
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sSampler                          sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float       
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Target                0   xyzw        0   TARGET  float   xyzw
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                dcl t0
                dcl_2d s0
                dcl_2d s1
                mov r0.xy, t0.wzzw
                texld r1, t0, s0
                texld r0, r0, s1
                mul r0, r0.w, r1
                mov oC0, r0
            
            // approximately 5 instruction slots used (2 texture, 3 arithmetic)
            ps_4_0
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 2
            sample r0.xyzw, v1.xyxx, t0.xyzw, s0
            sample r1.xyzw, v1.zwzz, t1.xyzw, s1
            mul o0.xyzw, r0.xyzw, r1.wwww
            ret 
            // Approximately 4 instruction slots used
                    
        };
    }

}

technique10 SampleTextureWithShadow
{
    pass P0
    {
        RasterizerState = TextureRast;
        AB_BlendFactor = float4(1, 1, 1, 1);
        AB_SampleMask = uint(0xffffffff);
        BlendState = ShadowBlendH;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // POSITION                 0   xyz         0     NONE  float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float   xyzw
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb1
            // {
            //
            //   float4 BlurOffsetsH[3];            // Offset:    0 Size:    48
            //   float4 BlurOffsetsV[3];            // Offset:   48 Size:    48 [unused]
            //   float4 BlurWeights[3];             // Offset:   96 Size:    48
            //   float4 ShadowColor;                // Offset:  144 Size:    16
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sShadowSampler                    sampler      NA          NA    0        1
            // tex                               texture  float4          2d    0        1
            // cb1                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float       
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float       
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Target                0   xyzw        0   TARGET  float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             0         3  ( FLT, FLT, FLT, FLT)
            // c3         cb0             6         4  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                dcl t0
                dcl_2d s0
                add r0.x, t0.x, c0.y
                mov r0.y, t0.y
                add r1.x, t0.x, c0.x
                mov r1.y, t0.y
                texld r0, r0, s0
                texld r1, r1, s0
                mul r0.x, r0.w, c3.y
                mad r0.x, c3.x, r1.w, r0.x
                add r1.x, t0.x, c0.z
                mov r1.y, t0.y
                add r2.x, t0.x, c0.w
                mov r2.y, t0.y
                texld r1, r1, s0
                texld r2, r2, s0
                mad r0.x, c3.z, r1.w, r0.x
                mad r0.x, c3.w, r2.w, r0.x
                add r1.x, t0.x, c1.x
                mov r1.y, t0.y
                add r2.x, t0.x, c1.y
                mov r2.y, t0.y
                texld r1, r1, s0
                texld r2, r2, s0
                mad r0.x, c4.x, r1.w, r0.x
                mad r0.x, c4.y, r2.w, r0.x
                add r1.x, t0.x, c1.z
                mov r1.y, t0.y
                add r2.x, t0.x, c1.w
                mov r2.y, t0.y
                texld r1, r1, s0
                texld r2, r2, s0
                mad r0.x, c4.z, r1.w, r0.x
                mad r0.x, c4.w, r2.w, r0.x
                add r1.x, t0.x, c2.x
                mov r1.y, t0.y
                texld r1, r1, s0
                mad r0.x, c5.x, r1.w, r0.x
                mul r0, r0.x, c6
                mov oC0, r0
            
            // approximately 38 instruction slots used (9 texture, 29 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[10], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_input_ps linear v1.xy
            dcl_output o0.xyzw
            dcl_temps 4
            add r0.xyzw, v1.xxxx, cb0[0].zxwy
            mov r1.xz, r0.yywy
            mov r1.yw, v1.yyyy
            sample r2.xyzw, r1.zwzz, t0.xyzw, s0
            sample r1.xyzw, r1.xyxx, t0.xyzw, s0
            mul r1.x, r2.w, cb0[6].y
            mad r1.x, cb0[6].x, r1.w, r1.x
            mov r0.yw, v1.yyyy
            sample r2.xyzw, r0.xyxx, t0.xyzw, s0
            sample r0.xyzw, r0.zwzz, t0.xyzw, s0
            mad r0.x, cb0[6].z, r2.w, r1.x
            mad r0.x, cb0[6].w, r0.w, r0.x
            add r1.xyzw, v1.xxxx, cb0[1].zxwy
            mov r2.xz, r1.yywy
            mov r2.yw, v1.yyyy
            sample r3.xyzw, r2.xyxx, t0.xyzw, s0
            sample r2.xyzw, r2.zwzz, t0.xyzw, s0
            mad r0.x, cb0[7].x, r3.w, r0.x
            mad r0.x, cb0[7].y, r2.w, r0.x
            mov r1.yw, v1.yyyy
            sample r2.xyzw, r1.xyxx, t0.xyzw, s0
            sample r1.xyzw, r1.zwzz, t0.xyzw, s0
            mad r0.x, cb0[7].z, r2.w, r0.x
            mad r0.x, cb0[7].w, r1.w, r0.x
            add r1.x, v1.x, cb0[2].x
            mov r1.y, v1.y
            sample r1.xyzw, r1.xyxx, t0.xyzw, s0
            mad r0.x, cb0[8].x, r1.w, r0.x
            mul o0.xyzw, r0.xxxx, cb0[9].xyzw
            ret 
            // Approximately 30 instruction slots used
                    
        };
    }

    pass P1
    {
        RasterizerState = TextureRast;
        AB_BlendFactor = float4(1, 1, 1, 1);
        AB_SampleMask = uint(0xffffffff);
        BlendState = ShadowBlendV;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // POSITION                 0   xyz         0     NONE  float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float   xyzw
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb1
            // {
            //
            //   float4 BlurOffsetsH[3];            // Offset:    0 Size:    48 [unused]
            //   float4 BlurOffsetsV[3];            // Offset:   48 Size:    48
            //   float4 BlurWeights[3];             // Offset:   96 Size:    48
            //   float4 ShadowColor;                // Offset:  144 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sShadowSampler                    sampler      NA          NA    0        1
            // tex                               texture  float4          2d    0        1
            // cb1                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float       
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float       
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Target                0   xyzw        0   TARGET  float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             3         6  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                dcl t0
                dcl_2d s0
                add r0.y, t0.y, c0.y
                mov r0.x, t0.x
                add r1.y, t0.y, c0.x
                mov r1.x, t0.x
                texld r0, r0, s0
                texld r1, r1, s0
                mul r0, r0, c3.y
                mad r0, c3.x, r1, r0
                add r1.y, t0.y, c0.z
                mov r1.x, t0.x
                add r2.y, t0.y, c0.w
                mov r2.x, t0.x
                texld r1, r1, s0
                texld r2, r2, s0
                mad r0, c3.z, r1, r0
                mad r0, c3.w, r2, r0
                add r1.y, t0.y, c1.x
                mov r1.x, t0.x
                add r2.y, t0.y, c1.y
                mov r2.x, t0.x
                texld r1, r1, s0
                texld r2, r2, s0
                mad r0, c4.x, r1, r0
                mad r0, c4.y, r2, r0
                add r1.y, t0.y, c1.z
                mov r1.x, t0.x
                add r2.y, t0.y, c1.w
                mov r2.x, t0.x
                texld r1, r1, s0
                texld r2, r2, s0
                mad r0, c4.z, r1, r0
                mad r0, c4.w, r2, r0
                add r1.y, t0.y, c2.x
                mov r1.x, t0.x
                texld r1, r1, s0
                mad r0, c5.x, r1, r0
                mov oC0, r0
            
            // approximately 37 instruction slots used (9 texture, 28 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[9], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_input_ps linear v1.xy
            dcl_output o0.xyzw
            dcl_temps 4
            mov r0.xz, v1.xxxx
            add r1.xyzw, v1.yyyy, cb0[3].xzyw
            mov r0.yw, r1.xxxz
            sample r2.xyzw, r0.zwzz, t0.xyzw, s0
            sample r0.xyzw, r0.xyxx, t0.xyzw, s0
            mul r2.xyzw, r2.xyzw, cb0[6].yyyy
            mad r0.xyzw, cb0[6].xxxx, r0.xyzw, r2.xyzw
            mov r1.xz, v1.xxxx
            sample r2.xyzw, r1.xyxx, t0.xyzw, s0
            sample r1.xyzw, r1.zwzz, t0.xyzw, s0
            mad r0.xyzw, cb0[6].zzzz, r2.xyzw, r0.xyzw
            mad r0.xyzw, cb0[6].wwww, r1.xyzw, r0.xyzw
            mov r1.xz, v1.xxxx
            add r2.xyzw, v1.yyyy, cb0[4].xzyw
            mov r1.yw, r2.xxxz
            sample r3.xyzw, r1.xyxx, t0.xyzw, s0
            sample r1.xyzw, r1.zwzz, t0.xyzw, s0
            mad r0.xyzw, cb0[7].xxxx, r3.xyzw, r0.xyzw
            mad r0.xyzw, cb0[7].yyyy, r1.xyzw, r0.xyzw
            mov r2.xz, v1.xxxx
            sample r1.xyzw, r2.xyxx, t0.xyzw, s0
            sample r2.xyzw, r2.zwzz, t0.xyzw, s0
            mad r0.xyzw, cb0[7].zzzz, r1.xyzw, r0.xyzw
            mad r0.xyzw, cb0[7].wwww, r2.xyzw, r0.xyzw
            add r1.y, v1.y, cb0[5].x
            mov r1.x, v1.x
            sample r1.xyzw, r1.xyxx, t0.xyzw, s0
            mad o0.xyzw, cb0[8].xxxx, r1.xyzw, r0.xyzw
            ret 
            // Approximately 29 instruction slots used
                    
        };
    }

    pass P2
    {
        RasterizerState = TextureRast;
        AB_BlendFactor = float4(1, 1, 1, 1);
        AB_SampleMask = uint(0xffffffff);
        BlendState = ShadowBlendV;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // POSITION                 0   xyz         0     NONE  float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float   xyzw
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb1
            // {
            //
            //   float4 BlurOffsetsH[3];            // Offset:    0 Size:    48 [unused]
            //   float4 BlurOffsetsV[3];            // Offset:   48 Size:    48
            //   float4 BlurWeights[3];             // Offset:   96 Size:    48
            //   float4 ShadowColor;                // Offset:  144 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sMaskSampler                      sampler      NA          NA    0        1
            // sShadowSampler                    sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb1                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float       
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Target                0   xyzw        0   TARGET  float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             3         6  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t1               
            // s1             s1              t0               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                dcl t0
                dcl_2d s0
                dcl_2d s1
                add r0.y, t0.y, c0.y
                mov r0.x, t0.x
                add r1.y, t0.y, c0.x
                mov r1.x, t0.x
                texld r0, r0, s1
                texld r1, r1, s1
                mul r0, r0, c3.y
                mad r0, c3.x, r1, r0
                add r1.y, t0.y, c0.z
                mov r1.x, t0.x
                add r2.y, t0.y, c0.w
                mov r2.x, t0.x
                texld r1, r1, s1
                texld r2, r2, s1
                mad r0, c3.z, r1, r0
                mad r0, c3.w, r2, r0
                add r1.y, t0.y, c1.x
                mov r1.x, t0.x
                add r2.y, t0.y, c1.y
                mov r2.x, t0.x
                texld r1, r1, s1
                texld r2, r2, s1
                mad r0, c4.x, r1, r0
                mad r0, c4.y, r2, r0
                add r1.y, t0.y, c1.z
                mov r1.x, t0.x
                add r2.y, t0.y, c1.w
                mov r2.x, t0.x
                texld r1, r1, s1
                texld r2, r2, s1
                mad r0, c4.z, r1, r0
                mad r0, c4.w, r2, r0
                add r1.y, t0.y, c2.x
                mov r1.x, t0.x
                mov r2.xy, t0.wzzw
                texld r1, r1, s1
                texld r2, r2, s0
                mad r0, c5.x, r1, r0
                mul r0, r2.w, r0
                mov oC0, r0
            
            // approximately 40 instruction slots used (10 texture, 30 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[9], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 4
            mov r0.xz, v1.xxxx
            add r1.xyzw, v1.yyyy, cb0[3].xzyw
            mov r0.yw, r1.xxxz
            sample r2.xyzw, r0.zwzz, t0.xyzw, s1
            sample r0.xyzw, r0.xyxx, t0.xyzw, s1
            mul r2.xyzw, r2.xyzw, cb0[6].yyyy
            mad r0.xyzw, cb0[6].xxxx, r0.xyzw, r2.xyzw
            mov r1.xz, v1.xxxx
            sample r2.xyzw, r1.xyxx, t0.xyzw, s1
            sample r1.xyzw, r1.zwzz, t0.xyzw, s1
            mad r0.xyzw, cb0[6].zzzz, r2.xyzw, r0.xyzw
            mad r0.xyzw, cb0[6].wwww, r1.xyzw, r0.xyzw
            mov r1.xz, v1.xxxx
            add r2.xyzw, v1.yyyy, cb0[4].xzyw
            mov r1.yw, r2.xxxz
            sample r3.xyzw, r1.xyxx, t0.xyzw, s1
            sample r1.xyzw, r1.zwzz, t0.xyzw, s1
            mad r0.xyzw, cb0[7].xxxx, r3.xyzw, r0.xyzw
            mad r0.xyzw, cb0[7].yyyy, r1.xyzw, r0.xyzw
            mov r2.xz, v1.xxxx
            sample r1.xyzw, r2.xyxx, t0.xyzw, s1
            sample r2.xyzw, r2.zwzz, t0.xyzw, s1
            mad r0.xyzw, cb0[7].zzzz, r1.xyzw, r0.xyzw
            mad r0.xyzw, cb0[7].wwww, r2.xyzw, r0.xyzw
            add r1.y, v1.y, cb0[5].x
            mov r1.x, v1.x
            sample r1.xyzw, r1.xyxx, t0.xyzw, s1
            mad r0.xyzw, cb0[8].xxxx, r1.xyzw, r0.xyzw
            sample r1.xyzw, v1.zwzz, t1.xyzw, s0
            mul o0.xyzw, r0.xyzw, r1.wwww
            ret 
            // Approximately 31 instruction slots used
                    
        };
    }

}

technique10 SampleTextTexture
{
    pass Unmasked
    {
        RasterizerState = TextureRast;
        AB_BlendFactor = float4(0, 0, 0, 0);
        AB_SampleMask = uint(0xffffffff);
        BlendState = bTextBlend;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // POSITION                 0   xyz         0     NONE  float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float   xyzw
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16 [unused]
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16 [unused]
            //   float4 TextColor;                  // Offset:   48 Size:    16
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sSampler                          sampler      NA          NA    0        1
            // tex                               texture  float4          2d    0        1
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float       
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float       
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Target                0   xyzw        0   TARGET  float   xyzw
            // SV_Target                1   xyzw        1   TARGET  float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                dcl t0
                dcl_2d s0
                mov oC0, c0
                texld r0, t0, s0
                mul r0, r0.zyxy, c0.w
                mov oC1, r0
            
            // approximately 4 instruction slots used (1 texture, 3 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[4], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_input_ps linear v1.xy
            dcl_output o0.xyzw
            dcl_output o1.xyzw
            dcl_temps 1
            mov o0.xyzw, cb0[3].xyzw
            sample r0.xyzw, v1.xyxx, t0.xyzw, s0
            mul o1.xyzw, r0.zyxy, cb0[3].wwww
            ret 
            // Approximately 4 instruction slots used
                    
        };
    }

    pass Masked
    {
        RasterizerState = TextureRast;
        AB_BlendFactor = float4(0, 0, 0, 0);
        AB_SampleMask = uint(0xffffffff);
        BlendState = bTextBlend;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // POSITION                 0   xyz         0     NONE  float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float   xyzw
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 9.29.952.3111
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16 [unused]
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16 [unused]
            //   float4 TextColor;                  // Offset:   48 Size:    16
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sSampler                          sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Position              0   xyzw        0      POS  float       
            // TEXCOORD                 0   xy          1     NONE  float   xy  
            // TEXCOORD                 1     zw        1     NONE  float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue Format   Used
            // -------------------- ----- ------ -------- -------- ------ ------
            // SV_Target                0   xyzw        0   TARGET  float   xyzw
            // SV_Target                1   xyzw        1   TARGET  float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                dcl t0
                dcl_2d s0
                dcl_2d s1
                mov r0.xy, t0.wzzw
                texld r1, t0, s0
                texld r0, r0, s1
                mul r2, r0.w, c0
                mov oC0, r2
                mul r1, r1.zyxy, c0.w
                mul r0, r0.w, r1
                mov oC1, r0
            
            // approximately 8 instruction slots used (2 texture, 6 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[4], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_output o1.xyzw
            dcl_temps 2
            sample r0.xyzw, v1.zwzz, t1.xyzw, s1
            mul o0.xyzw, r0.wwww, cb0[3].xyzw
            sample r1.xyzw, v1.xyxx, t0.xyzw, s0
            mul r1.xyzw, r1.zyxy, cb0[3].wwww
            mul o1.xyzw, r0.wwww, r1.xyzw
            ret 
            // Approximately 6 instruction slots used
                    
        };
    }

}

#endif

const BYTE d2deffect[] =
{
     68,  88,  66,  67, 103,  57, 
    133,   3,  51,  56, 175,  39, 
     21,  65,  54, 209,  72, 159, 
    240, 237,   1,   0,   0,   0, 
     16, 191,   0,   0,   1,   0, 
      0,   0,  36,   0,   0,   0, 
     70,  88,  49,  48, 228, 190, 
      0,   0,   1,  16, 255, 254, 
      3,   0,   0,   0,  15,   0, 
      0,   0,  11,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      5,   0,   0,   0,   4, 180, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   5,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  26,   0, 
      0,   0,  26,   0,   0,   0, 
      0,   0,   0,   0,  99,  98, 
     48,   0, 102, 108, 111,  97, 
    116,  52,   0,   8,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,  16,   0,   0, 
      0,  16,   0,   0,   0,  16, 
      0,   0,   0,  10,  33,   0, 
      0,  81, 117,  97, 100,  68, 
    101, 115,  99,   0,  84, 101, 
    120,  67, 111, 111, 114, 100, 
    115,   0,  77,  97, 115, 107, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  84, 101, 
    120, 116,  67, 111, 108, 111, 
    114,   0,  99,  98,  49,   0, 
      8,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
     48,   0,   0,   0,  16,   0, 
      0,   0,  48,   0,   0,   0, 
     10,  33,   0,   0,  66, 108, 
    117, 114,  79, 102, 102, 115, 
    101, 116, 115,  72,   0,  66, 
    108, 117, 114,  79, 102, 102, 
    115, 101, 116, 115,  86,   0, 
     66, 108, 117, 114,  87, 101, 
    105, 103, 104, 116, 115,   0, 
     83, 104,  97, 100, 111, 119, 
     67, 111, 108, 111, 114,   0, 
     99,  98,  50,   0, 102, 108, 
    111,  97, 116,  51, 120,  51, 
      0, 172,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,  44,   0,   0,   0,  48, 
      0,   0,   0,  36,   0,   0, 
      0,  11,  91,   0,   0,  68, 
    101, 118, 105,  99, 101,  83, 
    112,  97,  99, 101,  84, 111, 
     85, 115, 101, 114,  83, 112, 
     97,  99, 101,   0, 102, 108, 
    111,  97, 116,  50,   0, 232, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   8, 
      0,   0,   0,  16,   0,   0, 
      0,   8,   0,   0,   0,  10, 
     17,   0,   0, 100, 105, 109, 
    101, 110, 115, 105, 111, 110, 
    115,   0, 102, 108, 111,  97, 
    116,  51,   0,  22,   1,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,  12,   0,   0, 
      0,  16,   0,   0,   0,  12, 
      0,   0,   0,  10,  25,   0, 
      0, 100, 105, 102, 102,   0, 
     99, 101, 110, 116, 101, 114, 
     49,   0, 102, 108, 111,  97, 
    116,   0,  70,   1,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
     16,   0,   0,   0,   4,   0, 
      0,   0,   9,   9,   0,   0, 
     65,   0, 114,  97, 100, 105, 
    117, 115,  49,   0, 115, 113, 
     95, 114,  97, 100, 105, 117, 
    115,  49,   0,  84, 101, 120, 
    116, 117, 114, 101,  50,  68, 
      0, 125,   1,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  12,   0,   0,   0, 116, 
    101, 120,   0, 109,  97, 115, 
    107,   0,  83,  97, 109, 112, 
    108, 101, 114,  83, 116,  97, 
    116, 101,   0, 172,   1,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  21,   0,   0, 
      0, 115,  83,  97, 109, 112, 
    108, 101, 114,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
     21,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      3,   0,   0,   0, 115,  87, 
    114,  97, 112,  83,  97, 109, 
    112, 108, 101, 114,   0,   1, 
      0,   0,   0,   2,   0,   0, 
      0,  21,   0,   0,   0,   1, 
      0,   0,   0,   2,   0,   0, 
      0,   1,   0,   0,   0,   1, 
      0,   0,   0,   2,   0,   0, 
      0,   1,   0,   0,   0, 115, 
     77, 105, 114, 114, 111, 114, 
     83,  97, 109, 112, 108, 101, 
    114,   0,   1,   0,   0,   0, 
      2,   0,   0,   0,  21,   0, 
      0,   0,   1,   0,   0,   0, 
      2,   0,   0,   0,   2,   0, 
      0,   0,   1,   0,   0,   0, 
      2,   0,   0,   0,   2,   0, 
      0,   0, 115,  77,  97, 115, 
    107,  83,  97, 109, 112, 108, 
    101, 114,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,  21, 
      0,   0,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,   3, 
      0,   0,   0, 115,  83, 104, 
     97, 100, 111, 119,  83,  97, 
    109, 112, 108, 101, 114,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,  21,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,   4,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,   4,   0,   0,   0, 
      4,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
     82,  97, 115, 116, 101, 114, 
    105, 122, 101, 114,  83, 116, 
     97, 116, 101,   0, 238,   2, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,  84, 101, 120, 116, 
    117, 114, 101,  82,  97, 115, 
    116,   0,   1,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      2,   0,   0,   0,   1,   0, 
      0,   0,  66, 108, 101, 110, 
    100,  83, 116,  97, 116, 101, 
      0,  62,   3,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   2,   0,   0,   0,  83, 
    104,  97, 100, 111, 119,  66, 
    108, 101, 110, 100,  72,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,  15,   0,   0,   0, 
     83, 104,  97, 100, 111, 119, 
     66, 108, 101, 110, 100,  86, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   1,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   2,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   6,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   1,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   2,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   6,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   1,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,  15,   0,   0, 
      0,  98,  84, 101, 120, 116, 
     66, 108, 101, 110, 100,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,   1,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,  16,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,  17,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,   1,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,  18,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,  19,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,   1,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,  15,   0,   0,   0, 
     83,  97, 109, 112, 108, 101, 
     84, 101, 120, 116, 117, 114, 
    101,   0,  80,  48,   0,  68, 
      4,   0,   0,  68,  88,  66, 
     67,  26, 214, 157, 140, 185, 
     91, 182, 211, 177, 171, 114, 
    225, 174, 107,  56, 117,   1, 
      0,   0,   0,  68,   4,   0, 
      0,   6,   0,   0,   0,  56, 
      0,   0,   0, 248,   0,   0, 
      0, 244,   1,   0,   0, 112, 
      2,   0,   0, 160,   3,   0, 
      0, 212,   3,   0,   0,  65, 
    111, 110,  57, 184,   0,   0, 
      0, 184,   0,   0,   0,   0, 
      2, 254, 255, 132,   0,   0, 
      0,  52,   0,   0,   0,   1, 
      0,  36,   0,   0,   0,  48, 
      0,   0,   0,  48,   0,   0, 
      0,  36,   0,   1,   0,  48, 
      0,   0,   0,   0,   0,   3, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      2, 254, 255,  81,   0,   0, 
      5,   4,   0,  15, 160,   0, 
      0,   0,   0,   0,   0, 128, 
     63,   0,   0,   0,   0,   0, 
      0,   0,   0,  31,   0,   0, 
      2,   5,   0,   0, 128,   0, 
      0,  15, 144,   4,   0,   0, 
      4,   0,   0,   3, 224,   0, 
      0, 228, 144,   2,   0, 238, 
    160,   2,   0, 228, 160,   4, 
      0,   0,   4,   0,   0,  12, 
    224,   0,   0,  20, 144,   3, 
      0, 180, 160,   3,   0,  20, 
    160,   4,   0,   0,   4,   0, 
      0,   3, 128,   0,   0, 228, 
    144,   1,   0, 238, 160,   1, 
      0, 228, 160,   2,   0,   0, 
      3,   0,   0,   3, 192,   0, 
      0, 228, 128,   0,   0, 228, 
    160,   1,   0,   0,   2,   0, 
      0,  12, 192,   4,   0,  68, 
    160, 255, 255,   0,   0,  83, 
     72,  68,  82, 244,   0,   0, 
      0,  64,   0,   1,   0,  61, 
      0,   0,   0,  89,   0,   0, 
      4,  70, 142,  32,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,  95,   0,   0,   3,  50, 
     16,  16,   0,   0,   0,   0, 
      0, 103,   0,   0,   4, 242, 
     32,  16,   0,   0,   0,   0, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3,  50,  32,  16, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3, 194,  32,  16, 
      0,   1,   0,   0,   0,  50, 
      0,   0,  11,  50,  32,  16, 
      0,   0,   0,   0,   0,  70, 
     16,  16,   0,   0,   0,   0, 
      0, 230, 138,  32,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  70, 128,  32,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  54,   0,   0,   8, 194, 
     32,  16,   0,   0,   0,   0, 
      0,   2,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 128,  63,  50,   0,   0, 
     11,  50,  32,  16,   0,   1, 
      0,   0,   0,  70,  16,  16, 
      0,   0,   0,   0,   0, 230, 
    138,  32,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,  70, 
    128,  32,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,  50, 
      0,   0,  11, 194,  32,  16, 
      0,   1,   0,   0,   0,   6, 
     20,  16,   0,   0,   0,   0, 
      0, 166, 142,  32,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,   6, 132,  32,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,  62,   0,   0,   1,  83, 
     84,  65,  84, 116,   0,   0, 
      0,   5,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   4,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  82,  68,  69, 
     70,  40,   1,   0,   0,   1, 
      0,   0,   0,  64,   0,   0, 
      0,   1,   0,   0,   0,  28, 
      0,   0,   0,   0,   4, 254, 
    255,   0,   1,   0,   0, 246, 
      0,   0,   0,  60,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,  99, 
     98,  48,   0,  60,   0,   0, 
      0,   4,   0,   0,   0,  88, 
      0,   0,   0,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 184,   0,   0, 
      0,   0,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0, 196,   0,   0,   0,   0, 
      0,   0,   0, 212,   0,   0, 
      0,  16,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0, 196,   0,   0,   0,   0, 
      0,   0,   0, 222,   0,   0, 
      0,  32,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0, 196,   0,   0,   0,   0, 
      0,   0,   0, 236,   0,   0, 
      0,  48,   0,   0,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0, 196,   0,   0,   0,   0, 
      0,   0,   0,  81, 117,  97, 
    100,  68, 101, 115,  99,   0, 
    171, 171, 171,   1,   0,   3, 
      0,   1,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  84, 101, 120,  67, 111, 
    111, 114, 100, 115,   0,  77, 
     97, 115, 107,  84, 101, 120, 
     67, 111, 111, 114, 100, 115, 
      0,  84, 101, 120, 116,  67, 
    111, 108, 111, 114,   0,  77, 
    105,  99, 114, 111, 115, 111, 
    102, 116,  32,  40,  82,  41, 
     32,  72,  76,  83,  76,  32, 
     83, 104,  97, 100, 101, 114, 
     32,  67, 111, 109, 112, 105, 
    108, 101, 114,  32,  57,  46, 
     50,  57,  46,  57,  53,  50, 
     46,  51,  49,  49,  49,   0, 
    171,  73,  83,  71,  78,  44, 
      0,   0,   0,   1,   0,   0, 
      0,   8,   0,   0,   0,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   7,   3,   0,   0,  80, 
     79,  83,  73,  84,  73,  79, 
     78,   0, 171, 171, 171,  79, 
     83,  71,  78, 104,   0,   0, 
      0,   3,   0,   0,   0,   8, 
      0,   0,   0,  80,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  15, 
      0,   0,   0,  92,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,   3, 
     12,   0,   0,  92,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,  12, 
      3,   0,   0,  83,  86,  95, 
     80, 111, 115, 105, 116, 105, 
    111, 110,   0,  84,  69,  88, 
     67,  79,  79,  82,  68,   0, 
    171, 171, 171, 127,   4,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   0,   0,   0, 212, 
      2,   0,   0,  68,  88,  66, 
     67,  22, 206,  82, 103, 196, 
    235,  84, 233, 156,  39, 210, 
    152,  32, 145, 169, 162,   1, 
      0,   0,   0, 212,   2,   0, 
      0,   6,   0,   0,   0,  56, 
      0,   0,   0, 164,   0,   0, 
      0,  16,   1,   0,   0, 140, 
      1,   0,   0,  48,   2,   0, 
      0, 160,   2,   0,   0,  65, 
    111, 110,  57, 100,   0,   0, 
      0, 100,   0,   0,   0,   0, 
      2, 255, 255,  60,   0,   0, 
      0,  40,   0,   0,   0,   0, 
      0,  40,   0,   0,   0,  40, 
      0,   0,   0,  40,   0,   1, 
      0,  36,   0,   0,   0,  40, 
      0,   0,   0,   0,   0,   1, 
      2, 255, 255,  31,   0,   0, 
      2,   0,   0,   0, 128,   0, 
      0,  15, 176,  31,   0,   0, 
      2,   0,   0,   0, 144,   0, 
      8,  15, 160,  66,   0,   0, 
      3,   0,   0,  15, 128,   0, 
      0, 228, 176,   0,   8, 228, 
    160,   1,   0,   0,   2,   0, 
      8,  15, 128,   0,   0, 228, 
    128, 255, 255,   0,   0,  83, 
     72,  68,  82, 100,   0,   0, 
      0,  64,   0,   0,   0,  25, 
      0,   0,   0,  90,   0,   0, 
      3,   0,  96,  16,   0,   0, 
      0,   0,   0,  88,  24,   0, 
      4,   0, 112,  16,   0,   0, 
      0,   0,   0,  85,  85,   0, 
      0,  98,  16,   0,   3,  50, 
     16,  16,   0,   1,   0,   0, 
      0, 101,   0,   0,   3, 242, 
     32,  16,   0,   0,   0,   0, 
      0,  69,   0,   0,   9, 242, 
     32,  16,   0,   0,   0,   0, 
      0,  70,  16,  16,   0,   1, 
      0,   0,   0,  70, 126,  16, 
      0,   0,   0,   0,   0,   0, 
     96,  16,   0,   0,   0,   0, 
      0,  62,   0,   0,   1,  83, 
     84,  65,  84, 116,   0,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  82,  68,  69, 
     70, 156,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   2,   0,   0,   0,  28, 
      0,   0,   0,   0,   4, 255, 
    255,   0,   1,   0,   0, 105, 
      0,   0,   0,  92,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0, 101, 
      0,   0,   0,   2,   0,   0, 
      0,   5,   0,   0,   0,   4, 
      0,   0,   0, 255, 255, 255, 
    255,   0,   0,   0,   0,   1, 
      0,   0,   0,  12,   0,   0, 
      0, 115,  83,  97, 109, 112, 
    108, 101, 114,   0, 116, 101, 
    120,   0,  77, 105,  99, 114, 
    111, 115, 111, 102, 116,  32, 
     40,  82,  41,  32,  72,  76, 
     83,  76,  32,  83, 104,  97, 
    100, 101, 114,  32,  67, 111, 
    109, 112, 105, 108, 101, 114, 
     32,  57,  46,  50,  57,  46, 
     57,  53,  50,  46,  51,  49, 
     49,  49,   0, 171, 171,  73, 
     83,  71,  78, 104,   0,   0, 
      0,   3,   0,   0,   0,   8, 
      0,   0,   0,  80,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  15, 
      0,   0,   0,  92,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      3,   0,   0,  92,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,  12, 
      0,   0,   0,  83,  86,  95, 
     80, 111, 115, 105, 116, 105, 
    111, 110,   0,  84,  69,  88, 
     67,  79,  79,  82,  68,   0, 
    171, 171, 171,  79,  83,  71, 
     78,  44,   0,   0,   0,   1, 
      0,   0,   0,   8,   0,   0, 
      0,  32,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,  15,   0,   0, 
      0,  83,  86,  95,  84,  97, 
    114, 103, 101, 116,   0, 171, 
    171, 219,   8,   0,   0,   0, 
      0,   0,   0,  83,  97, 109, 
    112, 108, 101,  82,  97, 100, 
    105,  97, 108,  71, 114,  97, 
    100, 105, 101, 110, 116,   0, 
     65,  80, 111, 115,   0,  40, 
      7,   0,   0,  68,  88,  66, 
     67, 237,  58, 124, 168, 122, 
    234, 242,   5,  75,  29, 195, 
      6, 241, 206, 131, 117,   1, 
      0,   0,   0,  40,   7,   0, 
      0,   6,   0,   0,   0,  56, 
      0,   0,   0, 148,   1,   0, 
      0, 104,   3,   0,   0, 228, 
      3,   0,   0, 132,   6,   0, 
      0, 184,   6,   0,   0,  65, 
    111, 110,  57,  84,   1,   0, 
      0,  84,   1,   0,   0,   0, 
      2, 254, 255, 252,   0,   0, 
      0,  88,   0,   0,   0,   4, 
      0,  36,   0,   0,   0,  84, 
      0,   0,   0,  84,   0,   0, 
      0,  36,   0,   1,   0,  84, 
      0,   0,   0,   0,   0,   1, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   2,   0,   1, 
      0,   2,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   3,   0,   0,   0,   0, 
      0,   1,   0,   3,   0,   1, 
      0,   5,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      2, 254, 255,  81,   0,   0, 
      5,   6,   0,  15, 160,   0, 
      0, 128,  63,   0,   0,   0, 
     63,   0,   0,   0,   0,   0, 
      0,   0,   0,  31,   0,   0, 
      2,   5,   0,   0, 128,   0, 
      0,  15, 144,   4,   0,   0, 
      4,   0,   0,   3, 224,   0, 
      0, 228, 144,   2,   0, 238, 
    160,   2,   0, 228, 160,   4, 
      0,   0,   4,   0,   0,   3, 
    128,   0,   0, 228, 144,   1, 
      0, 238, 160,   1,   0, 228, 
    160,   2,   0,   0,   3,   0, 
      0,   4, 128,   0,   0,   0, 
    128,   6,   0,   0, 160,   5, 
      0,   0,   3,   0,   0,   4, 
    128,   0,   0, 170, 128,   5, 
      0,   0, 160,   5,   0,   0, 
      3,   1,   0,   1, 128,   0, 
      0, 170, 128,   6,   0,  85, 
    160,   2,   0,   0,   3,   0, 
      0,   4, 128,   0,   0,  85, 
    129,   6,   0,   0, 160,   2, 
      0,   0,   3,   0,   0,   3, 
    192,   0,   0, 228, 128,   0, 
      0, 228, 160,   5,   0,   0, 
      3,   0,   0,   1, 128,   0, 
      0, 170, 128,   5,   0,  85, 
    160,   5,   0,   0,   3,   1, 
      0,   2, 128,   0,   0,   0, 
    128,   6,   0,  85, 160,   1, 
      0,   0,   2,   1,   0,   4, 
    128,   6,   0,   0, 160,   8, 
      0,   0,   3,   0,   0,   8, 
    224,   1,   0, 228, 128,   3, 
      0, 228, 160,   8,   0,   0, 
      3,   0,   0,   4, 224,   1, 
      0, 228, 128,   4,   0, 228, 
    160,   1,   0,   0,   2,   0, 
      0,  12, 192,   6,   0,  36, 
    160, 255, 255,   0,   0,  83, 
     72,  68,  82, 204,   1,   0, 
      0,  64,   0,   1,   0, 115, 
      0,   0,   0,  89,   0,   0, 
      4,  70, 142,  32,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,  89,   0,   0,   4,  70, 
    142,  32,   0,   1,   0,   0, 
      0,   4,   0,   0,   0,  95, 
      0,   0,   3,  50,  16,  16, 
      0,   0,   0,   0,   0, 103, 
      0,   0,   4, 242,  32,  16, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0, 101,   0,   0, 
      3,  50,  32,  16,   0,   1, 
      0,   0,   0, 101,   0,   0, 
      3, 194,  32,  16,   0,   1, 
      0,   0,   0, 104,   0,   0, 
      2,   2,   0,   0,   0,  54, 
      0,   0,   8, 194,  32,  16, 
      0,   0,   0,   0,   0,   2, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 128, 
     63,  50,   0,   0,  11,  50, 
      0,  16,   0,   0,   0,   0, 
      0,  70,  16,  16,   0,   0, 
      0,   0,   0, 230, 138,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  70, 128,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      5,  50,  32,  16,   0,   0, 
      0,   0,   0,  70,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   7,  18,   0,  16, 
      0,   0,   0,   0,   0,  10, 
      0,  16,   0,   0,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0, 128,  63,   0,   0,   0, 
      8,  34,   0,  16,   0,   0, 
      0,   0,   0,  26,   0,  16, 
    128,  65,   0,   0,   0,   0, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0, 128,  63,  56, 
      0,   0,   8,  50,   0,  16, 
      0,   0,   0,   0,   0,  70, 
      0,  16,   0,   0,   0,   0, 
      0,  70, 128,  32,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0,  56,   0,   0,  10,  50, 
      0,  16,   0,   1,   0,   0, 
      0,  70,   0,  16,   0,   0, 
      0,   0,   0,   2,  64,   0, 
      0,   0,   0,   0,  63,   0, 
      0,   0,  63,   0,   0,   0, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   5,  66,   0,  16, 
      0,   1,   0,   0,   0,   1, 
     64,   0,   0,   0,   0, 128, 
     63,  16,   0,   0,   8,  66, 
     32,  16,   0,   1,   0,   0, 
      0,  70,   2,  16,   0,   1, 
      0,   0,   0,  70, 130,  32, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,  16,   0,   0, 
      8, 130,  32,  16,   0,   1, 
      0,   0,   0,  70,   2,  16, 
      0,   1,   0,   0,   0,  70, 
    130,  32,   0,   1,   0,   0, 
      0,   1,   0,   0,   0,  50, 
      0,   0,  11,  50,  32,  16, 
      0,   1,   0,   0,   0,  70, 
     16,  16,   0,   0,   0,   0, 
      0, 230, 138,  32,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,  70, 128,  32,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,  62,   0,   0,   1,  83, 
     84,  65,  84, 116,   0,   0, 
      0,  12,   0,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   4,   0,   0,   0,   6, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  82,  68,  69, 
     70, 152,   2,   0,   0,   2, 
      0,   0,   0, 100,   0,   0, 
      0,   2,   0,   0,   0,  28, 
      0,   0,   0,   0,   4, 254, 
    255,   0,   1,   0,   0, 103, 
      2,   0,   0,  92,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,  96, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,  99,  98,  48,   0,  99, 
     98,  50,   0,  92,   0,   0, 
      0,   4,   0,   0,   0, 148, 
      0,   0,   0,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  96,   0,   0, 
      0,   7,   0,   0,   0,  52, 
      1,   0,   0, 112,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 244,   0,   0, 
      0,   0,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  16,   1,   0, 
      0,  16,   0,   0,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  26,   1,   0, 
      0,  32,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  40,   1,   0, 
      0,  48,   0,   0,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  81, 117,  97, 
    100,  68, 101, 115,  99,   0, 
    171, 171, 171,   1,   0,   3, 
      0,   1,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  84, 101, 120,  67, 111, 
    111, 114, 100, 115,   0,  77, 
     97, 115, 107,  84, 101, 120, 
     67, 111, 111, 114, 100, 115, 
      0,  84, 101, 120, 116,  67, 
    111, 108, 111, 114,   0, 171, 
    171, 220,   1,   0,   0,   0, 
      0,   0,   0,  44,   0,   0, 
      0,   2,   0,   0,   0, 244, 
      1,   0,   0,   0,   0,   0, 
      0,   4,   2,   0,   0,  48, 
      0,   0,   0,   8,   0,   0, 
      0,   2,   0,   0,   0,  16, 
      2,   0,   0,   0,   0,   0, 
      0,  32,   2,   0,   0,  64, 
      0,   0,   0,  12,   0,   0, 
      0,   0,   0,   0,   0,  40, 
      2,   0,   0,   0,   0,   0, 
      0,  56,   2,   0,   0,  80, 
      0,   0,   0,   8,   0,   0, 
      0,   0,   0,   0,   0,  16, 
      2,   0,   0,   0,   0,   0, 
      0,  64,   2,   0,   0,  88, 
      0,   0,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,  68, 
      2,   0,   0,   0,   0,   0, 
      0,  84,   2,   0,   0,  92, 
      0,   0,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,  68, 
      2,   0,   0,   0,   0,   0, 
      0,  92,   2,   0,   0,  96, 
      0,   0,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,  68, 
      2,   0,   0,   0,   0,   0, 
      0,  68, 101, 118, 105,  99, 
    101,  83, 112,  97,  99, 101, 
     84, 111,  85, 115, 101, 114, 
     83, 112,  97,  99, 101,   0, 
    171,   3,   0,   3,   0,   3, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 100, 
    105, 109, 101, 110, 115, 105, 
    111, 110, 115,   0, 171,   1, 
      0,   3,   0,   1,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 100, 105, 102, 
    102,   0, 171, 171, 171,   1, 
      0,   3,   0,   1,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  99, 101, 110, 
    116, 101, 114,  49,   0,  65, 
      0, 171, 171,   0,   0,   3, 
      0,   1,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 114,  97, 100, 105, 117, 
    115,  49,   0, 115, 113,  95, 
    114,  97, 100, 105, 117, 115, 
     49,   0,  77, 105,  99, 114, 
    111, 115, 111, 102, 116,  32, 
     40,  82,  41,  32,  72,  76, 
     83,  76,  32,  83, 104,  97, 
    100, 101, 114,  32,  67, 111, 
    109, 112, 105, 108, 101, 114, 
     32,  57,  46,  50,  57,  46, 
     57,  53,  50,  46,  51,  49, 
     49,  49,   0,  73,  83,  71, 
     78,  44,   0,   0,   0,   1, 
      0,   0,   0,   8,   0,   0, 
      0,  32,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   7,   3,   0, 
      0,  80,  79,  83,  73,  84, 
     73,  79,  78,   0, 171, 171, 
    171,  79,  83,  71,  78, 104, 
      0,   0,   0,   3,   0,   0, 
      0,   8,   0,   0,   0,  80, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  15,   0,   0,   0,  92, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,   3,  12,   0,   0,  92, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,  12,   3,   0,   0,  83, 
     86,  95,  80, 111, 115, 105, 
    116, 105, 111, 110,   0,  84, 
     69,  88,  67,  79,  79,  82, 
     68,   0, 171, 171, 171, 213, 
     11,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0, 220,   9,   0,   0,  68, 
     88,  66,  67,  75, 110, 115, 
    165, 159, 108, 132, 208, 154, 
     90, 141,  18, 236, 102,  72, 
    112,   1,   0,   0,   0, 220, 
      9,   0,   0,   6,   0,   0, 
      0,  56,   0,   0,   0, 128, 
      2,   0,   0,  88,   6,   0, 
      0, 212,   6,   0,   0,  56, 
      9,   0,   0, 168,   9,   0, 
      0,  65, 111, 110,  57,  64, 
      2,   0,   0,  64,   2,   0, 
      0,   0,   2, 255, 255,   8, 
      2,   0,   0,  56,   0,   0, 
      0,   1,   0,  44,   0,   0, 
      0,  56,   0,   0,   0,  56, 
      0,   2,   0,  36,   0,   0, 
      0,  56,   0,   0,   0,   0, 
      0,   1,   1,   1,   0,   0, 
      0,   4,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      2, 255, 255,  81,   0,   0, 
      5,   3,   0,  15, 160,   0, 
      0,   0,  63,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  81,   0,   0, 
      5,   4,   0,  15, 160,   0, 
      0, 128,  63,   0,   0, 128, 
    191,   0,   0,   0,   0,   0, 
      0,   0, 128,  31,   0,   0, 
      2,   0,   0,   0, 128,   0, 
      0,  15, 176,  31,   0,   0, 
      2,   0,   0,   0, 144,   0, 
      8,  15, 160,  31,   0,   0, 
      2,   0,   0,   0, 144,   1, 
      8,  15, 160,   2,   0,   0, 
      3,   0,   0,   3, 128,   0, 
      0, 235, 176,   1,   0, 228, 
    161,  90,   0,   0,   4,   0, 
      0,   8, 128,   0,   0, 228, 
    128,   0,   0, 228, 128,   2, 
      0,   0, 161,   5,   0,   0, 
      3,   0,   0,   8, 128,   0, 
      0, 255, 128,   1,   0, 170, 
    160,   1,   0,   0,   2,   0, 
      0,   4, 128,   1,   0, 255, 
    160,   8,   0,   0,   3,   0, 
      0,   1, 128,   0,   0, 228, 
    128,   0,   0, 228, 160,   4, 
      0,   0,   4,   0,   0,   2, 
    128,   0,   0,   0, 128,   0, 
      0,   0, 128,   0,   0, 255, 
    129,  35,   0,   0,   2,   0, 
      0,   4, 128,   0,   0,  85, 
    128,   7,   0,   0,   2,   0, 
      0,   4, 128,   0,   0, 170, 
    128,   6,   0,   0,   2,   1, 
      0,   1, 128,   0,   0, 170, 
    128,   1,   0,   0,   2,   1, 
      0,   6, 128,   1,   0,   0, 
    129,   2,   0,   0,   3,   0, 
      0,  13, 128,   0,   0,   0, 
    128,   1,   0, 148, 128,   6, 
      0,   0,   2,   1,   0,   1, 
    128,   1,   0, 170, 160,   5, 
      0,   0,   3,   0,   0,  13, 
    128,   0,   0, 228, 128,   1, 
      0,   0, 128,   1,   0,   0, 
      2,   1,   0,   8, 128,   1, 
      0, 255, 160,   4,   0,   0, 
      4,   1,   0,   7, 128,   0, 
      0, 248, 128,   0,   0, 170, 
    160,   1,   0, 255, 128,  88, 
      0,   0,   4,   2,   0,   1, 
    128,   1,   0,   0, 128,   0, 
      0,   0, 128,   0,   0, 255, 
    128,  88,   0,   0,   4,   0, 
      0,  13, 128,   1,   0, 148, 
    128,   4,   0,  68, 160,   4, 
      0, 230, 160,   1,   0,   0, 
      2,   2,   0,   2, 128,   3, 
      0,   0, 160,  66,   0,   0, 
      3,   1,   0,  15, 128,   0, 
      0, 228, 176,   1,   8, 228, 
    160,  66,   0,   0,   3,   2, 
      0,  15, 128,   2,   0, 228, 
    128,   0,   8, 228, 160,   5, 
      0,   0,   3,   2,   0,   7, 
    128,   2,   0, 255, 128,   2, 
      0, 228, 128,   5,   0,   0, 
      3,   1,   0,  15, 128,   1, 
      0, 255, 128,   2,   0, 228, 
    128,   2,   0,   0,   3,   0, 
      0,   8, 128,   0,   0, 255, 
    128,   0,   0,   0, 128,  88, 
      0,   0,   4,   0,   0,   1, 
    128,   0,   0, 255, 128,   0, 
      0,   0, 128,   0,   0, 170, 
    128,  88,   0,   0,   4,   1, 
      0,  15, 128,   0,   0,   0, 
    129,   4,   0, 170, 160,   1, 
      0, 228, 128,  88,   0,   0, 
      4,   0,   0,  15, 128,   0, 
      0,  85, 128,   1,   0, 228, 
    128,   4,   0, 170, 160,   1, 
      0,   0,   2,   0,   8,  15, 
    128,   0,   0, 228, 128, 255, 
    255,   0,   0,  83,  72,  68, 
     82, 208,   3,   0,   0,  64, 
      0,   0,   0, 244,   0,   0, 
      0,  89,   0,   0,   4,  70, 
    142,  32,   0,   0,   0,   0, 
      0,   7,   0,   0,   0,  90, 
      0,   0,   3,   0,  96,  16, 
      0,   0,   0,   0,   0,  90, 
      0,   0,   3,   0,  96,  16, 
      0,   1,   0,   0,   0,  88, 
     24,   0,   4,   0, 112,  16, 
      0,   0,   0,   0,   0,  85, 
     85,   0,   0,  88,  24,   0, 
      4,   0, 112,  16,   0,   1, 
      0,   0,   0,  85,  85,   0, 
      0,  98,  16,   0,   3,  50, 
     16,  16,   0,   1,   0,   0, 
      0,  98,  16,   0,   3, 194, 
     16,  16,   0,   1,   0,   0, 
      0, 101,   0,   0,   3, 242, 
     32,  16,   0,   0,   0,   0, 
      0, 104,   0,   0,   2,   3, 
      0,   0,   0,   0,   0,   0, 
      9,  50,   0,  16,   0,   0, 
      0,   0,   0, 230,  26,  16, 
      0,   1,   0,   0,   0,  70, 
    128,  32, 128,  65,   0,   0, 
      0,   0,   0,   0,   0,   5, 
      0,   0,   0,  54,   0,   0, 
      6,  66,   0,  16,   0,   0, 
      0,   0,   0,  58, 128,  32, 
      0,   0,   0,   0,   0,   5, 
      0,   0,   0,  16,   0,   0, 
      8,  66,   0,  16,   0,   0, 
      0,   0,   0,  70,   2,  16, 
      0,   0,   0,   0,   0,  70, 
    130,  32,   0,   0,   0,   0, 
      0,   4,   0,   0,   0,  15, 
      0,   0,   7,  18,   0,  16, 
      0,   0,   0,   0,   0,  70, 
      0,  16,   0,   0,   0,   0, 
      0,  70,   0,  16,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      9,  18,   0,  16,   0,   0, 
      0,   0,   0,  10,   0,  16, 
      0,   0,   0,   0,   0,  10, 
    128,  32, 128,  65,   0,   0, 
      0,   0,   0,   0,   0,   6, 
      0,   0,   0,  56,   0,   0, 
      8,  18,   0,  16,   0,   0, 
      0,   0,   0,  10,   0,  16, 
      0,   0,   0,   0,   0,  42, 
    128,  32,   0,   0,   0,   0, 
      0,   5,   0,   0,   0,  50, 
      0,   0,  10,  18,   0,  16, 
      0,   0,   0,   0,   0,  42, 
      0,  16,   0,   0,   0,   0, 
      0,  42,   0,  16,   0,   0, 
      0,   0,   0,  10,   0,  16, 
    128,  65,   0,   0,   0,   0, 
      0,   0,   0,  49,   0,   0, 
      7,  34,   0,  16,   0,   0, 
      0,   0,   0,  10,   0,  16, 
      0,   0,   0,   0,   0,   1, 
     64,   0,   0,   0,   0,   0, 
      0,  75,   0,   0,   6,  18, 
      0,  16,   0,   1,   0,   0, 
      0,  10,   0,  16, 128, 129, 
      0,   0,   0,   0,   0,   0, 
      0,  54,   0,   0,   6,  34, 
      0,  16,   0,   1,   0,   0, 
      0,  10,   0,  16, 128,  65, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   7,  82, 
      0,  16,   0,   0,   0,   0, 
      0, 166,  10,  16,   0,   0, 
      0,   0,   0,   6,   1,  16, 
      0,   1,   0,   0,   0,  14, 
      0,   0,   8,  82,   0,  16, 
      0,   0,   0,   0,   0,   6, 
      2,  16,   0,   0,   0,   0, 
      0, 166, 138,  32,   0,   0, 
      0,   0,   0,   5,   0,   0, 
      0,  56,   0,   0,   8,  50, 
      0,  16,   0,   1,   0,   0, 
      0, 134,   0,  16,   0,   0, 
      0,   0,   0, 166, 138,  32, 
      0,   0,   0,   0,   0,   4, 
      0,   0,   0,  29,   0,   0, 
      9,  50,   0,  16,   0,   1, 
      0,   0,   0,  70,   0,  16, 
      0,   1,   0,   0,   0, 246, 
    143,  32, 128,  65,   0,   0, 
      0,   0,   0,   0,   0,   5, 
      0,   0,   0,   1,   0,   0, 
     10,  50,   0,  16,   0,   1, 
      0,   0,   0,  70,   0,  16, 
      0,   1,   0,   0,   0,   2, 
     64,   0,   0,   0,   0, 128, 
     63,   0,   0, 128,  63,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   8,  18, 
      0,  16,   0,   0,   0,   0, 
      0,  42,   0,  16, 128,  65, 
      0,   0,   0,   0,   0,   0, 
      0,  10,   0,  16,   0,   0, 
      0,   0,   0,  50,   0,   0, 
      9,  18,   0,  16,   0,   2, 
      0,   0,   0,  10,   0,  16, 
      0,   1,   0,   0,   0,  10, 
      0,  16,   0,   0,   0,   0, 
      0,  42,   0,  16,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      5,  34,   0,  16,   0,   2, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0,   0,  63,  69, 
      0,   0,   9, 242,   0,  16, 
      0,   2,   0,   0,   0,  70, 
      0,  16,   0,   2,   0,   0, 
      0,  70, 126,  16,   0,   0, 
      0,   0,   0,   0,  96,  16, 
      0,   0,   0,   0,   0,  31, 
      0,   4,   3,  26,   0,  16, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   8, 242,  32,  16, 
      0,   0,   0,   0,   0,   2, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  62,   0,   0,   1,  21, 
      0,   0,   1,  52,   0,   0, 
      7,  18,   0,  16,   0,   0, 
      0,   0,   0,  26,   0,  16, 
      0,   1,   0,   0,   0,  10, 
      0,  16,   0,   1,   0,   0, 
      0,  29,   0,   0,   7,  18, 
      0,  16,   0,   0,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0,   0,   0,  10,   0,  16, 
      0,   0,   0,   0,   0,  31, 
      0,   4,   3,  10,   0,  16, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   8, 242,  32,  16, 
      0,   0,   0,   0,   0,   2, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  62,   0,   0,   1,  21, 
      0,   0,   1,  56,   0,   0, 
      7, 114,   0,  16,   0,   2, 
      0,   0,   0, 246,  15,  16, 
      0,   2,   0,   0,   0,  70, 
      2,  16,   0,   2,   0,   0, 
      0,  69,   0,   0,   9, 242, 
      0,  16,   0,   0,   0,   0, 
      0,  70,  16,  16,   0,   1, 
      0,   0,   0,  70, 126,  16, 
      0,   1,   0,   0,   0,   0, 
     96,  16,   0,   1,   0,   0, 
      0,  56,   0,   0,   7, 242, 
     32,  16,   0,   0,   0,   0, 
      0, 246,  15,  16,   0,   0, 
      0,   0,   0,  70,  14,  16, 
      0,   2,   0,   0,   0,  62, 
      0,   0,   1,  83,  84,  65, 
     84, 116,   0,   0,   0,  33, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,  17,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   5,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  82,  68,  69,  70,  92, 
      2,   0,   0,   1,   0,   0, 
      0, 224,   0,   0,   0,   5, 
      0,   0,   0,  28,   0,   0, 
      0,   0,   4, 255, 255,   0, 
      1,   0,   0,  43,   2,   0, 
      0, 188,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0, 197,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0, 210, 
      0,   0,   0,   2,   0,   0, 
      0,   5,   0,   0,   0,   4, 
      0,   0,   0, 255, 255, 255, 
    255,   0,   0,   0,   0,   1, 
      0,   0,   0,  12,   0,   0, 
      0, 214,   0,   0,   0,   2, 
      0,   0,   0,   5,   0,   0, 
      0,   4,   0,   0,   0, 255, 
    255, 255, 255,   1,   0,   0, 
      0,   1,   0,   0,   0,  12, 
      0,   0,   0, 219,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0, 115, 
     83,  97, 109, 112, 108, 101, 
    114,   0, 115,  77,  97, 115, 
    107,  83,  97, 109, 112, 108, 
    101, 114,   0, 116, 101, 120, 
      0, 109,  97, 115, 107,   0, 
     99,  98,  50,   0, 171, 219, 
      0,   0,   0,   7,   0,   0, 
      0, 248,   0,   0,   0, 112, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 160, 
      1,   0,   0,   0,   0,   0, 
      0,  44,   0,   0,   0,   0, 
      0,   0,   0, 184,   1,   0, 
      0,   0,   0,   0,   0, 200, 
      1,   0,   0,  48,   0,   0, 
      0,   8,   0,   0,   0,   0, 
      0,   0,   0, 212,   1,   0, 
      0,   0,   0,   0,   0, 228, 
      1,   0,   0,  64,   0,   0, 
      0,  12,   0,   0,   0,   2, 
      0,   0,   0, 236,   1,   0, 
      0,   0,   0,   0,   0, 252, 
      1,   0,   0,  80,   0,   0, 
      0,   8,   0,   0,   0,   2, 
      0,   0,   0, 212,   1,   0, 
      0,   0,   0,   0,   0,   4, 
      2,   0,   0,  88,   0,   0, 
      0,   4,   0,   0,   0,   2, 
      0,   0,   0,   8,   2,   0, 
      0,   0,   0,   0,   0,  24, 
      2,   0,   0,  92,   0,   0, 
      0,   4,   0,   0,   0,   2, 
      0,   0,   0,   8,   2,   0, 
      0,   0,   0,   0,   0,  32, 
      2,   0,   0,  96,   0,   0, 
      0,   4,   0,   0,   0,   2, 
      0,   0,   0,   8,   2,   0, 
      0,   0,   0,   0,   0,  68, 
    101, 118, 105,  99, 101,  83, 
    112,  97,  99, 101,  84, 111, 
     85, 115, 101, 114,  83, 112, 
     97,  99, 101,   0, 171,   3, 
      0,   3,   0,   3,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 100, 105, 109, 
    101, 110, 115, 105, 111, 110, 
    115,   0, 171,   1,   0,   3, 
      0,   1,   0,   2,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 100, 105, 102, 102,   0, 
    171, 171, 171,   1,   0,   3, 
      0,   1,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  99, 101, 110, 116, 101, 
    114,  49,   0,  65,   0, 171, 
    171,   0,   0,   3,   0,   1, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 114, 
     97, 100, 105, 117, 115,  49, 
      0, 115, 113,  95, 114,  97, 
    100, 105, 117, 115,  49,   0, 
     77, 105,  99, 114, 111, 115, 
    111, 102, 116,  32,  40,  82, 
     41,  32,  72,  76,  83,  76, 
     32,  83, 104,  97, 100, 101, 
    114,  32,  67, 111, 109, 112, 
    105, 108, 101, 114,  32,  57, 
     46,  50,  57,  46,  57,  53, 
     50,  46,  51,  49,  49,  49, 
      0,  73,  83,  71,  78, 104, 
      0,   0,   0,   3,   0,   0, 
      0,   8,   0,   0,   0,  80, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  15,   0,   0,   0,  92, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,   3,   3,   0,   0,  92, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,  12,  12,   0,   0,  83, 
     86,  95,  80, 111, 115, 105, 
    116, 105, 111, 110,   0,  84, 
     69,  88,  67,  79,  79,  82, 
     68,   0, 171, 171, 171,  79, 
     83,  71,  78,  44,   0,   0, 
      0,   1,   0,   0,   0,   8, 
      0,   0,   0,  32,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  15, 
      0,   0,   0,  83,  86,  95, 
     84,  97, 114, 103, 101, 116, 
      0, 171, 171,  21,  19,   0, 
      0,   0,   0,   0,   0,  65, 
     48,   0,  40,   7,   0,   0, 
     68,  88,  66,  67, 237,  58, 
    124, 168, 122, 234, 242,   5, 
     75,  29, 195,   6, 241, 206, 
    131, 117,   1,   0,   0,   0, 
     40,   7,   0,   0,   6,   0, 
      0,   0,  56,   0,   0,   0, 
    148,   1,   0,   0, 104,   3, 
      0,   0, 228,   3,   0,   0, 
    132,   6,   0,   0, 184,   6, 
      0,   0,  65, 111, 110,  57, 
     84,   1,   0,   0,  84,   1, 
      0,   0,   0,   2, 254, 255, 
    252,   0,   0,   0,  88,   0, 
      0,   0,   4,   0,  36,   0, 
      0,   0,  84,   0,   0,   0, 
     84,   0,   0,   0,  36,   0, 
      1,   0,  84,   0,   0,   0, 
      0,   0,   1,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   1,   0,   2,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   3,   0, 
      0,   0,   0,   0,   1,   0, 
      3,   0,   1,   0,   5,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   2, 254, 255, 
     81,   0,   0,   5,   6,   0, 
     15, 160,   0,   0, 128,  63, 
      0,   0,   0,  63,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     31,   0,   0,   2,   5,   0, 
      0, 128,   0,   0,  15, 144, 
      4,   0,   0,   4,   0,   0, 
      3, 224,   0,   0, 228, 144, 
      2,   0, 238, 160,   2,   0, 
    228, 160,   4,   0,   0,   4, 
      0,   0,   3, 128,   0,   0, 
    228, 144,   1,   0, 238, 160, 
      1,   0, 228, 160,   2,   0, 
      0,   3,   0,   0,   4, 128, 
      0,   0,   0, 128,   6,   0, 
      0, 160,   5,   0,   0,   3, 
      0,   0,   4, 128,   0,   0, 
    170, 128,   5,   0,   0, 160, 
      5,   0,   0,   3,   1,   0, 
      1, 128,   0,   0, 170, 128, 
      6,   0,  85, 160,   2,   0, 
      0,   3,   0,   0,   4, 128, 
      0,   0,  85, 129,   6,   0, 
      0, 160,   2,   0,   0,   3, 
      0,   0,   3, 192,   0,   0, 
    228, 128,   0,   0, 228, 160, 
      5,   0,   0,   3,   0,   0, 
      1, 128,   0,   0, 170, 128, 
      5,   0,  85, 160,   5,   0, 
      0,   3,   1,   0,   2, 128, 
      0,   0,   0, 128,   6,   0, 
     85, 160,   1,   0,   0,   2, 
      1,   0,   4, 128,   6,   0, 
      0, 160,   8,   0,   0,   3, 
      0,   0,   8, 224,   1,   0, 
    228, 128,   3,   0, 228, 160, 
      8,   0,   0,   3,   0,   0, 
      4, 224,   1,   0, 228, 128, 
      4,   0, 228, 160,   1,   0, 
      0,   2,   0,   0,  12, 192, 
      6,   0,  36, 160, 255, 255, 
      0,   0,  83,  72,  68,  82, 
    204,   1,   0,   0,  64,   0, 
      1,   0, 115,   0,   0,   0, 
     89,   0,   0,   4,  70, 142, 
     32,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,  89,   0, 
      0,   4,  70, 142,  32,   0, 
      1,   0,   0,   0,   4,   0, 
      0,   0,  95,   0,   0,   3, 
     50,  16,  16,   0,   0,   0, 
      0,   0, 103,   0,   0,   4, 
    242,  32,  16,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    101,   0,   0,   3,  50,  32, 
     16,   0,   1,   0,   0,   0, 
    101,   0,   0,   3, 194,  32, 
     16,   0,   1,   0,   0,   0, 
    104,   0,   0,   2,   2,   0, 
      0,   0,  54,   0,   0,   8, 
    194,  32,  16,   0,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 128,  63,  50,   0, 
      0,  11,  50,   0,  16,   0, 
      0,   0,   0,   0,  70,  16, 
     16,   0,   0,   0,   0,   0, 
    230, 138,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     70, 128,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     54,   0,   0,   5,  50,  32, 
     16,   0,   0,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,   0,   0,   0,   7, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  10,   0,  16,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,   0,   0, 128,  63, 
      0,   0,   0,   8,  34,   0, 
     16,   0,   0,   0,   0,   0, 
     26,   0,  16, 128,  65,   0, 
      0,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
    128,  63,  56,   0,   0,   8, 
     50,   0,  16,   0,   0,   0, 
      0,   0,  70,   0,  16,   0, 
      0,   0,   0,   0,  70, 128, 
     32,   0,   1,   0,   0,   0, 
      3,   0,   0,   0,  56,   0, 
      0,  10,  50,   0,  16,   0, 
      1,   0,   0,   0,  70,   0, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,  63,   0,   0,   0,  63, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  54,   0,   0,   5, 
     66,   0,  16,   0,   1,   0, 
      0,   0,   1,  64,   0,   0, 
      0,   0, 128,  63,  16,   0, 
      0,   8,  66,  32,  16,   0, 
      1,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
     70, 130,  32,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
     16,   0,   0,   8, 130,  32, 
     16,   0,   1,   0,   0,   0, 
     70,   2,  16,   0,   1,   0, 
      0,   0,  70, 130,  32,   0, 
      1,   0,   0,   0,   1,   0, 
      0,   0,  50,   0,   0,  11, 
     50,  32,  16,   0,   1,   0, 
      0,   0,  70,  16,  16,   0, 
      0,   0,   0,   0, 230, 138, 
     32,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,  70, 128, 
     32,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,  62,   0, 
      0,   1,  83,  84,  65,  84, 
    116,   0,   0,   0,  12,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,   6,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     82,  68,  69,  70, 152,   2, 
      0,   0,   2,   0,   0,   0, 
    100,   0,   0,   0,   2,   0, 
      0,   0,  28,   0,   0,   0, 
      0,   4, 254, 255,   0,   1, 
      0,   0, 103,   2,   0,   0, 
     92,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,  96,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,  99,  98, 
     48,   0,  99,  98,  50,   0, 
     92,   0,   0,   0,   4,   0, 
      0,   0, 148,   0,   0,   0, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     96,   0,   0,   0,   7,   0, 
      0,   0,  52,   1,   0,   0, 
    112,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    244,   0,   0,   0,   0,   0, 
      0,   0,  16,   0,   0,   0, 
      2,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
     16,   1,   0,   0,  16,   0, 
      0,   0,  16,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
     26,   1,   0,   0,  32,   0, 
      0,   0,  16,   0,   0,   0, 
      2,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
     40,   1,   0,   0,  48,   0, 
      0,   0,  16,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
     81, 117,  97, 100,  68, 101, 
    115,  99,   0, 171, 171, 171, 
      1,   0,   3,   0,   1,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  84, 101, 
    120,  67, 111, 111, 114, 100, 
    115,   0,  77,  97, 115, 107, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  84, 101, 
    120, 116,  67, 111, 108, 111, 
    114,   0, 171, 171, 220,   1, 
      0,   0,   0,   0,   0,   0, 
     44,   0,   0,   0,   2,   0, 
      0,   0, 244,   1,   0,   0, 
      0,   0,   0,   0,   4,   2, 
      0,   0,  48,   0,   0,   0, 
      8,   0,   0,   0,   2,   0, 
      0,   0,  16,   2,   0,   0, 
      0,   0,   0,   0,  32,   2, 
      0,   0,  64,   0,   0,   0, 
     12,   0,   0,   0,   0,   0, 
      0,   0,  40,   2,   0,   0, 
      0,   0,   0,   0,  56,   2, 
      0,   0,  80,   0,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0,  16,   2,   0,   0, 
      0,   0,   0,   0,  64,   2, 
      0,   0,  88,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,  68,   2,   0,   0, 
      0,   0,   0,   0,  84,   2, 
      0,   0,  92,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,  68,   2,   0,   0, 
      0,   0,   0,   0,  92,   2, 
      0,   0,  96,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,  68,   2,   0,   0, 
      0,   0,   0,   0,  68, 101, 
    118, 105,  99, 101,  83, 112, 
     97,  99, 101,  84, 111,  85, 
    115, 101, 114,  83, 112,  97, 
     99, 101,   0, 171,   3,   0, 
      3,   0,   3,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 100, 105, 109, 101, 
    110, 115, 105, 111, 110, 115, 
      0, 171,   1,   0,   3,   0, 
      1,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    100, 105, 102, 102,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     99, 101, 110, 116, 101, 114, 
     49,   0,  65,   0, 171, 171, 
      0,   0,   3,   0,   1,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 114,  97, 
    100, 105, 117, 115,  49,   0, 
    115, 113,  95, 114,  97, 100, 
    105, 117, 115,  49,   0,  77, 
    105,  99, 114, 111, 115, 111, 
    102, 116,  32,  40,  82,  41, 
     32,  72,  76,  83,  76,  32, 
     83, 104,  97, 100, 101, 114, 
     32,  67, 111, 109, 112, 105, 
    108, 101, 114,  32,  57,  46, 
     50,  57,  46,  57,  53,  50, 
     46,  51,  49,  49,  49,   0, 
     73,  83,  71,  78,  44,   0, 
      0,   0,   1,   0,   0,   0, 
      8,   0,   0,   0,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   3,   0,   0,  80,  79, 
     83,  73,  84,  73,  79,  78, 
      0, 171, 171, 171,  79,  83, 
     71,  78, 104,   0,   0,   0, 
      3,   0,   0,   0,   8,   0, 
      0,   0,  80,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   3,  12, 
      0,   0,  92,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,  12,   3, 
      0,   0,  83,  86,  95,  80, 
    111, 115, 105, 116, 105, 111, 
    110,   0,  84,  69,  88,  67, 
     79,  79,  82,  68,   0, 171, 
    171, 171,   0,  29,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0, 188,   7, 
      0,   0,  68,  88,  66,  67, 
    158, 207, 216, 153, 107, 204, 
    140, 217, 118, 241, 126, 175, 
    204, 121,  49,  49,   1,   0, 
      0,   0, 188,   7,   0,   0, 
      6,   0,   0,   0,  56,   0, 
      0,   0, 196,   1,   0,   0, 
     56,   4,   0,   0, 180,   4, 
      0,   0,  24,   7,   0,   0, 
    136,   7,   0,   0,  65, 111, 
    110,  57, 132,   1,   0,   0, 
    132,   1,   0,   0,   0,   2, 
    255, 255,  76,   1,   0,   0, 
     56,   0,   0,   0,   1,   0, 
     44,   0,   0,   0,  56,   0, 
      0,   0,  56,   0,   2,   0, 
     36,   0,   0,   0,  56,   0, 
      0,   0,   0,   0,   1,   1, 
      1,   0,   0,   0,   4,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   1,   2, 255, 255, 
     81,   0,   0,   5,   2,   0, 
     15, 160,   0,   0,   0,  63, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     31,   0,   0,   2,   0,   0, 
      0, 128,   0,   0,  15, 176, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   0,   8,  15, 160, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   1,   8,  15, 160, 
      5,   0,   0,   3,   0,   0, 
      8, 128,   1,   0, 255, 160, 
      1,   0, 255, 160,   2,   0, 
      0,   3,   0,   0,   3, 128, 
      0,   0, 235, 176,   1,   0, 
    228, 161,  90,   0,   0,   4, 
      0,   0,   8, 128,   0,   0, 
    228, 128,   0,   0, 228, 128, 
      0,   0, 255, 129,   5,   0, 
      0,   3,   0,   0,   8, 128, 
      0,   0, 255, 128,   2,   0, 
      0, 160,   1,   0,   0,   2, 
      0,   0,   4, 128,   1,   0, 
    255, 160,   8,   0,   0,   3, 
      0,   0,   1, 128,   0,   0, 
    228, 128,   0,   0, 228, 160, 
      6,   0,   0,   2,   0,   0, 
      1, 128,   0,   0,   0, 128, 
      5,   0,   0,   3,   0,   0, 
      1, 128,   0,   0,   0, 128, 
      0,   0, 255, 128,   1,   0, 
      0,   2,   0,   0,   2, 128, 
      2,   0,   0, 160,  66,   0, 
      0,   3,   1,   0,  15, 128, 
      0,   0, 228, 176,   1,   8, 
    228, 160,  66,   0,   0,   3, 
      2,   0,  15, 128,   0,   0, 
    228, 128,   0,   8, 228, 160, 
      1,   0,   0,   2,   0,   0, 
      8, 128,   1,   0, 255, 160, 
      4,   0,   0,   4,   0,   0, 
      1, 128,   0,   0,   0, 128, 
      0,   0, 170, 161,   0,   0, 
    255, 129,   5,   0,   0,   3, 
      2,   0,   7, 128,   2,   0, 
    255, 128,   2,   0, 228, 128, 
      5,   0,   0,   3,   1,   0, 
     15, 128,   1,   0, 255, 128, 
      2,   0, 228, 128,  88,   0, 
      0,   4,   0,   0,  15, 128, 
      0,   0,   0, 128,   2,   0, 
     85, 160,   1,   0, 228, 128, 
      1,   0,   0,   2,   0,   8, 
     15, 128,   0,   0, 228, 128, 
    255, 255,   0,   0,  83,  72, 
     68,  82, 108,   2,   0,   0, 
     64,   0,   0,   0, 155,   0, 
      0,   0,  89,   0,   0,   4, 
     70, 142,  32,   0,   0,   0, 
      0,   0,   6,   0,   0,   0, 
     90,   0,   0,   3,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     90,   0,   0,   3,   0,  96, 
     16,   0,   1,   0,   0,   0, 
     88,  24,   0,   4,   0, 112, 
     16,   0,   0,   0,   0,   0, 
     85,  85,   0,   0,  88,  24, 
      0,   4,   0, 112,  16,   0, 
      1,   0,   0,   0,  85,  85, 
      0,   0,  98,  16,   0,   3, 
     50,  16,  16,   0,   1,   0, 
      0,   0,  98,  16,   0,   3, 
    194,  16,  16,   0,   1,   0, 
      0,   0, 101,   0,   0,   3, 
    242,  32,  16,   0,   0,   0, 
      0,   0, 104,   0,   0,   2, 
      2,   0,   0,   0,   0,   0, 
      0,   9,  50,   0,  16,   0, 
      0,   0,   0,   0, 230,  26, 
     16,   0,   1,   0,   0,   0, 
     70, 128,  32, 128,  65,   0, 
      0,   0,   0,   0,   0,   0, 
      5,   0,   0,   0,  54,   0, 
      0,   6,  66,   0,  16,   0, 
      0,   0,   0,   0,  58, 128, 
     32,   0,   0,   0,   0,   0, 
      5,   0,   0,   0,  16,   0, 
      0,   8,  66,   0,  16,   0, 
      0,   0,   0,   0,  70,   2, 
     16,   0,   0,   0,   0,   0, 
     70, 130,  32,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
     15,   0,   0,   7,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,  70,   0,  16,   0, 
      0,   0,   0,   0,  50,   0, 
      0,  12,  18,   0,  16,   0, 
      0,   0,   0,   0,  58, 128, 
     32, 128,  65,   0,   0,   0, 
      0,   0,   0,   0,   5,   0, 
      0,   0,  58, 128,  32,   0, 
      0,   0,   0,   0,   5,   0, 
      0,   0,  10,   0,  16,   0, 
      0,   0,   0,   0,  56,   0, 
      0,   7,  18,   0,  16,   0, 
      0,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,  63,  14,   0,   0,   7, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  10,   0,  16,   0, 
      0,   0,   0,   0,  42,   0, 
     16,   0,   0,   0,   0,   0, 
     56,   0,   0,   8,  66,   0, 
     16,   0,   0,   0,   0,   0, 
     10,   0,  16,   0,   0,   0, 
      0,   0,  42, 128,  32,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,  29,   0,   0,   9, 
     66,   0,  16,   0,   0,   0, 
      0,   0,  58, 128,  32, 128, 
     65,   0,   0,   0,   0,   0, 
      0,   0,   5,   0,   0,   0, 
     42,   0,  16,   0,   0,   0, 
      0,   0,  54,   0,   0,   5, 
     34,   0,  16,   0,   0,   0, 
      0,   0,   1,  64,   0,   0, 
      0,   0,   0,  63,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      1,   0,   0,   0,  70,   0, 
     16,   0,   0,   0,   0,   0, 
     70, 126,  16,   0,   0,   0, 
      0,   0,   0,  96,  16,   0, 
      0,   0,   0,   0,  31,   0, 
      4,   3,  42,   0,  16,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   8, 242,  32,  16,   0, 
      0,   0,   0,   0,   2,  64, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     62,   0,   0,   1,  21,   0, 
      0,   1,  56,   0,   0,   7, 
    114,   0,  16,   0,   1,   0, 
      0,   0, 246,  15,  16,   0, 
      1,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   0,   0,   0,   0, 
     70,  16,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      1,   0,   0,   0,   0,  96, 
     16,   0,   1,   0,   0,   0, 
     56,   0,   0,   7, 242,  32, 
     16,   0,   0,   0,   0,   0, 
    246,  15,  16,   0,   0,   0, 
      0,   0,  70,  14,  16,   0, 
      1,   0,   0,   0,  62,   0, 
      0,   1,  83,  84,  65,  84, 
    116,   0,   0,   0,  19,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   9,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     82,  68,  69,  70,  92,   2, 
      0,   0,   1,   0,   0,   0, 
    224,   0,   0,   0,   5,   0, 
      0,   0,  28,   0,   0,   0, 
      0,   4, 255, 255,   0,   1, 
      0,   0,  43,   2,   0,   0, 
    188,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 197,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 210,   0, 
      0,   0,   2,   0,   0,   0, 
      5,   0,   0,   0,   4,   0, 
      0,   0, 255, 255, 255, 255, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  12,   0,   0,   0, 
    214,   0,   0,   0,   2,   0, 
      0,   0,   5,   0,   0,   0, 
      4,   0,   0,   0, 255, 255, 
    255, 255,   1,   0,   0,   0, 
      1,   0,   0,   0,  12,   0, 
      0,   0, 219,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 115,  83, 
     97, 109, 112, 108, 101, 114, 
      0, 115,  77,  97, 115, 107, 
     83,  97, 109, 112, 108, 101, 
    114,   0, 116, 101, 120,   0, 
    109,  97, 115, 107,   0,  99, 
     98,  50,   0, 171, 219,   0, 
      0,   0,   7,   0,   0,   0, 
    248,   0,   0,   0, 112,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 160,   1, 
      0,   0,   0,   0,   0,   0, 
     44,   0,   0,   0,   0,   0, 
      0,   0, 184,   1,   0,   0, 
      0,   0,   0,   0, 200,   1, 
      0,   0,  48,   0,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0, 212,   1,   0,   0, 
      0,   0,   0,   0, 228,   1, 
      0,   0,  64,   0,   0,   0, 
     12,   0,   0,   0,   2,   0, 
      0,   0, 236,   1,   0,   0, 
      0,   0,   0,   0, 252,   1, 
      0,   0,  80,   0,   0,   0, 
      8,   0,   0,   0,   2,   0, 
      0,   0, 212,   1,   0,   0, 
      0,   0,   0,   0,   4,   2, 
      0,   0,  88,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   8,   2,   0,   0, 
      0,   0,   0,   0,  24,   2, 
      0,   0,  92,   0,   0,   0, 
      4,   0,   0,   0,   2,   0, 
      0,   0,   8,   2,   0,   0, 
      0,   0,   0,   0,  32,   2, 
      0,   0,  96,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   8,   2,   0,   0, 
      0,   0,   0,   0,  68, 101, 
    118, 105,  99, 101,  83, 112, 
     97,  99, 101,  84, 111,  85, 
    115, 101, 114,  83, 112,  97, 
     99, 101,   0, 171,   3,   0, 
      3,   0,   3,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 100, 105, 109, 101, 
    110, 115, 105, 111, 110, 115, 
      0, 171,   1,   0,   3,   0, 
      1,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    100, 105, 102, 102,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     99, 101, 110, 116, 101, 114, 
     49,   0,  65,   0, 171, 171, 
      0,   0,   3,   0,   1,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 114,  97, 
    100, 105, 117, 115,  49,   0, 
    115, 113,  95, 114,  97, 100, 
    105, 117, 115,  49,   0,  77, 
    105,  99, 114, 111, 115, 111, 
    102, 116,  32,  40,  82,  41, 
     32,  72,  76,  83,  76,  32, 
     83, 104,  97, 100, 101, 114, 
     32,  67, 111, 109, 112, 105, 
    108, 101, 114,  32,  57,  46, 
     50,  57,  46,  57,  53,  50, 
     46,  51,  49,  49,  49,   0, 
     73,  83,  71,  78, 104,   0, 
      0,   0,   3,   0,   0,   0, 
      8,   0,   0,   0,  80,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  92,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   3,   0,   0,  92,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
     12,  12,   0,   0,  83,  86, 
     95,  80, 111, 115, 105, 116, 
    105, 111, 110,   0,  84,  69, 
     88,  67,  79,  79,  82,  68, 
      0, 171, 171, 171,  79,  83, 
     71,  78,  44,   0,   0,   0, 
      1,   0,   0,   0,   8,   0, 
      0,   0,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  83,  86,  95,  84, 
     97, 114, 103, 101, 116,   0, 
    171, 171,  64,  36,   0,   0, 
      0,   0,   0,   0,  65,  80, 
    111, 115,  87, 114,  97, 112, 
      0,  40,   7,   0,   0,  68, 
     88,  66,  67, 237,  58, 124, 
    168, 122, 234, 242,   5,  75, 
     29, 195,   6, 241, 206, 131, 
    117,   1,   0,   0,   0,  40, 
      7,   0,   0,   6,   0,   0, 
      0,  56,   0,   0,   0, 148, 
      1,   0,   0, 104,   3,   0, 
      0, 228,   3,   0,   0, 132, 
      6,   0,   0, 184,   6,   0, 
      0,  65, 111, 110,  57,  84, 
      1,   0,   0,  84,   1,   0, 
      0,   0,   2, 254, 255, 252, 
      0,   0,   0,  88,   0,   0, 
      0,   4,   0,  36,   0,   0, 
      0,  84,   0,   0,   0,  84, 
      0,   0,   0,  36,   0,   1, 
      0,  84,   0,   0,   0,   0, 
      0,   1,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   2, 
      0,   1,   0,   2,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   2,   0,   3,   0,   0, 
      0,   0,   0,   1,   0,   3, 
      0,   1,   0,   5,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   2, 254, 255,  81, 
      0,   0,   5,   6,   0,  15, 
    160,   0,   0, 128,  63,   0, 
      0,   0,  63,   0,   0,   0, 
      0,   0,   0,   0,   0,  31, 
      0,   0,   2,   5,   0,   0, 
    128,   0,   0,  15, 144,   4, 
      0,   0,   4,   0,   0,   3, 
    224,   0,   0, 228, 144,   2, 
      0, 238, 160,   2,   0, 228, 
    160,   4,   0,   0,   4,   0, 
      0,   3, 128,   0,   0, 228, 
    144,   1,   0, 238, 160,   1, 
      0, 228, 160,   2,   0,   0, 
      3,   0,   0,   4, 128,   0, 
      0,   0, 128,   6,   0,   0, 
    160,   5,   0,   0,   3,   0, 
      0,   4, 128,   0,   0, 170, 
    128,   5,   0,   0, 160,   5, 
      0,   0,   3,   1,   0,   1, 
    128,   0,   0, 170, 128,   6, 
      0,  85, 160,   2,   0,   0, 
      3,   0,   0,   4, 128,   0, 
      0,  85, 129,   6,   0,   0, 
    160,   2,   0,   0,   3,   0, 
      0,   3, 192,   0,   0, 228, 
    128,   0,   0, 228, 160,   5, 
      0,   0,   3,   0,   0,   1, 
    128,   0,   0, 170, 128,   5, 
      0,  85, 160,   5,   0,   0, 
      3,   1,   0,   2, 128,   0, 
      0,   0, 128,   6,   0,  85, 
    160,   1,   0,   0,   2,   1, 
      0,   4, 128,   6,   0,   0, 
    160,   8,   0,   0,   3,   0, 
      0,   8, 224,   1,   0, 228, 
    128,   3,   0, 228, 160,   8, 
      0,   0,   3,   0,   0,   4, 
    224,   1,   0, 228, 128,   4, 
      0, 228, 160,   1,   0,   0, 
      2,   0,   0,  12, 192,   6, 
      0,  36, 160, 255, 255,   0, 
      0,  83,  72,  68,  82, 204, 
      1,   0,   0,  64,   0,   1, 
      0, 115,   0,   0,   0,  89, 
      0,   0,   4,  70, 142,  32, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,  89,   0,   0, 
      4,  70, 142,  32,   0,   1, 
      0,   0,   0,   4,   0,   0, 
      0,  95,   0,   0,   3,  50, 
     16,  16,   0,   0,   0,   0, 
      0, 103,   0,   0,   4, 242, 
     32,  16,   0,   0,   0,   0, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3,  50,  32,  16, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3, 194,  32,  16, 
      0,   1,   0,   0,   0, 104, 
      0,   0,   2,   2,   0,   0, 
      0,  54,   0,   0,   8, 194, 
     32,  16,   0,   0,   0,   0, 
      0,   2,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 128,  63,  50,   0,   0, 
     11,  50,   0,  16,   0,   0, 
      0,   0,   0,  70,  16,  16, 
      0,   0,   0,   0,   0, 230, 
    138,  32,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  70, 
    128,  32,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   5,  50,  32,  16, 
      0,   0,   0,   0,   0,  70, 
      0,  16,   0,   0,   0,   0, 
      0,   0,   0,   0,   7,  18, 
      0,  16,   0,   0,   0,   0, 
      0,  10,   0,  16,   0,   0, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0, 128,  63,   0, 
      0,   0,   8,  34,   0,  16, 
      0,   0,   0,   0,   0,  26, 
      0,  16, 128,  65,   0,   0, 
      0,   0,   0,   0,   0,   1, 
     64,   0,   0,   0,   0, 128, 
     63,  56,   0,   0,   8,  50, 
      0,  16,   0,   0,   0,   0, 
      0,  70,   0,  16,   0,   0, 
      0,   0,   0,  70, 128,  32, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,  56,   0,   0, 
     10,  50,   0,  16,   0,   1, 
      0,   0,   0,  70,   0,  16, 
      0,   0,   0,   0,   0,   2, 
     64,   0,   0,   0,   0,   0, 
     63,   0,   0,   0,  63,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  54,   0,   0,   5,  66, 
      0,  16,   0,   1,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0, 128,  63,  16,   0,   0, 
      8,  66,  32,  16,   0,   1, 
      0,   0,   0,  70,   2,  16, 
      0,   1,   0,   0,   0,  70, 
    130,  32,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,  16, 
      0,   0,   8, 130,  32,  16, 
      0,   1,   0,   0,   0,  70, 
      2,  16,   0,   1,   0,   0, 
      0,  70, 130,  32,   0,   1, 
      0,   0,   0,   1,   0,   0, 
      0,  50,   0,   0,  11,  50, 
     32,  16,   0,   1,   0,   0, 
      0,  70,  16,  16,   0,   0, 
      0,   0,   0, 230, 138,  32, 
      0,   0,   0,   0,   0,   2, 
      0,   0,   0,  70, 128,  32, 
      0,   0,   0,   0,   0,   2, 
      0,   0,   0,  62,   0,   0, 
      1,  83,  84,  65,  84, 116, 
      0,   0,   0,  12,   0,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   4,   0,   0, 
      0,   6,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  82, 
     68,  69,  70, 152,   2,   0, 
      0,   2,   0,   0,   0, 100, 
      0,   0,   0,   2,   0,   0, 
      0,  28,   0,   0,   0,   0, 
      4, 254, 255,   0,   1,   0, 
      0, 103,   2,   0,   0,  92, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,  96,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,  99,  98,  48, 
      0,  99,  98,  50,   0,  92, 
      0,   0,   0,   4,   0,   0, 
      0, 148,   0,   0,   0,  64, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  96, 
      0,   0,   0,   7,   0,   0, 
      0,  52,   1,   0,   0, 112, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 244, 
      0,   0,   0,   0,   0,   0, 
      0,  16,   0,   0,   0,   2, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,  16, 
      1,   0,   0,  16,   0,   0, 
      0,  16,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,  26, 
      1,   0,   0,  32,   0,   0, 
      0,  16,   0,   0,   0,   2, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,  40, 
      1,   0,   0,  48,   0,   0, 
      0,  16,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,  81, 
    117,  97, 100,  68, 101, 115, 
     99,   0, 171, 171, 171,   1, 
      0,   3,   0,   1,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  84, 101, 120, 
     67, 111, 111, 114, 100, 115, 
      0,  77,  97, 115, 107,  84, 
    101, 120,  67, 111, 111, 114, 
    100, 115,   0,  84, 101, 120, 
    116,  67, 111, 108, 111, 114, 
      0, 171, 171, 220,   1,   0, 
      0,   0,   0,   0,   0,  44, 
      0,   0,   0,   2,   0,   0, 
      0, 244,   1,   0,   0,   0, 
      0,   0,   0,   4,   2,   0, 
      0,  48,   0,   0,   0,   8, 
      0,   0,   0,   2,   0,   0, 
      0,  16,   2,   0,   0,   0, 
      0,   0,   0,  32,   2,   0, 
      0,  64,   0,   0,   0,  12, 
      0,   0,   0,   0,   0,   0, 
      0,  40,   2,   0,   0,   0, 
      0,   0,   0,  56,   2,   0, 
      0,  80,   0,   0,   0,   8, 
      0,   0,   0,   0,   0,   0, 
      0,  16,   2,   0,   0,   0, 
      0,   0,   0,  64,   2,   0, 
      0,  88,   0,   0,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      0,  68,   2,   0,   0,   0, 
      0,   0,   0,  84,   2,   0, 
      0,  92,   0,   0,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      0,  68,   2,   0,   0,   0, 
      0,   0,   0,  92,   2,   0, 
      0,  96,   0,   0,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      0,  68,   2,   0,   0,   0, 
      0,   0,   0,  68, 101, 118, 
    105,  99, 101,  83, 112,  97, 
     99, 101,  84, 111,  85, 115, 
    101, 114,  83, 112,  97,  99, 
    101,   0, 171,   3,   0,   3, 
      0,   3,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 100, 105, 109, 101, 110, 
    115, 105, 111, 110, 115,   0, 
    171,   1,   0,   3,   0,   1, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 100, 
    105, 102, 102,   0, 171, 171, 
    171,   1,   0,   3,   0,   1, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  99, 
    101, 110, 116, 101, 114,  49, 
      0,  65,   0, 171, 171,   0, 
      0,   3,   0,   1,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 114,  97, 100, 
    105, 117, 115,  49,   0, 115, 
    113,  95, 114,  97, 100, 105, 
    117, 115,  49,   0,  77, 105, 
     99, 114, 111, 115, 111, 102, 
    116,  32,  40,  82,  41,  32, 
     72,  76,  83,  76,  32,  83, 
    104,  97, 100, 101, 114,  32, 
     67, 111, 109, 112, 105, 108, 
    101, 114,  32,  57,  46,  50, 
     57,  46,  57,  53,  50,  46, 
     51,  49,  49,  49,   0,  73, 
     83,  71,  78,  44,   0,   0, 
      0,   1,   0,   0,   0,   8, 
      0,   0,   0,  32,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   7, 
      3,   0,   0,  80,  79,  83, 
     73,  84,  73,  79,  78,   0, 
    171, 171, 171,  79,  83,  71, 
     78, 104,   0,   0,   0,   3, 
      0,   0,   0,   8,   0,   0, 
      0,  80,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,  15,   0,   0, 
      0,  92,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   1, 
      0,   0,   0,   3,  12,   0, 
      0,  92,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   1, 
      0,   0,   0,  12,   3,   0, 
      0,  83,  86,  95,  80, 111, 
    115, 105, 116, 105, 111, 110, 
      0,  84,  69,  88,  67,  79, 
     79,  82,  68,   0, 171, 171, 
    171,  17,  44,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0, 224,   9,   0, 
      0,  68,  88,  66,  67,  24, 
    242,  43,  93, 196,  38, 133, 
    163, 204,  85, 187,  56, 214, 
     99,  96, 127,   1,   0,   0, 
      0, 224,   9,   0,   0,   6, 
      0,   0,   0,  56,   0,   0, 
      0, 128,   2,   0,   0,  88, 
      6,   0,   0, 212,   6,   0, 
      0,  60,   9,   0,   0, 172, 
      9,   0,   0,  65, 111, 110, 
     57,  64,   2,   0,   0,  64, 
      2,   0,   0,   0,   2, 255, 
    255,   8,   2,   0,   0,  56, 
      0,   0,   0,   1,   0,  44, 
      0,   0,   0,  56,   0,   0, 
      0,  56,   0,   2,   0,  36, 
      0,   0,   0,  56,   0,   0, 
      0,   0,   0,   1,   1,   1, 
      0,   0,   0,   4,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   2, 255, 255,  81, 
      0,   0,   5,   3,   0,  15, 
    160,   0,   0,   0,  63,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  81, 
      0,   0,   5,   4,   0,  15, 
    160,   0,   0, 128,  63,   0, 
      0, 128, 191,   0,   0,   0, 
      0,   0,   0,   0, 128,  31, 
      0,   0,   2,   0,   0,   0, 
    128,   0,   0,  15, 176,  31, 
      0,   0,   2,   0,   0,   0, 
    144,   0,   8,  15, 160,  31, 
      0,   0,   2,   0,   0,   0, 
    144,   1,   8,  15, 160,   2, 
      0,   0,   3,   0,   0,   3, 
    128,   0,   0, 235, 176,   1, 
      0, 228, 161,  90,   0,   0, 
      4,   0,   0,   8, 128,   0, 
      0, 228, 128,   0,   0, 228, 
    128,   2,   0,   0, 161,   5, 
      0,   0,   3,   0,   0,   8, 
    128,   0,   0, 255, 128,   1, 
      0, 170, 160,   1,   0,   0, 
      2,   0,   0,   4, 128,   1, 
      0, 255, 160,   8,   0,   0, 
      3,   0,   0,   1, 128,   0, 
      0, 228, 128,   0,   0, 228, 
    160,   4,   0,   0,   4,   0, 
      0,   2, 128,   0,   0,   0, 
    128,   0,   0,   0, 128,   0, 
      0, 255, 129,  35,   0,   0, 
      2,   0,   0,   4, 128,   0, 
      0,  85, 128,   7,   0,   0, 
      2,   0,   0,   4, 128,   0, 
      0, 170, 128,   6,   0,   0, 
      2,   1,   0,   1, 128,   0, 
      0, 170, 128,   1,   0,   0, 
      2,   1,   0,   6, 128,   1, 
      0,   0, 129,   2,   0,   0, 
      3,   0,   0,  13, 128,   0, 
      0,   0, 128,   1,   0, 148, 
    128,   6,   0,   0,   2,   1, 
      0,   1, 128,   1,   0, 170, 
    160,   5,   0,   0,   3,   0, 
      0,  13, 128,   0,   0, 228, 
    128,   1,   0,   0, 128,   1, 
      0,   0,   2,   1,   0,   8, 
    128,   1,   0, 255, 160,   4, 
      0,   0,   4,   1,   0,   7, 
    128,   0,   0, 248, 128,   0, 
      0, 170, 160,   1,   0, 255, 
    128,  88,   0,   0,   4,   2, 
      0,   1, 128,   1,   0,   0, 
    128,   0,   0,   0, 128,   0, 
      0, 255, 128,  88,   0,   0, 
      4,   0,   0,  13, 128,   1, 
      0, 148, 128,   4,   0,  68, 
    160,   4,   0, 230, 160,   1, 
      0,   0,   2,   2,   0,   2, 
    128,   3,   0,   0, 160,  66, 
      0,   0,   3,   1,   0,  15, 
    128,   0,   0, 228, 176,   1, 
      8, 228, 160,  66,   0,   0, 
      3,   2,   0,  15, 128,   2, 
      0, 228, 128,   0,   8, 228, 
    160,   5,   0,   0,   3,   2, 
      0,   7, 128,   2,   0, 255, 
    128,   2,   0, 228, 128,   5, 
      0,   0,   3,   1,   0,  15, 
    128,   1,   0, 255, 128,   2, 
      0, 228, 128,   2,   0,   0, 
      3,   0,   0,   8, 128,   0, 
      0, 255, 128,   0,   0,   0, 
    128,  88,   0,   0,   4,   0, 
      0,   1, 128,   0,   0, 255, 
    128,   0,   0,   0, 128,   0, 
      0, 170, 128,  88,   0,   0, 
      4,   1,   0,  15, 128,   0, 
      0,   0, 129,   4,   0, 170, 
    160,   1,   0, 228, 128,  88, 
      0,   0,   4,   0,   0,  15, 
    128,   0,   0,  85, 128,   1, 
      0, 228, 128,   4,   0, 170, 
    160,   1,   0,   0,   2,   0, 
      8,  15, 128,   0,   0, 228, 
    128, 255, 255,   0,   0,  83, 
     72,  68,  82, 208,   3,   0, 
      0,  64,   0,   0,   0, 244, 
      0,   0,   0,  89,   0,   0, 
      4,  70, 142,  32,   0,   0, 
      0,   0,   0,   7,   0,   0, 
      0,  90,   0,   0,   3,   0, 
     96,  16,   0,   0,   0,   0, 
      0,  90,   0,   0,   3,   0, 
     96,  16,   0,   1,   0,   0, 
      0,  88,  24,   0,   4,   0, 
    112,  16,   0,   0,   0,   0, 
      0,  85,  85,   0,   0,  88, 
     24,   0,   4,   0, 112,  16, 
      0,   1,   0,   0,   0,  85, 
     85,   0,   0,  98,  16,   0, 
      3,  50,  16,  16,   0,   1, 
      0,   0,   0,  98,  16,   0, 
      3, 194,  16,  16,   0,   1, 
      0,   0,   0, 101,   0,   0, 
      3, 242,  32,  16,   0,   0, 
      0,   0,   0, 104,   0,   0, 
      2,   3,   0,   0,   0,   0, 
      0,   0,   9,  50,   0,  16, 
      0,   0,   0,   0,   0, 230, 
     26,  16,   0,   1,   0,   0, 
      0,  70, 128,  32, 128,  65, 
      0,   0,   0,   0,   0,   0, 
      0,   5,   0,   0,   0,  54, 
      0,   0,   6,  66,   0,  16, 
      0,   0,   0,   0,   0,  58, 
    128,  32,   0,   0,   0,   0, 
      0,   5,   0,   0,   0,  16, 
      0,   0,   8,  66,   0,  16, 
      0,   0,   0,   0,   0,  70, 
      2,  16,   0,   0,   0,   0, 
      0,  70, 130,  32,   0,   0, 
      0,   0,   0,   4,   0,   0, 
      0,  15,   0,   0,   7,  18, 
      0,  16,   0,   0,   0,   0, 
      0,  70,   0,  16,   0,   0, 
      0,   0,   0,  70,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   9,  18,   0,  16, 
      0,   0,   0,   0,   0,  10, 
      0,  16,   0,   0,   0,   0, 
      0,  10, 128,  32, 128,  65, 
      0,   0,   0,   0,   0,   0, 
      0,   6,   0,   0,   0,  56, 
      0,   0,   8,  18,   0,  16, 
      0,   0,   0,   0,   0,  10, 
      0,  16,   0,   0,   0,   0, 
      0,  42, 128,  32,   0,   0, 
      0,   0,   0,   5,   0,   0, 
      0,  50,   0,   0,  10,  18, 
      0,  16,   0,   0,   0,   0, 
      0,  42,   0,  16,   0,   0, 
      0,   0,   0,  42,   0,  16, 
      0,   0,   0,   0,   0,  10, 
      0,  16, 128,  65,   0,   0, 
      0,   0,   0,   0,   0,  49, 
      0,   0,   7,  34,   0,  16, 
      0,   0,   0,   0,   0,  10, 
      0,  16,   0,   0,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0,   0,   0,  75,   0,   0, 
      6,  18,   0,  16,   0,   1, 
      0,   0,   0,  10,   0,  16, 
    128, 129,   0,   0,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      6,  34,   0,  16,   0,   1, 
      0,   0,   0,  10,   0,  16, 
    128,  65,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      7,  82,   0,  16,   0,   0, 
      0,   0,   0, 166,  10,  16, 
      0,   0,   0,   0,   0,   6, 
      1,  16,   0,   1,   0,   0, 
      0,  14,   0,   0,   8,  82, 
      0,  16,   0,   0,   0,   0, 
      0,   6,   2,  16,   0,   0, 
      0,   0,   0, 166, 138,  32, 
      0,   0,   0,   0,   0,   5, 
      0,   0,   0,  56,   0,   0, 
      8,  50,   0,  16,   0,   1, 
      0,   0,   0, 134,   0,  16, 
      0,   0,   0,   0,   0, 166, 
    138,  32,   0,   0,   0,   0, 
      0,   4,   0,   0,   0,  29, 
      0,   0,   9,  50,   0,  16, 
      0,   1,   0,   0,   0,  70, 
      0,  16,   0,   1,   0,   0, 
      0, 246, 143,  32, 128,  65, 
      0,   0,   0,   0,   0,   0, 
      0,   5,   0,   0,   0,   1, 
      0,   0,  10,  50,   0,  16, 
      0,   1,   0,   0,   0,  70, 
      0,  16,   0,   1,   0,   0, 
      0,   2,  64,   0,   0,   0, 
      0, 128,  63,   0,   0, 128, 
     63,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      8,  18,   0,  16,   0,   0, 
      0,   0,   0,  42,   0,  16, 
    128,  65,   0,   0,   0,   0, 
      0,   0,   0,  10,   0,  16, 
      0,   0,   0,   0,   0,  50, 
      0,   0,   9,  18,   0,  16, 
      0,   2,   0,   0,   0,  10, 
      0,  16,   0,   1,   0,   0, 
      0,  10,   0,  16,   0,   0, 
      0,   0,   0,  42,   0,  16, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   5,  34,   0,  16, 
      0,   2,   0,   0,   0,   1, 
     64,   0,   0,   0,   0,   0, 
     63,  69,   0,   0,   9, 242, 
      0,  16,   0,   2,   0,   0, 
      0,  70,   0,  16,   0,   2, 
      0,   0,   0,  70, 126,  16, 
      0,   0,   0,   0,   0,   0, 
     96,  16,   0,   0,   0,   0, 
      0,  31,   0,   4,   3,  26, 
      0,  16,   0,   0,   0,   0, 
      0,  54,   0,   0,   8, 242, 
     32,  16,   0,   0,   0,   0, 
      0,   2,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  62,   0,   0, 
      1,  21,   0,   0,   1,  52, 
      0,   0,   7,  18,   0,  16, 
      0,   0,   0,   0,   0,  26, 
      0,  16,   0,   1,   0,   0, 
      0,  10,   0,  16,   0,   1, 
      0,   0,   0,  29,   0,   0, 
      7,  18,   0,  16,   0,   0, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0,   0,   0,  10, 
      0,  16,   0,   0,   0,   0, 
      0,  31,   0,   4,   3,  10, 
      0,  16,   0,   0,   0,   0, 
      0,  54,   0,   0,   8, 242, 
     32,  16,   0,   0,   0,   0, 
      0,   2,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  62,   0,   0, 
      1,  21,   0,   0,   1,  56, 
      0,   0,   7, 114,   0,  16, 
      0,   2,   0,   0,   0, 246, 
     15,  16,   0,   2,   0,   0, 
      0,  70,   2,  16,   0,   2, 
      0,   0,   0,  69,   0,   0, 
      9, 242,   0,  16,   0,   0, 
      0,   0,   0,  70,  16,  16, 
      0,   1,   0,   0,   0,  70, 
    126,  16,   0,   1,   0,   0, 
      0,   0,  96,  16,   0,   1, 
      0,   0,   0,  56,   0,   0, 
      7, 242,  32,  16,   0,   0, 
      0,   0,   0, 246,  15,  16, 
      0,   0,   0,   0,   0,  70, 
     14,  16,   0,   2,   0,   0, 
      0,  62,   0,   0,   1,  83, 
     84,  65,  84, 116,   0,   0, 
      0,  33,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,  17, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   5, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  82,  68,  69, 
     70,  96,   2,   0,   0,   1, 
      0,   0,   0, 228,   0,   0, 
      0,   5,   0,   0,   0,  28, 
      0,   0,   0,   0,   4, 255, 
    255,   0,   1,   0,   0,  47, 
      2,   0,   0, 188,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0, 201, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0, 214,   0,   0,   0,   2, 
      0,   0,   0,   5,   0,   0, 
      0,   4,   0,   0,   0, 255, 
    255, 255, 255,   0,   0,   0, 
      0,   1,   0,   0,   0,  12, 
      0,   0,   0, 218,   0,   0, 
      0,   2,   0,   0,   0,   5, 
      0,   0,   0,   4,   0,   0, 
      0, 255, 255, 255, 255,   1, 
      0,   0,   0,   1,   0,   0, 
      0,  12,   0,   0,   0, 223, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0, 115,  87, 114,  97, 112, 
     83,  97, 109, 112, 108, 101, 
    114,   0, 115,  77,  97, 115, 
    107,  83,  97, 109, 112, 108, 
    101, 114,   0, 116, 101, 120, 
      0, 109,  97, 115, 107,   0, 
     99,  98,  50,   0, 171, 223, 
      0,   0,   0,   7,   0,   0, 
      0, 252,   0,   0,   0, 112, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 164, 
      1,   0,   0,   0,   0,   0, 
      0,  44,   0,   0,   0,   0, 
      0,   0,   0, 188,   1,   0, 
      0,   0,   0,   0,   0, 204, 
      1,   0,   0,  48,   0,   0, 
      0,   8,   0,   0,   0,   0, 
      0,   0,   0, 216,   1,   0, 
      0,   0,   0,   0,   0, 232, 
      1,   0,   0,  64,   0,   0, 
      0,  12,   0,   0,   0,   2, 
      0,   0,   0, 240,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,  80,   0,   0, 
      0,   8,   0,   0,   0,   2, 
      0,   0,   0, 216,   1,   0, 
      0,   0,   0,   0,   0,   8, 
      2,   0,   0,  88,   0,   0, 
      0,   4,   0,   0,   0,   2, 
      0,   0,   0,  12,   2,   0, 
      0,   0,   0,   0,   0,  28, 
      2,   0,   0,  92,   0,   0, 
      0,   4,   0,   0,   0,   2, 
      0,   0,   0,  12,   2,   0, 
      0,   0,   0,   0,   0,  36, 
      2,   0,   0,  96,   0,   0, 
      0,   4,   0,   0,   0,   2, 
      0,   0,   0,  12,   2,   0, 
      0,   0,   0,   0,   0,  68, 
    101, 118, 105,  99, 101,  83, 
    112,  97,  99, 101,  84, 111, 
     85, 115, 101, 114,  83, 112, 
     97,  99, 101,   0, 171,   3, 
      0,   3,   0,   3,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 100, 105, 109, 
    101, 110, 115, 105, 111, 110, 
    115,   0, 171,   1,   0,   3, 
      0,   1,   0,   2,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 100, 105, 102, 102,   0, 
    171, 171, 171,   1,   0,   3, 
      0,   1,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  99, 101, 110, 116, 101, 
    114,  49,   0,  65,   0, 171, 
    171,   0,   0,   3,   0,   1, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 114, 
     97, 100, 105, 117, 115,  49, 
      0, 115, 113,  95, 114,  97, 
    100, 105, 117, 115,  49,   0, 
     77, 105,  99, 114, 111, 115, 
    111, 102, 116,  32,  40,  82, 
     41,  32,  72,  76,  83,  76, 
     32,  83, 104,  97, 100, 101, 
    114,  32,  67, 111, 109, 112, 
    105, 108, 101, 114,  32,  57, 
     46,  50,  57,  46,  57,  53, 
     50,  46,  51,  49,  49,  49, 
      0,  73,  83,  71,  78, 104, 
      0,   0,   0,   3,   0,   0, 
      0,   8,   0,   0,   0,  80, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  15,   0,   0,   0,  92, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,   3,   3,   0,   0,  92, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,  12,  12,   0,   0,  83, 
     86,  95,  80, 111, 115, 105, 
    116, 105, 111, 110,   0,  84, 
     69,  88,  67,  79,  79,  82, 
     68,   0, 171, 171, 171,  79, 
     83,  71,  78,  44,   0,   0, 
      0,   1,   0,   0,   0,   8, 
      0,   0,   0,  32,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  15, 
      0,   0,   0,  83,  86,  95, 
     84,  97, 114, 103, 101, 116, 
      0, 171, 171,  81,  51,   0, 
      0,   0,   0,   0,   0,  65, 
     48,  87, 114,  97, 112,   0, 
     40,   7,   0,   0,  68,  88, 
     66,  67, 237,  58, 124, 168, 
    122, 234, 242,   5,  75,  29, 
    195,   6, 241, 206, 131, 117, 
      1,   0,   0,   0,  40,   7, 
      0,   0,   6,   0,   0,   0, 
     56,   0,   0,   0, 148,   1, 
      0,   0, 104,   3,   0,   0, 
    228,   3,   0,   0, 132,   6, 
      0,   0, 184,   6,   0,   0, 
     65, 111, 110,  57,  84,   1, 
      0,   0,  84,   1,   0,   0, 
      0,   2, 254, 255, 252,   0, 
      0,   0,  88,   0,   0,   0, 
      4,   0,  36,   0,   0,   0, 
     84,   0,   0,   0,  84,   0, 
      0,   0,  36,   0,   1,   0, 
     84,   0,   0,   0,   0,   0, 
      1,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      1,   0,   2,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      2,   0,   3,   0,   0,   0, 
      0,   0,   1,   0,   3,   0, 
      1,   0,   5,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   2, 254, 255,  81,   0, 
      0,   5,   6,   0,  15, 160, 
      0,   0, 128,  63,   0,   0, 
      0,  63,   0,   0,   0,   0, 
      0,   0,   0,   0,  31,   0, 
      0,   2,   5,   0,   0, 128, 
      0,   0,  15, 144,   4,   0, 
      0,   4,   0,   0,   3, 224, 
      0,   0, 228, 144,   2,   0, 
    238, 160,   2,   0, 228, 160, 
      4,   0,   0,   4,   0,   0, 
      3, 128,   0,   0, 228, 144, 
      1,   0, 238, 160,   1,   0, 
    228, 160,   2,   0,   0,   3, 
      0,   0,   4, 128,   0,   0, 
      0, 128,   6,   0,   0, 160, 
      5,   0,   0,   3,   0,   0, 
      4, 128,   0,   0, 170, 128, 
      5,   0,   0, 160,   5,   0, 
      0,   3,   1,   0,   1, 128, 
      0,   0, 170, 128,   6,   0, 
     85, 160,   2,   0,   0,   3, 
      0,   0,   4, 128,   0,   0, 
     85, 129,   6,   0,   0, 160, 
      2,   0,   0,   3,   0,   0, 
      3, 192,   0,   0, 228, 128, 
      0,   0, 228, 160,   5,   0, 
      0,   3,   0,   0,   1, 128, 
      0,   0, 170, 128,   5,   0, 
     85, 160,   5,   0,   0,   3, 
      1,   0,   2, 128,   0,   0, 
      0, 128,   6,   0,  85, 160, 
      1,   0,   0,   2,   1,   0, 
      4, 128,   6,   0,   0, 160, 
      8,   0,   0,   3,   0,   0, 
      8, 224,   1,   0, 228, 128, 
      3,   0, 228, 160,   8,   0, 
      0,   3,   0,   0,   4, 224, 
      1,   0, 228, 128,   4,   0, 
    228, 160,   1,   0,   0,   2, 
      0,   0,  12, 192,   6,   0, 
     36, 160, 255, 255,   0,   0, 
     83,  72,  68,  82, 204,   1, 
      0,   0,  64,   0,   1,   0, 
    115,   0,   0,   0,  89,   0, 
      0,   4,  70, 142,  32,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,  89,   0,   0,   4, 
     70, 142,  32,   0,   1,   0, 
      0,   0,   4,   0,   0,   0, 
     95,   0,   0,   3,  50,  16, 
     16,   0,   0,   0,   0,   0, 
    103,   0,   0,   4, 242,  32, 
     16,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3,  50,  32,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 194,  32,  16,   0, 
      1,   0,   0,   0, 104,   0, 
      0,   2,   2,   0,   0,   0, 
     54,   0,   0,   8, 194,  32, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    128,  63,  50,   0,   0,  11, 
     50,   0,  16,   0,   0,   0, 
      0,   0,  70,  16,  16,   0, 
      0,   0,   0,   0, 230, 138, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  70, 128, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   5,  50,  32,  16,   0, 
      0,   0,   0,   0,  70,   0, 
     16,   0,   0,   0,   0,   0, 
      0,   0,   0,   7,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     10,   0,  16,   0,   0,   0, 
      0,   0,   1,  64,   0,   0, 
      0,   0, 128,  63,   0,   0, 
      0,   8,  34,   0,  16,   0, 
      0,   0,   0,   0,  26,   0, 
     16, 128,  65,   0,   0,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,   0,   0, 128,  63, 
     56,   0,   0,   8,  50,   0, 
     16,   0,   0,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,  70, 128,  32,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,  56,   0,   0,  10, 
     50,   0,  16,   0,   1,   0, 
      0,   0,  70,   0,  16,   0, 
      0,   0,   0,   0,   2,  64, 
      0,   0,   0,   0,   0,  63, 
      0,   0,   0,  63,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     54,   0,   0,   5,  66,   0, 
     16,   0,   1,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
    128,  63,  16,   0,   0,   8, 
     66,  32,  16,   0,   1,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,  70, 130, 
     32,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,  16,   0, 
      0,   8, 130,  32,  16,   0, 
      1,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
     70, 130,  32,   0,   1,   0, 
      0,   0,   1,   0,   0,   0, 
     50,   0,   0,  11,  50,  32, 
     16,   0,   1,   0,   0,   0, 
     70,  16,  16,   0,   0,   0, 
      0,   0, 230, 138,  32,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  70, 128,  32,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  62,   0,   0,   1, 
     83,  84,  65,  84, 116,   0, 
      0,   0,  12,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
      6,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  82,  68, 
     69,  70, 152,   2,   0,   0, 
      2,   0,   0,   0, 100,   0, 
      0,   0,   2,   0,   0,   0, 
     28,   0,   0,   0,   0,   4, 
    254, 255,   0,   1,   0,   0, 
    103,   2,   0,   0,  92,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
     96,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,  99,  98,  48,   0, 
     99,  98,  50,   0,  92,   0, 
      0,   0,   4,   0,   0,   0, 
    148,   0,   0,   0,  64,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  96,   0, 
      0,   0,   7,   0,   0,   0, 
     52,   1,   0,   0, 112,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 244,   0, 
      0,   0,   0,   0,   0,   0, 
     16,   0,   0,   0,   2,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,  16,   1, 
      0,   0,  16,   0,   0,   0, 
     16,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,  26,   1, 
      0,   0,  32,   0,   0,   0, 
     16,   0,   0,   0,   2,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,  40,   1, 
      0,   0,  48,   0,   0,   0, 
     16,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,  81, 117, 
     97, 100,  68, 101, 115,  99, 
      0, 171, 171, 171,   1,   0, 
      3,   0,   1,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  84, 101, 120,  67, 
    111, 111, 114, 100, 115,   0, 
     77,  97, 115, 107,  84, 101, 
    120,  67, 111, 111, 114, 100, 
    115,   0,  84, 101, 120, 116, 
     67, 111, 108, 111, 114,   0, 
    171, 171, 220,   1,   0,   0, 
      0,   0,   0,   0,  44,   0, 
      0,   0,   2,   0,   0,   0, 
    244,   1,   0,   0,   0,   0, 
      0,   0,   4,   2,   0,   0, 
     48,   0,   0,   0,   8,   0, 
      0,   0,   2,   0,   0,   0, 
     16,   2,   0,   0,   0,   0, 
      0,   0,  32,   2,   0,   0, 
     64,   0,   0,   0,  12,   0, 
      0,   0,   0,   0,   0,   0, 
     40,   2,   0,   0,   0,   0, 
      0,   0,  56,   2,   0,   0, 
     80,   0,   0,   0,   8,   0, 
      0,   0,   0,   0,   0,   0, 
     16,   2,   0,   0,   0,   0, 
      0,   0,  64,   2,   0,   0, 
     88,   0,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
     68,   2,   0,   0,   0,   0, 
      0,   0,  84,   2,   0,   0, 
     92,   0,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
     68,   2,   0,   0,   0,   0, 
      0,   0,  92,   2,   0,   0, 
     96,   0,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
     68,   2,   0,   0,   0,   0, 
      0,   0,  68, 101, 118, 105, 
     99, 101,  83, 112,  97,  99, 
    101,  84, 111,  85, 115, 101, 
    114,  83, 112,  97,  99, 101, 
      0, 171,   3,   0,   3,   0, 
      3,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    100, 105, 109, 101, 110, 115, 
    105, 111, 110, 115,   0, 171, 
      1,   0,   3,   0,   1,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 100, 105, 
    102, 102,   0, 171, 171, 171, 
      1,   0,   3,   0,   1,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  99, 101, 
    110, 116, 101, 114,  49,   0, 
     65,   0, 171, 171,   0,   0, 
      3,   0,   1,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 114,  97, 100, 105, 
    117, 115,  49,   0, 115, 113, 
     95, 114,  97, 100, 105, 117, 
    115,  49,   0,  77, 105,  99, 
    114, 111, 115, 111, 102, 116, 
     32,  40,  82,  41,  32,  72, 
     76,  83,  76,  32,  83, 104, 
     97, 100, 101, 114,  32,  67, 
    111, 109, 112, 105, 108, 101, 
    114,  32,  57,  46,  50,  57, 
     46,  57,  53,  50,  46,  51, 
     49,  49,  49,   0,  73,  83, 
     71,  78,  44,   0,   0,   0, 
      1,   0,   0,   0,   8,   0, 
      0,   0,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   7,   3, 
      0,   0,  80,  79,  83,  73, 
     84,  73,  79,  78,   0, 171, 
    171, 171,  79,  83,  71,  78, 
    104,   0,   0,   0,   3,   0, 
      0,   0,   8,   0,   0,   0, 
     80,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  15,   0,   0,   0, 
     92,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,   3,  12,   0,   0, 
     92,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,  12,   3,   0,   0, 
     83,  86,  95,  80, 111, 115, 
    105, 116, 105, 111, 110,   0, 
     84,  69,  88,  67,  79,  79, 
     82,  68,   0, 171, 171, 171, 
     68,  61,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0, 192,   7,   0,   0, 
     68,  88,  66,  67, 148, 128, 
     74, 221, 199, 126,  74,  95, 
      7, 207, 141,  28, 193,  83, 
     71, 108,   1,   0,   0,   0, 
    192,   7,   0,   0,   6,   0, 
      0,   0,  56,   0,   0,   0, 
    196,   1,   0,   0,  56,   4, 
      0,   0, 180,   4,   0,   0, 
     28,   7,   0,   0, 140,   7, 
      0,   0,  65, 111, 110,  57, 
    132,   1,   0,   0, 132,   1, 
      0,   0,   0,   2, 255, 255, 
     76,   1,   0,   0,  56,   0, 
      0,   0,   1,   0,  44,   0, 
      0,   0,  56,   0,   0,   0, 
     56,   0,   2,   0,  36,   0, 
      0,   0,  56,   0,   0,   0, 
      0,   0,   1,   1,   1,   0, 
      0,   0,   4,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   2, 255, 255,  81,   0, 
      0,   5,   2,   0,  15, 160, 
      0,   0,   0,  63,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  31,   0, 
      0,   2,   0,   0,   0, 128, 
      0,   0,  15, 176,  31,   0, 
      0,   2,   0,   0,   0, 144, 
      0,   8,  15, 160,  31,   0, 
      0,   2,   0,   0,   0, 144, 
      1,   8,  15, 160,   5,   0, 
      0,   3,   0,   0,   8, 128, 
      1,   0, 255, 160,   1,   0, 
    255, 160,   2,   0,   0,   3, 
      0,   0,   3, 128,   0,   0, 
    235, 176,   1,   0, 228, 161, 
     90,   0,   0,   4,   0,   0, 
      8, 128,   0,   0, 228, 128, 
      0,   0, 228, 128,   0,   0, 
    255, 129,   5,   0,   0,   3, 
      0,   0,   8, 128,   0,   0, 
    255, 128,   2,   0,   0, 160, 
      1,   0,   0,   2,   0,   0, 
      4, 128,   1,   0, 255, 160, 
      8,   0,   0,   3,   0,   0, 
      1, 128,   0,   0, 228, 128, 
      0,   0, 228, 160,   6,   0, 
      0,   2,   0,   0,   1, 128, 
      0,   0,   0, 128,   5,   0, 
      0,   3,   0,   0,   1, 128, 
      0,   0,   0, 128,   0,   0, 
    255, 128,   1,   0,   0,   2, 
      0,   0,   2, 128,   2,   0, 
      0, 160,  66,   0,   0,   3, 
      1,   0,  15, 128,   0,   0, 
    228, 176,   1,   8, 228, 160, 
     66,   0,   0,   3,   2,   0, 
     15, 128,   0,   0, 228, 128, 
      0,   8, 228, 160,   1,   0, 
      0,   2,   0,   0,   8, 128, 
      1,   0, 255, 160,   4,   0, 
      0,   4,   0,   0,   1, 128, 
      0,   0,   0, 128,   0,   0, 
    170, 161,   0,   0, 255, 129, 
      5,   0,   0,   3,   2,   0, 
      7, 128,   2,   0, 255, 128, 
      2,   0, 228, 128,   5,   0, 
      0,   3,   1,   0,  15, 128, 
      1,   0, 255, 128,   2,   0, 
    228, 128,  88,   0,   0,   4, 
      0,   0,  15, 128,   0,   0, 
      0, 128,   2,   0,  85, 160, 
      1,   0, 228, 128,   1,   0, 
      0,   2,   0,   8,  15, 128, 
      0,   0, 228, 128, 255, 255, 
      0,   0,  83,  72,  68,  82, 
    108,   2,   0,   0,  64,   0, 
      0,   0, 155,   0,   0,   0, 
     89,   0,   0,   4,  70, 142, 
     32,   0,   0,   0,   0,   0, 
      6,   0,   0,   0,  90,   0, 
      0,   3,   0,  96,  16,   0, 
      0,   0,   0,   0,  90,   0, 
      0,   3,   0,  96,  16,   0, 
      1,   0,   0,   0,  88,  24, 
      0,   4,   0, 112,  16,   0, 
      0,   0,   0,   0,  85,  85, 
      0,   0,  88,  24,   0,   4, 
      0, 112,  16,   0,   1,   0, 
      0,   0,  85,  85,   0,   0, 
     98,  16,   0,   3,  50,  16, 
     16,   0,   1,   0,   0,   0, 
     98,  16,   0,   3, 194,  16, 
     16,   0,   1,   0,   0,   0, 
    101,   0,   0,   3, 242,  32, 
     16,   0,   0,   0,   0,   0, 
    104,   0,   0,   2,   2,   0, 
      0,   0,   0,   0,   0,   9, 
     50,   0,  16,   0,   0,   0, 
      0,   0, 230,  26,  16,   0, 
      1,   0,   0,   0,  70, 128, 
     32, 128,  65,   0,   0,   0, 
      0,   0,   0,   0,   5,   0, 
      0,   0,  54,   0,   0,   6, 
     66,   0,  16,   0,   0,   0, 
      0,   0,  58, 128,  32,   0, 
      0,   0,   0,   0,   5,   0, 
      0,   0,  16,   0,   0,   8, 
     66,   0,  16,   0,   0,   0, 
      0,   0,  70,   2,  16,   0, 
      0,   0,   0,   0,  70, 130, 
     32,   0,   0,   0,   0,   0, 
      4,   0,   0,   0,  15,   0, 
      0,   7,  18,   0,  16,   0, 
      0,   0,   0,   0,  70,   0, 
     16,   0,   0,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,  50,   0,   0,  12, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  58, 128,  32, 128, 
     65,   0,   0,   0,   0,   0, 
      0,   0,   5,   0,   0,   0, 
     58, 128,  32,   0,   0,   0, 
      0,   0,   5,   0,   0,   0, 
     10,   0,  16,   0,   0,   0, 
      0,   0,  56,   0,   0,   7, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  10,   0,  16,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,   0,   0,   0,  63, 
     14,   0,   0,   7,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     10,   0,  16,   0,   0,   0, 
      0,   0,  42,   0,  16,   0, 
      0,   0,   0,   0,  56,   0, 
      0,   8,  66,   0,  16,   0, 
      0,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
     42, 128,  32,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
     29,   0,   0,   9,  66,   0, 
     16,   0,   0,   0,   0,   0, 
     58, 128,  32, 128,  65,   0, 
      0,   0,   0,   0,   0,   0, 
      5,   0,   0,   0,  42,   0, 
     16,   0,   0,   0,   0,   0, 
     54,   0,   0,   5,  34,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,  63,  69,   0,   0,   9, 
    242,   0,  16,   0,   1,   0, 
      0,   0,  70,   0,  16,   0, 
      0,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  31,   0,   4,   3, 
     42,   0,  16,   0,   0,   0, 
      0,   0,  54,   0,   0,   8, 
    242,  32,  16,   0,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  62,   0, 
      0,   1,  21,   0,   0,   1, 
     56,   0,   0,   7, 114,   0, 
     16,   0,   1,   0,   0,   0, 
    246,  15,  16,   0,   1,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      0,   0,   0,   0,  70,  16, 
     16,   0,   1,   0,   0,   0, 
     70, 126,  16,   0,   1,   0, 
      0,   0,   0,  96,  16,   0, 
      1,   0,   0,   0,  56,   0, 
      0,   7, 242,  32,  16,   0, 
      0,   0,   0,   0, 246,  15, 
     16,   0,   0,   0,   0,   0, 
     70,  14,  16,   0,   1,   0, 
      0,   0,  62,   0,   0,   1, 
     83,  84,  65,  84, 116,   0, 
      0,   0,  19,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      9,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  82,  68, 
     69,  70,  96,   2,   0,   0, 
      1,   0,   0,   0, 228,   0, 
      0,   0,   5,   0,   0,   0, 
     28,   0,   0,   0,   0,   4, 
    255, 255,   0,   1,   0,   0, 
     47,   2,   0,   0, 188,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    201,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 214,   0,   0,   0, 
      2,   0,   0,   0,   5,   0, 
      0,   0,   4,   0,   0,   0, 
    255, 255, 255, 255,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   0,   0,   0, 218,   0, 
      0,   0,   2,   0,   0,   0, 
      5,   0,   0,   0,   4,   0, 
      0,   0, 255, 255, 255, 255, 
      1,   0,   0,   0,   1,   0, 
      0,   0,  12,   0,   0,   0, 
    223,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 115,  87, 114,  97, 
    112,  83,  97, 109, 112, 108, 
    101, 114,   0, 115,  77,  97, 
    115, 107,  83,  97, 109, 112, 
    108, 101, 114,   0, 116, 101, 
    120,   0, 109,  97, 115, 107, 
      0,  99,  98,  50,   0, 171, 
    223,   0,   0,   0,   7,   0, 
      0,   0, 252,   0,   0,   0, 
    112,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    164,   1,   0,   0,   0,   0, 
      0,   0,  44,   0,   0,   0, 
      0,   0,   0,   0, 188,   1, 
      0,   0,   0,   0,   0,   0, 
    204,   1,   0,   0,  48,   0, 
      0,   0,   8,   0,   0,   0, 
      0,   0,   0,   0, 216,   1, 
      0,   0,   0,   0,   0,   0, 
    232,   1,   0,   0,  64,   0, 
      0,   0,  12,   0,   0,   0, 
      2,   0,   0,   0, 240,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   2,   0,   0,  80,   0, 
      0,   0,   8,   0,   0,   0, 
      2,   0,   0,   0, 216,   1, 
      0,   0,   0,   0,   0,   0, 
      8,   2,   0,   0,  88,   0, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,  12,   2, 
      0,   0,   0,   0,   0,   0, 
     28,   2,   0,   0,  92,   0, 
      0,   0,   4,   0,   0,   0, 
      2,   0,   0,   0,  12,   2, 
      0,   0,   0,   0,   0,   0, 
     36,   2,   0,   0,  96,   0, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,  12,   2, 
      0,   0,   0,   0,   0,   0, 
     68, 101, 118, 105,  99, 101, 
     83, 112,  97,  99, 101,  84, 
    111,  85, 115, 101, 114,  83, 
    112,  97,  99, 101,   0, 171, 
      3,   0,   3,   0,   3,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 100, 105, 
    109, 101, 110, 115, 105, 111, 
    110, 115,   0, 171,   1,   0, 
      3,   0,   1,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 100, 105, 102, 102, 
      0, 171, 171, 171,   1,   0, 
      3,   0,   1,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  99, 101, 110, 116, 
    101, 114,  49,   0,  65,   0, 
    171, 171,   0,   0,   3,   0, 
      1,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    114,  97, 100, 105, 117, 115, 
     49,   0, 115, 113,  95, 114, 
     97, 100, 105, 117, 115,  49, 
      0,  77, 105,  99, 114, 111, 
    115, 111, 102, 116,  32,  40, 
     82,  41,  32,  72,  76,  83, 
     76,  32,  83, 104,  97, 100, 
    101, 114,  32,  67, 111, 109, 
    112, 105, 108, 101, 114,  32, 
     57,  46,  50,  57,  46,  57, 
     53,  50,  46,  51,  49,  49, 
     49,   0,  73,  83,  71,  78, 
    104,   0,   0,   0,   3,   0, 
      0,   0,   8,   0,   0,   0, 
     80,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  15,   0,   0,   0, 
     92,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,   3,   3,   0,   0, 
     92,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,  12,  12,   0,   0, 
     83,  86,  95,  80, 111, 115, 
    105, 116, 105, 111, 110,   0, 
     84,  69,  88,  67,  79,  79, 
     82,  68,   0, 171, 171, 171, 
     79,  83,  71,  78,  44,   0, 
      0,   0,   1,   0,   0,   0, 
      8,   0,   0,   0,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  83,  86, 
     95,  84,  97, 114, 103, 101, 
    116,   0, 171, 171, 132,  68, 
      0,   0,   0,   0,   0,   0, 
     65,  80, 111, 115,  77, 105, 
    114, 114, 111, 114,   0,  40, 
      7,   0,   0,  68,  88,  66, 
     67, 237,  58, 124, 168, 122, 
    234, 242,   5,  75,  29, 195, 
      6, 241, 206, 131, 117,   1, 
      0,   0,   0,  40,   7,   0, 
      0,   6,   0,   0,   0,  56, 
      0,   0,   0, 148,   1,   0, 
      0, 104,   3,   0,   0, 228, 
      3,   0,   0, 132,   6,   0, 
      0, 184,   6,   0,   0,  65, 
    111, 110,  57,  84,   1,   0, 
      0,  84,   1,   0,   0,   0, 
      2, 254, 255, 252,   0,   0, 
      0,  88,   0,   0,   0,   4, 
      0,  36,   0,   0,   0,  84, 
      0,   0,   0,  84,   0,   0, 
      0,  36,   0,   1,   0,  84, 
      0,   0,   0,   0,   0,   1, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   2,   0,   1, 
      0,   2,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   3,   0,   0,   0,   0, 
      0,   1,   0,   3,   0,   1, 
      0,   5,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      2, 254, 255,  81,   0,   0, 
      5,   6,   0,  15, 160,   0, 
      0, 128,  63,   0,   0,   0, 
     63,   0,   0,   0,   0,   0, 
      0,   0,   0,  31,   0,   0, 
      2,   5,   0,   0, 128,   0, 
      0,  15, 144,   4,   0,   0, 
      4,   0,   0,   3, 224,   0, 
      0, 228, 144,   2,   0, 238, 
    160,   2,   0, 228, 160,   4, 
      0,   0,   4,   0,   0,   3, 
    128,   0,   0, 228, 144,   1, 
      0, 238, 160,   1,   0, 228, 
    160,   2,   0,   0,   3,   0, 
      0,   4, 128,   0,   0,   0, 
    128,   6,   0,   0, 160,   5, 
      0,   0,   3,   0,   0,   4, 
    128,   0,   0, 170, 128,   5, 
      0,   0, 160,   5,   0,   0, 
      3,   1,   0,   1, 128,   0, 
      0, 170, 128,   6,   0,  85, 
    160,   2,   0,   0,   3,   0, 
      0,   4, 128,   0,   0,  85, 
    129,   6,   0,   0, 160,   2, 
      0,   0,   3,   0,   0,   3, 
    192,   0,   0, 228, 128,   0, 
      0, 228, 160,   5,   0,   0, 
      3,   0,   0,   1, 128,   0, 
      0, 170, 128,   5,   0,  85, 
    160,   5,   0,   0,   3,   1, 
      0,   2, 128,   0,   0,   0, 
    128,   6,   0,  85, 160,   1, 
      0,   0,   2,   1,   0,   4, 
    128,   6,   0,   0, 160,   8, 
      0,   0,   3,   0,   0,   8, 
    224,   1,   0, 228, 128,   3, 
      0, 228, 160,   8,   0,   0, 
      3,   0,   0,   4, 224,   1, 
      0, 228, 128,   4,   0, 228, 
    160,   1,   0,   0,   2,   0, 
      0,  12, 192,   6,   0,  36, 
    160, 255, 255,   0,   0,  83, 
     72,  68,  82, 204,   1,   0, 
      0,  64,   0,   1,   0, 115, 
      0,   0,   0,  89,   0,   0, 
      4,  70, 142,  32,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,  89,   0,   0,   4,  70, 
    142,  32,   0,   1,   0,   0, 
      0,   4,   0,   0,   0,  95, 
      0,   0,   3,  50,  16,  16, 
      0,   0,   0,   0,   0, 103, 
      0,   0,   4, 242,  32,  16, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0, 101,   0,   0, 
      3,  50,  32,  16,   0,   1, 
      0,   0,   0, 101,   0,   0, 
      3, 194,  32,  16,   0,   1, 
      0,   0,   0, 104,   0,   0, 
      2,   2,   0,   0,   0,  54, 
      0,   0,   8, 194,  32,  16, 
      0,   0,   0,   0,   0,   2, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 128, 
     63,  50,   0,   0,  11,  50, 
      0,  16,   0,   0,   0,   0, 
      0,  70,  16,  16,   0,   0, 
      0,   0,   0, 230, 138,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  70, 128,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      5,  50,  32,  16,   0,   0, 
      0,   0,   0,  70,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   7,  18,   0,  16, 
      0,   0,   0,   0,   0,  10, 
      0,  16,   0,   0,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0, 128,  63,   0,   0,   0, 
      8,  34,   0,  16,   0,   0, 
      0,   0,   0,  26,   0,  16, 
    128,  65,   0,   0,   0,   0, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0, 128,  63,  56, 
      0,   0,   8,  50,   0,  16, 
      0,   0,   0,   0,   0,  70, 
      0,  16,   0,   0,   0,   0, 
      0,  70, 128,  32,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0,  56,   0,   0,  10,  50, 
      0,  16,   0,   1,   0,   0, 
      0,  70,   0,  16,   0,   0, 
      0,   0,   0,   2,  64,   0, 
      0,   0,   0,   0,  63,   0, 
      0,   0,  63,   0,   0,   0, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   5,  66,   0,  16, 
      0,   1,   0,   0,   0,   1, 
     64,   0,   0,   0,   0, 128, 
     63,  16,   0,   0,   8,  66, 
     32,  16,   0,   1,   0,   0, 
      0,  70,   2,  16,   0,   1, 
      0,   0,   0,  70, 130,  32, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,  16,   0,   0, 
      8, 130,  32,  16,   0,   1, 
      0,   0,   0,  70,   2,  16, 
      0,   1,   0,   0,   0,  70, 
    130,  32,   0,   1,   0,   0, 
      0,   1,   0,   0,   0,  50, 
      0,   0,  11,  50,  32,  16, 
      0,   1,   0,   0,   0,  70, 
     16,  16,   0,   0,   0,   0, 
      0, 230, 138,  32,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,  70, 128,  32,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,  62,   0,   0,   1,  83, 
     84,  65,  84, 116,   0,   0, 
      0,  12,   0,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   4,   0,   0,   0,   6, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  82,  68,  69, 
     70, 152,   2,   0,   0,   2, 
      0,   0,   0, 100,   0,   0, 
      0,   2,   0,   0,   0,  28, 
      0,   0,   0,   0,   4, 254, 
    255,   0,   1,   0,   0, 103, 
      2,   0,   0,  92,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,  96, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,  99,  98,  48,   0,  99, 
     98,  50,   0,  92,   0,   0, 
      0,   4,   0,   0,   0, 148, 
      0,   0,   0,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  96,   0,   0, 
      0,   7,   0,   0,   0,  52, 
      1,   0,   0, 112,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 244,   0,   0, 
      0,   0,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  16,   1,   0, 
      0,  16,   0,   0,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  26,   1,   0, 
      0,  32,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  40,   1,   0, 
      0,  48,   0,   0,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  81, 117,  97, 
    100,  68, 101, 115,  99,   0, 
    171, 171, 171,   1,   0,   3, 
      0,   1,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  84, 101, 120,  67, 111, 
    111, 114, 100, 115,   0,  77, 
     97, 115, 107,  84, 101, 120, 
     67, 111, 111, 114, 100, 115, 
      0,  84, 101, 120, 116,  67, 
    111, 108, 111, 114,   0, 171, 
    171, 220,   1,   0,   0,   0, 
      0,   0,   0,  44,   0,   0, 
      0,   2,   0,   0,   0, 244, 
      1,   0,   0,   0,   0,   0, 
      0,   4,   2,   0,   0,  48, 
      0,   0,   0,   8,   0,   0, 
      0,   2,   0,   0,   0,  16, 
      2,   0,   0,   0,   0,   0, 
      0,  32,   2,   0,   0,  64, 
      0,   0,   0,  12,   0,   0, 
      0,   0,   0,   0,   0,  40, 
      2,   0,   0,   0,   0,   0, 
      0,  56,   2,   0,   0,  80, 
      0,   0,   0,   8,   0,   0, 
      0,   0,   0,   0,   0,  16, 
      2,   0,   0,   0,   0,   0, 
      0,  64,   2,   0,   0,  88, 
      0,   0,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,  68, 
      2,   0,   0,   0,   0,   0, 
      0,  84,   2,   0,   0,  92, 
      0,   0,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,  68, 
      2,   0,   0,   0,   0,   0, 
      0,  92,   2,   0,   0,  96, 
      0,   0,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,  68, 
      2,   0,   0,   0,   0,   0, 
      0,  68, 101, 118, 105,  99, 
    101,  83, 112,  97,  99, 101, 
     84, 111,  85, 115, 101, 114, 
     83, 112,  97,  99, 101,   0, 
    171,   3,   0,   3,   0,   3, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 100, 
    105, 109, 101, 110, 115, 105, 
    111, 110, 115,   0, 171,   1, 
      0,   3,   0,   1,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 100, 105, 102, 
    102,   0, 171, 171, 171,   1, 
      0,   3,   0,   1,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  99, 101, 110, 
    116, 101, 114,  49,   0,  65, 
      0, 171, 171,   0,   0,   3, 
      0,   1,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 114,  97, 100, 105, 117, 
    115,  49,   0, 115, 113,  95, 
    114,  97, 100, 105, 117, 115, 
     49,   0,  77, 105,  99, 114, 
    111, 115, 111, 102, 116,  32, 
     40,  82,  41,  32,  72,  76, 
     83,  76,  32,  83, 104,  97, 
    100, 101, 114,  32,  67, 111, 
    109, 112, 105, 108, 101, 114, 
     32,  57,  46,  50,  57,  46, 
     57,  53,  50,  46,  51,  49, 
     49,  49,   0,  73,  83,  71, 
     78,  44,   0,   0,   0,   1, 
      0,   0,   0,   8,   0,   0, 
      0,  32,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   7,   3,   0, 
      0,  80,  79,  83,  73,  84, 
     73,  79,  78,   0, 171, 171, 
    171,  79,  83,  71,  78, 104, 
      0,   0,   0,   3,   0,   0, 
      0,   8,   0,   0,   0,  80, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  15,   0,   0,   0,  92, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,   3,  12,   0,   0,  92, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,  12,   3,   0,   0,  83, 
     86,  95,  80, 111, 115, 105, 
    116, 105, 111, 110,   0,  84, 
     69,  88,  67,  79,  79,  82, 
     68,   0, 171, 171, 171,  91, 
     76,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0, 228,   9,   0,   0,  68, 
     88,  66,  67,  90, 139, 199, 
    161, 131,   3,  38, 117, 153, 
    113,  42, 204,  54, 196, 132, 
     44,   1,   0,   0,   0, 228, 
      9,   0,   0,   6,   0,   0, 
      0,  56,   0,   0,   0, 128, 
      2,   0,   0,  88,   6,   0, 
      0, 212,   6,   0,   0,  64, 
      9,   0,   0, 176,   9,   0, 
      0,  65, 111, 110,  57,  64, 
      2,   0,   0,  64,   2,   0, 
      0,   0,   2, 255, 255,   8, 
      2,   0,   0,  56,   0,   0, 
      0,   1,   0,  44,   0,   0, 
      0,  56,   0,   0,   0,  56, 
      0,   2,   0,  36,   0,   0, 
      0,  56,   0,   0,   0,   0, 
      0,   1,   1,   1,   0,   0, 
      0,   4,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      2, 255, 255,  81,   0,   0, 
      5,   3,   0,  15, 160,   0, 
      0,   0,  63,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  81,   0,   0, 
      5,   4,   0,  15, 160,   0, 
      0, 128,  63,   0,   0, 128, 
    191,   0,   0,   0,   0,   0, 
      0,   0, 128,  31,   0,   0, 
      2,   0,   0,   0, 128,   0, 
      0,  15, 176,  31,   0,   0, 
      2,   0,   0,   0, 144,   0, 
      8,  15, 160,  31,   0,   0, 
      2,   0,   0,   0, 144,   1, 
      8,  15, 160,   2,   0,   0, 
      3,   0,   0,   3, 128,   0, 
      0, 235, 176,   1,   0, 228, 
    161,  90,   0,   0,   4,   0, 
      0,   8, 128,   0,   0, 228, 
    128,   0,   0, 228, 128,   2, 
      0,   0, 161,   5,   0,   0, 
      3,   0,   0,   8, 128,   0, 
      0, 255, 128,   1,   0, 170, 
    160,   1,   0,   0,   2,   0, 
      0,   4, 128,   1,   0, 255, 
    160,   8,   0,   0,   3,   0, 
      0,   1, 128,   0,   0, 228, 
    128,   0,   0, 228, 160,   4, 
      0,   0,   4,   0,   0,   2, 
    128,   0,   0,   0, 128,   0, 
      0,   0, 128,   0,   0, 255, 
    129,  35,   0,   0,   2,   0, 
      0,   4, 128,   0,   0,  85, 
    128,   7,   0,   0,   2,   0, 
      0,   4, 128,   0,   0, 170, 
    128,   6,   0,   0,   2,   1, 
      0,   1, 128,   0,   0, 170, 
    128,   1,   0,   0,   2,   1, 
      0,   6, 128,   1,   0,   0, 
    129,   2,   0,   0,   3,   0, 
      0,  13, 128,   0,   0,   0, 
    128,   1,   0, 148, 128,   6, 
      0,   0,   2,   1,   0,   1, 
    128,   1,   0, 170, 160,   5, 
      0,   0,   3,   0,   0,  13, 
    128,   0,   0, 228, 128,   1, 
      0,   0, 128,   1,   0,   0, 
      2,   1,   0,   8, 128,   1, 
      0, 255, 160,   4,   0,   0, 
      4,   1,   0,   7, 128,   0, 
      0, 248, 128,   0,   0, 170, 
    160,   1,   0, 255, 128,  88, 
      0,   0,   4,   2,   0,   1, 
    128,   1,   0,   0, 128,   0, 
      0,   0, 128,   0,   0, 255, 
    128,  88,   0,   0,   4,   0, 
      0,  13, 128,   1,   0, 148, 
    128,   4,   0,  68, 160,   4, 
      0, 230, 160,   1,   0,   0, 
      2,   2,   0,   2, 128,   3, 
      0,   0, 160,  66,   0,   0, 
      3,   1,   0,  15, 128,   0, 
      0, 228, 176,   1,   8, 228, 
    160,  66,   0,   0,   3,   2, 
      0,  15, 128,   2,   0, 228, 
    128,   0,   8, 228, 160,   5, 
      0,   0,   3,   2,   0,   7, 
    128,   2,   0, 255, 128,   2, 
      0, 228, 128,   5,   0,   0, 
      3,   1,   0,  15, 128,   1, 
      0, 255, 128,   2,   0, 228, 
    128,   2,   0,   0,   3,   0, 
      0,   8, 128,   0,   0, 255, 
    128,   0,   0,   0, 128,  88, 
      0,   0,   4,   0,   0,   1, 
    128,   0,   0, 255, 128,   0, 
      0,   0, 128,   0,   0, 170, 
    128,  88,   0,   0,   4,   1, 
      0,  15, 128,   0,   0,   0, 
    129,   4,   0, 170, 160,   1, 
      0, 228, 128,  88,   0,   0, 
      4,   0,   0,  15, 128,   0, 
      0,  85, 128,   1,   0, 228, 
    128,   4,   0, 170, 160,   1, 
      0,   0,   2,   0,   8,  15, 
    128,   0,   0, 228, 128, 255, 
    255,   0,   0,  83,  72,  68, 
     82, 208,   3,   0,   0,  64, 
      0,   0,   0, 244,   0,   0, 
      0,  89,   0,   0,   4,  70, 
    142,  32,   0,   0,   0,   0, 
      0,   7,   0,   0,   0,  90, 
      0,   0,   3,   0,  96,  16, 
      0,   0,   0,   0,   0,  90, 
      0,   0,   3,   0,  96,  16, 
      0,   1,   0,   0,   0,  88, 
     24,   0,   4,   0, 112,  16, 
      0,   0,   0,   0,   0,  85, 
     85,   0,   0,  88,  24,   0, 
      4,   0, 112,  16,   0,   1, 
      0,   0,   0,  85,  85,   0, 
      0,  98,  16,   0,   3,  50, 
     16,  16,   0,   1,   0,   0, 
      0,  98,  16,   0,   3, 194, 
     16,  16,   0,   1,   0,   0, 
      0, 101,   0,   0,   3, 242, 
     32,  16,   0,   0,   0,   0, 
      0, 104,   0,   0,   2,   3, 
      0,   0,   0,   0,   0,   0, 
      9,  50,   0,  16,   0,   0, 
      0,   0,   0, 230,  26,  16, 
      0,   1,   0,   0,   0,  70, 
    128,  32, 128,  65,   0,   0, 
      0,   0,   0,   0,   0,   5, 
      0,   0,   0,  54,   0,   0, 
      6,  66,   0,  16,   0,   0, 
      0,   0,   0,  58, 128,  32, 
      0,   0,   0,   0,   0,   5, 
      0,   0,   0,  16,   0,   0, 
      8,  66,   0,  16,   0,   0, 
      0,   0,   0,  70,   2,  16, 
      0,   0,   0,   0,   0,  70, 
    130,  32,   0,   0,   0,   0, 
      0,   4,   0,   0,   0,  15, 
      0,   0,   7,  18,   0,  16, 
      0,   0,   0,   0,   0,  70, 
      0,  16,   0,   0,   0,   0, 
      0,  70,   0,  16,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      9,  18,   0,  16,   0,   0, 
      0,   0,   0,  10,   0,  16, 
      0,   0,   0,   0,   0,  10, 
    128,  32, 128,  65,   0,   0, 
      0,   0,   0,   0,   0,   6, 
      0,   0,   0,  56,   0,   0, 
      8,  18,   0,  16,   0,   0, 
      0,   0,   0,  10,   0,  16, 
      0,   0,   0,   0,   0,  42, 
    128,  32,   0,   0,   0,   0, 
      0,   5,   0,   0,   0,  50, 
      0,   0,  10,  18,   0,  16, 
      0,   0,   0,   0,   0,  42, 
      0,  16,   0,   0,   0,   0, 
      0,  42,   0,  16,   0,   0, 
      0,   0,   0,  10,   0,  16, 
    128,  65,   0,   0,   0,   0, 
      0,   0,   0,  49,   0,   0, 
      7,  34,   0,  16,   0,   0, 
      0,   0,   0,  10,   0,  16, 
      0,   0,   0,   0,   0,   1, 
     64,   0,   0,   0,   0,   0, 
      0,  75,   0,   0,   6,  18, 
      0,  16,   0,   1,   0,   0, 
      0,  10,   0,  16, 128, 129, 
      0,   0,   0,   0,   0,   0, 
      0,  54,   0,   0,   6,  34, 
      0,  16,   0,   1,   0,   0, 
      0,  10,   0,  16, 128,  65, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   7,  82, 
      0,  16,   0,   0,   0,   0, 
      0, 166,  10,  16,   0,   0, 
      0,   0,   0,   6,   1,  16, 
      0,   1,   0,   0,   0,  14, 
      0,   0,   8,  82,   0,  16, 
      0,   0,   0,   0,   0,   6, 
      2,  16,   0,   0,   0,   0, 
      0, 166, 138,  32,   0,   0, 
      0,   0,   0,   5,   0,   0, 
      0,  56,   0,   0,   8,  50, 
      0,  16,   0,   1,   0,   0, 
      0, 134,   0,  16,   0,   0, 
      0,   0,   0, 166, 138,  32, 
      0,   0,   0,   0,   0,   4, 
      0,   0,   0,  29,   0,   0, 
      9,  50,   0,  16,   0,   1, 
      0,   0,   0,  70,   0,  16, 
      0,   1,   0,   0,   0, 246, 
    143,  32, 128,  65,   0,   0, 
      0,   0,   0,   0,   0,   5, 
      0,   0,   0,   1,   0,   0, 
     10,  50,   0,  16,   0,   1, 
      0,   0,   0,  70,   0,  16, 
      0,   1,   0,   0,   0,   2, 
     64,   0,   0,   0,   0, 128, 
     63,   0,   0, 128,  63,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   8,  18, 
      0,  16,   0,   0,   0,   0, 
      0,  42,   0,  16, 128,  65, 
      0,   0,   0,   0,   0,   0, 
      0,  10,   0,  16,   0,   0, 
      0,   0,   0,  50,   0,   0, 
      9,  18,   0,  16,   0,   2, 
      0,   0,   0,  10,   0,  16, 
      0,   1,   0,   0,   0,  10, 
      0,  16,   0,   0,   0,   0, 
      0,  42,   0,  16,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      5,  34,   0,  16,   0,   2, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0,   0,  63,  69, 
      0,   0,   9, 242,   0,  16, 
      0,   2,   0,   0,   0,  70, 
      0,  16,   0,   2,   0,   0, 
      0,  70, 126,  16,   0,   0, 
      0,   0,   0,   0,  96,  16, 
      0,   0,   0,   0,   0,  31, 
      0,   4,   3,  26,   0,  16, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   8, 242,  32,  16, 
      0,   0,   0,   0,   0,   2, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  62,   0,   0,   1,  21, 
      0,   0,   1,  52,   0,   0, 
      7,  18,   0,  16,   0,   0, 
      0,   0,   0,  26,   0,  16, 
      0,   1,   0,   0,   0,  10, 
      0,  16,   0,   1,   0,   0, 
      0,  29,   0,   0,   7,  18, 
      0,  16,   0,   0,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0,   0,   0,  10,   0,  16, 
      0,   0,   0,   0,   0,  31, 
      0,   4,   3,  10,   0,  16, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   8, 242,  32,  16, 
      0,   0,   0,   0,   0,   2, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  62,   0,   0,   1,  21, 
      0,   0,   1,  56,   0,   0, 
      7, 114,   0,  16,   0,   2, 
      0,   0,   0, 246,  15,  16, 
      0,   2,   0,   0,   0,  70, 
      2,  16,   0,   2,   0,   0, 
      0,  69,   0,   0,   9, 242, 
      0,  16,   0,   0,   0,   0, 
      0,  70,  16,  16,   0,   1, 
      0,   0,   0,  70, 126,  16, 
      0,   1,   0,   0,   0,   0, 
     96,  16,   0,   1,   0,   0, 
      0,  56,   0,   0,   7, 242, 
     32,  16,   0,   0,   0,   0, 
      0, 246,  15,  16,   0,   0, 
      0,   0,   0,  70,  14,  16, 
      0,   2,   0,   0,   0,  62, 
      0,   0,   1,  83,  84,  65, 
     84, 116,   0,   0,   0,  33, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,  17,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   5,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  82,  68,  69,  70, 100, 
      2,   0,   0,   1,   0,   0, 
      0, 232,   0,   0,   0,   5, 
      0,   0,   0,  28,   0,   0, 
      0,   0,   4, 255, 255,   0, 
      1,   0,   0,  51,   2,   0, 
      0, 188,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0, 203,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0, 216, 
      0,   0,   0,   2,   0,   0, 
      0,   5,   0,   0,   0,   4, 
      0,   0,   0, 255, 255, 255, 
    255,   0,   0,   0,   0,   1, 
      0,   0,   0,  12,   0,   0, 
      0, 220,   0,   0,   0,   2, 
      0,   0,   0,   5,   0,   0, 
      0,   4,   0,   0,   0, 255, 
    255, 255, 255,   1,   0,   0, 
      0,   1,   0,   0,   0,  12, 
      0,   0,   0, 225,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0, 115, 
     77, 105, 114, 114, 111, 114, 
     83,  97, 109, 112, 108, 101, 
    114,   0, 115,  77,  97, 115, 
    107,  83,  97, 109, 112, 108, 
    101, 114,   0, 116, 101, 120, 
      0, 109,  97, 115, 107,   0, 
     99,  98,  50,   0, 171, 171, 
    171, 225,   0,   0,   0,   7, 
      0,   0,   0,   0,   1,   0, 
      0, 112,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 168,   1,   0,   0,   0, 
      0,   0,   0,  44,   0,   0, 
      0,   0,   0,   0,   0, 192, 
      1,   0,   0,   0,   0,   0, 
      0, 208,   1,   0,   0,  48, 
      0,   0,   0,   8,   0,   0, 
      0,   0,   0,   0,   0, 220, 
      1,   0,   0,   0,   0,   0, 
      0, 236,   1,   0,   0,  64, 
      0,   0,   0,  12,   0,   0, 
      0,   2,   0,   0,   0, 244, 
      1,   0,   0,   0,   0,   0, 
      0,   4,   2,   0,   0,  80, 
      0,   0,   0,   8,   0,   0, 
      0,   2,   0,   0,   0, 220, 
      1,   0,   0,   0,   0,   0, 
      0,  12,   2,   0,   0,  88, 
      0,   0,   0,   4,   0,   0, 
      0,   2,   0,   0,   0,  16, 
      2,   0,   0,   0,   0,   0, 
      0,  32,   2,   0,   0,  92, 
      0,   0,   0,   4,   0,   0, 
      0,   2,   0,   0,   0,  16, 
      2,   0,   0,   0,   0,   0, 
      0,  40,   2,   0,   0,  96, 
      0,   0,   0,   4,   0,   0, 
      0,   2,   0,   0,   0,  16, 
      2,   0,   0,   0,   0,   0, 
      0,  68, 101, 118, 105,  99, 
    101,  83, 112,  97,  99, 101, 
     84, 111,  85, 115, 101, 114, 
     83, 112,  97,  99, 101,   0, 
    171,   3,   0,   3,   0,   3, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 100, 
    105, 109, 101, 110, 115, 105, 
    111, 110, 115,   0, 171,   1, 
      0,   3,   0,   1,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 100, 105, 102, 
    102,   0, 171, 171, 171,   1, 
      0,   3,   0,   1,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  99, 101, 110, 
    116, 101, 114,  49,   0,  65, 
      0, 171, 171,   0,   0,   3, 
      0,   1,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 114,  97, 100, 105, 117, 
    115,  49,   0, 115, 113,  95, 
    114,  97, 100, 105, 117, 115, 
     49,   0,  77, 105,  99, 114, 
    111, 115, 111, 102, 116,  32, 
     40,  82,  41,  32,  72,  76, 
     83,  76,  32,  83, 104,  97, 
    100, 101, 114,  32,  67, 111, 
    109, 112, 105, 108, 101, 114, 
     32,  57,  46,  50,  57,  46, 
     57,  53,  50,  46,  51,  49, 
     49,  49,   0,  73,  83,  71, 
     78, 104,   0,   0,   0,   3, 
      0,   0,   0,   8,   0,   0, 
      0,  80,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,  15,   0,   0, 
      0,  92,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   1, 
      0,   0,   0,   3,   3,   0, 
      0,  92,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   1, 
      0,   0,   0,  12,  12,   0, 
      0,  83,  86,  95,  80, 111, 
    115, 105, 116, 105, 111, 110, 
      0,  84,  69,  88,  67,  79, 
     79,  82,  68,   0, 171, 171, 
    171,  79,  83,  71,  78,  44, 
      0,   0,   0,   1,   0,   0, 
      0,   8,   0,   0,   0,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  15,   0,   0,   0,  83, 
     86,  95,  84,  97, 114, 103, 
    101, 116,   0, 171, 171, 155, 
     83,   0,   0,   0,   0,   0, 
      0,  65,  48,  77, 105, 114, 
    114, 111, 114,   0,  40,   7, 
      0,   0,  68,  88,  66,  67, 
    237,  58, 124, 168, 122, 234, 
    242,   5,  75,  29, 195,   6, 
    241, 206, 131, 117,   1,   0, 
      0,   0,  40,   7,   0,   0, 
      6,   0,   0,   0,  56,   0, 
      0,   0, 148,   1,   0,   0, 
    104,   3,   0,   0, 228,   3, 
      0,   0, 132,   6,   0,   0, 
    184,   6,   0,   0,  65, 111, 
    110,  57,  84,   1,   0,   0, 
     84,   1,   0,   0,   0,   2, 
    254, 255, 252,   0,   0,   0, 
     88,   0,   0,   0,   4,   0, 
     36,   0,   0,   0,  84,   0, 
      0,   0,  84,   0,   0,   0, 
     36,   0,   1,   0,  84,   0, 
      0,   0,   0,   0,   1,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   1,   0, 
      2,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      3,   0,   0,   0,   0,   0, 
      1,   0,   3,   0,   1,   0, 
      5,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   2, 
    254, 255,  81,   0,   0,   5, 
      6,   0,  15, 160,   0,   0, 
    128,  63,   0,   0,   0,  63, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  31,   0,   0,   2, 
      5,   0,   0, 128,   0,   0, 
     15, 144,   4,   0,   0,   4, 
      0,   0,   3, 224,   0,   0, 
    228, 144,   2,   0, 238, 160, 
      2,   0, 228, 160,   4,   0, 
      0,   4,   0,   0,   3, 128, 
      0,   0, 228, 144,   1,   0, 
    238, 160,   1,   0, 228, 160, 
      2,   0,   0,   3,   0,   0, 
      4, 128,   0,   0,   0, 128, 
      6,   0,   0, 160,   5,   0, 
      0,   3,   0,   0,   4, 128, 
      0,   0, 170, 128,   5,   0, 
      0, 160,   5,   0,   0,   3, 
      1,   0,   1, 128,   0,   0, 
    170, 128,   6,   0,  85, 160, 
      2,   0,   0,   3,   0,   0, 
      4, 128,   0,   0,  85, 129, 
      6,   0,   0, 160,   2,   0, 
      0,   3,   0,   0,   3, 192, 
      0,   0, 228, 128,   0,   0, 
    228, 160,   5,   0,   0,   3, 
      0,   0,   1, 128,   0,   0, 
    170, 128,   5,   0,  85, 160, 
      5,   0,   0,   3,   1,   0, 
      2, 128,   0,   0,   0, 128, 
      6,   0,  85, 160,   1,   0, 
      0,   2,   1,   0,   4, 128, 
      6,   0,   0, 160,   8,   0, 
      0,   3,   0,   0,   8, 224, 
      1,   0, 228, 128,   3,   0, 
    228, 160,   8,   0,   0,   3, 
      0,   0,   4, 224,   1,   0, 
    228, 128,   4,   0, 228, 160, 
      1,   0,   0,   2,   0,   0, 
     12, 192,   6,   0,  36, 160, 
    255, 255,   0,   0,  83,  72, 
     68,  82, 204,   1,   0,   0, 
     64,   0,   1,   0, 115,   0, 
      0,   0,  89,   0,   0,   4, 
     70, 142,  32,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
     89,   0,   0,   4,  70, 142, 
     32,   0,   1,   0,   0,   0, 
      4,   0,   0,   0,  95,   0, 
      0,   3,  50,  16,  16,   0, 
      0,   0,   0,   0, 103,   0, 
      0,   4, 242,  32,  16,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 101,   0,   0,   3, 
     50,  32,  16,   0,   1,   0, 
      0,   0, 101,   0,   0,   3, 
    194,  32,  16,   0,   1,   0, 
      0,   0, 104,   0,   0,   2, 
      2,   0,   0,   0,  54,   0, 
      0,   8, 194,  32,  16,   0, 
      0,   0,   0,   0,   2,  64, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 128,  63, 
     50,   0,   0,  11,  50,   0, 
     16,   0,   0,   0,   0,   0, 
     70,  16,  16,   0,   0,   0, 
      0,   0, 230, 138,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  70, 128,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  54,   0,   0,   5, 
     50,  32,  16,   0,   0,   0, 
      0,   0,  70,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   7,  18,   0,  16,   0, 
      0,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
    128,  63,   0,   0,   0,   8, 
     34,   0,  16,   0,   0,   0, 
      0,   0,  26,   0,  16, 128, 
     65,   0,   0,   0,   0,   0, 
      0,   0,   1,  64,   0,   0, 
      0,   0, 128,  63,  56,   0, 
      0,   8,  50,   0,  16,   0, 
      0,   0,   0,   0,  70,   0, 
     16,   0,   0,   0,   0,   0, 
     70, 128,  32,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
     56,   0,   0,  10,  50,   0, 
     16,   0,   1,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0,   0,  63,   0,   0, 
      0,  63,   0,   0,   0,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   5,  66,   0,  16,   0, 
      1,   0,   0,   0,   1,  64, 
      0,   0,   0,   0, 128,  63, 
     16,   0,   0,   8,  66,  32, 
     16,   0,   1,   0,   0,   0, 
     70,   2,  16,   0,   1,   0, 
      0,   0,  70, 130,  32,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,  16,   0,   0,   8, 
    130,  32,  16,   0,   1,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,  70, 130, 
     32,   0,   1,   0,   0,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  11,  50,  32,  16,   0, 
      1,   0,   0,   0,  70,  16, 
     16,   0,   0,   0,   0,   0, 
    230, 138,  32,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
     70, 128,  32,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
     62,   0,   0,   1,  83,  84, 
     65,  84, 116,   0,   0,   0, 
     12,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      4,   0,   0,   0,   6,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  82,  68,  69,  70, 
    152,   2,   0,   0,   2,   0, 
      0,   0, 100,   0,   0,   0, 
      2,   0,   0,   0,  28,   0, 
      0,   0,   0,   4, 254, 255, 
      0,   1,   0,   0, 103,   2, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,  96,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
     99,  98,  48,   0,  99,  98, 
     50,   0,  92,   0,   0,   0, 
      4,   0,   0,   0, 148,   0, 
      0,   0,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  96,   0,   0,   0, 
      7,   0,   0,   0,  52,   1, 
      0,   0, 112,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 244,   0,   0,   0, 
      0,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,  16,   1,   0,   0, 
     16,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,  26,   1,   0,   0, 
     32,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,  40,   1,   0,   0, 
     48,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,  81, 117,  97, 100, 
     68, 101, 115,  99,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  77,  97, 
    115, 107,  84, 101, 120,  67, 
    111, 111, 114, 100, 115,   0, 
     84, 101, 120, 116,  67, 111, 
    108, 111, 114,   0, 171, 171, 
    220,   1,   0,   0,   0,   0, 
      0,   0,  44,   0,   0,   0, 
      2,   0,   0,   0, 244,   1, 
      0,   0,   0,   0,   0,   0, 
      4,   2,   0,   0,  48,   0, 
      0,   0,   8,   0,   0,   0, 
      2,   0,   0,   0,  16,   2, 
      0,   0,   0,   0,   0,   0, 
     32,   2,   0,   0,  64,   0, 
      0,   0,  12,   0,   0,   0, 
      0,   0,   0,   0,  40,   2, 
      0,   0,   0,   0,   0,   0, 
     56,   2,   0,   0,  80,   0, 
      0,   0,   8,   0,   0,   0, 
      0,   0,   0,   0,  16,   2, 
      0,   0,   0,   0,   0,   0, 
     64,   2,   0,   0,  88,   0, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,  68,   2, 
      0,   0,   0,   0,   0,   0, 
     84,   2,   0,   0,  92,   0, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,  68,   2, 
      0,   0,   0,   0,   0,   0, 
     92,   2,   0,   0,  96,   0, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,  68,   2, 
      0,   0,   0,   0,   0,   0, 
     68, 101, 118, 105,  99, 101, 
     83, 112,  97,  99, 101,  84, 
    111,  85, 115, 101, 114,  83, 
    112,  97,  99, 101,   0, 171, 
      3,   0,   3,   0,   3,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 100, 105, 
    109, 101, 110, 115, 105, 111, 
    110, 115,   0, 171,   1,   0, 
      3,   0,   1,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 100, 105, 102, 102, 
      0, 171, 171, 171,   1,   0, 
      3,   0,   1,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  99, 101, 110, 116, 
    101, 114,  49,   0,  65,   0, 
    171, 171,   0,   0,   3,   0, 
      1,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    114,  97, 100, 105, 117, 115, 
     49,   0, 115, 113,  95, 114, 
     97, 100, 105, 117, 115,  49, 
      0,  77, 105,  99, 114, 111, 
    115, 111, 102, 116,  32,  40, 
     82,  41,  32,  72,  76,  83, 
     76,  32,  83, 104,  97, 100, 
    101, 114,  32,  67, 111, 109, 
    112, 105, 108, 101, 114,  32, 
     57,  46,  50,  57,  46,  57, 
     53,  50,  46,  51,  49,  49, 
     49,   0,  73,  83,  71,  78, 
     44,   0,   0,   0,   1,   0, 
      0,   0,   8,   0,   0,   0, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   7,   3,   0,   0, 
     80,  79,  83,  73,  84,  73, 
     79,  78,   0, 171, 171, 171, 
     79,  83,  71,  78, 104,   0, 
      0,   0,   3,   0,   0,   0, 
      8,   0,   0,   0,  80,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  92,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
      3,  12,   0,   0,  92,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   3,   0,   0,  83,  86, 
     95,  80, 111, 115, 105, 116, 
    105, 111, 110,   0,  84,  69, 
     88,  67,  79,  79,  82,  68, 
      0, 171, 171, 171, 148,  93, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
    196,   7,   0,   0,  68,  88, 
     66,  67,  10,  64, 223, 200, 
    195, 240,   1, 206,   6, 135, 
     41, 112, 246, 195, 250,  98, 
      1,   0,   0,   0, 196,   7, 
      0,   0,   6,   0,   0,   0, 
     56,   0,   0,   0, 196,   1, 
      0,   0,  56,   4,   0,   0, 
    180,   4,   0,   0,  32,   7, 
      0,   0, 144,   7,   0,   0, 
     65, 111, 110,  57, 132,   1, 
      0,   0, 132,   1,   0,   0, 
      0,   2, 255, 255,  76,   1, 
      0,   0,  56,   0,   0,   0, 
      1,   0,  44,   0,   0,   0, 
     56,   0,   0,   0,  56,   0, 
      2,   0,  36,   0,   0,   0, 
     56,   0,   0,   0,   0,   0, 
      1,   1,   1,   0,   0,   0, 
      4,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   1,   2, 
    255, 255,  81,   0,   0,   5, 
      2,   0,  15, 160,   0,   0, 
      0,  63,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  31,   0,   0,   2, 
      0,   0,   0, 128,   0,   0, 
     15, 176,  31,   0,   0,   2, 
      0,   0,   0, 144,   0,   8, 
     15, 160,  31,   0,   0,   2, 
      0,   0,   0, 144,   1,   8, 
     15, 160,   5,   0,   0,   3, 
      0,   0,   8, 128,   1,   0, 
    255, 160,   1,   0, 255, 160, 
      2,   0,   0,   3,   0,   0, 
      3, 128,   0,   0, 235, 176, 
      1,   0, 228, 161,  90,   0, 
      0,   4,   0,   0,   8, 128, 
      0,   0, 228, 128,   0,   0, 
    228, 128,   0,   0, 255, 129, 
      5,   0,   0,   3,   0,   0, 
      8, 128,   0,   0, 255, 128, 
      2,   0,   0, 160,   1,   0, 
      0,   2,   0,   0,   4, 128, 
      1,   0, 255, 160,   8,   0, 
      0,   3,   0,   0,   1, 128, 
      0,   0, 228, 128,   0,   0, 
    228, 160,   6,   0,   0,   2, 
      0,   0,   1, 128,   0,   0, 
      0, 128,   5,   0,   0,   3, 
      0,   0,   1, 128,   0,   0, 
      0, 128,   0,   0, 255, 128, 
      1,   0,   0,   2,   0,   0, 
      2, 128,   2,   0,   0, 160, 
     66,   0,   0,   3,   1,   0, 
     15, 128,   0,   0, 228, 176, 
      1,   8, 228, 160,  66,   0, 
      0,   3,   2,   0,  15, 128, 
      0,   0, 228, 128,   0,   8, 
    228, 160,   1,   0,   0,   2, 
      0,   0,   8, 128,   1,   0, 
    255, 160,   4,   0,   0,   4, 
      0,   0,   1, 128,   0,   0, 
      0, 128,   0,   0, 170, 161, 
      0,   0, 255, 129,   5,   0, 
      0,   3,   2,   0,   7, 128, 
      2,   0, 255, 128,   2,   0, 
    228, 128,   5,   0,   0,   3, 
      1,   0,  15, 128,   1,   0, 
    255, 128,   2,   0, 228, 128, 
     88,   0,   0,   4,   0,   0, 
     15, 128,   0,   0,   0, 128, 
      2,   0,  85, 160,   1,   0, 
    228, 128,   1,   0,   0,   2, 
      0,   8,  15, 128,   0,   0, 
    228, 128, 255, 255,   0,   0, 
     83,  72,  68,  82, 108,   2, 
      0,   0,  64,   0,   0,   0, 
    155,   0,   0,   0,  89,   0, 
      0,   4,  70, 142,  32,   0, 
      0,   0,   0,   0,   6,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  88,  24,   0,   4, 
      0, 112,  16,   0,   0,   0, 
      0,   0,  85,  85,   0,   0, 
     88,  24,   0,   4,   0, 112, 
     16,   0,   1,   0,   0,   0, 
     85,  85,   0,   0,  98,  16, 
      0,   3,  50,  16,  16,   0, 
      1,   0,   0,   0,  98,  16, 
      0,   3, 194,  16,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 242,  32,  16,   0, 
      0,   0,   0,   0, 104,   0, 
      0,   2,   2,   0,   0,   0, 
      0,   0,   0,   9,  50,   0, 
     16,   0,   0,   0,   0,   0, 
    230,  26,  16,   0,   1,   0, 
      0,   0,  70, 128,  32, 128, 
     65,   0,   0,   0,   0,   0, 
      0,   0,   5,   0,   0,   0, 
     54,   0,   0,   6,  66,   0, 
     16,   0,   0,   0,   0,   0, 
     58, 128,  32,   0,   0,   0, 
      0,   0,   5,   0,   0,   0, 
     16,   0,   0,   8,  66,   0, 
     16,   0,   0,   0,   0,   0, 
     70,   2,  16,   0,   0,   0, 
      0,   0,  70, 130,  32,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,  15,   0,   0,   7, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  70,   0,  16,   0, 
      0,   0,   0,   0,  70,   0, 
     16,   0,   0,   0,   0,   0, 
     50,   0,   0,  12,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     58, 128,  32, 128,  65,   0, 
      0,   0,   0,   0,   0,   0, 
      5,   0,   0,   0,  58, 128, 
     32,   0,   0,   0,   0,   0, 
      5,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
     56,   0,   0,   7,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     10,   0,  16,   0,   0,   0, 
      0,   0,   1,  64,   0,   0, 
      0,   0,   0,  63,  14,   0, 
      0,   7,  18,   0,  16,   0, 
      0,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
     42,   0,  16,   0,   0,   0, 
      0,   0,  56,   0,   0,   8, 
     66,   0,  16,   0,   0,   0, 
      0,   0,  10,   0,  16,   0, 
      0,   0,   0,   0,  42, 128, 
     32,   0,   0,   0,   0,   0, 
      4,   0,   0,   0,  29,   0, 
      0,   9,  66,   0,  16,   0, 
      0,   0,   0,   0,  58, 128, 
     32, 128,  65,   0,   0,   0, 
      0,   0,   0,   0,   5,   0, 
      0,   0,  42,   0,  16,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   5,  34,   0,  16,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,   0,   0,   0,  63, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   1,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     31,   0,   4,   3,  42,   0, 
     16,   0,   0,   0,   0,   0, 
     54,   0,   0,   8, 242,  32, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  62,   0,   0,   1, 
     21,   0,   0,   1,  56,   0, 
      0,   7, 114,   0,  16,   0, 
      1,   0,   0,   0, 246,  15, 
     16,   0,   1,   0,   0,   0, 
     70,   2,  16,   0,   1,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   0,   0, 
      0,   0,  70,  16,  16,   0, 
      1,   0,   0,   0,  70, 126, 
     16,   0,   1,   0,   0,   0, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  56,   0,   0,   7, 
    242,  32,  16,   0,   0,   0, 
      0,   0, 246,  15,  16,   0, 
      0,   0,   0,   0,  70,  14, 
     16,   0,   1,   0,   0,   0, 
     62,   0,   0,   1,  83,  84, 
     65,  84, 116,   0,   0,   0, 
     19,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   9,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  82,  68,  69,  70, 
    100,   2,   0,   0,   1,   0, 
      0,   0, 232,   0,   0,   0, 
      5,   0,   0,   0,  28,   0, 
      0,   0,   0,   4, 255, 255, 
      0,   1,   0,   0,  51,   2, 
      0,   0, 188,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 203,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    216,   0,   0,   0,   2,   0, 
      0,   0,   5,   0,   0,   0, 
      4,   0,   0,   0, 255, 255, 
    255, 255,   0,   0,   0,   0, 
      1,   0,   0,   0,  12,   0, 
      0,   0, 220,   0,   0,   0, 
      2,   0,   0,   0,   5,   0, 
      0,   0,   4,   0,   0,   0, 
    255, 255, 255, 255,   1,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   0,   0,   0, 225,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    115,  77, 105, 114, 114, 111, 
    114,  83,  97, 109, 112, 108, 
    101, 114,   0, 115,  77,  97, 
    115, 107,  83,  97, 109, 112, 
    108, 101, 114,   0, 116, 101, 
    120,   0, 109,  97, 115, 107, 
      0,  99,  98,  50,   0, 171, 
    171, 171, 225,   0,   0,   0, 
      7,   0,   0,   0,   0,   1, 
      0,   0, 112,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 168,   1,   0,   0, 
      0,   0,   0,   0,  44,   0, 
      0,   0,   0,   0,   0,   0, 
    192,   1,   0,   0,   0,   0, 
      0,   0, 208,   1,   0,   0, 
     48,   0,   0,   0,   8,   0, 
      0,   0,   0,   0,   0,   0, 
    220,   1,   0,   0,   0,   0, 
      0,   0, 236,   1,   0,   0, 
     64,   0,   0,   0,  12,   0, 
      0,   0,   2,   0,   0,   0, 
    244,   1,   0,   0,   0,   0, 
      0,   0,   4,   2,   0,   0, 
     80,   0,   0,   0,   8,   0, 
      0,   0,   2,   0,   0,   0, 
    220,   1,   0,   0,   0,   0, 
      0,   0,  12,   2,   0,   0, 
     88,   0,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
     16,   2,   0,   0,   0,   0, 
      0,   0,  32,   2,   0,   0, 
     92,   0,   0,   0,   4,   0, 
      0,   0,   2,   0,   0,   0, 
     16,   2,   0,   0,   0,   0, 
      0,   0,  40,   2,   0,   0, 
     96,   0,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
     16,   2,   0,   0,   0,   0, 
      0,   0,  68, 101, 118, 105, 
     99, 101,  83, 112,  97,  99, 
    101,  84, 111,  85, 115, 101, 
    114,  83, 112,  97,  99, 101, 
      0, 171,   3,   0,   3,   0, 
      3,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    100, 105, 109, 101, 110, 115, 
    105, 111, 110, 115,   0, 171, 
      1,   0,   3,   0,   1,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 100, 105, 
    102, 102,   0, 171, 171, 171, 
      1,   0,   3,   0,   1,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  99, 101, 
    110, 116, 101, 114,  49,   0, 
     65,   0, 171, 171,   0,   0, 
      3,   0,   1,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 114,  97, 100, 105, 
    117, 115,  49,   0, 115, 113, 
     95, 114,  97, 100, 105, 117, 
    115,  49,   0,  77, 105,  99, 
    114, 111, 115, 111, 102, 116, 
     32,  40,  82,  41,  32,  72, 
     76,  83,  76,  32,  83, 104, 
     97, 100, 101, 114,  32,  67, 
    111, 109, 112, 105, 108, 101, 
    114,  32,  57,  46,  50,  57, 
     46,  57,  53,  50,  46,  51, 
     49,  49,  49,   0,  73,  83, 
     71,  78, 104,   0,   0,   0, 
      3,   0,   0,   0,   8,   0, 
      0,   0,  80,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   3,   3, 
      0,   0,  92,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,  12,  12, 
      0,   0,  83,  86,  95,  80, 
    111, 115, 105, 116, 105, 111, 
    110,   0,  84,  69,  88,  67, 
     79,  79,  82,  68,   0, 171, 
    171, 171,  79,  83,  71,  78, 
     44,   0,   0,   0,   1,   0, 
      0,   0,   8,   0,   0,   0, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  15,   0,   0,   0, 
     83,  86,  95,  84,  97, 114, 
    103, 101, 116,   0, 171, 171, 
    212, 100,   0,   0,   0,   0, 
      0,   0,  83,  97, 109, 112, 
    108, 101,  77,  97, 115, 107, 
    101, 100,  84, 101, 120, 116, 
    117, 114, 101,   0,  68,   4, 
      0,   0,  68,  88,  66,  67, 
     26, 214, 157, 140, 185,  91, 
    182, 211, 177, 171, 114, 225, 
    174, 107,  56, 117,   1,   0, 
      0,   0,  68,   4,   0,   0, 
      6,   0,   0,   0,  56,   0, 
      0,   0, 248,   0,   0,   0, 
    244,   1,   0,   0, 112,   2, 
      0,   0, 160,   3,   0,   0, 
    212,   3,   0,   0,  65, 111, 
    110,  57, 184,   0,   0,   0, 
    184,   0,   0,   0,   0,   2, 
    254, 255, 132,   0,   0,   0, 
     52,   0,   0,   0,   1,   0, 
     36,   0,   0,   0,  48,   0, 
      0,   0,  48,   0,   0,   0, 
     36,   0,   1,   0,  48,   0, 
      0,   0,   0,   0,   3,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   2, 
    254, 255,  81,   0,   0,   5, 
      4,   0,  15, 160,   0,   0, 
      0,   0,   0,   0, 128,  63, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  31,   0,   0,   2, 
      5,   0,   0, 128,   0,   0, 
     15, 144,   4,   0,   0,   4, 
      0,   0,   3, 224,   0,   0, 
    228, 144,   2,   0, 238, 160, 
      2,   0, 228, 160,   4,   0, 
      0,   4,   0,   0,  12, 224, 
      0,   0,  20, 144,   3,   0, 
    180, 160,   3,   0,  20, 160, 
      4,   0,   0,   4,   0,   0, 
      3, 128,   0,   0, 228, 144, 
      1,   0, 238, 160,   1,   0, 
    228, 160,   2,   0,   0,   3, 
      0,   0,   3, 192,   0,   0, 
    228, 128,   0,   0, 228, 160, 
      1,   0,   0,   2,   0,   0, 
     12, 192,   4,   0,  68, 160, 
    255, 255,   0,   0,  83,  72, 
     68,  82, 244,   0,   0,   0, 
     64,   0,   1,   0,  61,   0, 
      0,   0,  89,   0,   0,   4, 
     70, 142,  32,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
     95,   0,   0,   3,  50,  16, 
     16,   0,   0,   0,   0,   0, 
    103,   0,   0,   4, 242,  32, 
     16,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3,  50,  32,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 194,  32,  16,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  11,  50,  32,  16,   0, 
      0,   0,   0,   0,  70,  16, 
     16,   0,   0,   0,   0,   0, 
    230, 138,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     70, 128,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     54,   0,   0,   8, 194,  32, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    128,  63,  50,   0,   0,  11, 
     50,  32,  16,   0,   1,   0, 
      0,   0,  70,  16,  16,   0, 
      0,   0,   0,   0, 230, 138, 
     32,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  70, 128, 
     32,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  11, 194,  32,  16,   0, 
      1,   0,   0,   0,   6,  20, 
     16,   0,   0,   0,   0,   0, 
    166, 142,  32,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
      6, 132,  32,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
     62,   0,   0,   1,  83,  84, 
     65,  84, 116,   0,   0,   0, 
      5,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  82,  68,  69,  70, 
     40,   1,   0,   0,   1,   0, 
      0,   0,  64,   0,   0,   0, 
      1,   0,   0,   0,  28,   0, 
      0,   0,   0,   4, 254, 255, 
      0,   1,   0,   0, 246,   0, 
      0,   0,  60,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,  99,  98, 
     48,   0,  60,   0,   0,   0, 
      4,   0,   0,   0,  88,   0, 
      0,   0,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 184,   0,   0,   0, 
      0,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0, 212,   0,   0,   0, 
     16,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0, 222,   0,   0,   0, 
     32,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0, 236,   0,   0,   0, 
     48,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0,  81, 117,  97, 100, 
     68, 101, 115,  99,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  77,  97, 
    115, 107,  84, 101, 120,  67, 
    111, 111, 114, 100, 115,   0, 
     84, 101, 120, 116,  67, 111, 
    108, 111, 114,   0,  77, 105, 
     99, 114, 111, 115, 111, 102, 
    116,  32,  40,  82,  41,  32, 
     72,  76,  83,  76,  32,  83, 
    104,  97, 100, 101, 114,  32, 
     67, 111, 109, 112, 105, 108, 
    101, 114,  32,  57,  46,  50, 
     57,  46,  57,  53,  50,  46, 
     51,  49,  49,  49,   0, 171, 
     73,  83,  71,  78,  44,   0, 
      0,   0,   1,   0,   0,   0, 
      8,   0,   0,   0,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   3,   0,   0,  80,  79, 
     83,  73,  84,  73,  79,  78, 
      0, 171, 171, 171,  79,  83, 
     71,  78, 104,   0,   0,   0, 
      3,   0,   0,   0,   8,   0, 
      0,   0,  80,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   3,  12, 
      0,   0,  92,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,  12,   3, 
      0,   0,  83,  86,  95,  80, 
    111, 115, 105, 116, 105, 111, 
    110,   0,  84,  69,  88,  67, 
     79,  79,  82,  68,   0, 171, 
    171, 171, 184, 108,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0, 208,   3, 
      0,   0,  68,  88,  66,  67, 
    145,  96, 208, 189, 244, 147, 
     57, 205, 242, 133,  35, 176, 
     39, 143, 121, 235,   1,   0, 
      0,   0, 208,   3,   0,   0, 
      6,   0,   0,   0,  56,   0, 
      0,   0, 224,   0,   0,   0, 
    188,   1,   0,   0,  56,   2, 
      0,   0,  44,   3,   0,   0, 
    156,   3,   0,   0,  65, 111, 
    110,  57, 160,   0,   0,   0, 
    160,   0,   0,   0,   0,   2, 
    255, 255, 116,   0,   0,   0, 
     44,   0,   0,   0,   0,   0, 
     44,   0,   0,   0,  44,   0, 
      0,   0,  44,   0,   2,   0, 
     36,   0,   0,   0,  44,   0, 
      0,   0,   0,   0,   1,   1, 
      1,   0,   1,   2, 255, 255, 
     31,   0,   0,   2,   0,   0, 
      0, 128,   0,   0,  15, 176, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   0,   8,  15, 160, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   1,   8,  15, 160, 
      1,   0,   0,   2,   0,   0, 
      3, 128,   0,   0, 235, 176, 
     66,   0,   0,   3,   1,   0, 
     15, 128,   0,   0, 228, 176, 
      0,   8, 228, 160,  66,   0, 
      0,   3,   0,   0,  15, 128, 
      0,   0, 228, 128,   1,   8, 
    228, 160,   5,   0,   0,   3, 
      0,   0,  15, 128,   0,   0, 
    255, 128,   1,   0, 228, 128, 
      1,   0,   0,   2,   0,   8, 
     15, 128,   0,   0, 228, 128, 
    255, 255,   0,   0,  83,  72, 
     68,  82, 212,   0,   0,   0, 
     64,   0,   0,   0,  53,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  88,  24,   0,   4, 
      0, 112,  16,   0,   0,   0, 
      0,   0,  85,  85,   0,   0, 
     88,  24,   0,   4,   0, 112, 
     16,   0,   1,   0,   0,   0, 
     85,  85,   0,   0,  98,  16, 
      0,   3,  50,  16,  16,   0, 
      1,   0,   0,   0,  98,  16, 
      0,   3, 194,  16,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 242,  32,  16,   0, 
      0,   0,   0,   0, 104,   0, 
      0,   2,   2,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   0,   0,   0,   0, 
     70,  16,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   1,   0,   0,   0, 
    230,  26,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      1,   0,   0,   0,   0,  96, 
     16,   0,   1,   0,   0,   0, 
     56,   0,   0,   7, 242,  32, 
     16,   0,   0,   0,   0,   0, 
     70,  14,  16,   0,   0,   0, 
      0,   0, 246,  15,  16,   0, 
      1,   0,   0,   0,  62,   0, 
      0,   1,  83,  84,  65,  84, 
    116,   0,   0,   0,   4,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     82,  68,  69,  70, 236,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,  28,   0,   0,   0, 
      0,   4, 255, 255,   0,   1, 
      0,   0, 187,   0,   0,   0, 
    156,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 165,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 178,   0, 
      0,   0,   2,   0,   0,   0, 
      5,   0,   0,   0,   4,   0, 
      0,   0, 255, 255, 255, 255, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  12,   0,   0,   0, 
    182,   0,   0,   0,   2,   0, 
      0,   0,   5,   0,   0,   0, 
      4,   0,   0,   0, 255, 255, 
    255, 255,   1,   0,   0,   0, 
      1,   0,   0,   0,  12,   0, 
      0,   0, 115,  83,  97, 109, 
    112, 108, 101, 114,   0, 115, 
     77,  97, 115, 107,  83,  97, 
    109, 112, 108, 101, 114,   0, 
    116, 101, 120,   0, 109,  97, 
    115, 107,   0,  77, 105,  99, 
    114, 111, 115, 111, 102, 116, 
     32,  40,  82,  41,  32,  72, 
     76,  83,  76,  32,  83, 104, 
     97, 100, 101, 114,  32,  67, 
    111, 109, 112, 105, 108, 101, 
    114,  32,  57,  46,  50,  57, 
     46,  57,  53,  50,  46,  51, 
     49,  49,  49,   0,  73,  83, 
     71,  78, 104,   0,   0,   0, 
      3,   0,   0,   0,   8,   0, 
      0,   0,  80,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   3,   3, 
      0,   0,  92,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,  12,  12, 
      0,   0,  83,  86,  95,  80, 
    111, 115, 105, 116, 105, 111, 
    110,   0,  84,  69,  88,  67, 
     79,  79,  82,  68,   0, 171, 
    171, 171,  79,  83,  71,  78, 
     44,   0,   0,   0,   1,   0, 
      0,   0,   8,   0,   0,   0, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  15,   0,   0,   0, 
     83,  86,  95,  84,  97, 114, 
    103, 101, 116,   0, 171, 171, 
     20, 113,   0,   0,   0,   0, 
      0,   0,  83,  97, 109, 112, 
    108, 101,  84, 101, 120, 116, 
    117, 114, 101,  87, 105, 116, 
    104,  83, 104,  97, 100, 111, 
    119,   0,   4,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
    128,  63,   1,   0,   0,   0, 
      0,   0, 128,  63,   1,   0, 
      0,   0,   0,   0, 128,  63, 
      1,   0,   0,   0,   0,   0, 
    128,  63,   1,   0,   0,   0, 
      3,   0,   0,   0, 255, 255, 
    255, 255,  68,   4,   0,   0, 
     68,  88,  66,  67,  26, 214, 
    157, 140, 185,  91, 182, 211, 
    177, 171, 114, 225, 174, 107, 
     56, 117,   1,   0,   0,   0, 
     68,   4,   0,   0,   6,   0, 
      0,   0,  56,   0,   0,   0, 
    248,   0,   0,   0, 244,   1, 
      0,   0, 112,   2,   0,   0, 
    160,   3,   0,   0, 212,   3, 
      0,   0,  65, 111, 110,  57, 
    184,   0,   0,   0, 184,   0, 
      0,   0,   0,   2, 254, 255, 
    132,   0,   0,   0,  52,   0, 
      0,   0,   1,   0,  36,   0, 
      0,   0,  48,   0,   0,   0, 
     48,   0,   0,   0,  36,   0, 
      1,   0,  48,   0,   0,   0, 
      0,   0,   3,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   2, 254, 255, 
     81,   0,   0,   5,   4,   0, 
     15, 160,   0,   0,   0,   0, 
      0,   0, 128,  63,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     31,   0,   0,   2,   5,   0, 
      0, 128,   0,   0,  15, 144, 
      4,   0,   0,   4,   0,   0, 
      3, 224,   0,   0, 228, 144, 
      2,   0, 238, 160,   2,   0, 
    228, 160,   4,   0,   0,   4, 
      0,   0,  12, 224,   0,   0, 
     20, 144,   3,   0, 180, 160, 
      3,   0,  20, 160,   4,   0, 
      0,   4,   0,   0,   3, 128, 
      0,   0, 228, 144,   1,   0, 
    238, 160,   1,   0, 228, 160, 
      2,   0,   0,   3,   0,   0, 
      3, 192,   0,   0, 228, 128, 
      0,   0, 228, 160,   1,   0, 
      0,   2,   0,   0,  12, 192, 
      4,   0,  68, 160, 255, 255, 
      0,   0,  83,  72,  68,  82, 
    244,   0,   0,   0,  64,   0, 
      1,   0,  61,   0,   0,   0, 
     89,   0,   0,   4,  70, 142, 
     32,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,  95,   0, 
      0,   3,  50,  16,  16,   0, 
      0,   0,   0,   0, 103,   0, 
      0,   4, 242,  32,  16,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 101,   0,   0,   3, 
     50,  32,  16,   0,   1,   0, 
      0,   0, 101,   0,   0,   3, 
    194,  32,  16,   0,   1,   0, 
      0,   0,  50,   0,   0,  11, 
     50,  32,  16,   0,   0,   0, 
      0,   0,  70,  16,  16,   0, 
      0,   0,   0,   0, 230, 138, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  70, 128, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   8, 194,  32,  16,   0, 
      0,   0,   0,   0,   2,  64, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 128,  63, 
     50,   0,   0,  11,  50,  32, 
     16,   0,   1,   0,   0,   0, 
     70,  16,  16,   0,   0,   0, 
      0,   0, 230, 138,  32,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  70, 128,  32,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  50,   0,   0,  11, 
    194,  32,  16,   0,   1,   0, 
      0,   0,   6,  20,  16,   0, 
      0,   0,   0,   0, 166, 142, 
     32,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,   6, 132, 
     32,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,  62,   0, 
      0,   1,  83,  84,  65,  84, 
    116,   0,   0,   0,   5,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     82,  68,  69,  70,  40,   1, 
      0,   0,   1,   0,   0,   0, 
     64,   0,   0,   0,   1,   0, 
      0,   0,  28,   0,   0,   0, 
      0,   4, 254, 255,   0,   1, 
      0,   0, 246,   0,   0,   0, 
     60,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,  99,  98,  48,   0, 
     60,   0,   0,   0,   4,   0, 
      0,   0,  88,   0,   0,   0, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    184,   0,   0,   0,   0,   0, 
      0,   0,  16,   0,   0,   0, 
      2,   0,   0,   0, 196,   0, 
      0,   0,   0,   0,   0,   0, 
    212,   0,   0,   0,  16,   0, 
      0,   0,  16,   0,   0,   0, 
      2,   0,   0,   0, 196,   0, 
      0,   0,   0,   0,   0,   0, 
    222,   0,   0,   0,  32,   0, 
      0,   0,  16,   0,   0,   0, 
      2,   0,   0,   0, 196,   0, 
      0,   0,   0,   0,   0,   0, 
    236,   0,   0,   0,  48,   0, 
      0,   0,  16,   0,   0,   0, 
      0,   0,   0,   0, 196,   0, 
      0,   0,   0,   0,   0,   0, 
     81, 117,  97, 100,  68, 101, 
    115,  99,   0, 171, 171, 171, 
      1,   0,   3,   0,   1,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  84, 101, 
    120,  67, 111, 111, 114, 100, 
    115,   0,  77,  97, 115, 107, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  84, 101, 
    120, 116,  67, 111, 108, 111, 
    114,   0,  77, 105,  99, 114, 
    111, 115, 111, 102, 116,  32, 
     40,  82,  41,  32,  72,  76, 
     83,  76,  32,  83, 104,  97, 
    100, 101, 114,  32,  67, 111, 
    109, 112, 105, 108, 101, 114, 
     32,  57,  46,  50,  57,  46, 
     57,  53,  50,  46,  51,  49, 
     49,  49,   0, 171,  73,  83, 
     71,  78,  44,   0,   0,   0, 
      1,   0,   0,   0,   8,   0, 
      0,   0,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   7,   3, 
      0,   0,  80,  79,  83,  73, 
     84,  73,  79,  78,   0, 171, 
    171, 171,  79,  83,  71,  78, 
    104,   0,   0,   0,   3,   0, 
      0,   0,   8,   0,   0,   0, 
     80,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  15,   0,   0,   0, 
     92,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,   3,  12,   0,   0, 
     92,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,  12,   3,   0,   0, 
     83,  86,  95,  80, 111, 115, 
    105, 116, 105, 111, 110,   0, 
     84,  69,  88,  67,  79,  79, 
     82,  68,   0, 171, 171, 171, 
     56, 117,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0, 232,   9,   0,   0, 
     68,  88,  66,  67,  45,  80, 
     33,   8,   5,  16, 134, 134, 
    115,  16, 129,  43, 103, 216, 
    255, 210,   1,   0,   0,   0, 
    232,   9,   0,   0,   6,   0, 
      0,   0,  56,   0,   0,   0, 
    248,   2,   0,   0,   8,   7, 
      0,   0, 132,   7,   0,   0, 
     68,   9,   0,   0, 180,   9, 
      0,   0,  65, 111, 110,  57, 
    184,   2,   0,   0, 184,   2, 
      0,   0,   0,   2, 255, 255, 
    120,   2,   0,   0,  64,   0, 
      0,   0,   2,   0,  40,   0, 
      0,   0,  64,   0,   0,   0, 
     64,   0,   1,   0,  36,   0, 
      0,   0,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   6,   0, 
      4,   0,   3,   0,   0,   0, 
      0,   0,   1,   2, 255, 255, 
     31,   0,   0,   2,   0,   0, 
      0, 128,   0,   0,  15, 176, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   0,   8,  15, 160, 
      2,   0,   0,   3,   0,   0, 
      1, 128,   0,   0,   0, 176, 
      0,   0,  85, 160,   1,   0, 
      0,   2,   0,   0,   2, 128, 
      0,   0,  85, 176,   2,   0, 
      0,   3,   1,   0,   1, 128, 
      0,   0,   0, 176,   0,   0, 
      0, 160,   1,   0,   0,   2, 
      1,   0,   2, 128,   0,   0, 
     85, 176,  66,   0,   0,   3, 
      0,   0,  15, 128,   0,   0, 
    228, 128,   0,   8, 228, 160, 
     66,   0,   0,   3,   1,   0, 
     15, 128,   1,   0, 228, 128, 
      0,   8, 228, 160,   5,   0, 
      0,   3,   0,   0,   1, 128, 
      0,   0, 255, 128,   3,   0, 
     85, 160,   4,   0,   0,   4, 
      0,   0,   1, 128,   3,   0, 
      0, 160,   1,   0, 255, 128, 
      0,   0,   0, 128,   2,   0, 
      0,   3,   1,   0,   1, 128, 
      0,   0,   0, 176,   0,   0, 
    170, 160,   1,   0,   0,   2, 
      1,   0,   2, 128,   0,   0, 
     85, 176,   2,   0,   0,   3, 
      2,   0,   1, 128,   0,   0, 
      0, 176,   0,   0, 255, 160, 
      1,   0,   0,   2,   2,   0, 
      2, 128,   0,   0,  85, 176, 
     66,   0,   0,   3,   1,   0, 
     15, 128,   1,   0, 228, 128, 
      0,   8, 228, 160,  66,   0, 
      0,   3,   2,   0,  15, 128, 
      2,   0, 228, 128,   0,   8, 
    228, 160,   4,   0,   0,   4, 
      0,   0,   1, 128,   3,   0, 
    170, 160,   1,   0, 255, 128, 
      0,   0,   0, 128,   4,   0, 
      0,   4,   0,   0,   1, 128, 
      3,   0, 255, 160,   2,   0, 
    255, 128,   0,   0,   0, 128, 
      2,   0,   0,   3,   1,   0, 
      1, 128,   0,   0,   0, 176, 
      1,   0,   0, 160,   1,   0, 
      0,   2,   1,   0,   2, 128, 
      0,   0,  85, 176,   2,   0, 
      0,   3,   2,   0,   1, 128, 
      0,   0,   0, 176,   1,   0, 
     85, 160,   1,   0,   0,   2, 
      2,   0,   2, 128,   0,   0, 
     85, 176,  66,   0,   0,   3, 
      1,   0,  15, 128,   1,   0, 
    228, 128,   0,   8, 228, 160, 
     66,   0,   0,   3,   2,   0, 
     15, 128,   2,   0, 228, 128, 
      0,   8, 228, 160,   4,   0, 
      0,   4,   0,   0,   1, 128, 
      4,   0,   0, 160,   1,   0, 
    255, 128,   0,   0,   0, 128, 
      4,   0,   0,   4,   0,   0, 
      1, 128,   4,   0,  85, 160, 
      2,   0, 255, 128,   0,   0, 
      0, 128,   2,   0,   0,   3, 
      1,   0,   1, 128,   0,   0, 
      0, 176,   1,   0, 170, 160, 
      1,   0,   0,   2,   1,   0, 
      2, 128,   0,   0,  85, 176, 
      2,   0,   0,   3,   2,   0, 
      1, 128,   0,   0,   0, 176, 
      1,   0, 255, 160,   1,   0, 
      0,   2,   2,   0,   2, 128, 
      0,   0,  85, 176,  66,   0, 
      0,   3,   1,   0,  15, 128, 
      1,   0, 228, 128,   0,   8, 
    228, 160,  66,   0,   0,   3, 
      2,   0,  15, 128,   2,   0, 
    228, 128,   0,   8, 228, 160, 
      4,   0,   0,   4,   0,   0, 
      1, 128,   4,   0, 170, 160, 
      1,   0, 255, 128,   0,   0, 
      0, 128,   4,   0,   0,   4, 
      0,   0,   1, 128,   4,   0, 
    255, 160,   2,   0, 255, 128, 
      0,   0,   0, 128,   2,   0, 
      0,   3,   1,   0,   1, 128, 
      0,   0,   0, 176,   2,   0, 
      0, 160,   1,   0,   0,   2, 
      1,   0,   2, 128,   0,   0, 
     85, 176,  66,   0,   0,   3, 
      1,   0,  15, 128,   1,   0, 
    228, 128,   0,   8, 228, 160, 
      4,   0,   0,   4,   0,   0, 
      1, 128,   5,   0,   0, 160, 
      1,   0, 255, 128,   0,   0, 
      0, 128,   5,   0,   0,   3, 
      0,   0,  15, 128,   0,   0, 
      0, 128,   6,   0, 228, 160, 
      1,   0,   0,   2,   0,   8, 
     15, 128,   0,   0, 228, 128, 
    255, 255,   0,   0,  83,  72, 
     68,  82,   8,   4,   0,   0, 
     64,   0,   0,   0,   2,   1, 
      0,   0,  89,   0,   0,   4, 
     70, 142,  32,   0,   0,   0, 
      0,   0,  10,   0,   0,   0, 
     90,   0,   0,   3,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     88,  24,   0,   4,   0, 112, 
     16,   0,   0,   0,   0,   0, 
     85,  85,   0,   0,  98,  16, 
      0,   3,  50,  16,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 242,  32,  16,   0, 
      0,   0,   0,   0, 104,   0, 
      0,   2,   4,   0,   0,   0, 
      0,   0,   0,   8, 242,   0, 
     16,   0,   0,   0,   0,   0, 
      6,  16,  16,   0,   1,   0, 
      0,   0,  38, 135,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  54,   0,   0,   5, 
     82,   0,  16,   0,   1,   0, 
      0,   0,  86,   7,  16,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   5, 162,   0,  16,   0, 
      1,   0,   0,   0,  86,  21, 
     16,   0,   1,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   2,   0,   0,   0, 
    230,  10,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   1,   0,   0,   0, 
     70,   0,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     56,   0,   0,   8,  18,   0, 
     16,   0,   1,   0,   0,   0, 
     58,   0,  16,   0,   2,   0, 
      0,   0,  26, 128,  32,   0, 
      0,   0,   0,   0,   6,   0, 
      0,   0,  50,   0,   0,  10, 
     18,   0,  16,   0,   1,   0, 
      0,   0,  10, 128,  32,   0, 
      0,   0,   0,   0,   6,   0, 
      0,   0,  58,   0,  16,   0, 
      1,   0,   0,   0,  10,   0, 
     16,   0,   1,   0,   0,   0, 
     54,   0,   0,   5, 162,   0, 
     16,   0,   0,   0,   0,   0, 
     86,  21,  16,   0,   1,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   2,   0, 
      0,   0,  70,   0,  16,   0, 
      0,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   0,   0, 
      0,   0, 230,  10,  16,   0, 
      0,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  50,   0,   0,  10, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  42, 128,  32,   0, 
      0,   0,   0,   0,   6,   0, 
      0,   0,  58,   0,  16,   0, 
      2,   0,   0,   0,  10,   0, 
     16,   0,   1,   0,   0,   0, 
     50,   0,   0,  10,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     58, 128,  32,   0,   0,   0, 
      0,   0,   6,   0,   0,   0, 
     58,   0,  16,   0,   0,   0, 
      0,   0,  10,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   8, 242,   0,  16,   0, 
      1,   0,   0,   0,   6,  16, 
     16,   0,   1,   0,   0,   0, 
     38, 135,  32,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     54,   0,   0,   5,  82,   0, 
     16,   0,   2,   0,   0,   0, 
     86,   7,  16,   0,   1,   0, 
      0,   0,  54,   0,   0,   5, 
    162,   0,  16,   0,   2,   0, 
      0,   0,  86,  21,  16,   0, 
      1,   0,   0,   0,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      3,   0,   0,   0,  70,   0, 
     16,   0,   2,   0,   0,   0, 
     70, 126,  16,   0,   0,   0, 
      0,   0,   0,  96,  16,   0, 
      0,   0,   0,   0,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      2,   0,   0,   0, 230,  10, 
     16,   0,   2,   0,   0,   0, 
     70, 126,  16,   0,   0,   0, 
      0,   0,   0,  96,  16,   0, 
      0,   0,   0,   0,  50,   0, 
      0,  10,  18,   0,  16,   0, 
      0,   0,   0,   0,  10, 128, 
     32,   0,   0,   0,   0,   0, 
      7,   0,   0,   0,  58,   0, 
     16,   0,   3,   0,   0,   0, 
     10,   0,  16,   0,   0,   0, 
      0,   0,  50,   0,   0,  10, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  26, 128,  32,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0,  58,   0,  16,   0, 
      2,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
     54,   0,   0,   5, 162,   0, 
     16,   0,   1,   0,   0,   0, 
     86,  21,  16,   0,   1,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   2,   0, 
      0,   0,  70,   0,  16,   0, 
      1,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   1,   0, 
      0,   0, 230,  10,  16,   0, 
      1,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  50,   0,   0,  10, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  42, 128,  32,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0,  58,   0,  16,   0, 
      2,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
     50,   0,   0,  10,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     58, 128,  32,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
     58,   0,  16,   0,   1,   0, 
      0,   0,  10,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   8,  18,   0,  16,   0, 
      1,   0,   0,   0,  10,  16, 
     16,   0,   1,   0,   0,   0, 
     10, 128,  32,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
     54,   0,   0,   5,  34,   0, 
     16,   0,   1,   0,   0,   0, 
     26,  16,  16,   0,   1,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   1,   0, 
      0,   0,  70,   0,  16,   0, 
      1,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  50,   0,   0,  10, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  10, 128,  32,   0, 
      0,   0,   0,   0,   8,   0, 
      0,   0,  58,   0,  16,   0, 
      1,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
     56,   0,   0,   8, 242,  32, 
     16,   0,   0,   0,   0,   0, 
      6,   0,  16,   0,   0,   0, 
      0,   0,  70, 142,  32,   0, 
      0,   0,   0,   0,   9,   0, 
      0,   0,  62,   0,   0,   1, 
     83,  84,  65,  84, 116,   0, 
      0,   0,  30,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
      5,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   9,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      9,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  82,  68, 
     69,  70, 184,   1,   0,   0, 
      1,   0,   0,   0, 148,   0, 
      0,   0,   3,   0,   0,   0, 
     28,   0,   0,   0,   0,   4, 
    255, 255,   0,   1,   0,   0, 
    132,   1,   0,   0, 124,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    139,   0,   0,   0,   2,   0, 
      0,   0,   5,   0,   0,   0, 
      4,   0,   0,   0, 255, 255, 
    255, 255,   0,   0,   0,   0, 
      1,   0,   0,   0,  12,   0, 
      0,   0, 143,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 115,  83, 
    104,  97, 100, 111, 119,  83, 
     97, 109, 112, 108, 101, 114, 
      0, 116, 101, 120,   0,  99, 
     98,  49,   0, 171, 143,   0, 
      0,   0,   4,   0,   0,   0, 
    172,   0,   0,   0, 160,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  12,   1, 
      0,   0,   0,   0,   0,   0, 
     48,   0,   0,   0,   2,   0, 
      0,   0,  28,   1,   0,   0, 
      0,   0,   0,   0,  44,   1, 
      0,   0,  48,   0,   0,   0, 
     48,   0,   0,   0,   0,   0, 
      0,   0,  60,   1,   0,   0, 
      0,   0,   0,   0,  76,   1, 
      0,   0,  96,   0,   0,   0, 
     48,   0,   0,   0,   2,   0, 
      0,   0,  88,   1,   0,   0, 
      0,   0,   0,   0, 104,   1, 
      0,   0, 144,   0,   0,   0, 
     16,   0,   0,   0,   2,   0, 
      0,   0, 116,   1,   0,   0, 
      0,   0,   0,   0,  66, 108, 
    117, 114,  79, 102, 102, 115, 
    101, 116, 115,  72,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   4,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     66, 108, 117, 114,  79, 102, 
    102, 115, 101, 116, 115,  86, 
      0, 171, 171, 171,   1,   0, 
      3,   0,   1,   0,   4,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  66, 108, 117, 114, 
     87, 101, 105, 103, 104, 116, 
    115,   0,   1,   0,   3,   0, 
      1,   0,   4,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     83, 104,  97, 100, 111, 119, 
     67, 111, 108, 111, 114,   0, 
      1,   0,   3,   0,   1,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  77, 105, 
     99, 114, 111, 115, 111, 102, 
    116,  32,  40,  82,  41,  32, 
     72,  76,  83,  76,  32,  83, 
    104,  97, 100, 101, 114,  32, 
     67, 111, 109, 112, 105, 108, 
    101, 114,  32,  57,  46,  50, 
     57,  46,  57,  53,  50,  46, 
     51,  49,  49,  49,   0, 171, 
    171, 171,  73,  83,  71,  78, 
    104,   0,   0,   0,   3,   0, 
      0,   0,   8,   0,   0,   0, 
     80,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  15,   0,   0,   0, 
     92,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,   3,   3,   0,   0, 
     92,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,  12,   0,   0,   0, 
     83,  86,  95,  80, 111, 115, 
    105, 116, 105, 111, 110,   0, 
     84,  69,  88,  67,  79,  79, 
     82,  68,   0, 171, 171, 171, 
     79,  83,  71,  78,  44,   0, 
      0,   0,   1,   0,   0,   0, 
      8,   0,   0,   0,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  83,  86, 
     95,  84,  97, 114, 103, 101, 
    116,   0, 171, 171, 148, 121, 
      0,   0,   0,   0,   0,   0, 
     80,  49,   0,   4,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0, 128,  63,   1,   0,   0, 
      0,   0,   0, 128,  63,   1, 
      0,   0,   0,   0,   0, 128, 
     63,   1,   0,   0,   0,   0, 
      0, 128,  63,   1,   0,   0, 
      0,   3,   0,   0,   0, 255, 
    255, 255, 255,  68,   4,   0, 
      0,  68,  88,  66,  67,  26, 
    214, 157, 140, 185,  91, 182, 
    211, 177, 171, 114, 225, 174, 
    107,  56, 117,   1,   0,   0, 
      0,  68,   4,   0,   0,   6, 
      0,   0,   0,  56,   0,   0, 
      0, 248,   0,   0,   0, 244, 
      1,   0,   0, 112,   2,   0, 
      0, 160,   3,   0,   0, 212, 
      3,   0,   0,  65, 111, 110, 
     57, 184,   0,   0,   0, 184, 
      0,   0,   0,   0,   2, 254, 
    255, 132,   0,   0,   0,  52, 
      0,   0,   0,   1,   0,  36, 
      0,   0,   0,  48,   0,   0, 
      0,  48,   0,   0,   0,  36, 
      0,   1,   0,  48,   0,   0, 
      0,   0,   0,   3,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   2, 254, 
    255,  81,   0,   0,   5,   4, 
      0,  15, 160,   0,   0,   0, 
      0,   0,   0, 128,  63,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  31,   0,   0,   2,   5, 
      0,   0, 128,   0,   0,  15, 
    144,   4,   0,   0,   4,   0, 
      0,   3, 224,   0,   0, 228, 
    144,   2,   0, 238, 160,   2, 
      0, 228, 160,   4,   0,   0, 
      4,   0,   0,  12, 224,   0, 
      0,  20, 144,   3,   0, 180, 
    160,   3,   0,  20, 160,   4, 
      0,   0,   4,   0,   0,   3, 
    128,   0,   0, 228, 144,   1, 
      0, 238, 160,   1,   0, 228, 
    160,   2,   0,   0,   3,   0, 
      0,   3, 192,   0,   0, 228, 
    128,   0,   0, 228, 160,   1, 
      0,   0,   2,   0,   0,  12, 
    192,   4,   0,  68, 160, 255, 
    255,   0,   0,  83,  72,  68, 
     82, 244,   0,   0,   0,  64, 
      0,   1,   0,  61,   0,   0, 
      0,  89,   0,   0,   4,  70, 
    142,  32,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,  95, 
      0,   0,   3,  50,  16,  16, 
      0,   0,   0,   0,   0, 103, 
      0,   0,   4, 242,  32,  16, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0, 101,   0,   0, 
      3,  50,  32,  16,   0,   1, 
      0,   0,   0, 101,   0,   0, 
      3, 194,  32,  16,   0,   1, 
      0,   0,   0,  50,   0,   0, 
     11,  50,  32,  16,   0,   0, 
      0,   0,   0,  70,  16,  16, 
      0,   0,   0,   0,   0, 230, 
    138,  32,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  70, 
    128,  32,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   8, 194,  32,  16, 
      0,   0,   0,   0,   0,   2, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 128, 
     63,  50,   0,   0,  11,  50, 
     32,  16,   0,   1,   0,   0, 
      0,  70,  16,  16,   0,   0, 
      0,   0,   0, 230, 138,  32, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,  70, 128,  32, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,  50,   0,   0, 
     11, 194,  32,  16,   0,   1, 
      0,   0,   0,   6,  20,  16, 
      0,   0,   0,   0,   0, 166, 
    142,  32,   0,   0,   0,   0, 
      0,   2,   0,   0,   0,   6, 
    132,  32,   0,   0,   0,   0, 
      0,   2,   0,   0,   0,  62, 
      0,   0,   1,  83,  84,  65, 
     84, 116,   0,   0,   0,   5, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  82,  68,  69,  70,  40, 
      1,   0,   0,   1,   0,   0, 
      0,  64,   0,   0,   0,   1, 
      0,   0,   0,  28,   0,   0, 
      0,   0,   4, 254, 255,   0, 
      1,   0,   0, 246,   0,   0, 
      0,  60,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,  99,  98,  48, 
      0,  60,   0,   0,   0,   4, 
      0,   0,   0,  88,   0,   0, 
      0,  64,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 184,   0,   0,   0,   0, 
      0,   0,   0,  16,   0,   0, 
      0,   2,   0,   0,   0, 196, 
      0,   0,   0,   0,   0,   0, 
      0, 212,   0,   0,   0,  16, 
      0,   0,   0,  16,   0,   0, 
      0,   2,   0,   0,   0, 196, 
      0,   0,   0,   0,   0,   0, 
      0, 222,   0,   0,   0,  32, 
      0,   0,   0,  16,   0,   0, 
      0,   2,   0,   0,   0, 196, 
      0,   0,   0,   0,   0,   0, 
      0, 236,   0,   0,   0,  48, 
      0,   0,   0,  16,   0,   0, 
      0,   0,   0,   0,   0, 196, 
      0,   0,   0,   0,   0,   0, 
      0,  81, 117,  97, 100,  68, 
    101, 115,  99,   0, 171, 171, 
    171,   1,   0,   3,   0,   1, 
      0,   4,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  84, 
    101, 120,  67, 111, 111, 114, 
    100, 115,   0,  77,  97, 115, 
    107,  84, 101, 120,  67, 111, 
    111, 114, 100, 115,   0,  84, 
    101, 120, 116,  67, 111, 108, 
    111, 114,   0,  77, 105,  99, 
    114, 111, 115, 111, 102, 116, 
     32,  40,  82,  41,  32,  72, 
     76,  83,  76,  32,  83, 104, 
     97, 100, 101, 114,  32,  67, 
    111, 109, 112, 105, 108, 101, 
    114,  32,  57,  46,  50,  57, 
     46,  57,  53,  50,  46,  51, 
     49,  49,  49,   0, 171,  73, 
     83,  71,  78,  44,   0,   0, 
      0,   1,   0,   0,   0,   8, 
      0,   0,   0,  32,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   7, 
      3,   0,   0,  80,  79,  83, 
     73,  84,  73,  79,  78,   0, 
    171, 171, 171,  79,  83,  71, 
     78, 104,   0,   0,   0,   3, 
      0,   0,   0,   8,   0,   0, 
      0,  80,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,  15,   0,   0, 
      0,  92,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   1, 
      0,   0,   0,   3,  12,   0, 
      0,  92,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   1, 
      0,   0,   0,  12,   3,   0, 
      0,  83,  86,  95,  80, 111, 
    115, 105, 116, 105, 111, 110, 
      0,  84,  69,  88,  67,  79, 
     79,  82,  68,   0, 171, 171, 
    171, 187, 131,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0, 172,   9,   0, 
      0,  68,  88,  66,  67, 110, 
     68, 159, 211, 251, 173, 118, 
     80, 154, 213, 185, 171, 243, 
     23, 113, 100,   1,   0,   0, 
      0, 172,   9,   0,   0,   6, 
      0,   0,   0,  56,   0,   0, 
      0, 220,   2,   0,   0, 204, 
      6,   0,   0,  72,   7,   0, 
      0,   8,   9,   0,   0, 120, 
      9,   0,   0,  65, 111, 110, 
     57, 156,   2,   0,   0, 156, 
      2,   0,   0,   0,   2, 255, 
    255, 104,   2,   0,   0,  52, 
      0,   0,   0,   1,   0,  40, 
      0,   0,   0,  52,   0,   0, 
      0,  52,   0,   1,   0,  36, 
      0,   0,   0,  52,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   6,   0,   0,   0,   0, 
      0,   0,   0,   1,   2, 255, 
    255,  31,   0,   0,   2,   0, 
      0,   0, 128,   0,   0,  15, 
    176,  31,   0,   0,   2,   0, 
      0,   0, 144,   0,   8,  15, 
    160,   2,   0,   0,   3,   0, 
      0,   2, 128,   0,   0,  85, 
    176,   0,   0,  85, 160,   1, 
      0,   0,   2,   0,   0,   1, 
    128,   0,   0,   0, 176,   2, 
      0,   0,   3,   1,   0,   2, 
    128,   0,   0,  85, 176,   0, 
      0,   0, 160,   1,   0,   0, 
      2,   1,   0,   1, 128,   0, 
      0,   0, 176,  66,   0,   0, 
      3,   0,   0,  15, 128,   0, 
      0, 228, 128,   0,   8, 228, 
    160,  66,   0,   0,   3,   1, 
      0,  15, 128,   1,   0, 228, 
    128,   0,   8, 228, 160,   5, 
      0,   0,   3,   0,   0,  15, 
    128,   0,   0, 228, 128,   3, 
      0,  85, 160,   4,   0,   0, 
      4,   0,   0,  15, 128,   3, 
      0,   0, 160,   1,   0, 228, 
    128,   0,   0, 228, 128,   2, 
      0,   0,   3,   1,   0,   2, 
    128,   0,   0,  85, 176,   0, 
      0, 170, 160,   1,   0,   0, 
      2,   1,   0,   1, 128,   0, 
      0,   0, 176,   2,   0,   0, 
      3,   2,   0,   2, 128,   0, 
      0,  85, 176,   0,   0, 255, 
    160,   1,   0,   0,   2,   2, 
      0,   1, 128,   0,   0,   0, 
    176,  66,   0,   0,   3,   1, 
      0,  15, 128,   1,   0, 228, 
    128,   0,   8, 228, 160,  66, 
      0,   0,   3,   2,   0,  15, 
    128,   2,   0, 228, 128,   0, 
      8, 228, 160,   4,   0,   0, 
      4,   0,   0,  15, 128,   3, 
      0, 170, 160,   1,   0, 228, 
    128,   0,   0, 228, 128,   4, 
      0,   0,   4,   0,   0,  15, 
    128,   3,   0, 255, 160,   2, 
      0, 228, 128,   0,   0, 228, 
    128,   2,   0,   0,   3,   1, 
      0,   2, 128,   0,   0,  85, 
    176,   1,   0,   0, 160,   1, 
      0,   0,   2,   1,   0,   1, 
    128,   0,   0,   0, 176,   2, 
      0,   0,   3,   2,   0,   2, 
    128,   0,   0,  85, 176,   1, 
      0,  85, 160,   1,   0,   0, 
      2,   2,   0,   1, 128,   0, 
      0,   0, 176,  66,   0,   0, 
      3,   1,   0,  15, 128,   1, 
      0, 228, 128,   0,   8, 228, 
    160,  66,   0,   0,   3,   2, 
      0,  15, 128,   2,   0, 228, 
    128,   0,   8, 228, 160,   4, 
      0,   0,   4,   0,   0,  15, 
    128,   4,   0,   0, 160,   1, 
      0, 228, 128,   0,   0, 228, 
    128,   4,   0,   0,   4,   0, 
      0,  15, 128,   4,   0,  85, 
    160,   2,   0, 228, 128,   0, 
      0, 228, 128,   2,   0,   0, 
      3,   1,   0,   2, 128,   0, 
      0,  85, 176,   1,   0, 170, 
    160,   1,   0,   0,   2,   1, 
      0,   1, 128,   0,   0,   0, 
    176,   2,   0,   0,   3,   2, 
      0,   2, 128,   0,   0,  85, 
    176,   1,   0, 255, 160,   1, 
      0,   0,   2,   2,   0,   1, 
    128,   0,   0,   0, 176,  66, 
      0,   0,   3,   1,   0,  15, 
    128,   1,   0, 228, 128,   0, 
      8, 228, 160,  66,   0,   0, 
      3,   2,   0,  15, 128,   2, 
      0, 228, 128,   0,   8, 228, 
    160,   4,   0,   0,   4,   0, 
      0,  15, 128,   4,   0, 170, 
    160,   1,   0, 228, 128,   0, 
      0, 228, 128,   4,   0,   0, 
      4,   0,   0,  15, 128,   4, 
      0, 255, 160,   2,   0, 228, 
    128,   0,   0, 228, 128,   2, 
      0,   0,   3,   1,   0,   2, 
    128,   0,   0,  85, 176,   2, 
      0,   0, 160,   1,   0,   0, 
      2,   1,   0,   1, 128,   0, 
      0,   0, 176,  66,   0,   0, 
      3,   1,   0,  15, 128,   1, 
      0, 228, 128,   0,   8, 228, 
    160,   4,   0,   0,   4,   0, 
      0,  15, 128,   5,   0,   0, 
    160,   1,   0, 228, 128,   0, 
      0, 228, 128,   1,   0,   0, 
      2,   0,   8,  15, 128,   0, 
      0, 228, 128, 255, 255,   0, 
      0,  83,  72,  68,  82, 232, 
      3,   0,   0,  64,   0,   0, 
      0, 250,   0,   0,   0,  89, 
      0,   0,   4,  70, 142,  32, 
      0,   0,   0,   0,   0,   9, 
      0,   0,   0,  90,   0,   0, 
      3,   0,  96,  16,   0,   0, 
      0,   0,   0,  88,  24,   0, 
      4,   0, 112,  16,   0,   0, 
      0,   0,   0,  85,  85,   0, 
      0,  98,  16,   0,   3,  50, 
     16,  16,   0,   1,   0,   0, 
      0, 101,   0,   0,   3, 242, 
     32,  16,   0,   0,   0,   0, 
      0, 104,   0,   0,   2,   4, 
      0,   0,   0,  54,   0,   0, 
      5,  82,   0,  16,   0,   0, 
      0,   0,   0,   6,  16,  16, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   8, 242,   0,  16, 
      0,   1,   0,   0,   0,  86, 
     21,  16,   0,   1,   0,   0, 
      0, 134, 141,  32,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,  54,   0,   0,   5, 162, 
      0,  16,   0,   0,   0,   0, 
      0,   6,   8,  16,   0,   1, 
      0,   0,   0,  69,   0,   0, 
      9, 242,   0,  16,   0,   2, 
      0,   0,   0, 230,  10,  16, 
      0,   0,   0,   0,   0,  70, 
    126,  16,   0,   0,   0,   0, 
      0,   0,  96,  16,   0,   0, 
      0,   0,   0,  69,   0,   0, 
      9, 242,   0,  16,   0,   0, 
      0,   0,   0,  70,   0,  16, 
      0,   0,   0,   0,   0,  70, 
    126,  16,   0,   0,   0,   0, 
      0,   0,  96,  16,   0,   0, 
      0,   0,   0,  56,   0,   0, 
      8, 242,   0,  16,   0,   2, 
      0,   0,   0,  70,  14,  16, 
      0,   2,   0,   0,   0,  86, 
    133,  32,   0,   0,   0,   0, 
      0,   6,   0,   0,   0,  50, 
      0,   0,  10, 242,   0,  16, 
      0,   0,   0,   0,   0,   6, 
    128,  32,   0,   0,   0,   0, 
      0,   6,   0,   0,   0,  70, 
     14,  16,   0,   0,   0,   0, 
      0,  70,  14,  16,   0,   2, 
      0,   0,   0,  54,   0,   0, 
      5,  82,   0,  16,   0,   1, 
      0,   0,   0,   6,  16,  16, 
      0,   1,   0,   0,   0,  69, 
      0,   0,   9, 242,   0,  16, 
      0,   2,   0,   0,   0,  70, 
      0,  16,   0,   1,   0,   0, 
      0,  70, 126,  16,   0,   0, 
      0,   0,   0,   0,  96,  16, 
      0,   0,   0,   0,   0,  69, 
      0,   0,   9, 242,   0,  16, 
      0,   1,   0,   0,   0, 230, 
     10,  16,   0,   1,   0,   0, 
      0,  70, 126,  16,   0,   0, 
      0,   0,   0,   0,  96,  16, 
      0,   0,   0,   0,   0,  50, 
      0,   0,  10, 242,   0,  16, 
      0,   0,   0,   0,   0, 166, 
    138,  32,   0,   0,   0,   0, 
      0,   6,   0,   0,   0,  70, 
     14,  16,   0,   2,   0,   0, 
      0,  70,  14,  16,   0,   0, 
      0,   0,   0,  50,   0,   0, 
     10, 242,   0,  16,   0,   0, 
      0,   0,   0, 246, 143,  32, 
      0,   0,   0,   0,   0,   6, 
      0,   0,   0,  70,  14,  16, 
      0,   1,   0,   0,   0,  70, 
     14,  16,   0,   0,   0,   0, 
      0,  54,   0,   0,   5,  82, 
      0,  16,   0,   1,   0,   0, 
      0,   6,  16,  16,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      8, 242,   0,  16,   0,   2, 
      0,   0,   0,  86,  21,  16, 
      0,   1,   0,   0,   0, 134, 
    141,  32,   0,   0,   0,   0, 
      0,   4,   0,   0,   0,  54, 
      0,   0,   5, 162,   0,  16, 
      0,   1,   0,   0,   0,   6, 
      8,  16,   0,   2,   0,   0, 
      0,  69,   0,   0,   9, 242, 
      0,  16,   0,   3,   0,   0, 
      0,  70,   0,  16,   0,   1, 
      0,   0,   0,  70, 126,  16, 
      0,   0,   0,   0,   0,   0, 
     96,  16,   0,   0,   0,   0, 
      0,  69,   0,   0,   9, 242, 
      0,  16,   0,   1,   0,   0, 
      0, 230,  10,  16,   0,   1, 
      0,   0,   0,  70, 126,  16, 
      0,   0,   0,   0,   0,   0, 
     96,  16,   0,   0,   0,   0, 
      0,  50,   0,   0,  10, 242, 
      0,  16,   0,   0,   0,   0, 
      0,   6, 128,  32,   0,   0, 
      0,   0,   0,   7,   0,   0, 
      0,  70,  14,  16,   0,   3, 
      0,   0,   0,  70,  14,  16, 
      0,   0,   0,   0,   0,  50, 
      0,   0,  10, 242,   0,  16, 
      0,   0,   0,   0,   0,  86, 
    133,  32,   0,   0,   0,   0, 
      0,   7,   0,   0,   0,  70, 
     14,  16,   0,   1,   0,   0, 
      0,  70,  14,  16,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      5,  82,   0,  16,   0,   2, 
      0,   0,   0,   6,  16,  16, 
      0,   1,   0,   0,   0,  69, 
      0,   0,   9, 242,   0,  16, 
      0,   1,   0,   0,   0,  70, 
      0,  16,   0,   2,   0,   0, 
      0,  70, 126,  16,   0,   0, 
      0,   0,   0,   0,  96,  16, 
      0,   0,   0,   0,   0,  69, 
      0,   0,   9, 242,   0,  16, 
      0,   2,   0,   0,   0, 230, 
     10,  16,   0,   2,   0,   0, 
      0,  70, 126,  16,   0,   0, 
      0,   0,   0,   0,  96,  16, 
      0,   0,   0,   0,   0,  50, 
      0,   0,  10, 242,   0,  16, 
      0,   0,   0,   0,   0, 166, 
    138,  32,   0,   0,   0,   0, 
      0,   7,   0,   0,   0,  70, 
     14,  16,   0,   1,   0,   0, 
      0,  70,  14,  16,   0,   0, 
      0,   0,   0,  50,   0,   0, 
     10, 242,   0,  16,   0,   0, 
      0,   0,   0, 246, 143,  32, 
      0,   0,   0,   0,   0,   7, 
      0,   0,   0,  70,  14,  16, 
      0,   2,   0,   0,   0,  70, 
     14,  16,   0,   0,   0,   0, 
      0,   0,   0,   0,   8,  34, 
      0,  16,   0,   1,   0,   0, 
      0,  26,  16,  16,   0,   1, 
      0,   0,   0,  10, 128,  32, 
      0,   0,   0,   0,   0,   5, 
      0,   0,   0,  54,   0,   0, 
      5,  18,   0,  16,   0,   1, 
      0,   0,   0,  10,  16,  16, 
      0,   1,   0,   0,   0,  69, 
      0,   0,   9, 242,   0,  16, 
      0,   1,   0,   0,   0,  70, 
      0,  16,   0,   1,   0,   0, 
      0,  70, 126,  16,   0,   0, 
      0,   0,   0,   0,  96,  16, 
      0,   0,   0,   0,   0,  50, 
      0,   0,  10, 242,  32,  16, 
      0,   0,   0,   0,   0,   6, 
    128,  32,   0,   0,   0,   0, 
      0,   8,   0,   0,   0,  70, 
     14,  16,   0,   1,   0,   0, 
      0,  70,  14,  16,   0,   0, 
      0,   0,   0,  62,   0,   0, 
      1,  83,  84,  65,  84, 116, 
      0,   0,   0,  29,   0,   0, 
      0,   4,   0,   0,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,   4,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   9, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   9,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  82, 
     68,  69,  70, 184,   1,   0, 
      0,   1,   0,   0,   0, 148, 
      0,   0,   0,   3,   0,   0, 
      0,  28,   0,   0,   0,   0, 
      4, 255, 255,   0,   1,   0, 
      0, 132,   1,   0,   0, 124, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0, 139,   0,   0,   0,   2, 
      0,   0,   0,   5,   0,   0, 
      0,   4,   0,   0,   0, 255, 
    255, 255, 255,   0,   0,   0, 
      0,   1,   0,   0,   0,  12, 
      0,   0,   0, 143,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0, 115, 
     83, 104,  97, 100, 111, 119, 
     83,  97, 109, 112, 108, 101, 
    114,   0, 116, 101, 120,   0, 
     99,  98,  49,   0, 171, 143, 
      0,   0,   0,   4,   0,   0, 
      0, 172,   0,   0,   0, 160, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  12, 
      1,   0,   0,   0,   0,   0, 
      0,  48,   0,   0,   0,   0, 
      0,   0,   0,  28,   1,   0, 
      0,   0,   0,   0,   0,  44, 
      1,   0,   0,  48,   0,   0, 
      0,  48,   0,   0,   0,   2, 
      0,   0,   0,  60,   1,   0, 
      0,   0,   0,   0,   0,  76, 
      1,   0,   0,  96,   0,   0, 
      0,  48,   0,   0,   0,   2, 
      0,   0,   0,  88,   1,   0, 
      0,   0,   0,   0,   0, 104, 
      1,   0,   0, 144,   0,   0, 
      0,  16,   0,   0,   0,   0, 
      0,   0,   0, 116,   1,   0, 
      0,   0,   0,   0,   0,  66, 
    108, 117, 114,  79, 102, 102, 
    115, 101, 116, 115,  72,   0, 
    171, 171, 171,   1,   0,   3, 
      0,   1,   0,   4,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  66, 108, 117, 114,  79, 
    102, 102, 115, 101, 116, 115, 
     86,   0, 171, 171, 171,   1, 
      0,   3,   0,   1,   0,   4, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,  66, 108, 117, 
    114,  87, 101, 105, 103, 104, 
    116, 115,   0,   1,   0,   3, 
      0,   1,   0,   4,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  83, 104,  97, 100, 111, 
    119,  67, 111, 108, 111, 114, 
      0,   1,   0,   3,   0,   1, 
      0,   4,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  77, 
    105,  99, 114, 111, 115, 111, 
    102, 116,  32,  40,  82,  41, 
     32,  72,  76,  83,  76,  32, 
     83, 104,  97, 100, 101, 114, 
     32,  67, 111, 109, 112, 105, 
    108, 101, 114,  32,  57,  46, 
     50,  57,  46,  57,  53,  50, 
     46,  51,  49,  49,  49,   0, 
    171, 171, 171,  73,  83,  71, 
     78, 104,   0,   0,   0,   3, 
      0,   0,   0,   8,   0,   0, 
      0,  80,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,  15,   0,   0, 
      0,  92,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   1, 
      0,   0,   0,   3,   3,   0, 
      0,  92,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   1, 
      0,   0,   0,  12,   0,   0, 
      0,  83,  86,  95,  80, 111, 
    115, 105, 116, 105, 111, 110, 
      0,  84,  69,  88,  67,  79, 
     79,  82,  68,   0, 171, 171, 
    171,  79,  83,  71,  78,  44, 
      0,   0,   0,   1,   0,   0, 
      0,   8,   0,   0,   0,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  15,   0,   0,   0,  83, 
     86,  95,  84,  97, 114, 103, 
    101, 116,   0, 171, 171,  23, 
    136,   0,   0,   0,   0,   0, 
      0,  80,  50,   0,   4,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0, 128,  63,   1,   0, 
      0,   0,   0,   0, 128,  63, 
      1,   0,   0,   0,   0,   0, 
    128,  63,   1,   0,   0,   0, 
      0,   0, 128,  63,   1,   0, 
      0,   0,   3,   0,   0,   0, 
    255, 255, 255, 255,  68,   4, 
      0,   0,  68,  88,  66,  67, 
     26, 214, 157, 140, 185,  91, 
    182, 211, 177, 171, 114, 225, 
    174, 107,  56, 117,   1,   0, 
      0,   0,  68,   4,   0,   0, 
      6,   0,   0,   0,  56,   0, 
      0,   0, 248,   0,   0,   0, 
    244,   1,   0,   0, 112,   2, 
      0,   0, 160,   3,   0,   0, 
    212,   3,   0,   0,  65, 111, 
    110,  57, 184,   0,   0,   0, 
    184,   0,   0,   0,   0,   2, 
    254, 255, 132,   0,   0,   0, 
     52,   0,   0,   0,   1,   0, 
     36,   0,   0,   0,  48,   0, 
      0,   0,  48,   0,   0,   0, 
     36,   0,   1,   0,  48,   0, 
      0,   0,   0,   0,   3,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   2, 
    254, 255,  81,   0,   0,   5, 
      4,   0,  15, 160,   0,   0, 
      0,   0,   0,   0, 128,  63, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  31,   0,   0,   2, 
      5,   0,   0, 128,   0,   0, 
     15, 144,   4,   0,   0,   4, 
      0,   0,   3, 224,   0,   0, 
    228, 144,   2,   0, 238, 160, 
      2,   0, 228, 160,   4,   0, 
      0,   4,   0,   0,  12, 224, 
      0,   0,  20, 144,   3,   0, 
    180, 160,   3,   0,  20, 160, 
      4,   0,   0,   4,   0,   0, 
      3, 128,   0,   0, 228, 144, 
      1,   0, 238, 160,   1,   0, 
    228, 160,   2,   0,   0,   3, 
      0,   0,   3, 192,   0,   0, 
    228, 128,   0,   0, 228, 160, 
      1,   0,   0,   2,   0,   0, 
     12, 192,   4,   0,  68, 160, 
    255, 255,   0,   0,  83,  72, 
     68,  82, 244,   0,   0,   0, 
     64,   0,   1,   0,  61,   0, 
      0,   0,  89,   0,   0,   4, 
     70, 142,  32,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
     95,   0,   0,   3,  50,  16, 
     16,   0,   0,   0,   0,   0, 
    103,   0,   0,   4, 242,  32, 
     16,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3,  50,  32,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 194,  32,  16,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  11,  50,  32,  16,   0, 
      0,   0,   0,   0,  70,  16, 
     16,   0,   0,   0,   0,   0, 
    230, 138,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     70, 128,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     54,   0,   0,   8, 194,  32, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    128,  63,  50,   0,   0,  11, 
     50,  32,  16,   0,   1,   0, 
      0,   0,  70,  16,  16,   0, 
      0,   0,   0,   0, 230, 138, 
     32,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  70, 128, 
     32,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  11, 194,  32,  16,   0, 
      1,   0,   0,   0,   6,  20, 
     16,   0,   0,   0,   0,   0, 
    166, 142,  32,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
      6, 132,  32,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
     62,   0,   0,   1,  83,  84, 
     65,  84, 116,   0,   0,   0, 
      5,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  82,  68,  69,  70, 
     40,   1,   0,   0,   1,   0, 
      0,   0,  64,   0,   0,   0, 
      1,   0,   0,   0,  28,   0, 
      0,   0,   0,   4, 254, 255, 
      0,   1,   0,   0, 246,   0, 
      0,   0,  60,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,  99,  98, 
     48,   0,  60,   0,   0,   0, 
      4,   0,   0,   0,  88,   0, 
      0,   0,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 184,   0,   0,   0, 
      0,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0, 212,   0,   0,   0, 
     16,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0, 222,   0,   0,   0, 
     32,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0, 236,   0,   0,   0, 
     48,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0,  81, 117,  97, 100, 
     68, 101, 115,  99,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  77,  97, 
    115, 107,  84, 101, 120,  67, 
    111, 111, 114, 100, 115,   0, 
     84, 101, 120, 116,  67, 111, 
    108, 111, 114,   0,  77, 105, 
     99, 114, 111, 115, 111, 102, 
    116,  32,  40,  82,  41,  32, 
     72,  76,  83,  76,  32,  83, 
    104,  97, 100, 101, 114,  32, 
     67, 111, 109, 112, 105, 108, 
    101, 114,  32,  57,  46,  50, 
     57,  46,  57,  53,  50,  46, 
     51,  49,  49,  49,   0, 171, 
     73,  83,  71,  78,  44,   0, 
      0,   0,   1,   0,   0,   0, 
      8,   0,   0,   0,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   3,   0,   0,  80,  79, 
     83,  73,  84,  73,  79,  78, 
      0, 171, 171, 171,  79,  83, 
     71,  78, 104,   0,   0,   0, 
      3,   0,   0,   0,   8,   0, 
      0,   0,  80,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   3,  12, 
      0,   0,  92,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,  12,   3, 
      0,   0,  83,  86,  95,  80, 
    111, 115, 105, 116, 105, 111, 
    110,   0,  84,  69,  88,  67, 
     79,  79,  82,  68,   0, 171, 
    171, 171,   2, 146,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0, 164,  10, 
      0,   0,  68,  88,  66,  67, 
    143, 148, 190,  36,  41, 120, 
     46, 207, 200, 138, 139,  29, 
     38,  89, 245,  86,   1,   0, 
      0,   0, 164,  10,   0,   0, 
      6,   0,   0,   0,  56,   0, 
      0,   0,  24,   3,   0,   0, 
    112,   7,   0,   0, 236,   7, 
      0,   0,   0,  10,   0,   0, 
    112,  10,   0,   0,  65, 111, 
    110,  57, 216,   2,   0,   0, 
    216,   2,   0,   0,   0,   2, 
    255, 255, 160,   2,   0,   0, 
     56,   0,   0,   0,   1,   0, 
     44,   0,   0,   0,  56,   0, 
      0,   0,  56,   0,   2,   0, 
     36,   0,   0,   0,  56,   0, 
      1,   0,   0,   0,   0,   1, 
      1,   0,   0,   0,   3,   0, 
      6,   0,   0,   0,   0,   0, 
      0,   0,   1,   2, 255, 255, 
     31,   0,   0,   2,   0,   0, 
      0, 128,   0,   0,  15, 176, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   0,   8,  15, 160, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   1,   8,  15, 160, 
      2,   0,   0,   3,   0,   0, 
      2, 128,   0,   0,  85, 176, 
      0,   0,  85, 160,   1,   0, 
      0,   2,   0,   0,   1, 128, 
      0,   0,   0, 176,   2,   0, 
      0,   3,   1,   0,   2, 128, 
      0,   0,  85, 176,   0,   0, 
      0, 160,   1,   0,   0,   2, 
      1,   0,   1, 128,   0,   0, 
      0, 176,  66,   0,   0,   3, 
      0,   0,  15, 128,   0,   0, 
    228, 128,   1,   8, 228, 160, 
     66,   0,   0,   3,   1,   0, 
     15, 128,   1,   0, 228, 128, 
      1,   8, 228, 160,   5,   0, 
      0,   3,   0,   0,  15, 128, 
      0,   0, 228, 128,   3,   0, 
     85, 160,   4,   0,   0,   4, 
      0,   0,  15, 128,   3,   0, 
      0, 160,   1,   0, 228, 128, 
      0,   0, 228, 128,   2,   0, 
      0,   3,   1,   0,   2, 128, 
      0,   0,  85, 176,   0,   0, 
    170, 160,   1,   0,   0,   2, 
      1,   0,   1, 128,   0,   0, 
      0, 176,   2,   0,   0,   3, 
      2,   0,   2, 128,   0,   0, 
     85, 176,   0,   0, 255, 160, 
      1,   0,   0,   2,   2,   0, 
      1, 128,   0,   0,   0, 176, 
     66,   0,   0,   3,   1,   0, 
     15, 128,   1,   0, 228, 128, 
      1,   8, 228, 160,  66,   0, 
      0,   3,   2,   0,  15, 128, 
      2,   0, 228, 128,   1,   8, 
    228, 160,   4,   0,   0,   4, 
      0,   0,  15, 128,   3,   0, 
    170, 160,   1,   0, 228, 128, 
      0,   0, 228, 128,   4,   0, 
      0,   4,   0,   0,  15, 128, 
      3,   0, 255, 160,   2,   0, 
    228, 128,   0,   0, 228, 128, 
      2,   0,   0,   3,   1,   0, 
      2, 128,   0,   0,  85, 176, 
      1,   0,   0, 160,   1,   0, 
      0,   2,   1,   0,   1, 128, 
      0,   0,   0, 176,   2,   0, 
      0,   3,   2,   0,   2, 128, 
      0,   0,  85, 176,   1,   0, 
     85, 160,   1,   0,   0,   2, 
      2,   0,   1, 128,   0,   0, 
      0, 176,  66,   0,   0,   3, 
      1,   0,  15, 128,   1,   0, 
    228, 128,   1,   8, 228, 160, 
     66,   0,   0,   3,   2,   0, 
     15, 128,   2,   0, 228, 128, 
      1,   8, 228, 160,   4,   0, 
      0,   4,   0,   0,  15, 128, 
      4,   0,   0, 160,   1,   0, 
    228, 128,   0,   0, 228, 128, 
      4,   0,   0,   4,   0,   0, 
     15, 128,   4,   0,  85, 160, 
      2,   0, 228, 128,   0,   0, 
    228, 128,   2,   0,   0,   3, 
      1,   0,   2, 128,   0,   0, 
     85, 176,   1,   0, 170, 160, 
      1,   0,   0,   2,   1,   0, 
      1, 128,   0,   0,   0, 176, 
      2,   0,   0,   3,   2,   0, 
      2, 128,   0,   0,  85, 176, 
      1,   0, 255, 160,   1,   0, 
      0,   2,   2,   0,   1, 128, 
      0,   0,   0, 176,  66,   0, 
      0,   3,   1,   0,  15, 128, 
      1,   0, 228, 128,   1,   8, 
    228, 160,  66,   0,   0,   3, 
      2,   0,  15, 128,   2,   0, 
    228, 128,   1,   8, 228, 160, 
      4,   0,   0,   4,   0,   0, 
     15, 128,   4,   0, 170, 160, 
      1,   0, 228, 128,   0,   0, 
    228, 128,   4,   0,   0,   4, 
      0,   0,  15, 128,   4,   0, 
    255, 160,   2,   0, 228, 128, 
      0,   0, 228, 128,   2,   0, 
      0,   3,   1,   0,   2, 128, 
      0,   0,  85, 176,   2,   0, 
      0, 160,   1,   0,   0,   2, 
      1,   0,   1, 128,   0,   0, 
      0, 176,   1,   0,   0,   2, 
      2,   0,   3, 128,   0,   0, 
    235, 176,  66,   0,   0,   3, 
      1,   0,  15, 128,   1,   0, 
    228, 128,   1,   8, 228, 160, 
     66,   0,   0,   3,   2,   0, 
     15, 128,   2,   0, 228, 128, 
      0,   8, 228, 160,   4,   0, 
      0,   4,   0,   0,  15, 128, 
      5,   0,   0, 160,   1,   0, 
    228, 128,   0,   0, 228, 128, 
      5,   0,   0,   3,   0,   0, 
     15, 128,   2,   0, 255, 128, 
      0,   0, 228, 128,   1,   0, 
      0,   2,   0,   8,  15, 128, 
      0,   0, 228, 128, 255, 255, 
      0,   0,  83,  72,  68,  82, 
     80,   4,   0,   0,  64,   0, 
      0,   0,  20,   1,   0,   0, 
     89,   0,   0,   4,  70, 142, 
     32,   0,   0,   0,   0,   0, 
      9,   0,   0,   0,  90,   0, 
      0,   3,   0,  96,  16,   0, 
      0,   0,   0,   0,  90,   0, 
      0,   3,   0,  96,  16,   0, 
      1,   0,   0,   0,  88,  24, 
      0,   4,   0, 112,  16,   0, 
      0,   0,   0,   0,  85,  85, 
      0,   0,  88,  24,   0,   4, 
      0, 112,  16,   0,   1,   0, 
      0,   0,  85,  85,   0,   0, 
     98,  16,   0,   3,  50,  16, 
     16,   0,   1,   0,   0,   0, 
     98,  16,   0,   3, 194,  16, 
     16,   0,   1,   0,   0,   0, 
    101,   0,   0,   3, 242,  32, 
     16,   0,   0,   0,   0,   0, 
    104,   0,   0,   2,   4,   0, 
      0,   0,  54,   0,   0,   5, 
     82,   0,  16,   0,   0,   0, 
      0,   0,   6,  16,  16,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   8, 242,   0,  16,   0, 
      1,   0,   0,   0,  86,  21, 
     16,   0,   1,   0,   0,   0, 
    134, 141,  32,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
     54,   0,   0,   5, 162,   0, 
     16,   0,   0,   0,   0,   0, 
      6,   8,  16,   0,   1,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   2,   0, 
      0,   0, 230,  10,  16,   0, 
      0,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   0,   0, 
      0,   0,  70,   0,  16,   0, 
      0,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  56,   0,   0,   8, 
    242,   0,  16,   0,   2,   0, 
      0,   0,  70,  14,  16,   0, 
      2,   0,   0,   0,  86, 133, 
     32,   0,   0,   0,   0,   0, 
      6,   0,   0,   0,  50,   0, 
      0,  10, 242,   0,  16,   0, 
      0,   0,   0,   0,   6, 128, 
     32,   0,   0,   0,   0,   0, 
      6,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
     70,  14,  16,   0,   2,   0, 
      0,   0,  54,   0,   0,   5, 
     82,   0,  16,   0,   1,   0, 
      0,   0,   6,  16,  16,   0, 
      1,   0,   0,   0,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      2,   0,   0,   0,  70,   0, 
     16,   0,   1,   0,   0,   0, 
     70, 126,  16,   0,   0,   0, 
      0,   0,   0,  96,  16,   0, 
      1,   0,   0,   0,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      1,   0,   0,   0, 230,  10, 
     16,   0,   1,   0,   0,   0, 
     70, 126,  16,   0,   0,   0, 
      0,   0,   0,  96,  16,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  10, 242,   0,  16,   0, 
      0,   0,   0,   0, 166, 138, 
     32,   0,   0,   0,   0,   0, 
      6,   0,   0,   0,  70,  14, 
     16,   0,   2,   0,   0,   0, 
     70,  14,  16,   0,   0,   0, 
      0,   0,  50,   0,   0,  10, 
    242,   0,  16,   0,   0,   0, 
      0,   0, 246, 143,  32,   0, 
      0,   0,   0,   0,   6,   0, 
      0,   0,  70,  14,  16,   0, 
      1,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
     54,   0,   0,   5,  82,   0, 
     16,   0,   1,   0,   0,   0, 
      6,  16,  16,   0,   1,   0, 
      0,   0,   0,   0,   0,   8, 
    242,   0,  16,   0,   2,   0, 
      0,   0,  86,  21,  16,   0, 
      1,   0,   0,   0, 134, 141, 
     32,   0,   0,   0,   0,   0, 
      4,   0,   0,   0,  54,   0, 
      0,   5, 162,   0,  16,   0, 
      1,   0,   0,   0,   6,   8, 
     16,   0,   2,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   3,   0,   0,   0, 
     70,   0,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   1,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   1,   0,   0,   0, 
    230,  10,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   1,   0,   0,   0, 
     50,   0,   0,  10, 242,   0, 
     16,   0,   0,   0,   0,   0, 
      6, 128,  32,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
     70,  14,  16,   0,   3,   0, 
      0,   0,  70,  14,  16,   0, 
      0,   0,   0,   0,  50,   0, 
      0,  10, 242,   0,  16,   0, 
      0,   0,   0,   0,  86, 133, 
     32,   0,   0,   0,   0,   0, 
      7,   0,   0,   0,  70,  14, 
     16,   0,   1,   0,   0,   0, 
     70,  14,  16,   0,   0,   0, 
      0,   0,  54,   0,   0,   5, 
     82,   0,  16,   0,   2,   0, 
      0,   0,   6,  16,  16,   0, 
      1,   0,   0,   0,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      1,   0,   0,   0,  70,   0, 
     16,   0,   2,   0,   0,   0, 
     70, 126,  16,   0,   0,   0, 
      0,   0,   0,  96,  16,   0, 
      1,   0,   0,   0,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      2,   0,   0,   0, 230,  10, 
     16,   0,   2,   0,   0,   0, 
     70, 126,  16,   0,   0,   0, 
      0,   0,   0,  96,  16,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  10, 242,   0,  16,   0, 
      0,   0,   0,   0, 166, 138, 
     32,   0,   0,   0,   0,   0, 
      7,   0,   0,   0,  70,  14, 
     16,   0,   1,   0,   0,   0, 
     70,  14,  16,   0,   0,   0, 
      0,   0,  50,   0,   0,  10, 
    242,   0,  16,   0,   0,   0, 
      0,   0, 246, 143,  32,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0,  70,  14,  16,   0, 
      2,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
      0,   0,   0,   8,  34,   0, 
     16,   0,   1,   0,   0,   0, 
     26,  16,  16,   0,   1,   0, 
      0,   0,  10, 128,  32,   0, 
      0,   0,   0,   0,   5,   0, 
      0,   0,  54,   0,   0,   5, 
     18,   0,  16,   0,   1,   0, 
      0,   0,  10,  16,  16,   0, 
      1,   0,   0,   0,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      1,   0,   0,   0,  70,   0, 
     16,   0,   1,   0,   0,   0, 
     70, 126,  16,   0,   0,   0, 
      0,   0,   0,  96,  16,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  10, 242,   0,  16,   0, 
      0,   0,   0,   0,   6, 128, 
     32,   0,   0,   0,   0,   0, 
      8,   0,   0,   0,  70,  14, 
     16,   0,   1,   0,   0,   0, 
     70,  14,  16,   0,   0,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   1,   0, 
      0,   0, 230,  26,  16,   0, 
      1,   0,   0,   0,  70, 126, 
     16,   0,   1,   0,   0,   0, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  56,   0,   0,   7, 
    242,  32,  16,   0,   0,   0, 
      0,   0,  70,  14,  16,   0, 
      0,   0,   0,   0, 246,  15, 
     16,   0,   1,   0,   0,   0, 
     62,   0,   0,   1,  83,  84, 
     65,  84, 116,   0,   0,   0, 
     31,   0,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   5,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  10,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   9,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  82,  68,  69,  70, 
     12,   2,   0,   0,   1,   0, 
      0,   0, 232,   0,   0,   0, 
      5,   0,   0,   0,  28,   0, 
      0,   0,   0,   4, 255, 255, 
      0,   1,   0,   0, 216,   1, 
      0,   0, 188,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 201,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    216,   0,   0,   0,   2,   0, 
      0,   0,   5,   0,   0,   0, 
      4,   0,   0,   0, 255, 255, 
    255, 255,   0,   0,   0,   0, 
      1,   0,   0,   0,  12,   0, 
      0,   0, 220,   0,   0,   0, 
      2,   0,   0,   0,   5,   0, 
      0,   0,   4,   0,   0,   0, 
    255, 255, 255, 255,   1,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   0,   0,   0, 225,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    115,  77,  97, 115, 107,  83, 
     97, 109, 112, 108, 101, 114, 
      0, 115,  83, 104,  97, 100, 
    111, 119,  83,  97, 109, 112, 
    108, 101, 114,   0, 116, 101, 
    120,   0, 109,  97, 115, 107, 
      0,  99,  98,  49,   0, 171, 
    171, 171, 225,   0,   0,   0, 
      4,   0,   0,   0,   0,   1, 
      0,   0, 160,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  96,   1,   0,   0, 
      0,   0,   0,   0,  48,   0, 
      0,   0,   0,   0,   0,   0, 
    112,   1,   0,   0,   0,   0, 
      0,   0, 128,   1,   0,   0, 
     48,   0,   0,   0,  48,   0, 
      0,   0,   2,   0,   0,   0, 
    144,   1,   0,   0,   0,   0, 
      0,   0, 160,   1,   0,   0, 
     96,   0,   0,   0,  48,   0, 
      0,   0,   2,   0,   0,   0, 
    172,   1,   0,   0,   0,   0, 
      0,   0, 188,   1,   0,   0, 
    144,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
    200,   1,   0,   0,   0,   0, 
      0,   0,  66, 108, 117, 114, 
     79, 102, 102, 115, 101, 116, 
    115,  72,   0, 171, 171, 171, 
      1,   0,   3,   0,   1,   0, 
      4,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  66, 108, 
    117, 114,  79, 102, 102, 115, 
    101, 116, 115,  86,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   4,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     66, 108, 117, 114,  87, 101, 
    105, 103, 104, 116, 115,   0, 
      1,   0,   3,   0,   1,   0, 
      4,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  83, 104, 
     97, 100, 111, 119,  67, 111, 
    108, 111, 114,   0,   1,   0, 
      3,   0,   1,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  77, 105,  99, 114, 
    111, 115, 111, 102, 116,  32, 
     40,  82,  41,  32,  72,  76, 
     83,  76,  32,  83, 104,  97, 
    100, 101, 114,  32,  67, 111, 
    109, 112, 105, 108, 101, 114, 
     32,  57,  46,  50,  57,  46, 
     57,  53,  50,  46,  51,  49, 
     49,  49,   0, 171, 171, 171, 
     73,  83,  71,  78, 104,   0, 
      0,   0,   3,   0,   0,   0, 
      8,   0,   0,   0,  80,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  92,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   3,   0,   0,  92,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
     12,  12,   0,   0,  83,  86, 
     95,  80, 111, 115, 105, 116, 
    105, 111, 110,   0,  84,  69, 
     88,  67,  79,  79,  82,  68, 
      0, 171, 171, 171,  79,  83, 
     71,  78,  44,   0,   0,   0, 
      1,   0,   0,   0,   8,   0, 
      0,   0,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  83,  86,  95,  84, 
     97, 114, 103, 101, 116,   0, 
    171, 171,  94, 150,   0,   0, 
      0,   0,   0,   0,  83,  97, 
    109, 112, 108, 101,  84, 101, 
    120, 116,  84, 101, 120, 116, 
    117, 114, 101,   0,  85, 110, 
    109,  97, 115, 107, 101, 100, 
      0,   4,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0, 255, 255, 255, 
    255,  68,   4,   0,   0,  68, 
     88,  66,  67,  26, 214, 157, 
    140, 185,  91, 182, 211, 177, 
    171, 114, 225, 174, 107,  56, 
    117,   1,   0,   0,   0,  68, 
      4,   0,   0,   6,   0,   0, 
      0,  56,   0,   0,   0, 248, 
      0,   0,   0, 244,   1,   0, 
      0, 112,   2,   0,   0, 160, 
      3,   0,   0, 212,   3,   0, 
      0,  65, 111, 110,  57, 184, 
      0,   0,   0, 184,   0,   0, 
      0,   0,   2, 254, 255, 132, 
      0,   0,   0,  52,   0,   0, 
      0,   1,   0,  36,   0,   0, 
      0,  48,   0,   0,   0,  48, 
      0,   0,   0,  36,   0,   1, 
      0,  48,   0,   0,   0,   0, 
      0,   3,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   2, 254, 255,  81, 
      0,   0,   5,   4,   0,  15, 
    160,   0,   0,   0,   0,   0, 
      0, 128,  63,   0,   0,   0, 
      0,   0,   0,   0,   0,  31, 
      0,   0,   2,   5,   0,   0, 
    128,   0,   0,  15, 144,   4, 
      0,   0,   4,   0,   0,   3, 
    224,   0,   0, 228, 144,   2, 
      0, 238, 160,   2,   0, 228, 
    160,   4,   0,   0,   4,   0, 
      0,  12, 224,   0,   0,  20, 
    144,   3,   0, 180, 160,   3, 
      0,  20, 160,   4,   0,   0, 
      4,   0,   0,   3, 128,   0, 
      0, 228, 144,   1,   0, 238, 
    160,   1,   0, 228, 160,   2, 
      0,   0,   3,   0,   0,   3, 
    192,   0,   0, 228, 128,   0, 
      0, 228, 160,   1,   0,   0, 
      2,   0,   0,  12, 192,   4, 
      0,  68, 160, 255, 255,   0, 
      0,  83,  72,  68,  82, 244, 
      0,   0,   0,  64,   0,   1, 
      0,  61,   0,   0,   0,  89, 
      0,   0,   4,  70, 142,  32, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,  95,   0,   0, 
      3,  50,  16,  16,   0,   0, 
      0,   0,   0, 103,   0,   0, 
      4, 242,  32,  16,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0, 101,   0,   0,   3,  50, 
     32,  16,   0,   1,   0,   0, 
      0, 101,   0,   0,   3, 194, 
     32,  16,   0,   1,   0,   0, 
      0,  50,   0,   0,  11,  50, 
     32,  16,   0,   0,   0,   0, 
      0,  70,  16,  16,   0,   0, 
      0,   0,   0, 230, 138,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  70, 128,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      8, 194,  32,  16,   0,   0, 
      0,   0,   0,   2,  64,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 128,  63,  50, 
      0,   0,  11,  50,  32,  16, 
      0,   1,   0,   0,   0,  70, 
     16,  16,   0,   0,   0,   0, 
      0, 230, 138,  32,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,  70, 128,  32,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,  50,   0,   0,  11, 194, 
     32,  16,   0,   1,   0,   0, 
      0,   6,  20,  16,   0,   0, 
      0,   0,   0, 166, 142,  32, 
      0,   0,   0,   0,   0,   2, 
      0,   0,   0,   6, 132,  32, 
      0,   0,   0,   0,   0,   2, 
      0,   0,   0,  62,   0,   0, 
      1,  83,  84,  65,  84, 116, 
      0,   0,   0,   5,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  82, 
     68,  69,  70,  40,   1,   0, 
      0,   1,   0,   0,   0,  64, 
      0,   0,   0,   1,   0,   0, 
      0,  28,   0,   0,   0,   0, 
      4, 254, 255,   0,   1,   0, 
      0, 246,   0,   0,   0,  60, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,  99,  98,  48,   0,  60, 
      0,   0,   0,   4,   0,   0, 
      0,  88,   0,   0,   0,  64, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 184, 
      0,   0,   0,   0,   0,   0, 
      0,  16,   0,   0,   0,   2, 
      0,   0,   0, 196,   0,   0, 
      0,   0,   0,   0,   0, 212, 
      0,   0,   0,  16,   0,   0, 
      0,  16,   0,   0,   0,   2, 
      0,   0,   0, 196,   0,   0, 
      0,   0,   0,   0,   0, 222, 
      0,   0,   0,  32,   0,   0, 
      0,  16,   0,   0,   0,   2, 
      0,   0,   0, 196,   0,   0, 
      0,   0,   0,   0,   0, 236, 
      0,   0,   0,  48,   0,   0, 
      0,  16,   0,   0,   0,   0, 
      0,   0,   0, 196,   0,   0, 
      0,   0,   0,   0,   0,  81, 
    117,  97, 100,  68, 101, 115, 
     99,   0, 171, 171, 171,   1, 
      0,   3,   0,   1,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  84, 101, 120, 
     67, 111, 111, 114, 100, 115, 
      0,  77,  97, 115, 107,  84, 
    101, 120,  67, 111, 111, 114, 
    100, 115,   0,  84, 101, 120, 
    116,  67, 111, 108, 111, 114, 
      0,  77, 105,  99, 114, 111, 
    115, 111, 102, 116,  32,  40, 
     82,  41,  32,  72,  76,  83, 
     76,  32,  83, 104,  97, 100, 
    101, 114,  32,  67, 111, 109, 
    112, 105, 108, 101, 114,  32, 
     57,  46,  50,  57,  46,  57, 
     53,  50,  46,  51,  49,  49, 
     49,   0, 171,  73,  83,  71, 
     78,  44,   0,   0,   0,   1, 
      0,   0,   0,   8,   0,   0, 
      0,  32,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   7,   3,   0, 
      0,  80,  79,  83,  73,  84, 
     73,  79,  78,   0, 171, 171, 
    171,  79,  83,  71,  78, 104, 
      0,   0,   0,   3,   0,   0, 
      0,   8,   0,   0,   0,  80, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  15,   0,   0,   0,  92, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,   3,  12,   0,   0,  92, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,  12,   3,   0,   0,  83, 
     86,  95,  80, 111, 115, 105, 
    116, 105, 111, 110,   0,  84, 
     69,  88,  67,  79,  79,  82, 
     68,   0, 171, 171, 171,  89, 
    161,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,  76,   4,   0,   0,  68, 
     88,  66,  67, 126,  10, 214, 
     10, 153,   0, 166,  80, 219, 
     54, 158, 130, 209,  70,  79, 
    109,   1,   0,   0,   0,  76, 
      4,   0,   0,   6,   0,   0, 
      0,  56,   0,   0,   0, 204, 
      0,   0,   0, 148,   1,   0, 
      0,  16,   2,   0,   0, 144, 
      3,   0,   0,   0,   4,   0, 
      0,  65, 111, 110,  57, 140, 
      0,   0,   0, 140,   0,   0, 
      0,   0,   2, 255, 255,  88, 
      0,   0,   0,  52,   0,   0, 
      0,   1,   0,  40,   0,   0, 
      0,  52,   0,   0,   0,  52, 
      0,   1,   0,  36,   0,   0, 
      0,  52,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   2, 255, 255,  31, 
      0,   0,   2,   0,   0,   0, 
    128,   0,   0,  15, 176,  31, 
      0,   0,   2,   0,   0,   0, 
    144,   0,   8,  15, 160,   1, 
      0,   0,   2,   0,   8,  15, 
    128,   0,   0, 228, 160,  66, 
      0,   0,   3,   0,   0,  15, 
    128,   0,   0, 228, 176,   0, 
      8, 228, 160,   5,   0,   0, 
      3,   0,   0,  15, 128,   0, 
      0,  70, 128,   0,   0, 255, 
    160,   1,   0,   0,   2,   1, 
      8,  15, 128,   0,   0, 228, 
    128, 255, 255,   0,   0,  83, 
     72,  68,  82, 192,   0,   0, 
      0,  64,   0,   0,   0,  48, 
      0,   0,   0,  89,   0,   0, 
      4,  70, 142,  32,   0,   0, 
      0,   0,   0,   4,   0,   0, 
      0,  90,   0,   0,   3,   0, 
     96,  16,   0,   0,   0,   0, 
      0,  88,  24,   0,   4,   0, 
    112,  16,   0,   0,   0,   0, 
      0,  85,  85,   0,   0,  98, 
     16,   0,   3,  50,  16,  16, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3, 242,  32,  16, 
      0,   0,   0,   0,   0, 101, 
      0,   0,   3, 242,  32,  16, 
      0,   1,   0,   0,   0, 104, 
      0,   0,   2,   1,   0,   0, 
      0,  54,   0,   0,   6, 242, 
     32,  16,   0,   0,   0,   0, 
      0,  70, 142,  32,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,  69,   0,   0,   9, 242, 
      0,  16,   0,   0,   0,   0, 
      0,  70,  16,  16,   0,   1, 
      0,   0,   0,  70, 126,  16, 
      0,   0,   0,   0,   0,   0, 
     96,  16,   0,   0,   0,   0, 
      0,  56,   0,   0,   8, 242, 
     32,  16,   0,   1,   0,   0, 
      0, 102,   4,  16,   0,   0, 
      0,   0,   0, 246, 143,  32, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,  62,   0,   0, 
      1,  83,  84,  65,  84, 116, 
      0,   0,   0,   4,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  82, 
     68,  69,  70, 120,   1,   0, 
      0,   1,   0,   0,   0, 144, 
      0,   0,   0,   3,   0,   0, 
      0,  28,   0,   0,   0,   0, 
      4, 255, 255,   0,   1,   0, 
      0,  70,   1,   0,   0, 124, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0, 133,   0,   0,   0,   2, 
      0,   0,   0,   5,   0,   0, 
      0,   4,   0,   0,   0, 255, 
    255, 255, 255,   0,   0,   0, 
      0,   1,   0,   0,   0,  12, 
      0,   0,   0, 137,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0, 115, 
     83,  97, 109, 112, 108, 101, 
    114,   0, 116, 101, 120,   0, 
     99,  98,  48,   0, 171, 171, 
    171, 137,   0,   0,   0,   4, 
      0,   0,   0, 168,   0,   0, 
      0,  64,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   8,   1,   0,   0,   0, 
      0,   0,   0,  16,   0,   0, 
      0,   0,   0,   0,   0,  20, 
      1,   0,   0,   0,   0,   0, 
      0,  36,   1,   0,   0,  16, 
      0,   0,   0,  16,   0,   0, 
      0,   0,   0,   0,   0,  20, 
      1,   0,   0,   0,   0,   0, 
      0,  46,   1,   0,   0,  32, 
      0,   0,   0,  16,   0,   0, 
      0,   0,   0,   0,   0,  20, 
      1,   0,   0,   0,   0,   0, 
      0,  60,   1,   0,   0,  48, 
      0,   0,   0,  16,   0,   0, 
      0,   2,   0,   0,   0,  20, 
      1,   0,   0,   0,   0,   0, 
      0,  81, 117,  97, 100,  68, 
    101, 115,  99,   0, 171, 171, 
    171,   1,   0,   3,   0,   1, 
      0,   4,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  84, 
    101, 120,  67, 111, 111, 114, 
    100, 115,   0,  77,  97, 115, 
    107,  84, 101, 120,  67, 111, 
    111, 114, 100, 115,   0,  84, 
    101, 120, 116,  67, 111, 108, 
    111, 114,   0,  77, 105,  99, 
    114, 111, 115, 111, 102, 116, 
     32,  40,  82,  41,  32,  72, 
     76,  83,  76,  32,  83, 104, 
     97, 100, 101, 114,  32,  67, 
    111, 109, 112, 105, 108, 101, 
    114,  32,  57,  46,  50,  57, 
     46,  57,  53,  50,  46,  51, 
     49,  49,  49,   0, 171,  73, 
     83,  71,  78, 104,   0,   0, 
      0,   3,   0,   0,   0,   8, 
      0,   0,   0,  80,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  15, 
      0,   0,   0,  92,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      3,   0,   0,  92,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,  12, 
      0,   0,   0,  83,  86,  95, 
     80, 111, 115, 105, 116, 105, 
    111, 110,   0,  84,  69,  88, 
     67,  79,  79,  82,  68,   0, 
    171, 171, 171,  79,  83,  71, 
     78,  68,   0,   0,   0,   2, 
      0,   0,   0,   8,   0,   0, 
      0,  56,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,  15,   0,   0, 
      0,  56,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   1, 
      0,   0,   0,  15,   0,   0, 
      0,  83,  86,  95,  84,  97, 
    114, 103, 101, 116,   0, 171, 
    171, 181, 165,   0,   0,   0, 
      0,   0,   0,  77,  97, 115, 
    107, 101, 100,   0,   4,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
    255, 255, 255, 255,  68,   4, 
      0,   0,  68,  88,  66,  67, 
     26, 214, 157, 140, 185,  91, 
    182, 211, 177, 171, 114, 225, 
    174, 107,  56, 117,   1,   0, 
      0,   0,  68,   4,   0,   0, 
      6,   0,   0,   0,  56,   0, 
      0,   0, 248,   0,   0,   0, 
    244,   1,   0,   0, 112,   2, 
      0,   0, 160,   3,   0,   0, 
    212,   3,   0,   0,  65, 111, 
    110,  57, 184,   0,   0,   0, 
    184,   0,   0,   0,   0,   2, 
    254, 255, 132,   0,   0,   0, 
     52,   0,   0,   0,   1,   0, 
     36,   0,   0,   0,  48,   0, 
      0,   0,  48,   0,   0,   0, 
     36,   0,   1,   0,  48,   0, 
      0,   0,   0,   0,   3,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   2, 
    254, 255,  81,   0,   0,   5, 
      4,   0,  15, 160,   0,   0, 
      0,   0,   0,   0, 128,  63, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  31,   0,   0,   2, 
      5,   0,   0, 128,   0,   0, 
     15, 144,   4,   0,   0,   4, 
      0,   0,   3, 224,   0,   0, 
    228, 144,   2,   0, 238, 160, 
      2,   0, 228, 160,   4,   0, 
      0,   4,   0,   0,  12, 224, 
      0,   0,  20, 144,   3,   0, 
    180, 160,   3,   0,  20, 160, 
      4,   0,   0,   4,   0,   0, 
      3, 128,   0,   0, 228, 144, 
      1,   0, 238, 160,   1,   0, 
    228, 160,   2,   0,   0,   3, 
      0,   0,   3, 192,   0,   0, 
    228, 128,   0,   0, 228, 160, 
      1,   0,   0,   2,   0,   0, 
     12, 192,   4,   0,  68, 160, 
    255, 255,   0,   0,  83,  72, 
     68,  82, 244,   0,   0,   0, 
     64,   0,   1,   0,  61,   0, 
      0,   0,  89,   0,   0,   4, 
     70, 142,  32,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
     95,   0,   0,   3,  50,  16, 
     16,   0,   0,   0,   0,   0, 
    103,   0,   0,   4, 242,  32, 
     16,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3,  50,  32,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 194,  32,  16,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  11,  50,  32,  16,   0, 
      0,   0,   0,   0,  70,  16, 
     16,   0,   0,   0,   0,   0, 
    230, 138,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     70, 128,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     54,   0,   0,   8, 194,  32, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    128,  63,  50,   0,   0,  11, 
     50,  32,  16,   0,   1,   0, 
      0,   0,  70,  16,  16,   0, 
      0,   0,   0,   0, 230, 138, 
     32,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  70, 128, 
     32,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  11, 194,  32,  16,   0, 
      1,   0,   0,   0,   6,  20, 
     16,   0,   0,   0,   0,   0, 
    166, 142,  32,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
      6, 132,  32,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
     62,   0,   0,   1,  83,  84, 
     65,  84, 116,   0,   0,   0, 
      5,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  82,  68,  69,  70, 
     40,   1,   0,   0,   1,   0, 
      0,   0,  64,   0,   0,   0, 
      1,   0,   0,   0,  28,   0, 
      0,   0,   0,   4, 254, 255, 
      0,   1,   0,   0, 246,   0, 
      0,   0,  60,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,  99,  98, 
     48,   0,  60,   0,   0,   0, 
      4,   0,   0,   0,  88,   0, 
      0,   0,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 184,   0,   0,   0, 
      0,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0, 212,   0,   0,   0, 
     16,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0, 222,   0,   0,   0, 
     32,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0, 236,   0,   0,   0, 
     48,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0,  81, 117,  97, 100, 
     68, 101, 115,  99,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  77,  97, 
    115, 107,  84, 101, 120,  67, 
    111, 111, 114, 100, 115,   0, 
     84, 101, 120, 116,  67, 111, 
    108, 111, 114,   0,  77, 105, 
     99, 114, 111, 115, 111, 102, 
    116,  32,  40,  82,  41,  32, 
     72,  76,  83,  76,  32,  83, 
    104,  97, 100, 101, 114,  32, 
     67, 111, 109, 112, 105, 108, 
    101, 114,  32,  57,  46,  50, 
     57,  46,  57,  53,  50,  46, 
     51,  49,  49,  49,   0, 171, 
     73,  83,  71,  78,  44,   0, 
      0,   0,   1,   0,   0,   0, 
      8,   0,   0,   0,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   3,   0,   0,  80,  79, 
     83,  73,  84,  73,  79,  78, 
      0, 171, 171, 171,  79,  83, 
     71,  78, 104,   0,   0,   0, 
      3,   0,   0,   0,   8,   0, 
      0,   0,  80,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   3,  12, 
      0,   0,  92,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,  12,   3, 
      0,   0,  83,  86,  95,  80, 
    111, 115, 105, 116, 105, 111, 
    110,   0,  84,  69,  88,  67, 
     79,  79,  82,  68,   0, 171, 
    171, 171,  68, 170,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,  88,   5, 
      0,   0,  68,  88,  66,  67, 
     80,  96, 162, 163, 102, 118, 
     55,  76, 239,  60, 125, 214, 
      9,   4,   5, 138,   1,   0, 
      0,   0,  88,   5,   0,   0, 
      6,   0,   0,   0,  56,   0, 
      0,   0,  24,   1,   0,   0, 
     80,   2,   0,   0, 204,   2, 
      0,   0, 156,   4,   0,   0, 
     12,   5,   0,   0,  65, 111, 
    110,  57, 216,   0,   0,   0, 
    216,   0,   0,   0,   0,   2, 
    255, 255, 160,   0,   0,   0, 
     56,   0,   0,   0,   1,   0, 
     44,   0,   0,   0,  56,   0, 
      0,   0,  56,   0,   2,   0, 
     36,   0,   0,   0,  56,   0, 
      0,   0,   0,   0,   1,   1, 
      1,   0,   0,   0,   3,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   1,   2, 255, 255, 
     31,   0,   0,   2,   0,   0, 
      0, 128,   0,   0,  15, 176, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   0,   8,  15, 160, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   1,   8,  15, 160, 
      1,   0,   0,   2,   0,   0, 
      3, 128,   0,   0, 235, 176, 
     66,   0,   0,   3,   1,   0, 
     15, 128,   0,   0, 228, 176, 
      0,   8, 228, 160,  66,   0, 
      0,   3,   0,   0,  15, 128, 
      0,   0, 228, 128,   1,   8, 
    228, 160,   5,   0,   0,   3, 
      2,   0,  15, 128,   0,   0, 
    255, 128,   0,   0, 228, 160, 
      1,   0,   0,   2,   0,   8, 
     15, 128,   2,   0, 228, 128, 
      5,   0,   0,   3,   1,   0, 
     15, 128,   1,   0,  70, 128, 
      0,   0, 255, 160,   5,   0, 
      0,   3,   0,   0,  15, 128, 
      0,   0, 255, 128,   1,   0, 
    228, 128,   1,   0,   0,   2, 
      1,   8,  15, 128,   0,   0, 
    228, 128, 255, 255,   0,   0, 
     83,  72,  68,  82,  48,   1, 
      0,   0,  64,   0,   0,   0, 
     76,   0,   0,   0,  89,   0, 
      0,   4,  70, 142,  32,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  88,  24,   0,   4, 
      0, 112,  16,   0,   0,   0, 
      0,   0,  85,  85,   0,   0, 
     88,  24,   0,   4,   0, 112, 
     16,   0,   1,   0,   0,   0, 
     85,  85,   0,   0,  98,  16, 
      0,   3,  50,  16,  16,   0, 
      1,   0,   0,   0,  98,  16, 
      0,   3, 194,  16,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 242,  32,  16,   0, 
      0,   0,   0,   0, 101,   0, 
      0,   3, 242,  32,  16,   0, 
      1,   0,   0,   0, 104,   0, 
      0,   2,   2,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   0,   0,   0,   0, 
    230,  26,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      1,   0,   0,   0,   0,  96, 
     16,   0,   1,   0,   0,   0, 
     56,   0,   0,   8, 242,  32, 
     16,   0,   0,   0,   0,   0, 
    246,  15,  16,   0,   0,   0, 
      0,   0,  70, 142,  32,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   1,   0, 
      0,   0,  70,  16,  16,   0, 
      1,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  56,   0,   0,   8, 
    242,   0,  16,   0,   1,   0, 
      0,   0, 102,   4,  16,   0, 
      1,   0,   0,   0, 246, 143, 
     32,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,  56,   0, 
      0,   7, 242,  32,  16,   0, 
      1,   0,   0,   0, 246,  15, 
     16,   0,   0,   0,   0,   0, 
     70,  14,  16,   0,   1,   0, 
      0,   0,  62,   0,   0,   1, 
     83,  84,  65,  84, 116,   0, 
      0,   0,   6,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  82,  68, 
     69,  70, 200,   1,   0,   0, 
      1,   0,   0,   0, 224,   0, 
      0,   0,   5,   0,   0,   0, 
     28,   0,   0,   0,   0,   4, 
    255, 255,   0,   1,   0,   0, 
    150,   1,   0,   0, 188,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    197,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 210,   0,   0,   0, 
      2,   0,   0,   0,   5,   0, 
      0,   0,   4,   0,   0,   0, 
    255, 255, 255, 255,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   0,   0,   0, 214,   0, 
      0,   0,   2,   0,   0,   0, 
      5,   0,   0,   0,   4,   0, 
      0,   0, 255, 255, 255, 255, 
      1,   0,   0,   0,   1,   0, 
      0,   0,  12,   0,   0,   0, 
    219,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 115,  83,  97, 109, 
    112, 108, 101, 114,   0, 115, 
     77,  97, 115, 107,  83,  97, 
    109, 112, 108, 101, 114,   0, 
    116, 101, 120,   0, 109,  97, 
    115, 107,   0,  99,  98,  48, 
      0, 171, 219,   0,   0,   0, 
      4,   0,   0,   0, 248,   0, 
      0,   0,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  88,   1,   0,   0, 
      0,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
    100,   1,   0,   0,   0,   0, 
      0,   0, 116,   1,   0,   0, 
     16,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
    100,   1,   0,   0,   0,   0, 
      0,   0, 126,   1,   0,   0, 
     32,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
    100,   1,   0,   0,   0,   0, 
      0,   0, 140,   1,   0,   0, 
     48,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    100,   1,   0,   0,   0,   0, 
      0,   0,  81, 117,  97, 100, 
     68, 101, 115,  99,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  77,  97, 
    115, 107,  84, 101, 120,  67, 
    111, 111, 114, 100, 115,   0, 
     84, 101, 120, 116,  67, 111, 
    108, 111, 114,   0,  77, 105, 
     99, 114, 111, 115, 111, 102, 
    116,  32,  40,  82,  41,  32, 
     72,  76,  83,  76,  32,  83, 
    104,  97, 100, 101, 114,  32, 
     67, 111, 109, 112, 105, 108, 
    101, 114,  32,  57,  46,  50, 
     57,  46,  57,  53,  50,  46, 
     51,  49,  49,  49,   0, 171, 
     73,  83,  71,  78, 104,   0, 
      0,   0,   3,   0,   0,   0, 
      8,   0,   0,   0,  80,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  92,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   3,   0,   0,  92,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
     12,  12,   0,   0,  83,  86, 
     95,  80, 111, 115, 105, 116, 
    105, 111, 110,   0,  84,  69, 
     88,  67,  79,  79,  82,  68, 
      0, 171, 171, 171,  79,  83, 
     71,  78,  68,   0,   0,   0, 
      2,   0,   0,   0,   8,   0, 
      0,   0,  56,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  56,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,  15,   0, 
      0,   0,  83,  86,  95,  84, 
     97, 114, 103, 101, 116,   0, 
    171, 171, 160, 174,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,  64,   0,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0, 255, 255, 255, 255, 
      0,   0,   0,   0,  43,   0, 
      0,   0,  15,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  52,   0,   0,   0, 
     15,   0,   0,   0,   0,   0, 
      0,   0,  16,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     62,   0,   0,   0,  15,   0, 
      0,   0,   0,   0,   0,   0, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  76,   0, 
      0,   0,  15,   0,   0,   0, 
      0,   0,   0,   0,  48,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  86,   0,   0,   0, 
    160,   0,   0,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
    255, 255, 255, 255,   0,   0, 
      0,   0, 118,   0,   0,   0, 
     90,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    131,   0,   0,   0,  90,   0, 
      0,   0,   0,   0,   0,   0, 
     48,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 144,   0, 
      0,   0,  90,   0,   0,   0, 
      0,   0,   0,   0,  96,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 156,   0,   0,   0, 
     15,   0,   0,   0,   0,   0, 
      0,   0, 144,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    168,   0,   0,   0, 112,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0, 255, 255, 
    255, 255,   0,   0,   0,   0, 
    209,   0,   0,   0, 181,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  11,   1, 
      0,   0, 239,   0,   0,   0, 
      0,   0,   0,   0,  48,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  57,   1,   0,   0, 
     29,   1,   0,   0,   0,   0, 
      0,   0,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     62,   1,   0,   0, 239,   0, 
      0,   0,   0,   0,   0,   0, 
     80,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 104,   1, 
      0,   0,  76,   1,   0,   0, 
      0,   0,   0,   0,  88,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 106,   1,   0,   0, 
     76,   1,   0,   0,   0,   0, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    114,   1,   0,   0,  76,   1, 
      0,   0,   0,   0,   0,   0, 
     96,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 163,   1, 
      0,   0, 135,   1,   0,   0, 
      0,   0,   0,   0, 255, 255, 
    255, 255,   0,   0,   0,   0, 
    167,   1,   0,   0, 135,   1, 
      0,   0,   0,   0,   0,   0, 
    255, 255, 255, 255,   0,   0, 
      0,   0, 213,   1,   0,   0, 
    185,   1,   0,   0,   0,   0, 
      0,   0, 255, 255, 255, 255, 
      4,   0,   0,   0,  45,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 222,   1, 
      0,   0,  55,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0, 163,   1,   0,   0, 
     46,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    234,   1,   0,   0,  47,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 246,   1, 
      0,   0,   0,   0,   0,   0, 
      2,   2,   0,   0, 185,   1, 
      0,   0,   0,   0,   0,   0, 
    255, 255, 255, 255,   4,   0, 
      0,   0,  45,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  15,   2,   0,   0, 
     55,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
    163,   1,   0,   0,  46,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  27,   2, 
      0,   0,  47,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  39,   2,   0,   0, 
      0,   0,   0,   0,  51,   2, 
      0,   0, 185,   1,   0,   0, 
      0,   0,   0,   0, 255, 255, 
    255, 255,   4,   0,   0,   0, 
     45,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     66,   2,   0,   0,  55,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0, 163,   1, 
      0,   0,  46,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  78,   2,   0,   0, 
     47,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     90,   2,   0,   0,   0,   0, 
      0,   0, 102,   2,   0,   0, 
    185,   1,   0,   0,   0,   0, 
      0,   0, 255, 255, 255, 255, 
      4,   0,   0,   0,  45,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 115,   2, 
      0,   0,  55,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0, 167,   1,   0,   0, 
     46,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    127,   2,   0,   0,  47,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 139,   2, 
      0,   0,   0,   0,   0,   0, 
    151,   2,   0,   0, 185,   1, 
      0,   0,   0,   0,   0,   0, 
    255, 255, 255, 255,   5,   0, 
      0,   0,  45,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 166,   2,   0,   0, 
     55,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
    163,   1,   0,   0,  46,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 178,   2, 
      0,   0,  47,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 190,   2,   0,   0, 
     52,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    202,   2,   0,   0,   0,   0, 
      0,   0,  26,   3,   0,   0, 
    254,   2,   0,   0,   0,   0, 
      0,   0, 255, 255, 255, 255, 
      2,   0,   0,   0,  19,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  38,   3, 
      0,   0,  13,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  50,   3,   0,   0, 
      0,   0,   0,   0, 101,   3, 
      0,   0,  73,   3,   0,   0, 
      0,   0,   0,   0, 255, 255, 
    255, 255,   2,   0,   0,   0, 
     37,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    114,   3,   0,   0,  44,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 126,   3, 
      0,   0,   0,   0,   0,   0, 
    138,   3,   0,   0,  73,   3, 
      0,   0,   0,   0,   0,   0, 
    255, 255, 255, 255,   8,   0, 
      0,   0,  37,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 151,   3,   0,   0, 
     38,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    163,   3,   0,   0,  39,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 175,   3, 
      0,   0,  40,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 187,   3,   0,   0, 
     41,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    199,   3,   0,   0,  42,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 211,   3, 
      0,   0,  43,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 223,   3,   0,   0, 
     44,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    235,   3,   0,   0,   0,   0, 
      0,   0, 247,   3,   0,   0, 
     73,   3,   0,   0,   0,   0, 
      0,   0, 255, 255, 255, 255, 
      9,   0,   0,   0,  36,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   2,   4, 
      0,   0,  37,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  14,   4,   0,   0, 
     38,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     26,   4,   0,   0,  39,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  38,   4, 
      0,   0,  40,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  50,   4,   0,   0, 
     41,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     62,   4,   0,   0,  42,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  74,   4, 
      0,   0,  43,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  86,   4,   0,   0, 
     44,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     98,   4,   0,   0,   0,   0, 
      0,   0, 110,   4,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 124,   4,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  26,   3,   0,   0, 
      6,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
    199,   8,   0,   0,   8,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 207,   8, 
      0,   0,   7,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0, 179,  11,   0,   0, 
    187,  11,   0,   0,   6,   0, 
      0,   0,   0,   0,   0,   0, 
    208,  11,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
     26,   3,   0,   0,   6,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0,   1,  19, 
      0,   0,   8,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   9,  19,   0,   0, 
      7,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
    245,  28,   0,   0, 253,  28, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,  26,   3, 
      0,   0,   6,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0,  44,  36,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     52,  36,   0,   0,   7,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0,   0,  44, 
      0,   0,   8,  44,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  26,   3,   0,   0, 
      6,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
     61,  51,   0,   0,   8,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  69,  51, 
      0,   0,   7,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0,  53,  61,   0,   0, 
     61,  61,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
     26,   3,   0,   0,   6,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0, 112,  68, 
      0,   0,   8,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 120,  68,   0,   0, 
      7,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
     72,  76,   0,   0,  80,  76, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,  26,   3, 
      0,   0,   6,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0, 135,  83,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    143,  83,   0,   0,   7,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0, 131,  93, 
      0,   0, 139,  93,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  26,   3,   0,   0, 
      6,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
    192, 100,   0,   0,   8,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 200, 100, 
      0,   0,   7,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0, 156, 108,   0,   0, 
    164, 108,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    124,   4,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
     26,   3,   0,   0,   6,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0,   0, 113, 
      0,   0,   8,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   8, 113,   0,   0, 
      7,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
    232, 116,   0,   0, 240, 116, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0, 124,   4, 
      0,   0,   7,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,  26,   3, 
      0,   0,  10,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   8, 117,   0,   0, 
     11,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     44, 117,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0, 101,   3, 
      0,   0,   6,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0, 128, 121,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    136, 121,   0,   0,   7,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0, 128, 131, 
      0,   0, 136, 131,   0,   0, 
      7,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  26,   3,   0,   0, 
     10,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    139, 131,   0,   0,  11,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 175, 131, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0, 138,   3,   0,   0, 
      6,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
      3, 136,   0,   0,   8,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  11, 136, 
      0,   0,   7,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0, 199, 145,   0,   0, 
    207, 145,   0,   0,   7,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
     26,   3,   0,   0,  10,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 210, 145, 
      0,   0,  11,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 246, 145,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
    138,   3,   0,   0,   6,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0,  74, 150, 
      0,   0,   8,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  82, 150,   0,   0, 
      7,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
      6, 161,   0,   0,  14, 161, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,  32, 161, 
      0,   0,   7,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,  26,   3, 
      0,   0,  10,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  41, 161,   0,   0, 
     11,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     77, 161,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0, 247,   3, 
      0,   0,   6,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0, 161, 165,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    169, 165,   0,   0,   7,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0,   5, 170, 
      0,   0,  13, 170,   0,   0, 
      7,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  26,   3,   0,   0, 
     10,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     20, 170,   0,   0,  11,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  56, 170, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0, 247,   3,   0,   0, 
      6,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
    140, 174,   0,   0,   8,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 148, 174, 
      0,   0,   7,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0, 252, 179,   0,   0
};
