/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef __TX_ERROR
#define __TX_ERROR

/*
 * Error value mockup for standalone.
 * See nsError.h for details.
 */

#include "nsError.h"

#define NS_ERROR_XPATH_INVALID_ARG         NS_ERROR_INVALID_ARG

#define NS_XSLT_GET_NEW_HANDLER                        \
    NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_XSLT, 1)

#define NS_ERROR_XSLT_PARSE_FAILURE                    \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 1)

#define NS_ERROR_XPATH_PARSE_FAILURE                   \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 2)

#define NS_ERROR_XSLT_ALREADY_SET                      \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 3)

#define NS_ERROR_XSLT_EXECUTION_FAILURE                \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 4)

#define NS_ERROR_XPATH_UNKNOWN_FUNCTION                \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 5)

#define NS_ERROR_XSLT_BAD_RECURSION                    \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 6)

#define NS_ERROR_XSLT_BAD_VALUE                        \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 7)

#define NS_ERROR_XSLT_NODESET_EXPECTED                 \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 8)

#define NS_ERROR_XSLT_ABORTED                          \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 9)

#define NS_ERROR_XSLT_NETWORK_ERROR                    \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 10)

#define NS_ERROR_XSLT_WRONG_MIME_TYPE                  \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 11)

#define NS_ERROR_XSLT_LOAD_RECURSION                   \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 12)

#define NS_ERROR_XPATH_BAD_ARGUMENT_COUNT              \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 13)

#define NS_ERROR_XPATH_BAD_EXTENSION_FUNCTION          \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 14)

#define NS_ERROR_XPATH_PAREN_EXPECTED                  \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 15)

#define NS_ERROR_XPATH_INVALID_AXIS                    \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 16)

#define NS_ERROR_XPATH_NO_NODE_TYPE_TEST               \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 17)

#define NS_ERROR_XPATH_BRACKET_EXPECTED                \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 18)

#define NS_ERROR_XPATH_INVALID_VAR_NAME                \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 19)

#define NS_ERROR_XPATH_UNEXPECTED_END                  \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 20)

#define NS_ERROR_XPATH_OPERATOR_EXPECTED               \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 21)

#define NS_ERROR_XPATH_UNCLOSED_LITERAL                \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 22)

#define NS_ERROR_XPATH_BAD_COLON                       \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 23)

#define NS_ERROR_XPATH_BAD_BANG                        \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 24)

#define NS_ERROR_XPATH_ILLEGAL_CHAR                    \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 25)

#define NS_ERROR_XPATH_BINARY_EXPECTED                 \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 26)

#define NS_ERROR_XSLT_LOAD_BLOCKED_ERROR               \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 27)

#define NS_ERROR_XPATH_INVALID_EXPRESSION_EVALUATED    \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 28)

#define NS_ERROR_XPATH_UNBALANCED_CURLY_BRACE          \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 29)

#define NS_ERROR_XSLT_BAD_NODE_NAME                    \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 30)

#define NS_ERROR_XSLT_VAR_ALREADY_SET                  \
    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 31)

#endif // __TX_ERROR
