<?

	// global variable for theme selection
	global $theme;

	// theme descriptors
	DEFINE(HUMAN, 'human');
	DEFINE(TANGERINE, 'tangerine');
	DEFINE(TANGO, 'tango');

	/**
	 * Initialize the environment for theme creation.
	 */
	function initialize($themedesc) {
		// store theme description
		global $theme;
		$theme = $themedesc;
		
		// cleanup "classic" dir
		system('rm -Rf classic');
		
		// initialize debugging
		initializeDebug();
		
		// sanity check for existing theme data
		$sourcedir = '/usr/share/firefox/chrome/classic';
		if(!file_exists($sourcedir)) {
			echo "Fatal error: default theme source directory $sourcedir not found\n";
			die(1);
		}
		
		// copy original Firefox theme
		system("cp -R $sourcedir .");

		// remove skin/classic tree
		system('mv -f classic/skin/classic/* classic');
		system('rm -Rf classic/skin');
	}

	/**
	 * Create JAR file and finish theme creation.
	 */
	function finish() {
		// global theme selection
		global $theme;		
		
		// copy theme icon
		$icon = getPngFilenameFor(PLACES, 'start-here', 32);
		copy($icon, 'classic/icon.png');
		
		// copy RDF descriptions
		copy(
			"custom/$theme/contents.rdf",
			'classic/contents.rdf');
		copy(
			"custom/$theme/browsercontents.rdf",
			'classic/browser/contents.rdf');
			
		// process install RDF to include version number
		system(
			'sed "s/VERSION/`cat VERSION`/g" custom/'.$theme.
			'/install.rdf > classic/install.rdf');
	
		// create jarfile
		system("cd classic ; jar cvf $theme.jar . ; cd ..");
		system("mv -f classic/$theme.jar .");
		system('rm -Rf classic');
		
		// end debug
		finishDebug();
	}

?>