/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Tue Mar  7 10:57:26 EST 2006 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -n 8 -dit -name hf_8 -include hf.h */

/*
 * This function contains 66 FP additions, 36 FP multiplications,
 * (or, 44 additions, 14 multiplications, 22 fused multiply/add),
 * 61 stack variables, and 32 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hf.h"

static const R *hf_8(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 14, MAKE_VOLATILE_STRIDE(ios)) {
	  E T1g, T1f, T1e, Tm, T1q, T1o, T1p, TN, T1h, T1i;
	  {
	       E T1, T1m, TS, Tk, TQ, Te, T1l, T7, To, Tr, T17, TM, T12, Tu, TW;
	       E Tp, Tx, Tt, Tq, Tw;
	       {
		    E Tg, Tj, Tf, Ti;
		    T1 = rio[0];
		    T1m = iio[-WS(ios, 7)];
		    Tg = rio[WS(ios, 6)];
		    Tj = iio[-WS(ios, 1)];
		    Tf = W[10];
		    Ti = W[11];
		    {
			 E T3, T6, T2, T5;
			 {
			      E Ta, Td, Tc, TP, Tb, TR, Th, T9;
			      Ta = rio[WS(ios, 2)];
			      Td = iio[-WS(ios, 5)];
			      TR = Tf * Tj;
			      Th = Tf * Tg;
			      T9 = W[2];
			      Tc = W[3];
			      TS = FNMS(Ti, Tg, TR);
			      Tk = FMA(Ti, Tj, Th);
			      TP = T9 * Td;
			      Tb = T9 * Ta;
			      T3 = rio[WS(ios, 4)];
			      T6 = iio[-WS(ios, 3)];
			      TQ = FNMS(Tc, Ta, TP);
			      Te = FMA(Tc, Td, Tb);
			      T2 = W[6];
			      T5 = W[7];
			 }
			 {
			      E TB, TE, TH, T13, TC, TK, TG, TD, TJ, T1k, T4, TA, Tn;
			      TB = rio[WS(ios, 7)];
			      TE = iio[0];
			      T1k = T2 * T6;
			      T4 = T2 * T3;
			      TA = W[12];
			      TH = rio[WS(ios, 3)];
			      T1l = FNMS(T5, T3, T1k);
			      T7 = FMA(T5, T6, T4);
			      T13 = TA * TE;
			      TC = TA * TB;
			      TK = iio[-WS(ios, 4)];
			      TG = W[4];
			      TD = W[13];
			      TJ = W[5];
			      {
				   E T14, TF, T16, TL, T15, TI;
				   To = rio[WS(ios, 1)];
				   T15 = TG * TK;
				   TI = TG * TH;
				   T14 = FNMS(TD, TB, T13);
				   TF = FMA(TD, TE, TC);
				   T16 = FNMS(TJ, TH, T15);
				   TL = FMA(TJ, TK, TI);
				   Tr = iio[-WS(ios, 6)];
				   Tn = W[0];
				   T17 = T14 - T16;
				   T1g = T14 + T16;
				   TM = TF + TL;
				   T12 = TF - TL;
			      }
			      Tu = rio[WS(ios, 5)];
			      TW = Tn * Tr;
			      Tp = Tn * To;
			      Tx = iio[-WS(ios, 2)];
			      Tt = W[8];
			      Tq = W[1];
			      Tw = W[9];
			 }
		    }
	       }
	       {
		    E T8, T1j, T1n, Tz, T1a, TU, Tl, T1b, T1c, T1v, T1t, T1w, T19, T1u, T1d;
		    {
			 E T1r, T10, TV, T1s, T11, T18;
			 {
			      E TO, TX, Ts, TZ, Ty, TT, TY, Tv;
			      T8 = T1 + T7;
			      TO = T1 - T7;
			      TY = Tt * Tx;
			      Tv = Tt * Tu;
			      TX = FNMS(Tq, To, TW);
			      Ts = FMA(Tq, Tr, Tp);
			      TZ = FNMS(Tw, Tu, TY);
			      Ty = FMA(Tw, Tx, Tv);
			      TT = TQ - TS;
			      T1j = TQ + TS;
			      T1n = T1l + T1m;
			      T1r = T1m - T1l;
			      T10 = TX - TZ;
			      T1f = TX + TZ;
			      Tz = Ts + Ty;
			      TV = Ts - Ty;
			      T1a = TO - TT;
			      TU = TO + TT;
			      T1s = Te - Tk;
			      Tl = Te + Tk;
			 }
			 T1b = T10 - TV;
			 T11 = TV + T10;
			 T18 = T12 - T17;
			 T1c = T12 + T17;
			 T1v = T1s + T1r;
			 T1t = T1r - T1s;
			 T1w = T18 - T11;
			 T19 = T11 + T18;
		    }
		    iio[-WS(ios, 3)] = FMA(KP707106781, T1w, T1v);
		    rio[WS(ios, 7)] = FMS(KP707106781, T1w, T1v);
		    rio[WS(ios, 1)] = FMA(KP707106781, T19, TU);
		    iio[-WS(ios, 5)] = FNMS(KP707106781, T19, TU);
		    T1u = T1b + T1c;
		    T1d = T1b - T1c;
		    iio[-WS(ios, 1)] = FMA(KP707106781, T1u, T1t);
		    rio[WS(ios, 5)] = FMS(KP707106781, T1u, T1t);
		    rio[WS(ios, 3)] = FMA(KP707106781, T1d, T1a);
		    iio[-WS(ios, 7)] = FNMS(KP707106781, T1d, T1a);
		    T1e = T8 - Tl;
		    Tm = T8 + Tl;
		    T1q = T1n - T1j;
		    T1o = T1j + T1n;
		    T1p = TM - Tz;
		    TN = Tz + TM;
	       }
	  }
	  iio[-WS(ios, 2)] = T1p + T1q;
	  rio[WS(ios, 6)] = T1p - T1q;
	  rio[0] = Tm + TN;
	  iio[-WS(ios, 4)] = Tm - TN;
	  T1h = T1f - T1g;
	  T1i = T1f + T1g;
	  iio[0] = T1i + T1o;
	  rio[WS(ios, 4)] = T1i - T1o;
	  rio[WS(ios, 2)] = T1e + T1h;
	  iio[-WS(ios, 6)] = T1e - T1h;
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 8},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 8, "hf_8", twinstr, &GENUS, {44, 14, 22, 0}, 0, 0, 0 };

void X(codelet_hf_8) (planner *p) {
     X(khc2hc_register) (p, hf_8, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc -compact -variables 4 -pipeline-latency 4 -n 8 -dit -name hf_8 -include hf.h */

/*
 * This function contains 66 FP additions, 32 FP multiplications,
 * (or, 52 additions, 18 multiplications, 14 fused multiply/add),
 * 28 stack variables, and 32 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hf.h"

static const R *hf_8(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 14, MAKE_VOLATILE_STRIDE(ios)) {
	  E T7, T1e, TH, T19, TF, T13, TR, TU, Ti, T1f, TK, T16, Tu, T12, TM;
	  E TP;
	  {
	       E T1, T18, T6, T17;
	       T1 = rio[0];
	       T18 = iio[-WS(ios, 7)];
	       {
		    E T3, T5, T2, T4;
		    T3 = rio[WS(ios, 4)];
		    T5 = iio[-WS(ios, 3)];
		    T2 = W[6];
		    T4 = W[7];
		    T6 = FMA(T2, T3, T4 * T5);
		    T17 = FNMS(T4, T3, T2 * T5);
	       }
	       T7 = T1 + T6;
	       T1e = T18 - T17;
	       TH = T1 - T6;
	       T19 = T17 + T18;
	  }
	  {
	       E Tz, TS, TE, TT;
	       {
		    E Tw, Ty, Tv, Tx;
		    Tw = rio[WS(ios, 7)];
		    Ty = iio[0];
		    Tv = W[12];
		    Tx = W[13];
		    Tz = FMA(Tv, Tw, Tx * Ty);
		    TS = FNMS(Tx, Tw, Tv * Ty);
	       }
	       {
		    E TB, TD, TA, TC;
		    TB = rio[WS(ios, 3)];
		    TD = iio[-WS(ios, 4)];
		    TA = W[4];
		    TC = W[5];
		    TE = FMA(TA, TB, TC * TD);
		    TT = FNMS(TC, TB, TA * TD);
	       }
	       TF = Tz + TE;
	       T13 = TS + TT;
	       TR = Tz - TE;
	       TU = TS - TT;
	  }
	  {
	       E Tc, TI, Th, TJ;
	       {
		    E T9, Tb, T8, Ta;
		    T9 = rio[WS(ios, 2)];
		    Tb = iio[-WS(ios, 5)];
		    T8 = W[2];
		    Ta = W[3];
		    Tc = FMA(T8, T9, Ta * Tb);
		    TI = FNMS(Ta, T9, T8 * Tb);
	       }
	       {
		    E Te, Tg, Td, Tf;
		    Te = rio[WS(ios, 6)];
		    Tg = iio[-WS(ios, 1)];
		    Td = W[10];
		    Tf = W[11];
		    Th = FMA(Td, Te, Tf * Tg);
		    TJ = FNMS(Tf, Te, Td * Tg);
	       }
	       Ti = Tc + Th;
	       T1f = Tc - Th;
	       TK = TI - TJ;
	       T16 = TI + TJ;
	  }
	  {
	       E To, TN, Tt, TO;
	       {
		    E Tl, Tn, Tk, Tm;
		    Tl = rio[WS(ios, 1)];
		    Tn = iio[-WS(ios, 6)];
		    Tk = W[0];
		    Tm = W[1];
		    To = FMA(Tk, Tl, Tm * Tn);
		    TN = FNMS(Tm, Tl, Tk * Tn);
	       }
	       {
		    E Tq, Ts, Tp, Tr;
		    Tq = rio[WS(ios, 5)];
		    Ts = iio[-WS(ios, 2)];
		    Tp = W[8];
		    Tr = W[9];
		    Tt = FMA(Tp, Tq, Tr * Ts);
		    TO = FNMS(Tr, Tq, Tp * Ts);
	       }
	       Tu = To + Tt;
	       T12 = TN + TO;
	       TM = To - Tt;
	       TP = TN - TO;
	  }
	  {
	       E Tj, TG, T1b, T1c;
	       Tj = T7 + Ti;
	       TG = Tu + TF;
	       iio[-WS(ios, 4)] = Tj - TG;
	       rio[0] = Tj + TG;
	       {
		    E T15, T1a, T11, T14;
		    T15 = T12 + T13;
		    T1a = T16 + T19;
		    rio[WS(ios, 4)] = T15 - T1a;
		    iio[0] = T15 + T1a;
		    T11 = T7 - Ti;
		    T14 = T12 - T13;
		    iio[-WS(ios, 6)] = T11 - T14;
		    rio[WS(ios, 2)] = T11 + T14;
	       }
	       T1b = TF - Tu;
	       T1c = T19 - T16;
	       rio[WS(ios, 6)] = T1b - T1c;
	       iio[-WS(ios, 2)] = T1b + T1c;
	       {
		    E TX, T1g, T10, T1d, TY, TZ;
		    TX = TH - TK;
		    T1g = T1e - T1f;
		    TY = TP - TM;
		    TZ = TR + TU;
		    T10 = KP707106781 * (TY - TZ);
		    T1d = KP707106781 * (TY + TZ);
		    iio[-WS(ios, 7)] = TX - T10;
		    iio[-WS(ios, 1)] = T1d + T1g;
		    rio[WS(ios, 3)] = TX + T10;
		    rio[WS(ios, 5)] = T1d - T1g;
	       }
	       {
		    E TL, T1i, TW, T1h, TQ, TV;
		    TL = TH + TK;
		    T1i = T1f + T1e;
		    TQ = TM + TP;
		    TV = TR - TU;
		    TW = KP707106781 * (TQ + TV);
		    T1h = KP707106781 * (TV - TQ);
		    iio[-WS(ios, 5)] = TL - TW;
		    iio[-WS(ios, 3)] = T1h + T1i;
		    rio[WS(ios, 1)] = TL + TW;
		    rio[WS(ios, 7)] = T1h - T1i;
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 8},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 8, "hf_8", twinstr, &GENUS, {52, 18, 14, 0}, 0, 0, 0 };

void X(codelet_hf_8) (planner *p) {
     X(khc2hc_register) (p, hf_8, &desc);
}
#endif				/* HAVE_FMA */
