/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Tue Mar  7 11:38:44 EST 2006 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -n 15 -dif -name hb_15 -include hb.h */

/*
 * This function contains 184 FP additions, 140 FP multiplications,
 * (or, 72 additions, 28 multiplications, 112 fused multiply/add),
 * 108 stack variables, and 60 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hb.h"

static const R *hb_15(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DK(KP618033988, +0.618033988749894848204586834365638117720309180);
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 28, MAKE_VOLATILE_STRIDE(ios)) {
	  E T3I, T3s, T3L, T3v, T3t, T3w, T3u, T3H, T3K, T3M, T3J;
	  {
	       E T5, T11, T2f, T2U, T1C, T3f, T19, TS, T18, TH, T14, T16, Tv, Ts, T24;
	       E T3m, T27, T3n, T2m, T33, T31, T2n, T1T, T1R, T37, T3a, T3i, T3k, T21, T2g;
	       {
		    E T1, TX, T2, T3, TY, TZ;
		    T1 = rio[0];
		    TX = iio[0];
		    T2 = rio[WS(ios, 5)];
		    T3 = iio[-WS(ios, 10)];
		    TY = iio[-WS(ios, 5)];
		    TZ = rio[WS(ios, 10)];
		    {
			 E T1E, T1W, T1V, Ta, TM, T1D, T1H, T1Z, T1Y, Tf, TR, T1G, T1L, Tm, T23;
			 E T22, Tl, TB, T1K, TF, TC, TD, Tp, T1O;
			 {
			      E Tb, TQ, TN, TO, Te;
			      {
				   E T6, TI, TJ, TK, T9, Tc, Td, TL;
				   {
					E T7, T8, T1B, T4;
					T6 = rio[WS(ios, 3)];
					T1B = T2 - T3;
					T4 = T2 + T3;
					{
					     E T2e, T10, T2d, T1A;
					     T2e = TZ + TY;
					     T10 = TY - TZ;
					     T7 = iio[-WS(ios, 8)];
					     T5 = T1 + T4;
					     T2d = FNMS(KP500000000, T4, T1);
					     T11 = TX + T10;
					     T1A = FNMS(KP500000000, T10, TX);
					     T2f = FMA(KP866025403, T2e, T2d);
					     T2U = FNMS(KP866025403, T2e, T2d);
					     T1C = FNMS(KP866025403, T1B, T1A);
					     T3f = FMA(KP866025403, T1B, T1A);
					     T8 = iio[-WS(ios, 13)];
					}
					TI = iio[-WS(ios, 3)];
					TJ = rio[WS(ios, 8)];
					TK = rio[WS(ios, 13)];
					T9 = T7 + T8;
					T1E = T7 - T8;
				   }
				   Tb = iio[-WS(ios, 12)];
				   T1W = TJ - TK;
				   TL = TJ + TK;
				   T1V = FNMS(KP500000000, T9, T6);
				   Ta = T6 + T9;
				   Tc = rio[WS(ios, 2)];
				   TM = TI - TL;
				   T1D = FMA(KP500000000, TL, TI);
				   Td = rio[WS(ios, 7)];
				   TQ = rio[WS(ios, 12)];
				   TN = iio[-WS(ios, 2)];
				   TO = iio[-WS(ios, 7)];
				   Te = Tc + Td;
				   T1H = Tc - Td;
			      }
			      {
				   E Th, Tx, Ty, Tz, Tk, Ti, Tj, TP, Tn, To, TA;
				   Th = rio[WS(ios, 6)];
				   T1Z = TO - TN;
				   TP = TN + TO;
				   T1Y = FNMS(KP500000000, Te, Tb);
				   Tf = Tb + Te;
				   Ti = iio[-WS(ios, 11)];
				   TR = TP - TQ;
				   T1G = FMA(KP500000000, TP, TQ);
				   Tj = rio[WS(ios, 1)];
				   Tx = iio[-WS(ios, 6)];
				   Ty = iio[-WS(ios, 1)];
				   Tz = rio[WS(ios, 11)];
				   Tk = Ti + Tj;
				   T1L = Ti - Tj;
				   Tm = iio[-WS(ios, 9)];
				   T23 = Tz + Ty;
				   TA = Ty - Tz;
				   T22 = FNMS(KP500000000, Tk, Th);
				   Tl = Th + Tk;
				   Tn = iio[-WS(ios, 14)];
				   TB = Tx + TA;
				   T1K = FNMS(KP500000000, TA, Tx);
				   To = rio[WS(ios, 4)];
				   TF = rio[WS(ios, 9)];
				   TC = iio[-WS(ios, 4)];
				   TD = rio[WS(ios, 14)];
				   Tp = Tn + To;
				   T1O = Tn - To;
			      }
			 }
			 {
			      E Tg, T26, T25, T12, TG, T1N, Tr, TE, Tq;
			      Tg = Ta + Tf;
			      T19 = Ta - Tf;
			      T26 = TD + TC;
			      TE = TC - TD;
			      T25 = FNMS(KP500000000, Tp, Tm);
			      Tq = Tm + Tp;
			      TS = TM - TR;
			      T12 = TM + TR;
			      TG = TE - TF;
			      T1N = FMA(KP500000000, TE, TF);
			      Tr = Tl + Tq;
			      T18 = Tl - Tq;
			      {
				   E T1X, T20, T2Y, T2X, T2Z, T13, T2V, T2W;
				   T13 = TB + TG;
				   TH = TB - TG;
				   T1X = FNMS(KP866025403, T1W, T1V);
				   T2V = FMA(KP866025403, T1W, T1V);
				   T14 = T12 + T13;
				   T16 = T12 - T13;
				   T20 = FNMS(KP866025403, T1Z, T1Y);
				   T2W = FMA(KP866025403, T1Z, T1Y);
				   Tv = Tg - Tr;
				   Ts = Tg + Tr;
				   T2Y = FMA(KP866025403, T23, T22);
				   T24 = FNMS(KP866025403, T23, T22);
				   T3m = T2V - T2W;
				   T2X = T2V + T2W;
				   T2Z = FMA(KP866025403, T26, T25);
				   T27 = FNMS(KP866025403, T26, T25);
				   {
					E T35, T36, T1M, T38, T1J, T1P, T39, T1F, T1I, T30, T3g, T3h, T1Q;
					T1F = FNMS(KP866025403, T1E, T1D);
					T35 = FMA(KP866025403, T1E, T1D);
					T36 = FNMS(KP866025403, T1H, T1G);
					T1I = FMA(KP866025403, T1H, T1G);
					T3n = T2Y - T2Z;
					T30 = T2Y + T2Z;
					T1M = FNMS(KP866025403, T1L, T1K);
					T38 = FMA(KP866025403, T1L, T1K);
					T2m = T1F + T1I;
					T1J = T1F - T1I;
					T1P = FMA(KP866025403, T1O, T1N);
					T39 = FNMS(KP866025403, T1O, T1N);
					T33 = T2X - T30;
					T31 = T2X + T30;
					T2n = T1M + T1P;
					T1Q = T1M - T1P;
					T1T = T1J - T1Q;
					T1R = T1J + T1Q;
					T3g = T35 - T36;
					T37 = T35 + T36;
					T3h = T38 - T39;
					T3a = T38 + T39;
					T3i = T3g + T3h;
					T3k = T3g - T3h;
					T21 = T1X - T20;
					T2g = T1X + T20;
				   }
			      }
			 }
		    }
	       }
	       {
		    E T28, T3j, T3O, T3R, T32, T2k, T2i, T3N, T3Q, T2h;
		    rio[0] = T5 + Ts;
		    T28 = T24 - T27;
		    T2h = T24 + T27;
		    iio[-WS(ios, 14)] = T11 + T14;
		    T3j = FNMS(KP250000000, T3i, T3f);
		    T3O = T3f + T3i;
		    T3R = T2U + T31;
		    T32 = FNMS(KP250000000, T31, T2U);
		    T2k = T2g - T2h;
		    T2i = T2g + T2h;
		    T3N = W[18];
		    T3Q = W[19];
		    {
			 E T1S, T2j, T1r, T1o, T1n;
			 {
			      E T2R, T2O, T2Q, T2S, T2P, T3S, T3P, T2N;
			      T2R = T1C + T1R;
			      T1S = FNMS(KP250000000, T1R, T1C);
			      T2j = FNMS(KP250000000, T2i, T2f);
			      T2O = T2f + T2i;
			      T3S = T3N * T3R;
			      T3P = T3N * T3O;
			      T2N = W[8];
			      T2Q = W[9];
			      rio[WS(ios, 10)] = FNMS(T3Q, T3O, T3S);
			      iio[-WS(ios, 4)] = FMA(T3Q, T3R, T3P);
			      T2S = T2N * T2R;
			      T2P = T2N * T2O;
			      {
				   E T1a, T1q, TT, T1l, Tu, T17, T1p, T15;
				   T1a = FNMS(KP618033988, T19, T18);
				   T1q = FMA(KP618033988, T18, T19);
				   iio[-WS(ios, 9)] = FMA(T2Q, T2O, T2S);
				   rio[WS(ios, 5)] = FNMS(T2Q, T2R, T2P);
				   T15 = FNMS(KP250000000, T14, T11);
				   TT = FNMS(KP618033988, TS, TH);
				   T1l = FMA(KP618033988, TH, TS);
				   Tu = FNMS(KP250000000, Ts, T5);
				   T17 = FNMS(KP559016994, T16, T15);
				   T1p = FMA(KP559016994, T16, T15);
				   {
					E T1h, T1m, T1e, T1x, T1w, T1v, T1g, T1d;
					{
					     E TW, T1b, Tt, T1u, TU, T1k, Tw;
					     TW = W[23];
					     T1k = FMA(KP559016994, Tv, Tu);
					     Tw = FNMS(KP559016994, Tv, Tu);
					     T1b = FNMS(KP951056516, T1a, T17);
					     T1h = FMA(KP951056516, T1a, T17);
					     Tt = W[22];
					     T1m = FMA(KP951056516, T1l, T1k);
					     T1u = FNMS(KP951056516, T1l, T1k);
					     T1e = FNMS(KP951056516, TT, Tw);
					     TU = FMA(KP951056516, TT, Tw);
					     {
						  E T1t, TV, T1c, T1y;
						  T1x = FMA(KP951056516, T1q, T1p);
						  T1r = FNMS(KP951056516, T1q, T1p);
						  T1w = W[11];
						  T1t = W[10];
						  TV = Tt * TU;
						  T1c = TW * TU;
						  T1y = T1w * T1u;
						  T1v = T1t * T1u;
						  rio[WS(ios, 12)] = FNMS(TW, T1b, TV);
						  iio[-WS(ios, 2)] = FMA(Tt, T1b, T1c);
						  iio[-WS(ios, 8)] = FMA(T1t, T1x, T1y);
					     }
					}
					rio[WS(ios, 6)] = FNMS(T1w, T1x, T1v);
					T1g = W[5];
					T1d = W[4];
					{
					     E T1j, T1s, T1i, T1f;
					     T1o = W[17];
					     T1i = T1g * T1e;
					     T1f = T1d * T1e;
					     T1j = W[16];
					     T1s = T1o * T1m;
					     iio[-WS(ios, 11)] = FMA(T1d, T1h, T1i);
					     rio[WS(ios, 3)] = FNMS(T1g, T1h, T1f);
					     T1n = T1j * T1m;
					     iio[-WS(ios, 5)] = FMA(T1j, T1r, T1s);
					}
				   }
			      }
			 }
			 {
			      E T2F, T2s, T2A, T2v, T2t, T2w, T2u, T2x, T2C;
			      {
				   E T29, T2E, T2z, T2o, T2D, T1U;
				   T29 = FMA(KP618033988, T28, T21);
				   T2E = FNMS(KP618033988, T21, T28);
				   rio[WS(ios, 9)] = FNMS(T1o, T1r, T1n);
				   T2z = FNMS(KP618033988, T2m, T2n);
				   T2o = FMA(KP618033988, T2n, T2m);
				   T2D = FNMS(KP559016994, T1T, T1S);
				   T1U = FMA(KP559016994, T1T, T1S);
				   {
					E T1z, T2I, T2a, T2c, T2b, T2L, T2p, T2H, T2K, T2y, T2l;
					T1z = W[26];
					T2F = FNMS(KP951056516, T2E, T2D);
					T2I = FMA(KP951056516, T2E, T2D);
					T2s = FMA(KP951056516, T29, T1U);
					T2a = FNMS(KP951056516, T29, T1U);
					T2y = FNMS(KP559016994, T2k, T2j);
					T2l = FMA(KP559016994, T2k, T2j);
					T2c = W[27];
					T2b = T1z * T2a;
					T2A = FMA(KP951056516, T2z, T2y);
					T2L = FNMS(KP951056516, T2z, T2y);
					T2v = FNMS(KP951056516, T2o, T2l);
					T2p = FMA(KP951056516, T2o, T2l);
					T2H = W[14];
					T2K = W[15];
					{
					     E T2r, T2q, T2M, T2J;
					     T2r = W[20];
					     iio[0] = FMA(T2c, T2p, T2b);
					     T2q = T1z * T2p;
					     T2M = T2H * T2L;
					     T2J = T2H * T2I;
					     T2t = T2r * T2s;
					     rio[WS(ios, 14)] = FNMS(T2c, T2a, T2q);
					     rio[WS(ios, 8)] = FNMS(T2K, T2I, T2M);
					     iio[-WS(ios, 6)] = FMA(T2K, T2L, T2J);
					     T2w = T2r * T2v;
					}
					T2u = W[21];
					T2x = W[2];
					T2C = W[3];
				   }
			      }
			      {
				   E T3E, T3b, T3z, T3o, T3D, T34, T2G, T2B;
				   T3E = FNMS(KP618033988, T37, T3a);
				   T3b = FMA(KP618033988, T3a, T37);
				   rio[WS(ios, 11)] = FNMS(T2u, T2s, T2w);
				   iio[-WS(ios, 3)] = FMA(T2u, T2v, T2t);
				   T2G = T2x * T2F;
				   T2B = T2x * T2A;
				   iio[-WS(ios, 12)] = FMA(T2C, T2A, T2G);
				   rio[WS(ios, 2)] = FNMS(T2C, T2F, T2B);
				   T3z = FNMS(KP618033988, T3m, T3n);
				   T3o = FMA(KP618033988, T3n, T3m);
				   T3D = FNMS(KP559016994, T33, T32);
				   T34 = FMA(KP559016994, T33, T32);
				   {
					E T2T, T3F, T3c, T3e, T3d, T3A, T3p, T3x, T3C, T3y, T3l;
					T2T = W[0];
					T3F = FNMS(KP951056516, T3E, T3D);
					T3I = FMA(KP951056516, T3E, T3D);
					T3s = FMA(KP951056516, T3b, T34);
					T3c = FNMS(KP951056516, T3b, T34);
					T3y = FNMS(KP559016994, T3k, T3j);
					T3l = FMA(KP559016994, T3k, T3j);
					T3e = W[1];
					T3d = T2T * T3c;
					T3A = FMA(KP951056516, T3z, T3y);
					T3L = FNMS(KP951056516, T3z, T3y);
					T3v = FNMS(KP951056516, T3o, T3l);
					T3p = FMA(KP951056516, T3o, T3l);
					T3x = W[24];
					T3C = W[25];
					{
					     E T3r, T3q, T3G, T3B;
					     T3r = W[6];
					     rio[WS(ios, 1)] = FNMS(T3e, T3p, T3d);
					     T3q = T2T * T3p;
					     T3G = T3x * T3F;
					     T3B = T3x * T3A;
					     T3t = T3r * T3s;
					     iio[-WS(ios, 13)] = FMA(T3e, T3c, T3q);
					     rio[WS(ios, 13)] = FNMS(T3C, T3A, T3G);
					     iio[-WS(ios, 1)] = FMA(T3C, T3F, T3B);
					     T3w = T3r * T3v;
					}
					T3u = W[7];
					T3H = W[12];
					T3K = W[13];
				   }
			      }
			 }
		    }
	       }
	  }
	  iio[-WS(ios, 10)] = FMA(T3u, T3s, T3w);
	  rio[WS(ios, 4)] = FNMS(T3u, T3v, T3t);
	  T3M = T3H * T3L;
	  T3J = T3H * T3I;
	  iio[-WS(ios, 7)] = FMA(T3K, T3I, T3M);
	  rio[WS(ios, 7)] = FNMS(T3K, T3L, T3J);
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 15},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 15, "hb_15", twinstr, &GENUS, {72, 28, 112, 0}, 0, 0, 0 };

void X(codelet_hb_15) (planner *p) {
     X(khc2hc_register) (p, hb_15, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc -compact -variables 4 -pipeline-latency 4 -sign 1 -n 15 -dif -name hb_15 -include hb.h */

/*
 * This function contains 184 FP additions, 112 FP multiplications,
 * (or, 128 additions, 56 multiplications, 56 fused multiply/add),
 * 75 stack variables, and 60 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hb.h"

static const R *hb_15(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 28, MAKE_VOLATILE_STRIDE(ios)) {
	  E T5, T2N, TV, T25, T1v, T2o, T2W, T38, T37, T2X, T2Q, T2T, T2U, Tg, Tr;
	  E Ts, Ty, TD, TE, T2c, T2d, T2m, TJ, TO, TP, T1Y, T1Z, T20, T1e, T1j;
	  E T1p, T13, T18, T1o, T29, T2a, T2l, T21, T22, T23;
	  {
	       E T1, T1r, T4, T1u, TU, T1s, TR, T1t;
	       T1 = rio[0];
	       T1r = iio[0];
	       {
		    E T2, T3, TS, TT;
		    T2 = rio[WS(ios, 5)];
		    T3 = iio[-WS(ios, 10)];
		    T4 = T2 + T3;
		    T1u = KP866025403 * (T2 - T3);
		    TS = rio[WS(ios, 10)];
		    TT = iio[-WS(ios, 5)];
		    TU = KP866025403 * (TS + TT);
		    T1s = TS - TT;
	       }
	       T5 = T1 + T4;
	       T2N = T1r - T1s;
	       TR = FNMS(KP500000000, T4, T1);
	       TV = TR + TU;
	       T25 = TR - TU;
	       T1t = FMA(KP500000000, T1s, T1r);
	       T1v = T1t - T1u;
	       T2o = T1u + T1t;
	  }
	  {
	       E Ta, T12, Tu, Tx, T2O, T11, Tf, T14, Tz, TC, T2P, T17, Tl, T1d, TF;
	       E TI, T2R, T1c, Tq, T1i, TK, TN, T2S, T1h;
	       {
		    E T6, T7, T8, T9;
		    T6 = rio[WS(ios, 3)];
		    T7 = iio[-WS(ios, 8)];
		    T8 = iio[-WS(ios, 13)];
		    T9 = T7 + T8;
		    Ta = T6 + T9;
		    T12 = KP866025403 * (T7 - T8);
		    Tu = FNMS(KP500000000, T9, T6);
	       }
	       {
		    E TZ, Tv, Tw, T10;
		    TZ = iio[-WS(ios, 3)];
		    Tv = rio[WS(ios, 8)];
		    Tw = rio[WS(ios, 13)];
		    T10 = Tv + Tw;
		    Tx = KP866025403 * (Tv - Tw);
		    T2O = TZ - T10;
		    T11 = FMA(KP500000000, T10, TZ);
	       }
	       {
		    E Tb, Tc, Td, Te;
		    Tb = iio[-WS(ios, 12)];
		    Tc = rio[WS(ios, 2)];
		    Td = rio[WS(ios, 7)];
		    Te = Tc + Td;
		    Tf = Tb + Te;
		    T14 = KP866025403 * (Tc - Td);
		    Tz = FNMS(KP500000000, Te, Tb);
	       }
	       {
		    E T15, TA, TB, T16;
		    T15 = rio[WS(ios, 12)];
		    TA = iio[-WS(ios, 7)];
		    TB = iio[-WS(ios, 2)];
		    T16 = TB + TA;
		    TC = KP866025403 * (TA - TB);
		    T2P = T16 - T15;
		    T17 = FMA(KP500000000, T16, T15);
	       }
	       {
		    E Th, Ti, Tj, Tk;
		    Th = rio[WS(ios, 6)];
		    Ti = iio[-WS(ios, 11)];
		    Tj = rio[WS(ios, 1)];
		    Tk = Ti + Tj;
		    Tl = Th + Tk;
		    T1d = KP866025403 * (Ti - Tj);
		    TF = FNMS(KP500000000, Tk, Th);
	       }
	       {
		    E T1a, TG, TH, T1b;
		    T1a = iio[-WS(ios, 6)];
		    TG = rio[WS(ios, 11)];
		    TH = iio[-WS(ios, 1)];
		    T1b = TG - TH;
		    TI = KP866025403 * (TG + TH);
		    T2R = T1a - T1b;
		    T1c = FMA(KP500000000, T1b, T1a);
	       }
	       {
		    E Tm, Tn, To, Tp;
		    Tm = iio[-WS(ios, 9)];
		    Tn = iio[-WS(ios, 14)];
		    To = rio[WS(ios, 4)];
		    Tp = Tn + To;
		    Tq = Tm + Tp;
		    T1i = KP866025403 * (Tn - To);
		    TK = FNMS(KP500000000, Tp, Tm);
	       }
	       {
		    E T1g, TL, TM, T1f;
		    T1g = rio[WS(ios, 9)];
		    TL = rio[WS(ios, 14)];
		    TM = iio[-WS(ios, 4)];
		    T1f = TL - TM;
		    TN = KP866025403 * (TL + TM);
		    T2S = T1f + T1g;
		    T1h = FMS(KP500000000, T1f, T1g);
	       }
	       T2W = Ta - Tf;
	       T38 = T2R + T2S;
	       T37 = T2O - T2P;
	       T2X = Tl - Tq;
	       T2Q = T2O + T2P;
	       T2T = T2R - T2S;
	       T2U = T2Q + T2T;
	       Tg = Ta + Tf;
	       Tr = Tl + Tq;
	       Ts = Tg + Tr;
	       Ty = Tu - Tx;
	       TD = Tz - TC;
	       TE = Ty + TD;
	       T2c = T1d + T1c;
	       T2d = T1i + T1h;
	       T2m = T2c + T2d;
	       TJ = TF - TI;
	       TO = TK - TN;
	       TP = TJ + TO;
	       T1Y = Tu + Tx;
	       T1Z = Tz + TC;
	       T20 = T1Y + T1Z;
	       T1e = T1c - T1d;
	       T1j = T1h - T1i;
	       T1p = T1e + T1j;
	       T13 = T11 - T12;
	       T18 = T14 + T17;
	       T1o = T13 - T18;
	       T29 = T12 + T11;
	       T2a = T14 - T17;
	       T2l = T29 + T2a;
	       T21 = TF + TI;
	       T22 = TK + TN;
	       T23 = T21 + T22;
	  }
	  rio[0] = T5 + Ts;
	  {
	       E T1l, T1J, T1B, T1M, TY, T1U, T1I, T1y, T1W, T1N, T1T, T1V;
	       {
		    E T19, T1k, T1z, T1A;
		    T19 = T13 + T18;
		    T1k = T1e - T1j;
		    T1l = FMA(KP951056516, T19, KP587785252 * T1k);
		    T1J = FNMS(KP951056516, T1k, KP587785252 * T19);
		    T1z = Ty - TD;
		    T1A = TJ - TO;
		    T1B = FMA(KP951056516, T1z, KP587785252 * T1A);
		    T1M = FNMS(KP951056516, T1A, KP587785252 * T1z);
	       }
	       {
		    E TQ, TW, TX, T1q, T1w, T1x;
		    TQ = KP559016994 * (TE - TP);
		    TW = TE + TP;
		    TX = FNMS(KP250000000, TW, TV);
		    TY = TQ + TX;
		    T1U = TV + TW;
		    T1I = TX - TQ;
		    T1q = KP559016994 * (T1o - T1p);
		    T1w = T1o + T1p;
		    T1x = FNMS(KP250000000, T1w, T1v);
		    T1y = T1q + T1x;
		    T1W = T1v + T1w;
		    T1N = T1x - T1q;
	       }
	       T1T = W[8];
	       T1V = W[9];
	       rio[WS(ios, 5)] = FNMS(T1V, T1W, T1T * T1U);
	       iio[-WS(ios, 9)] = FMA(T1V, T1U, T1T * T1W);
	       {
		    E T1Q, T1S, T1P, T1R;
		    T1Q = T1I + T1J;
		    T1S = T1N - T1M;
		    T1P = W[14];
		    T1R = W[15];
		    rio[WS(ios, 8)] = FNMS(T1R, T1S, T1P * T1Q);
		    iio[-WS(ios, 6)] = FMA(T1R, T1Q, T1P * T1S);
	       }
	       {
		    E T1m, T1C, Tt, T1n;
		    T1m = TY + T1l;
		    T1C = T1y - T1B;
		    Tt = W[26];
		    T1n = W[27];
		    rio[WS(ios, 14)] = FNMS(T1n, T1C, Tt * T1m);
		    iio[0] = FMA(T1n, T1m, Tt * T1C);
	       }
	       {
		    E T1E, T1G, T1D, T1F;
		    T1E = TY - T1l;
		    T1G = T1B + T1y;
		    T1D = W[20];
		    T1F = W[21];
		    rio[WS(ios, 11)] = FNMS(T1F, T1G, T1D * T1E);
		    iio[-WS(ios, 3)] = FMA(T1F, T1E, T1D * T1G);
	       }
	       {
		    E T1K, T1O, T1H, T1L;
		    T1K = T1I - T1J;
		    T1O = T1M + T1N;
		    T1H = W[2];
		    T1L = W[3];
		    rio[WS(ios, 2)] = FNMS(T1L, T1O, T1H * T1K);
		    iio[-WS(ios, 12)] = FMA(T1L, T1K, T1H * T1O);
	       }
	  }
	  iio[-WS(ios, 14)] = T2N + T2U;
	  {
	       E T2Y, T39, T3k, T3h, T36, T3g, T31, T3l;
	       T2Y = FNMS(KP951056516, T2X, KP587785252 * T2W);
	       T39 = FNMS(KP951056516, T38, KP587785252 * T37);
	       T3k = FMA(KP951056516, T2W, KP587785252 * T2X);
	       T3h = FMA(KP951056516, T37, KP587785252 * T38);
	       {
		    E T34, T35, T2Z, T30;
		    T34 = FNMS(KP250000000, Ts, T5);
		    T35 = KP559016994 * (Tg - Tr);
		    T36 = T34 - T35;
		    T3g = T35 + T34;
		    T2Z = FNMS(KP250000000, T2U, T2N);
		    T30 = KP559016994 * (T2Q - T2T);
		    T31 = T2Z - T30;
		    T3l = T30 + T2Z;
	       }
	       {
		    E T32, T3a, T2V, T33;
		    T32 = T2Y + T31;
		    T3a = T36 - T39;
		    T2V = W[22];
		    T33 = W[23];
		    iio[-WS(ios, 2)] = FMA(T2V, T32, T33 * T3a);
		    rio[WS(ios, 12)] = FNMS(T33, T32, T2V * T3a);
	       }
	       {
		    E T3o, T3q, T3n, T3p;
		    T3o = T3l - T3k;
		    T3q = T3g + T3h;
		    T3n = W[16];
		    T3p = W[17];
		    iio[-WS(ios, 5)] = FMA(T3n, T3o, T3p * T3q);
		    rio[WS(ios, 9)] = FNMS(T3p, T3o, T3n * T3q);
	       }
	       {
		    E T3c, T3e, T3b, T3d;
		    T3c = T36 + T39;
		    T3e = T31 - T2Y;
		    T3b = W[4];
		    T3d = W[5];
		    rio[WS(ios, 3)] = FNMS(T3d, T3e, T3b * T3c);
		    iio[-WS(ios, 11)] = FMA(T3b, T3e, T3d * T3c);
	       }
	       {
		    E T3i, T3m, T3f, T3j;
		    T3i = T3g - T3h;
		    T3m = T3k + T3l;
		    T3f = W[10];
		    T3j = W[11];
		    rio[WS(ios, 6)] = FNMS(T3j, T3m, T3f * T3i);
		    iio[-WS(ios, 8)] = FMA(T3f, T3m, T3j * T3i);
	       }
	  }
	  {
	       E T2f, T2z, T2k, T2D, T28, T2K, T2y, T2r, T2M, T2C, T2J, T2L;
	       {
		    E T2b, T2e, T2i, T2j;
		    T2b = T29 - T2a;
		    T2e = T2c - T2d;
		    T2f = FMA(KP951056516, T2b, KP587785252 * T2e);
		    T2z = FNMS(KP951056516, T2e, KP587785252 * T2b);
		    T2i = T1Y - T1Z;
		    T2j = T21 - T22;
		    T2k = FMA(KP951056516, T2i, KP587785252 * T2j);
		    T2D = FNMS(KP951056516, T2j, KP587785252 * T2i);
	       }
	       {
		    E T24, T26, T27, T2n, T2p, T2q;
		    T24 = KP559016994 * (T20 - T23);
		    T26 = T20 + T23;
		    T27 = FNMS(KP250000000, T26, T25);
		    T28 = T24 + T27;
		    T2K = T25 + T26;
		    T2y = T27 - T24;
		    T2n = KP559016994 * (T2l - T2m);
		    T2p = T2l + T2m;
		    T2q = FNMS(KP250000000, T2p, T2o);
		    T2r = T2n + T2q;
		    T2M = T2o + T2p;
		    T2C = T2q - T2n;
	       }
	       T2J = W[18];
	       T2L = W[19];
	       rio[WS(ios, 10)] = FNMS(T2L, T2M, T2J * T2K);
	       iio[-WS(ios, 4)] = FMA(T2L, T2K, T2J * T2M);
	       {
		    E T2u, T2w, T2t, T2v;
		    T2u = T28 + T2f;
		    T2w = T2r - T2k;
		    T2t = W[6];
		    T2v = W[7];
		    rio[WS(ios, 4)] = FNMS(T2v, T2w, T2t * T2u);
		    iio[-WS(ios, 10)] = FMA(T2v, T2u, T2t * T2w);
	       }
	       {
		    E T2g, T2s, T1X, T2h;
		    T2g = T28 - T2f;
		    T2s = T2k + T2r;
		    T1X = W[0];
		    T2h = W[1];
		    rio[WS(ios, 1)] = FNMS(T2h, T2s, T1X * T2g);
		    iio[-WS(ios, 13)] = FMA(T2h, T2g, T1X * T2s);
	       }
	       {
		    E T2A, T2E, T2x, T2B;
		    T2A = T2y + T2z;
		    T2E = T2C - T2D;
		    T2x = W[24];
		    T2B = W[25];
		    rio[WS(ios, 13)] = FNMS(T2B, T2E, T2x * T2A);
		    iio[-WS(ios, 1)] = FMA(T2B, T2A, T2x * T2E);
	       }
	       {
		    E T2G, T2I, T2F, T2H;
		    T2G = T2y - T2z;
		    T2I = T2D + T2C;
		    T2F = W[12];
		    T2H = W[13];
		    rio[WS(ios, 7)] = FNMS(T2H, T2I, T2F * T2G);
		    iio[-WS(ios, 7)] = FMA(T2H, T2G, T2F * T2I);
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 15},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 15, "hb_15", twinstr, &GENUS, {128, 56, 56, 0}, 0, 0, 0 };

void X(codelet_hb_15) (planner *p) {
     X(khc2hc_register) (p, hb_15, &desc);
}
#endif				/* HAVE_FMA */
