/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul  5 21:45:21 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homee/stevenj/cvs/fftw3.0.1/genfft/gen_twidsq_c -simd -compact -variables 4 -n 2 -dif -name q1bv_2 -include q1b.h -sign 1 */

/*
 * This function contains 6 FP additions, 4 FP multiplications,
 * (or, 6 additions, 4 multiplications, 0 fused multiply/add),
 * 8 stack variables, and 8 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twidsq_c.ml,v 1.1 2003/03/26 12:45:03 athena Exp $
 */

#include "q1b.h"

static const R *q1bv_2(R *ri, R *ii, const R *W, stride is, stride vs, int m, int dist)
{
     int i;
     R *x;
     x = ii;
     BEGIN_SIMD();
     for (i = 0; i < m; i = i + VL, x = x + (VL * dist), W = W + (TWVL * 2)) {
	  V T1, T2, T3, T4, T5, T6;
	  T1 = LD(&(x[0]), dist, &(x[0]));
	  T2 = LD(&(x[WS(is, 1)]), dist, &(x[WS(is, 1)]));
	  T3 = BYTW(&(W[0]), VSUB(T1, T2));
	  T4 = LD(&(x[WS(vs, 1)]), dist, &(x[WS(vs, 1)]));
	  T5 = LD(&(x[WS(vs, 1) + WS(is, 1)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
	  T6 = BYTW(&(W[0]), VSUB(T4, T5));
	  ST(&(x[WS(vs, 1)]), T3, dist, &(x[WS(vs, 1)]));
	  ST(&(x[WS(vs, 1) + WS(is, 1)]), T6, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	  ST(&(x[0]), VADD(T1, T2), dist, &(x[0]));
	  ST(&(x[WS(is, 1)]), VADD(T4, T5), dist, &(x[WS(is, 1)]));
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 2, "q1bv_2", twinstr, {6, 4, 0, 0}, &GENUS, 0, 0, 0 };

void X(codelet_q1bv_2) (planner *p) {
     X(kdft_difsq_register) (p, q1bv_2, &desc);
}
