#!/usr/bin/env ruby

require File.dirname(__FILE__) + '/../spec_helper'

require 'facter'

describe "SELinux facts" do


    after do
        Facter.clear
    end

    it "should return true if SELinux enabled" do
        Facter.fact(:kernel).stubs(:value).returns("Linux")

        FileTest.stubs(:exists?).returns false
        File.stubs(:read).with("/proc/self/attr/current").returns("notkernel")

        FileTest.expects(:exists?).with("/selinux/enforce").returns true
        FileTest.expects(:exists?).with("/proc/self/attr/current").returns true
        File.expects(:read).with("/proc/self/attr/current").returns("kernel")

        Facter.fact(:selinux).value.should == "true"
    end

    it "should return true if SELinux policy enabled" do
       Facter.fact(:selinux).stubs(:value).returns("true")

       FileTest.stubs(:exists?).returns false
       File.stubs(:read).with("/selinux/enforce").returns("0")

       FileTest.expects(:exists?).with("/selinux/enforce").returns true
       File.expects(:read).with("/selinux/enforce").returns("1") 

       Facter.fact(:selinux_enforced).value.should == "true"
    end
  
    it "should return an SELinux policy version" do
       Facter.fact(:selinux).stubs(:value).returns("true")

       File.stubs(:read).with("/selinux/policyvers").returns("")

       File.expects(:read).with("/selinux/policyvers").returns("1")

       Facter.fact(:selinux_policyversion).value.should == "1"
    end
end
