/*
 *   (C) Copyright IBM Corp. 2004
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: lvm2
 * File: evms2/engine/plugins/lvm2/vgda.h
 */

/**
 * Structures used in the VGDA trees.
 **/

typedef enum {
	VALUE,
	ARRAY,
	SECTION
} kv_type_t;

typedef struct value_array_s {
	int count;
	char **strings;
	union {
		u_int32_t *u32;
		u_int64_t *u64;
	} values;
} value_array_t;

typedef struct key_value_s {
	struct key_value_s *next;
	char *key;
	union {
		char *string;
		value_array_t *array;
		struct key_value_s *section;
	} value;
	kv_type_t type;
} key_value_t;

/**
 * Various routines to convert the string in a key-value node to a
 * numerical value.
 **/

static inline u_int32_t read_int32(key_value_t *node)
{
	return (u_int32_t) strtoul(node->value.string, NULL, 0);
}

static inline u_int64_t read_int64(key_value_t *node)
{
	return (u_int64_t) strtoull(node->value.string, NULL, 0);
}

static inline key_value_t *get_section(key_value_t *node)
{
	return node->value.section;
}

#define WRITE_STRING(string, buffer, offset, size, rc)			\
	do {								\
		rc = write_vgda_string(string, buffer, offset, size);	\
		if (rc) {						\
			goto out;					\
		}							\
	} while (0);

/**
 * Routines exported from vgda.c
 **/
extern key_value_t *parse_vg_metadata(char *buffer);
extern key_value_t *find_key(key_value_t *list, char *key);
extern void delete_vgda_tree(key_value_t *tree);
extern int write_vgda_string(char *string, char **buffer,
			     unsigned long *offset, unsigned long *size);
extern int prepare_vgda_buffer(storage_container_t *container, char **buffer);

