/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __LOCAL_DSK_MGR_H__
#define __LOCAL_DSK_MGR_H__ 1

#ifndef O_DIRECT
#define O_DIRECT	0
#endif

#define BLKGETSIZE64	_IOR(0x12,114,size_t)
#define BLKSSZGET	_IO(0x12,104)
#define BLKBSZGET	_IOR(0x12,112,size_t)
#define BLKBSZSET	_IOW(0x12,113,size_t)
#define HDIO_GETGEO	0x0301
#define HDIO_GETGEO_BIG	0x0330

/* Major-numbers for devices that need special processing. */
#define FLOPPY_MAJOR	2
#define LOOP_MAJOR	7
#define MD_MAJOR	9
#define NBD_MAJOR	43
#define LVM_MAJOR	58
#define DRBD_MAJOR	147

#define NBD_DEF_SIZE_2_4	(2 * 1024 * 1024 * 2 - 2)  // 2 GB - 2 sectors
#define NBD_DEF_SIZE_2_6	0xfffff800

struct hd_geometry {
	unsigned char heads;
	unsigned char sectors;
	unsigned short cylinders;
	unsigned long start;
};

struct hd_big_geometry {
	unsigned char heads;
	unsigned char sectors;
	unsigned int cylinders;
	unsigned long start;
};

struct partition {
	unsigned char boot_ind;         /* 0x80 - active */
	unsigned char head;             /* starting head */
	unsigned char sector;           /* starting sector */
	unsigned char cyl;              /* starting cylinder */
	unsigned char sys_ind;          /* What partition type */
	unsigned char end_head;         /* end head */
	unsigned char end_sector;       /* end sector */
	unsigned char end_cyl;          /* end cylinder */
	unsigned char start4[4];        /* starting sector counting from 0 */
	unsigned char size4[4];         /* nr of sectors in partition */
};

/**
 * struct file_handle
 *
 * Structure to help keep track of how many open file-handles we
 * have, and prevent too many from being open at once.
 **/
typedef struct file_handle {
	storage_object_t *disk;
	list_element_t elem;
} file_handle_t;

/**
 * struct local_disk
 *
 * Private data for the local disk manager.
 **/
typedef struct local_disk {
	int fd;
	unsigned int flags;
	file_handle_t *file_handle;
} local_disk_t;

#define LD_FLAG_MULTIPATH	(1 << 0)
#define LD_FLAG_IDE		(1 << 1)
#define LD_FLAG_SCSI		(1 << 2)

extern engine_functions_t *EngFncs;
extern plugin_record_t    *my_plugin_record;

#endif

